/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.bgcsl.utils.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.ma.bgcsl.utils.BgCslTemplateSequenceSetHelper;
import com.kingdee.eas.ma.bgcsl.utils.MbgCslDataHelper;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionBack;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionReceive;
import com.kingdee.eas.ma.bgcsl.utils.data.UnionReport;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BizCslDataControlUtils
extends BizMbgDataControlUtils {
    private static final Logger logger = Logger.getLogger(BizCslDataControlUtils.class);
    public static final String AUDIT_UNION_UNIONID = "AUDIT_UNION_UNIONID";
    private UnionReport report = null;
    private UnionReceive receive = null;
    private UnionBack back = null;

    protected UnionReport getReport() {
        if (this.report == null) {
            this.report = new UnionReport(this);
        }
        return this.report;
    }

    protected UnionReceive getReceive() {
        if (this.receive == null) {
            this.receive = new UnionReceive(this);
        }
        return this.receive;
    }

    protected UnionBack getBack() {
        if (this.back == null) {
            this.back = new UnionBack(this);
        }
        return this.back;
    }

    protected AuditParam transReportParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = super.transReportParams(ctx, auditParams);
        param.unionId = auditParams.get(AUDIT_UNION_UNIONID);
        return param;
    }

    protected AuditParam transUnReportParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = super.transUnReportParams(ctx, auditParams);
        param.unionId = auditParams.get(AUDIT_UNION_UNIONID);
        return param;
    }

    public Map<String, Object> receive(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        return super.receive(ctx, billIds, auditParams);
    }

    public Map<String, Object> unReceive(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        return super.unReceive(ctx, billIds, auditParams);
    }

    protected AuditParam transReceiveParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = super.transReceiveParams(ctx, auditParams);
        param.unionId = auditParams.get(AUDIT_UNION_UNIONID);
        return param;
    }

    protected AuditParam transUnReceiveParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = super.transUnReceiveParams(ctx, auditParams);
        param.unionId = auditParams.get(AUDIT_UNION_UNIONID);
        return param;
    }

    public Map<String, Object> unionBack(Context ctx, List<String> billIds, Map<String, String> auditParams) throws BOSException, EASBizException {
        return super.unionBack(ctx, billIds, auditParams);
    }

    protected AuditParam transUnionBackParams(Context ctx, Map<String, String> auditParams) {
        AuditParam param = super.transUnionBackParams(ctx, auditParams);
        param.unionId = auditParams.get(AUDIT_UNION_UNIONID);
        return param;
    }

    protected List<String> filterBillIds(List<String> billIds) {
        ArrayList<String> _billIds = new ArrayList<String>();
        if (billIds == null) {
            return _billIds;
        }
        String bosType = null;
        for (String billId : billIds) {
            bosType = BOSUuid.read((String)billId).getType().toString();
            if (!"655ADD42".equals(bosType) && !"9E7BD5E2".equals(bosType)) continue;
            _billIds.add(billId);
        }
        return _billIds;
    }

    public IDimDataQuery queryData(Context ctx, Connection conn, String billId) throws Exception {
        ReportBaseInfo model = null;
        if (ctx == null || conn == null || billId == null) {
            return model;
        }
        BOSUuid uuid = BOSUuid.read((String)billId);
        String type = uuid.getType().toString();
        model = "655ADD42".equals(type) ? MbgCslDataHelper.getBgCslFormInfo(ctx, conn, billId) : ("9E7BD5E2".equals(type) ? MbgCslDataHelper.getMBgWorkPaperInfo(ctx, conn, billId) : super.queryData(ctx, conn, billId));
        return model;
    }

    protected boolean checkBillState(IDimDataQuery model, AuditParam param) {
        boolean error = true;
        if (model == null || param == null) {
            return error;
        }
        int state = model.getBizState();
        if (param.auditType == 2) {
            if (state == 2) {
                error = false;
            }
        } else if (param.auditType == 3) {
            if (state == 50) {
                error = false;
            }
        } else if (param.auditType == 4) {
            if (state == 50) {
                error = false;
            }
        } else if (param.auditType == 5) {
            if (state == 51) {
                error = false;
            }
        } else if (param.auditType == 6 && (state == 51 || state == 50)) {
            error = false;
        }
        return error;
    }

    protected void checkBgTemplateSequenceSet(Context ctx, Connection conn, List<String> billIds, Map<String, Object> result, AuditParam param) throws EASBizException, BOSException {
        BgCslTemplateSequenceSetHelper.checkBgTemplateSequenceSet(ctx, conn, billIds, result, param);
    }
}

