/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgAnalyseHelper {
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseHelper.class);
    private static final String SOURCESTR = "com.kingdee.eas.ma.budget.client.BgAnalyseResource";
    public static final String FILTERPARAM = "FILTERPARAM";
    public static final String date_pattern = "yyyy-MM-dd HH:mm:ss";
    public static final int bufferSize = 4096;

    public static String getMessage(String key) {
        if (key == null) {
            return "";
        }
        return EASResource.getString((String)SOURCESTR, (String)key);
    }

    public static void setSelectObject(KDComboBox cbo, Object anObject) {
        if (anObject == null) {
            return;
        }
        if (CoreBaseInfo.class.isInstance(anObject)) {
            CoreBaseInfo newObject = (CoreBaseInfo)anObject;
            for (int i = 0; i < cbo.getItemCount(); ++i) {
                CoreBaseInfo obj = (CoreBaseInfo)cbo.getItemAt(i);
                if (obj == null || !newObject.getId().equals((Object)obj.getId())) continue;
                cbo.setSelectedIndex(i);
                break;
            }
        } else {
            cbo.setSelectedItem(anObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Object obj) {
        byte[] objByte;
        block6: {
            if (obj == null) {
                return null;
            }
            objByte = null;
            ByteArrayOutputStream baos = null;
            ObjectOutputStream out = null;
            try {
                baos = new ByteArrayOutputStream();
                out = new ObjectOutputStream(baos);
                out.writeObject(obj);
                objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
                BgAnalyseHelper.close(out);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
                break block6;
            }
            finally {
                BgAnalyseHelper.close(out);
                BgAnalyseHelper.close(baos);
            }
            BgAnalyseHelper.close(baos);
        }
        return objByte;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getObject(byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Object obj = null;
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])data);
            bais = new ObjectInputStream(is);
            obj = bais.readObject();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                BgAnalyseHelper.close(bais);
                BgAnalyseHelper.close(is);
                throw throwable;
            }
            BgAnalyseHelper.close(bais);
            BgAnalyseHelper.close(is);
        }
        BgAnalyseHelper.close(bais);
        BgAnalyseHelper.close(is);
        return obj;
    }

    public static String encode(byte[] bytes) {
        if (bytes != null && bytes.length > 0) {
            return Base64.encodeBytes((byte[])bytes);
        }
        return null;
    }

    public static byte[] decode(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            return Base64.decode((String)str);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFormFile(String filename) {
        byte[] objBytes = null;
        File file = null;
        file = new File(filename);
        try {
            if (file.isFile()) {
                objBytes = BgAnalyseHelper.loadFormFile(file);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            file = null;
        }
        return objBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadFormFile(File file) {
        FileInputStream is;
        byte[] objBytes;
        byte[] buffer;
        block10: {
            if (file == null) {
                return null;
            }
            int bufferRead = 0;
            buffer = new byte[4096];
            objBytes = null;
            is = null;
            ByteArrayOutputStream os = null;
            try {
                is = new FileInputStream(file);
                os = new ByteArrayOutputStream();
                while ((bufferRead = ((InputStream)is).read(buffer, 0, 4096)) != -1) {
                    ((OutputStream)os).write(buffer, 0, bufferRead);
                }
                objBytes = os.toByteArray();
                if (os == null) break block10;
            }
            catch (Exception ex) {
                block11: {
                    try {
                        logger.error((Object)ex);
                        if (os == null) break block11;
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            BgAnalyseHelper.close(os);
                        }
                        if (is != null) {
                            BgAnalyseHelper.close(is);
                        }
                        buffer = null;
                        throw throwable;
                    }
                    BgAnalyseHelper.close(os);
                }
                if (is != null) {
                    BgAnalyseHelper.close(is);
                }
                buffer = null;
            }
            BgAnalyseHelper.close(os);
        }
        if (is != null) {
            BgAnalyseHelper.close(is);
        }
        buffer = null;
        return objBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToFile(String filename, Object obj) {
        boolean re;
        block6: {
            re = false;
            if (obj == null) {
                return re;
            }
            byte[] objByte = null;
            ByteArrayOutputStream baos = null;
            ObjectOutputStream out = null;
            try {
                baos = new ByteArrayOutputStream();
                out = new ObjectOutputStream(baos);
                out.writeObject(obj);
                objByte = ZipUtil.pack((ByteArrayOutputStream)baos);
                re = BgAnalyseHelper.saveToFile(filename, objByte, 4096);
                BgAnalyseHelper.close(out);
            }
            catch (IOException ex) {
                logger.error((Object)ex);
                break block6;
            }
            finally {
                BgAnalyseHelper.close(out);
                BgAnalyseHelper.close(baos);
                objByte = null;
            }
            BgAnalyseHelper.close(baos);
            objByte = null;
        }
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToFile(String filename, byte[] content, int bufferSize) {
        boolean re;
        block12: {
            byte[] buffer;
            ByteArrayInputStream is;
            File file;
            block11: {
                re = false;
                if (filename == null || content == null || content.length == 0) {
                    return re;
                }
                file = null;
                is = null;
                FileOutputStream os = null;
                int bufferRead = 0;
                buffer = new byte[bufferSize];
                try {
                    file = new File(filename);
                    if (file.isFile() || file.createNewFile()) {
                        os = new FileOutputStream(file);
                        is = new ByteArrayInputStream(content);
                        while ((bufferRead = ((InputStream)is).read(buffer, 0, bufferSize)) != -1) {
                            ((OutputStream)os).write(buffer, 0, bufferRead);
                        }
                        re = true;
                    }
                    if (os == null) break block11;
                }
                catch (IOException ex) {
                    logger.error((Object)ex);
                    break block12;
                }
                finally {
                    if (os != null) {
                        BgAnalyseHelper.close(os);
                    }
                    if (is != null) {
                        BgAnalyseHelper.close(is);
                    }
                    buffer = null;
                    file = null;
                }
                BgAnalyseHelper.close(os);
            }
            if (is != null) {
                BgAnalyseHelper.close(is);
            }
            buffer = null;
            file = null;
        }
        return re;
    }

    public static void clearAllFile(Map fileMap) {
        if (fileMap == null) {
            return;
        }
        File file = null;
        Map.Entry entry2 = null;
        Object value = null;
        for (Map.Entry entry2 : fileMap.entrySet()) {
            value = entry2.getValue();
            if (value == null || !(value instanceof String)) continue;
            file = new File(value.toString());
            BgAnalyseHelper.deleteFile(file);
            file = null;
        }
    }

    public static void deleteFile(String filename) {
        if (StringUtils.isEmpty((String)filename)) {
            return;
        }
        File file = new File(filename);
        BgAnalyseHelper.deleteFile(file);
        file = null;
    }

    public static void deleteFile(File file) {
        if (file != null && file.isFile()) {
            file.delete();
        }
    }

    private static void close(OutputStream os, InputStream is) {
        BgAnalyseHelper.close(os);
        BgAnalyseHelper.close(is);
    }

    private static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
            finally {
                os = null;
            }
        }
    }

    private static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                logger.error((Object)ex);
            }
            finally {
                is = null;
            }
        }
    }

    public static boolean exitsTmpFile(String filename) {
        File file = new File(filename);
        return file.exists() && file.isFile();
    }

    public static boolean deleteTmpFile(String filename) {
        File file = new File(filename);
        if (file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public static boolean createTmpFile(String filename, Object obj) {
        return BgAnalyseHelper.saveToFile(filename, obj);
    }

    public static String getDefaultFileName() {
        String bgAnalyseStr = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"Bg_Analysis_Form");
        bgAnalyseStr = bgAnalyseStr == null ? "Budget_Analyse_Report" : bgAnalyseStr.replace(' ', '_');
        return BgExportHelper.getDefaultDirtory() + "//" + bgAnalyseStr + ".xls";
    }

    public static String getLastBgSchemeID(Context ctx, String currentBgSchemeID, String[] orgs) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currentBgSchemeID)) {
            return currentBgSchemeID;
        }
        String sql = "select fdatefrom , fdateto from t_bg_bgscheme where fid = '" + currentBgSchemeID + "'";
        java.util.Date sDate = null;
        java.util.Date eDate = null;
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                Date tempSDate = rs.getDate("fdatefrom");
                Date tempEDate = rs.getDate("fdateto");
                sDate = new java.util.Date(tempSDate.getYear() - 1, 0, 1, 0, 0, 0);
                eDate = new java.util.Date(tempEDate.getYear() - 1, 11, 31, 23, 59, 59);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        StringBuffer sqlSB = new StringBuffer("select fid ,fname_l2, fisFormal from t_bg_bgscheme where ");
        sqlSB.append(" ( (fdateto <= to_date('" + BgAnalyseHelper.dateToStr(eDate) + "') ");
        sqlSB.append(" and fdateto >= to_date('" + BgAnalyseHelper.dateToStr(sDate) + "') ) or");
        sqlSB.append("   ( fdatefrom <= to_date('" + BgAnalyseHelper.dateToStr(eDate) + "')");
        sqlSB.append(" and fdatefrom >= to_date('" + BgAnalyseHelper.dateToStr(sDate) + "') )");
        sqlSB.append(" ) and fisFormal = 1 ");
        sqlSB.append(" and forgunitid in " + BgAnalyseHelper.constructInSqlFromStrArr(orgs));
        sqlSB.append(" order by fisformal desc,fnumber asc");
        String idList = currentBgSchemeID;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sqlSB.toString());
            while (rs.next()) {
                String id = rs.getString("fid");
                idList = idList + "," + id;
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, ex, new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return idList;
    }

    public static String dateToStr(java.util.Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(date_pattern);
        return sdf.format(date);
    }

    public static String constructInSqlFromStrArr(String[] arr) {
        StringBuffer sb = new StringBuffer();
        sb.append("('");
        int num = arr.length;
        for (int i = 0; i < num; ++i) {
            sb.append(arr[i]);
            if (i == num - 1) break;
            sb.append("','");
        }
        sb.append("')");
        return sb.toString();
    }
}

