/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgItemQueryHelper {
    private static final Logger logger = Logger.getLogger((String)BgItemQueryHelper.class.getName());

    public static Map getCombinItemIds(Context ctx, String bgTemplateId) throws BgSchemeAssignException {
        HashMap<String, Cloneable> mapReturn = new HashMap<String, Cloneable>();
        Vector<String> ids = new Vector<String>();
        LinkedHashMap<String, String> mapCombinItem = new LinkedHashMap<String, String>();
        StringBuffer sqlTem = new StringBuffer();
        sqlTem.append("select distinct b.fid,b.fkey \n");
        sqlTem.append("\t from T_BG_BgTemRefBgItemCombin a,T_BG_BgItemCombination b \n");
        sqlTem.append("\t where a.FBgItemCombinId = b.fid and a.FBgTemplateID = ? order by b.fkey asc");
        String id = null;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlTem.toString(), (Object[])new Object[]{bgTemplateId});
            while (row.next()) {
                id = row.getString(1);
                ids.add(id);
                mapCombinItem.put(id, row.getString(2).replaceAll("_", ","));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        mapReturn.put("ids", ids);
        mapReturn.put("id.to.name.map", mapCombinItem);
        return mapReturn;
    }

    public static Map getCurrencyIds(Context ctx, String bgTemplateId) throws BgSchemeAssignException {
        HashMap<String, Cloneable> mapReturn = new HashMap<String, Cloneable>();
        Vector<String> ids = new Vector<String>();
        HashMap<String, String> mapCombinItem = new HashMap<String, String>();
        StringBuffer sqlTem = new StringBuffer();
        sqlTem.append("select distinct b.fid,b.fnumber \n");
        sqlTem.append("\t from T_BG_BgTemRefCurrency a,T_BD_Currency b \n");
        sqlTem.append("\t where a.FCurrencyID = b.fid and a.FBgTemplateID = ?");
        String id = null;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlTem.toString(), (Object[])new Object[]{bgTemplateId});
            while (row.next()) {
                id = row.getString(1);
                ids.add(id);
                mapCombinItem.put(id, row.getString(2));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        mapReturn.put("ids", ids);
        mapReturn.put("id.to.name.map", mapCombinItem);
        return mapReturn;
    }

    public static Map getElementIds(Context ctx, String bgTemplateId) throws BgSchemeAssignException {
        HashMap<String, Cloneable> mapReturn = new HashMap<String, Cloneable>();
        Vector<String> ids = new Vector<String>();
        HashMap<String, String> mapCombinItem = new HashMap<String, String>();
        StringBuffer sqlTem = new StringBuffer();
        sqlTem.append("select distinct b.fid,b.fnumber \n");
        sqlTem.append("\t from T_BG_BgTemRefBgElement a,T_BG_BgElement b \n");
        sqlTem.append("\t where a.FBgElementID = b.fid and a.FBgTemplateID = ?");
        String id = null;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlTem.toString(), (Object[])new Object[]{bgTemplateId});
            while (row.next()) {
                id = row.getString(1);
                ids.add(id);
                mapCombinItem.put(id, row.getString(2));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        mapReturn.put("ids", ids);
        mapReturn.put("id.to.name.map", mapCombinItem);
        return mapReturn;
    }

    public static Map getPeriodIds(Context ctx, String bgTemplateId) throws BgSchemeAssignException {
        HashMap<String, Cloneable> mapReturn = new HashMap<String, Cloneable>();
        Vector<String> ids = new Vector<String>();
        HashMap<String, String> mapCombinItem = new HashMap<String, String>();
        StringBuffer sqlTem = new StringBuffer();
        sqlTem.append("select distinct b.fid,b.fnumber \n");
        sqlTem.append("\t from T_BG_BgTemRefBgPeriod a,T_BG_BgPeriod b \n");
        sqlTem.append("\t where a.FBgPeriodID = b.fid and a.FBgTemplateID = ?");
        String id = null;
        try {
            IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sqlTem.toString(), (Object[])new Object[]{bgTemplateId});
            while (row.next()) {
                id = row.getString(1);
                ids.add(id);
                mapCombinItem.put(id, row.getString(2));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BgSchemeAssignException(BgSchemeAssignException.DATABASE_ERROR);
        }
        mapReturn.put("ids", ids);
        mapReturn.put("id.to.name.map", mapCombinItem);
        return mapReturn;
    }
}

