/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodFactory;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.IBgPeriod;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class BgPeriodHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.BgPeriodHelper");
    public static final Calendar calendar = Calendar.getInstance();
    public static Date date = new Date();
    public static final String STRRESOURCE = "com.kingdee.eas.ma.budget.BgPeriodResource";
    public static final String SEPARATOR = ".";
    public static final String LONGSEPARATOR = "!";
    public static final int showStart = 100;
    public static final String YearCode = "Y";
    public static final int YearLevel = 1;
    public static final int showYear = 1;
    public static final String HalfYearCode = "HY";
    public static final int HalfYearLevel = 2;
    public static final int showHalfYear = 900;
    public static final String QuarterCode = "Q";
    public static final int QuarterLevel = 3;
    public static final int showQuarter = 400;
    public static final String MonthCode = "M";
    public static final int MonthLevel = 4;
    public static final int MonthShowLevel = 50;
    public static final String WeekCode = "W";
    public static final String YearWeekCode = "W";
    public static final int YearWeekLevel = 2;
    public static final int showYearWeek = 1900;
    public static final String DayCode = "D";
    public static final int DayLevel = 5;
    public static final String MonthWeekCode = "MW";
    public static final int MonthWeekLevel = 5;
    public static final int showMonthWeek = 70;
    public static final String TenDaysCode = "TD";
    public static final int TenDaysLeve = 5;
    public static final int showTenDays = 80;

    public static int getYear() {
        calendar.clear();
        calendar.setTime(new Date());
        return calendar.get(1);
    }

    public static int getQuarter() {
        return 4;
    }

    public static int getMonth() {
        return 12;
    }

    public static int getDaysOfYear(int Year) {
        if (BgPeriodHelper.isLeapYear(Year)) {
            return 366;
        }
        return 365;
    }

    public static Date getFirstDay(int Year) {
        calendar.clear();
        calendar.set(Year, 0, 1);
        return calendar.getTime();
    }

    public static Date getLastDay(int Year) {
        calendar.clear();
        calendar.set(Year, 12, 1);
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date getHalfYearFirstDay(int year, int halfYear) {
        calendar.clear();
        switch (halfYear) {
            case 1: {
                calendar.set(year, 0, 1);
                break;
            }
            case 2: {
                calendar.set(year, 6, 1);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getHalfYearLastDay(int year, int halfYear) {
        calendar.clear();
        switch (halfYear) {
            case 1: {
                calendar.set(year, 5, 30);
                break;
            }
            case 2: {
                calendar.set(year, 11, 31);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getQuarterFirstDay(int Year, int Quarter) {
        calendar.clear();
        switch (Quarter) {
            case 1: {
                calendar.set(Year, 0, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 9, 1);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getQuarterLastDay(int Year, int Quarter) {
        calendar.clear();
        switch (Quarter) {
            case 1: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 9, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 12, 1);
                break;
            }
        }
        calendar.add(6, -1);
        return calendar.getTime();
    }

    public static Date getMonthFirstDay(int Year, int Month) {
        calendar.clear();
        switch (Month) {
            case 1: {
                calendar.set(Year, 0, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 1, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 2, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 5: {
                calendar.set(Year, 4, 1);
                break;
            }
            case 6: {
                calendar.set(Year, 5, 1);
                break;
            }
            case 7: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 8: {
                calendar.set(Year, 7, 1);
                break;
            }
            case 9: {
                calendar.set(Year, 8, 1);
                break;
            }
            case 10: {
                calendar.set(Year, 9, 1);
                break;
            }
            case 11: {
                calendar.set(Year, 10, 1);
                break;
            }
            case 12: {
                calendar.set(Year, 11, 1);
                break;
            }
        }
        return calendar.getTime();
    }

    public static Date getMonthLastDay(int Year, int Month) {
        calendar.clear();
        switch (Month) {
            case 1: {
                calendar.set(Year, 1, 1);
                break;
            }
            case 2: {
                calendar.set(Year, 2, 1);
                break;
            }
            case 3: {
                calendar.set(Year, 3, 1);
                break;
            }
            case 4: {
                calendar.set(Year, 4, 1);
                break;
            }
            case 5: {
                calendar.set(Year, 5, 1);
                break;
            }
            case 6: {
                calendar.set(Year, 6, 1);
                break;
            }
            case 7: {
                calendar.set(Year, 7, 1);
                break;
            }
            case 8: {
                calendar.set(Year, 8, 1);
                break;
            }
            case 9: {
                calendar.set(Year, 9, 1);
                break;
            }
            case 10: {
                calendar.set(Year, 10, 1);
                break;
            }
            case 11: {
                calendar.set(Year, 11, 1);
                break;
            }
            case 12: {
                calendar.set(Year, 12, 1);
                break;
            }
        }
        calendar.add(6, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDayOfMonth(int Year, int Month) {
        int days = 0;
        if (Month == 1 || Month == 3 || Month == 5 || Month == 7 || Month == 8 || Month == 10 || Month == 12) {
            days = 31;
        } else if (Month == 4 || Month == 6 || Month == 9 || Month == 11) {
            days = 30;
        } else if (Month == 2) {
            days = BgPeriodHelper.isLeapYear(Year) ? 29 : 28;
        }
        return days;
    }

    public static Date getDay(int Year, int Month, int Day) {
        calendar.clear();
        calendar.set(Year, Month - 1, Day);
        return calendar.getTime();
    }

    public static Date getTenDaysFirstDay(int Year, int Month, int tenDays) {
        calendar.clear();
        if (tenDays == 1) {
            calendar.set(Year, Month - 1, 1);
        } else if (tenDays == 2) {
            calendar.set(Year, Month - 1, 11);
        } else {
            calendar.set(Year, Month - 1, 21);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getTenDaysLastDay(int Year, int Month, int tenDays) {
        calendar.clear();
        if (tenDays == 1) {
            calendar.set(Year, Month - 1, 10);
        } else if (tenDays == 2) {
            calendar.set(Year, Month - 1, 20);
        } else {
            calendar.set(Year, Month, 1);
            calendar.add(6, -1);
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static int getDayOfWeek(int Year, int Month, int Day) {
        calendar.clear();
        calendar.set(Year, Month - 1, Day);
        return calendar.get(7);
    }

    public static int getWeek(int Year, boolean isYear) {
        int Week = 53;
        Week = isYear ? BgPeriodHelper.getYearWeek(Year) : BgPeriodHelper.getMonthWeek(Year);
        return Week;
    }

    private static int getYearWeek(int Year) {
        int Week = 53;
        calendar.clear();
        Week = BgPeriodHelper.isLeapYear(Year) ? (BgPeriodHelper.getDayOfWeek(Year, 1, 1) == 7 ? 54 : 53) : 53;
        return Week;
    }

    private static int getMonthWeek(int Year) {
        int week = 0;
        for (int i = 1; i <= 12; ++i) {
            calendar.clear();
            calendar.setTime(BgPeriodHelper.getMonthLastDay(Year, i));
            week += calendar.get(4);
        }
        return week;
    }

    public static boolean isLeapYear(int Year) {
        return Year % 400 == 0 || Year % 4 == 0 && Year % 100 != 0;
    }

    public static Date getWeekFirstDay(int Year, int Week) {
        if (Week == 1) {
            return BgPeriodHelper.getFirstDay(Year);
        }
        calendar.clear();
        int days = BgPeriodHelper.getDayOfWeek(Year, 1, 1);
        calendar.set(Year, 0, 1);
        calendar.add(3, Week - 1);
        calendar.add(6, 1 - days);
        return calendar.getTime();
    }

    public static Date getWeekFirstDay(int Year, int Week, int weekFirstDay) {
        if (Week == 1) {
            return BgPeriodHelper.getFirstDay(Year);
        }
        calendar.clear();
        int days = BgPeriodHelper.getDayOfWeek(Year, 1, 1);
        calendar.set(Year, 0, 1);
        calendar.add(3, Week - 1);
        calendar.add(6, weekFirstDay - days);
        return calendar.getTime();
    }

    public static Date getWeekLastDay(int Year, int Week) {
        if (Week >= 53) {
            return BgPeriodHelper.getLastDay(Year);
        }
        calendar.clear();
        int days = BgPeriodHelper.getDayOfWeek(Year, 1, 1);
        calendar.set(Year, 0, 1);
        calendar.add(3, Week);
        calendar.add(6, -1);
        calendar.add(6, 1 - days);
        return calendar.getTime();
    }

    public static Date getWeekLastDay(int Year, int Week, int weekFirstDay) {
        if (Week >= 53) {
            return BgPeriodHelper.getLastDay(Year);
        }
        calendar.clear();
        int days = BgPeriodHelper.getDayOfWeek(Year, 1, 1);
        calendar.set(Year, 0, 1);
        calendar.add(3, Week);
        calendar.add(6, weekFirstDay - 1 - days);
        return calendar.getTime();
    }

    public static Date getMonthWeekFirstDay(int Year, int Month, int Week) {
        calendar.clear();
        calendar.setTime(BgPeriodHelper.getMonthFirstDay(Year, Month));
        int n = BgPeriodHelper.getDayOfMonth(Year, Month);
        for (int i = 1; i <= n; ++i) {
            if (calendar.get(4) == Week) {
                return calendar.getTime();
            }
            calendar.add(6, 1);
        }
        return calendar.getTime();
    }

    public static Date getMonthWeekFirstDay(int Year, int Month, int Week, int weekFirstDay) {
        calendar.clear();
        calendar.setTime(BgPeriodHelper.getMonthFirstDay(Year, Month));
        calendar.setFirstDayOfWeek(weekFirstDay);
        int n = BgPeriodHelper.getDayOfMonth(Year, Month);
        for (int i = 1; i <= n; ++i) {
            if (calendar.get(4) == Week) {
                return calendar.getTime();
            }
            calendar.add(6, 1);
        }
        date = calendar.getTime();
        calendar.setFirstDayOfWeek(1);
        return date;
    }

    public static Date getMonthWeekLastDay(int Year, int Month, int Week) {
        calendar.clear();
        calendar.setTime(BgPeriodHelper.getMonthLastDay(Year, Month));
        int n = 1;
        for (int i = BgPeriodHelper.getDayOfMonth(Year, Month); i >= n; --i) {
            if (calendar.get(4) == Week) {
                return calendar.getTime();
            }
            calendar.add(6, -1);
        }
        return calendar.getTime();
    }

    public static Date getMonthWeekLastDay(int Year, int Month, int Week, int weekFirstDay) {
        calendar.clear();
        calendar.setTime(BgPeriodHelper.getMonthLastDay(Year, Month));
        calendar.setFirstDayOfWeek(weekFirstDay);
        int n = 1;
        for (int i = BgPeriodHelper.getDayOfMonth(Year, Month); i >= n; --i) {
            if (calendar.get(4) == Week) {
                return calendar.getTime();
            }
            calendar.add(6, -1);
        }
        date = calendar.getTime();
        calendar.setFirstDayOfWeek(1);
        return date;
    }

    public static BgPeriodInfo getNextPeriodOfDate(int bgPeriodType, Date start, Date beover, Date currently) throws BOSException, EASBizException {
        int endYear;
        int beginYear;
        if (start == null || beover == null || bgPeriodType == 8) {
            return null;
        }
        CalendarHelper calendar = new CalendarHelper();
        Date _currently = currently == null ? new Date() : currently;
        int compute = calendar.computeToDate(_currently, start);
        _currently = compute == 1 ? start : _currently;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        if (bgPeriodType == 1) {
            if (compute == 1) {
                items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(_currently)), CompareType.GREATER_EQUALS));
            } else {
                items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(_currently)), CompareType.GREATER));
            }
            items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
        } else if (bgPeriodType == 2) {
            beginYear = calendar.getCurrentlyYear(_currently);
            int beginHalfYear = calendar.getCurrentlyHalfYear(_currently);
            endYear = calendar.getCurrentlyYear(beover);
            int endHalfYear = calendar.getCurrentlyHalfYear(beover);
            if (beginYear != endYear) {
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.EQUALS));
                if (compute == 1) {
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(beginHalfYear), CompareType.GREATER_EQUALS));
                } else {
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(beginHalfYear), CompareType.GREATER));
                }
                items.add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.EQUALS));
                items.add(new FilterItemInfo("halfYear", (Object)new Integer(endHalfYear), CompareType.LESS_EQUALS));
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.GREATER));
                items.add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.LESS));
                filter.setMaskString("#0 and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
            } else {
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.EQUALS));
                if (compute == 1) {
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(beginHalfYear), CompareType.GREATER_EQUALS));
                } else {
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(beginHalfYear), CompareType.GREATER));
                }
                items.add(new FilterItemInfo("halfYear", (Object)new Integer(endHalfYear), CompareType.LESS_EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else if (bgPeriodType == 3) {
            beginYear = calendar.getCurrentlyYear(_currently);
            int beginQuarter = calendar.getCurrentlyQuarter(_currently);
            endYear = calendar.getCurrentlyYear(beover);
            int endQuarter = calendar.getCurrentlyQuarter(beover);
            if (beginYear != endYear) {
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.EQUALS));
                if (compute == 1) {
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(beginQuarter), CompareType.GREATER_EQUALS));
                } else {
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(beginQuarter), CompareType.GREATER));
                }
                items.add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.EQUALS));
                items.add(new FilterItemInfo("quarter", (Object)new Integer(endQuarter), CompareType.LESS_EQUALS));
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.GREATER));
                items.add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.LESS));
                filter.setMaskString("#0 and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
            } else {
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.EQUALS));
                if (compute == 1) {
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(beginQuarter), CompareType.GREATER_EQUALS));
                } else {
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(beginQuarter), CompareType.GREATER));
                }
                items.add(new FilterItemInfo("quarter", (Object)new Integer(endQuarter), CompareType.LESS_EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else if (bgPeriodType == 4) {
            beginYear = calendar.getCurrentlyYear(_currently);
            int beginMonth = calendar.getCurrentlyMonth(_currently);
            endYear = calendar.getCurrentlyYear(beover);
            int endMonth = calendar.getCurrentlyMonth(beover);
            if (beginYear != endYear) {
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.EQUALS));
                if (compute == 1) {
                    items.add(new FilterItemInfo("month", (Object)new Integer(beginMonth), CompareType.GREATER_EQUALS));
                } else {
                    items.add(new FilterItemInfo("month", (Object)new Integer(beginMonth), CompareType.GREATER));
                }
                items.add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.EQUALS));
                items.add(new FilterItemInfo("month", (Object)new Integer(endMonth), CompareType.LESS_EQUALS));
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.GREATER));
                items.add(new FilterItemInfo("year", (Object)new Integer(endYear), CompareType.LESS));
                filter.setMaskString("#0 and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
            } else {
                items.add(new FilterItemInfo("year", (Object)new Integer(beginYear), CompareType.EQUALS));
                if (compute == 1) {
                    items.add(new FilterItemInfo("month", (Object)new Integer(beginMonth), CompareType.GREATER_EQUALS));
                } else {
                    items.add(new FilterItemInfo("month", (Object)new Integer(beginMonth), CompareType.GREATER));
                }
                items.add(new FilterItemInfo("month", (Object)new Integer(endMonth), CompareType.LESS_EQUALS));
                filter.setMaskString("#0 and #1 and #2 and #3");
            }
        } else if (bgPeriodType == 5) {
            if (compute == 1) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(_currently), CompareType.GREATER_EQUALS));
            } else {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(_currently), CompareType.GREATER));
            }
            items.add(new FilterItemInfo("endDate", (Object)calendar.getStartDate(beover), CompareType.LESS_EQUALS));
        } else if (bgPeriodType == 6) {
            if (compute == 1) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(_currently), CompareType.GREATER_EQUALS));
            } else {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(_currently), CompareType.GREATER));
            }
            items.add(new FilterItemInfo("endDate", (Object)calendar.getStartDate(beover), CompareType.LESS_EQUALS));
        } else if (bgPeriodType == 7) {
            items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(_currently), CompareType.GREATER));
            items.add(new FilterItemInfo("endDate", (Object)calendar.getStartDate(beover), CompareType.LESS_EQUALS));
        } else if (bgPeriodType == 9) {
            items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(_currently), CompareType.GREATER));
            items.add(new FilterItemInfo("endDate", (Object)calendar.getStartDate(beover), CompareType.LESS_EQUALS));
        }
        view.setFilter(filter);
        view.setTopCount(1);
        view.getSorter().add(new SorterItemInfo("longnumber"));
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static BgPeriodCollection getPeriodColInfo(int bgPeriodType, Date start, Date beover) throws BOSException, EASBizException {
        return BgPeriodHelper.getPeriodColInfo(bgPeriodType, start, beover, null);
    }

    public static BgPeriodCollection getPeriodColInfo(Context ctx, Date start, Date beover, int bgPeriodType) throws BOSException, EASBizException {
        return BgPeriodHelper.getPeriodColInfo(bgPeriodType, start, beover, ctx);
    }

    public static BgPeriodCollection getPeriodColInfo(int bgPeriodType, Date start, Date beover, Context ctx) throws BOSException, EASBizException {
        int startYear;
        CalendarHelper calendar = new CalendarHelper();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        if (bgPeriodType == 1) {
            if (start != null) {
                items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 2) {
            if (start != null && beover != null) {
                startYear = calendar.getCurrentlyYear(start);
                int startHalfYear = calendar.getCurrentlyHalfYear(start);
                int beoverYear = calendar.getCurrentlyYear(beover);
                int beoverHalfYear = calendar.getCurrentlyHalfYear(beover);
                if (startYear == beoverYear) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(startHalfYear), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(beoverHalfYear), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(startHalfYear), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(beoverHalfYear), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(calendar.getCurrentlyHalfYear(start)), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("halfYear", (Object)new Integer(calendar.getCurrentlyHalfYear(beover)), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 3) {
            if (start != null && beover != null) {
                startYear = calendar.getCurrentlyYear(start);
                int startQuarter = calendar.getCurrentlyQuarter(start);
                int beoverYear = calendar.getCurrentlyYear(beover);
                int beoverQuarter = calendar.getCurrentlyQuarter(beover);
                if (startYear == beoverYear) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(startQuarter), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(beoverQuarter), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(startQuarter), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(beoverQuarter), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(calendar.getCurrentlyQuarter(start)), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("quarter", (Object)new Integer(calendar.getCurrentlyQuarter(beover)), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 4) {
            if (start != null && beover != null) {
                startYear = calendar.getCurrentlyYear(start);
                int startMonth = calendar.getCurrentlyMonth(start);
                int beoverYear = calendar.getCurrentlyYear(beover);
                int beoverMonth = calendar.getCurrentlyMonth(beover);
                if (startYear == beoverYear) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("month", (Object)new Integer(startMonth), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("month", (Object)new Integer(beoverMonth), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("month", (Object)new Integer(startMonth), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("month", (Object)new Integer(beoverMonth), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("month", (Object)new Integer(calendar.getCurrentlyMonth(start)), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("month", (Object)new Integer(calendar.getCurrentlyMonth(beover)), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 5) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 6) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 7) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
            }
        } else if (bgPeriodType == 9) {
            if (start != null && beover != null) {
                int beoverYear;
                startYear = calendar.getCurrentlyYear(start);
                if (startYear == (beoverYear = calendar.getCurrentlyYear(beover))) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
                } else {
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.GREATER));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.LESS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(startYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("year", (Object)new Integer(beoverYear), CompareType.EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
                    filter.setMaskString("(#0) and ((#1 and #2) or (#3 and #4) or (#5 and #6))");
                }
            } else {
                if (start != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(start)), CompareType.GREATER_EQUALS));
                    items.add(new FilterItemInfo("beginDate", (Object)calendar.getStartDate(start), CompareType.GREATER_EQUALS));
                }
                if (beover != null) {
                    items.add(new FilterItemInfo("year", (Object)new Integer(calendar.getCurrentlyYear(beover)), CompareType.LESS_EQUALS));
                    items.add(new FilterItemInfo("endDate", (Object)calendar.getBeoverDate(beover), CompareType.LESS_EQUALS));
                }
            }
        } else if (bgPeriodType == 8) {
            if (start != null) {
                items.add(new FilterItemInfo("beginDate", (Object)start, CompareType.GREATER_EQUALS));
            }
            if (beover != null) {
                items.add(new FilterItemInfo("endDate", (Object)beover, CompareType.LESS_EQUALS));
            }
        }
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("longnumber"));
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = (IBgPeriod)BgPeriodHelper.getBizInterface(ctx);
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol == null) {
                bgPeriodCol = new BgPeriodCollection();
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodCol;
    }

    public static ICoreBase getBizInterface(Context ctx) throws BOSException {
        if (ctx == null) {
            return BgPeriodFactory.getRemoteInstance();
        }
        return BgPeriodFactory.getLocalInstance(ctx);
    }

    public static final BgPeriodInfo getYearOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        return BgPeriodHelper.getYearOfBgPeriodInfo(bgPeriodInfo.getNumber());
    }

    public static final BgPeriodInfo getYearOfBgPeriodInfo(String bgPeriodInfoNumber) throws EASBizException, BOSException {
        boolean isSarch = Pattern.matches("[0-9]{4}Y\\w*", bgPeriodInfoNumber.replaceAll("\\.", ""));
        if (!isSarch) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgPeriodInfoNumber.substring(0, 4 + YearCode.length()), CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getHalfYearOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        return BgPeriodHelper.getHalfYearOfBgPeriodInfo(bgPeriodInfo.getNumber());
    }

    public static final BgPeriodInfo getHalfYearOfBgPeriodInfo(String bgPeriodInfoNumber) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        boolean isSarch = Pattern.matches("[0-9]{4}Y[0-9]{2}HY\\w*", bgPeriodInfoNumber.replaceAll("\\.", ""));
        if (!isSarch) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgPeriodInfoNumber.substring(4 + YearCode.length() + 2 + HalfYearCode.length()), CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getQuarterOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        return BgPeriodHelper.getQuarterOfBgPeriodInfo(bgPeriodInfo.getNumber());
    }

    public static final BgPeriodInfo getQuarterOfBgPeriodInfo(String bgPeriodInfoNumber) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        boolean isSarch = Pattern.matches("[0-9]{4}Y[0-9]{2}Q\\w*", bgPeriodInfoNumber.replaceAll("\\.", ""));
        if (!isSarch) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgPeriodInfoNumber.substring(0, 4 + YearCode.length() + 2 + QuarterCode.length()), CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getMonthOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        return BgPeriodHelper.getMonthOfBgPeriodInfo(bgPeriodInfo.getNumber());
    }

    public static final BgPeriodInfo getMonthOfBgPeriodInfo(String bgPeriodInfoNumber) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        boolean isSarch = Pattern.matches("[0-9]{4}Y[0-9]{2}M\\w*", bgPeriodInfoNumber.replaceAll("\\.", ""));
        if (!isSarch) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)bgPeriodInfoNumber.substring(0, 4 + YearCode.length() + 2 + MonthCode.length()), CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getParentOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        return BgPeriodHelper.getParentOfBgPeriodInfo(bgPeriodInfo.getNumber());
    }

    public static final BgPeriodInfo getParentOfBgPeriodInfo(String bgPeriodInfoNumber) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.number", (Object)bgPeriodInfoNumber, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getPreYearOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo) throws EASBizException, BOSException {
        return BgPeriodHelper.getPreYearOfBgPeriodInfo(bgPeriodInfo.getNumber());
    }

    public static final BgPeriodInfo getPreYearOfBgPeriodInfo(String bgPeriodInfoNumber) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        String number = Pattern.matches("[0-9]{4}Y\\w*", bgPeriodInfoNumber.replaceAll("\\.", "")) ? bgPeriodInfoNumber.substring(0, 4) : "";
        number = String.valueOf(Integer.valueOf(number) - 1) + YearCode;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getRemoteInstance();
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final boolean hasBgPeriodInfo() throws EASBizException, BOSException {
        return true;
    }

    public static final BgPeriodInfo getYearBeginOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo, int bgPeriodType, Context ctx) throws EASBizException, BOSException {
        return BgPeriodHelper.getYearBeginOfBgPeriodInfo(bgPeriodInfo.getNumber(), bgPeriodType, ctx);
    }

    public static final BgPeriodInfo getYearBeginOfBgPeriodInfo(String bgPeriodInfoNumber, int bgPeriodType, Context ctx) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        String subNumber = null;
        String YearNumber = "";
        YearNumber = bgPeriodInfoNumber.substring(0, 5);
        if (bgPeriodType == 1) {
            subNumber = "";
        }
        if (bgPeriodType == 2) {
            subNumber = ".01HY";
        }
        if (bgPeriodType == 3) {
            subNumber = ".01Q";
        }
        if (bgPeriodType == 4) {
            subNumber = ".01M";
        }
        if (bgPeriodType == 5) {
            subNumber = ".01YW";
        }
        if (bgPeriodType == 6) {
            subNumber = ".01M.01MW";
        }
        if (bgPeriodType == 7) {
            subNumber = ".01M.01D";
        }
        String number = YearNumber + subNumber;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getPreviousYearOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo, Context ctx) throws EASBizException, BOSException {
        return BgPeriodHelper.getPreviousYearOfBgPeriodInfo(bgPeriodInfo.getNumber(), ctx);
    }

    public static final BgPeriodInfo getPreviousYearOfBgPeriodInfo(String bgPeriodInfoNumber, Context ctx) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        String subNumber = "";
        int length = bgPeriodInfoNumber.length();
        if (length > 6) {
            subNumber = bgPeriodInfoNumber.substring(5, length);
        }
        String number = Pattern.matches("[0-9]{4}Y\\w*", bgPeriodInfoNumber.replaceAll("\\.", "")) ? bgPeriodInfoNumber.substring(0, 4) : "";
        number = String.valueOf(Integer.valueOf(number) - 1) + YearCode;
        number = number + subNumber;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static final BgPeriodInfo getYearEndOfBgPeriodInfo(BgPeriodInfo bgPeriodInfo, int bgPeriodType, Context ctx) throws EASBizException, BOSException {
        return BgPeriodHelper.getYearEndOfBgPeriodInfo(bgPeriodInfo.getNumber(), bgPeriodType, ctx);
    }

    public static final BgPeriodInfo getYearEndOfBgPeriodInfo(String bgPeriodInfoNumber, int bgPeriodType, Context ctx) throws EASBizException, BOSException {
        if (bgPeriodInfoNumber == null || bgPeriodInfoNumber.trim().length() == 0) {
            return null;
        }
        String subNumber = null;
        String YearNumber = "";
        YearNumber = bgPeriodInfoNumber.substring(0, 5);
        if (bgPeriodType == 1) {
            subNumber = "";
        }
        if (bgPeriodType == 2) {
            subNumber = ".02HY";
        }
        if (bgPeriodType == 3) {
            subNumber = ".04Q";
        }
        if (bgPeriodType == 4) {
            subNumber = ".12M";
        }
        if (bgPeriodType == 5) {
            subNumber = ".53YW";
        }
        if (bgPeriodType == 6) {
            subNumber = ".12M.05MW";
        }
        if (bgPeriodType == 7) {
            subNumber = ".12M.31D";
        }
        String number = YearNumber + subNumber;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        BgPeriodInfo bgPeriodInfo = null;
        BgPeriodCollection bgPeriodCol = null;
        try {
            IBgPeriod ibgPeriod = BgPeriodFactory.getLocalInstance(ctx);
            if (ibgPeriod == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            bgPeriodCol = ibgPeriod.getBgPeriodCollection(view);
            if (bgPeriodCol != null && !bgPeriodCol.isEmpty()) {
                bgPeriodInfo = bgPeriodCol.get(0);
            }
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (BOSException ex) {
            throw ex;
        }
        return bgPeriodInfo;
    }

    public static Date getDay(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return null;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        try {
            year = new Integer(bgPeriodNumber.substring(0, 4));
            month = new Integer(bgPeriodNumber.substring(6, 8));
            day = new Integer(bgPeriodNumber.substring(10, 12));
            return BgPeriodHelper.getDay(year, month, day);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            return null;
        }
    }

    public static Date getBeginDay(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return null;
        }
        int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber);
        String[] param = bgPeriodNumber.split("\\.");
        int year = -1;
        int halfYear = -1;
        int month = -1;
        int tenDays = -1;
        int quarter = -1;
        int week = -1;
        CalendarHelper calendar = new CalendarHelper();
        try {
            switch (periodType) {
                case 1: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    return calendar.getFirstDayOfYear(year);
                }
                case 2: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    halfYear = Integer.parseInt(param[1].substring(0, 2));
                    if (halfYear == 1) {
                        return calendar.getFirstDayOfMonth(year, 1);
                    }
                    return calendar.getFirstDayOfMonth(year, 7);
                }
                case 3: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    quarter = Integer.parseInt(param[1].substring(0, 2));
                    return calendar.getFirstDayOfQuarter(year, quarter);
                }
                case 4: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    return calendar.getFirstDayOfMonth(year, month);
                }
                case 9: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    tenDays = Integer.parseInt(param[2].substring(0, 2));
                    return calendar.getFirstDayOfMonthTenDays(year, month, tenDays);
                }
                case 5: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    week = Integer.parseInt(param[1].substring(0, 2));
                    return calendar.getFirstDayOfWeek(year, week);
                }
                case 6: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    week = Integer.parseInt(param[2].substring(0, 2));
                    return calendar.getFirstDayOfWeek(year, month, week);
                }
                case 7: {
                    return BgPeriodHelper.getDay(bgPeriodNumber);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            return null;
        }
        return null;
    }

    public static Date getEndDay(String bgPeriodNumber) {
        if (bgPeriodNumber == null) {
            return null;
        }
        int periodType = BgNPeriodHelper.parserBgPeriodType((String)bgPeriodNumber);
        String[] param = bgPeriodNumber.split("\\.");
        int year = -1;
        int halfYear = -1;
        int month = -1;
        int tenDays = -1;
        int quarter = -1;
        int week = -1;
        CalendarHelper calendar = new CalendarHelper();
        try {
            switch (periodType) {
                case 1: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    return calendar.getLastDayOfYear(year);
                }
                case 2: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    halfYear = Integer.parseInt(param[1].substring(0, 2));
                    if (halfYear == 1) {
                        return calendar.getLastDayOfMonth(year, 1);
                    }
                    return calendar.getLastDayOfMonth(year, 7);
                }
                case 3: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    quarter = Integer.parseInt(param[1].substring(0, 2));
                    return calendar.getLastDayOfQuarter(year, quarter);
                }
                case 4: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    return calendar.getLastDayOfMonth(year, month);
                }
                case 9: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    tenDays = Integer.parseInt(param[2].substring(0, 2));
                    return calendar.getFirstDayOfMonthTenDays(year, month, tenDays);
                }
                case 5: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    week = Integer.parseInt(param[1].substring(0, 2));
                    return calendar.getLastDayOfWeek(year, week);
                }
                case 6: {
                    year = Integer.parseInt(param[0].substring(0, 4));
                    month = Integer.parseInt(param[1].substring(0, 2));
                    week = Integer.parseInt(param[2].substring(0, 2));
                    return calendar.getLastDayOfWeek(year, month, week);
                }
                case 7: {
                    return BgPeriodHelper.getDay(bgPeriodNumber);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            return null;
        }
        return null;
    }
}

