/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.IBgTemplate;

public class BgSchemeHelper {
    public static SelectorItemCollection getAssignSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("isFormal"));
        sic.add(new SelectorItemInfo("dateFrom"));
        sic.add(new SelectorItemInfo("dateTo"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("bgSchemeNodes"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("isSubmitByScheme"));
        return sic;
    }

    public static boolean checkTemplateQuoted(String bgSchemeId, String templateId) throws Exception {
        IBgForm iBgForm = BgFormFactory.getRemoteInstance();
        boolean isQuoted = false;
        if (iBgForm.checkTemplateQuoted(bgSchemeId, templateId)) {
            isQuoted = true;
        }
        return isQuoted;
    }

    public static boolean checkSchemeHasChild(String schemeId) throws Exception {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        boolean hasChild = false;
        if (iBgScheme.hasChildScheme(schemeId)) {
            hasChild = true;
        }
        return hasChild;
    }

    public static boolean checkTemplateHasChild(String templateId) throws Exception {
        IBgTemplate iTemplate = BgTemplateFactory.getRemoteInstance();
        boolean hasChild = false;
        if (iTemplate.hasChildTemplate(templateId)) {
            hasChild = true;
        }
        return hasChild;
    }

    public static boolean checkSchemeHasParent(String schemeId) throws Exception {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        boolean hasParent = false;
        if (((BgSchemeInfo)iBgScheme.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)schemeId)))).getParentScheme() != null) {
            hasParent = true;
        }
        return hasParent;
    }

    public static boolean checkTemplateHasParent(String templateId) throws Exception {
        IBgTemplate iBgTemplate = BgTemplateFactory.getRemoteInstance();
        boolean hasParent = false;
        if (((BgTemplateInfo)iBgTemplate.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)templateId)))).getParent() != null) {
            hasParent = true;
        }
        return hasParent;
    }

    public static boolean checkTempParentQuotedBySchemeParent(String templateId, String schemeId) throws Exception {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        boolean quoted = false;
        if (iBgScheme.checkTempParentQuotedBySchemeParent(templateId, schemeId)) {
            quoted = true;
        }
        return quoted;
    }

    public static boolean checkTempAssignedInBgScheme(String templateId, String schemeId) throws Exception {
        IBgScheme iBgScheme = BgSchemeFactory.getRemoteInstance();
        boolean assigned = false;
        if (iBgScheme.checkTempAssignedInBgScheme(templateId, schemeId)) {
            assigned = true;
        }
        return assigned;
    }
}

