/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.analysiscolumn.impls;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCompareAndAnalysisByBgItemFacadeFactory;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgCompareAndAnalysisByBgItemFacade;
import com.kingdee.eas.ma.budget.NewBgCompareAndAnalysisFilterParam;
import com.kingdee.eas.ma.budget.analysiscolumn.AbstractFetchDataFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.BgCompareAndAnalysisObjInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.DataDealCenter;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.FetchStandardDataFactory;
import com.kingdee.eas.ma.budget.analysiscolumn.impls.StandardAnalysisElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FetchStandardDataByBgItemFactory
extends AbstractFetchDataFactory {
    private static Logger logger = Logger.getLogger((String)FetchStandardDataByBgItemFactory.class.getName());
    private IBgCompareAndAnalysisByBgItemFacade remoteInstance;
    private Map BASEDATA_MAP;
    private Map LAST_YEAR_DATA_MAP;
    private Map THIS_YEAR_DATA_MAP;
    private Map SUM_DATA_MAP;
    private Map BALANCE_DATA_MAP;
    private Map PERIOD_BALANCE_DATA_MAP;
    private Map BEFORE_BALANCE_DATA_MAP;
    private static List THE_LAST_ACTUAL_DATA_LIST = Collections.unmodifiableList(Arrays.asList("col16"));
    private Map THE_LAST_ACTUAL_DATA_MAP;

    protected FetchStandardDataByBgItemFactory() throws ClassNotFoundException {
    }

    @Override
    public void initDataFactory(FilterParam filter1Params, FilterParam filter2Params) throws EASBizException, BOSException {
        logger.info((Object)"FetchStandardDataByBgItemFactory.initDataFactory invoke");
        NewBgCompareAndAnalysisFilterParam newFilter1Params = (NewBgCompareAndAnalysisFilterParam)filter1Params;
        NewBgCompareAndAnalysisFilterParam newFilter2Params = (NewBgCompareAndAnalysisFilterParam)filter2Params;
        List analysisColIndexList = newFilter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (FetchStandardDataFactory.BASEDATA_LIST.indexOf(proName) != -1) {
                this.getData(null, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.LAST_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getLastYearData(null, newFilter1Params, null);
                if (proName.equals("col9") || proName.equals("col10")) {
                    this.getData(null, newFilter1Params, null);
                }
            }
            if (FetchStandardDataFactory.THIS_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getThisYearData(null, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.SUM_DATA_LIST.indexOf(proName) != -1) {
                this.getSumData(null, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getBalanceData(null, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.PERIOD_BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getPeriodBalanceData(null, newFilter1Params, null);
            }
            if (THE_LAST_ACTUAL_DATA_LIST.indexOf(proName) != -1) {
                this.getTheLastActualData(null, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.BEFORE_BALANCE_DATA_LIST.indexOf(proName) == -1) continue;
            this.getBeforeBalanceData(null, newFilter1Params, null);
        }
    }

    @Override
    public void initSubOrgDataFactory(FilterParam filter1Params, FilterParam filter2Params, String[] bgItemAry) throws EASBizException, BOSException {
        NewBgCompareAndAnalysisFilterParam newFilter1Params = (NewBgCompareAndAnalysisFilterParam)filter1Params;
        NewBgCompareAndAnalysisFilterParam newFilter2Params = (NewBgCompareAndAnalysisFilterParam)filter2Params;
        List analysisColIndexList = newFilter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (FetchStandardDataFactory.BASEDATA_LIST.indexOf(proName) != -1) {
                this.getData(null, newFilter1Params, bgItemAry);
            }
            if (FetchStandardDataFactory.LAST_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getLastYearData(null, newFilter1Params, bgItemAry);
                if (proName.equals("row9") || proName.equals("row10")) {
                    this.getData(null, newFilter1Params, bgItemAry);
                }
            }
            if (FetchStandardDataFactory.THIS_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getThisYearData(null, newFilter1Params, bgItemAry);
            }
            if (FetchStandardDataFactory.SUM_DATA_LIST.indexOf(proName) != -1) {
                this.getSumData(null, newFilter1Params, bgItemAry);
            }
            if (FetchStandardDataFactory.BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getBalanceData(null, newFilter1Params, bgItemAry);
            }
            if (FetchStandardDataFactory.PERIOD_BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getPeriodBalanceData(null, newFilter1Params, bgItemAry);
            }
            if (THE_LAST_ACTUAL_DATA_LIST.indexOf(proName) != -1) {
                this.getTheLastActualData(null, newFilter1Params, bgItemAry);
            }
            if (FetchStandardDataFactory.BEFORE_BALANCE_DATA_LIST.indexOf(proName) == -1) continue;
            this.getBeforeBalanceData(null, newFilter1Params, bgItemAry);
        }
    }

    private void getData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.BASEDATA_MAP == null || this.BASEDATA_MAP.size() == 0) {
            this.BASEDATA_MAP = this.getRemoteInstance(ctx).getData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.BASEDATA_MAP, "data", bgItemAry);
        }
    }

    private void getLastYearData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.LAST_YEAR_DATA_MAP == null || this.LAST_YEAR_DATA_MAP.size() == 0) {
            this.LAST_YEAR_DATA_MAP = this.getRemoteInstance(ctx).getLastYearData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.LAST_YEAR_DATA_MAP, "lastYearData", bgItemAry);
        }
    }

    private void getThisYearData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.THIS_YEAR_DATA_MAP == null || this.THIS_YEAR_DATA_MAP.size() == 0) {
            this.THIS_YEAR_DATA_MAP = this.getRemoteInstance(ctx).getThisYearData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.THIS_YEAR_DATA_MAP, "thisYearData", bgItemAry);
        }
    }

    private void getSumData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.SUM_DATA_MAP == null || this.SUM_DATA_MAP.size() == 0) {
            this.SUM_DATA_MAP = this.getRemoteInstance(ctx).getSumData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.SUM_DATA_MAP, "sumData", bgItemAry);
        }
    }

    private void getBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.BALANCE_DATA_MAP == null || this.BALANCE_DATA_MAP.size() == 0) {
            this.BALANCE_DATA_MAP = this.getRemoteInstance(ctx).getBalanceData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.BALANCE_DATA_MAP, "balanceData", bgItemAry);
        }
    }

    private void getPeriodBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.PERIOD_BALANCE_DATA_MAP == null || this.PERIOD_BALANCE_DATA_MAP.size() == 0) {
            this.PERIOD_BALANCE_DATA_MAP = this.getRemoteInstance(ctx).getPeriodBalanceData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.PERIOD_BALANCE_DATA_MAP, "periodbalanceData", bgItemAry);
        }
    }

    private void getBeforeBalanceData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.BEFORE_BALANCE_DATA_MAP == null || this.BEFORE_BALANCE_DATA_MAP.size() == 0) {
            this.BEFORE_BALANCE_DATA_MAP = this.getRemoteInstance(ctx).getBeforeData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.BEFORE_BALANCE_DATA_MAP, "beforebalanceData", bgItemAry);
        }
    }

    private void getTheLastActualData(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Params, String[] bgItemAry) throws EASBizException, BOSException {
        if (this.THE_LAST_ACTUAL_DATA_MAP == null || this.THE_LAST_ACTUAL_DATA_MAP.size() == 0) {
            this.THE_LAST_ACTUAL_DATA_MAP = this.getRemoteInstance(ctx).getTheLastData(filter1Params);
        }
        if (bgItemAry != null) {
            this.addSubOrgUnitData(filter1Params, this.THE_LAST_ACTUAL_DATA_MAP, "theLastActualData", bgItemAry);
        }
    }

    private void addSubOrgUnitData(NewBgCompareAndAnalysisFilterParam filter1Params, Map valueMap, String flag, String[] bgItemAry) throws BOSException, EASBizException {
        Map newDataMap = null;
        for (String bgItem : bgItemAry) {
            Object obj;
            Object tempOrgUnitID;
            if (bgItem == null) continue;
            CostCenterOrgUnitInfo[] ary = filter1Params.getLazyLoadDataCostCenterOrgUnitInfoAry();
            ArrayList<String> lazyOrgUnitList = new ArrayList<String>();
            int num = ary.length;
            for (int i = 0; i < num; ++i) {
                lazyOrgUnitList.add(ary[i].getId().toString());
            }
            BgCompareAndAnalysisObjInfo objInfo = (BgCompareAndAnalysisObjInfo)valueMap.get(bgItem);
            if (objInfo == null) {
                return;
            }
            Map orgUnitIdMap = objInfo.getOrgUnitIdMap();
            Set areadyOrgUnitSet = orgUnitIdMap.keySet();
            if (areadyOrgUnitSet.containsAll(lazyOrgUnitList)) continue;
            if (newDataMap == null) {
                newDataMap = this.getDataForAll(filter1Params, flag);
                if (newDataMap == null) continue;
                if (newDataMap.size() == 0) {
                    HashMap subMap = new HashMap();
                    int num2 = lazyOrgUnitList.size();
                    for (int i = 0; i < num2; ++i) {
                        tempOrgUnitID = lazyOrgUnitList.get(i).toString();
                        BgCompareAndAnalysisObjInfo tempObjInfo = new BgCompareAndAnalysisObjInfo((String)tempOrgUnitID, DataDealCenter.ZERO, DataDealCenter.ZERO, DataDealCenter.ZERO, DataDealCenter.ZERO, subMap);
                        newDataMap.put(bgItem, tempObjInfo);
                    }
                    valueMap.putAll(newDataMap);
                    return;
                }
            }
            if ((obj = newDataMap.get(bgItem)) == null) {
                int num3 = lazyOrgUnitList.size();
                for (int i = 0; i < num3; ++i) {
                    tempOrgUnitID = lazyOrgUnitList.get(i);
                    orgUnitIdMap.put(tempOrgUnitID, null);
                }
            } else {
                BgCompareAndAnalysisObjInfo newObjInfo = (BgCompareAndAnalysisObjInfo)obj;
                Map newValMap = newObjInfo.getOrgUnitIdMap();
                ArrayList newOrgUnitList = new ArrayList(newValMap.keySet());
                orgUnitIdMap.putAll(newValMap);
                if (!newOrgUnitList.equals(lazyOrgUnitList)) {
                    int num4 = lazyOrgUnitList.size();
                    for (int i = 0; i < num4; ++i) {
                        Object tempOrgUnitID2 = lazyOrgUnitList.get(i);
                        if (newOrgUnitList.contains(tempOrgUnitID2)) continue;
                        orgUnitIdMap.put(tempOrgUnitID2, null);
                    }
                }
            }
            this.fillValueMap(valueMap, newDataMap, lazyOrgUnitList);
        }
    }

    private void fillValueMap(Map valueMap, Map newDataMap, List lazyOrgUnitList) {
        ArrayList keyNewDataList = new ArrayList(newDataMap.keySet());
        int num = keyNewDataList.size();
        for (int i = 0; i < num; ++i) {
            String keyFormula = keyNewDataList.get(i).toString();
            if (!valueMap.keySet().contains(keyFormula)) {
                valueMap.put(keyFormula, newDataMap.get(keyFormula));
                continue;
            }
            BgCompareAndAnalysisObjInfo oldInfo = (BgCompareAndAnalysisObjInfo)valueMap.get(keyFormula);
            BgCompareAndAnalysisObjInfo newInfo = (BgCompareAndAnalysisObjInfo)newDataMap.get(keyFormula);
            oldInfo.getOrgUnitIdMap().putAll(newInfo.getOrgUnitIdMap());
        }
    }

    private Map getDataForAll(NewBgCompareAndAnalysisFilterParam filter1Params, String flag) throws BOSException, EASBizException {
        IBgCompareAndAnalysisByBgItemFacade facade = this.getRemoteInstance(null);
        Map map = null;
        if (flag.equals("data")) {
            map = facade.getData(filter1Params);
        } else if (flag.equals("thisYearData")) {
            map = facade.getThisYearData(filter1Params);
        } else if (flag.equals("lastYearData")) {
            map = facade.getLastYearData(filter1Params);
        } else if (flag.equals("sumData")) {
            map = facade.getSumData(filter1Params);
        } else if (flag.equals("balanceData")) {
            map = facade.getBalanceData(filter1Params);
        } else if (flag.equals("periodbalanceData")) {
            map = facade.getPeriodBalanceData(filter1Params);
        } else if (flag.equals("theLastActualData")) {
            map = facade.getTheLastData(filter1Params);
        } else if (flag.equals("beforebalanceData")) {
            map = facade.getBeforeData(filter1Params);
        }
        return map;
    }

    @Override
    public void clearAllCache() {
        if (this.BASEDATA_MAP != null) {
            this.BASEDATA_MAP.clear();
        }
        if (this.LAST_YEAR_DATA_MAP != null) {
            this.LAST_YEAR_DATA_MAP.clear();
        }
        if (this.THIS_YEAR_DATA_MAP != null) {
            this.THIS_YEAR_DATA_MAP.clear();
        }
        if (this.SUM_DATA_MAP != null) {
            this.SUM_DATA_MAP.clear();
        }
        if (this.BALANCE_DATA_MAP != null) {
            this.BALANCE_DATA_MAP.clear();
        }
        if (this.PERIOD_BALANCE_DATA_MAP != null) {
            this.PERIOD_BALANCE_DATA_MAP.clear();
        }
        if (this.THE_LAST_ACTUAL_DATA_MAP != null) {
            this.THE_LAST_ACTUAL_DATA_MAP.clear();
        }
    }

    @Override
    public String getAnalysisEleClassName() {
        return StandardAnalysisElement.class.getName();
    }

    public Map getBASEDATA_MAP() {
        return this.BASEDATA_MAP;
    }

    public Map getLAST_YEAR_DATA_MAP() {
        return this.LAST_YEAR_DATA_MAP;
    }

    public Map getSUM_DATA_MAP() {
        return this.SUM_DATA_MAP;
    }

    public Map getTHIS_YEAR_DATA_MAP() {
        return this.THIS_YEAR_DATA_MAP;
    }

    public Map getBALANCE_DATA_MAP() {
        return this.BALANCE_DATA_MAP;
    }

    public void setBALANCE_DATA_MAP(Map balance_data_map) {
        this.BALANCE_DATA_MAP = balance_data_map;
    }

    public Map getTHE_LAST_ACTUAL_DATA_MAP() {
        return this.THE_LAST_ACTUAL_DATA_MAP;
    }

    public void setTHE_LAST_ACTUAL_DATA_MAP(Map the_last_actual_data_map) {
        this.THE_LAST_ACTUAL_DATA_MAP = the_last_actual_data_map;
    }

    public Map getPERIOD_BALANCE_DATA_MAP() {
        return this.PERIOD_BALANCE_DATA_MAP;
    }

    public void setPERIOD_BALANCE_DATA_MAP(Map period_balance_data_map) {
        this.PERIOD_BALANCE_DATA_MAP = period_balance_data_map;
    }

    public Map getBEFORE_BALANCE_DATA_MAP() {
        return this.BEFORE_BALANCE_DATA_MAP;
    }

    public void setBEFORE_BALANCE_DATA_MAP(Map before_balance_data_map) {
        this.BEFORE_BALANCE_DATA_MAP = before_balance_data_map;
    }

    @Override
    public void initDataFactory(Context ctx, NewBgCompareAndAnalysisFilterParam filter1Param, NewBgCompareAndAnalysisFilterParam filter2Param) throws EASBizException, BOSException {
        logger.info((Object)"FetchStandardDataByBgItemFactory.initDataFactory invoke");
        NewBgCompareAndAnalysisFilterParam newFilter1Params = filter1Param;
        NewBgCompareAndAnalysisFilterParam newFilter2Params = filter2Param;
        List analysisColIndexList = newFilter2Params.getAnalysisElement();
        int num = analysisColIndexList.size();
        for (int i = 0; i < num; ++i) {
            String proName = analysisColIndexList.get(i).toString();
            if (FetchStandardDataFactory.BASEDATA_LIST.indexOf(proName) != -1) {
                this.getData(ctx, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.LAST_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getLastYearData(ctx, newFilter1Params, null);
                if (proName.equals("col9") || proName.equals("col10")) {
                    this.getData(ctx, newFilter1Params, null);
                }
            }
            if (FetchStandardDataFactory.THIS_YEAR_DATA_LIST.indexOf(proName) != -1) {
                this.getThisYearData(ctx, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.SUM_DATA_LIST.indexOf(proName) != -1) {
                this.getSumData(ctx, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getBalanceData(ctx, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.PERIOD_BALANCE_DATA_LIST.indexOf(proName) != -1) {
                this.getPeriodBalanceData(ctx, newFilter1Params, null);
            }
            if (THE_LAST_ACTUAL_DATA_LIST.indexOf(proName) != -1) {
                this.getTheLastActualData(ctx, newFilter1Params, null);
            }
            if (FetchStandardDataFactory.BEFORE_BALANCE_DATA_LIST.indexOf(proName) == -1) continue;
            this.getBeforeBalanceData(ctx, newFilter1Params, null);
        }
    }

    private IBgCompareAndAnalysisByBgItemFacade getRemoteInstance(Context ctx) throws BOSException {
        if (ctx != null) {
            this.remoteInstance = BgCompareAndAnalysisByBgItemFacadeFactory.getLocalInstance(ctx);
            return this.remoteInstance;
        }
        this.remoteInstance = BgCompareAndAnalysisByBgItemFacadeFactory.getRemoteInstance();
        return this.remoteInstance;
    }
}

