/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgActualRecordFacade;
import com.kingdee.eas.ma.budget.IBgElement;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AbstractBgActualCollectViewUI;
import com.kingdee.eas.ma.budget.client.BgActualRecordEditUI;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgActualCollectViewUI
extends AbstractBgActualCollectViewUI {
    private static final Logger logger = CoreUIObject.getLogger(BgActualCollectViewUI.class);
    private IBgActualRecordFacade iBgActFacade = null;

    public IBgActualRecordFacade getBgActualCollectInterface() throws BOSException {
        return BgActualRecordFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.processInitSystem();
        this.processCollectInfo();
    }

    private void processInitSystem() {
        this.txtBgDataType.setText("");
        this.txtBgElementName.setText("");
        this.txtBgItemName.setText("");
        this.txtBgItemNumber.setText("");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.contBgItemName.setEnabled(false);
        this.contBgItemNumber.setEnabled(false);
        this.contBgElementName.setEnabled(false);
        this.contBgDataType.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCollectInfo() throws BOSException, EASBizException {
        ArrayList<String[]> orgUnitList;
        block24: {
            BigDecimal measure;
            String[] parameter;
            String formulaString;
            block23: {
                block25: {
                    formulaString = (String)this.getUIContext().get("COLLECT_FORMULA");
                    parameter = BgFSHelper.getFormulaInfo(formulaString);
                    measure = null;
                    if (this.getUIContext().get("COLLECT_MEASUREUNIT") != null) {
                        measure = (BigDecimal)this.getUIContext().get("COLLECT_MEASUREUNIT");
                    }
                    OrgUnitInfo orgUnitInfo = null;
                    ArrayList orgUnitIn = null;
                    Hashtable bgSchemeMap = null;
                    String[] orgUnitStr = null;
                    orgUnitList = new ArrayList<String[]>();
                    if (this.getUIContext().get("COLLECT_ORGUNIT") == null) return;
                    if (this.getUIContext().get("COLLECT_SCHEME") == null) return;
                    orgUnitIn = (ArrayList)this.getUIContext().get("COLLECT_ORGUNIT");
                    bgSchemeMap = (Hashtable)this.getUIContext().get("COLLECT_SCHEME");
                    if (orgUnitIn == null) return;
                    if (orgUnitIn.isEmpty()) return;
                    if (bgSchemeMap == null) return;
                    if (bgSchemeMap.isEmpty()) return;
                    String orgUnitId = null;
                    int n = orgUnitIn.size();
                    for (int i = 0; i < n; ++i) {
                        orgUnitInfo = (OrgUnitInfo)orgUnitIn.get(i);
                        orgUnitId = orgUnitInfo.getId().toString();
                        if (!bgSchemeMap.containsKey(orgUnitId)) continue;
                        orgUnitStr = new String[]{orgUnitId, orgUnitInfo.getName(), (String)bgSchemeMap.get(orgUnitId)};
                        orgUnitList.add(orgUnitStr);
                    }
                    orgUnitIn = null;
                    bgSchemeMap = null;
                    if (parameter == null) break block24;
                    if (parameter[0] == null || parameter[0].trim().length() <= 0) break block25;
                    HashSet<String> bgItemsSet = new HashSet<String>();
                    HashMap<String, String> bgItemsMap = new HashMap<String, String>();
                    String bgItemsName = null;
                    String[] bgItems = parameter[0].split(",");
                    int n2 = bgItems.length;
                    for (int i = 0; i < n2; ++i) {
                        bgItemsSet.add(bgItems[i]);
                    }
                    try {
                        IBgItem ibgItem = BgItemFactory.getRemoteInstance();
                        if (ibgItem == null) {
                            throw new BgException(BgException.NOINSTANCE);
                        }
                        String orgUnitId2 = null;
                        FullOrgUnitInfo orgUnit = (FullOrgUnitInfo)this.getUIContext().get("orgUnitInfo");
                        if (orgUnit != null) {
                            orgUnitId2 = orgUnit.getId().toString();
                        } else if (orgUnitIn != null && orgUnitIn.size() > 0 && orgUnitIn.get(0) instanceof OrgUnitInfo) {
                            orgUnitId2 = ((OrgUnitInfo)orgUnitIn.get(0)).getId().toString();
                        }
                        if (!BgSHelper.isBgItemIsolate()) {
                            orgUnitId2 = "00000000-0000-0000-0000-000000000000CCE7AED4";
                        }
                        EntityViewInfo view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("number", bgItemsSet, CompareType.INCLUDE));
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId2, CompareType.EQUALS));
                        view.setFilter(filter);
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("name"));
                        sic.add(new SelectorItemInfo("number"));
                        view.getSelector().addObjectCollection((IObjectCollection)sic);
                        BgItemInfo bgItemInfo = null;
                        BgItemCollection bgItemCol = ibgItem.getBgItemCollection(view);
                        Iterator iter = bgItemCol.iterator();
                        while (iter.hasNext()) {
                            bgItemInfo = (BgItemInfo)iter.next();
                            if (bgItemsMap.containsKey(bgItemInfo.getNumber())) continue;
                            bgItemsMap.put(bgItemInfo.getNumber(), bgItemInfo.getName());
                        }
                        int n3 = bgItems.length;
                        for (int i = 0; i < n3; ++i) {
                            bgItemsName = i == 0 ? (String)bgItemsMap.get(bgItems[i]) : bgItemsName + "|" + bgItemsMap.get(bgItems[i]);
                        }
                        this.txtBgItemNumber.setText(parameter[0]);
                    }
                    catch (BOSException ex) {
                        throw ex;
                        catch (EASBizException ex2) {
                            throw ex2;
                        }
                        catch (Exception ex3) {
                            logger.error((Object)"budget error:", (Throwable)ex3);
                            break block23;
                        }
                    }
                    this.txtBgItemName.setText(bgItemsName);
                    break block23;
                    finally {
                        this.txtBgItemNumber.setText(parameter[0]);
                        this.txtBgItemName.setText(bgItemsName);
                    }
                }
                this.txtBgItemNumber.setText("");
                this.txtBgItemName.setText("");
            }
            this.dealBGelement(parameter);
            this.txtBgDataType.setText(BgDataTypeEnum.BgActual.getAlias());
            int idecimal = this.dealCurrency(parameter);
            String bgPeriodId = this.getUIContext().get("bgPeriodId") == null ? "" : this.getUIContext().get("bgPeriodId").toString();
            List reInfo = this.getBgActualCollectInterface().getCollectData(formulaString, orgUnitList, bgPeriodId);
            if (reInfo != null && !reInfo.isEmpty()) {
                String[] data = null;
                IRow row = null;
                int i = 0;
                int n = 0;
                int x = 0;
                int y = 0;
                n = reInfo.size();
                for (i = 0; i < n; ++i) {
                    data = (String[])reInfo.get(i);
                    row = this.tblMain.addRow();
                    if (measure == null) {
                        y = data.length;
                        for (x = 0; x < y; ++x) {
                            row.getCell(x).setValue((Object)data[x]);
                        }
                        continue;
                    }
                    row.getCell(0).setValue((Object)data[0]);
                    try {
                        row.getCell(1).setValue((Object)new BigDecimal(data[1]).divide(measure, idecimal, 4).toString());
                    }
                    catch (Exception ex) {
                        row.getCell(1).setValue((Object)data[1]);
                    }
                    row.getCell(2).setValue((Object)data[2]);
                }
                this.tblMain.getSelectManager().select(0, 0, 0, 0);
            }
        }
        BgNSHelper.objClear(orgUnitList);
    }

    private int dealCurrency(String[] parameter) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo;
        int idecimal = 8;
        if (parameter != null && parameter[5] != null && (currencyInfo = BgSHelper.getCurrencyInfo(null, parameter[5], null)) != null) {
            idecimal = currencyInfo.getPrecision();
        }
        return idecimal;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dealBGelement(String[] parameter) throws BOSException, EASBizException {
        if (parameter[2] == null) return;
        if (parameter[2].trim().length() <= 0) return;
        String bgElementName = null;
        try {
            IBgElement ibgElement = BgElementFactory.getRemoteInstance();
            if (ibgElement == null) {
                throw new BgException(BgException.NOINSTANCE);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)parameter[2], CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            BgElementCollection bgElementCol = ibgElement.getBgElementCollection(view);
            bgElementName = !bgElementCol.isEmpty() ? bgElementCol.get(0).getName() : "";
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (EASBizException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                this.txtBgElementName.setText(bgElementName);
                throw throwable;
            }
        }
        this.txtBgElementName.setText(bgElementName);
    }

    @Override
    protected void btnViewRpt_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewRpt_actionPerformed(e);
        this.openReport(OprtState.VIEW);
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.openReport(OprtState.VIEW);
        }
    }

    protected void openReport(String reportState) throws Exception {
        Object bgActualRecordId;
        if (this.tblMain.getBody().size() == 0) {
            return;
        }
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < 0) {
            activeRowIndex = 0;
        }
        if ((bgActualRecordId = this.tblMain.getCell(activeRowIndex, 2).getValue()) != null && bgActualRecordId.toString().trim().length() != 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", (Object)bgActualRecordId.toString());
            uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
            uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
            uiContext.put((Object)"OpenReportState", (Object)reportState);
            uiContext.put((Object)"OpenReportModal", (Object)Boolean.TRUE);
            uiContext.put((Object)"isWillAudit", (Object)Boolean.FALSE);
            uiContext.put((Object)"isWillUnAudit", (Object)Boolean.FALSE);
            uiContext.put((Object)"viewCollectInfo", (Object)Boolean.TRUE);
            uiContext.put((Object)"bgFormType", (Object)"ActualEditType");
            uiContext.put((Object)"orgUnitInfo", this.getUIContext().get("orgUnitInfo"));
            uiContext.put((Object)"OrgUnitCU", this.getUIContext().get("OrgUnitCU"));
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgActualRecordEditUI.class.getName(), (Map)uiContext, null, reportState);
            uiWindow.hide();
        }
    }
}

