/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgActualRecordFacadeFactory;
import com.kingdee.eas.ma.budget.BgActualRecordFactory;
import com.kingdee.eas.ma.budget.BgFPeriodFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.IBgFPeriodFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgActualRecordListUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgActualRecordEditUI;
import com.kingdee.eas.ma.budget.client.BgFormPeriodEditUI;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForActual;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgActualRecordListUI
extends AbstractBgActualRecordListUI {
    public static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgActualRecordResource";
    private static final Logger logger = CoreUIObject.getLogger(BgActualRecordListUI.class);
    private boolean isWillAudit = false;
    private boolean isWillUnAudit = false;
    private IBgFPeriodFacade ibgFPeriodFacade = null;
    protected LongTimeDialog dialog = null;
    private Window win = null;
    private Object _filterParam = null;
    private BgFormPeriodEditUI filterUI = null;
    public static final String RESOURCEPATH = "com.kingdee.eas.ma.budget.client.BgFormResource";
    private IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    private CommonQueryDialog cqDialog = null;

    @Override
    protected String getEditUIName() {
        return BgActualRecordEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgActualRecordFactory.getRemoteInstance();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        this.tblMain.getSelectManager().setSelectMode(2);
    }

    private void setIcon() {
        this.btnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_audit"));
        this.btnUnAuditActual.setIcon(EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.btnActualCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
    }

    protected void openReport(ActionEvent e, String reportState) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReportState", (Object)reportState);
        uiContext.put((Object)"bgFormType", (Object)"budgetEditType");
        uiContext.put((Object)"isWillAudit", (Object)this.isWillAudit);
        uiContext.put((Object)"isWillUnAudit", (Object)this.isWillUnAudit);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    public void openCollectReport(ActionEvent e, String bgFormId, Hashtable mapInfo, ArrayList orgUnitCol) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)bgFormId);
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
        uiContext.put((Object)"bgFormType", (Object)"budgetEditType");
        uiContext.put((Object)"isWillAudit", (Object)this.isWillAudit);
        uiContext.put((Object)"isWillUnAudit", (Object)this.isWillUnAudit);
        uiContext.put((Object)"IS_COLLECT", (Object)Boolean.TRUE);
        uiContext.put((Object)"COLLECT_SCHEME", (Object)mapInfo);
        uiContext.put((Object)"COLLECT_ORGUNIT", (Object)orgUnitCol);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        try {
            queryExecutor.setParameter(1, (Object)this.getOrgUnitId());
            queryExecutor.setParameter(2, (Object)new Integer(1));
            queryExecutor.setParameter(3, (Object)new Integer(8));
            if (BgParamCHelper.isFodian()) {
                queryExecutor.setParameter(4, (Object)new Integer(4));
            } else {
                queryExecutor.setParameter(4, (Object)new Integer(-1));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        return queryExecutor;
    }

    @Override
    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        uiContext.put((Object)"orgUnitInfo", (Object)orgUnitInfo);
        uiContext.put((Object)"OrgUnitCU", (Object)orgUnitInfo.getCU());
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.setWillAudit(false);
        this.setWillUnAudit(false);
        this.openReport(e, OprtState.VIEW);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsOnCU(true);
        this.setWillAudit(false);
        this.setWillUnAudit(false);
        this.openReport(e, OprtState.EDIT);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFlow_actionPerformed(e);
    }

    @Override
    public void actionAuditActual_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsOnCU(true);
        this.setWillAudit(true);
        this.setWillUnAudit(false);
        this.openReport(e, OprtState.VIEW);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("state").getValue();
            if (state.getInt() == 1) {
                this.actionAuditActual.setEnabled(true);
                this.actionAuditActual.setVisible(true);
                this.actionUnAuditActual.setEnabled(false);
                this.actionUnAuditActual.setVisible(false);
                this.actionEdit.setEnabled(true);
                this.actionEdit.setVisible(true);
                this.actionRemove.setEnabled(true);
                this.actionRemove.setVisible(true);
            } else if (state.getInt() == 2) {
                this.actionAuditActual.setEnabled(false);
                this.actionAuditActual.setVisible(false);
                this.actionUnAuditActual.setEnabled(true);
                this.actionUnAuditActual.setVisible(true);
                this.actionEdit.setEnabled(false);
                this.actionEdit.setVisible(false);
                this.actionRemove.setEnabled(false);
                this.actionRemove.setVisible(false);
            }
        }
    }

    @Override
    public void actionUnAuditActual_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsOnCU(true);
        this.setWillAudit(false);
        this.setWillUnAudit(true);
        this.openReport(e, OprtState.VIEW);
    }

    public void collectActualRecord(ActionEvent e, String bgActualRecordId, String bgFormId, String bgActualPeriodId) throws Exception {
        if (bgActualRecordId == null || bgActualRecordId.trim().length() == 0) {
            return;
        }
        BOSUuid bgActualId = BOSUuid.read((String)bgActualRecordId);
        BOSUuid bgFId = BOSUuid.read((String)bgFormId);
        FullOrgUnitInfo org = null;
        FullOrgUnitInfo tmpOrg = null;
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            IRow row = this.tblMain.getRow(activeRowIndex);
            org = new FullOrgUnitInfo();
            org.setId(BOSUuid.read((String)row.getCell("orgUnit.id").getValue().toString()));
        } else {
            org = this.getBGOrgUnitInfo();
        }
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCol = iNew.getChildren(org.getId().toString(), OrgViewType.COSTCENTER);
        if (orgUnitCol != null && !orgUnitCol.isEmpty()) {
            int i;
            FullOrgUnitCollection orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            HashMap<String, String> orgRangesMap = new HashMap<String, String>();
            for (i = 0; i < orgRangesColl.size(); ++i) {
                orgRangesMap.put(orgRangesColl.get(i).getId().toString(), orgRangesColl.get(i).getId().toString());
            }
            for (i = orgUnitCol.size() - 1; i >= 0; --i) {
                String tmpid = orgUnitCol.get(i).getId().toString();
                if (orgRangesMap.containsKey(tmpid)) continue;
                orgUnitCol.removeObject(i);
            }
        }
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NoSubOrgNotCollect"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitCol);
        uiContextOrg.put((Object)"CUID", (Object)org.getId().toString());
        uiContextOrg.put((Object)"ID", (Object)bgFormId);
        uiContextOrg.put((Object)"selfPanelUiName", (Object)BgSubOrgUnitSelectUIForActual.class.getName());
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        HashMap returnData = (HashMap)((AssignSolutionUI)orgSelectorUI.getUIObject()).getReturnData();
        if (returnData == null || returnData.get("returnValue") == null || ((ArrayList)returnData.get("returnValue")).size() == 0) {
            return;
        }
        ArrayList<FullOrgUnitInfo> subOrgs = (ArrayList<FullOrgUnitInfo>)returnData.get("returnValue");
        HashMap<BOSUuid, Object> orgUnitMap = new HashMap<BOSUuid, Object>();
        int n = subOrgs.size();
        for (int i = 0; i < n; ++i) {
            tmpOrg = (FullOrgUnitInfo)subOrgs.get(i);
            orgUnitMap.put(tmpOrg.getId(), null);
        }
        Hashtable map = new Hashtable();
        map.putAll(BgActualRecordFacadeFactory.getRemoteInstance().filterBgActualCollectInfo(bgFId, orgUnitMap, BOSUuid.read((String)bgActualPeriodId)));
        if (!map.isEmpty()) {
            ArrayList<FullOrgUnitInfo> newOrgs = new ArrayList<FullOrgUnitInfo>();
            int n2 = subOrgs.size();
            for (int i = 0; i < n2; ++i) {
                tmpOrg = (FullOrgUnitInfo)subOrgs.get(i);
                if (!map.containsKey(tmpOrg.getId().toString())) continue;
                newOrgs.add(tmpOrg);
            }
            if (newOrgs == null || newOrgs.isEmpty()) {
                MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"cantCollect"));
                SysUtil.abort();
            }
            subOrgs.clear();
            subOrgs = newOrgs;
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"cantCollect"));
            SysUtil.abort();
        }
        this.openCollectReport(e, bgActualRecordId, map, subOrgs);
        if (this.isDoRefresh(this.uiWindow)) {
            this.refresh(null);
        }
    }

    public boolean isWillAudit() {
        return this.isWillAudit;
    }

    public void setWillAudit(boolean isWillAudit) {
        this.isWillAudit = isWillAudit;
    }

    public boolean isWillUnAudit() {
        return this.isWillUnAudit;
    }

    public void setWillUnAudit(boolean isWillUnAudit) {
        this.isWillUnAudit = isWillUnAudit;
    }

    @Override
    public void actionActualCollect_actionPerformed(ActionEvent e) throws Exception {
        super.actionActualCollect_actionPerformed(e);
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            ICell cell = row.getCell("bgForm.id");
            ICell cell1 = row.getCell("bgPeriod.id");
            this.collectActualRecord(e, this.getSelectedKeyValue(), cell.getValue().toString(), cell1.getValue().toString());
        }
    }

    @Override
    public void actionBgPeriodEdit_actionPerformed(ActionEvent e) throws Exception {
        this.cqDialog = this.getCommonQueryDialog();
        if (this.cqDialog.show()) {
            CustomerParams _cp = this.getFilterUI().getCustomerParams();
            this._filterParam = this.getFilterUI().getFilterObject(_cp);
            this.win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (this.win instanceof Frame) {
                this.dialog = new LongTimeDialog((Frame)this.win);
            } else if (this.win instanceof Dialog) {
                this.dialog = new LongTimeDialog((Dialog)this.win);
            }
            this.dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    List mutexList = BgActualRecordListUI.this.getBgFPEInterface().weave(BgActualRecordListUI.this._filterParam, false);
                    return mutexList;
                }

                public void afterExec(Object result) throws Exception {
                    List reList;
                    if (result != null && result instanceof List && (reList = (List)result) != null) {
                        int i;
                        int in;
                        StringBuffer message;
                        String bgFormName;
                        List mutexList = (List)reList.get(0);
                        List succeedList = (List)reList.get(1);
                        if (mutexList != null && !mutexList.isEmpty()) {
                            bgFormName = null;
                            message = new StringBuffer();
                            in = mutexList.size();
                            for (i = 0; i < in; ++i) {
                                bgFormName = (String)mutexList.get(i);
                                message.append(bgFormName + ",");
                            }
                            message.delete(message.length() - 1, message.length());
                            MsgBox.showWarning((String)(message.toString() + BgFormHelper.getMessage("bgFormInfoMutex")));
                        }
                        if (succeedList != null && !succeedList.isEmpty()) {
                            bgFormName = null;
                            message = new StringBuffer();
                            in = succeedList.size();
                            for (i = 0; i < in; ++i) {
                                bgFormName = (String)succeedList.get(i);
                                message.append(bgFormName + ",");
                            }
                            message.delete(message.length() - 1, message.length());
                            MsgBox.showWarning((String)(message.toString() + BgFormHelper.getMessage("bgFormPeriodSucceed")));
                        }
                    }
                }
            });
            this.dialog.show();
        }
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.cqDialog != null) {
            KDPanel panel = null;
            int in = this.cqDialog.getUserPanels().size();
            for (int i = 0; i < in; ++i) {
                panel = this.cqDialog.getUserPanel(i);
                if (panel == null || !(panel instanceof BgFormPeriodEditUI)) continue;
                ((BgFormPeriodEditUI)panel).restart((OrgUnitInfo)this.getBGOrgUnitInfo());
            }
            return this.cqDialog;
        }
        this.cqDialog = new CommonQueryDialog();
        this.cqDialog.setOwner((Component)((Object)this));
        this.cqDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.cqDialog.setEntityViewInfo(new EntityViewInfo());
        this.cqDialog.setQueryObjectPK(this.mainQueryPk);
        this.cqDialog.setTitle(EASResource.getString((String)RESOURCEPATH, (String)"bgFormPeriodEdit"));
        this.cqDialog.setWidth(800);
        this.cqDialog.setHeight(620);
        this.cqDialog.addUserPanel((KDPanel)this.getFilterUI());
        this.cqDialog.setShowFilter(false);
        this.cqDialog.setShowSorter(false);
        this.cqDialog.setDisVisiableDefaultView(false);
        return this.cqDialog;
    }

    @Override
    protected IBgFPeriodFacade getBgFPEInterface() throws Exception {
        if (this.ibgFPeriodFacade == null) {
            this.ibgFPeriodFacade = BgFPeriodFacadeFactory.getRemoteInstance();
        }
        return this.ibgFPeriodFacade;
    }

    protected BgFormPeriodEditUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BgFormPeriodEditUI((Object)this, this.getBGOrgUnitInfo());
        }
        return this.filterUI;
    }
}

