/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.message.client.MessageCenterUI;
import com.kingdee.eas.base.multiapprove.client.MultiApproveUI;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAdjustBillAuditIdeaInfo;
import com.kingdee.eas.ma.budget.BgAdjustBillEntryInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.AbstractBgAdjustBillWFEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class BgAdjustBillWFEditUI
extends AbstractBgAdjustBillWFEditUI {
    private static final long serialVersionUID = -8453776438029317940L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustBillWFEditUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public void onShow() throws Exception {
        super.onShow();
        if (this.getDetailTable() != null) {
            this.getDetailTable().getSelectManager().select(0, 0);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("auditor.*"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.rootId"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("entry.formula"));
        sic.add(new SelectorItemInfo("entry.bgItemId"));
        sic.add(new SelectorItemInfo("entry.adjustBefore"));
        sic.add(new SelectorItemInfo("entry.adjustApply"));
        sic.add(new SelectorItemInfo("entry.adjustPass"));
        sic.add(new SelectorItemInfo("entry.adjustAfter"));
        sic.add(new SelectorItemInfo("entry.adjustGroup"));
        sic.add(new SelectorItemInfo("entry.adjustCause"));
        sic.add(new SelectorItemInfo("entry.*"));
        sic.add(new SelectorItemInfo("entry.number"));
        sic.add(new SelectorItemInfo("entry.adjustType"));
        sic.add(new SelectorItemInfo("entry.orgUnit.id"));
        sic.add(new SelectorItemInfo("entry.orgUnit.name"));
        sic.add(new SelectorItemInfo("entry.orgUnit.number"));
        sic.add(new SelectorItemInfo("entry.bgScheme.id"));
        sic.add(new SelectorItemInfo("entry.bgScheme.name"));
        sic.add(new SelectorItemInfo("entry.bgScheme.number"));
        sic.add(new SelectorItemInfo("entry.bgForm.id"));
        sic.add(new SelectorItemInfo("entry.bgForm.name"));
        sic.add(new SelectorItemInfo("entry.bgForm.number"));
        sic.add(new SelectorItemInfo("entry.bgPeriod.id"));
        sic.add(new SelectorItemInfo("entry.bgPeriod.name"));
        sic.add(new SelectorItemInfo("entry.bgPeriod.number"));
        sic.add(new SelectorItemInfo("entry.bgElement.id"));
        sic.add(new SelectorItemInfo("entry.bgElement.name"));
        sic.add(new SelectorItemInfo("entry.bgElement.number"));
        sic.add(new SelectorItemInfo("entry.currency.id"));
        sic.add(new SelectorItemInfo("entry.currency.name"));
        sic.add(new SelectorItemInfo("entry.currency.number"));
        sic.add(new SelectorItemInfo("entry.currency.precision"));
        sic.add(new SelectorItemInfo("entry.idea.*"));
        sic.add(new SelectorItemInfo("entry.idea.auditor.*"));
        sic.add(new SelectorItemInfo("isAcrossOrgAndPeriod"));
        return sic;
    }

    @Override
    public void loadFields() {
        this.beforeLoadFields();
        super.loadFields();
        try {
            this.getRPCData();
        }
        catch (Exception ex) {
            logger.error((Object)"budget error:", (Throwable)ex);
        }
        this.afterLoadFields();
    }

    @Override
    protected void initSystemInfo() throws EASBizException, BOSException {
        super.initSystemInfo();
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof MultiApproveUI) {
            if (this.getOprtState().equals("EDIT")) {
                this.workBtnAddIdea.setEnabled(true);
                this.workBtnDelIdea.setEnabled(true);
                this.prmtBgScheme.setEnabled(false);
                this.actionAddNewIdea.setEnabled(true);
                this.actionRemoveIdea.setEnabled(true);
            } else if (this.getOprtState().equals("FINDVIEW")) {
                this.workBtnAddIdea.setEnabled(false);
                this.workBtnDelIdea.setEnabled(false);
                this.btnSave.setEnabled(false);
                this.btnAudit.setEnabled(false);
                this.btnReport.setEnabled(true);
                this.actionAddNewIdea.setEnabled(false);
                this.actionRemoveIdea.setEnabled(false);
                this.actionSubmit.setEnabled(false);
                this.actionAudit.setEnabled(false);
                this.actionOpenReport.setEnabled(true);
                this.btnSave.setVisible(false);
                this.btnAudit.setVisible(false);
                this.btnReport.setVisible(true);
            }
        }
        if (this.getUIContext().get("Owner") != null && this.getUIContext().get("Owner") instanceof MessageCenterUI) {
            this.workBtnAddIdea.setEnabled(false);
            this.workBtnDelIdea.setEnabled(false);
            this.actionAddNewIdea.setEnabled(false);
            this.actionRemoveIdea.setEnabled(false);
        }
        this.prmtForm_global.setEnabled(false);
        int n = this.getDetailTable().getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i != this.getDetailTable().getColumn(this.adjustPassColIndex).getColumnIndex()) {
                this.getDetailTable().getColumn(i).getStyleAttributes().setLocked(true);
                continue;
            }
            this.getDetailTable().getColumn(i).getStyleAttributes().setLocked(false);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAddLine.setEnabled(false);
        this.actionInsertLine.setEnabled(false);
        this.actionRemoveLine.setEnabled(false);
        this.actionAddNewLine.setEnabled(false);
        this.actionDeleteLine.setEnabled(false);
        this.actionAddNewIdea.setEnabled(true);
        this.actionRemoveIdea.setEnabled(true);
        this.actionAddNew.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        this.actionReferWorking.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnRefer.setVisible(false);
        this.workBtnAddIdea.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.workBtnDelIdea.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    @Override
    protected void kdtEntry_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.kdtEntry_tableSelectChanged(e);
        DateFormat format = BgNationalFormatUIUtil.getNationalDateFormat();
        if (this.getDetailTable() != null) {
            BgAdjustBillEntryInfo entry;
            int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
            rowIndex = rowIndex == -1 ? 0 : rowIndex;
            IRow row = this.getDetailTable().getRow(rowIndex);
            if (row.getUserObject() != null && row.getUserObject() instanceof BgAdjustBillEntryInfo && (entry = (BgAdjustBillEntryInfo)row.getUserObject()).getIdea() != null) {
                this.beforeShowIdeaInfo();
                BgAdjustBillAuditIdeaInfo audit = null;
                Iterator iter = entry.getIdea().iterator();
                while (iter.hasNext()) {
                    audit = (BgAdjustBillAuditIdeaInfo)iter.next();
                    if (audit == null) continue;
                    row = this.entryIdea.addRow();
                    row.getCell("auditor.name").setValue((Object)audit.getAuditor());
                    row.getCell("auditValue").setValue((Object)audit.getAuditValue());
                    row.getCell("auditIdea").setValue((Object)audit.getAuditIdea());
                    row.getCell("auditDate").setValue((Object)format.format(audit.getAuditDate()));
                    row.setUserObject((Object)audit);
                }
                this.afterShowIdeaInfo();
            }
        }
    }

    protected void beforeShowIdeaInfo() throws Exception {
        this.entryIdea.setRefresh(false);
        this.entryIdea.removeRows();
    }

    protected void afterShowIdeaInfo() throws Exception {
        this.entryIdea.setRefresh(true);
        this.entryIdea.reLayoutAndPaint();
    }

    @Override
    public void actionAddNewIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNewIdea_actionPerformed(e);
        if (this.getDetailTable().getBody().size() <= 0) {
            return;
        }
        IRow row = null;
        BigDecimal value = null;
        int rowIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        rowIndex = rowIndex <= -1 ? 0 : rowIndex;
        row = this.getDetailTable().getRow(rowIndex);
        BgAdjustBillEntryInfo entry = (BgAdjustBillEntryInfo)row.getUserObject();
        if (row.getCell(this.adjustPassColIndex).getValue() != null) {
            value = (BigDecimal)row.getCell(this.adjustPassColIndex).getValue();
        }
        if ((row = this.entryIdea.addRow()) != null) {
            BgAdjustBillAuditIdeaInfo audit = new BgAdjustBillAuditIdeaInfo();
            audit.setId(BOSUuid.create((BOSObjectType)audit.getBOSType()));
            audit.setAuditor(SysContext.getSysContext().getCurrentUserInfo());
            audit.setAuditValue(value);
            audit.setAuditDate(new Date());
            row.getCell("auditor.name").setValue((Object)audit.getAuditor());
            row.getCell("auditValue").setValue((Object)audit.getAuditValue());
            row.getCell("auditIdea").setValue((Object)audit.getAuditIdea());
            row.getCell("auditDate").setValue((Object)BgNationalFormatUIUtil.getNationalDateFormat().format(audit.getAuditDate()));
            row.setUserObject((Object)audit);
            entry.getIdea().add(audit);
        }
    }

    @Override
    public void actionRemoveIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemoveIdea_actionPerformed(e);
        if (this.entryIdea.getBody().size() <= 0) {
            return;
        }
        int entryIndex = this.getDetailTable().getSelectManager().getActiveRowIndex();
        int rowIndex = this.entryIdea.getSelectManager().getActiveRowIndex();
        entryIndex = entryIndex <= -1 ? 0 : entryIndex;
        IRow row = this.entryIdea.getRow(rowIndex = rowIndex <= -1 ? 0 : rowIndex);
        if (row != null && row.getUserObject() != null) {
            BgAdjustBillAuditIdeaInfo audit = (BgAdjustBillAuditIdeaInfo)row.getUserObject();
            if (audit.getAuditor().getId().equals((Object)SysContext.getSysContext().getCurrentUserInfo().getId())) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"isRemoveIdea"));
                if (re == 0) {
                    this.entryIdea.removeRow(rowIndex);
                    row = this.getDetailTable().getRow(entryIndex);
                    if (row != null && row.getUserObject() != null) {
                        BgAdjustBillEntryInfo entryInfo = (BgAdjustBillEntryInfo)row.getUserObject();
                        entryInfo.getIdea().remove(audit);
                    }
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAdjustBillResource", (String)"cantRemoveIdea"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void entryIdea_editStopped(KDTEditEvent e) throws Exception {
        int rowIndex;
        IRow row;
        super.entryIdea_editStopped(e);
        if (e.getColIndex() == this.entryIdea.getColumnIndex("auditIdea") && (row = this.entryIdea.getRow(rowIndex = (rowIndex = this.entryIdea.getSelectManager().getActiveRowIndex()) <= -1 ? 0 : rowIndex)) != null && row.getUserObject() != null) {
            BgAdjustBillAuditIdeaInfo audit = (BgAdjustBillAuditIdeaInfo)row.getUserObject();
            if (e.getValue() == null) {
                audit.setAuditIdea(null);
            } else {
                audit.setAuditIdea(e.getValue().toString());
            }
        }
    }

    @Override
    public boolean isModify() {
        return false;
    }
}

