/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormAdjustData;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class BgAdjustCheckReportUI
extends BgExamineViewUI {
    private static final long serialVersionUID = -517913759023721350L;
    private static final Logger logger = CoreUIObject.getLogger(BgAdjustCheckReportUI.class);
    private static final String DEFAULT_STR = "com.kingdee.eas.ma.budget.client.BgAdjustCheckResource";
    protected DecimalFormat decFormat = BgNationalFormatUIUtil.getDecimalFormat(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()).getPrecision());

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle(EASResource.getString((String)DEFAULT_STR, (String)"title"));
    }

    @Override
    protected void initTable() {
        int rowCount = 6;
        int colCount = 9;
        this.tblMain.checkParsed(true);
        this.tblMain.removeRows();
        this.tblMain.removeColumns();
        this.tblMain.setRefresh(false);
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.addRows(rowCount);
        this.tblMain.addColumns(colCount);
        this.tblMain.addHeadRow();
        this.tblMain.getColumn(0).setWidth(80);
        this.tblMain.getColumn(1).setWidth(80);
        this.tblMain.getColumn(2).setWidth(80);
        this.tblMain.getColumn(3).setWidth(80);
        this.tblMain.getColumn(4).setWidth(80);
        this.tblMain.getColumn(5).setWidth(80);
        this.tblMain.getColumn(6).setWidth(80);
        this.tblMain.getColumn(7).setWidth(80);
        this.tblMain.getColumn(8).setWidth(150);
        this.tblMain.setRefresh(true);
        this.tblMain.checkParsed(true);
        this.tblMain.getStyleAttributes().setLocked(true);
    }

    @Override
    protected void loadBgExamineCheckData() {
        this.tblMain.getCell(0, 1).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"title"));
        this.tblMain.getCell(1, 1).setValue((Object)(EASResource.getString((String)DEFAULT_STR, (String)"user") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        this.tblMain.getCell(2, 1).setValue((Object)(EASResource.getString((String)DEFAULT_STR, (String)"time") + BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date())));
        this.tblMain.getMergeManager().mergeBlock(0, 0, 0, 1);
        this.tblMain.getMergeManager().mergeBlock(1, 0, 1, 2);
        this.tblMain.getMergeManager().mergeBlock(2, 0, 2, 1);
        this.tblMain.getMergeManager().mergeBlock(3, 0, 3, 1);
        this.tblMain.getCell(4, 0).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"budgetAdjustCheckCantPassIsThisReason"));
        this.tblMain.getMergeManager().mergeBlock(4, 0, 4, 6);
        this.tblMain.getCell(5, 0).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"seq"));
        this.tblMain.getCell(5, 1).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"org"));
        this.tblMain.getCell(5, 2).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"bgform"));
        this.tblMain.getCell(5, 3).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"itemnumber"));
        this.tblMain.getCell(5, 4).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"itemname"));
        this.tblMain.getCell(5, 5).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"element"));
        this.tblMain.getCell(5, 6).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"currency"));
        this.tblMain.getCell(5, 7).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"period"));
        this.tblMain.getCell(5, 8).setValue((Object)EASResource.getString((String)DEFAULT_STR, (String)"balance"));
        int n = this.tblMain.getRowCount();
        if (this.getUIContext().get("adjustData") != null && this.getUIContext().get("adjustData") instanceof List) {
            List adjustData = (List)this.getUIContext().get("adjustData");
            int i = 0;
            while (i < adjustData.size()) {
                BgFormAdjustData data = (BgFormAdjustData)adjustData.get(i);
                this.tblMain.addRow();
                this.tblMain.getCell(n, 0).setValue((Object)(i + 1 + ""));
                this.tblMain.getCell(n, 1).setValue((Object)data.getOrgName());
                this.tblMain.getCell(n, 2).setValue((Object)data.getBgFormName());
                this.tblMain.getCell(n, 3).setValue((Object)data.getItemNumber());
                this.tblMain.getCell(n, 4).setValue((Object)data.getItemName());
                this.tblMain.getCell(n, 5).setValue((Object)data.getElement());
                this.tblMain.getCell(n, 6).setValue((Object)data.getCurrency());
                this.tblMain.getCell(n, 7).setValue((Object)data.getPeriod());
                if (data.getBadFunction().trim().length() > 0) {
                    this.tblMain.getCell(n, 8).setValue((Object)data.getBadFunction());
                } else {
                    BigDecimal _value = null;
                    DecimalFormat _decFormat = null;
                    _value = data.getAdjustBalance();
                    if (data.getPrecision() == 0) {
                        data.setPrecision(2);
                    }
                    _decFormat = BgNationalFormatUIUtil.getDecimalFormat(data.getPrecision());
                    this.tblMain.getCell(n, 8).setValue((Object)_decFormat.format(_value.doubleValue()));
                }
                ++i;
                ++n;
            }
        }
    }
}

