/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.LanguageManager;
import com.kingdee.bos.ctrl.common.ui.WindowUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.IMouseController;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.TableMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Column;
import com.kingdee.bos.ctrl.excel.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.excel.model.struct.Row;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.BookDataWrapper;
import com.kingdee.bos.ctrl.kdf.excel.wrapper.SXSSFExportWrapper;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.export.ExporterParameter;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.SpreadHelper;
import com.kingdee.eas.fi.newrpt.client.designer.SpreadManager;
import com.kingdee.eas.fi.newrpt.client.designer.io.WizzardIO;
import com.kingdee.eas.fi.newrpt.client.designer.render.IRenderProvider;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormCollectFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgMeasureUnitCollection;
import com.kingdee.eas.ma.budget.BgMeasureUnitInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormCollectFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgAllFormCollectionUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BudgetFormAllDisplayValueProvider;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.OrgUnitRender;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.Excel2007FileFilter;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgAllFormCollectionUI
extends AbstractBgAllFormCollectionUI {
    private static final long serialVersionUID = 8308409815898352218L;
    private static final Logger logger = CoreUIObject.getLogger(BgAllFormCollectionUI.class);
    protected BgFormInfo editData = null;
    protected Sheet tblMain;
    boolean isAdjust = false;
    boolean isBudget = false;
    private BigDecimal coefficient = null;
    private MeasureUnitInfo defMeasureUnit = null;
    public static final String FORM_DATA = "bgform.collection.not.save";
    public static final String ITEMFORMUL_MAP = "bgform.collection.itemformula.map";
    public static final String MEASUREUNIT_MAP = "bgform.collection.MeasreUnitMap.map";
    public static final String is_adjust = "bgform.collection.is.adjust";
    public static final String form_active_sheet_index = "bgforminfo.book.activesheet.index";
    private Book bookMain;
    private Map measureMap = null;
    private Map formulaMap = null;
    private Set companySet = null;
    private Set orgSet = null;
    protected CostCenterOrgUnitInfo defOrgUnitInfo = null;
    protected CostCenterOrgUnitCollection refOrgUnitCol = null;
    protected CurrencyInfo defCurrency = null;
    protected CurrencyInfo currency = null;
    protected Map expandColIndex = null;
    protected Map expandRowIndex = null;
    protected int dataEndRow = -1;
    protected int dataRow = -1;
    private SpreadContext sc = null;
    protected String displayStyle = null;
    private List orgOrderInfo = null;
    protected Map currencyMap = null;

    public BgAllFormCollectionUI() throws Exception {
        int wight = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int height = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() - 40;
        this.setPreferredSize(new Dimension(wight, height));
    }

    protected void loadAllCurrency() throws BOSException, EASBizException {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
    }

    public void onLoad() throws Exception {
        this.measureMap = new HashMap();
        this.formulaMap = new HashMap();
        this.currencyMap = new HashMap();
        this.expandColIndex = new HashMap();
        this.expandRowIndex = new HashMap();
        this.bookMain = Book.Manager.getNewBook((String)this.getUITitle(), (int)0);
        super.onLoad();
        if (this.getUIContext().get("ID") == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"118_BgAllFormCollectionUI"));
            return;
        }
        if (this.getUIContext().get(FORM_DATA) != null) {
            this.editData = (BgFormInfo)this.getUIContext().get(FORM_DATA);
        } else {
            ObjectUuidPK pk = new ObjectUuidPK((String)this.getUIContext().get("ID"));
            if (this.getFormInterface().exists((IObjectPK)pk)) {
                this.editData = this.getFormInterface().getBgFormInfo((IObjectPK)pk, this.getBgFormInfo());
            } else {
                throw new BgException(BgException.NOOBJECT);
            }
        }
        this.coefficient = this.getUIContext().get("GATHER_MEASUREUNIT") != null ? (BigDecimal)this.getUIContext().get("GATHER_MEASUREUNIT") : BgConstants.ONE;
        if (this.getUIContext().get(MEASUREUNIT_MAP) != null) {
            this.measureMap = new HashMap();
            this.getMeasureMap().putAll((Map)this.getUIContext().get(MEASUREUNIT_MAP));
        }
        this.isBudget = this.getUIContext().get("GATHER_TYPE") != null ? (Boolean)this.getUIContext().get("GATHER_TYPE") : true;
        if (this.getUIContext().get(is_adjust) != null) {
            this.isAdjust = (Boolean)this.getUIContext().get(is_adjust);
        }
        this.displayStyle = this.getUIContext().get("GATHER_VIEW_TYPE") != null ? (String)this.getUIContext().get("GATHER_VIEW_TYPE") : "GATHER_VIEW_TYPE_ITEM";
        if (this.getUIContext().get("GATHER_ORGUNIT_SORT") != null) {
            this.orgOrderInfo = new ArrayList();
            this.orgOrderInfo.addAll((Collection)this.getUIContext().get("GATHER_ORGUNIT_SORT"));
        }
        try {
            this.loadAllCurrency();
            this.loadAllTableStyle();
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        this.companySet = null;
        if (this.companySet == null || this.companySet.isEmpty()) {
            this.companySet = new HashSet();
            try {
                this.companySet = this.getInterface().getsourceOrgSet((IObjectValue)this.editData, true);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        if (this.orgSet == null) {
            this.orgSet = this.getInterface().getsourceOrgSet((IObjectValue)this.editData, false);
        }
        this.sc.repaint();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExpandAll.setIcon(UIManager.getIcon("Tree.tbtn_open_menu"));
        this.btnFoldAll.setIcon(UIManager.getIcon("Tree.tbtn_close_menu"));
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.getUIWindow() instanceof Dialog) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
            ((Dialog)this.getUIWindow()).setSize(new Dimension(dimension.width - (insets.right - insets.left), dimension.height - (insets.bottom - insets.top)));
        }
    }

    private void setTreeDisplayStyle(Sheet table, Row row, NumberExpandInfo expandInfo, int colIndex) {
        this.expandTable(table, row, expandInfo, colIndex);
    }

    private void setTreeDisplayStyle(Sheet table, Column column, NumberExpandInfo expandInfo, int rowIndex) {
        this.expandTable(table, column, expandInfo, rowIndex);
    }

    protected void expandTable(Sheet table, Row row, NumberExpandInfo parentExpandInfo, int colIndex) {
        if (table == null || row == null || parentExpandInfo == null || parentExpandInfo.isLeaf()) {
            return;
        }
        Row child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(colIndex, true), (NumberExpandInfo)parentExpandInfo);
            int rowCount = table.getMaxRowIndex() + 1;
            for (int rowIndex = row.getRow() + 1; rowIndex < rowCount; ++rowIndex) {
                child = table.getRow(rowIndex, true);
                expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)child.getCell(colIndex, true));
                if (expandInfo == null) continue;
                longnumber = expandInfo.getLongNumber();
                if (longnumber.startsWith(plongnumber + "!")) {
                    BgNFSHelper.setHided((Row)child, (boolean)true);
                    continue;
                }
                break;
            }
        } else {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            int rowCount = table.getMaxRowIndex() + 1;
            if (!parentExpandInfo.isHasExpendData()) {
                parentExpandInfo.setHasExpendData(true);
                this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
            } else {
                for (rowIndex = row.getRow() + 1; rowIndex < rowCount; ++rowIndex) {
                    child = table.getRow(rowIndex, true);
                    expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)child.getCell(colIndex, true));
                    if (expandInfo == null) continue;
                    longnumber = expandInfo.getLongNumber();
                    if (!longnumber.startsWith(plongnumber + "!")) break;
                    BgNFSHelper.setHided((Row)child, (boolean)false);
                    if (expandInfo.isHasExpendData()) {
                        expandInfo.setExpandStatus(true);
                    } else {
                        expandInfo.setExpandStatus(false);
                    }
                    BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowIndex, colIndex, true), (NumberExpandInfo)expandInfo);
                }
            }
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(colIndex, true), (NumberExpandInfo)parentExpandInfo);
        }
    }

    protected void expandTable(Sheet table, Column column, NumberExpandInfo parentExpandInfo, int rowIndex) {
        if (table == null || column == null || parentExpandInfo == null || parentExpandInfo.isLeaf()) {
            return;
        }
        Column child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowIndex, column.getCol(), true), (NumberExpandInfo)parentExpandInfo);
            int colCount = table.getMaxColIndex() + 1;
            for (int colIndex = column.getCol() + 1; colIndex < colCount; ++colIndex) {
                child = table.getColumn(colIndex, true);
                expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)table.getCell(rowIndex, colIndex, true));
                if (expandInfo == null) continue;
                longnumber = expandInfo.getLongNumber();
                if (longnumber.startsWith(plongnumber + "!")) {
                    BgNFSHelper.setHided((Column)child, (boolean)true);
                    continue;
                }
                break;
            }
        } else {
            int colIndex;
            parentExpandInfo.setExpandStatus(true);
            int colCount = table.getMaxColIndex() + 1;
            if (!parentExpandInfo.isHasExpendData()) {
                parentExpandInfo.setHasExpendData(true);
                this.addChildOrgUnitByRow(table, parentExpandInfo, rowIndex, colIndex);
            } else {
                for (colIndex = column.getCol() + 1; colIndex < colCount; ++colIndex) {
                    child = table.getColumn(colIndex, true);
                    expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)table.getCell(rowIndex, colIndex, true));
                    if (expandInfo == null) continue;
                    longnumber = expandInfo.getLongNumber();
                    if (!longnumber.startsWith(plongnumber + "!")) break;
                    BgNFSHelper.setHided((Column)child, (boolean)false);
                    if (expandInfo.isHasExpendData()) {
                        expandInfo.setExpandStatus(true);
                    } else {
                        expandInfo.setExpandStatus(false);
                    }
                    BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowIndex, colIndex, true), (NumberExpandInfo)expandInfo);
                }
            }
            BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowIndex, column.getCol(), true), (NumberExpandInfo)parentExpandInfo);
        }
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
    }

    private boolean isCol(Sheet table, Row row, int colIndex) {
        NumberExpandInfo info = BgNFCHelper.getNumberExpandInfo((Cell)row.getCell(colIndex, true));
        return info != null && info.getName() != null && info.getName().equals(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"collect"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildOrgUnitByCol(Sheet table, NumberExpandInfo expandInfo, int rowAlias, int colAlias) {
        block10: {
            if (table == null || expandInfo == null) {
                return;
            }
            Row row = null;
            Cell cell = null;
            NumberExpandInfo expand = null;
            CostCenterOrgUnitInfo costCenterOrgUnitInfo2 = null;
            int rowIndex = 0;
            int aliasIndex = 0;
            Map childMap = null;
            try {
                childMap = this.getInterface().getDirectSubOrgInfoFormALLFormView(expandInfo.getLongNumber(), this.companySet);
                if (childMap == null || childMap.isEmpty()) {
                    expandInfo.setLeaf(true);
                    break block10;
                }
                for (rowIndex = rowAlias - 1; rowIndex >= 0; --rowIndex) {
                    cell = table.getCell(rowIndex, colAlias, true);
                    if (cell.getUserObjectValue("NEId") == null || (expand = BgNFCHelper.getNumberExpandInfo((Cell)cell)).getLevel() != 0) continue;
                    aliasIndex = rowIndex;
                    break;
                }
                HashMap<String, Object> orgIdMap = new HashMap<String, Object>();
                HashMap<String, Row> orgIdToRow = new HashMap<String, Row>();
                for (CostCenterOrgUnitInfo costCenterOrgUnitInfo2 : BgClientHelper.getSortedByNumberOrgs(childMap.keySet(), false)) {
                    row = BgNFSHelper.addRow((Sheet)table, (int)rowAlias, (boolean)true);
                    this.dealMergeInfo(table, row);
                    expand = new NumberExpandInfo();
                    expand.setId(costCenterOrgUnitInfo2.getId().toString());
                    expand.setName(costCenterOrgUnitInfo2.getName());
                    expand.setNumber(costCenterOrgUnitInfo2.getNumber());
                    expand.setLongNumber(costCenterOrgUnitInfo2.getLongNumber());
                    expand.setLevel(expandInfo.getLevel() + 1);
                    if (childMap.get(costCenterOrgUnitInfo2) != null && childMap.get(costCenterOrgUnitInfo2) instanceof Boolean && ((Boolean)childMap.get(costCenterOrgUnitInfo2)).booleanValue()) {
                        expand.setLeaf(false);
                    } else {
                        expand.setLeaf(true);
                    }
                    expand.setExpandStatus(false);
                    expand.setHasExpendData(false);
                    expand.setCollect(false);
                    BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(row.getRow(), colAlias, true), (NumberExpandInfo)expand);
                    if (!this.orgSet.contains(costCenterOrgUnitInfo2.getId().toString())) continue;
                    orgIdMap.put(costCenterOrgUnitInfo2.getId().toString(), null);
                    orgIdToRow.put(costCenterOrgUnitInfo2.getId().toString(), row);
                }
                this.fillChildOrgUnitDataByCol(table, orgIdToRow, aliasIndex, colAlias, orgIdMap);
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillChildOrgUnitDataByCol(Sheet table, Map orgIdToRow, int rowAlias, int colAlias, Map orgIdMap) {
        if (table == null || orgIdToRow == null || orgIdMap == null || orgIdMap.isEmpty() || orgIdToRow.isEmpty()) {
            return;
        }
        Object _obj = null;
        Row row = null;
        Cell cell = null;
        Cell sCell = null;
        String formulaString = null;
        Map formulaDataMap = null;
        HashSet<String> formulaSet = new HashSet<String>();
        int colIndex = 0;
        int colCount = 0;
        try {
            String rootId = null;
            rootId = this.editData.getBgScheme().getRootId() == null ? this.editData.getBgScheme().getRootId().toString() : this.editData.getBgScheme().getId().toString();
            String orgid2 = null;
            for (String orgid2 : orgIdMap.keySet()) {
                row = (Row)orgIdToRow.get(orgid2);
                if (row == null) continue;
                colCount = table.getMaxColIndex() + 1;
                for (colIndex = 0; colIndex < colCount; ++colIndex) {
                    sCell = table.getCell(rowAlias, colIndex, true);
                    cell = table.getCell(row.getRow(), colIndex, true);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)sCell)) continue;
                    formulaString = BgNFSHelper.getFormulaOfCell((Cell)sCell);
                    formulaSet.add(formulaString);
                    BgNFSHelper.setFormulaOfCell((Cell)cell, (String)formulaString, (boolean)true);
                    this.setMearureUnitOfCell(cell, true);
                }
            }
            orgIdMap = this.getInterface().getBgDataALLCelect(rootId, formulaSet, orgIdMap, this.isAdjust, this.isBudget);
            if (orgIdMap != null) {
                for (String orgid2 : orgIdMap.keySet()) {
                    formulaDataMap = (Map)orgIdMap.get(orgid2);
                    row = (Row)orgIdToRow.get(orgid2);
                    if (row == null || formulaDataMap == null || formulaDataMap.isEmpty()) continue;
                    colCount = table.getMaxColIndex() + 1;
                    for (colIndex = colAlias + 1; colIndex < colCount; ++colIndex) {
                        cell = table.getCell(row.getRow(), colIndex, true);
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                            _obj = formulaDataMap.get(formulaString);
                            if (_obj instanceof BigDecimal) {
                                BgNFSHelper.setValue((Cell)cell, _obj);
                            } else if (_obj instanceof String) {
                                BgNFSHelper.setValue((Cell)cell, (Object)new BigDecimal(_obj.toString()));
                            } else {
                                BgNFSHelper.setValue((Cell)cell, _obj);
                            }
                        } else {
                            BgNFSHelper.setValue((Cell)cell, null);
                        }
                        if (cell == null) continue;
                        StyleAttributes sa = Styles.getEmptySA();
                        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        if (cell.getSheet().getRange(cell) != null && !cell.getSSA().isEmpty()) {
                            sa.setWeight(cell.getSheet().getRange(cell).getColumnWidth().floatValue());
                        }
                        cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    protected void fillCollectRowData(Sheet table, Row collRow, int colAlias) {
        int rowBegin;
        if (table == null || collRow == null) {
            return;
        }
        int rowEnd = rowBegin = collRow.getRow() + 1;
        int rowIndex = 0;
        int rowCount = table.getMaxRowIndex() + 1;
        int colIndex = 0;
        int colCount = table.getMaxColIndex() + 1;
        Cell cell = null;
        Row row = null;
        NumberExpandInfo expandInfo = null;
        NumberExpandInfo tmpExpand = null;
        BigDecimal value = null;
        expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)collRow.getCell(colAlias, false));
        for (rowIndex = rowBegin; rowIndex < rowCount; ++rowIndex) {
            row = table.getRow(rowIndex, true);
            cell = row.getCell(colAlias, true);
            if (cell.getValue() == Variant.nullVariant || cell.getUserObject("NEId") == null) continue;
            tmpExpand = BgNFCHelper.getNumberExpandInfo((Cell)cell);
            if (expandInfo.getLevel() != tmpExpand.getLevel()) break;
            rowEnd = rowIndex;
        }
        for (colIndex = 0; colIndex < colCount; ++colIndex) {
            if (!BgNFSHelper.checkHasFormulaOfCol((Sheet)table, (int)colIndex, (int)rowBegin, (int)(rowEnd + 1))) continue;
            value = BgConstants.BIGZERO;
            for (rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                cell = table.getCell(rowIndex, colIndex, true);
                if (cell == null || cell.getValue() == null) continue;
                try {
                    value = value.add(new BigDecimal(cell.getValue().toString().replaceAll(",", "")));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            BgNFSHelper.setValue((Cell)collRow.getCell(colIndex, true), (Object)value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChildOrgUnitByRow(Sheet table, NumberExpandInfo expandInfo, int rowAlias, int colAlias) {
        if (table == null || expandInfo == null) {
            return;
        }
        Column column = null;
        Cell cell = null;
        NumberExpandInfo expand = null;
        CostCenterOrgUnitInfo orgUnitInfo2 = null;
        int colIndex = 0;
        int aliasIndex = 0;
        int size = 0;
        String orgUnitId = null;
        Map childMap = null;
        try {
            if (this.orgOrderInfo != null && !this.orgOrderInfo.isEmpty()) {
                childMap = this.getQueryOrgUnitInfo(this.orgOrderInfo);
                int in = this.orgOrderInfo.size();
                for (int i = 0; i < in; ++i) {
                    orgUnitId = (String)this.orgOrderInfo.get(i);
                    if (!this.orgSet.contains(orgUnitId)) continue;
                    orgUnitInfo2 = (CostCenterOrgUnitInfo)childMap.get(orgUnitId);
                    column = BgNFSHelper.addColumn((Sheet)table, (int)(colAlias + size), (boolean)true);
                    expand = new NumberExpandInfo();
                    expand.setId(orgUnitInfo2.getId().toString());
                    expand.setName(orgUnitInfo2.getName());
                    expand.setNumber(orgUnitInfo2.getNumber());
                    expand.setLongNumber(orgUnitInfo2.getLongNumber());
                    expand.setLevel(expandInfo.getLevel() + 1);
                    expand.setLeaf(true);
                    expand.setExpandStatus(false);
                    expand.setHasExpendData(true);
                    expand.setCollect(false);
                    BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowAlias, column.getCol(), true), (NumberExpandInfo)expand);
                    ++size;
                }
                this.fillChildDataByRow(table, expandInfo, childMap, rowAlias, colAlias, size);
            } else {
                childMap = this.getInterface().getDirectSubOrgInfoFormALLFormView(expandInfo.getLongNumber(), this.companySet);
                if (childMap == null || childMap.isEmpty()) {
                    expandInfo.setLeaf(true);
                } else {
                    for (colIndex = colAlias - 1; colIndex >= 0; --colIndex) {
                        cell = table.getCell(rowAlias, colIndex, true);
                        if (cell.getUserObjectValue("NEId") == null || (expand = BgNFCHelper.getNumberExpandInfo((Cell)cell)).getLevel() != 0) continue;
                        aliasIndex = colIndex;
                        break;
                    }
                    HashMap orgIdMap = new HashMap();
                    HashMap<String, Column> orgIdToCol = new HashMap<String, Column>();
                    int i = 0;
                    for (CostCenterOrgUnitInfo orgUnitInfo2 : BgClientHelper.getSortedByNumberOrgs(childMap.keySet(), true)) {
                        column = BgNFSHelper.addColumn((Sheet)table, (int)(colAlias + i), (boolean)true);
                        expand = new NumberExpandInfo();
                        expand.setId(orgUnitInfo2.getId().toString());
                        expand.setName(orgUnitInfo2.getName());
                        expand.setNumber(orgUnitInfo2.getNumber());
                        expand.setLongNumber(orgUnitInfo2.getLongNumber());
                        expand.setLevel(expandInfo.getLevel() + 1);
                        if (childMap.get(orgUnitInfo2) != null && childMap.get(orgUnitInfo2) instanceof Boolean && ((Boolean)childMap.get(orgUnitInfo2)).booleanValue()) {
                            expand.setLeaf(false);
                        } else {
                            expand.setLeaf(true);
                        }
                        expand.setExpandStatus(false);
                        expand.setHasExpendData(false);
                        expand.setCollect(false);
                        BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowAlias, column.getCol(), true), (NumberExpandInfo)expand);
                        orgIdMap.clear();
                        orgIdToCol.clear();
                        if (this.orgSet.contains(orgUnitInfo2.getId().toString())) {
                            orgIdMap.put(orgUnitInfo2.getId().toString(), null);
                            orgIdToCol.put(orgUnitInfo2.getId().toString(), column);
                        }
                        this.fillChildDataByRow(table, orgIdToCol, aliasIndex, rowAlias, orgIdMap);
                        ++i;
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getQueryOrgUnitInfo(List orgUnitInfo) {
        if (orgUnitInfo == null || orgUnitInfo.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, CostCenterOrgUnitInfo> tmpMap = new HashMap<String, CostCenterOrgUnitInfo>();
        HashSet orgUnitSet = new HashSet();
        orgUnitSet.addAll(orgUnitInfo);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgUnitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("longnumber");
        sic.add("level");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        CostCenterOrgUnitInfo info = null;
        CostCenterOrgUnitCollection collection = null;
        try {
            collection = this.getOrgUnitInterface().getCostCenterOrgUnitCollection(view);
            if (collection != null) {
                int in = collection.size();
                for (int i = 0; i < in; ++i) {
                    info = collection.get(i);
                    tmpMap.put(info.getId().toString(), info);
                }
            }
        }
        catch (BOSException ex) {
            this.handUIExceptionAndAbort((Exception)((Object)ex));
        }
        return tmpMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fillChildDataByRow(Sheet table, Map orgIdToCol, int aliasIndex, int rowAlias, Map orgIdMap) {
        if (table == null || orgIdToCol == null || orgIdMap == null || orgIdMap.isEmpty() || orgIdToCol.isEmpty()) {
            return;
        }
        Column column = null;
        Cell cell = null;
        Cell sCell = null;
        String formulaString = null;
        Map formulaDataMap = null;
        HashSet<String> formulaSet = new HashSet<String>();
        int rowIndex = 0;
        int rowCount = 0;
        try {
            String rootId = null;
            rootId = this.editData.getBgScheme().getRootId() == null ? this.editData.getBgScheme().getRootId().toString() : this.editData.getBgScheme().getId().toString();
            String orgid2 = null;
            for (String orgid2 : orgIdMap.keySet()) {
                if (orgIdToCol.get(orgid2) == null) continue;
                column = (Column)orgIdToCol.get(orgid2);
                rowCount = table.getMaxRowIndex() + 1;
                for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    sCell = table.getCell(rowIndex, aliasIndex, true);
                    cell = table.getCell(rowIndex, column.getCol(), true);
                    if (!BgNFSHelper.checkHasFormulaOfCell((Cell)sCell)) continue;
                    formulaString = BgNFSHelper.getFormulaOfCell((Cell)sCell);
                    formulaSet.add(formulaString);
                    BgNFSHelper.setFormulaOfCell((Cell)cell, (String)formulaString, (boolean)true);
                    this.setMearureUnitOfCell(cell, true);
                }
            }
            orgIdMap = this.getInterface().getBgDataALLCelect(rootId, formulaSet, orgIdMap, this.isAdjust, this.isBudget);
            if (orgIdMap != null) {
                for (String orgid2 : orgIdMap.keySet()) {
                    formulaDataMap = (Map)orgIdMap.get(orgid2);
                    column = (Column)orgIdToCol.get(orgid2);
                    if (column == null || formulaDataMap == null || formulaDataMap.isEmpty()) continue;
                    rowCount = table.getMaxRowIndex() + 1;
                    for (rowIndex = rowAlias + 1; rowIndex < rowCount; ++rowIndex) {
                        cell = table.getCell(rowIndex, column.getCol(), true);
                        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                            formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                            BgNFSHelper.setValue((Cell)cell, formulaDataMap.get(formulaString));
                        } else {
                            BgNFSHelper.setValue((Cell)cell, null);
                        }
                        if (cell == null) continue;
                        StyleAttributes sa = Styles.getEmptySA();
                        sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                        if (cell.getSheet().getRange(cell) != null && !cell.getSSA().isEmpty()) {
                            sa.setWeight(cell.getSheet().getRange(cell).getColumnWidth().floatValue());
                        }
                        cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
    }

    protected void fillChildDataByRow(Sheet table, NumberExpandInfo expendInfo, Map orgUnitMap, int rowAlias, int colAlias, int size) {
        if (table == null || expendInfo == null) {
            return;
        }
        String _formulaStr = null;
        String _orgUnitId = null;
        String _key = null;
        ArrayList<String> formulaList = new ArrayList<String>();
        Cell cell = null;
        NumberExpandInfo _expandInfo = null;
        int rowCount = table.getMaxRowIndex();
        int colCount = table.getMaxColIndex();
        for (int rowIndex = rowAlias + 1; rowIndex <= rowCount; ++rowIndex) {
            cell = table.getCell(rowIndex, colAlias - 1, false);
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
            _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
            formulaList.add(_formulaStr);
            this.setMearureUnitOfCell(cell, true);
        }
        Map tmpMap = null;
        try {
            tmpMap = this.getInterface().queryBgDataInfo(this.editData.getBgScheme().getRootId().toString(), this.orgOrderInfo, formulaList, this.isAdjust);
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
        for (int rowIndex = rowAlias + 1; rowIndex <= rowCount; ++rowIndex) {
            cell = table.getCell(rowIndex, colAlias - 1, true);
            if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
            _formulaStr = BgNFSHelper.getFormulaOfCell((Cell)cell);
            for (int colIndex = 0; colIndex < size; ++colIndex) {
                cell = table.getCell(rowAlias, colAlias + colIndex, true);
                _expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
                if (_expandInfo != null) {
                    _orgUnitId = _expandInfo.getId();
                    _key = _orgUnitId + "_" + _formulaStr;
                    cell = table.getCell(rowIndex, colAlias + colIndex, true);
                    BgNFSHelper.setFormulaOfCell((Cell)cell, (String)_formulaStr, (boolean)true);
                    if (tmpMap.containsKey(_key)) {
                        BgNFSHelper.setValue((Cell)cell, tmpMap.get(_key));
                    } else {
                        BgNFSHelper.setValue((Cell)cell, (Object)BgNConstants.ZERO);
                    }
                }
                if (cell == null) continue;
                StyleAttributes sa = Styles.getEmptySA();
                sa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (cell.getSheet().getRange(cell) != null && !cell.getSSA().isEmpty()) {
                    sa.setWeight(cell.getSheet().getRange(cell).getColumnWidth().floatValue());
                }
                cell.getSheet().getRange(cell).setStyle(sa, Styles.getEmptySA());
            }
        }
    }

    protected IBgForm getFormInterface() throws BOSException {
        return BgFormFactory.getRemoteInstance();
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }

    protected ICostCenterOrgUnit getOrgUnitInterface() throws BOSException {
        return CostCenterOrgUnitFactory.getRemoteInstance();
    }

    private IBgFormCollectFacade getInterface() throws BOSException {
        return BgFormCollectFacadeFactory.getRemoteInstance();
    }

    protected void loadAllTableStyle() throws BOSException, EASBizException {
        int sheetIndex = 0;
        int sheetCount = 0;
        Book book = null;
        Sheet nSheet = null;
        this.pnlMain.removeAll();
        this.defOrgUnitInfo = this.getOrgUnitInterface().getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.editData.getOrgUnit().getId()));
        this.defCurrency = this.editData.getCurrency();
        if (this.editData.getMeasureUnit() != null) {
            this.defMeasureUnit = this.editData.getMeasureUnit();
        }
        if (this.defMeasureUnit == null) {
            this.defMeasureUnit = new MeasureUnitInfo();
            this.defMeasureUnit.setCoefficient(new BigDecimal("1"));
        }
        if (this.editData.getBgMeasureUnit() != null && !this.editData.getBgMeasureUnit().isEmpty()) {
            BgMeasureUnitInfo bgMuInfo = null;
            BgMeasureUnitCollection bgMuColl = this.editData.getBgMeasureUnit();
            int n = bgMuColl.size();
            for (int i = 0; i < n; ++i) {
                bgMuInfo = bgMuColl.get(i);
                this.measureMap.put(bgMuInfo.getBgElement().getNumber(), bgMuInfo.getMeasureUnit());
            }
        }
        try {
            book = this.editData.getBook();
        }
        catch (Exception ex) {
            throw new BgException(BgException.UNSERIALIZABLEERROR, ex, new String[]{ex.getMessage()});
        }
        BgNFSHelper.disableCal((Book)book);
        BgNFSHelper.disableUndo((Book)book);
        if (book == null) {
            return;
        }
        sheetCount = book.getSheetCount();
        this.bookMain = book;
        if (this.displayStyle.equals("GATHER_VIEW_TYPE_ITEM")) {
            for (sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                nSheet = this.bookMain.getSheet(sheetIndex);
                this.dealOrgUnitColInfo(nSheet);
            }
        } else {
            for (sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
                nSheet = this.bookMain.getSheet(sheetIndex);
                this.dealOrgUnitRowInfo(nSheet);
            }
        }
        this.addBookToPanel(this.pnlMain, false);
        if (this.getUIContext().get(form_active_sheet_index) != null) {
            int index = 0;
            try {
                index = Integer.valueOf((String)this.getUIContext().get(form_active_sheet_index));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.bookMain.activeSheet(index);
        } else {
            this.bookMain.activeSheet(0);
        }
        this.pnlMain.setSelectedIndex(0);
        BgNFSHelper.setAllCellLocked((Book)this.bookMain, (boolean)true);
    }

    private void addBookToPanel(KDTabbedPane paneMain, boolean b) {
        this.sc = new SpreadContext();
        this.sc.setBook(this.bookMain);
        this.sc.setName(this.getUITitle());
        this.sc.getSpread().setMouseController(3, (IMouseController)new MyTableMouseController(this.sc));
        SpreadManager.registerRenderProvider((IRenderProvider)new OrgUnitRender());
        BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
        a.setDisplayValueProvider(new BudgetFormAllDisplayValueProvider((Component)((Object)this)));
        a.addRenderProvider(new OrgUnitRender());
        this.sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
        paneMain.add((Component)this.sc, (Object)"Center");
        paneMain.setTitleAt(0, this.getUITitle());
        BgNFSHelper.setFocusOfCell((SpreadContext)this.sc);
    }

    protected void cell_select_change() {
    }

    public Sheet getSheetPage() throws Exception {
        Book book = this.getCurrentPage();
        Sheet sheet = null;
        sheet = book.getActiveSheet();
        if (sheet == null) {
            throw new BgException(BgException.CHECKBLANK, new String[]{"Sheet"});
        }
        return sheet;
    }

    public Book getCurrentPage() throws Exception {
        Book book = null;
        KDPanel panel = (KDPanel)this.pnlMain.getSelectedComponent();
        int n = panel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            if (!(panel.getComponent(i) instanceof KDSpread)) continue;
            book = ((KDSpread)panel.getComponent(i)).getBook();
            break;
        }
        if (book == null) {
            return this.bookMain;
        }
        return book;
    }

    protected void dealOrgUnitColInfo(Sheet table) {
        if (table == null) {
            return;
        }
        String alias = null;
        Row row = null;
        Column column = null;
        NumberExpandInfo expandInfo = null;
        int rowCount = table.getMaxRowIndex() + 1;
        int colCount = table.getMaxColIndex() + 1;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            column = table.getColumn(colIndex, true);
            alias = (String)BgNFSHelper.getColObject((Column)column, (String)"SIGN_DATA_ID");
            if (alias == null) continue;
            this.expandColIndex.put(table.getID(), new Integer(colIndex - 1));
            break;
        }
        if (this.expandColIndex.get(table.getID()) == null) {
            return;
        }
        if ((Integer)this.expandColIndex.get(table.getID()) == -1) {
            column = BgNFSHelper.addColumn((Sheet)table, (int)0, (boolean)false);
            this.expandColIndex.put(table.getID(), new Integer(0));
        } else {
            column = table.getColumn(((Integer)this.expandColIndex.get(table.getID())).intValue(), true);
        }
        colCount = table.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = table.getRow(rowIndex, true);
            if (!BgNFSHelper.checkHasFormulaOfRow((Row)row, (int)colCount)) continue;
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(this.defOrgUnitInfo.getId().toString());
            expandInfo.setName(this.defOrgUnitInfo.getName());
            expandInfo.setNumber(this.defOrgUnitInfo.getNumber());
            expandInfo.setLongNumber(this.defOrgUnitInfo.getLongNumber());
            expandInfo.setLevel(0);
            expandInfo.setLeaf(false);
            expandInfo.setCollect(false);
            expandInfo.setExpandStatus(false);
            expandInfo.setHasExpendData(false);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(column.getCol(), true), (NumberExpandInfo)expandInfo);
        }
    }

    protected void dealOrgUnitRowInfo(Sheet table) {
        if (table == null) {
            return;
        }
        Row row = null;
        NumberExpandInfo expandInfo = null;
        int rowCount = table.getMaxRowIndex() + 1;
        int colCount = table.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            row = table.getRow(rowIndex, true);
            if (!BgNFSHelper.checkHasFormulaOfRow((Row)row, (int)colCount)) continue;
            this.expandRowIndex.put(table.getID(), new Integer(rowIndex - 1));
            break;
        }
        if (this.expandRowIndex.get(table.getID()) == null) {
            return;
        }
        if ((Integer)this.expandRowIndex.get(table.getID()) == -1) {
            row = BgNFSHelper.addRow((Sheet)table, (int)0, (boolean)true);
            this.expandRowIndex.put(table.getID(), new Integer(0));
        } else {
            row = BgNFSHelper.addRow((Sheet)table, (int)((Integer)this.expandRowIndex.get(table.getID()) + 1), (boolean)true);
            this.expandRowIndex.put(table.getID(), new Integer(row.getRow()));
        }
        int rowBegin = (Integer)this.expandRowIndex.get(table.getID());
        rowCount = table.getMaxRowIndex() + 1;
        for (int colIndex = 0; colIndex < colCount; ++colIndex) {
            if (!BgNFSHelper.checkHasFormulaOfCol((Sheet)table, (int)colIndex, (int)rowBegin, (int)rowCount)) continue;
            expandInfo = new NumberExpandInfo();
            expandInfo.setId(this.defOrgUnitInfo.getId().toString());
            expandInfo.setName(this.defOrgUnitInfo.getName());
            expandInfo.setNumber(this.defOrgUnitInfo.getNumber());
            expandInfo.setLongNumber(this.defOrgUnitInfo.getLongNumber());
            expandInfo.setLevel(0);
            expandInfo.setLeaf(false);
            expandInfo.setCollect(false);
            expandInfo.setExpandStatus(false);
            expandInfo.setHasExpendData(false);
            BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowBegin, colIndex, true), (NumberExpandInfo)expandInfo);
        }
    }

    protected void dealMergeManager(Sheet nSheet, Sheet sheet) {
        MergeBlocks mblist;
        if (nSheet == null || sheet == null) {
            return;
        }
        int rowBegin = 0;
        int rowEnd = 0;
        int colBegin = 0;
        int colEnd = 0;
        Cell cell = null;
        Variant obj = null;
        CellBlock _block = null;
        if (sheet.getMerger(false) != null && (mblist = sheet.getMerger(false)) != null && !mblist.isEmpty()) {
            int maxRowIndex = sheet.getMaxRowIndex();
            int maxColIndex = sheet.getMaxColIndex();
            for (int n = 0; n < mblist.getBlocksColumnNum(); ++n) {
                _block = mblist.getBlock(n);
                rowBegin = _block.getRow();
                rowEnd = _block.getRow2() > maxRowIndex ? maxRowIndex : _block.getRow2();
                colBegin = _block.getCol();
                colEnd = _block.getCol2() > maxColIndex ? maxColIndex : _block.getCol2();
                obj = sheet.getCell(rowBegin, colBegin, true).getValue();
                sheet.getCell(rowBegin, colBegin, true).getStyle();
                if (rowEnd < this.dataRow || this.dataRow < this.dataEndRow && rowEnd > this.dataEndRow) {
                    nSheet.getCell(rowBegin, colBegin, true).setSSA(sheet.getCell(rowBegin, colBegin, true).getSSA());
                    nSheet.getRange(rowBegin, colBegin, rowEnd, colEnd).merge();
                    continue;
                }
                if (obj == null) continue;
                for (int rowIndex = rowBegin; rowIndex <= rowEnd; ++rowIndex) {
                    for (int colIndex = colBegin; colIndex <= colEnd; ++colIndex) {
                        cell = nSheet.getCell(rowIndex, colIndex, true);
                        if (cell == null) continue;
                        BgNFSHelper.setValue((Cell)cell, (Object)obj);
                    }
                }
            }
        }
    }

    private void dealMergeInfo(Sheet table, Row row) {
        if (table == null || row == null) {
            return;
        }
        MergeBlocks mm = table.getMerger(true);
        if (mm != null) {
            CellBlock mb = null;
            int n = mm.getBlocksColumnNum();
            for (int i = 0; i < n; ++i) {
                mb = mm.getBlock(i);
                if (row.getRow() != mb.getRow2() + 1) continue;
                mb.setRow2(mb.getRow2() + 1);
            }
        }
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, Cell cell, Object svalue) {
        if (svalue == null) {
            return svalue;
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
            String formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String[] parameter = BgFSHelper.getFormulaInfo(this.formulaMap, formulaString);
            int precision = 0;
            BigDecimal measure = BgConstants.ONE;
            BigDecimal value = null;
            String currencyNumber = null;
            CurrencyInfo currencyInfo = null;
            if (parameter != null && parameter[2] != null) {
                if (this.measureMap.containsKey(parameter[2])) {
                    MeasureUnitInfo measureInfo = (MeasureUnitInfo)this.measureMap.get(parameter[2]);
                    measure = measureInfo.getCoefficient();
                } else {
                    measure = this.defMeasureUnit.getCoefficient();
                }
            }
            if (this.currencyMap.containsKey(currencyNumber = parameter != null && parameter[3] != null ? parameter[3] : this.defCurrency.getNumber())) {
                currencyInfo = (CurrencyInfo)this.currencyMap.get(currencyNumber);
                precision = currencyInfo.getPrecision();
            } else {
                precision = 8;
            }
            String text = null;
            try {
                value = new BigDecimal(svalue.toString().replaceAll(",", "")).divide(measure, precision, 4);
                DecimalFormat decFormat = BgNationalFormatUIUtil.getDecimalFormat(precision);
                text = decFormat.format(value.doubleValue());
            }
            catch (Exception ex) {
                text = svalue.toString();
            }
            return text;
        }
        if (BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
            String text = null;
            int precision = this.defCurrency.getPrecision();
            BigDecimal measure = this.defMeasureUnit.getCoefficient();
            BigDecimal value = null;
            try {
                value = new BigDecimal(svalue.toString().replaceAll(",", "")).divide(measure, precision, 4);
                DecimalFormat decFormat = BgNationalFormatUIUtil.getDecimalFormat(precision);
                text = decFormat.format(value.doubleValue());
            }
            catch (Exception ex) {
                text = svalue.toString();
            }
            return text;
        }
        return svalue.toString();
    }

    protected void copyStyleFromTable(Sheet nSheet, Sheet sheet) {
        if (nSheet == null || sheet == null) {
            return;
        }
        Row row = null;
        Row sRow = null;
        Column column = null;
        Column sColumn = null;
        Cell cell = null;
        Cell sCell = null;
        String alias = null;
        int rowIndex = 0;
        int colIndex = 0;
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        sheet.getBook().setCalculate(false);
        BgNFSHelper.addRows((Sheet)nSheet, (int)rowIndex, (int)rowCount, (boolean)true);
        BgNFSHelper.addColumns((Sheet)nSheet, (int)colIndex, (int)colCount, (boolean)true);
        for (rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            sRow = sheet.getRow(rowIndex, true);
            if (sRow == null || !BgNFSHelper.checkHasSign((Row)sRow)) continue;
            alias = BgNFSHelper.getRowSign((Row)sRow);
            row = nSheet.getRow(rowIndex, true);
            BgNFSHelper.setRowObject((Row)row, (String)"SIGN_DATA_ID", (Object)alias);
            for (colIndex = 0; colIndex < colCount; ++colIndex) {
                sColumn = sheet.getColumn(colIndex, true);
                if (sColumn == null || !BgNFSHelper.checkHasSign((Column)sColumn)) continue;
                alias = BgNFSHelper.getColSign((Column)sColumn);
                column = nSheet.getColumn(colIndex, true);
                BgNFSHelper.setColSign((Column)column, (String)alias);
                sCell = sheet.getCell(rowIndex, colIndex, true);
                cell = nSheet.getCell(rowIndex, colIndex, true);
                this.copyDataFormCell(cell, sCell);
            }
            if (!BgNFSHelper.checkHasFormulaOfRow((Row)row, (int)colCount) || this.dataEndRow >= rowIndex) continue;
            this.dataEndRow = rowIndex;
        }
    }

    protected boolean checkHasAliasByRow(Row row) {
        return BgNFSHelper.checkHasSign((Row)row);
    }

    protected boolean checkHasAliasByCol(Column column) {
        return BgNFSHelper.checkHasSign((Column)column);
    }

    protected void copyDataFormCell(Cell cell, Cell style) {
        if (cell == null || style == null) {
            return;
        }
        if (style.getValue() != Variant.nullVariant) {
            cell.setValue(style.getValue());
        }
        if (style.getSSA().getNumberFormat() != null) {
            BgNFSHelper.setNumberFormat((Cell)cell, (String)style.getSSA().getNumberFormat());
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)style)) {
            if (this.dataRow == -1) {
                this.dataRow = style.getRow();
            }
            String formulaString = BgNFSHelper.getFormulaOfCell((Cell)style);
            String valueString = this.getExpInfo(style, "BG_BUDGET_VALUE");
            valueString = valueString == null || "".equals(valueString) ? BgConstants.BIGZERO.toString() : valueString;
            BgNFSHelper.setFormulaOfCell((Cell)cell, (String)formulaString, (boolean)true);
        }
    }

    protected String getExpInfo(Cell cell, String key) {
        if (cell == null || key == null) {
            return "";
        }
        if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
            return BgNFSHelper.getItemFormula((Cell)cell).getExt(key);
        }
        return "";
    }

    protected void setMearureUnitOfCell(Cell cell, boolean hasFormula) {
    }

    protected void initMeasureUnitInfo() throws Exception {
        this.setMeasureMap(BgNFSHelper.getMeasureUnitMap((BgFormInfo)this.getBgFormInfo(this)));
        if (this.getMeasureMap() == null) {
            this.setMeasureMap(new HashMap());
        }
    }

    protected void upateMeasureUnitValue(Cell cell) {
        if (cell != null && !BgNFSHelper.checkIsEmptyValue((Cell)cell)) {
            if (BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) {
                if (!this.getMeasureMap().isEmpty()) {
                    this.upateMeasureUnitValue(cell);
                } else {
                    this.upateDefMeasureUnitValue(cell);
                }
            } else {
                this.upateDefMeasureUnitValue(cell);
            }
        }
    }

    protected void upateDefMeasureUnitValue(Cell cell) {
        if (BgNFSHelper.checkIsNumericOfCell((Cell)cell)) {
            BigDecimal _value = null;
            BigDecimal _coefficient = this.getBgFormInfo(this).getMeasureUnit().getCoefficient();
            _value = (BigDecimal)BgNFSHelper.getValue((Cell)cell);
            if (_coefficient != null) {
                _value = _value.multiply(_coefficient);
            }
            this.updateCellValue(cell, _value);
        }
    }

    protected void updateCellValue(Cell cell, BigDecimal value) {
        BgNFSHelper.setValue((Cell)cell, (Object)value);
    }

    public BgFormInfo getBgFormInfo(BgAllFormCollectionUI editUI) {
        return this.editData;
    }

    protected Map getFormulaMap(Sheet sheet, Map formulaMap) {
        if (sheet == null || formulaMap == null) {
            return null;
        }
        Cell cell = null;
        String formulaString = null;
        String localString = null;
        int rowCount = sheet.getMaxRowIndex() + 1;
        int colCount = sheet.getMaxColIndex() + 1;
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                cell = sheet.getCell(rowIndex, colIndex, true);
                if (!BgNFSHelper.checkHasFormulaOfCell((Cell)cell)) continue;
                formulaString = BgNFSHelper.getFormulaOfCell((Cell)cell);
                localString = TableToolkit.xy2range((int)colIndex, (int)rowIndex);
                formulaMap.put(formulaString, localString);
            }
        }
        return formulaMap;
    }

    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    protected BigDecimal getCoefficient() {
        return this.coefficient;
    }

    protected void setCoefficient(BigDecimal coefficient) {
        this.coefficient = coefficient;
    }

    protected Map getMeasureMap() {
        return this.measureMap;
    }

    protected void setMeasureMap(Map measureMap) {
        this.measureMap = measureMap;
    }

    @Override
    protected void btnExport_actionPerformed(ActionEvent e) throws Exception {
        this.actionExpandAll_actionPerformed(null);
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"fileExport"));
        fc.addChoosableFileFilter((FileFilter)new Excel2007FileFilter());
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        StringBuffer titleName = new StringBuffer();
        if (this.editData != null && this.editData.getName() != null) {
            titleName.append(this.editData.getName());
        }
        titleName.append("-");
        titleName.append(this.getUITitle());
        titleName.append("-");
        if (this.displayStyle.equals("GATHER_VIEW_TYPE_ITEM")) {
            titleName.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"byItemDisplay"));
        } else {
            titleName.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemImportResource", (String)"byOrgDisplay"));
        }
        fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + "//" + titleName.toString().trim() + ".xls"));
        if (fc.showSaveDialog((Component)((Object)this)) == 0) {
            FileFilter filter = fc.getFileFilter();
            File file = fc.getSelectedFile();
            if (filter instanceof ExcelFileFilter) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(fc.getSelectedFile() + ".xls");
                }
                if (file != null) {
                    if (file.exists()) {
                        int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                        if (re == 1 || re == 2) {
                            return;
                        }
                        file.delete();
                    }
                    try {
                        this.exportBook(file);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"budget error:", (Throwable)ex);
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            } else if (filter instanceof Excel2007FileFilter) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(fc.getSelectedFile() + ".xlsx");
                }
                if (file != null) {
                    if (file.exists()) {
                        int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                        if (re == 1 || re == 2) {
                            return;
                        }
                        file.delete();
                    }
                    try {
                        this.exportToExcel2007(this.sc.getBook(), file.getPath());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                    }
                }
            }
        }
    }

    private boolean exportToExcel2007(Book book, String fileName) {
        String[] sns = new String[book.getSheetCount()];
        for (int i = 0; i < book.getSheetCount(); ++i) {
            sns[i] = book.getSheetName(i);
        }
        if (sns.length == 0) {
            WindowUtil.msgboxError((Object)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"26_WizzardIO"), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this.sc);
            return false;
        }
        try {
            Book tempBook = SpreadHelper.copyBook((Book)book);
            HashMap<String, Object> _parameter = new HashMap<String, Object>();
            BigDecimal _coefficient = this.editData.getMeasureUnit() != null ? this.editData.getMeasureUnit().getCoefficient() : BgNConstants.ONE;
            _parameter.put("EXPORT_BOOK", tempBook);
            _parameter.put("EXPORT_COEFFICIENT", _coefficient);
            _parameter.put("EXPORT_MEASUREUNIT", this.getMeasureMap());
            _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
            _parameter.put("EXPORT_DATA", this.getUIContext().get("EXPORT_DATA"));
            Book _book = BgNFCHelper.exportExcel2007(_parameter);
            BookDataWrapper bookDataWrapper = new BookDataWrapper(_book);
            bookDataWrapper.setExportFormula(false);
            bookDataWrapper.setExportCustomerFomulas(true);
            bookDataWrapper.setShowValue(true);
            bookDataWrapper.setExportHideCols(true);
            bookDataWrapper.setExportHideRows(true);
            SXSSFExportWrapper booksc = new SXSSFExportWrapper((AbstractDataWrapper)bookDataWrapper);
            booksc.write(fileName);
            return true;
        }
        catch (Exception e) {
            WindowUtil.msgboxError((Object)e.getCause().getMessage(), (String)this.getLocalText("Key_ErrorOnSaveFile"), (Component)this.sc);
            return false;
        }
    }

    private String getLocalText(String key) {
        return LanguageManager.getLangMessage((String)key, WizzardIO.class, (String)EASResource.getString((String)"com.kingdee.eas.fi.newrpt.NEWRPTAutoGenerateResource", (String)"23_WizzardIO"));
    }

    private void exportBook(File file) {
        Book _book = this.bookMain;
        String _filename = file.getPath();
        BigDecimal _coefficient = this.editData.getMeasureUnit() != null ? this.editData.getMeasureUnit().getCoefficient() : BgNConstants.ONE;
        HashMap<String, Object> _parameter = new HashMap<String, Object>();
        _parameter.put("EXPORT_BOOK", _book);
        _parameter.put("EXPORT_COEFFICIENT", _coefficient);
        _parameter.put("EXPORT_MEASUREUNIT", this.getMeasureMap());
        _parameter.put("EXPORT_BGFORMULA", this.getFormulaMap());
        _parameter.put("EXPORT_DATA", this.getUIContext().get("EXPORT_DATA"));
        KDSBook _kdsBook = BgNFCHelper.exportExcel(_parameter);
        ExportManager em = new ExportManager();
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_TRUE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.BOOLEAN_VALUE_FALSE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMAT, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_STYLE, (Object)"true");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_CUSTOM_FORMULA, (Object)"false");
        em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"false");
        em.exportToExcel(_kdsBook, _filename);
    }

    @Override
    public void actionExpandAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        int n;
        Book table = this.getCurrentPage();
        Sheet sheet = null;
        if (this.displayStyle.equals("GATHER_VIEW_TYPE_ITEM")) {
            for (n = 0; n < table.getSheetCount(); ++n) {
                sheet = table.getSheet(n);
                if (this.expandColIndex.get(sheet.getID()) == null) continue;
                for (i = 0; i < sheet.getMaxRowIndex() + 1; ++i) {
                    NumberExpandInfo expandInfo;
                    Cell orgCell = sheet.getCell(i, ((Integer)this.expandColIndex.get(sheet.getID())).intValue(), true);
                    if (orgCell == null || orgCell.getUserObject("NEId") == null || (expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)sheet.getCell(i, ((Integer)this.expandColIndex.get(sheet.getID())).intValue(), true))) == null) continue;
                    this.expandTableAll(sheet, sheet.getRow(i, true), expandInfo, (int)((Integer)this.expandColIndex.get(sheet.getID())));
                }
            }
        } else if (this.displayStyle.equals("GATHER_VIEW_TYPE_ORG")) {
            for (n = 0; n < table.getSheetCount(); ++n) {
                sheet = table.getSheet(n);
                if (this.expandRowIndex.get(sheet.getID()) == null) continue;
                for (i = 0; i < sheet.getMaxColIndex() + 1; ++i) {
                    NumberExpandInfo expandInfo;
                    Cell orgCell = sheet.getCell(((Integer)this.expandRowIndex.get(sheet.getID())).intValue(), i, true);
                    if (orgCell == null || orgCell.getUserObject("NEId") == null || (expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)sheet.getCell(((Integer)this.expandRowIndex.get(sheet.getID())).intValue(), i, true))) == null) continue;
                    this.expandTableAll(sheet, sheet.getColumn(i, true), expandInfo, (int)((Integer)this.expandRowIndex.get(sheet.getID())));
                }
            }
        }
        if (this.getUIContext().get(form_active_sheet_index) != null) {
            int index = 0;
            try {
                index = Integer.valueOf((String)this.getUIContext().get(form_active_sheet_index));
            }
            catch (Exception e1) {
                logger.error((Object)e1);
            }
            this.bookMain.activeSheet(index);
        } else {
            this.bookMain.activeSheet(0);
        }
        this.pnlMain.setSelectedIndex(0);
    }

    @Override
    public void actionFoldAll_actionPerformed(ActionEvent e) throws Exception {
        block5: {
            Sheet sheet;
            Book table;
            block4: {
                table = this.getCurrentPage();
                sheet = null;
                if (!this.displayStyle.equals("GATHER_VIEW_TYPE_ITEM")) break block4;
                for (int n = 0; n < table.getSheetCount(); ++n) {
                    sheet = table.getSheet(n);
                    if (this.expandColIndex.get(sheet.getID()) == null) continue;
                    for (int i = 0; i < sheet.getMaxRowIndex() + 1; ++i) {
                        NumberExpandInfo expandInfo;
                        Cell orgCell = sheet.getCell(i, ((Integer)this.expandColIndex.get(sheet.getID())).intValue(), true);
                        if (orgCell == null || orgCell.getUserObject("NEId") == null || (expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)sheet.getCell(i, ((Integer)this.expandColIndex.get(sheet.getID())).intValue(), true))) == null) continue;
                        this.foldTableAll(sheet, sheet.getRow(i, true), expandInfo, (int)((Integer)this.expandColIndex.get(sheet.getID())));
                    }
                }
                break block5;
            }
            if (!this.displayStyle.equals("GATHER_VIEW_TYPE_ORG")) break block5;
            for (int n = 0; n < table.getSheetCount(); ++n) {
                sheet = table.getSheet(n);
                if (this.expandRowIndex.get(sheet.getID()) == null) continue;
                for (int i = 0; i < sheet.getMaxColIndex() + 1; ++i) {
                    NumberExpandInfo expandInfo;
                    Cell orgCell = sheet.getCell(((Integer)this.expandRowIndex.get(sheet.getID())).intValue(), i, true);
                    if (orgCell == null || orgCell.getUserObject("NEId") == null || (expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)sheet.getCell(((Integer)this.expandRowIndex.get(sheet.getID())).intValue(), i, true))) == null) continue;
                    this.foldTableAll(sheet, sheet.getColumn(i, true), expandInfo, (int)((Integer)this.expandRowIndex.get(sheet.getID())));
                }
            }
        }
    }

    protected void expandTableAll(Sheet table, Row row, NumberExpandInfo parentExpandInfo, int colIndex) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        Row child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (!parentExpandInfo.isExpandStatus()) {
            int rowIndex;
            parentExpandInfo.setExpandStatus(true);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(colIndex, true), (NumberExpandInfo)parentExpandInfo);
            int rowCount = table.getMaxRowIndex() + 1;
            if (rowIndex >= rowCount) {
                this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
            } else {
                for (rowIndex = row.getRow() + 1; rowIndex < rowCount; ++rowIndex) {
                    child = table.getRow(rowIndex, true);
                    expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)child.getCell(colIndex, true));
                    if (expandInfo != null) {
                        longnumber = expandInfo.getLongNumber();
                        if (longnumber.startsWith(plongnumber + "!")) {
                            BgNFSHelper.setHided((Row)child, (boolean)false);
                            if (!expandInfo.isLeaf()) {
                                expandInfo.setExpandStatus(false);
                            }
                            if (table.getRow(rowIndex + 1, false) == null || !this.isCol(table, table.getRow(rowIndex + 1, true), colIndex)) continue;
                            expandInfo.setExpandStatus(true);
                            continue;
                        }
                        if (rowIndex != row.getRow() + 1) break;
                        this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
                        break;
                    }
                    if (rowIndex != row.getRow() + 1) continue;
                    this.addChildOrgUnitByCol(table, parentExpandInfo, rowIndex, colIndex);
                }
            }
        }
    }

    protected void expandTableAll(Sheet table, Column column, NumberExpandInfo parentExpandInfo, int rowIndex) {
        if (column == null || parentExpandInfo == null) {
            return;
        }
        Column child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (!parentExpandInfo.isExpandStatus()) {
            int colIndex;
            parentExpandInfo.setExpandStatus(true);
            int colCount = table.getMaxColIndex() + 1;
            if (!parentExpandInfo.isHasExpendData()) {
                this.addChildOrgUnitByRow(table, parentExpandInfo, rowIndex, colIndex);
                parentExpandInfo.setHasExpendData(true);
            } else {
                for (colIndex = column.getCol() + 1; colIndex < colCount; ++colIndex) {
                    child = table.getColumn(colIndex, true);
                    expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)table.getCell(rowIndex, colIndex, true));
                    if (expandInfo == null) continue;
                    longnumber = expandInfo.getLongNumber();
                    if (!longnumber.startsWith(plongnumber + "!")) break;
                    BgNFSHelper.setHided((Column)child, (boolean)false);
                    if (expandInfo.isExpandStatus()) {
                        expandInfo.setExpandStatus(true);
                        continue;
                    }
                    expandInfo.setExpandStatus(false);
                }
            }
            BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowIndex, column.getCol(), true), (NumberExpandInfo)parentExpandInfo);
        }
    }

    protected void foldTableAll(Sheet table, Row row, NumberExpandInfo parentExpandInfo, int colIndex) {
        if (row == null || parentExpandInfo == null) {
            return;
        }
        Row child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)row.getCell(colIndex, true), (NumberExpandInfo)parentExpandInfo);
            int rowCount = table.getMaxRowIndex() + 1;
            for (int rowIndex = row.getRow() + 1; rowIndex < rowCount; ++rowIndex) {
                child = table.getRow(rowIndex, true);
                expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)child.getCell(colIndex, true));
                if (expandInfo == null) continue;
                longnumber = expandInfo.getLongNumber();
                if (!longnumber.startsWith(plongnumber + "!")) break;
                BgNFSHelper.setHided((Row)child, (boolean)true);
            }
        }
    }

    protected void foldTableAll(Sheet table, Column column, NumberExpandInfo parentExpandInfo, int rowIndex) {
        if (column == null || parentExpandInfo == null) {
            return;
        }
        Column child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = parentExpandInfo.getLongNumber();
        if (parentExpandInfo.isExpandStatus()) {
            parentExpandInfo.setExpandStatus(false);
            BgNFCHelper.setNumberExpandInfo((Cell)table.getCell(rowIndex, column.getCol(), true), (NumberExpandInfo)parentExpandInfo);
            int colCount = table.getMaxColIndex() + 1;
            for (int colIndex = column.getCol() + 1; colIndex < colCount; ++colIndex) {
                child = table.getColumn(colIndex, true);
                expandInfo = BgNFCHelper.getNumberExpandInfo((Cell)table.getCell(rowIndex, colIndex, true));
                if (expandInfo == null) continue;
                longnumber = expandInfo.getLongNumber();
                if (!longnumber.startsWith(plongnumber + "!")) break;
                BgNFSHelper.setHided((Column)child, (boolean)true);
            }
        }
    }

    private class MyTableMouseController
    extends TableMouseController {
        public MyTableMouseController(SpreadContext context) {
            super(context);
        }

        public void mouseClicked(MouseEvent e) {
            Sheet activeSheet = null;
            try {
                activeSheet = BgAllFormCollectionUI.this.getSheetPage();
            }
            catch (Exception e1) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"119_BgAllFormCollectionUI"));
            }
            if (activeSheet == null) {
                return;
            }
            Row row = activeSheet.getRow(activeSheet.getActiveRow(), true);
            Column column = activeSheet.getColumn(activeSheet.getActiveCol(), true);
            Cell cell = activeSheet.getActiveCell();
            if (cell != null) {
                NumberExpandInfo numberExpandInfo = BgNFCHelper.getNumberExpandInfo((Cell)cell);
                if (numberExpandInfo != null) {
                    if (BgAllFormCollectionUI.this.displayStyle.equals("GATHER_VIEW_TYPE_ITEM")) {
                        BgAllFormCollectionUI.this.setTreeDisplayStyle(activeSheet, row, numberExpandInfo, (Integer)BgAllFormCollectionUI.this.expandColIndex.get(activeSheet.getID()));
                    } else if (BgAllFormCollectionUI.this.displayStyle.equals("GATHER_VIEW_TYPE_ORG")) {
                        BgAllFormCollectionUI.this.setTreeDisplayStyle(activeSheet, column, numberExpandInfo, (Integer)BgAllFormCollectionUI.this.expandRowIndex.get(activeSheet.getID()));
                    }
                }
                activeSheet.getRange(cell.getRow(), cell.getCol()).select();
            }
        }
    }
}

