/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseContrastFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseContrastFilterUI;
import com.kingdee.eas.ma.budget.client.BgCostCenterOrgViewF7;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgAnalyseContrastFilterUI
extends AbstractBgAnalyseContrastFilterUI {
    private static final long serialVersionUID = -4504035601941919035L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseContrastFilterUI.class);

    public BgAnalyseContrastFilterUI() throws Exception {
    }

    public BgAnalyseContrastFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    public String getUITitle() {
        return BgAnalyseHelper.getMessage("bgContrastFilterTitle");
    }

    @Override
    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            if (this.comAnalyseType.getSelectedIndex() != 0 && this.comAnalyseType.getSelectedIndex() == 1 && this.prmtBatchBgScheme.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage("selectbatchBgScheme"));
                return false;
            }
            if (this.comBgTemplate.getSelectedItem() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage("selectBgTemplate"));
                return false;
            }
            if (this.prmtBgElement.getData() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage("selectBgElement"));
                return false;
            }
            if (this.checkGather.isSelected()) {
                OrgUnitInfo[] orgUnits = null;
                Object obj = this.prmtOrgUnit.getData();
                if (obj instanceof OrgUnitInfo) {
                    orgUnits = new OrgUnitInfo[]{(CostCenterOrgUnitInfo)obj};
                } else if (obj instanceof OrgUnitInfo[]) {
                    orgUnits = (OrgUnitInfo[])obj;
                }
                if (orgUnits.length <= 1) {
                    MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage("gatherSelect"));
                    return false;
                }
            }
        }
        return re;
    }

    @Override
    public void clear() {
        this.comAnalyseType.setSelectedIndex(0);
        super.clear();
        this.checkGather.setSelected(false);
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgAnalyseContrastFilterParam();
    }

    @Override
    protected void initOrgUnit() throws Exception {
        this.initAnalyseType();
        super.initOrgUnit();
    }

    protected void initAnalyseType() throws Exception {
        this.comAnalyseType.addItem((Object)BgAnalyseHelper.getMessage("AnalyseBudgetVsActual"));
        this.comAnalyseType.addItem((Object)BgAnalyseHelper.getMessage("AnalyseBatchBgScheme"));
    }

    @Override
    protected void comAnalyseType_actionPerformed(ActionEvent e) throws Exception {
        this.analyseType_actionPerformed(e);
    }

    protected void analyseType_actionPerformed(ActionEvent e) throws Exception {
        if (this.comAnalyseType.getSelectedIndex() == 0) {
            this.contBgScheme.setVisible(true);
            this.contBgScheme.setEnabled(true);
            this.checkGather.setEnabled(true);
            this.contBatchBgScheme.setEnabled(false);
            this.contBatchBgScheme.setVisible(false);
            BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
            orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
            orgView.setCuID(this.getCurrOrgUnit().getId().toString());
            orgView.setMultiSelect(true);
            orgView.setReturnSuperior(true);
            if (this.ui != null) {
                orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
            }
            this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        } else if (this.comAnalyseType.getSelectedIndex() == 1) {
            this.contBatchBgScheme.setVisible(true);
            this.contBatchBgScheme.setEnabled(true);
            this.contBgScheme.setEnabled(false);
            this.contBgScheme.setVisible(false);
            this.checkGather.setEnabled(false);
            this.checkGather.setSelected(false);
            BgCostCenterOrgViewF7 orgView = new BgCostCenterOrgViewF7((IUIObject)this);
            orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
            orgView.setCuID(this.getCurrOrgUnit().getId().toString());
            orgView.setMultiSelect(false);
            orgView.setReturnSuperior(false);
            if (this.ui != null) {
                orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
            }
            this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
            Object obj = this.prmtOrgUnit.getData();
            if (obj != null && obj instanceof OrgUnitInfo[]) {
                this.prmtOrgUnit.setData((Object)this.getCurrOrgUnit());
            } else {
                this.setSelectBgSchemeInfo((OrgUnitInfo)obj);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void orgUnit_dataChanged(DataChangeEvent e) throws Exception {
        int selectIndex = this.comAnalyseType.getSelectedIndex();
        if (this.prmtOrgUnit.getData() != null) {
            Object obj = this.prmtOrgUnit.getData();
            if (selectIndex == 0) {
                HashSet<BOSUuid> subOrgUnits = null;
                OrgUnitInfo[] orgUnits = null;
                OrgUnitInfo cCOrgUnit2 = null;
                OrgUnitInfo _currOrgUnit = null;
                if (obj instanceof OrgUnitInfo) {
                    orgUnits = new OrgUnitInfo[]{(CostCenterOrgUnitInfo)obj};
                } else if (obj instanceof OrgUnitInfo[]) {
                    orgUnits = (OrgUnitInfo[])obj;
                }
                subOrgUnits = new HashSet<BOSUuid>();
                if (orgUnits != null && orgUnits.length > 1) {
                    _currOrgUnit = this.getCurrOrgUnit();
                    if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                        _currOrgUnit = orgUnits[0];
                    }
                    for (OrgUnitInfo cCOrgUnit2 : orgUnits) {
                        if (cCOrgUnit2.getId().equals((Object)_currOrgUnit.getId())) continue;
                        subOrgUnits.add(cCOrgUnit2.getId());
                    }
                } else if (orgUnits != null) {
                    _currOrgUnit = orgUnits[0];
                }
                BgSchemeCollection bgSchemeCol = null;
                this.comBgScheme.removeAllItems();
                try {
                    if (_currOrgUnit == null) return;
                    bgSchemeCol = this.getBgSchemeInfo(_currOrgUnit.getId(), subOrgUnits, this.isHasUseFund(), false);
                    this.comBgScheme.addItems(bgSchemeCol.toArray());
                    return;
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    throw ex;
                }
            } else {
                if (selectIndex != 1) return;
                if (obj instanceof OrgUnitInfo) {
                    this.setSelectBgSchemeInfo((OrgUnitInfo)obj);
                    return;
                } else if (obj instanceof OrgUnitInfo[] && ((OrgUnitInfo[])obj).length == 1) {
                    this.setSelectBgSchemeInfo(((OrgUnitInfo[])obj)[0]);
                    return;
                } else {
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectbatchBgScheme"));
                    this.prmtBatchBgScheme.setData(null);
                }
            }
            return;
        } else if (selectIndex == 0) {
            this.comBgScheme.removeAllItems();
            return;
        } else {
            if (selectIndex != 1) return;
            this.prmtBatchBgScheme.setData(null);
        }
    }

    protected void setSelectBgSchemeInfo(OrgUnitInfo orgUnitInfo) {
        if (orgUnitInfo == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
        if (this.isHasUseFund()) {
            this.setFilterInfoOfBgScheme(filter);
        }
        view.setFilter(filter);
        this.prmtBatchBgScheme.setEntityViewInfo(view);
    }

    protected void setFilterInfoOfBgScheme(FilterInfo filter) {
        if (filter == null) {
            return;
        }
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
    }

    @Override
    protected void bgScheme_actionPerformed(ActionEvent e) throws Exception {
        super.bgScheme_actionPerformed(e);
        this.comBgTemplate.removeAllItems();
        if (this.comBgScheme.getSelectedItem() != null && this.comAnalyseType.getSelectedIndex() == 0) {
            BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this.comBgScheme.getSelectedItem();
            BgTemplateCollection bgTemplateCol = null;
            try {
                bgTemplateCol = this.getBgTemplateInfo(new BOSUuid[]{bgSchemeInfo.getId()}, this.isHasUseFund(), false);
                this.comBgTemplate.addItems(bgTemplateCol.toArray());
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        }
    }

    protected BgTemplateCollection getBgTemplateInfo(BOSUuid[] bgSchemeIds, boolean hasUseFund, boolean isFund) throws Exception {
        return this.getInterface().getCommonBgTemplate(bgSchemeIds, hasUseFund, isFund);
    }

    @Override
    protected void prmtBatchBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        this.batchBgScheme_dataChanged(e);
    }

    protected void batchBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBatchBgScheme.getData() != null && this.comAnalyseType.getSelectedIndex() == 1) {
            Object[] obj = (Object[])this.prmtBatchBgScheme.getData();
            this.comBgTemplate.removeAllItems();
            if (obj != null && obj.length == 2) {
                BOSUuid[] bgSchemeIds = null;
                BgTemplateCollection bgTemplateCol = null;
                bgSchemeIds = new BOSUuid[]{((BgSchemeInfo)obj[0]).getId(), ((BgSchemeInfo)obj[1]).getId()};
                try {
                    bgTemplateCol = this.getBgTemplateInfo(bgSchemeIds, this.isHasUseFund(), false);
                    this.comBgTemplate.addItems(bgTemplateCol.toArray());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    throw ex;
                }
                finally {
                    bgSchemeIds = null;
                }
            } else {
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectTwoBgScheme"));
                this.prmtBatchBgScheme.setData(null);
            }
        }
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseContrastFilterParam) {
            BgAnalyseContrastFilterParam _filterParam = (BgAnalyseContrastFilterParam)filterParam;
            if (this.comAnalyseType.getSelectedIndex() == 0) {
                _filterParam.setAnalyseType(new Integer(0));
                if (this.comBgScheme.getSelectedItem() != null) {
                    _filterParam.setBgScheme((BgSchemeInfo)this.comBgScheme.getSelectedItem());
                }
                _filterParam.setBgSchemes(null);
            } else if (this.comAnalyseType.getSelectedIndex() == 1) {
                _filterParam.setAnalyseType(new Integer(1));
                if (this.prmtBatchBgScheme.getData() != null) {
                    Object[] obj = (Object[])this.prmtBatchBgScheme.getData();
                    BgSchemeInfo[] _tmpBgSchemes = new BgSchemeInfo[obj.length];
                    int in = obj.length;
                    for (int i = 0; i < in; ++i) {
                        _tmpBgSchemes[i] = (BgSchemeInfo)obj[i];
                    }
                    _filterParam.setBgSchemes(_tmpBgSchemes);
                }
                _filterParam.setBgScheme(null);
            }
            if (this.comBgTemplate.getSelectedItem() != null) {
                _filterParam.setBgTemplateInfo((BgTemplateInfo)this.comBgTemplate.getSelectedItem());
            }
            if (this.checkGather.isSelected()) {
                _filterParam.setIsGather(true);
            } else {
                _filterParam.setIsGather(false);
            }
        }
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseContrastFilterParam) {
            BgAnalyseContrastFilterParam _filterParam = (BgAnalyseContrastFilterParam)filterParam;
            if (_filterParam.getAnalyseType() == 0) {
                if (_filterParam.getBgScheme() != null) {
                    BgAnalyseHelper.setSelectObject(this.comBgScheme, _filterParam.getBgScheme());
                }
            } else if (_filterParam.getAnalyseType() == 1 && _filterParam.getBgSchemes() != null) {
                BgSchemeInfo[] bgSchemes = _filterParam.getBgSchemes();
                Object[] obj = new Object[bgSchemes.length];
                for (Object obj[i] : bgSchemes) {
                }
                this.prmtBatchBgScheme.setData((Object)obj);
            }
            if (_filterParam.getBgTemplateInfo() != null) {
                BgAnalyseHelper.setSelectObject(this.comBgTemplate, _filterParam.getBgTemplateInfo());
            }
            if (_filterParam.getIsGather()) {
                this.checkGather.setSelected(true);
            } else {
                this.checkGather.setSelected(false);
            }
        }
    }

    @Override
    protected void getFilterParamBefore(FilterParam filterParam) {
        super.getFilterParamBefore(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseContrastFilterParam) {
            BgAnalyseContrastFilterParam _filterParam = (BgAnalyseContrastFilterParam)filterParam;
            if (_filterParam.getAnalyseType() == 0) {
                this.comAnalyseType.setSelectedIndex(0);
            } else if (_filterParam.getAnalyseType() == 1) {
                this.comAnalyseType.setSelectedIndex(1);
            }
        }
    }

    @Override
    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        FilterParam _fp = super.getFilterParam(mainParam, filterParam);
        BgAnalyseContrastFilterParam _mainParam = null;
        BgAnalyseContrastFilterParam _filterParam = null;
        if (_fp != null) {
            _mainParam = (BgAnalyseContrastFilterParam)_fp;
            _filterParam = (BgAnalyseContrastFilterParam)filterParam;
            if (_filterParam.getAnalyseType() != null) {
                _mainParam.setAnalyseType(_filterParam.getAnalyseType());
            } else {
                _mainParam.setAnalyseType(null);
            }
            if (_filterParam.getBgSchemes() != null) {
                _mainParam.setBgSchemes(_filterParam.getBgSchemes());
            } else {
                _mainParam.setBgSchemes(null);
            }
            if (_filterParam.getBgTemplateInfo() != null) {
                _mainParam.setBgTemplateInfo(_filterParam.getBgTemplateInfo());
            } else {
                _mainParam.setBgTemplateInfo(null);
            }
            if (_filterParam.getIsGather()) {
                _mainParam.setIsGather(true);
            } else {
                _mainParam.setIsGather(false);
            }
        }
        return _mainParam;
    }
}

