/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.ma.budget.BgAnalyseDiffFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgAnalyseInfo;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseDiffMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgNAnalyseDiffFilterUI;
import com.kingdee.eas.ma.budget.client.NumberExpandInfo;
import com.kingdee.eas.ma.budget.client.NumberExpendRender;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BgAnalyseDiffMainUI
extends AbstractBgAnalyseDiffMainUI {
    private static final long serialVersionUID = -507641667733232937L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseDiffMainUI.class);
    private Map dataMap = null;
    private Map measureMap = null;
    private NumberExpendRender render = null;
    private MeasureUnitInfo measureUnit = null;
    private int decimal = 10;
    private String decFormat = null;
    private static final int COLUMN_ORGUNIT = 0;
    private static final int COLUMN_BGPERIOD = 1;
    private static final int COLUMN_BGITEMNUMBER = 2;
    private static final int COLUMN_BGITEMNAME = 3;
    private static final int COLUMN_CURRENCY = 4;
    private static final String DIFF_DATA = "DIFF_DATA";
    private static final String ORGUNIT_PARAM = "ORGUNIT_PARAM";
    private static final String BGITEM_PARAM = "BGITEM_PARAM";
    private static final String BGITEMS_PARAM = "BGITEMS_PARAM";
    private static final String ELEMENT_PARAM = "ELEMENT_PARAM";
    private static final String ELEMENT_COLUMN = "ELEMENT_COLUMN";
    private static final String ELEMENT_MEASUREUNIT = "ELEMENT_MEASUREUNIT";
    private boolean isExpand = false;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
    }

    @Override
    protected String getQueryMainName() {
        return BgAnalyseDiffMainUI.class.getName();
    }

    @Override
    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage("bgDiffTitle"));
    }

    @Override
    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgNAnalyseDiffFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return this.defaultFilterUI;
    }

    @Override
    protected int getHeightOfDialog() {
        return 400;
    }

    @Override
    protected void executeQuery() {
        if (this.defaultFilterParam == null || !(this.defaultFilterParam instanceof BgAnalyseDiffFilterParam)) {
            return;
        }
        BgAnalyseDiffFilterParam filterParam = null;
        KDTable sheet = null;
        filterParam = (BgAnalyseDiffFilterParam)this.defaultFilterParam;
        this.clearTable();
        this.dataMap = this.getAllData(filterParam);
        sheet = this.addAnalyseSheet(filterParam.getBgScheme().getName());
        this.dealExpandOrgUnit(sheet);
        this.initStyleOfSheet(sheet, this.dataMap);
        this.fillStyleOfSheet(sheet, this.dataMap, filterParam);
    }

    private Map getAllData(BgAnalyseDiffFilterParam filterParam) {
        BgAnalyseInfo analyse = null;
        VisualItemInfo visItemInfo = null;
        String bgItemNumber2 = null;
        Map<String, BgElementInfo> _elementMap = null;
        HashMap _elementMuMap = null;
        HashMap<String, OrgUnitInfo> _orgUnitMap = null;
        HashMap<String, VisualItemInfo> _bgItemComMap = null;
        Map _bgItemMap = null;
        HashMap _tmpBgItemMap = null;
        if (this.dataMap == null) {
            this.dataMap = new HashMap();
            this.measureMap = new HashMap();
        }
        ArrayList data = null;
        try {
            data = BgAnalyseFacadeFactory.getRemoteInstance().getDiffData(null, filterParam);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            data = new ArrayList();
        }
        this.dataMap.put(DIFF_DATA, data);
        _bgItemComMap = new HashMap<String, VisualItemInfo>();
        _tmpBgItemMap = new HashMap();
        int n = data.size();
        for (int i = 0; i < n; ++i) {
            analyse = (BgAnalyseInfo)data.get(i);
            bgItemNumber2 = analyse.getBgItemNumber();
            if (_tmpBgItemMap.containsKey(bgItemNumber2)) continue;
            _tmpBgItemMap.put(bgItemNumber2, null);
        }
        try {
            String orgUnitId = filterParam.getOrgUnits()[0].getId().toString();
            _bgItemMap = BgSHelper.getBgItemsInfo(null, _tmpBgItemMap, null, null, orgUnitId);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            _bgItemMap = new HashMap();
        }
        for (String bgItemNumber2 : _tmpBgItemMap.keySet()) {
            try {
                visItemInfo = BgSHelper.getBgItemCombinInfo(bgItemNumber2, _bgItemMap);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
            if (visItemInfo == null) continue;
            _bgItemComMap.put(bgItemNumber2, visItemInfo);
        }
        this.dataMap.put(BGITEM_PARAM, _bgItemComMap);
        this.dataMap.put(BGITEMS_PARAM, _bgItemMap);
        _orgUnitMap = new HashMap<String, OrgUnitInfo>();
        if (filterParam.getOrgUnits() != null && filterParam.getOrgUnits().length > 0) {
            OrgUnitInfo orgUnitInfo2 = null;
            for (OrgUnitInfo orgUnitInfo2 : filterParam.getOrgUnits()) {
                _orgUnitMap.put(orgUnitInfo2.getId().toString(), orgUnitInfo2);
            }
        }
        this.dataMap.put(ORGUNIT_PARAM, _orgUnitMap);
        if (filterParam.getElementMap() != null && filterParam.getElementMap().size() > 0) {
            BgElementInfo _elementInfo2 = null;
            _elementMuMap = new HashMap();
            _elementMap = new HashMap();
            for (BgElementInfo _elementInfo2 : filterParam.getElementMap().keySet()) {
                if (_elementInfo2 == null) continue;
                _elementMap.put(_elementInfo2.getNumber(), _elementInfo2);
                _elementMuMap.put(_elementInfo2.getNumber(), filterParam.getElementMap().get(_elementInfo2));
            }
        } else {
            try {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("name");
                sic.add("number");
                sic.add("isApportionable");
                sic.add("dataType");
                _elementMap = BgSHelper.getBgElementInfo(null, null, null, sic);
            }
            catch (Exception ex) {
                _elementMap = new HashMap<String, BgElementInfo>();
                logger.error((Object)ex);
            }
        }
        this.dataMap.put(ELEMENT_PARAM, _elementMap);
        this.dataMap.put(ELEMENT_MEASUREUNIT, _elementMuMap);
        if (filterParam.getMeasureUnit() != null) {
            this.measureUnit = filterParam.getMeasureUnit();
        }
        this.measureUnit = null;
        if (filterParam.getCurrency() != null) {
            this.decimal = filterParam.getCurrency().getPrecision();
        }
        return this.dataMap;
    }

    private void clearTable() {
        this.getMainTabPane().removeAll();
    }

    @Override
    protected void dealListener(KDTable sheet) {
        super.dealListener(sheet);
        if (sheet != null) {
            sheet.addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    BgAnalyseDiffMainUI.this.table_Clicked(e);
                }
            });
        }
    }

    @Override
    protected void dealExpandOrgUnit(KDTable sheet) {
        if (this.defaultFilterParam != null && this.defaultFilterParam instanceof BgAnalyseDiffFilterParam) {
            BgAnalyseDiffFilterParam _filterParam = (BgAnalyseDiffFilterParam)this.defaultFilterParam;
            this.isExpand = _filterParam.getOrgUnits().length > 1;
        }
    }

    private void initStyleOfSheet(KDTable sheet, Map dataMap) {
        if (sheet == null || dataMap == null) {
            return;
        }
        int colCount = 5;
        int dataType = 0;
        IRow row = null;
        IColumn column = null;
        sheet.checkParsed(true);
        sheet.setRefresh(false);
        sheet.addColumns(colCount);
        row = sheet.addHeadRow();
        sheet.getColumn(0).setWidth(225);
        sheet.getColumn(1).setWidth(100);
        sheet.getColumn(2).setWidth(150);
        sheet.getColumn(3).setWidth(175);
        sheet.getColumn(4).setWidth(100);
        row.getCell(0).setValue((Object)BgAnalyseHelper.getMessage("orgUnit"));
        row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage("bgPeriod"));
        row.getCell(2).setValue((Object)BgAnalyseHelper.getMessage("bgitem-number"));
        row.getCell(3).setValue((Object)BgAnalyseHelper.getMessage("bgitem-name"));
        row.getCell(4).setValue((Object)BgAnalyseHelper.getMessage("currency"));
        if (this.isExpand) {
            this.render = new NumberExpendRender();
            sheet.getColumn(0).setRenderer((IBasicRender)this.render);
        }
        if (dataMap.containsKey(ELEMENT_PARAM)) {
            String key2 = null;
            BgElementInfo _elementInfo = null;
            MeasureUnitInfo _measueUnit = null;
            HashMap<String, Integer> _elementColMap = new HashMap<String, Integer>();
            Map _elementMap = (Map)dataMap.get(ELEMENT_PARAM);
            Map _elementMuMap = (Map)dataMap.get(ELEMENT_MEASUREUNIT);
            TreeMap _elementTreeMap = new TreeMap();
            _elementTreeMap.putAll(_elementMap);
            for (String key2 : _elementTreeMap.keySet()) {
                _elementInfo = (BgElementInfo)_elementMap.get(key2);
                dataType = _elementInfo.getDataType().getValue();
                if (dataType == 4 || dataType == 5) continue;
                column = sheet.addColumn();
                column.setWidth(100);
                column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (_elementMuMap != null && _elementMuMap.containsKey(_elementInfo.getNumber())) {
                    _measueUnit = (MeasureUnitInfo)_elementMuMap.get(_elementInfo.getNumber());
                    row.getCell(column.getColumnIndex()).setValue((Object)(_elementInfo.getName() + (_measueUnit != null ? " ( " + _measueUnit.getName() + " ) " : "")));
                    this.measureMap.put(new Integer(column.getColumnIndex()), _measueUnit != null ? _measueUnit.getCoefficient() : BgNConstants.ONE);
                } else {
                    row.getCell(column.getColumnIndex()).setValue((Object)(_elementInfo.getName() + (this.measureUnit != null ? " ( " + this.measureUnit.getName() + " ) " : "")));
                    this.measureMap.put(new Integer(column.getColumnIndex()), this.measureUnit != null ? this.measureUnit.getCoefficient() : BgNConstants.ONE);
                }
                column.setUserObject((Object)_elementInfo);
                _elementColMap.put(_elementInfo.getId().toString(), new Integer(column.getColumnIndex()));
            }
            dataMap.put(ELEMENT_COLUMN, _elementColMap);
        }
        sheet.setRefresh(true);
        sheet.getStyleAttributes().setLocked(true);
    }

    private void fillStyleOfSheet(KDTable sheet, Map dataMap, BgAnalyseDiffFilterParam filterParam) {
        if (sheet == null || dataMap == null) {
            return;
        }
        int colIndex = 0;
        BigDecimal value = null;
        String bgItemNumber = null;
        String bgElementId2 = null;
        List diffData = null;
        Map _orgUnitMap = null;
        Map _elementColMap = null;
        Map _bgItemMap = null;
        HashMap<String, BigDecimal> _valueMap = null;
        BgAnalyseInfo analyse = null;
        VisualItemInfo itemInfo = null;
        BgElementInfo _bgElementInfo = null;
        OrgUnitInfo orgUnitInfo = null;
        NumberExpandInfo expandInfo = null;
        IRow row = null;
        if (dataMap.containsKey(DIFF_DATA) && dataMap.containsKey(ELEMENT_COLUMN)) {
            diffData = (List)dataMap.get(DIFF_DATA);
            _orgUnitMap = (Map)dataMap.get(ORGUNIT_PARAM);
            _bgItemMap = (Map)dataMap.get(BGITEM_PARAM);
            _elementColMap = (Map)dataMap.get(ELEMENT_COLUMN);
            _valueMap = new HashMap<String, BigDecimal>();
            int n = diffData.size();
            for (int i = 0; i < n; ++i) {
                analyse = (BgAnalyseInfo)diffData.get(i);
                row = sheet.addRow();
                if (orgUnitInfo == null && _orgUnitMap.containsKey(analyse.getCostCenterOrgUnitId())) {
                    orgUnitInfo = (OrgUnitInfo)_orgUnitMap.get(analyse.getCostCenterOrgUnitId());
                }
                if (orgUnitInfo != null) {
                    if (this.isExpand) {
                        expandInfo = new NumberExpandInfo();
                        expandInfo.setId(orgUnitInfo.getId().toString());
                        expandInfo.setName(orgUnitInfo.getName());
                        expandInfo.setNumber(orgUnitInfo.getNumber());
                        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
                        expandInfo.setLevel(0);
                        expandInfo.setLeaf(false);
                        expandInfo.setExpandStatus(false);
                        expandInfo.setCollect(false);
                        row.getCell(0).setValue((Object)expandInfo);
                    } else {
                        row.getCell(0).setValue((Object)orgUnitInfo.getName());
                    }
                }
                row.getCell(1).setValue((Object)analyse.getBgPeriodName());
                bgItemNumber = analyse.getBgItemNumber();
                row.getCell(2).setValue((Object)bgItemNumber);
                if (_bgItemMap.containsKey(bgItemNumber)) {
                    itemInfo = (VisualItemInfo)_bgItemMap.get(bgItemNumber);
                    row.getCell(3).setValue((Object)itemInfo.getName());
                }
                row.getCell(4).setValue((Object)filterParam.getCurrency().getName());
                row.getCell(4).setUserObject((Object)analyse.getCurrencyId());
                if (!_elementColMap.containsKey(analyse.getBgElementId())) continue;
                colIndex = (Integer)_elementColMap.get(analyse.getBgElementId());
                row.getCell(colIndex).setValue((Object)analyse.getValue());
                if (_valueMap.containsKey(analyse.getBgElementId())) {
                    value = (BigDecimal)_valueMap.get(analyse.getBgElementId());
                    value = value.add(analyse.getValue());
                    _valueMap.put(analyse.getBgElementId(), value);
                    continue;
                }
                _valueMap.put(analyse.getBgElementId(), analyse.getValue());
            }
            if (orgUnitInfo == null) {
                orgUnitInfo = filterParam.getOrgUnits()[0];
            }
            row = sheet.addRow();
            row.getStyleAttributes().setBackground(BgSHelper.COLLECT_COLOR);
            if (this.isExpand) {
                expandInfo = new NumberExpandInfo();
                expandInfo.setId(orgUnitInfo.getId().toString());
                expandInfo.setName(orgUnitInfo.getName());
                expandInfo.setNumber(orgUnitInfo.getNumber());
                expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
                expandInfo.setLevel(0);
                expandInfo.setLeaf(false);
                expandInfo.setExpandStatus(false);
                expandInfo.setCollect(true);
                row.getCell(0).setValue((Object)expandInfo);
            } else {
                row.getCell(0).setValue((Object)orgUnitInfo.getName());
            }
            row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage("collect"));
            row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sheet.getMergeManager().mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), 4);
            for (String bgElementId2 : _elementColMap.keySet()) {
                value = (BigDecimal)_valueMap.get(bgElementId2);
                if (value == null || !(_bgElementInfo = (BgElementInfo)sheet.getColumn(colIndex = ((Integer)_elementColMap.get(bgElementId2)).intValue()).getUserObject()).isIsApportionable()) continue;
                row.getCell(colIndex).setValue((Object)value);
            }
            sheet.getMergeManager().mergeBlock(0, 0, diffData.size(), 0);
        }
    }

    private void table_Clicked(KDTMouseEvent e) {
        if (e.getClickCount() == 1) {
            NumberExpandInfo expandInfo;
            int rowIndex = e.getRowIndex();
            int colIndex = e.getColIndex();
            KDTable sheet = (KDTable)e.getSource();
            if (sheet != null && sheet.getCell(rowIndex, colIndex) != null && sheet.getCell(rowIndex, colIndex).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)sheet.getCell(rowIndex, colIndex).getValue()) != null && this.render.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(sheet, rowIndex, colIndex, expandInfo);
            }
        }
    }

    private void setTreeDisplayStyle(KDTable sheet, int rowAlias, int colAlias, NumberExpandInfo expandInfo) {
        sheet.setRefresh(false);
        ICell cell = null;
        IRow row = null;
        NumberExpandInfo tmpExpandInfo = null;
        int rowIndex = rowAlias;
        int rowCount = sheet.getBody().size();
        while (rowIndex < rowCount && (row = sheet.getRow(rowIndex)) != null && row.getCell(colAlias).getValue() != null && (cell = row.getCell(colAlias)).getValue() != null && cell.getValue() instanceof NumberExpandInfo && (tmpExpandInfo = (NumberExpandInfo)cell.getValue()).getId().equals(expandInfo.getId())) {
            rowAlias = rowIndex++;
        }
        this.expandTable(sheet, rowAlias, colAlias, expandInfo);
        sheet.setRefresh(true);
        sheet.reLayoutAndPaint();
    }

    private void expandTable(KDTable sheet, int rowAlias, int colAlias, NumberExpandInfo pExpandInfo) {
        if (sheet == null || pExpandInfo == null) {
            return;
        }
        IRow child = null;
        NumberExpandInfo expandInfo = null;
        String longnumber = null;
        String plongnumber = null;
        plongnumber = pExpandInfo.getLongNumber();
        if (pExpandInfo.isExpandStatus()) {
            pExpandInfo.setExpandStatus(false);
            int rowCount = sheet.getBody().size();
            for (int rowIndex = rowAlias + 1; rowIndex < rowCount; ++rowIndex) {
                child = sheet.getRow(rowIndex);
                expandInfo = (NumberExpandInfo)child.getCell(colAlias).getValue();
                if (expandInfo == null || expandInfo.getLevel() <= pExpandInfo.getLevel()) continue;
                longnumber = expandInfo.getLongNumber();
                if (longnumber.startsWith(plongnumber + "!")) {
                    child.getStyleAttributes().setHided(true);
                    continue;
                }
                break;
            }
        } else {
            int rowIndex;
            pExpandInfo.setExpandStatus(true);
            int rowCount = sheet.getBody().size();
            if (rowIndex >= rowCount) {
                this.addChildOrgUnitByCol(sheet, pExpandInfo, rowIndex, colAlias);
            } else {
                for (rowIndex = rowAlias + 1; rowIndex < rowCount; ++rowIndex) {
                    child = sheet.getRow(rowIndex);
                    expandInfo = (NumberExpandInfo)child.getCell(colAlias).getValue();
                    if (expandInfo != null) {
                        longnumber = expandInfo.getLongNumber();
                        if (longnumber.startsWith(plongnumber + "!")) {
                            child.getStyleAttributes().setHided(false);
                            if (expandInfo.isLeaf()) continue;
                            expandInfo.setExpandStatus(true);
                            continue;
                        }
                        if (rowIndex != rowAlias + 1) break;
                        this.addChildOrgUnitByCol(sheet, pExpandInfo, rowIndex, colAlias);
                        break;
                    }
                    if (rowIndex != rowAlias + 1) continue;
                    this.addChildOrgUnitByCol(sheet, pExpandInfo, rowIndex, colAlias);
                }
            }
        }
    }

    protected void addChildOrgUnitByCol(KDTable sheet, NumberExpandInfo pExpandInfo, int rowAlias, int colAlias) {
        if (sheet == null || pExpandInfo == null) {
            return;
        }
        if (this.defaultFilterParam != null) {
            BgAnalyseDiffFilterParam filterParam = (BgAnalyseDiffFilterParam)this.defaultFilterParam;
            ArrayList data = null;
            BigDecimal value = null;
            String bgItemNumber2 = null;
            String bgElementId2 = null;
            boolean hasSubOrgUnit = false;
            int rowAddNew = 0;
            int startIndex = 0;
            int colIndex = 0;
            IRow row = null;
            Map _elementColMap = null;
            HashMap<String, BigDecimal> _valueMap = null;
            HashMap _tmpBgItemMap = null;
            HashMap _bgItemMap = null;
            Map _bgVisItemMap = null;
            BgAnalyseInfo analyse = null;
            VisualItemInfo visItemInfo = null;
            BgElementInfo _bgElementInfo = null;
            CostCenterOrgUnitInfo orgUnitInfo = null;
            NumberExpandInfo expandInfo = null;
            _bgItemMap = (HashMap)this.dataMap.get(BGITEMS_PARAM);
            _bgVisItemMap = (Map)this.dataMap.get(BGITEM_PARAM);
            _elementColMap = (Map)this.dataMap.get(ELEMENT_COLUMN);
            _valueMap = new HashMap<String, BigDecimal>();
            rowAddNew = rowAlias;
            int in = filterParam.getOrgUnits().length;
            for (int i = 0; i < in; ++i) {
                orgUnitInfo = (CostCenterOrgUnitInfo)filterParam.getOrgUnits()[i];
                startIndex = 0;
                if (orgUnitInfo.getId().toString().equals(pExpandInfo.getId()) || orgUnitInfo.getParent() == null || !orgUnitInfo.getParent().getId().toString().equals(pExpandInfo.getId())) continue;
                hasSubOrgUnit = !this.hasSubOrgUnit(orgUnitInfo.getId(), filterParam.getOrgUnits());
                try {
                    data = BgAnalyseFacadeFactory.getRemoteInstance().getDiffData(orgUnitInfo.getId(), filterParam);
                }
                catch (Exception ex) {
                    data = new ArrayList();
                }
                _tmpBgItemMap = new HashMap();
                int xn = data.size();
                for (int x = 0; x < xn; ++x) {
                    analyse = (BgAnalyseInfo)data.get(x);
                    bgItemNumber2 = analyse.getBgItemNumber();
                    if (_bgVisItemMap.containsKey(bgItemNumber2)) continue;
                    _tmpBgItemMap.put(bgItemNumber2, null);
                }
                try {
                    _bgItemMap = BgSHelper.getBgItemsInfo(null, _tmpBgItemMap, _bgItemMap, null, orgUnitInfo.getId().toString());
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    _bgItemMap = new HashMap();
                }
                for (String bgItemNumber2 : _tmpBgItemMap.keySet()) {
                    try {
                        visItemInfo = BgSHelper.getBgItemCombinInfo(bgItemNumber2, _bgItemMap);
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                    if (visItemInfo == null) continue;
                    _bgVisItemMap.put(bgItemNumber2, visItemInfo);
                }
                _valueMap.clear();
                int jn = data.size();
                for (int j = 0; j < jn; ++j) {
                    analyse = (BgAnalyseInfo)data.get(j);
                    row = sheet.addRow(rowAddNew++);
                    if (startIndex == 0) {
                        startIndex = row.getRowIndex();
                    }
                    if (this.isExpand) {
                        expandInfo = new NumberExpandInfo();
                        expandInfo.setId(orgUnitInfo.getId().toString());
                        expandInfo.setName(orgUnitInfo.getName());
                        expandInfo.setNumber(orgUnitInfo.getNumber());
                        expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
                        expandInfo.setLevel(pExpandInfo.getLevel() + 1);
                        expandInfo.setLeaf(hasSubOrgUnit);
                        expandInfo.setExpandStatus(false);
                        expandInfo.setCollect(false);
                        row.getCell(0).setValue((Object)expandInfo);
                    } else {
                        row.getCell(0).setValue((Object)orgUnitInfo.getName());
                    }
                    row.getCell(1).setValue((Object)analyse.getBgPeriodName());
                    bgItemNumber2 = analyse.getBgItemNumber();
                    row.getCell(2).setValue((Object)bgItemNumber2);
                    if (_bgVisItemMap.containsKey(bgItemNumber2)) {
                        visItemInfo = (VisualItemInfo)_bgVisItemMap.get(bgItemNumber2);
                        row.getCell(3).setValue((Object)visItemInfo.getName());
                    }
                    row.getCell(4).setValue((Object)filterParam.getCurrency().getName());
                    row.getCell(4).setUserObject((Object)analyse.getCurrencyId());
                    if (!_elementColMap.containsKey(analyse.getBgElementId())) continue;
                    colIndex = (Integer)_elementColMap.get(analyse.getBgElementId());
                    row.getCell(colIndex).setValue((Object)analyse.getValue());
                    if (_valueMap.containsKey(analyse.getBgElementId())) {
                        value = (BigDecimal)_valueMap.get(analyse.getBgElementId());
                        value = value.add(analyse.getValue());
                        _valueMap.put(analyse.getBgElementId(), value);
                        continue;
                    }
                    _valueMap.put(analyse.getBgElementId(), analyse.getValue());
                }
                row = sheet.addRow(rowAddNew++);
                row.getStyleAttributes().setBackground(BgSHelper.COLLECT_COLOR);
                if (this.isExpand) {
                    expandInfo = new NumberExpandInfo();
                    expandInfo.setId(orgUnitInfo.getId().toString());
                    expandInfo.setName(orgUnitInfo.getName());
                    expandInfo.setNumber(orgUnitInfo.getNumber());
                    expandInfo.setLongNumber(orgUnitInfo.getLongNumber());
                    expandInfo.setLevel(pExpandInfo.getLevel() + 1);
                    expandInfo.setLeaf(hasSubOrgUnit);
                    expandInfo.setExpandStatus(false);
                    expandInfo.setCollect(true);
                    row.getCell(0).setValue((Object)expandInfo);
                } else {
                    row.getCell(0).setValue((Object)orgUnitInfo.getName());
                }
                row.getCell(1).setValue((Object)BgAnalyseHelper.getMessage("collect"));
                row.getCell(1).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                sheet.getMergeManager().mergeBlock(row.getRowIndex(), 1, row.getRowIndex(), 4);
                for (String bgElementId2 : _elementColMap.keySet()) {
                    value = (BigDecimal)_valueMap.get(bgElementId2);
                    if (value == null || !(_bgElementInfo = (BgElementInfo)sheet.getColumn(colIndex = ((Integer)_elementColMap.get(bgElementId2)).intValue()).getUserObject()).isIsApportionable()) continue;
                    row.getCell(colIndex).setValue((Object)value);
                }
                if (data.isEmpty()) continue;
                sheet.getMergeManager().mergeBlock(startIndex, 0, row.getRowIndex(), 0);
            }
        }
    }

    private boolean hasSubOrgUnit(BOSUuid pOrgUnitId, OrgUnitInfo[] orgUnitsInfo) {
        if (pOrgUnitId == null || orgUnitsInfo == null) {
            return false;
        }
        CostCenterOrgUnitInfo orgUnitInfo = null;
        int n = orgUnitsInfo.length;
        for (int i = 0; i < n; ++i) {
            orgUnitInfo = (CostCenterOrgUnitInfo)orgUnitsInfo[i];
            if (orgUnitInfo.getParent() == null || !orgUnitInfo.getParent().getId().equals((Object)pOrgUnitId)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        if (cell.getValue() != null && cell.getValue() instanceof BigDecimal && StringUtils.isEmpty((String)cell.getStyleAttributes().getNumberFormat())) {
            BigDecimal bigValue = (BigDecimal)cell.getValue();
            Integer _colIndex = new Integer(cell.getColumnIndex());
            if (this.measureMap.containsKey(_colIndex)) {
                BigDecimal coefficient = (BigDecimal)this.measureMap.get(_colIndex);
                value = bigValue.divide(coefficient, this.decimal, 4);
            }
            if (this.getDecFormat() == null) {
                this.setDecFormat(BgNationalFormatUIUtil.getFormatStringForTable(this.decimal));
            }
            cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            cell.getStyleAttributes().setNumberFormat(this.getDecFormat());
            cell.setValue(value);
        }
        return super.formatCellDisplay(rowIndex, colIndex, cell, value);
    }

    public String getDecFormat() {
        return this.decFormat;
    }

    public void setDecFormat(String decFormat) {
        this.decFormat = decFormat;
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }
}

