/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgAnalyseFilterParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseFilterUI;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgAnalyseFilterUI
extends AbstractBgAnalyseFilterUI {
    private static final long serialVersionUID = -2310294178563169069L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseFilterUI.class);
    private OrgUnitInfo currOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
    private CtrlUnitInfo currCU = SysContext.getSysContext().getCurrentCtrlUnit();
    private CurrencyInfo currencyInfo = null;
    private boolean hasUseFund = false;
    private static final String CURR_ORGUNIT_ID = "CURR_ORGUNIT_ID";
    private static final String ORGUNIT_IDS = "ORGUNIT_IDS";
    private static final String BGSCHEME_ID = "BGSCHEME_ID";
    private static final String BGPERIOD_ID_BEGIN = "BGPERIOD_ID_BEGIN";
    private static final String BGPERIOD_ID_END = "BGPERIOD_ID_END";
    private static final String CURRENCY_ID = "CURRENCY_ID";
    private static final String MEASUREUNIT_ID = "MEASUREUNIT_ID";

    public BgAnalyseFilterUI() throws Exception {
    }

    public BgAnalyseFilterUI(Object ui) throws Exception {
        this.ui = ui;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.initFilter();
    }

    protected IFullOrgUnit getOrgUnitInterface() throws Exception {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected IMeasureUnit getMuInterface() throws Exception {
        return MeasureUnitFactory.getRemoteInstance();
    }

    public CtrlUnitInfo getCtrlUnit() {
        return this.currCU;
    }

    public OrgUnitInfo getCurrOrgUnit() {
        return this.currOrgUnit;
    }

    public CurrencyInfo getCurrencyInfo() {
        return this.currencyInfo;
    }

    public void setCurrencyInfo(CurrencyInfo currencyInfo) {
        this.currencyInfo = currencyInfo;
    }

    public boolean isHasUseFund() {
        return this.hasUseFund;
    }

    protected void initFilter() throws Exception {
        this.initOrgUnit();
        this.initBgScheme();
        this.initBgPeriod();
        this.initCurrency();
        this.initMeasureUnit();
    }

    protected void initOrgUnit() throws Exception {
        BgOrgViewF7 orgView = new BgOrgViewF7((IUIObject)this);
        orgView.setTitle(BgAnalyseHelper.getMessage("orgUnitTitle"));
        orgView.setCuID(this.getCurrOrgUnit().getId().toString());
        orgView.setMultiSelect(this.isMultiSelect());
        orgView.setReturnSuperior(this.isReturnSuperior());
        if (this.ui != null) {
            orgView.setUIActionPK((IMetaDataPK)new MetaDataPK(this.ui.getClass().getName()), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        }
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgView);
        this.prmtOrgUnit.setEditable(false);
        if (this.ui != null) {
            Method method = null;
            try {
                BgAnalyseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAnalyseFilterParam)method.invoke(this.ui, null)) != null) {
                    this.prmtOrgUnit.setData((Object)filterParam.getOrgUnits());
                    return;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        this.prmtOrgUnit.setData((Object)this.getCurrOrgUnit());
    }

    protected boolean isMultiSelect() {
        return true;
    }

    protected boolean isReturnSuperior() {
        return true;
    }

    protected void initBgScheme() throws Exception {
        if (this.ui != null) {
            Method method = null;
            try {
                BgAnalyseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAnalyseFilterParam)method.invoke(this.ui, null)) != null) {
                    BgAnalyseHelper.setSelectObject(this.comBgScheme, filterParam.getBgScheme());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initBgPeriod() throws Exception {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriodBegin.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriodEnd.setSelector((KDPromptSelector)bgPeriodDialog);
        this.prmtBgPeriodBegin.setEditable(false);
        this.prmtBgPeriodEnd.setEditable(false);
    }

    protected void initCurrency() throws Exception {
        CurrencyInfo currencyInfo = null;
        OrgUnitInfo unitInfo = this.getCurrOrgUnit();
        BgNFCHelper.setCurrency((KDComboBox)this.comCurrency, null, (boolean)false);
        if (unitInfo != null) {
            currencyInfo = BgNFCHelper.getBaseCurrency((BOSUuid)unitInfo.getId());
            BgNFCHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)currencyInfo);
            this.setCurrencyInfo(currencyInfo);
        }
        if (this.ui != null) {
            Method method = null;
            try {
                BgAnalyseFilterParam filterParam;
                method = this.ui.getClass().getMethod("getFilterParam", null);
                if (method != null && (filterParam = (BgAnalyseFilterParam)method.invoke(this.ui, null)) != null) {
                    BgAnalyseHelper.setSelectObject(this.comCurrency, filterParam.getCurrency());
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
    }

    protected void initMeasureUnit() throws Exception {
        MeasureUnitCollection muCol = this.getMeasureUnitInfo();
        if (muCol != null && !muCol.isEmpty()) {
            this.comMeasureUnit.removeAllItems();
            this.comMeasureUnit.addItems(muCol.toArray());
            if (this.ui != null) {
                Method method = null;
                try {
                    BgAnalyseFilterParam filterParam;
                    method = this.ui.getClass().getMethod("getFilterParam", null);
                    if (method != null && (filterParam = (BgAnalyseFilterParam)method.invoke(this.ui, null)) != null) {
                        BgAnalyseHelper.setSelectObject(this.comMeasureUnit, filterParam.getMeasureUnit());
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    protected MeasureUnitCollection getMeasureUnitInfo() throws Exception {
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)0, CompareType.EQUALS));
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("coefficient"));
        return this.getMuInterface().getMeasureUnitCollection(muView);
    }

    public boolean verify() {
        boolean re = super.verify();
        if (re) {
            Object obj = this.prmtOrgUnit.getData();
            if (obj == null || obj instanceof String) {
                this.prmtOrgUnit.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectOrgUnit"));
                return false;
            }
            if (this.comBgScheme.getSelectedItem() == null) {
                this.comBgScheme.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgScheme"));
                return false;
            }
            if (this.comCurrency.getSelectedItem() == null) {
                this.comCurrency.requestFocus();
                MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectCurrency"));
                return false;
            }
            if (this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
                BgPeriodInfo begin = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
                BgPeriodInfo end = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
                if (!begin.getPeriodType().equals((Object)end.getPeriodType())) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((String)BgAnalyseHelper.getMessage("selectBgPeriodNoAccord"));
                    return false;
                }
                if (end.getBeginDate().compareTo(begin.getBeginDate()) == -1) {
                    this.prmtBgPeriodBegin.requestFocus();
                    MsgBox.showWarning((Component)((Object)this), (String)BgAnalyseHelper.getMessage("selectBgPeriodError"));
                    return false;
                }
            }
        }
        return re;
    }

    @Override
    public void clear() {
        super.clear();
        this.prmtOrgUnit.setData((Object)this.getCurrOrgUnit());
        if (this.comBgScheme.getItemCount() > 0) {
            this.comBgScheme.setSelectedIndex(0);
        }
        this.prmtBgPeriodBegin.setData(null);
        this.prmtBgPeriodEnd.setData(null);
        if (this.comCurrency.getItemCount() > 0) {
            CurrencyInfo currencyInfo = this.getCurrencyInfo();
            if (currencyInfo != null) {
                BgNFCHelper.setSelectObject((KDComboBox)this.comCurrency, (Object)currencyInfo);
            } else {
                this.comCurrency.setSelectedIndex(0);
            }
        }
        if (this.comMeasureUnit.getItemCount() > 0) {
            this.comMeasureUnit.setSelectedIndex(0);
        }
    }

    @Override
    protected void prmtOrgUnit_willShow(SelectorEvent e) throws Exception {
        super.prmtOrgUnit_willShow(e);
        if (this.prmtOrgUnit.getData() != null) {
            BgOrgViewF7 orgView = (BgOrgViewF7)this.prmtOrgUnit.getSelector();
            OrgUnitInfo unitInfo2 = null;
            OrgUnitInfo[] unitInfos = null;
            Object obj = this.prmtOrgUnit.getData();
            if (obj instanceof OrgUnitInfo) {
                unitInfo2 = (OrgUnitInfo)obj;
                HashSet<String> checked = new HashSet<String>();
                checked.add(unitInfo2.getId().toString());
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else if (obj instanceof OrgUnitInfo[]) {
                unitInfos = (OrgUnitInfo[])obj;
                HashSet<String> checked = new HashSet<String>();
                for (OrgUnitInfo unitInfo2 : unitInfos) {
                    checked.add(unitInfo2.getId().toString());
                }
                orgView.setCheckedOrgIDs(checked);
                orgView.refresh();
            } else {
                orgView.setCheckedOrgIDs(null);
            }
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.orgUnit_dataChanged(e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void orgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.comBgScheme.removeAllItems();
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null && !(obj instanceof String)) {
            HashSet<BOSUuid> subOrgUnits = null;
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _currOrgUnit = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)obj};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
            }
            subOrgUnits = new HashSet<BOSUuid>();
            if (orgUnits != null && orgUnits.length > 1) {
                _currOrgUnit = this.getCurrOrgUnit();
                if (!_currOrgUnit.getId().equals((Object)orgUnits[0].getId())) {
                    _currOrgUnit = orgUnits[0];
                }
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    if (_tmpOrgUnit2.getId().equals((Object)_currOrgUnit.getId())) continue;
                    subOrgUnits.add(_tmpOrgUnit2.getId());
                }
            } else if (orgUnits != null) {
                _currOrgUnit = orgUnits[0];
            }
            BgSchemeCollection bgSchemeCol = null;
            try {
                if (_currOrgUnit == null) return;
                bgSchemeCol = this.getBgSchemeInfo(_currOrgUnit.getId(), subOrgUnits, this.isHasUseFund(), false);
                this.comBgScheme.addItems(bgSchemeCol.toArray());
                return;
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
        } else {
            this.prmtBgPeriodBegin.setData(null);
            this.prmtBgPeriodEnd.setData(null);
            if (this.comCurrency.getItemCount() > 0) {
                this.comCurrency.setSelectedIndex(0);
            }
            if (this.comMeasureUnit.getItemCount() <= 0) return;
            this.comMeasureUnit.setSelectedIndex(0);
        }
    }

    protected BOSUuid[] getOrgUnitIds() throws Exception {
        BOSUuid[] orgUnitIds = null;
        Object obj = this.prmtOrgUnit.getData();
        if (obj != null && !(obj instanceof String)) {
            OrgUnitInfo[] orgUnits = null;
            OrgUnitInfo _tmpOrgUnit2 = null;
            if (obj instanceof OrgUnitInfo) {
                orgUnitIds = new BOSUuid[]{((OrgUnitInfo)obj).getId()};
            } else if (obj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])obj;
                orgUnitIds = new BOSUuid[orgUnits.length];
                for (OrgUnitInfo _tmpOrgUnit2 : orgUnits) {
                    orgUnitIds[i] = _tmpOrgUnit2.getId();
                }
            }
        }
        return orgUnitIds;
    }

    protected BgSchemeCollection getBgSchemeInfo(BOSUuid currCCOrgUnitId, Set subOrgUnits, boolean hasUseFund, boolean isFund) throws Exception {
        return this.getInterface().getCommonBgScheme(currCCOrgUnitId, subOrgUnits, hasUseFund, isFund, true);
    }

    @Override
    protected void comBgScheme_actionPerformed(ActionEvent e) throws Exception {
        super.comBgScheme_actionPerformed(e);
        this.bgScheme_actionPerformed(e);
    }

    protected void bgScheme_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void prmtBgPeriodBegin_dataChanged(DataChangeEvent e) throws Exception {
        this.bgPeriodBegin_dataChanged(e);
    }

    protected void bgPeriodBegin_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() instanceof BgPeriodInfo) {
            BgPeriodInfo _bgPeriodInfo = (BgPeriodInfo)e.getNewValue();
            if (this.prmtBgPeriodEnd.getData() == null) {
                this.prmtBgPeriodEnd.setData((Object)_bgPeriodInfo);
            }
            if (_bgPeriodInfo.getPeriodType().getValue() == 8) {
                this.prmtBgPeriodEnd.setEnabled(false);
                this.prmtBgPeriodEnd.setData((Object)_bgPeriodInfo);
            } else {
                this.prmtBgPeriodEnd.setEnabled(true);
                if (this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo && (_bgPeriodInfo = (BgPeriodInfo)this.prmtBgPeriodEnd.getData()).getPeriodType().getValue() == 8) {
                    this.prmtBgPeriodEnd.setData(null);
                }
            }
        } else if (!this.prmtBgPeriodEnd.isEnabled()) {
            this.prmtBgPeriodEnd.setData(null);
            this.prmtBgPeriodEnd.setEnabled(true);
        }
    }

    @Override
    protected void prmtBgPeriodEnd_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodEnd_dataChanged(e);
        this.bgPeriodEnd_dataChanged(e);
    }

    protected void bgPeriodEnd_dataChanged(DataChangeEvent e) throws Exception {
    }

    @Override
    protected void comCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comCurrency_actionPerformed(e);
        this.currency_actionPerformed(e);
    }

    protected void currency_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void comMeasureUnit_actionPerformed(ActionEvent e) throws Exception {
        super.comMeasureUnit_actionPerformed(e);
        this.measureUnit_actionPerformed(e);
    }

    protected void measureUnit_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected FilterParam createNewFilterParam() {
        return new BgAnalyseFilterParam();
    }

    @Override
    protected FilterParam getFilterParam(FilterParam mainParam, FilterParam filterParam) {
        if (mainParam == null) {
            mainParam = this.createNewFilterParam();
        }
        BgAnalyseFilterParam _mainParam = null;
        BgAnalyseFilterParam _filterParam = null;
        if (mainParam != null && filterParam != null) {
            _mainParam = (BgAnalyseFilterParam)mainParam;
            _filterParam = (BgAnalyseFilterParam)filterParam;
            if (_filterParam != null && _filterParam.getOrgUnits() != null) {
                _mainParam.setOrgUnits(_filterParam.getOrgUnits());
            } else {
                _mainParam.setOrgUnits(null);
            }
            if (_filterParam != null && _filterParam.getCurrOrgUnitInfo() != null) {
                _mainParam.setCurrOrgUnitInfo(_filterParam.getCurrOrgUnitInfo());
            } else {
                _mainParam.setCurrOrgUnitInfo(null);
            }
            if (_filterParam != null && _filterParam.getBgScheme() != null) {
                _mainParam.setBgScheme(_filterParam.getBgScheme());
            } else {
                _mainParam.setBgScheme(null);
            }
            if (_filterParam != null && _filterParam.getBgPeriodBegin() != null) {
                _mainParam.setBgPeriodBegin(_filterParam.getBgPeriodBegin());
            } else {
                _mainParam.setBgPeriodBegin(null);
            }
            if (_filterParam != null && _filterParam.getBgPeriodEnd() != null) {
                _mainParam.setBgPeriodEnd(_filterParam.getBgPeriodEnd());
            } else {
                _mainParam.setBgPeriodEnd(null);
            }
            if (_filterParam != null && _filterParam.getCurrency() != null) {
                _mainParam.setCurrency(_filterParam.getCurrency());
            } else {
                _mainParam.setCurrency(null);
            }
            if (_filterParam != null && _filterParam.getMeasureUnit() != null) {
                _mainParam.setMeasureUnit(_filterParam.getMeasureUnit());
            } else {
                _mainParam.setMeasureUnit(null);
            }
        }
        return _mainParam;
    }

    @Override
    protected void setFilterParam(FilterParam filterParam) {
        super.setFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseFilterParam) {
            BgAnalyseFilterParam _filterParam = (BgAnalyseFilterParam)filterParam;
            _filterParam.setCurrOrgUnitInfo(this.getCurrOrgUnit());
            OrgUnitInfo[] orgUnits = null;
            Object orgObj = this.prmtOrgUnit.getData();
            if (orgObj instanceof OrgUnitInfo) {
                orgUnits = new OrgUnitInfo[]{(OrgUnitInfo)orgObj};
            } else if (orgObj instanceof OrgUnitInfo[]) {
                orgUnits = (OrgUnitInfo[])orgObj;
            }
            _filterParam.setOrgUnits(orgUnits);
            _filterParam.setBgScheme((BgSchemeInfo)this.comBgScheme.getSelectedItem());
            if (this.prmtBgPeriodBegin.getData() != null) {
                _filterParam.setBgPeriodBegin((BgPeriodInfo)this.prmtBgPeriodBegin.getData());
            } else {
                _filterParam.setBgPeriodBegin(null);
            }
            if (this.prmtBgPeriodEnd.getData() != null) {
                _filterParam.setBgPeriodEnd((BgPeriodInfo)this.prmtBgPeriodEnd.getData());
            } else {
                _filterParam.setBgPeriodEnd(null);
            }
            if (this.comCurrency.getSelectedItem() != null) {
                _filterParam.setCurrency((CurrencyInfo)this.comCurrency.getSelectedItem());
            } else {
                _filterParam.setCurrency(null);
            }
            if (this.comMeasureUnit.getSelectedItem() != null) {
                _filterParam.setMeasureUnit((MeasureUnitInfo)this.comMeasureUnit.getSelectedItem());
            } else {
                _filterParam.setMeasureUnit(null);
            }
        }
    }

    @Override
    protected void getFilterParam(FilterParam filterParam) {
        super.getFilterParam(filterParam);
        if (filterParam != null && filterParam instanceof BgAnalyseFilterParam) {
            BgAnalyseFilterParam _filterParam = (BgAnalyseFilterParam)filterParam;
            this.getFilterParamBefore(_filterParam);
            if (_filterParam.getOrgUnits() != null) {
                this.prmtOrgUnit.setData((Object)_filterParam.getOrgUnits());
            } else {
                this.prmtOrgUnit.setData(null);
            }
            if (_filterParam.getBgScheme() != null) {
                BgAnalyseHelper.setSelectObject(this.comBgScheme, _filterParam.getBgScheme());
            }
            if (_filterParam.getBgPeriodBegin() != null) {
                this.prmtBgPeriodBegin.setData((Object)_filterParam.getBgPeriodBegin());
            } else {
                this.prmtBgPeriodBegin.setData(null);
            }
            if (_filterParam.getBgPeriodEnd() != null) {
                this.prmtBgPeriodEnd.setData((Object)_filterParam.getBgPeriodEnd());
            } else {
                this.prmtBgPeriodEnd.setData(null);
            }
            if (_filterParam.getCurrency() != null) {
                BgAnalyseHelper.setSelectObject(this.comCurrency, _filterParam.getCurrency());
            }
            if (_filterParam.getMeasureUnit() != null) {
                BgAnalyseHelper.setSelectObject(this.comMeasureUnit, _filterParam.getMeasureUnit());
            }
        }
    }

    protected void getFilterParamBefore(FilterParam filterParam) {
    }

    @Override
    protected void loadCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.loadCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseFilterParam)) {
            return;
        }
        String id = null;
        List ids = null;
        BgAnalyseFilterParam _filterParam = (BgAnalyseFilterParam)filterParam;
        try {
            id = cp.getCustomerParam(CURR_ORGUNIT_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setCurrOrgUnitInfo(new OrgUnitInfo());
                _filterParam.getCurrOrgUnitInfo().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setCurrOrgUnitInfo(null);
            }
            ids = (List)BgAnalyseHelper.getObject(BgAnalyseHelper.decode(cp.getCustomerParam(ORGUNIT_IDS)));
            if (ids != null) {
                _filterParam.setOrgUnits(new OrgUnitInfo[ids.size()]);
                int in = ids.size();
                for (int i = 0; i < in; ++i) {
                    id = (String)ids.get(i);
                    if (StringUtils.isEmpty((String)id)) continue;
                    _filterParam.getOrgUnits()[i] = new OrgUnitInfo();
                    _filterParam.getOrgUnits()[i].setId(BOSUuid.read((String)id));
                }
            } else {
                _filterParam.setOrgUnits(null);
            }
            id = cp.getCustomerParam(BGSCHEME_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setBgScheme(new BgSchemeInfo());
                _filterParam.getBgScheme().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setBgScheme(null);
            }
            id = cp.getCustomerParam(BGPERIOD_ID_BEGIN);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setBgPeriodBegin(new BgPeriodInfo());
                _filterParam.getBgPeriodBegin().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setBgPeriodBegin(null);
            }
            id = cp.getCustomerParam(BGPERIOD_ID_END);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setBgPeriodEnd(new BgPeriodInfo());
                _filterParam.getBgPeriodEnd().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setBgPeriodEnd(null);
            }
            id = cp.getCustomerParam(CURRENCY_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setCurrency(new CurrencyInfo());
                _filterParam.getCurrency().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setCurrency(null);
            }
            id = cp.getCustomerParam(MEASUREUNIT_ID);
            if (!StringUtils.isEmpty((String)id)) {
                _filterParam.setMeasureUnit(new MeasureUnitInfo());
                _filterParam.getMeasureUnit().setId(BOSUuid.read((String)id));
            } else {
                _filterParam.setMeasureUnit(null);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
    }

    @Override
    protected void saveCustomerParams(CustomerParams cp, FilterParam filterParam) {
        super.saveCustomerParams(cp, filterParam);
        if (cp == null || filterParam == null || !(filterParam instanceof BgAnalyseFilterParam)) {
            return;
        }
        ArrayList<String> tmpList = null;
        OrgUnitInfo _unitInfo = null;
        BgAnalyseFilterParam _filterParam = (BgAnalyseFilterParam)filterParam;
        if (_filterParam.getCurrOrgUnitInfo() != null) {
            cp.addCustomerParam(CURR_ORGUNIT_ID, _filterParam.getCurrOrgUnitInfo().getId().toString());
        } else {
            cp.removeCustomerParam(CURR_ORGUNIT_ID);
        }
        if (_filterParam.getOrgUnits() != null) {
            tmpList = new ArrayList<String>();
            int in = _filterParam.getOrgUnits().length;
            for (int i = 0; i < in; ++i) {
                _unitInfo = _filterParam.getOrgUnits()[i];
                if (_unitInfo == null) continue;
                tmpList.add(_unitInfo.getId().toString());
            }
            if (!tmpList.isEmpty()) {
                cp.addCustomerParam(ORGUNIT_IDS, BgAnalyseHelper.encode(BgAnalyseHelper.getBytes(tmpList)));
            } else {
                cp.removeCustomerParam(ORGUNIT_IDS);
            }
        } else {
            cp.removeCustomerParam(ORGUNIT_IDS);
        }
        if (_filterParam.getBgScheme() != null) {
            cp.addCustomerParam(BGSCHEME_ID, _filterParam.getBgScheme().getId().toString());
        } else {
            cp.removeCustomerParam(BGSCHEME_ID);
        }
        if (_filterParam.getBgPeriodBegin() != null) {
            cp.addCustomerParam(BGPERIOD_ID_BEGIN, _filterParam.getBgPeriodBegin().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID_BEGIN);
        }
        if (_filterParam.getBgPeriodEnd() != null) {
            cp.addCustomerParam(BGPERIOD_ID_END, _filterParam.getBgPeriodEnd().getId().toString());
        } else {
            cp.removeCustomerParam(BGPERIOD_ID_END);
        }
        if (_filterParam.getCurrency() != null) {
            cp.addCustomerParam(CURRENCY_ID, _filterParam.getCurrency().getId().toString());
        } else {
            cp.removeCustomerParam(CURRENCY_ID);
        }
        if (_filterParam.getMeasureUnit() != null) {
            cp.addCustomerParam(MEASUREUNIT_ID, _filterParam.getMeasureUnit().getId().toString());
        } else {
            cp.removeCustomerParam(MEASUREUNIT_ID);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (request == null) {
                request = new RequestContext();
                request.setClassName(this.getUIHandlerClassName());
                handler.setRequestContext((Serializable)request);
            }
            request.put("ORGUNIT_ID", (Object)this.getCurrOrgUnit().getId().toString());
        }
        return handler;
    }
}

