/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.excel.core.ICellDisplayProvider;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseFormQueryParam;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseFormQueryMainUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFormDisplayValueProvider;
import com.kingdee.eas.ma.budget.client.BgAnalyseFormQueryFilterUI;
import com.kingdee.eas.ma.budget.client.BudgetUserCellDisplayProvider;
import com.kingdee.eas.ma.budget.client.NumberExpendRender;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgAnalyseFormQueryMainUI
extends AbstractBgAnalyseFormQueryMainUI {
    private static final long serialVersionUID = -8555199908924972874L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseFormQueryMainUI.class);
    protected int selectPanelIndex = -1;
    protected boolean isOnload = false;
    protected String filePath = null;
    protected String resource = "com.kingdee.eas.ma.budget.client.BgAnalyseFormQueryResource";
    protected NumberExpendRender expendRender = null;
    protected Book sampleTable = null;
    protected Map itemFormulas = new HashMap();
    protected Map decFormatMap = new HashMap();
    protected Map tableFoOrg = null;
    protected OrgUnitInfo[] orgUnits = null;
    private Map currencyMap = null;
    private Map measreUnitMap = null;
    private Map formulaMap = null;
    private BgFormInfo returnBgFormInfo = null;
    protected boolean isCol = false;

    public BgAnalyseFormQueryMainUI() throws Exception {
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        OrgUnitInfo unit = SysContext.getSysContext().getCurrentOrgUnit();
        if (unit == null) {
            return;
        }
        this.verifyPermission(user.getId().toString(), unit.getId().toString());
    }

    protected void verifyPermission(String userId, String orgUnitId) throws BOSException, EASBizException {
        this.getPermissionInterface().checkFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), "bg_query01_query");
    }

    protected IPermission getPermissionInterface() throws BOSException {
        return PermissionFactory.getRemoteInstance();
    }

    @Override
    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage("bgFormQueryTitle"));
    }

    @Override
    protected String getQueryMainName() {
        return BgAnalyseFormQueryMainUI.class.getName();
    }

    @Override
    public void onLoad() throws Exception {
        this.currencyMap = new HashMap();
        this.measreUnitMap = new HashMap();
        this.formulaMap = new HashMap();
        this.loadAllCurrency();
        super.onLoad();
    }

    @Override
    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgAnalyseFormQueryFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
            }
        }
        return this.defaultFilterUI;
    }

    @Override
    protected void executeQuery() {
        this.isOnload = false;
        this.selectPanelIndex = -1;
        if (!StringUtils.isEmpty((String)this.filePath)) {
            this.clearAllFile(this.filePath);
        }
        this.filePath = "";
        if (this.getMainTabPane() != null) {
            KDPanel kdpanel = null;
            Component component = null;
            SpreadContext sc = null;
            Book book = null;
            int in = this.getMainTabPane().getComponentCount();
            for (int i = 0; i < in; ++i) {
                component = this.getMainTabPane().getComponent(i);
                if (component == null || !(component instanceof KDPanel)) continue;
                kdpanel = (KDPanel)component;
                int jn = kdpanel.getComponentCount();
                for (int j = 0; j < jn; ++j) {
                    component = kdpanel.getComponent(j);
                    if (component == null || !(component instanceof SpreadContext)) continue;
                    sc = (SpreadContext)component;
                    BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
                    a.setDisplayValueProvider(new BgAnalyseFormDisplayValueProvider((Component)((Object)this)));
                    sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
                    book = sc.getBook();
                    book.clear();
                    sc.removeAll();
                    sc.removeNotify();
                }
                kdpanel.removeAll();
            }
            this.getMainTabPane().removeAll();
        }
        if (this.defaultFilterParam == null || !(this.defaultFilterParam instanceof BgAnalyseFormQueryParam)) {
            return;
        }
        try {
            this.initMeasureUnitInfo();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        BgAnalyseFormQueryParam bgFormQueryParam = (BgAnalyseFormQueryParam)this.defaultFilterParam;
        this.getOrgUnit(bgFormQueryParam);
        this.isCol = bgFormQueryParam.isCol() && bgFormQueryParam.getOrgUnits().length > 1;
        this.formatTable(bgFormQueryParam);
        this.sampleTable = null;
        this.isOnload = true;
    }

    protected void onSheetActive(Sheet sheet) {
        if (sheet == null) {
            return;
        }
        Range range = sheet.getRange(0, 0);
        if (range != null) {
            range.select();
        }
        this.getSC().getSpread().scrollCellVisible(0, 0);
    }

    private void getOrgUnit(BgAnalyseFormQueryParam bgFormQueryParam) {
        try {
            this.orgUnits = new OrgUnitInfo[bgFormQueryParam.getOrgUnits().length];
            this.orgUnits = this.getInterFace().getHaveFormOrg(bgFormQueryParam);
            this.orgUnits = this.withoutNull(this.orgUnits);
            if (!(bgFormQueryParam.isCol() && this.orgUnits.length != bgFormQueryParam.getOrgUnits().length || bgFormQueryParam.isCol() || this.orgUnits.length == bgFormQueryParam.getOrgUnits().length)) {
                bgFormQueryParam.setOrgUnits(this.orgUnits);
            }
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatTable(BgAnalyseFormQueryParam bgFormQueryParam) {
        String tmpFilPath = "";
        Map tables = new HashMap();
        this.tableFoOrg = new Hashtable();
        HashMap<String, Object> org = new HashMap<String, Object>();
        try {
            org.put(this.orgUnits[0].getId().toString(), null);
            tables = this.getInterFace().getTableWithOrgs(bgFormQueryParam, org, this.isCol);
            if (this.isCol) {
                Book book = Book.Manager.getNewBook((String)"123", (int)1);
                String panelName = System.getProperty("user.dir") + "/BAFQ_Collect.data";
                this.clearAllFile(panelName);
                String key = this.orgUnits[0].getId().toString() + "Collect";
                this.tableFoOrg.put(panelName, key);
                if (tables.get(key) != null) {
                    this.filePath = this.filePath + panelName + "!";
                    BgAnalyseHelper.saveToFile(panelName, tables.get(key));
                }
                BgNFSHelper.disableCal((Book)book);
                BgNFSHelper.disableUndo((Book)book);
                this.addAnalyseSheet(book, EASResource.getString((String)this.resource, (String)"collect") + "_" + this.orgUnits[0].getName(), panelName);
                this.orgUnits = this.withoutMidOrg(this.orgUnits, bgFormQueryParam);
                this.orgUnits = this.withoutNull(this.orgUnits);
            }
            for (int i = 0; i < this.orgUnits.length; ++i) {
                if (this.orgUnits[i] == null) continue;
                Book book = Book.Manager.getNewBook((String)"123", (int)1);
                String panelName = System.getProperty("user.dir") + "/BAFQ_" + i + ".data";
                this.tableFoOrg.put(panelName, this.orgUnits[i].getId().toString());
                tmpFilPath = tmpFilPath + panelName + "!";
                if (tables.get(this.orgUnits[i].getId().toString()) != null) {
                    this.filePath = this.filePath + panelName + "!";
                    BgAnalyseHelper.saveToFile(panelName, tables.get(this.orgUnits[i].getId().toString()));
                }
                BgNFSHelper.disableCal((Book)book);
                BgNFSHelper.disableUndo((Book)book);
                this.addAnalyseSheet(book, this.orgUnits[i].getName(), panelName);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
            MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)this.resource, (String)"error") + e.toString()));
        }
        this.clearAllFile(tmpFilPath);
        this.showTable();
    }

    private void showTable() {
        KDPanel panel = this.getSelectPanel();
        if (panel == null) {
            return;
        }
        this.clearPanle();
        Book book = null;
        String name = panel.getName();
        if (this.notHaveData(name)) {
            this.addFileData(name);
        }
        SpreadContext delSc = null;
        Book delBook = null;
        for (int i = panel.getComponentCount() - 1; i >= 0; --i) {
            if (!(panel.getComponent(i) instanceof SpreadContext)) continue;
            delSc = (SpreadContext)panel.getComponent(i);
            delBook = delSc.getBook();
            if (delBook != null) {
                delBook.clear();
            }
            delSc.removeAll();
            delSc.removeNotify();
            panel.remove(panel.getComponent(i));
            break;
        }
        try {
            Object byteData = BgAnalyseHelper.getObject(BgAnalyseHelper.loadFormFile(name));
            if (byteData == null) {
                this.selectPanelIndex = this.getMainTabPane().getSelectedIndex();
                return;
            }
            book = IOHelper.unpackBook((byte[])((byte[])byteData));
            BgNFSHelper.disableCal((Book)book);
            BgNFSHelper.disableUndo((Book)book);
        }
        catch (Exception ex) {
            this.handUIException(ex);
            MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)this.resource, (String)"error") + ex.toString()));
        }
        String title = "";
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            if (!(panel.getComponent(i) instanceof SpreadContext)) continue;
            title = panel.getComponent(i).getName();
        }
        SpreadContext sc = new SpreadContext();
        BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
        a.setDisplayValueProvider(new BgAnalyseFormDisplayValueProvider((Component)((Object)this)));
        sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
        BgNFSHelper.setBookProtection((Book)book, (boolean)true, (List)BgNFSHelper.getIsNotEnumerateOperation());
        Sheet _sheet = null;
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            _sheet = book.getSheet(i);
            BgNFSHelper.setSheetProtection((Sheet)_sheet, (boolean)false, null);
            BgNFSHelper.setSheetProtection((Sheet)_sheet, (boolean)true, (List)BgNFSHelper.getIsNotEnumerateOperation());
        }
        sc.setBook(book);
        sc.setName(title);
        Range selectRange = sc.getBook().getSheet(0).getRange(0, 0);
        selectRange.select();
        sc.getSpread().scrollCellVisible(0, 0);
        panel.add((Component)sc, (Object)"Center");
        this.selectPanelIndex = this.getMainTabPane().getSelectedIndex();
        sc.addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                if (e.isSheetActive()) {
                    BgAnalyseFormQueryMainUI.this.onSheetActive(e.getSheet());
                }
            }
        });
    }

    private void addFileData(String panelName) {
        Map tables = new HashMap();
        HashMap<String, Object> org = new HashMap<String, Object>();
        BgAnalyseFormQueryParam bgFormQueryParam = (BgAnalyseFormQueryParam)this.defaultFilterParam;
        org.put((String)this.tableFoOrg.get(panelName), null);
        try {
            this.filePath = this.filePath + panelName + "!";
            tables = this.getInterFace().getTableWithOrgs(bgFormQueryParam, org, this.isCol);
            BgAnalyseHelper.saveToFile(panelName, tables.get((String)this.tableFoOrg.get(panelName)));
        }
        catch (Exception e) {
            this.handUIException(e);
            MsgBox.showError((Component)((Object)this), (String)(EASResource.getString((String)this.resource, (String)"error") + e.toString()));
        }
    }

    private boolean notHaveData(String panelName) {
        File file = null;
        file = new File(panelName);
        return !file.isFile();
    }

    private void clearPanle() {
        KDPanel panel = null;
        Component obj = null;
        if (this.selectPanelIndex == -1 || this.selectPanelIndex >= this.getMainTabPane().getComponentCount()) {
            return;
        }
        try {
            obj = this.getMainTabPane().getComponentAt(this.selectPanelIndex);
        }
        catch (Exception e) {
            return;
        }
        if (obj != null && obj instanceof KDPanel) {
            panel = (KDPanel)obj;
        }
        SpreadContext delSc = null;
        Book delBook = null;
        if (panel != null) {
            for (int i = panel.getComponentCount() - 1; i >= 0; --i) {
                if (!(panel.getComponent(i) instanceof SpreadContext)) continue;
                String title = ((SpreadContext)panel.getComponent(i)).getName();
                KDSeparator kdSep = new KDSeparator();
                kdSep.setName(title);
                delSc = (SpreadContext)panel.getComponent(i);
                delBook = delSc.getBook();
                BgNFSHelper.disableCal((Book)delBook);
                BgNFSHelper.disableUndo((Book)delBook);
                try {
                    BgAnalyseHelper.saveToFile(panel.getName(), IOHelper.packBook((Book)delBook));
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                if (delBook != null) {
                    delBook.clear();
                }
                delSc.removeAll();
                delSc.removeNotify();
                panel.remove(panel.getComponent(i));
                panel.add((Component)kdSep);
                break;
            }
        }
    }

    private OrgUnitInfo[] withoutMidOrg(OrgUnitInfo[] org, BgAnalyseFormQueryParam bgFormQueryParam) {
        String longNum;
        int i;
        String orgNum = "";
        org = (OrgUnitInfo[])bgFormQueryParam.getOrgUnits().clone();
        for (i = org.length - 1; i >= 0; --i) {
            longNum = org[i].getLongNumber();
            if (orgNum.lastIndexOf(longNum + "!") >= 0) continue;
            orgNum = orgNum + longNum;
        }
        for (i = org.length - 1; i >= 0; --i) {
            longNum = org[i].getLongNumber();
            if (orgNum.lastIndexOf(longNum + "!") < 0) continue;
            org[i] = null;
        }
        return org;
    }

    protected IBgAnalyseFacade getInterFace() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected OrgUnitInfo[] withoutNull(OrgUnitInfo[] orgCol) {
        Vector<OrgUnitInfo> orgs = new Vector<OrgUnitInfo>();
        OrgUnitInfo[] orgInfos = null;
        for (int i = 0; i < orgCol.length; ++i) {
            if (orgCol[i] == null) continue;
            orgs.add(orgCol[i]);
        }
        if (orgs.size() > 0) {
            orgInfos = new OrgUnitInfo[orgs.size()];
            for (int j = 0; j < orgs.size(); ++j) {
                orgInfos[j] = (OrgUnitInfo)orgs.get(j);
            }
        }
        return orgInfos;
    }

    @Override
    protected void TabPaneMain_stateChanged(ChangeEvent e) throws Exception {
        if (this.isOnload) {
            this.showTable();
        }
    }

    protected IFullOrgUnit getOrgUnitInterface() throws BOSException {
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected Book addAnalyseSheet(Book book, String title, String panelName) {
        if (this.getMainTabPane() == null) {
            return null;
        }
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.setName(panelName);
        SpreadContext sc = new SpreadContext();
        BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
        a.setDisplayValueProvider(new BgAnalyseFormDisplayValueProvider((Component)((Object)this)));
        sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
        sc.setBook(book);
        sc.setName(title);
        Range selectRange = sc.getBook().getSheet(0).getRange(0, 0);
        selectRange.select();
        sc.getSpread().scrollCellVisible(0, 0);
        panel.add((Component)sc, (Object)"Center");
        this.getMainTabPane().addTab(title, (Component)panel);
        BgNFSHelper.setBookProtection((Book)book, (boolean)true, (List)BgNFSHelper.getIsNotEnumerateOperation());
        Sheet _sheet = null;
        int in = book.getSheetCount();
        for (int i = 0; i < in; ++i) {
            _sheet = book.getSheet(i);
            BgNFSHelper.setSheetProtection((Sheet)_sheet, (boolean)true, (List)BgNFSHelper.getIsNotEnumerateOperation());
        }
        return book;
    }

    protected KDPanel getSelectPanel() {
        Component obj = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj != null && obj instanceof KDPanel) {
            return (KDPanel)obj;
        }
        return null;
    }

    @Override
    protected boolean hasSpreadContext() {
        return true;
    }

    @Override
    protected SpreadContext getSpreadContext() {
        return this.getSC();
    }

    protected SpreadContext getSC() {
        Component obj = null;
        Component objSC = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj != null && obj instanceof KDPanel) {
            for (int i = 0; i < ((KDPanel)obj).getComponentCount(); ++i) {
                objSC = ((KDPanel)obj).getComponent(i);
                if (objSC == null || !(objSC instanceof SpreadContext)) continue;
                return (SpreadContext)objSC;
            }
        }
        return null;
    }

    protected boolean checkBeforeWindowClosing() {
        if (this.filePath != null) {
            this.clearAllFile(this.filePath);
        }
        this.isOnload = false;
        return super.checkBeforeWindowClosing();
    }

    private void clearAllFile(String filePath2) {
        if (filePath2 == null || filePath2.trim().length() == 0) {
            return;
        }
        String[] fileP = filePath2.split("!");
        File file = null;
        for (int i = 0; i < fileP.length; ++i) {
            file = new File(fileP[i]);
            BgAnalyseHelper.deleteFile(file);
        }
    }

    public static String getNumberFormat(String str, int number) {
        if (str == null || number <= 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < number; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (this.filePath != null) {
            this.clearAllFile(this.filePath);
        }
        this.executeQuery();
        this.loadPrintConfigInfo();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSC() != null) {
            this.getSC().getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSC() != null) {
            this.getSC().getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        KDFileChooser fc = new KDFileChooser();
        fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"fileExport"));
        fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
        fc.setAcceptAllFileFilterUsed(false);
        String fileName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"excelFileName1");
        fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + File.separator + fileName));
        if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
            if (file.exists()) {
                int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                if (re == 1 || re == 2) {
                    return;
                }
                file.delete();
            }
            try {
                this.exportBookContent(file);
            }
            catch (Exception ex) {
                throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
            }
        }
    }

    private Book getSelectBook() {
        Component obj = null;
        SpreadContext sc = this.getSC();
        BudgetUserCellDisplayProvider a = new BudgetUserCellDisplayProvider();
        a.setDisplayValueProvider(new BgAnalyseFormDisplayValueProvider((Component)((Object)this)));
        sc.getRenderManager().setUserCellDisplayProvider((ICellDisplayProvider)a);
        for (int i = 0; i < sc.getComponentCount(); ++i) {
            obj = sc.getComponent(i);
            if (obj == null || !(obj instanceof KDSpread)) continue;
            KDSpread sp = (KDSpread)obj;
            return sp.getBook();
        }
        return null;
    }

    protected void exportBookContent(File file) throws Exception {
        Book _book = this.getSelectBook();
        Sheet _sheet = null;
        Cell _cell = null;
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        Object _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            if (_sheet.isHide()) continue;
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (_cell == null) continue;
                    StyleAttributes ssa = Styles.getSA((ShareStyleAttributes)_cell.getSSA());
                    ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    _kdsSheet.setCell(_rowIndex, _colIndex, (Object)_cell.getValue(), (ShareStyleAttributes)ssa);
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    public Map getMeasreUnitMap() {
        return this.measreUnitMap;
    }

    public void setMeasreUnitMap(Map measreUnitMap) {
        this.measreUnitMap = measreUnitMap;
    }

    public Map getCurrencyMap() {
        return this.currencyMap;
    }

    public void setCurrencyMap(Map currencyMap) {
        this.currencyMap = currencyMap;
    }

    protected void initMeasureUnitInfo() throws Exception {
        this.setMeasreUnitMap(BgNFSHelper.getMeasureUnitMap((BgFormInfo)this.getBgFormInfo(this)));
        if (this.getMeasreUnitMap() == null) {
            this.setMeasreUnitMap(new HashMap());
        }
    }

    public Map getFormulaMap() {
        return this.formulaMap;
    }

    public void setFormulaMap(Map formulaMap) {
        this.formulaMap = formulaMap;
    }

    public BgFormInfo getBgFormInfo(BgAnalyseFormQueryMainUI editUI) {
        BOSUuid id = null;
        if (this.defaultFilterParam instanceof BgAnalyseFormQueryParam) {
            id = ((BgAnalyseFormQueryParam)this.defaultFilterParam).getBgFormInfo().getId();
        }
        if (id != null && this.returnBgFormInfo != null && id.equals((Object)this.returnBgFormInfo.getId())) {
            return this.returnBgFormInfo;
        }
        try {
            if (id != null) {
                this.returnBgFormInfo = this.getFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(id), this.getBgFormInfo());
            }
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            logger.error((Object)e);
            this.handleException((Exception)((Object)e));
        }
        return this.returnBgFormInfo;
    }

    protected IBgForm getFormInterface() throws BOSException {
        return BgFormFactory.getRemoteInstance();
    }

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        return sic;
    }

    protected void loadAllCurrency() throws BOSException, EASBizException {
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
        if (iCurrency != null) {
            currencyCol = iCurrency.getCurrencyCollection();
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                this.currencyMap.put(currencyInfo2.getNumber(), currencyInfo2);
            }
        } else {
            throw new BgFormException(BgFormException.NOINSTANCE);
        }
    }

    @Override
    protected int getHeightOfDialog() {
        return 350;
    }

    @Override
    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            // empty if block
        }
        return re;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("USER_ID", (Object)this.getUserPk().toString());
            request.put("ORGUNIT_ID", (Object)SysContext.getSysContext().getCurrentCostUnit().getId().toString());
        }
        return handler;
    }
}

