/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.print.PrintBookTrans;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSCell;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.IDObject;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryPanel;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.popup.MenuSection;
import com.kingdee.eas.framework.client.popup.PopupMenuManager;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgAnalyseHelper;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.PrintConfigInfo;
import com.kingdee.eas.ma.budget.analysiscolumn.RatePopoInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgAnalyseMainBaseUI;
import com.kingdee.eas.ma.budget.client.BgAdjustAnalysisListUI;
import com.kingdee.eas.ma.budget.client.BgAnalyseFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.nbudget.BgExportHelper;
import com.kingdee.eas.ma.nbudget.BgNFormException;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.ExcelFileFilter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgAnalyseMainBaseUI
extends AbstractBgAnalyseMainBaseUI {
    private static final long serialVersionUID = -7969191034562152704L;
    private static final Logger logger = CoreUIObject.getLogger(BgAnalyseMainBaseUI.class);
    protected IMetaDataPK mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    public static final String COEFFICIENT = "Coefficient";
    protected BgAnalyseFilterBaseUI defaultFilterUI = null;
    protected FilterParam defaultFilterParam = null;
    private CommonQueryDialog dialog = null;
    private CurrencyInfo currency = null;
    private static final String SHEETID = "SHEETID1";
    private BOSUuid solutionId = null;

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public IMetaDataPK getQueryPk() {
        return this.mainQueryPk;
    }

    protected BOSUuid getSolutionId() {
        return this.solutionId;
    }

    protected void setSolutionId(BOSUuid solutionId) {
        this.solutionId = solutionId;
    }

    protected static String getSHEETID() {
        return SHEETID;
    }

    protected IBgAnalyseFacade getInterface() throws Exception {
        return BgAnalyseFacadeFactory.getRemoteInstance();
    }

    protected ActionManager getSpreadActionManager() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        SpreadContext sc = this.getSpreadContext();
        if (sc != null) {
            this.menuItemFreeze.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadContext sc = BgAnalyseMainBaseUI.this.getSpreadContext();
                    ActionManager am = sc.getActionManager();
                    am.getAction("Freeze").actionPerformed(e);
                }
            });
            this.menuItemCancelFreeze.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadContext sc = BgAnalyseMainBaseUI.this.getSpreadContext();
                    ActionManager am = sc.getActionManager();
                    am.getAction("Unfreeze").actionPerformed(e);
                }
            });
        } else {
            this.menuItemFreeze.setVisible(false);
            this.menuItemCancelFreeze.setVisible(false);
            this.menuWindow.setVisible(false);
        }
        this.setUITitle();
        Object _obj = this.getUIContext().get("ANALYSEINFO");
        if (_obj instanceof FilterParam) {
            this.setFilterParam((FilterParam)_obj);
            this.executeQuery();
        } else {
            boolean hasDefaultQuery = this.getDefaultFilterParam();
            if (hasDefaultQuery) {
                this.executeQuery();
                this.loadPrintConfigInfo();
            } else {
                this.dialog = this.getCommonQueryDialog();
                if (this.dialog.show()) {
                    CommonQueryPanel queryPanel = this.dialog.getCommonqueryPanel();
                    this.solutionId = queryPanel.getCurrentSolution() != null ? queryPanel.getCurrentSolution().getId() : null;
                    this.setFilterParam(this.getFilterUI().getCustomerParams());
                    if (this.hasOtherFilterUI()) {
                        KDPanel[] panels = this.getOtherFilterUI();
                        int n = panels.length;
                        for (int i = 0; i < n; ++i) {
                            this.setFilterParam(((CustomerQueryPanel)panels[i]).getCustomerParams());
                        }
                    }
                    this.executeQuery();
                    this.loadPrintConfigInfo();
                } else {
                    SysUtil.abort();
                }
            }
        }
    }

    public void onShow() throws Exception {
        super.onShow();
        Map map = this.tHelper.getUiTables();
        if (map != null) {
            KDTable table2 = null;
            for (KDTable table2 : map.keySet()) {
                PopupMenuManager menus;
                if (table2 == null || (menus = this.getPopupMenuManager((JComponent)table2)) == null) continue;
                MenuSection menuSection = this.getPopupMenuManager((JComponent)table2).findMenuSection("table");
            }
        }
    }

    public void addCommonMenusToTable(KDTable table) {
        super.addCommonMenusToTable(table);
        this.getMenuManager(table);
        Object obj = this.actionExport.getItemAction().getValue("srcTable");
        if (obj instanceof KDTable) {
            // empty if block
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        int id = e.getID();
        switch (id) {
            case 501: {
                break;
            }
            case 502: {
                break;
            }
            case 500: {
                break;
            }
            case 505: {
                break;
            }
        }
    }

    protected void initUserConfig() {
        Object obj;
        KDTMenuManager ktm;
        KDPopupMenu menus;
        super.initUserConfig();
        Map map = this.tHelper.getUiTables();
        if (map != null) {
            KDTable table2 = null;
            for (KDTable table2 : map.keySet()) {
                this.tHelper.getActionRestoreDefault(table2);
                if (table2 == null || (menus = this.getPopupMenuManager((JComponent)table2)) == null) continue;
                MenuSection menuSection = this.getPopupMenuManager((JComponent)table2).findMenuSection("table");
            }
        }
        if ((ktm = this.getMenuManager((KDTable)(obj = this.actionExport.getItemAction().getValue("srcTable")))) == null || (menus = ktm.getMenu()) != null) {
            // empty if block
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnRefresh.setIsControlByParent(false);
        this.btnQuery.setIsControlByParent(false);
        this.btnExport.setIsControlByParent(false);
        this.btnPrint.setIsControlByParent(false);
        this.btnPrintPreview.setIsControlByParent(false);
        this.btnRefresh.setTextIconDisStyle((short)2);
        this.btnQuery.setTextIconDisStyle((short)2);
        this.btnExport.setTextIconDisStyle((short)2);
        this.btnPrint.setTextIconDisStyle((short)2);
        this.btnPrintPreview.setTextIconDisStyle((short)2);
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
    }

    protected void setUITitle() {
        this.setUITitle(BgAnalyseHelper.getMessage("mainTitle"));
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            this.solutionId = ds.getId();
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            this.setFilterParam(cp);
        }
        return this.getFilterParam() != null;
    }

    protected String getQueryMainName() {
        return BgAnalyseMainBaseUI.class.getName();
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.setFilterParam((FilterParam)this.getFilterUI().getFilterObject(cp));
    }

    public void setFilterParam(FilterParam filterParam) {
        if (filterParam == null) {
            filterParam = this.getFilterUI().createNewFilterParam();
        }
        this.defaultFilterParam = filterParam;
    }

    public FilterParam getFilterParam() {
        return this.defaultFilterParam;
    }

    protected BgAnalyseFilterBaseUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgAnalyseFilterBaseUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        this.dialog.setTitle(this.getFilterUI().getUITitle());
        this.dialog.setWidth(this.getWidthOfDialog());
        this.dialog.setHeight(this.getHeightOfDialog());
        this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        if (this.hasOtherFilterUI()) {
            KDPanel[] other = this.getOtherFilterUI();
            int n = other.length;
            for (int i = 0; i < n; ++i) {
                this.dialog.addUserPanel(other[i]);
            }
        }
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    protected int getWidthOfDialog() {
        return 290;
    }

    protected int getHeightOfDialog() {
        return 280;
    }

    protected boolean hasOtherFilterUI() {
        return false;
    }

    protected KDPanel[] getOtherFilterUI() {
        return null;
    }

    public void query() {
        this.executeQuery();
    }

    protected void executeQuery() {
    }

    protected boolean hasSpreadContext() {
        return false;
    }

    protected KDTabbedPane getMainTabPane() {
        return this.TabPaneMain;
    }

    protected SpreadContext getSpreadContext() {
        return null;
    }

    protected void clearAnalyseSheet() {
        if (this.getMainTabPane() != null) {
            this.getMainTabPane().removeAll();
        }
    }

    protected void enableOAMenu(KDTable table) {
        super.enableOAMenu(table);
        if (table != null) {
            KDTMenuManager tm = this.getMenuManager(table);
            Component[] menus = tm.getMenu().getComponents();
            for (int i = 0; i < menus.length; ++i) {
                if (!(menus[i] instanceof JMenuItem)) continue;
                JMenuItem menu = (JMenuItem)menus[i];
                menu.setVisible(true);
            }
        }
    }

    protected KDTable addAnalyseSheet(KDTable sheet, String sheetId, String title) {
        if (this.getMainTabPane() == null) {
            return null;
        }
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        KDTable nSheet = new KDTable();
        if (!StringUtils.isEmpty((String)sheetId)) {
            nSheet.setID(sheetId);
        } else {
            nSheet.setID(BOSUuid.create((String)BgAnalyseMainBaseUI.getSHEETID()).toString());
        }
        nSheet.setName(title == null ? "" : title);
        panel.add((Component)nSheet, (Object)"Center");
        this.getMainTabPane().addTab(nSheet.getName(), (Component)panel);
        this.dealListener(nSheet);
        this.dealStyleOfTable(sheet, nSheet);
        this.dealMergeManager(sheet, nSheet);
        this.enableOAMenu(nSheet);
        return nSheet;
    }

    protected KDTable addAnalyseSheet(KDTable sheet, String sheetId, String title, boolean isShowPopMenu) {
        if (this.getMainTabPane() == null) {
            return null;
        }
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        KDTable nSheet = new KDTable();
        if (!StringUtils.isEmpty((String)sheetId)) {
            nSheet.setID(sheetId);
        } else {
            nSheet.setID(BOSUuid.create((String)BgAnalyseMainBaseUI.getSHEETID()).toString());
        }
        nSheet.setName(title == null ? "" : title);
        panel.add((Component)nSheet, (Object)"Center");
        this.getMainTabPane().addTab(nSheet.getName(), (Component)panel);
        this.dealListener(nSheet);
        this.dealStyleOfTable(sheet, nSheet);
        this.dealMergeManager(sheet, nSheet);
        if (isShowPopMenu) {
            this.enableOAMenu(nSheet);
        }
        return nSheet;
    }

    protected KDTable addAnalyseSheet(String title) {
        return this.addAnalyseSheet(null, BOSUuid.create((String)BgAnalyseMainBaseUI.getSHEETID()).toString(), title);
    }

    protected KDTable addAnalyseSheet(String sheetId, String title) {
        return this.addAnalyseSheet(null, sheetId, title);
    }

    protected KDTable addAnalyseSheet(String sheetId, String title, boolean isShowPopMenu) {
        return this.addAnalyseSheet(null, sheetId, title, isShowPopMenu);
    }

    protected KDTable addAnalyseSheet(KDTable sheet, String title) {
        return this.addAnalyseSheet(sheet, BOSUuid.create((String)BgAnalyseMainBaseUI.getSHEETID()).toString(), title);
    }

    protected int getSheetSize() {
        int sheetSize = 0;
        Component obj = null;
        int in = this.getMainTabPane().getTabCount();
        for (int i = 0; i < in; ++i) {
            obj = this.getMainTabPane().getComponentAt(i);
            if (obj instanceof KDTable) {
                sheetSize = 1;
                continue;
            }
            if (!(obj instanceof KDPanel)) continue;
            KDPanel panel = (KDPanel)obj;
            int jn = panel.getComponentCount();
            for (int j = 0; j < jn; ++j) {
                obj = panel.getComponent(j);
                if (!(obj instanceof KDTable)) continue;
                ++sheetSize;
            }
        }
        return sheetSize;
    }

    protected Object getSelectSheet() {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getSelectedComponent();
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
                break;
            }
        }
        return sheet;
    }

    protected Object getSheet(int index) {
        Component obj = null;
        KDTable sheet = null;
        obj = this.getMainTabPane().getComponentAt(index);
        if (obj instanceof KDTable) {
            return (KDTable)obj;
        }
        if (obj instanceof KDPanel) {
            KDPanel panel = (KDPanel)obj;
            int n = panel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                obj = panel.getComponent(i);
                if (!(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
            }
        }
        return sheet;
    }

    protected Object formatCellDisplay(int rowIndex, int colIndex, ICell cell, Object value) {
        return value;
    }

    protected void dealListener(KDTable sheet) {
        if (sheet == null) {
            return;
        }
        sheet.setUserCellDisplayParser((IUserCellDisplayParser)new AnalyseCellDisplayParser());
    }

    protected void dealStyleOfTable(KDTable sheet, KDTable nSheet) {
    }

    protected void dealExpandOrgUnit(KDTable sheet) {
    }

    protected void dealMergeManager(KDTable table, KDTable nTable) {
        List mblist;
        if (table == null || nTable == null) {
            return;
        }
        int top = 0;
        int left = 0;
        ICell cell = null;
        Object obj = null;
        if (table.getMergeManager() != null && (mblist = table.getMergeManager().getMergeBlockList()) != null && !mblist.isEmpty()) {
            KDTMergeBlock mb = null;
            int n = mblist.size();
            for (int i = 0; i < n; ++i) {
                mb = (KDTMergeBlock)mblist.get(i);
                top = mb.getTop();
                obj = table.getCell(top, left = mb.getLeft()).getValue();
                if (obj == null) continue;
                int xn = mb.getRight();
                for (int x = mb.getLeft(); x <= xn; ++x) {
                    int yn = mb.getBottom();
                    for (int y = mb.getTop(); y <= yn; ++y) {
                        cell = nTable.getCell(y, x);
                        if (cell == null) continue;
                        cell.setValue(obj);
                    }
                }
            }
        }
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        CommonQueryDialog dialog = this.getCommonQueryDialog();
        if (dialog.show()) {
            CommonQueryPanel queryPanel;
            this.setFilterParam(this.getFilterUI().getCustomerParams());
            if (this.hasOtherFilterUI()) {
                KDPanel[] panels = this.getOtherFilterUI();
                int n = panels.length;
                for (int i = 0; i < n; ++i) {
                    this.setFilterParam(((CustomerQueryPanel)panels[i]).getCustomerParams());
                }
            }
            if ((queryPanel = dialog.getCommonqueryPanel()).getCurrentSolution() != null) {
                this.solutionId = queryPanel.getCurrentSolution().getId();
            }
            this.executeQuery();
            this.loadPrintConfigInfo();
        }
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.executeQuery();
        this.loadPrintConfigInfo();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        if (this.hasSpreadContext()) {
            SpreadContext sc = this.getSpreadContext();
            if (sc != null) {
                sc.getPrintManager().print();
            }
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            this.preparePrintPage(_table);
            _table.getPrintManager().print();
        }
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        if (this.hasSpreadContext()) {
            SpreadContext sc = this.getSpreadContext();
            if (sc != null) {
                sc.getPrintManager().printPreview();
            }
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            _table.getDataRequestManager().setDataRequestMode(0);
            this.preparePrintPage(_table);
            _table.getPrintManager().printPreview();
        }
        this.setPrintConfigInfo();
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        if (this.hasSpreadContext()) {
            File file;
            KDFileChooser fc = new KDFileChooser();
            fc.setDialogTitle(BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.nbudget.client.BgIEResource", (String)"fileExport"));
            fc.addChoosableFileFilter((FileFilter)new ExcelFileFilter());
            fc.setAcceptAllFileFilterUsed(false);
            String fileSelecName = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.NewAnalysisResource", (String)"excelFileName1");
            fc.setSelectedFile(new File(BgExportHelper.getDefaultDirtory() + File.separator + fileSelecName));
            if (fc.showSaveDialog((Component)((Object)this)) == 0 && (file = fc.getSelectedFile()) != null) {
                if (file.exists()) {
                    int re = MsgBox.showConfirm3((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"existsFile"));
                    if (re == 1 || re == 2) {
                        return;
                    }
                    file.delete();
                }
                try {
                    this.exportBookContent(file);
                }
                catch (Exception ex) {
                    throw new BgNFormException(BgNFormException.FILEEXPORTERROR);
                }
            }
        } else {
            Object _obj = this.getSelectSheet();
            if (_obj == null || !(_obj instanceof KDTable)) {
                return;
            }
            KDTable _table = (KDTable)_obj;
            BgClientHelper.exportTableToExcel((Component)((Object)this), _table);
        }
    }

    private void exportBookContent(File file) throws Exception {
        Book _book = this.getSpreadContext().getBook();
        Sheet _sheet = null;
        Cell _cell = null;
        String numFormater = this.getNumberFormat(null);
        KDSBook _kdsBook = null;
        KDSSheet _kdsSheet = null;
        KDSCell _kdsCell = null;
        int _sheetIndex = 0;
        int _sheetSize = _book.getSheetCount();
        int _rowIndex = 0;
        int _rowCount = 0;
        int _colIndex = 0;
        int _colCount = 0;
        String _filename = file.getPath();
        _kdsBook = new KDSBook(_filename);
        for (_sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
            _sheet = _book.getSheet(_sheetIndex);
            _kdsSheet = new KDSSheet(_kdsBook, _sheet.getSheetName());
            _kdsBook.addSheet(null, _kdsSheet);
            _rowCount = _sheet.getMaxRowIndex();
            _colCount = _sheet.getMaxColIndex();
            for (_rowIndex = 0; _rowIndex <= _rowCount; ++_rowIndex) {
                for (_colIndex = 0; _colIndex <= _colCount; ++_colIndex) {
                    _cell = _sheet.getCell(_rowIndex, _colIndex, false);
                    if (_cell == null) {
                        _kdsCell = _kdsSheet.getCell(_rowIndex, _colIndex, true);
                        continue;
                    }
                    StyleAttributes ssa = Styles.getEmptySA();
                    _cell.getSheet().getRange(_cell).getStyle(ssa);
                    if (_cell == null || _cell.getValue() == Variant.nullVariant) continue;
                    Variant value = _cell.getValue();
                    if (value.getValue() instanceof BigDecimal) {
                        if (StringUtils.isEmpty((String)ssa.getNumberFormat())) {
                            ssa.setNumberFormat(numFormater);
                        }
                        ssa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                    }
                    _kdsCell = _kdsSheet.setCell(_rowIndex, _colIndex, (Object)value, (ShareStyleAttributes)ssa);
                }
            }
        }
        ExportManager em = new ExportManager();
        em.exportToExcel(_kdsBook, _filename);
    }

    public boolean destroyWindow() {
        boolean re = super.destroyWindow();
        if (re) {
            this.destroyTabPane();
            if (this.dialog != null) {
                if (this.dialog.getUserPanels() != null) {
                    KDPanel panel = null;
                    int in = this.dialog.getUserPanels().size();
                    for (int i = 0; i < in; ++i) {
                        panel = this.dialog.getUserPanel(i);
                        if (panel == null || !(panel instanceof IUIObject)) continue;
                        ((IUIObject)panel).destroyWindow();
                    }
                }
                if (this.dialog.getWindow() != null) {
                    if (this.dialog.getWindow().getUIObject() != null) {
                        this.dialog.getWindow().getUIObject().destroyWindow();
                    }
                    this.dialog.getWindow().close();
                }
            }
            if (this.getFilterUI() != null) {
                this.getFilterUI().destroyWindow();
            }
            this.removeNotify();
        }
        return re;
    }

    protected void destroyTabPane() {
        Component obj = null;
        KDTable sheet = null;
        KDPanel panel = null;
        int in = this.getMainTabPane().getComponentCount();
        for (int i = 0; i < in; ++i) {
            obj = this.getMainTabPane().getComponent(i);
            if (obj == null || !(obj instanceof KDPanel)) continue;
            panel = (KDPanel)obj;
            int jn = panel.getComponentCount();
            for (int j = 0; j < jn; ++j) {
                obj = panel.getComponent(j);
                if (obj == null || !(obj instanceof KDTable)) continue;
                sheet = (KDTable)obj;
                sheet.removeAll();
            }
        }
        this.getMainTabPane().removeAll();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUDGETMANAGEMENT;
    }

    protected KDTable getTableForOA() {
        Object _obj = this.getSelectSheet();
        if (_obj == null || !(_obj instanceof KDTable)) {
            return null;
        }
        return (KDTable)_obj;
    }

    protected Object getLastEntityViewInfo() {
        return "";
    }

    protected void setPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
        Book _book = null;
        KDF _kdf = null;
        KDTable _table = null;
        PrintConfigInfo printConfigInfo = new PrintConfigInfo();
        if (this.hasSpreadContext()) {
            int sheetSize = this.getSpreadContext().getBook().getSheetCount();
            _book = Book.Manager.getNewBook((String)"PRINT", (int)sheetSize);
            PrintBookTrans.copyPrintSetup((Book)this.getSpreadContext().getBook(), (Book)_book);
            printConfigInfo.setData(IOHelper.packBook((Book)_book));
        } else {
            _kdf = new KDF();
            int in = this.getSheetSize();
            for (int i = 0; i < in; ++i) {
                _table = (KDTable)this.getSheet(i);
                _kdf.addTable((IDObject)_table);
                _table.getPrintManager().saveToKDF(_kdf);
            }
            printConfigInfo.setData(ZipKDF.pack((KDF)_kdf));
        }
        this.getInterface().setPrintConfig(this.solutionId.toString(), printConfigInfo);
    }

    protected void loadPrintConfigInfo() throws Exception {
        if (this.solutionId == null) {
            return;
        }
        PrintConfigInfo configInfo = null;
        configInfo = (PrintConfigInfo)this.getInterface().getPrintConfig(this.solutionId.toString());
        if (configInfo.getData() != null && configInfo.getData().length > 0) {
            if (this.hasSpreadContext()) {
                Book _book = null;
                _book = IOHelper.unpackBook((byte[])configInfo.getData());
                if (this.getSpreadContext() != null && this.getSpreadContext().getBook() != null && _book != null && _book.getSheetCount() == this.getSpreadContext().getBook().getSheetCount()) {
                    PrintBookTrans.copyPrintSetup((Book)_book, (Book)this.getSpreadContext().getBook());
                }
            } else {
                KDF _kdf = null;
                KDTable _table = null;
                _kdf = ZipKDF.unpack((byte[])configInfo.getData());
                int in = this.getSheetSize();
                for (int i = 0; i < in; ++i) {
                    _table = (KDTable)this.getSheet(i);
                    _table.getPrintManager().setFromKDF(_kdf);
                }
            }
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            if (request == null) {
                request = new RequestContext();
                request.setClassName(this.getUIHandlerClassName());
                handler.setRequestContext((Serializable)request);
            }
            request.put("QUERY_NAME", (Object)this.getQueryMainName());
            request.put("QUERY_PK_NAME", (Object)this.mainQueryPk.getFullName());
        }
        return handler;
    }

    public void setCellValue(Sheet sheet, int rowIndex, int colIndex, Object value, BigDecimal coefficient) {
        if (sheet == null || rowIndex < 0 || colIndex < 0 || value == null) {
            return;
        }
        Cell cell = sheet.getCell(rowIndex, colIndex, true);
        cell.removeUserObject(COEFFICIENT);
        cell.setValue(new Variant(value));
        if (value instanceof BigDecimal) {
            if (coefficient != null) {
                cell.setUserObject(COEFFICIENT, (Object)coefficient);
            }
            StyleAttributes numSsa = Styles.getEmptySA();
            StyleAttributes sa = Styles.getEmptySA();
            sheet.getRange(cell).getStyle(numSsa, sa);
            numSsa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            numSsa.setNumberFormat(this.getNumberFormat(cell));
            cell.setSSA((ShareStyleAttributes)numSsa);
            sheet.getRange(cell).setStyle(numSsa, sa);
        } else if (value instanceof RatePopoInfo) {
            RatePopoInfo rpi = (RatePopoInfo)value;
            if (this.getCurrency() != null) {
                rpi.setScale(this.getCurrency().getPrecision());
            }
            if (this.getUIContext().get("Owner") instanceof BgAdjustAnalysisListUI && rpi.getFenzi().compareTo(RatePopoInfo.ZERO) != 0) {
                rpi.resetFenmuForAdjustAnalyse();
            }
            if (!rpi.isReInitInfo()) {
                rpi.initReuslt();
            }
            if (!rpi.isFenmuZero()) {
                StyleAttributes numSsa = Styles.getEmptySA();
                StyleAttributes sa = Styles.getEmptySA();
                sheet.getRange(cell).getStyle(numSsa, sa);
                numSsa.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                numSsa.setNumberFormat(rpi.getNumberFormat());
                cell.setValue(new Variant((Object)rpi.getResult1()));
                sheet.getRange(cell).setStyle(numSsa, sa);
            }
        }
    }

    public String getNumberFormat(Cell cell) {
        int prec = 2;
        if (this.getCurrency() != null) {
            prec = this.getCurrency().getPrecision();
        }
        return this.getNumberFormat(prec);
    }

    public String getNumberFormat(int prec) {
        StringBuffer sb = new StringBuffer("#,##0.");
        for (int i = 0; i < prec; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    private final class AnalyseCellDisplayParser
    implements IUserCellDisplayParser {
        private AnalyseCellDisplayParser() {
        }

        public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
            return BgAnalyseMainBaseUI.this.formatCellDisplay(rowIndex, colIndex, cell, value);
        }
    }
}

