/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.ma.budget.BgAvlBalDetailInfo;
import com.kingdee.eas.ma.budget.BgBudgetFacadeFactory;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgGetPeriodTypeForGetBlanceEnum;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BudgetCtrlConstants;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.BudgetCtrlUtil;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgAvlBalDetailUI;
import com.kingdee.eas.ma.nbudget.BgNConstants;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BgAvlBalDetailUI
extends AbstractBgAvlBalDetailUI {
    private static final long serialVersionUID = -7313453759370705484L;
    public static final String bgDataId = "bgDataId";
    public static final String isCtrl = "isCtrl";
    public static final String formatStyle = "formatStyle";
    public static final String balTypeEnum = "balTypeEnum";
    protected BgAvlBalDetailInfo detailInfo = null;
    protected Map itemKey2NameMap = new HashMap();
    protected static final String add = "+";
    protected static final String subtract = "-";
    protected static final String multiply = "*";
    protected static final String divide = "/";
    protected static final String equal = "=";
    protected static final String leftSmallBracket = "(";
    protected static final String rightSmallBracket = ")";
    protected static final String leftBigBracket = "[";
    protected static final String rightBigBracket = "]";
    protected static final String newLineSpliter = "\n";
    protected DecimalFormat floatFormater = BgNationalFormatUIUtil.getDecimalFormat(2);
    protected DecimalFormat longFormater = BgNationalFormatUIUtil.getDecimalFormat(2);

    public void onLoad() throws Exception {
        super.onLoad();
        this.getRemoteData();
        this.initHead();
        this.initBody();
    }

    private void getRemoteData() throws Exception {
        BgGetPeriodTypeForGetBlanceEnum _balTypeEnum;
        String _bgDataId = (String)this.getUIContext().get(bgDataId);
        boolean _isCtrl = (Boolean)this.getUIContext().get(isCtrl);
        String _formatStyle = (String)this.getUIContext().get(formatStyle);
        if (_formatStyle != null) {
            this.floatFormater = new DecimalFormat(_formatStyle, BgNationalFormatUIUtil.getDecimalFormatSymbols());
            this.longFormater = new DecimalFormat("#####0." + _formatStyle.split("\\.")[1], BgNationalFormatUIUtil.getDecimalFormatSymbols());
        }
        if (BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance.equals((Object)(_balTypeEnum = (BgGetPeriodTypeForGetBlanceEnum)((Object)this.getUIContext().get(balTypeEnum))))) {
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"120_BgAvlBalDetailUI"));
        }
        IBudgetCtrlFacade iBudgetCtrlFacade = BudgetCtrlFacadeFactory.getRemoteInstance();
        this.detailInfo = iBudgetCtrlFacade.processBalDetailView(_bgDataId, _isCtrl, _balTypeEnum);
        if (this.detailInfo == null) {
            return;
        }
        Map calcuItems = this.detailInfo.getCalcuItems();
        if (calcuItems == null || calcuItems.isEmpty()) {
            return;
        }
        Iterator itr = calcuItems.keySet().iterator();
        while (itr.hasNext()) {
            String itemCombNumber = itr.next().toString();
            this.itemKey2NameMap.put(itemCombNumber.replaceAll(",", "_"), null);
        }
        this.itemKey2NameMap = BgBudgetFacadeFactory.getRemoteInstance().getSelectBgItemCombinName(this.itemKey2NameMap, this.detailInfo.getOrgUnitId());
    }

    private void initHead() throws Exception {
        if (this.detailInfo == null) {
            return;
        }
        String itemCombName = (String)this.itemKey2NameMap.get(this.detailInfo.getBgItemCombNumber().replaceAll(",", "_"));
        this.txtItem.setText(itemCombName);
        this.txtBal.setText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"121_BgAvlBalDetailUI"), this.floatFormater.format(this.detailInfo.getAvlBal())));
        StringBuffer ctrlType = new StringBuffer(this.detailInfo.getCtrlType().getAlias());
        if (this.detailInfo.isFlexible()) {
            ctrlType.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"122_BgAvlBalDetailUI"));
        }
        if (this.detailInfo.isGroupCtrl()) {
            ctrlType.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"123_BgAvlBalDetailUI"));
        }
        this.txtCtrlType.setText(ctrlType.toString());
        this.formula.setEnabled(true);
        this.formula.setEditable(false);
        this.formula.setAutoscrolls(true);
    }

    private void initBody() throws Exception {
        if (this.detailInfo == null) {
            return;
        }
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        Map calcuItems = this.detailInfo.getCalcuItems();
        Iterator itr = calcuItems.keySet().iterator();
        boolean isPeriodBal = BgGetPeriodTypeForGetBlanceEnum.Is_Period_User_Blance.equals(this.getUIContext().get(balTypeEnum));
        StringBuffer expHead = new StringBuffer("");
        if (isPeriodBal) {
            expHead.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"124_BgAvlBalDetailUI"));
        } else {
            expHead.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"125_BgAvlBalDetailUI"));
        }
        expHead.append(newLineSpliter);
        if (this.detailInfo.isGroupCtrl()) {
            expHead.append(equal);
            Iterator iterator = this.itemKey2NameMap.keySet().iterator();
            while (iterator.hasNext()) {
                String name = (String)this.itemKey2NameMap.get(iterator.next());
                if (isPeriodBal) {
                    expHead.append(name + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"124_BgAvlBalDetailUI") + add);
                    continue;
                }
                expHead.append(name + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"125_BgAvlBalDetailUI") + add);
            }
            expHead = new StringBuffer(BudgetCtrlUtil.deleteStrTail(expHead.toString()));
            expHead.append(newLineSpliter);
        }
        StringBuffer expRowOne = new StringBuffer(equal);
        StringBuffer expRowTwo = new StringBuffer(equal);
        StringBuffer expRowThree = new StringBuffer(equal);
        boolean isGroup = this.detailInfo.isGroupCtrl();
        while (itr.hasNext()) {
            StringBuffer sumBgValStr = new StringBuffer("");
            BigDecimal sumBgValAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            StringBuffer sumActValStr = new StringBuffer("");
            BigDecimal sumActValAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            StringBuffer sumBalValStr = new StringBuffer("");
            BigDecimal sumBalValAmt = BudgetCtrlConstants.ZERO_AMOUNT;
            String itemCombNumber = itr.next().toString();
            String itemCombName = this.itemKey2NameMap.get(itemCombNumber.replaceAll(",", "_")).toString();
            List blockList = (List)calcuItems.get(itemCombNumber);
            int periodCounter = blockList.size();
            int startRowIndex = 0;
            int endRowIndex = 0;
            for (int i = 0; i < periodCounter; ++i) {
                List rowList = (List)blockList.get(i);
                IRow row = this.tblMain.addRow();
                if (i == 0) {
                    startRowIndex = row.getRowIndex();
                }
                if (i == periodCounter - 1) {
                    endRowIndex = row.getRowIndex();
                }
                String periodName = (String)rowList.get(0);
                BigDecimal bgVal = (BigDecimal)rowList.get(1);
                BigDecimal coe = (BigDecimal)rowList.get(2);
                BigDecimal actVal = (BigDecimal)rowList.get(3);
                row.getCell("bgItem").setValue((Object)(itemCombNumber + " " + itemCombName));
                row.getCell("period").setValue((Object)periodName);
                row.getCell("bgVal").setValue(bgVal != null ? this.floatFormater.format(bgVal) : null);
                row.getCell("coe").setValue(coe != null ? this.floatFormater.format(coe) : null);
                row.getCell("actVal").setValue(actVal != null ? this.floatFormater.format(actVal) : null);
                row.getCell("bgItem").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                row.getCell("period").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                row.getCell("bgVal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                row.getCell("coe").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                row.getCell("actVal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                if (bgVal != null) {
                    if (i == 0) {
                        if (periodCounter > 1) {
                            sumBgValStr.append(leftSmallBracket + this.longFormater.format(bgVal) + multiply + this.longFormater.format(coe));
                        } else {
                            sumBgValStr.append(this.longFormater.format(bgVal) + multiply + this.longFormater.format(coe));
                        }
                    } else {
                        sumBgValStr.append(add + this.longFormater.format(bgVal) + multiply + this.longFormater.format(coe));
                    }
                    sumBgValAmt = sumBgValAmt.add(bgVal.multiply(coe));
                }
                if (actVal == null) continue;
                if (i == 0) {
                    if (periodCounter > 1) {
                        sumActValStr.append(leftSmallBracket + this.longFormater.format(actVal));
                    } else {
                        sumActValStr.append(this.longFormater.format(actVal));
                    }
                } else {
                    sumActValStr.append(add + this.longFormater.format(actVal));
                }
                sumActValAmt = sumActValAmt.add(actVal);
            }
            if (periodCounter > 1) {
                sumBgValStr.append(rightSmallBracket);
            }
            if (periodCounter > 1) {
                sumActValStr.append(rightSmallBracket);
            }
            if (isGroup) {
                sumBalValStr.append(leftBigBracket);
            }
            sumBalValStr.append(sumBgValStr);
            sumBalValStr.append(subtract);
            if (sumActValStr.toString().startsWith(subtract)) {
                sumActValStr.insert(0, leftSmallBracket);
                sumActValStr.insert(sumActValStr.length(), rightSmallBracket);
            }
            sumBalValStr.append(sumActValStr);
            if (isGroup) {
                sumBalValStr.append(rightBigBracket);
            }
            sumBalValAmt = sumBgValAmt.subtract(sumActValAmt);
            expRowOne.append(sumBalValStr + add);
            if (isGroup) {
                expRowTwo.append(leftSmallBracket);
            }
            expRowTwo.append(this.longFormater.format(sumBgValAmt));
            expRowTwo.append(subtract);
            if (sumActValAmt.compareTo(BgConstants.BIGZERO) < 0) {
                expRowTwo.append(leftSmallBracket + this.longFormater.format(sumActValAmt) + rightSmallBracket);
            } else {
                expRowTwo.append(this.longFormater.format(sumActValAmt));
            }
            if (isGroup) {
                expRowTwo.append(rightSmallBracket);
            }
            expRowTwo.append(add);
            if (sumBalValAmt.compareTo(BgConstants.BIGZERO) < 0) {
                expRowThree.append(leftSmallBracket + this.longFormater.format(sumBalValAmt) + rightSmallBracket + add);
            } else {
                expRowThree.append(this.longFormater.format(sumBalValAmt) + add);
            }
            this.tblMain.getMergeManager().mergeBlock(startRowIndex, 0, endRowIndex, 0);
            IRow sumRow = this.tblMain.addRow();
            sumRow.getStyleAttributes().setBackground(BgNConstants.LITILE_SUM_COROR);
            sumRow.getCell("bgItem").setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"126_BgAvlBalDetailUI"));
            sumRow.getCell("period").setValue(null);
            sumRow.getCell("bgVal").setValue((Object)this.floatFormater.format(sumBgValAmt));
            sumRow.getCell("coe").setValue((Object)this.floatFormater.format(sumBgValAmt));
            sumRow.getCell("actVal").setValue((Object)this.floatFormater.format(sumActValAmt));
            sumRow.getCell("bgItem").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sumRow.getCell("period").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sumRow.getCell("bgVal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            sumRow.getCell("coe").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sumRow.getCell("actVal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            this.tblMain.getMergeManager().mergeBlock(endRowIndex + 1, 2, endRowIndex + 1, 3);
        }
        StringBuffer exp = new StringBuffer("");
        exp.append(expHead.toString());
        exp.append(BudgetCtrlUtil.deleteStrTail(expRowOne.toString()));
        exp.append(newLineSpliter);
        exp.append(BudgetCtrlUtil.deleteStrTail(expRowTwo.toString()));
        exp.append(newLineSpliter);
        exp.append(isGroup ? BudgetCtrlUtil.deleteStrTail(expRowThree.toString()) + newLineSpliter : "");
        exp.append(equal);
        exp.append(this.floatFormater.format(this.detailInfo.getAvlBal()));
        this.formula.setText(exp.toString());
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }
}

