/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BudgetCtrlFacadeFactory;
import com.kingdee.eas.ma.budget.IBudgetCtrlFacade;
import com.kingdee.eas.ma.budget.client.ProgressDialogUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgBatchCollectClientHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgBatchCollectClientHelper");
    private static final String RES = "com.kingdee.eas.ma.budget.client.BgControlRuleResource";
    public static final int BATCH_COUNT = 100;

    public static void beforeBatchCollection(CoreUI ui) {
        try {
            IBudgetCtrlFacade ctrlFacade = BudgetCtrlFacadeFactory.getRemoteInstance();
            List ctrlRecordIds = ctrlFacade.getNeedCollectCtrlRecords();
            if (ctrlRecordIds == null || ctrlRecordIds.isEmpty()) {
                return;
            }
            String msg = EASResource.getString((String)RES, (String)"confirmCollect");
            int msgRes = MsgBox.showConfirm2((Component)ui, (String)(msg = MessageFormat.format(msg, new Integer(ctrlRecordIds.size()))));
            if (msgRes != 0) {
                return;
            }
            BgBatchCollectClientHelper.showBatchCollectProgress(ui, ctrlRecordIds);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Component)ui, (Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Component)ui, (Throwable)e);
        }
    }

    private static void showBatchCollectProgress(CoreUI ui, List ctrlRecordIds) throws BOSException, EASBizException {
        if (ctrlRecordIds == null || ctrlRecordIds.isEmpty()) {
            return;
        }
        SimpleTimer time = new SimpleTimer();
        UIContext map = new UIContext((Object)ui);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)map);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI progressUi = (ProgressDialogUI)window.getUIObject();
            progressUi.setShowTableMessage(true);
            logger.debug((Object)("begin initParameterValue" + time.getTime() + ""));
            BgBatchCollectClientHelper.initParameterValue(ui, progressUi, ctrlRecordIds);
            logger.debug((Object)("begin init" + time.getTime() + ""));
            progressUi.init();
            logger.debug((Object)("begin show" + time.getTime() + ""));
            window.show();
        }
    }

    private static void initParameterValue(CoreUI ui, ProgressDialogUI progressUi, List ctrlRecordIds) {
        if (ctrlRecordIds == null || ctrlRecordIds.isEmpty()) {
            return;
        }
        progressUi.setUITitle(EASResource.getString((String)RES, (String)"batchCollect"));
        progressUi.setInvokeClass(BgBatchCollectClientHelper.class.getName());
        progressUi.setInvokeMethod("invokeMethod");
        Class[] cls = new Class[]{List.class, Integer.TYPE};
        progressUi.setInvokeMethodParmeterType(cls);
        int batchCount = (ctrlRecordIds.size() - 1) / 100 + 1;
        Object[][] params = new Object[batchCount + 1][];
        for (int i = -1; i < batchCount; ++i) {
            params[i + 1] = new Object[]{ctrlRecordIds, new Integer(i)};
        }
        progressUi.setInvokeMethodParmeterValue(params);
        progressUi.setCountSum(batchCount);
    }

    public Object invokeMethod(List ctrlRecordIds, int index) throws Exception {
        logger.error((Object)("invokeMethod:" + index));
        if (index >= 0 && ctrlRecordIds != null) {
            int start = index * 100;
            int end = start + 100;
            if (start < ctrlRecordIds.size()) {
                if (end > ctrlRecordIds.size()) {
                    end = ctrlRecordIds.size();
                }
                ArrayList sub = new ArrayList();
                for (int i = start; i < end; ++i) {
                    sub.add(ctrlRecordIds.get(i));
                }
                BudgetCtrlFacadeFactory.getRemoteInstance().collectCtrlResult(sub);
            }
        }
        return new String[]{EASResource.getString((String)RES, (String)"batchCollecting"), ""};
    }
}

