/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.INewBgControlFacade;
import com.kingdee.eas.ma.budget.NewBgControlFacadeFactory;
import com.kingdee.eas.ma.budget.client.AbstractBgBatchCtrlBizBillsUI;
import com.kingdee.eas.ma.budget.client.BgBatchCtrlReportUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgBatchCtrlBizBillsUI
extends AbstractBgBatchCtrlBizBillsUI {
    private static final long serialVersionUID = 2984995649145945029L;
    private static final Logger logger = CoreUIObject.getLogger(BgBatchCtrlBizBillsUI.class);
    public static final String Ctrl_BizBills = "controlBizBills";
    public static final String Cancel_Ctrl_BizBills = "cancelControlBizBills";
    protected boolean isCtrlBizBills = true;
    protected BOSUuid bgCtrlSchemeId = null;
    protected String bgCtrlSchemeName = null;
    protected String boName = null;
    protected String boAlias = null;
    protected String subSystemAlias = null;
    protected Date beginDate = null;
    protected Date endDate = null;
    protected Map orgUnits = null;
    protected List orgUnitNumbers = null;
    protected List result = null;
    protected IBgControlScheme iBgControlScheme = null;
    protected INewBgControlFacade iNewBgControlFacade = null;

    public void onLoad() throws Exception {
        super.onLoad();
        Map uiContext = this.getUIContext();
        if (uiContext.get(Ctrl_BizBills) != null) {
            this.isCtrlBizBills = true;
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"132_BgBatchCtrlBizBillsUI"));
        } else if (uiContext.get(Cancel_Ctrl_BizBills) != null) {
            this.isCtrlBizBills = false;
            this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"133_BgBatchCtrlBizBillsUI"));
        }
        this.prmtBgCtrlScheme.setQueryInfo("com.kingdee.eas.ma.budget.BgControlSchemeQuery");
        this.prmtBgCtrlScheme.setDisplayFormat("$name$");
        this.prmtBgCtrlScheme.setEditFormat("$number$");
        this.prmtBgCtrlScheme.setCommitFormat("$number$");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isValid", (Object)new Integer(1), CompareType.EQUALS));
        view.setFilter(filter);
        this.prmtBgCtrlScheme.setEntityViewInfo(view);
        this.prmtBgCtrlScheme.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                try {
                    BgBatchCtrlBizBillsUI.this.filterBizOrg(event);
                }
                catch (Exception e) {
                    logger.error((Object)this, (Throwable)e);
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        });
        this.prmtBizOrg.setEnabled(false);
        this.prmtBizOrg.setValue(null);
    }

    protected void filterBizOrg(DataChangeEvent event) throws EASBizException, BOSException {
        if (event.getNewValue() == null) {
            this.prmtBizOrg.setValue(null);
            this.prmtBizOrg.setQueryInfo(null);
            this.prmtBizOrg.setEnabled(false);
        } else {
            BgControlSchemeInfo value = (BgControlSchemeInfo)event.getNewValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("boName"));
            sic.add(new SelectorItemInfo("boAlias"));
            sic.add(new SelectorItemInfo("subSystemAlias"));
            BgControlSchemeInfo ctrlScheme = (BgControlSchemeInfo)this.getIBgControlScheme().getValue((IObjectPK)new ObjectUuidPK(value.getId().toString()), sic);
            this.bgCtrlSchemeId = ctrlScheme.getId();
            this.bgCtrlSchemeName = ctrlScheme.getName();
            this.boName = ctrlScheme.getBoName();
            this.boAlias = ctrlScheme.getBoAlias();
            this.subSystemAlias = ctrlScheme.getSubSystemAlias();
            EntityObjectInfo bizBillEntity = MetaDataLoader.getEntity(null, (IMetaDataPK)new MetaDataPK(ctrlScheme.getBoName()));
            String orgType = bizBillEntity.getExtendedProperty("OrgType");
            String orgUnitF7Query = null;
            if (orgType == null || orgType.equalsIgnoreCase("NONE")) {
                orgUnitF7Query = null;
            } else if (orgType.equalsIgnoreCase("Admin")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("Company")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("Sale")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.SaleOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("Purchase")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.PurchaseOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("Storage")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.StorageOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("CostCenter")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.CostCenterOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("ProfitCenter")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.ProfitCenterOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("UnionDebt")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery";
            } else if (orgType.equalsIgnoreCase("ControlUnit")) {
                orgUnitF7Query = "com.kingdee.eas.basedata.framework.app.CtrlUnitQuery";
            } else if (orgType.equalsIgnoreCase("HRO")) {
                orgUnitF7Query = "HROrgUnitQuery";
            }
            if (orgUnitF7Query != null) {
                this.prmtBizOrg.setQueryInfo(orgUnitF7Query);
                this.prmtBizOrg.setDisplayFormat("$name$");
                this.prmtBizOrg.setEditFormat("$number$");
                this.prmtBizOrg.setCommitFormat("$number$");
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1), CompareType.EQUALS));
                view.setFilter(filter);
                this.prmtBizOrg.setEntityViewInfo(view);
                this.prmtBizOrg.setValue(null);
                this.prmtBizOrg.setEnabled(true);
            } else {
                this.prmtBizOrg.setQueryInfo(null);
                this.prmtBizOrg.setEnabled(false);
            }
        }
    }

    @Override
    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtBgCtrlScheme.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"134_BgBatchCtrlBizBillsUI"));
            SysUtil.abort();
        }
        if (this.prmtBizOrg.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"135_BgBatchCtrlBizBillsUI"));
            SysUtil.abort();
        }
        if (this.kDPickerBeginTime.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"136_BgBatchCtrlBizBillsUI"));
            SysUtil.abort();
        }
        if (this.kDPickerEndTime.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"137_BgBatchCtrlBizBillsUI"));
            SysUtil.abort();
        }
        BgControlSchemeInfo ctrlSchemeInfo = (BgControlSchemeInfo)this.prmtBgCtrlScheme.getValue();
        this.bgCtrlSchemeId = ctrlSchemeInfo.getId();
        this.bgCtrlSchemeName = ctrlSchemeInfo.getName();
        this.orgUnits = new HashMap();
        this.orgUnitNumbers = new ArrayList();
        Object[] _orgUnits = (Object[])this.prmtBizOrg.getValue();
        for (int i = 0; i < _orgUnits.length; ++i) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)_orgUnits[i];
            this.orgUnits.put(orgUnitInfo.getNumber(), orgUnitInfo);
            this.orgUnitNumbers.add(orgUnitInfo.getNumber());
        }
        this.beginDate = (Date)this.kDPickerBeginTime.getValue();
        this.endDate = (Date)this.kDPickerEndTime.getValue();
        this.beginDate.setHours(0);
        this.beginDate.setMinutes(0);
        this.beginDate.setSeconds(0);
        this.endDate.setHours(23);
        this.endDate.setMinutes(59);
        this.endDate.setSeconds(59);
        if (this.endDate.before(this.beginDate)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"138_BgBatchCtrlBizBillsUI"));
            this.kDPickerEndTime.setValue(null);
            SysUtil.abort();
        }
        this.checkPermission();
        this.setAllComponentEnabled(false);
        this.callRemoteCtrl();
        this.setAllComponentEnabled(true);
        this.dealExcelReport();
    }

    private void checkPermission() throws EASBizException, BOSException {
        if (this.orgUnits == null || this.orgUnits.isEmpty()) {
            return;
        }
        String batchCtrlPermission = "bg_scheme12_batchCtrl";
        String batchCancelCtrlPermission = "bg_scheme13_batchCancelCtrl";
        OrgUnitInfo currentOrgUnit = SysContext.getSysContext().getCurrentOrgUnit();
        ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        ObjectUuidPK currentOrgPK = new ObjectUuidPK(currentOrgUnit.getId());
        IPermission iPermisstion = PermissionFactory.getRemoteInstance();
        if (this.isCtrlBizBills) {
            iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, batchCtrlPermission);
        } else {
            iPermisstion.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)currentOrgPK, batchCancelCtrlPermission);
        }
        ICostCenterOrgUnit iCU = CostCenterOrgUnitFactory.getRemoteInstance();
        OrgUnitInfo orgUnitInfo = null;
        ObjectUuidPK CUPK = null;
        Iterator itr = this.orgUnits.keySet().iterator();
        while (itr.hasNext()) {
            orgUnitInfo = (OrgUnitInfo)this.orgUnits.get(itr.next());
            CUPK = new ObjectUuidPK(orgUnitInfo.getId().toString());
            if (!iCU.exists((IObjectPK)new ObjectUuidPK(CUPK.toString()))) continue;
            if (this.isCtrlBizBills) {
                if (iPermisstion.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)CUPK, batchCtrlPermission)) continue;
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"139_BgBatchCtrlBizBillsUI") + orgUnitInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"140_BgBatchCtrlBizBillsUI")));
                SysUtil.abort();
                continue;
            }
            if (iPermisstion.hasFunctionPermission((IObjectPK)userPK, (IObjectPK)CUPK, batchCancelCtrlPermission)) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"139_BgBatchCtrlBizBillsUI") + orgUnitInfo.getName() + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"141_BgBatchCtrlBizBillsUI")));
            SysUtil.abort();
        }
    }

    private void callRemoteCtrl() {
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgBatchCtrlBizBillsUI.this.result = BgBatchCtrlBizBillsUI.this.isCtrlBizBills ? BgBatchCtrlBizBillsUI.this.getNewBgControlFacade().batchCtrlBizBills(BgBatchCtrlBizBillsUI.this.bgCtrlSchemeId, BgBatchCtrlBizBillsUI.this.boName, BgBatchCtrlBizBillsUI.this.orgUnitNumbers, BgBatchCtrlBizBillsUI.this.beginDate, BgBatchCtrlBizBillsUI.this.endDate) : BgBatchCtrlBizBillsUI.this.getNewBgControlFacade().batchCancelCtrlBizBills(BgBatchCtrlBizBillsUI.this.bgCtrlSchemeId, BgBatchCtrlBizBillsUI.this.boName, BgBatchCtrlBizBillsUI.this.orgUnitNumbers, BgBatchCtrlBizBillsUI.this.beginDate, BgBatchCtrlBizBillsUI.this.endDate);
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)BgBatchCtrlBizBillsUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"142_BgBatchCtrlBizBillsUI"));
            }
        });
        dialog.show();
    }

    private void dealExcelReport() throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        if (this.isCtrlBizBills) {
            uiContext.put((Object)Ctrl_BizBills, (Object)Ctrl_BizBills);
        } else {
            uiContext.put((Object)Cancel_Ctrl_BizBills, (Object)Cancel_Ctrl_BizBills);
        }
        uiContext.put((Object)BgBatchCtrlBizBillsUI.class.getName(), (Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgBatchCtrlReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private void setAllComponentEnabled(boolean enable) {
        this.prmtBgCtrlScheme.setEnabled(enable);
        this.prmtBizOrg.setEnabled(enable);
        this.kDPickerBeginTime.setEnabled(enable);
        this.kDPickerEndTime.setEnabled(enable);
        this.bntOK.setEnabled(enable);
        this.btnCancel.setEnabled(enable);
    }

    protected IBgControlScheme getIBgControlScheme() throws BOSException {
        if (this.iBgControlScheme == null) {
            this.iBgControlScheme = BgControlSchemeFactory.getRemoteInstance();
        }
        return this.iBgControlScheme;
    }

    protected INewBgControlFacade getNewBgControlFacade() throws BOSException {
        if (this.iNewBgControlFacade == null) {
            this.iNewBgControlFacade = NewBgControlFacadeFactory.getRemoteInstance();
        }
        return this.iNewBgControlFacade;
    }
}

