/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IGeneralAsstActTypeGroup;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.ma.budget.BgControlFacadeFactory;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class BgBizItemF7Util {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.budget.client.BgBizItemF7Util");
    public static final String CU = "CU";
    public static final String COMPANY = "company";
    public static final String COMPANYID = "companyId";
    public static final String GLOBAL = "gloval";
    public static final String SPECIAL = "special";

    public static EntityViewInfo getOrgViewInfo(EntityViewInfo view, String name, String property) {
        String type;
        if (view == null) {
            view = new EntityViewInfo();
        }
        if ((type = BgBizItemF7Util.getOrgFilterType(name)) == null) {
            return view;
        }
        String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
        String companyId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (CU.equals(type)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
        } else if (COMPANY.equals(type)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        } else if (COMPANYID.equals(type)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("companyId.id", (Object)companyId));
        } else {
            if (GLOBAL.equals(type)) {
                return view;
            }
            if (SPECIAL.equals(type)) {
                if ("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery".equals(name) || "com.kingdee.eas.cp.bc.app.ExpenseType".equals(name)) {
                    view.getFilter().getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
                    CompanyOrgUnitInfo cui = SysContext.getSysContext().getCurrentFIUnit();
                    String ln = cui.getLongNumber();
                    String[] lnSecs = ln.split("!");
                    int size = lnSecs.length;
                    HashSet<String> lnUps = new HashSet<String>();
                    for (int i = 0; i < size; ++i) {
                        lnUps.add(lnSecs[i]);
                    }
                    if (lnUps.size() != 0) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("company.number", lnUps, CompareType.INCLUDE));
                        view.getFilter().setMaskString("#0 or #1");
                    }
                }
                if (property != null && ("com.kingdee.eas.basedata.master.auxacct.app.F7GeneralAsstActTypeQuery".equals(name) || "com.kingdee.eas.basedata.master.auxacct.app.GeneralAsstActType".equals(name))) {
                    HashMap assActTypeGroupIdMap = null;
                    try {
                        assActTypeGroupIdMap = BgControlFacadeFactory.getRemoteInstance().getGeneralAssActTypeGroupIds();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.handle((Throwable)ex);
                    }
                    String[] tmps = property.split("\\.");
                    if (tmps != null && tmps.length == 5 && tmps[3] != null && tmps[3].startsWith("generalAssActType")) {
                        String groupId = null;
                        for (String key : assActTypeGroupIdMap.keySet()) {
                            if (!key.equalsIgnoreCase(tmps[3])) continue;
                            groupId = (String)assActTypeGroupIdMap.get(key);
                            break;
                        }
                        view.getFilter().getFilterItems().add(new FilterItemInfo("group.id", groupId));
                        FilterInfo filter = GlUtils.getFilterForGeneral(groupId);
                        try {
                            view.getFilter().mergeFilter(filter, "AND");
                        }
                        catch (Exception ex) {
                            logger.error((Object)"budget error:", (Throwable)ex);
                        }
                    }
                    if (tmps != null && tmps.length == 5 && tmps[3] != null && tmps[3].startsWith("generalAssActType")) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId));
                    }
                }
                if ("com.kingdee.eas.basedata.org.app.AdminItemQuery".equals(name)) {
                    boolean isAdmin = false;
                    if (SysContext.getSysContext().getCurrentCostUnit() != null && SysContext.getSysContext().getCurrentCostUnit().isIsAdminOrgUnit()) {
                        isAdmin = true;
                    }
                    if (isAdmin) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(SysContext.getSysContext().getCurrentAdminUnit().get("longNumber").toString() + "%"), CompareType.LIKE));
                    } else {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"###############"));
                    }
                }
                if ("com.kingdee.eas.basedata.org.app.CostCenterItemQuery".equals(name) || "com.kingdee.eas.basedata.org.app.CostCenterOrgUnit".equals(name)) {
                    boolean isCc = false;
                    if (SysContext.getSysContext().getCurrentCostUnit() != null) {
                        isCc = true;
                    }
                    if (isCc) {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(SysContext.getSysContext().getCurrentCostUnit().get("longNumber").toString() + "%"), CompareType.LIKE));
                    } else {
                        view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"###############"));
                    }
                }
                return view;
            }
            return view;
        }
        return view;
    }

    private static String getOrgFilterType(String name) {
        if ("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery".equals(name) || "com.kingdee.eas.basedata.master.account.app.AccountView".equals(name)) {
            return COMPANYID;
        }
        if ("com.kingdee.eas.fi.lcm.LCMLcmCatQuery".equals(name) || "com.kingdee.eas.fi.lcm.app.LCMLcmCat".equals(name)) {
            return COMPANY;
        }
        if ("com.kingdee.eas.fm.fpl.FpItemQuery".equals(name) || "com.kingdee.eas.fm.fpl.app.FpItem".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.basedata.assistant.app.F7CashFlowQuery".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.fi.fa.basedata.FaCatQuery".equals(name) || "com.kingdee.eas.fi.fa.basedata.app.FaCat".equals(name)) {
            return COMPANY;
        }
        if ("com.kingdee.eas.cp.bc.app.ExpenseTypeQuery".equals(name) || "com.kingdee.eas.cp.bc.app.ExpenseType".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.basedata.master.auxacct.app.F7GeneralAsstActTypeQuery".equals(name) || "com.kingdee.eas.basedata.master.auxacct.app.GeneralAsstActType".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.basedata.org.app.AdminItemQuery".equals(name) || "com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.basedata.org.app.CostCenterItemQuery".equals(name) || "com.kingdee.eas.basedata.org.app.CostCenterOrgUnit".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.ma.nbudget.app.F7MaterialGroupQuery".equals(name)) {
            return SPECIAL;
        }
        if ("com.kingdee.eas.fi.cas.ReceivingBillTypeQuery".equals(name) || "com.kingdee.eas.fi.cas.app.ReceivingBillType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.basedata.assistant.app.BankQuery".equals(name) || "com.kingdee.eas.basedata.assistant.app.Bank".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.basedata.assistant.app.SettlementTypeQuery".equals(name) || "com.kingdee.eas.basedata.assistant.app.SettlementType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.ma.budget.CustomerProjectQuery".equals(name)) {
            if (BgNSHelper.isProjectlsolate(null)) {
                return COMPANY;
            }
            return GLOBAL;
        }
        if ("com.kingdee.eas.fdc.basedata.app.F7PaymentTypeQuery".equals(name) || "com.kingdee.eas.fdc.basedata.app.PaymentType".equals(name)) {
            return GLOBAL;
        }
        if ("com.kingdee.eas.fdc.contract.app.ContractBaseDataQuery".equals(name) || "com.kingdee.eas.fdc.contract.app.ContractBaseData".equals(name)) {
            return GLOBAL;
        }
        return CU;
    }

    private static FilterInfo getGLFilter(Context ctx, String groupID) {
        CtrlUnitInfo CU = ctx == null ? SysContext.getSysContext().getCurrentCtrlUnit() : ContextUtil.getCurrentCtrlUnit((Context)ctx);
        if (CU == null) {
            return null;
        }
        String currentCUID = CU.getId().toString();
        String currentCULongNumber = CU.getLongNumber();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("group.id", (Object)groupID));
        fic.add(new FilterItemInfo("CU.id", (Object)currentCUID));
        if (groupID != null) {
            try {
                IGeneralAsstActTypeGroup IGenAsstActTypeGroup = ctx == null ? GeneralAsstActTypeGroupFactory.getRemoteInstance() : GeneralAsstActTypeGroupFactory.getLocalInstance((Context)ctx);
                GeneralAsstActTypeGroupInfo info = IGenAsstActTypeGroup.getGeneralAsstActTypeGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)groupID)));
                if (info.getShareTactic().equals((Object)ShareTacticEnum.S3)) {
                    fi.setMaskString("#0 and #1");
                } else {
                    String ln = currentCULongNumber;
                    String[] lnSecs = ln.split("!");
                    int size = lnSecs.length;
                    HashSet<String> lnUps = new HashSet<String>();
                    StringBuffer sb = new StringBuffer();
                    for (int i = 0; i < size - 1; ++i) {
                        if (i != 0) {
                            sb.append("!");
                        }
                        sb.append(lnSecs[i]);
                        lnUps.add(sb.toString());
                    }
                    if (lnUps.size() != 0) {
                        fic.add(new FilterItemInfo("CU.longNumber", lnUps, CompareType.INCLUDE));
                        fi.setMaskString("#0 and (#1 or #2)");
                    }
                }
            }
            catch (Exception e) {
                fi.setMaskString("#0 and #1");
            }
        } else {
            fi.setMaskString("#0 and #1");
        }
        return fi;
    }
}

