/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.export.ExportManager;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgCentralizedOrgCollection;
import com.kingdee.eas.ma.budget.BgCentralizedOrgFactory;
import com.kingdee.eas.ma.budget.BgCentralizedOrgInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgCentralizedOrgListUI;
import com.kingdee.eas.ma.budget.client.BgCentralizedOrgEditUI;
import com.kingdee.eas.ma.budget.client.ExcelFile;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class BgCentralizedOrgListUI
extends AbstractBgCentralizedOrgListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCentralizedOrgListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.setUITitle("\u59d4\u6258\u7ec4\u7ec7\u8bbe\u7f6e");
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnExportData.setIcon(this.menuItemExportData.getIcon());
        this.btnImportData.setIcon(this.menuItemImportData.getIcon());
        this.actionImportData.setVisible(true);
        this.actionImportData.setEnabled(true);
        this.actionExportData.setVisible(true);
        this.actionExportData.setEnabled(true);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCentralizedOrgFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        BgCentralizedOrgInfo objectValue = new BgCentralizedOrgInfo();
        return objectValue;
    }

    protected String getEditUIName() {
        return BgCentralizedOrgEditUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        return filter;
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"out"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showSaveDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
            if (!filePath.toLowerCase(Locale.ENGLISH).endsWith(".xls")) {
                filePath = filePath + ".xls";
            }
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = new KDSBook("001");
        KDSSheet kdsSheet = new KDSSheet(kdsBook, "001");
        kdsSheet.getSheetStyleAttributes().setFont(new Font(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"font"), 0, 9));
        kdsSheet.getSheetStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
        kdsSheet.getSheetStyleAttributes().setNumberFormat("@");
        kdsSheet.setCellValue(0, 0, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"orgUnitNumber"));
        kdsSheet.setCellValue(0, 1, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"orgUnitName"));
        kdsSheet.setCellValue(0, 2, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"cenOrgUnitNumber"));
        kdsSheet.setCellValue(0, 3, (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"cenOrgUnitName"));
        IRow row = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            kdsSheet.setCellValue(i + 1, 0, (Object)row.getCell("orgUnit.number").getValue().toString());
            kdsSheet.setCellValue(i + 1, 1, (Object)row.getCell("orgUnitName").getValue().toString());
            kdsSheet.setCellValue(i + 1, 2, (Object)row.getCell("cenOrgUnit.number").getValue().toString());
            kdsSheet.setCellValue(i + 1, 3, (Object)row.getCell("cenOrgUnitName").getValue().toString());
        }
        kdsBook.addSheet(null, kdsSheet);
        ExportManager export = new ExportManager();
        try {
            export.exportToExcel(kdsBook, filePath);
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"exportsuccess"));
        }
        catch (RuntimeException e1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"fileIsNotOpen"));
        }
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        String filePath = null;
        boolean isNull = false;
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"in"));
        fileChooser.setFileFilter((FileFilter)new ExcelFile());
        fileChooser.setAcceptAllFileFilterUsed(false);
        if (fileChooser.showOpenDialog((Component)((Object)this)) == 0) {
            filePath = fileChooser.getSelectedFile().getPath();
        } else {
            SysUtil.abort();
        }
        if (filePath == null) {
            SysUtil.abort();
        }
        KDSBook kdsBook = null;
        try {
            kdsBook = POIXlsReader.parse((String)filePath);
        }
        catch (Exception e1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"excelBad"));
            SysUtil.abort();
        }
        if (kdsBook == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"notFile"));
            SysUtil.abort();
        }
        CoreBaseCollection collection = new CoreBaseCollection();
        KDSSheet sheet = kdsBook.getSheet((Object)new Integer(0));
        int rowCount = sheet.getRowCount();
        String nextNum = "0";
        String nextName = "0";
        String orgUnitNum = null;
        String cenOrgUnitNum = null;
        BgCentralizedOrgInfo bgCentralizedOrgInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        view.setSelector(selector);
        CostCenterOrgUnitCollection costCenterOrgUnitCol = CostCenterOrgUnitFactory.getRemoteInstance().getCostCenterOrgUnitCollection(view);
        HashMap<String, BOSUuid> costCenterOrgUnitMap = new HashMap<String, BOSUuid>();
        HashMap<String, String> costCenterOrgUnitMap2 = new HashMap<String, String>();
        for (int i = 0; i < costCenterOrgUnitCol.size(); ++i) {
            CostCenterOrgUnitInfo cbInfo = costCenterOrgUnitCol.get(i);
            BOSUuid id = cbInfo.getId();
            String number = cbInfo.getNumber();
            String name = cbInfo.getName();
            costCenterOrgUnitMap.put(number, id);
            costCenterOrgUnitMap2.put(number, name);
        }
        Set<String> bgCentralizedOrgSet = this.getBgCentralizedOrgMap();
        StringBuffer msg = new StringBuffer();
        HashSet<String> excelSet = new HashSet<String>();
        try {
            for (int i = 1; i < rowCount || !nextNum.trim().equals("") || !nextName.trim().equals(""); ++i) {
                orgUnitNum = sheet.getCell(i, 0, false).getValue() == null ? "" : sheet.getCell(i, 0, false).getValue().toString().trim();
                cenOrgUnitNum = sheet.getCell(i, 2, false).getValue() == null ? null : sheet.getCell(i, 2, false).getValue().toString().trim();
                nextNum = sheet.getCell(i + 1, 0, false).getValue() == null ? "" : sheet.getCell(i + 1, 0, false).getValue().toString().trim();
                String string = nextName = sheet.getCell(i + 1, 1, false).getValue() == null ? "" : sheet.getCell(i + 1, 1, false).getValue().toString().trim();
                if (!excelSet.contains(orgUnitNum)) {
                    excelSet.add(orgUnitNum);
                    if (StringUtils.isEmpty((String)orgUnitNum) || StringUtils.isEmpty((String)cenOrgUnitNum)) {
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"isNull") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"errorLine") + (i + 1));
                        msg.append("\r\n");
                        isNull = true;
                    }
                    boolean isOrgUnitNum = costCenterOrgUnitMap.containsKey(orgUnitNum);
                    boolean isCenOrgUnitNum = costCenterOrgUnitMap.containsKey(cenOrgUnitNum);
                    if (!isOrgUnitNum && !StringUtils.isEmpty((String)orgUnitNum)) {
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"notExistOrgUnit") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"errorLine") + (i + 1));
                        msg.append("\r\n");
                        isNull = true;
                    }
                    if (!isCenOrgUnitNum && !StringUtils.isEmpty((String)cenOrgUnitNum)) {
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"notExistCenOrgUnit") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"errorLine") + (i + 1));
                        msg.append("\r\n");
                        isNull = true;
                    }
                    if (orgUnitNum.equals(cenOrgUnitNum)) {
                        msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"sameOrgUit") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"errorLine") + (i + 1));
                        msg.append("\r\n");
                        isNull = true;
                    }
                    if (!isOrgUnitNum || !isCenOrgUnitNum || orgUnitNum.equals(cenOrgUnitNum)) continue;
                    boolean isExists = bgCentralizedOrgSet.contains(orgUnitNum);
                    if (!isExists) {
                        bgCentralizedOrgInfo = new BgCentralizedOrgInfo();
                        bgCentralizedOrgInfo.setId(BOSUuid.create((BOSObjectType)bgCentralizedOrgInfo.getBOSType()));
                        CostCenterOrgUnitInfo orgUnitInfo = new CostCenterOrgUnitInfo();
                        orgUnitInfo.setId((BOSUuid)costCenterOrgUnitMap.get(orgUnitNum));
                        bgCentralizedOrgInfo.setOrgUnit(orgUnitInfo);
                        bgCentralizedOrgInfo.setOrgUnitName((String)costCenterOrgUnitMap2.get(orgUnitNum));
                        CostCenterOrgUnitInfo cenOrgUnitInfo = new CostCenterOrgUnitInfo();
                        cenOrgUnitInfo.setId((BOSUuid)costCenterOrgUnitMap.get(cenOrgUnitNum));
                        bgCentralizedOrgInfo.setCenOrgUnit(cenOrgUnitInfo);
                        bgCentralizedOrgInfo.setCenOrgUnitName((String)costCenterOrgUnitMap2.get(cenOrgUnitNum));
                        collection.add((CoreBaseInfo)bgCentralizedOrgInfo);
                        continue;
                    }
                    msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"existOrgUnit") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"errorLine") + (i + 1));
                    msg.append("\r\n");
                    isNull = true;
                    continue;
                }
                msg.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"orgUnitRepeat") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"errorLine") + (i + 1));
                msg.append("\r\n");
            }
        }
        catch (Exception ee) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"dataError"));
            SysUtil.abort();
        }
        if (isNull) {
            MsgBox.showDetailAndOK(null, (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"importerror"), (String)msg.toString(), (int)1);
        } else {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgCentralizedOrgResource", (String)"importSuccess"));
        }
        BgCentralizedOrgFactory.getRemoteInstance().save(collection);
        this.actionRefresh_actionPerformed(null);
    }

    private Set<String> getBgCentralizedOrgMap() throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("orgUnit.number"));
        view.setSelector(selector);
        BgCentralizedOrgCollection bgCentralizedOrgCol = BgCentralizedOrgFactory.getRemoteInstance().getBgCentralizedOrgCollection(view);
        HashSet<String> ses = new HashSet<String>();
        for (int i = 0; i < bgCentralizedOrgCol.size(); ++i) {
            BgCentralizedOrgInfo bgInfo = bgCentralizedOrgCol.get(i);
            String number = bgInfo.getOrgUnit().getNumber();
            ses.add(number);
        }
        return ses;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"orgUnit.number", "orgUnitName", "cenOrgUnit.number", "cenOrgUnitName"};
        return locateNames;
    }
}

