/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgColForPeriodFacadeFactory;
import com.kingdee.eas.ma.budget.BgColForPeriodFormFactory;
import com.kingdee.eas.ma.budget.BgColForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodAdjustDiaplsyEnum;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgColForPeriodFacade;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.RefBgColPeriodsCollection;
import com.kingdee.eas.ma.budget.RefBgColPeriodsInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgColForPeriodAddNewUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgColForPeriodAddNewUI
extends AbstractBgColForPeriodAddNewUI
implements AssignSolutionInterface {
    private static final Logger logger = CoreUIObject.getLogger(BgColForPeriodAddNewUI.class);
    private IBgColForPeriodFacade iBgColForPeriodF = null;
    private Map hadPeriod = null;
    private String oldPerNum = null;
    private boolean isCancel = false;
    private Set endPeriodSet = null;
    private Map returnData = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddNewLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnRemoveLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddNewLine.setVisible(true);
        this.btnAddNewLine.setEnabled(true);
        this.btnRemoveLine.setVisible(true);
        this.btnRemoveLine.setEnabled(true);
        this.contPeriodShowType.setVisible(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCom();
        this.initSystem();
    }

    private void initCom() throws Exception {
        this.hadPeriod = new HashMap();
        this.initBgScheme();
        this.initEndPeriod();
        this.combEndPeriodType.setSelectedItem((Object)BgPeriodEnum.MONTH);
    }

    private void initSystem() throws Exception {
        this.prmtBgForm.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgColForPeriodAddNewUI.this.checkDataValid(eventObj.getNewValue(), eventObj.getOldValue());
            }
        });
    }

    protected void checkDataValid(Object newValue, Object oldValue) {
        if (newValue != null) {
            BgFormInfo bgFormInfo = (BgFormInfo)newValue;
            if (oldValue != null && bgFormInfo.getId().equals((Object)((BgFormInfo)oldValue).getId())) {
                return;
            }
            try {
                if (BgFormFacadeFactory.getRemoteInstance().checkFormIsAdjust(bgFormInfo.getId()) != null) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgFormInAdjustNoPeriodAdjust"));
                    this.prmtBgForm.setData(oldValue);
                    SysUtil.abort();
                }
            }
            catch (BgFormException e1) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgFormInAdjustNoPeriodAdjust"));
                this.prmtBgForm.setData(oldValue);
                SysUtil.abort();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void initEndPeriod() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        this.tblMain.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(2).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(3).getStyleAttributes().setLocked(true);
        this.tblMain.getColumn(4).getStyleAttributes().setLocked(true);
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this, true);
        KDBizPromptBox prmtSelect = null;
        prmtSelect = new KDBizPromptBox();
        prmtSelect.setEditable(false);
        prmtSelect.setSelector((KDPromptSelector)bgPeriodDialog);
        prmtSelect.setDisplayFormat("$number$");
        this.tblMain.getColumn("number").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtSelect));
    }

    protected void initBgScheme() throws Exception {
        if (this.getSelectOrg().getId() == null) {
            throw new BgCollectException(BgCollectException.CURRENTHASNOCOSTCENTER);
        }
        String orgId = this.getSelectOrg().getId().toString();
        IBgScheme bgSchema = BgSchemeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgId));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFiling ", (Object)1, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgId);
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgSet, (FilterInfo)filter);
        }
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        BgSchemeCollection bgSchemeCols = bgSchema.getBgSchemeCollection(view);
        if (bgSchemeCols == null || bgSchemeCols.isEmpty()) {
            return;
        }
        String[] num = new String[]{"number"};
        BgHelper.sortCollection(bgSchemeCols, num);
        this.combBgScheme.addItems(bgSchemeCols.toArray());
    }

    private FullOrgUnitInfo getSelectOrg() {
        FullOrgUnitInfo info = new FullOrgUnitInfo();
        String id = (String)this.getUIContext().get("OrgID");
        info.setId(BOSUuid.read((String)id));
        return info;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.tblMain.getColumnIndex("number") && this.tblMain.getCell(e.getRowIndex(), e.getColIndex()) != null && this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getValue() != null) {
            this.oldPerNum = this.tblMain.getCell(e.getRowIndex(), e.getColIndex()).getValue().toString();
            this.hadPeriod.remove(this.oldPerNum);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.tblMain.getColumnIndex("number")) {
            ICell cell = this.tblMain.getCell(e.getRowIndex(), e.getColIndex());
            IRow row = null;
            boolean isAddNew = false;
            boolean isUpdate = false;
            BgPeriodInfo[] periods = null;
            if (cell != null && cell.getValue() != null && (cell.getValue() instanceof BgPeriodInfo[] || cell.getValue() instanceof BgPeriodInfo) && (periods = cell.getValue() instanceof BgPeriodInfo ? new BgPeriodInfo[]{(BgPeriodInfo)cell.getValue()} : (BgPeriodInfo[])cell.getValue()) != null && periods.length > 0) {
                for (int n = periods.length - 1; n >= 0; --n) {
                    if (!periods[n].getPeriodType().equals(this.combEndPeriodType.getSelectedItem())) continue;
                    if (this.hadPeriod.containsKey(periods[n].getNumber())) {
                        this.tblMain.getRow(e.getRowIndex()).getCell(0).setValue(null);
                        continue;
                    }
                    if (isAddNew) {
                        row = this.tblMain.addRow(e.getRowIndex());
                    } else {
                        row = this.tblMain.getRow(e.getRowIndex());
                        isAddNew = true;
                    }
                    row.getCell(0).setValue((Object)periods[n].getNumber());
                    row.getCell(1).setValue((Object)periods[n].getName());
                    row.getCell(2).setValue((Object)periods[n].getPeriodType());
                    row.getCell(3).setValue((Object)periods[n].getBeginDate());
                    row.getCell(4).setValue((Object)periods[n].getEndDate());
                    row.getCell("id").setValue((Object)periods[n].getId());
                    this.hadPeriod.put(periods[n].getNumber(), null);
                    isUpdate = true;
                }
                if (!isUpdate && this.oldPerNum != null) {
                    this.tblMain.getRow(e.getRowIndex()).getCell(0).setValue((Object)this.oldPerNum);
                    this.hadPeriod.put(this.oldPerNum, null);
                } else if (!isUpdate) {
                    this.tblMain.getRow(e.getRowIndex()).getCell(0).setValue(null);
                }
            }
        }
    }

    @Override
    protected void combBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        if (this.combBgScheme.getSelectedItem() != null) {
            BgFormInfo bgFormInfo;
            BgSchemeInfo bgSchemaInfo = (BgSchemeInfo)this.combBgScheme.getSelectedItem();
            if (this.prmtBgForm.getData() != null && !(bgFormInfo = (BgFormInfo)this.prmtBgForm.getData()).getBgScheme().getId().toString().equals(bgSchemaInfo.getId().toString())) {
                this.prmtBgForm.setData(null);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getSelectOrg().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemaInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"BV/FQwEUEADgABtLwKgSXv9s2OA=", CompareType.NOTINCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
            filter.setMaskString(" #0 and #1 and #2  and ( #3 or #4 ) ");
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            sic.add(new SelectorItemInfo("bgPeriod.id"));
            sic.add(new SelectorItemInfo("bgPeriod.number"));
            sic.add(new SelectorItemInfo("bgPeriod.name"));
            sic.add(new SelectorItemInfo("bgPeriod.periodType"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("bgScheme.id"));
            sic.add(new SelectorItemInfo("bgScheme.number"));
            sic.add(new SelectorItemInfo("bgScheme.name"));
            sic.add(new SelectorItemInfo("bgTemplate.id"));
            sic.add(new SelectorItemInfo("bgTemplate.number"));
            sic.add(new SelectorItemInfo("bgTemplate.name"));
            sic.add(new SelectorItemInfo("bgTemplate.bgType.id"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("state"));
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(this.getSelectOrg().getId().toString());
                filter = BgPermissionHelper.addBgFormPermission((String)userId, orgSet, (FilterInfo)filter);
            }
            HashSet<Integer> formType = new HashSet<Integer>();
            formType.add(new Integer(2));
            formType.add(new Integer(3));
            formType.add(4);
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", formType, CompareType.NOTINCLUDE));
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
            view.setFilter(filter);
            this.prmtBgForm.setEntityViewInfo(view);
            this.prmtBgForm.setRefresh(true);
        }
    }

    private void inputSourcePeriodValue() throws EASBizException, BOSException {
        this.combSourcePeriod.removeAllItems();
        if (this.prmtBgForm.getValue() == null || this.combSourcePeriodType.getSelectedItem() == null) {
            return;
        }
        String bgFormId = ((BgFormInfo)this.prmtBgForm.getValue()).getId().toString();
        int sPerType = ((BgPeriodEnum)((Object)this.combSourcePeriodType.getSelectedItem())).getValue();
        BgPeriodCollection periodCol = this.getIBgColForPeriodF().getSourcePeriod(bgFormId, sPerType);
        if (periodCol != null && periodCol.size() > 0) {
            this.combSourcePeriod.addItems(periodCol.toArray());
        }
    }

    private IBgColForPeriodFacade getIBgColForPeriodF() throws BOSException {
        if (this.iBgColForPeriodF != null) {
            return this.iBgColForPeriodF;
        }
        this.iBgColForPeriodF = BgColForPeriodFacadeFactory.getRemoteInstance();
        return this.iBgColForPeriodF;
    }

    @Override
    protected void combSourcePeriodType_itemStateChanged(ItemEvent e) throws Exception {
        super.combSourcePeriodType_itemStateChanged(e);
        this.inputSourcePeriodValue();
    }

    @Override
    protected void combSourcePeriod_itemStateChanged(ItemEvent e) throws Exception {
        super.combSourcePeriod_itemStateChanged(e);
    }

    @Override
    protected void combEndPeriodType_itemStateChanged(ItemEvent e) throws Exception {
        this.tblMain.removeRows();
        this.hadPeriod.clear();
    }

    @Override
    protected void prmtBgForm_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgForm_dataChanged(e);
        this.inputSourcePeriodValue();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        super.actionCalculator_actionPerformed(e);
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportSelected_actionPerformed(e);
    }

    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception {
        super.actionRegProduct_actionPerformed(e);
    }

    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception {
        super.actionPersonalSite_actionPerformed(e);
    }

    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception {
        super.actionProcductVal_actionPerformed(e);
    }

    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    protected void beforeStoreFields(ActionEvent ex) {
        try {
            super.beforeStoreFields(ex);
            this.editData.setBgForm((BgFormInfo)this.prmtBgForm.getData());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    private void checkInput() {
        if (this.hadPeriod == null || this.hadPeriod.isEmpty()) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"endPeriodIsNull"));
            SysUtil.abort();
        }
        if (this.combBgScheme.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"selectScheme"));
            SysUtil.abort();
        }
        if (this.prmtBgForm.getData() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"selectForm"));
            SysUtil.abort();
        }
        if (this.combSourcePeriod.getSelectedItem() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"sourcePeriodError"));
            SysUtil.abort();
        }
        if (this.combEndPeriodType.getSelectedItem() != null && this.combSourcePeriodType.getSelectedItem() != null) {
            int sou;
            int end = ((BgPeriodEnum)((Object)this.combEndPeriodType.getSelectedItem())).getValue();
            if (end < (sou = ((BgPeriodEnum)((Object)this.combSourcePeriodType.getSelectedItem())).getValue()) && end != 8 && sou != 8) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"periodTypeError"));
                SysUtil.abort();
            }
            if (end == sou && sou != 8) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"periodTypeError"));
                SysUtil.abort();
            }
            if (end == sou && sou == 8 && this.hadPeriod.containsKey(((BgPeriodInfo)this.combSourcePeriod.getSelectedItem()).getNumber())) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"samePeriod"));
                SysUtil.abort();
            }
        }
        this.getData().setDisplayStyle((BgPeriodAdjustDiaplsyEnum)((Object)this.combShowPeriodType.getSelectedItem()));
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        this.checkInput();
        String id = ((BgFormInfo)this.prmtBgForm.getData()).getId().toString();
        if (!BgFormFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(id))) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"formIsDel"));
            SysUtil.abort();
        }
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        this.beforeStoreFields(e);
        BgPeriodInfo souPer = new BgPeriodInfo();
        souPer = (BgPeriodInfo)this.combSourcePeriod.getSelectedItem();
        Map<String, Object> formIds = new HashMap();
        String bgSchemeId = null;
        bgSchemeId = ((BgSchemeInfo)this.combBgScheme.getSelectedItem()).getId().toString();
        BgPeriodCollection perCol = new BgPeriodCollection();
        perCol = this.getPeriodColl();
        String[] num = new String[]{"number"};
        BgHelper.sortCollection(perCol, num);
        formIds = this.getIBgColForPeriodF().getFormId(bgSchemeId, id, this.hadPeriod);
        if (formIds == null || formIds.size() < 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"notEndApprovedData"));
            SysUtil.abort();
        }
        BgFormInfo bgFormInfo = null;
        RefBgColPeriodsInfo refInfo = null;
        String formid = null;
        BOSUuid bosId = null;
        String[] ids = null;
        List formIdsList = null;
        if (formIds.containsKey("formIdsList")) {
            formIdsList = (List)formIds.get("formIdsList");
            ids = new String[formIds.size()];
        } else {
            ids = new String[formIds.size() + 1];
        }
        if (formIdsList == null || formIdsList.size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecforPeriodFormResource", (String)"endPeriodNotCorrect"));
            SysUtil.abort();
        }
        int i = 0;
        Iterator ite = formIds.keySet().iterator();
        while (ite.hasNext()) {
            bgFormInfo = new BgFormInfo();
            refInfo = new RefBgColPeriodsInfo();
            formid = (String)ite.next();
            if (formid.equals("formIdsList")) continue;
            ids[i] = formid;
            ++i;
            bosId = BOSUuid.read((String)formid);
            bgFormInfo.setId(bosId);
            refInfo.setBgForm(bgFormInfo);
            this.editData.getRefBgColPeriods().add(refInfo);
        }
        ids[ids.length - 1] = id;
        BgClientHelper.batchApplyMutexService((Component)((Object)this), ids, userId);
        formIds.put(this.editData.getBgForm().getId().toString(), null);
        this.hadPeriod.put(souPer.getNumber(), null);
        Map oldData = this.getIBgColForPeriodF().getFormOldData(formIds, this.hadPeriod);
        HashMap<String, Object> otherData = new HashMap<String, Object>();
        otherData.put("oldData", BgHelper.storeHashMapToByte((HashMap)oldData));
        otherData.put("periods", this.endPeriodSet);
        otherData.put("sourcePer", souPer.getNumber());
        otherData.put("formIdsList", formIds.get("formIdsList"));
        if (otherData != null && !otherData.isEmpty()) {
            this.editData.setMapData(BgHelper.storeHashMapToByte(otherData));
        }
        super.actionSubmit_actionPerformed(e);
        BgFormHelper.refreshBgFormList((CoreUI)this);
        this.returnData = new HashMap();
        this.returnData.put("getData", this.getData());
        this.returnData.put("isSubmit", new Boolean(true));
        this.returnData.put("isCancel", new Boolean(this.isCancel));
        this.returnData.put("setUITitle", ((BgSchemeInfo)this.combBgScheme.getSelectedItem()).getName() + " " + ((BgFormInfo)this.prmtBgForm.getData()).getName());
        BgClientHelper.batchReleaseMutexService(ids);
        this.getIBgColForPeriodF().addNewData(this.getColIdsMap(this.editData));
    }

    private BgPeriodCollection getPeriodColl() {
        this.endPeriodSet = new HashSet();
        BgPeriodCollection col = new BgPeriodCollection();
        BgPeriodInfo info = null;
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (row.getCell("id") == null || row.getCell("id").getValue() == null) continue;
            info = new BgPeriodInfo();
            info.setNumber((String)row.getCell("number").getValue());
            info.setName((String)row.getCell("name").getValue());
            info.setId((BOSUuid)row.getCell("id").getValue());
            col.add(info);
            this.endPeriodSet.add((String)row.getCell("number").getValue());
        }
        return col;
    }

    public BgColForPeriodFormInfo getData() {
        return this.editData;
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelCancel_actionPerformed(e);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitOption_actionPerformed(e);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        int i = -1;
        if (this.tblMain.getSelectManager().size() == 0) {
            SysUtil.abort();
        }
        if (this.tblMain.getCell(i = this.tblMain.getSelectManager().getActiveRowIndex(), 0) != null && this.tblMain.getCell(i, 0).getValue() != null) {
            this.hadPeriod.remove(this.tblMain.getCell(i, 0).getValue().toString());
        }
        this.tblMain.removeRow(i);
    }

    protected IObjectValue createNewData() {
        BgColForPeriodFormInfo bgColInfo = null;
        try {
            bgColInfo = new BgColForPeriodFormInfo();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        bgColInfo.setState(BgCollectStateEnum.PeriodAdjusted);
        bgColInfo.setOrgUnit(this.getSelectOrg());
        return bgColInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgColForPeriodFormFactory.getRemoteInstance();
    }

    @Override
    public void clear() throws Exception {
        if (this.combBgScheme.getSelectedIndex() > 0) {
            this.combBgScheme.setSelectedIndex(0);
        }
        this.prmtBgForm.setData(null);
        this.combSourcePeriodType.setSelectedIndex(0);
        this.combSourcePeriod.setSelectedIndex(-1);
        this.combEndPeriodType.setSelectedIndex(3);
        this.combShowPeriodType.setSelectedIndex(0);
        this.tblMain.removeRows();
    }

    @Override
    public Object saveSolution() throws Exception {
        this.checkInput();
        HashMap<String, Object> saveData = new HashMap<String, Object>();
        saveData.put("bgSchemeID", ((BgSchemeInfo)this.combBgScheme.getSelectedItem()).getId().toString());
        saveData.put("bgFormID", ((BgFormInfo)this.prmtBgForm.getData()).getId().toString());
        saveData.put("sourcePeriodType", (Object)((BgPeriodEnum)((Object)this.combSourcePeriodType.getSelectedItem())));
        saveData.put("sourcePeriod", ((BgPeriodInfo)this.combSourcePeriod.getSelectedItem()).getId().toString());
        saveData.put("endPeriodType", (Object)((BgPeriodEnum)((Object)this.combEndPeriodType.getSelectedItem())));
        saveData.put("endPeriod", this.getEndPeriod());
        saveData.put("displayStyle", (Object)((BgPeriodAdjustDiaplsyEnum)((Object)this.combShowPeriodType.getSelectedItem())));
        return saveData;
    }

    private Object[] getEndPeriod() {
        ArrayList<BgPeriodInfo> aa = new ArrayList<BgPeriodInfo>();
        BgPeriodInfo info = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            if (this.tblMain.getRow(i).getCell("id").getValue() == null) continue;
            info = new BgPeriodInfo();
            info.setNumber(this.tblMain.getRow(i).getCell("number").getValue().toString());
            info.setName(this.tblMain.getRow(i).getCell("name").getValue().toString());
            info.setPeriodType((BgPeriodEnum)((Object)this.tblMain.getRow(i).getCell("periodType").getValue()));
            info.setBeginDate((Date)this.tblMain.getRow(i).getCell("beginDate").getValue());
            info.setEndDate((Date)this.tblMain.getRow(i).getCell("endDate").getValue());
            info.setId(BOSUuid.read((String)this.tblMain.getRow(i).getCell("id").getValue().toString()));
            aa.add(info);
        }
        if (aa.size() > 0) {
            return aa.toArray();
        }
        return null;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        try {
            HashMap loadData;
            if (o instanceof Map && (loadData = (HashMap)o) != null && loadData.size() > 0 && !this.loadDataToUI(loadData)) {
                MsgBox.showDetailAndOK((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"), (String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme0") + "\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme1") + "\r\n" + EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme2")), (int)2);
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
        }
    }

    private boolean loadDataToUI(Map loadData) throws Exception {
        this.combBgScheme.setSelectedItem(null);
        this.prmtBgForm.setValue(null);
        if (loadData.get("bgSchemeID") == null || loadData.get("bgFormID") == null) {
            return false;
        }
        for (int i = 0; i < this.combBgScheme.getItemCount(); ++i) {
            if (!loadData.get("bgSchemeID").equals(((BgSchemeInfo)this.combBgScheme.getItemAt(i)).getId().toString())) continue;
            this.combBgScheme.setSelectedIndex(i);
        }
        if (this.combBgScheme.getSelectedItem() == null) {
            return false;
        }
        this.combBgScheme_itemStateChanged(null);
        if (!this.inputBgForm((String)loadData.get("bgFormID"))) {
            return false;
        }
        if (!this.inputType((BgPeriodEnum)((Object)loadData.get("sourcePeriodType")), (BgPeriodEnum)((Object)loadData.get("endPeriodType")))) {
            return false;
        }
        if (!this.inputSourecPeriod((String)loadData.get("sourcePeriod"))) {
            return false;
        }
        this.inputEndPeriod((Object[])loadData.get("endPeriod"));
        return true;
    }

    private void inputEndPeriod(Object[] endPeriod) {
        this.tblMain.removeRows();
        this.hadPeriod.clear();
        IRow row = null;
        BgPeriodInfo info = null;
        if (endPeriod != null && endPeriod.length > 0) {
            for (int n = endPeriod.length - 1; n >= 0; --n) {
                info = (BgPeriodInfo)endPeriod[n];
                if (!info.getPeriodType().equals(this.combEndPeriodType.getSelectedItem())) continue;
                row = this.tblMain.addRow();
                row.getCell(0).setValue((Object)info.getNumber());
                row.getCell(1).setValue((Object)info.getName());
                row.getCell(2).setValue((Object)info.getPeriodType());
                row.getCell(3).setValue((Object)info.getBeginDate());
                row.getCell(4).setValue((Object)info.getEndDate());
                row.getCell("id").setValue((Object)info.getId());
                this.hadPeriod.put(info.getNumber(), null);
            }
        }
    }

    private boolean inputSourecPeriod(String string) {
        BgPeriodInfo info = null;
        for (int i = 0; i < this.combSourcePeriod.getItemCount(); ++i) {
            info = (BgPeriodInfo)this.combSourcePeriod.getItemAt(i);
            if (!info.getId().toString().equals(string)) continue;
            this.combSourcePeriod.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private boolean inputType(BgPeriodEnum sourcePeriodType, BgPeriodEnum endPeriodType) {
        try {
            this.combSourcePeriodType.setSelectedItem((Object)sourcePeriodType);
            this.combSourcePeriodType_itemStateChanged(null);
            this.combEndPeriodType.setSelectedItem((Object)endPeriodType);
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean inputBgForm(String bgFormID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view = this.prmtBgForm.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter = view.getFilter();
        filter.appendFilterItem("id", (Object)bgFormID);
        String maskstring = filter.getMaskString();
        filter.setMaskString(maskstring + " and #" + (filter.getFilterItems().size() - 1));
        view.setFilter(filter);
        BgFormCollection bgFormCol = BgFormFactory.getRemoteInstance().getBgFormCollection(view);
        if (bgFormCol.size() == 1) {
            this.prmtBgForm.setValue((Object)bgFormCol.get(0));
            this.prmtBgForm_dataChanged(null);
            return true;
        }
        return false;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        if (uicontext.get("selfPanelUiName") != null) {
            oql.append(" and uiName='" + (String)uicontext.get("selfPanelUiName") + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        ActionEvent e = new ActionEvent(this.btnSubmit, 1001, "");
        this.actionSubmit_actionPerformed(e);
        return true;
    }

    @Override
    public boolean cancel() throws Exception {
        this.isCancel = true;
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return this.returnData;
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        return null;
    }

    private Map getColIdsMap(BgColForPeriodFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("decId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgColPeriodsCollection coll = editData.getRefBgColPeriods();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }
}

