/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgCollectException;
import com.kingdee.eas.ma.budget.BgCollectFormFactory;
import com.kingdee.eas.ma.budget.BgCollectFormInfo;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgCollectForm;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.RefBgFormCollection;
import com.kingdee.eas.ma.budget.RefBgFormFactory;
import com.kingdee.eas.ma.budget.RefBgFormInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgCollectFormAddNewUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgCollectFormCommentCommitDlgUI;
import com.kingdee.eas.ma.budget.client.BgCollectFormCommentViewDlgUI;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class BgCollectFormAddNewUI
extends AbstractBgCollectFormAddNewUI
implements AssignSolutionInterface {
    private static final long serialVersionUID = -7332822551105777228L;
    private static final Logger logger = CoreUIObject.getLogger(BgCollectFormAddNewUI.class);
    private static final String STRRESOURCE = "com.kingdee.eas.ma.budget.client.BgCollectResource";
    protected boolean isCancel = true;
    protected boolean isAddNew = true;
    protected Map orgUnitMap = new HashMap();
    protected Vector orgUnits = null;
    private Map returnData = null;
    private TreeWillExpandListener listener = new TreeWillExpandListener(){

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)e.getPath().getLastPathComponent();
            try {
                OrgUnitUtils.addChildNode(node, BgCollectFormAddNewUI.this.orgUnitMap.keySet(), true);
            }
            catch (Exception ex) {
                ExceptionHandler.handle((String)"", (Throwable)ex);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
        }
    };

    public void onLoad() throws Exception {
        String rootUnitID = this.getCurrentCostCenterOrgUnitInfo().getId().toString();
        TreeModel treeModel = OrgUnitUtils.getOrgTreeModel(this.tblTree, rootUnitID, this.listener);
        this.tblTree.setModel(treeModel);
        this.tblTree.setShowCheckBox(true);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)treeModel.getRoot();
        root.setChecked(true);
        root.setCheckBoxEnabled(false);
        root.setCheckBoxEnabled(false);
        super.onLoad();
        this.initSystem();
        this.initBgSchema();
        if (this.getOprtState() == OprtState.VIEW) {
            this.actionConfirm.setEnabled(false);
        } else {
            this.actionConfirm.setEnabled(true);
        }
        this.prmtBgForm.getEntityViewInfo().getFilter().setMaskString("(" + this.prmtBgForm.getEntityViewInfo().getFilter().getMaskString() + ") and #" + this.prmtBgForm.getEntityViewInfo().getFilter().getFilterItems().size());
        this.prmtBgForm.getEntityViewInfo().getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)4, CompareType.NOTEQUALS));
    }

    private IBgForm getBgFormInterface() throws BOSException {
        return BgFormFactory.getRemoteInstance();
    }

    private void initSystem() throws Exception {
        this.prmtBgForm.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                BgCollectFormAddNewUI.this.checkDataValid(eventObj.getNewValue(), eventObj.getOldValue());
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddComment.setEnabled(false);
        this.btnAddComment.setVisible(false);
        this.btnViewComment.setEnabled(false);
        this.btnViewComment.setVisible(false);
        this.menuBar.setVisible(false);
        this.toolBar.setVisible(false);
        this.statusBar.setVisible(false);
        this.actionQuit.setEnabled(true);
    }

    protected void initBgSchema() throws Exception {
        FullOrgUnitInfo ouInfo = this.getCurrentFullOrgUnitInfoUsedInBg();
        if (ouInfo == null) {
            throw new BgCollectException(BgCollectException.CURRENTHASNOCOSTCENTER);
        }
        IBgScheme bgSchema = BgSchemeFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)ouInfo.getId().toString()));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)1, CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(ouInfo.getId().toString());
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgSet, (FilterInfo)filter);
        }
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("name");
        BgSchemeCollection bgSchemeCols = bgSchema.getBgSchemeCollection(view);
        if (bgSchemeCols == null || bgSchemeCols.isEmpty()) {
            EntityViewInfo viewForm = new EntityViewInfo();
            FilterInfo filterForm = new FilterInfo();
            filterForm.getFilterItems().add(new FilterItemInfo("id", (Object)"0000000000000000000000000000"));
            viewForm.setFilter(filterForm);
            this.prmtBgForm.setEntityViewInfo(viewForm);
            return;
        }
        String[] num = new String[]{"number"};
        BgHelper.sortCollection(bgSchemeCols, num);
        this.comBgScheme.addItems(bgSchemeCols.toArray());
    }

    protected void initCostCenter(BOSUuid bgFormId) throws Exception {
        Map filterMap = null;
        ArrayList<BgFormStateEnum> state = new ArrayList<BgFormStateEnum>();
        state.add(BgFormStateEnum.Approved);
        try {
            filterMap = this.getBgFormInterface().getFormFilterInfo(bgFormId, state);
            filterMap = this.getBgFormInterface().getFormFilterInfo(filterMap);
            this.orgUnitMap.clear();
            if (filterMap != null && !filterMap.isEmpty()) {
                String _bgFormId2 = null;
                String orgUnitId = null;
                for (String _bgFormId2 : filterMap.keySet()) {
                    orgUnitId = (String)filterMap.get(_bgFormId2);
                    if (this.orgUnitMap.containsKey(orgUnitId)) continue;
                    this.orgUnitMap.put(orgUnitId, null);
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
    }

    protected void traceNode(DefaultKingdeeTreeNode root, Map orgUnitMap) {
        if (root == null || orgUnitMap == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        DefaultKingdeeTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                if (orgUnitMap.containsKey(orgUnitInfo.getId().toString())) {
                    node.setChecked(true);
                } else {
                    node.setChecked(false);
                }
            }
            this.traceNode(node, orgUnitMap);
        }
    }

    protected void traceNode(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            node.setChecked(false);
            this.traceNode(node);
        }
    }

    protected void checkTraceNode(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        OrgStructureInfo posi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        FullOrgUnitInfo pOrgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                if (!root.isChecked()) {
                    posi = (OrgStructureInfo)root.getUserObject();
                    pOrgUnitInfo = posi.getUnit();
                    BgCollectException e = new BgCollectException(BgCollectException.NOSELECTPARENTNODE, new String[]{orgUnitInfo.getName(), pOrgUnitInfo.getName()});
                    this.handleException((Exception)((Object)e));
                    SysUtil.abort();
                }
            }
            this.checkTraceNode(node);
        }
    }

    protected List<String> traceNode(KDTree orgTree) {
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (orgTree == null) {
            return orgUnitIds;
        }
        orgUnitIds.addAll(this.orgUnitMap.keySet());
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
        this.traceNode(root, orgUnitIds);
        return orgUnitIds;
    }

    protected void traceNode(DefaultKingdeeTreeNode root, List<String> orgUnitList) {
        if (root == null || orgUnitList == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                orgUnitList.add(orgUnitInfo.getId().toString());
            } else if (node.getUserObject() instanceof OrgStructureInfo) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                orgUnitList.remove(orgUnitInfo.getId().toString());
            }
            this.traceNode(node, orgUnitList);
        }
    }

    @Override
    protected void prmtBgForm_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgForm_dataChanged(e);
        if (this.isAddNew && this.prmtBgForm.getData() != null) {
            BgFormInfo bgFormInfo = (BgFormInfo)this.prmtBgForm.getData();
            this.initCostCenter(bgFormInfo.getId());
            this.traceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), this.orgUnitMap);
            this.tblTree.repaint();
        }
    }

    protected void checkDataValid(Object newValue, Object oldValue) {
        if (newValue != null) {
            BgFormInfo bgFormInfo = (BgFormInfo)newValue;
            if (oldValue != null && bgFormInfo.getId().equals((Object)((BgFormInfo)oldValue).getId())) {
                return;
            }
            try {
                IBgCollectForm bgCollectImpl = BgCollectFormFactory.getRemoteInstance();
                boolean hasBgDataFormula = bgCollectImpl.hasBgDataFomular(bgFormInfo.getId());
                if (!hasBgDataFormula) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGFORMSPECIFIEDHASNOBGFORMULA"));
                    this.prmtBgForm.setData(oldValue);
                    SysUtil.abort();
                }
                try {
                    if (BgFormFacadeFactory.getRemoteInstance().checkFormIsAdjust(bgFormInfo.getId()) != null) {
                        MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgFormInAdjustNoCollect"));
                        this.prmtBgForm.setData(oldValue);
                        SysUtil.abort();
                    }
                }
                catch (BgFormException e1) {
                    MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BgFormInAdjustNoCollect"));
                    this.prmtBgForm.setData(oldValue);
                    SysUtil.abort();
                }
            }
            catch (Exception e) {
                this.handleException(e);
            }
        }
    }

    private void loadCostCenterStatus() {
        if (!this.getOprtState().equals(OprtState.ADDNEW) && this.editData != null && this.editData.getRefBgForms() != null) {
            RefBgFormCollection children = this.editData.getRefBgForms();
            HashMap<String, Object> orgUnitMap = new HashMap<String, Object>();
            int count = children.size();
            for (int i = 0; i < count; ++i) {
                orgUnitMap.put(children.get(i).getBgForm().getOrgUnit().getId().toString(), null);
            }
            this.traceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), orgUnitMap);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (this.editData.getBgForm() != null) {
            BgSchemeInfo bgSchemaInfo = this.editData.getBgForm().getBgScheme();
            BgFormHelper.setSelectObject(this.comBgScheme, bgSchemaInfo);
            this.prmtBgForm.setData((Object)this.editData.getBgForm());
            this.loadCostCenterStatus();
        }
    }

    protected void beforeStoreFields(ActionEvent ex) {
        try {
            super.beforeStoreFields(ex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.editData.setBgForm((BgFormInfo)this.prmtBgForm.getData());
            if (this.editData.getBgForm() == null) {
                BgCollectException e = new BgCollectException(BgCollectException.HASNOBGFORMINBGCOLLECTFORM);
                this.handleException((Exception)((Object)e));
                SysUtil.abort();
            }
            this.checkTraceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot());
            this.editData.getRefBgForms().clear();
            List<String> ouIdList = this.traceNode(this.tblTree);
            RefBgFormCollection refBgFormCols = RefBgFormFactory.getRemoteInstance().loadRefBgFormCollectionByBgForm(this.editData.getBgForm(), ouIdList);
            int count = refBgFormCols.size();
            for (int i = 0; i < count; ++i) {
                RefBgFormInfo child = refBgFormCols.get(i);
                child.setBgCollect(this.editData);
            }
            this.editData.getRefBgForms().addCollection(refBgFormCols);
            HashMap<String, List<String>> otherMap = new HashMap<String, List<String>>();
            otherMap.put("orgList", ouIdList);
            this.editData.setOrgList(BgHelper.storeHashMapToByte(otherMap));
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setOprtState(OprtState.EDIT);
        }
    }

    protected IBgCollectForm getInterface() throws BOSException {
        return BgCollectFormFactory.getRemoteInstance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.chkMenuItemSubmitAndAddNew.setVisible(false);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
        this.checkSelectCostCenter(root);
        boolean isDebug = false;
        this.beforeStoreFields(null);
        if (isDebug) {
            super.actionSubmit_actionPerformed(e);
        } else {
            this.isAddNew = false;
            super.actionSubmit_actionPerformed(e);
            this.isCancel = false;
            this.returnData = new HashMap();
            this.returnData.put("getData", this.getData());
            this.returnData.put("isCancel", new Boolean(this.isCancel()));
            this.returnData.put("setUITitle", ((BgSchemeInfo)this.comBgScheme.getSelectedItem()).getName() + " " + ((BgFormInfo)this.prmtBgForm.getData()).getName());
            this.getInterface().addNewData(this.getColIdsMap(this.editData));
            BgFormHelper.refreshBgFormList((CoreUI)this);
        }
    }

    private Map getColIdsMap(BgCollectFormInfo editData) {
        HashMap<String, Object> decIds = new HashMap<String, Object>();
        HashMap<String, Object> refIds = new HashMap<String, Object>();
        decIds.put("colId", editData.getId().toString());
        decIds.put("mainFormId", editData.getBgForm().getId().toString());
        RefBgFormCollection coll = editData.getRefBgForms();
        for (int i = 0; i < coll.size(); ++i) {
            refIds.put(coll.get(i).getBgForm().getId().toString(), null);
        }
        decIds.put("refIds", refIds);
        return decIds;
    }

    protected IObjectValue createNewData() {
        BgCollectFormInfo bgCollectFormInfo = null;
        try {
            bgCollectFormInfo = new BgCollectFormInfo();
            bgCollectFormInfo.setState(BgCollectStateEnum.COLLECTED);
            bgCollectFormInfo.setOrgUnit(this.getCurrentFullOrgUnitInfoUsedInBg());
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return bgCollectFormInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgCollectFormFactory.getRemoteInstance();
    }

    @Override
    protected void comBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        if (this.comBgScheme.getSelectedItem() != null) {
            BgFormInfo bgFormInfo;
            BgSchemeInfo bgSchemaInfo = (BgSchemeInfo)this.comBgScheme.getSelectedItem();
            if (this.prmtBgForm.getData() != null && !(bgFormInfo = (BgFormInfo)this.prmtBgForm.getData()).getBgScheme().getId().toString().equals(bgSchemaInfo.getId().toString())) {
                this.prmtBgForm.setData(null);
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("lastUpdateTime"));
            sic.add(new SelectorItemInfo("bgPeriod.id"));
            sic.add(new SelectorItemInfo("bgPeriod.number"));
            sic.add(new SelectorItemInfo("bgPeriod.name"));
            sic.add(new SelectorItemInfo("orgUnit.id"));
            sic.add(new SelectorItemInfo("orgUnit.number"));
            sic.add(new SelectorItemInfo("orgUnit.name"));
            sic.add(new SelectorItemInfo("bgScheme.id"));
            sic.add(new SelectorItemInfo("bgScheme.number"));
            sic.add(new SelectorItemInfo("bgScheme.name"));
            sic.add(new SelectorItemInfo("bgTemplate.id"));
            sic.add(new SelectorItemInfo("bgTemplate.number"));
            sic.add(new SelectorItemInfo("bgTemplate.name"));
            sic.add(new SelectorItemInfo("bgTemplate.formType"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("state"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getCurrentFullOrgUnitInfoUsedInBg().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemaInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(2)));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)4, CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                HashSet<String> orgSet = new HashSet<String>();
                orgSet.add(this.getCurrentFullOrgUnitInfoUsedInBg().getId().toString());
                filter = BgPermissionHelper.addBgFormPermission((String)userId, orgSet, (FilterInfo)filter);
            }
            HashSet<Integer> formType = new HashSet<Integer>();
            formType.add(new Integer(2));
            formType.add(new Integer(3));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", formType, CompareType.NOTINCLUDE));
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate = 4", CompareType.NOTINNER));
            if (!StringUtils.isEmpty((String)filter.getMaskString())) {
                filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
            }
            view.setFilter(filter);
            this.prmtBgForm.setEntityViewInfo(view);
            this.prmtBgForm.setRefresh(true);
            DefaultKingdeeTreeNode node = null;
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                node = (DefaultKingdeeTreeNode)root.getChildAt(i);
                node.setChecked(false);
                this.traceNode(node);
            }
            this.tblTree.repaint();
        }
    }

    protected FullOrgUnitInfo getCurrentFullOrgUnitInfoUsedInBg() {
        CostCenterOrgUnitInfo costCenterInfo = this.getCurrentCostCenterOrgUnitInfo();
        if (costCenterInfo != null) {
            FullOrgUnitInfo ouInfo = new FullOrgUnitInfo();
            ouInfo.setId(BOSUuid.read((String)costCenterInfo.getId().toString()));
            return ouInfo;
        }
        return null;
    }

    protected CostCenterOrgUnitInfo getCurrentCostCenterOrgUnitInfo() {
        return SysContext.getSysContext().getCurrentCostUnit();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("state");
        sic.add("otherCont");
        sic.add("orgList");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("bgForm.id");
        sic.add("bgForm.number");
        sic.add("bgForm.name");
        sic.add("bgForm.bgScheme.id");
        sic.add("bgForm.bgScheme.name");
        sic.add("bgForm.bgScheme.number");
        sic.add("bgForm.orgUnit.id");
        sic.add("bgForm.orgUnit.name");
        sic.add("bgForm.orgUnit.number");
        sic.add("bgForm.orgUnit.longnumber");
        sic.add("bgForm.bgPeriod.name");
        sic.add("refBgForms.id");
        sic.add("refBgForms.comment");
        sic.add("refBgForms.adjustMapData");
        sic.add("refBgForms.bgForm");
        sic.add("refBgForms.bgForm.id");
        sic.add("refBgForms.bgForm.number");
        sic.add("refBgForms.bgForm.name");
        sic.add("refBgForms.bgForm.orgUnit.id");
        sic.add("refBgForms.bgForm.orgUnit.name");
        sic.add("refBgForms.bgForm.orgUnit.number");
        sic.add("refBgForms.bgForm.orgUnit.longnumber");
        sic.add("refBgForms.bgForm.bgScheme.id");
        sic.add("refBgForms.bgForm.bgScheme.name");
        sic.add("refBgForms.bgForm.bgScheme.number");
        return sic;
    }

    public boolean isModify() {
        return false;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }

    public BgCollectFormInfo getData() {
        return this.editData;
    }

    @Override
    protected void btnAddComment_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM", (Object)this.editData.getRefBgForms().get(0).getBgForm());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCollectFormCommentCommitDlgUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    protected void btnViewComment_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGFORM", (Object)this.editData.getRefBgForms().get(0).getBgForm());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgCollectFormCommentViewDlgUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
    }

    private void checkSelectCostCenter(DefaultKingdeeTreeNode root) {
        if (root == null) {
            return;
        }
        DefaultKingdeeTreeNode node = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.getUserObject() instanceof OrgStructureInfo) {
                OrgStructureInfo osi = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo orgUnitInfo = osi.getUnit();
                if (node.isChecked() && !this.orgUnitMap.containsKey(orgUnitInfo.getId().toString())) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"161_BgCollectFormAddNewUI"));
                    SysUtil.abort();
                }
            }
            this.checkSelectCostCenter(node);
        }
    }

    protected void disposeUIWindow() {
        super.disposeUIWindow();
    }

    @Override
    public void clear() throws Exception {
        this.prmtBgForm.setData(null);
        this.comBgScheme.setSelectedIndex(-1);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot();
        this.disSelectedTree(root);
        root.setChecked(true);
        this.tblTree.repaint();
    }

    private void disSelectedTree(DefaultKingdeeTreeNode node) {
        if (node == null) {
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            node.setChecked(false);
            this.disSelectedTree(subNode);
        }
    }

    @Override
    public Object saveSolution() throws Exception {
        if (this.prmtBgForm.getData() == null) {
            BgCollectException e = new BgCollectException(BgCollectException.HASNOBGFORMINBGCOLLECTFORM);
            this.handleException((Exception)((Object)e));
            SysUtil.abort();
        }
        this.setOrgs();
        HashMap<String, Object> saveData = new HashMap<String, Object>();
        saveData.put("bgSchemeID", ((BgSchemeInfo)this.comBgScheme.getSelectedItem()).getId().toString());
        saveData.put("bgFormID", ((BgFormInfo)this.prmtBgForm.getData()).getId().toString());
        saveData.put("orgUnits", this.orgUnits);
        return saveData;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        try {
            HashMap loadData;
            if (o instanceof Map && (loadData = (HashMap)o) != null && loadData.size() > 0 && !this.loadDataToUI(loadData)) {
                MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
            }
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"errorScheme"));
        }
    }

    private boolean loadDataToUI(Map loadData) throws Exception {
        this.comBgScheme.setSelectedItem(null);
        this.prmtBgForm.setValue(null);
        this.inputOrgUnitTraceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), null);
        this.tblTree.requestFocus();
        if (loadData.get("bgSchemeID") == null || loadData.get("bgFormID") == null || loadData.get("orgUnits") == null || ((Vector)loadData.get("orgUnits")).size() < 2) {
            return false;
        }
        for (int i = 0; i < this.comBgScheme.getItemCount(); ++i) {
            if (!loadData.get("bgSchemeID").equals(((BgSchemeInfo)this.comBgScheme.getItemAt(i)).getId().toString())) continue;
            this.comBgScheme.setSelectedIndex(i);
        }
        if (this.comBgScheme.getSelectedItem() == null) {
            return false;
        }
        this.comBgScheme_itemStateChanged(null);
        if (!this.inputBgForm((String)loadData.get("bgFormID"))) {
            return false;
        }
        this.inputOrgUnit((Vector)loadData.get("orgUnits"));
        return true;
    }

    private void inputOrgUnit(Vector orgUnit) {
        ((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot()).setChecked(true);
        this.inputOrgUnitTraceNode((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot(), orgUnit);
        this.tblTree.requestFocus();
    }

    private void inputOrgUnitTraceNode(DefaultKingdeeTreeNode root, Vector orgUnit) {
        if (root == null || orgUnit == null || orgUnit.isEmpty()) {
            return;
        }
        HashMap orgIds = new HashMap();
        for (int i = 0; i < orgUnit.size(); ++i) {
            orgIds.put(((FullOrgUnitInfo)orgUnit.get(i)).getId().toString(), null);
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            osi = (OrgStructureInfo)node.getUserObject();
            orgUnitInfo = osi.getUnit();
            if (orgUnit != null && orgIds.containsKey(orgUnitInfo.getId().toString())) {
                node.setChecked(true);
            } else {
                node.setChecked(false);
            }
            this.inputOrgUnitTraceNode(node, orgUnit);
        }
    }

    private boolean inputBgForm(String bgFormID) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view = this.prmtBgForm.getEntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter = view.getFilter();
        filter.appendFilterItem("id", (Object)bgFormID);
        String maskstring = filter.getMaskString();
        filter.setMaskString(maskstring + " and #" + (filter.getFilterItems().size() - 1));
        view.setFilter(filter);
        BgFormCollection bgFormCol = this.getBgFormInterface().getBgFormCollection(view);
        if (bgFormCol.size() == 1) {
            this.prmtBgForm.setValue((Object)bgFormCol.get(0));
            this.prmtBgForm_dataChanged(null);
            return true;
        }
        return false;
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        if (uicontext.get("selfPanelUiName") != null) {
            oql.append(" and uiName='" + (String)uicontext.get("selfPanelUiName") + "' ");
        }
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public boolean conferm(Object invokeUi) throws Exception {
        ActionEvent e = new ActionEvent(this.btnConfirm, 1001, "");
        this.actionSubmit_actionPerformed(e);
        return true;
    }

    @Override
    public boolean cancel() throws Exception {
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return this.returnData;
    }

    public void setConfermLabel(String confermLabel) {
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        return null;
    }

    public void setOrgs() {
        this.orgUnits = new Vector();
        try {
            this.orgUnits.add(((OrgStructureInfo)((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot()).getUserObject()).getUnit());
            this.orgs((DefaultKingdeeTreeNode)this.tblTree.getModel().getRoot());
        }
        catch (Exception e) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"errorData"));
            SysUtil.abort();
        }
    }

    public Vector getOrgs() {
        return this.orgUnits;
    }

    protected void orgs(DefaultKingdeeTreeNode root) throws Exception {
        if (root == null) {
            return;
        }
        OrgStructureInfo osi = null;
        FullOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node.isChecked()) {
                osi = (OrgStructureInfo)node.getUserObject();
                orgUnitInfo = osi.getUnit();
                this.orgUnits.add(orgUnitInfo);
            }
            this.orgs(node);
        }
    }

    @Override
    public String getNewConfermLabel() {
        return null;
    }

    private boolean addBgFormToChildren(String orgId) throws Exception {
        BgFormInfo bgFormInfo = null;
        if (this.prmtBgForm.getData() != null) {
            bgFormInfo = (BgFormInfo)this.prmtBgForm.getData();
        }
        if (bgFormInfo != null) {
            bgFormInfo = this.getBgFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId().toString()), this.getFormSelectors());
        }
        IBgCollectForm iBgCollForm = BgCollectFormFactory.getRemoteInstance();
        return iBgCollForm.addBgFormToChildren(orgId, bgFormInfo);
    }

    private SelectorItemCollection getFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("state"));
        return sic;
    }
}

