/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCombinItemFDObject;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaFacadeFactory;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgItemQueryFieldEnum;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.client.AbstractBgCombinItemFDF7UI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCombinItemFDF7UI
extends AbstractBgCombinItemFDF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgCombinItemFDF7UI.class);
    private Date date = null;
    private String orgUnitId = null;
    private String schemeId = null;
    private boolean isMulti = false;
    private boolean isCancel = true;
    private BgCombinItemFDObject result = null;
    private Vector results = new Vector();

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.table.checkParsed();
        super.onLoad();
        this.date = (Date)this.getUIContext().get("date");
        this.orgUnitId = (String)this.getUIContext().get("orgUnit");
        this.isMulti = (Boolean)this.getUIContext().get("isMulti");
        if (this.isMulti) {
            this.table.getSelectManager().setSelectMode(10);
        } else {
            this.table.getSelectManager().setSelectMode(2);
        }
        this.initBoxBgForm();
    }

    @Override
    protected void boxBgForm_actionPerformed(ActionEvent e) throws Exception {
        super.boxBgForm_actionPerformed(e);
        this.txtSpNumber.setText("");
        if (this.boxBgForm.getSelectedItem() != null) {
            BgFormInfo info = (BgFormInfo)this.boxBgForm.getSelectedItem();
            String bgFormId = info.getId().toString();
            this.putDataToKDTable(bgFormId, this.orgUnitId, 1, "", true);
        }
    }

    @Override
    protected void btnQuery_actionPerformed(ActionEvent e) throws Exception {
        super.btnQuery_actionPerformed(e);
        if (this.boxBgForm.getSelectedItem() == null) {
            return;
        }
        BgFormInfo info = (BgFormInfo)this.boxBgForm.getSelectedItem();
        String bgFormId = info.getId().toString();
        int queryFiledIndex = ((BgItemQueryFieldEnum)((Object)this.cbxField.getSelectedItem())).getValue();
        String queryStr = this.txtSpNumber.getText().trim();
        boolean isBlur = true;
        if (!queryStr.equals("")) {
            isBlur = this.raCheck.isSelected();
        }
        this.putDataToKDTable(bgFormId, this.orgUnitId, queryFiledIndex, queryStr, isBlur);
    }

    public void initBoxBgForm() throws BOSException, SQLException {
        BgFormCollection coll = this.getBgformList();
        if (coll != null && coll.size() != 0) {
            this.boxBgForm.addItems(coll.toArray());
        }
    }

    public BgFormCollection getBgformList() throws SQLException, BOSException {
        String dateStr = this.date.getYear() + 1900 + "-" + (this.date.getMonth() + 1) + "-" + this.date.getDate();
        String periodNumber = this.date.getYear() + 1900 + "Y." + (this.date.getMonth() + 1 < 10 ? "0" + String.valueOf(this.date.getMonth() + 1) : String.valueOf(this.date.getMonth() + 1)) + "M";
        String sql = "select fid from t_bg_bgscheme where fisformal=1 and fperiod = 4 and forgunitid = '" + this.orgUnitId + "' and fdatefrom <= to_date('" + dateStr + "') and fdateto >= to_date('" + dateStr + "')";
        ISQLExecutor query = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = query.executeSQL();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (rs.next()) {
            this.schemeId = rs.getString(1);
            IBgForm iForm = BgFormFactory.getRemoteInstance();
            BgFormCollection coll = iForm.getBgFormCollection("select id ,number,name where bgPeriod.number = '" + periodNumber + "' and bgScheme.id='" + this.schemeId + "' and state=" + 2);
            return coll;
        }
        return null;
    }

    public static BgCombinItemFDObject getSingleItemBgValue(String orgUnitId, String itemCombinNumber, Date date) throws SQLException, BOSException, EASBizException {
        Object[] result = null;
        String dateStr = date.getYear() + 1900 + "-" + (date.getMonth() + 1) + "-" + date.getDate();
        String periodNumber = date.getYear() + 1900 + "Y." + (date.getMonth() + 1 < 10 ? "0" + String.valueOf(date.getMonth() + 1) : String.valueOf(date.getMonth() + 1)) + "M";
        String sql = "select fid from t_bg_bgscheme where fisformal=1 and fperiod = 4 and forgunitid = '" + orgUnitId + "' and fdatefrom <= to_date('" + dateStr + "') and fdateto >= to_date('" + dateStr + "')";
        ISQLExecutor query = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = query.executeSQL();
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String schemeId = null;
        if (rs.next()) {
            schemeId = rs.getString(1);
        }
        if (schemeId != null && !schemeId.trim().equals("")) {
            String key = "";
            itemCombinNumber = BgFormulaFacadeFactory.getRemoteInstance().parseBgItemCombi(orgUnitId, itemCombinNumber);
            key = itemCombinNumber.replaceAll(",", "_");
            sql = " select a.fbgvalue ,c.fkey ,d.fextType ,d.fnumber ,b.fyear ,b.fmonth  from t_bg_bgdata a,t_bg_bgperiod b ,t_bg_bgitemcombination c ,t_bg_bgelement d  where a.fbgperiodid=b.fid and a.fbgitemcombinid = c.fid and a.fbgelementid = d.fid  and a.fbgschemeid = '" + schemeId + "' and a.forgunitid = '" + orgUnitId + "'  and b.fnumber = '" + periodNumber + "' and c.fkey = '" + key + "'  and b.fperiodtype = " + 4;
            query = SQLExecutorFactory.getRemoteInstance((String)sql);
            rs = query.executeSQL();
            if (rs.next()) {
                BigDecimal monthBudget = rs.getBigDecimal(1);
                String combinNumber = rs.getString(2);
                String eleNumber = rs.getString(4);
                int year = rs.getInt(5);
                int month = rs.getInt(6);
                result = BgCombinItemFDF7UI.getTotalInfo(monthBudget, orgUnitId, combinNumber, eleNumber, year, month, 1, "", true);
            }
        }
        if (result != null) {
            BgCombinItemFDObject result1 = new BgCombinItemFDObject(result);
            return result1;
        }
        return null;
    }

    private void putDataToKDTable(String bgFormId, String orgUnitId, int queryField, String queryStr, boolean isBlur) throws BOSException, SQLException, EASBizException {
        Vector<Object[]> result = new Vector<Object[]>();
        if (this.schemeId != null) {
            String sql = " select a.fbgvalue ,c.fkey ,d.fextType ,d.fnumber ,b.fyear ,b.fmonth  from t_bg_bgdata a,t_bg_bgperiod b ,t_bg_bgitemcombination c ,t_bg_bgelement d  where a.fbgperiodid=b.fid and a.fbgitemcombinid = c.fid and a.fbgelementid = d.fid  and a.fbgformid = '" + bgFormId + "' and b.fperiodtype = " + 4;
            ISQLExecutor query = SQLExecutorFactory.getRemoteInstance((String)sql);
            IRowSet rs = query.executeSQL();
            while (rs.next()) {
                int month;
                int year;
                String eleNumber;
                String combinNumber;
                BigDecimal monthBudget = rs.getBigDecimal(1);
                Object[] obj = BgCombinItemFDF7UI.getTotalInfo(monthBudget, orgUnitId, combinNumber = rs.getString(2), eleNumber = rs.getString(4), year = rs.getInt(5), month = rs.getInt(6), queryField, queryStr, isBlur);
                if (obj == null) continue;
                result.add(obj);
            }
            this.table.removeRows();
            for (int i = 0; i < result.size(); ++i) {
                if (result.get(i) == null) continue;
                Object[] obj = (Object[])result.get(i);
                IRow iRow = this.table.addRow();
                iRow.setUserObject((Object)obj);
                iRow.getCell(0).setValue(obj[0]);
                iRow.getCell(1).setValue(obj[1]);
                iRow.getCell(2).setValue(obj[2]);
                iRow.getCell(3).setValue(obj[3]);
                iRow.getCell(4).setValue(obj[4]);
                iRow.getCell(5).setValue(obj[5]);
                iRow.getCell(6).setValue(obj[6]);
                iRow.getCell(7).setValue(obj[7]);
            }
        }
    }

    public static Object[] getTotalInfo(BigDecimal monthBudget, String orgUnitId, String combinNumber, String eleNumber, int year, int month, int queryField, String queryStr, boolean isBlur) throws EASBizException, BOSException, SQLException {
        Object[] detailInfo = BgCombinItemFDF7UI.getDetailInfo(orgUnitId, combinNumber, eleNumber, year, month, queryField, queryStr, isBlur);
        if (detailInfo == null) {
            return null;
        }
        Object[] obj = new Object[]{combinNumber, detailInfo[0], detailInfo[1], detailInfo[2], detailInfo[3], ((BigDecimal)detailInfo[2]).subtract((BigDecimal)detailInfo[3]), monthBudget, detailInfo[4]};
        return obj;
    }

    private static Object[] getDetailInfo(String orgUnitId, String combinNumber, String eleNumber, int year, int month, int queryField, String queryStr, boolean isBlur) throws BOSException, EASBizException, SQLException {
        IBgItem iItem = BgItemFactory.getRemoteInstance();
        Object[] result = new Object[5];
        String[] strs = combinNumber.split("_");
        String name = "";
        String spNumber = "";
        String sql = " select name,specialNumber where orgUnit.id = '" + orgUnitId + "' and number='@1' ";
        if (queryStr != null && !queryStr.equals("")) {
            if (isBlur) {
                if (queryField == 1) {
                    sql = sql + " and name like '%@2%'";
                } else if (queryField == 2) {
                    sql = sql + " and ((specialNumber like '%@2%' and specialNumber is not null) or specialNumber is null )";
                }
            } else if (queryField == 1) {
                sql = sql + " and name = '@2'";
            } else if (queryField == 2) {
                sql = sql + " and ((specialNumber = '@2' and specialNumber is not null) or specialNumber is null )";
            }
        }
        for (int i = 0; i < strs.length; ++i) {
            BgItemInfo item = null;
            try {
                item = iItem.getBgItemInfo(sql.replaceAll("@1", strs[i]).replaceAll("@2", queryStr));
            }
            catch (Exception e) {
                return null;
            }
            name = name + item.getName() + "_";
            spNumber = spNumber + (item.getSpecialNumber() == null ? "" : item.getSpecialNumber() + "_");
        }
        name = name.substring(0, name.length() - 1);
        String string = spNumber = spNumber.equals("") ? "" : spNumber.substring(0, spNumber.length() - 1);
        if (queryField == 2 && !queryStr.equals("") && spNumber.trim().equals("")) {
            return null;
        }
        result[0] = name;
        result[1] = spNumber;
        result[2] = new BigDecimal("0.00");
        result[3] = new BigDecimal("0.00");
        result[4] = new BigDecimal("0.00");
        String sql1 = " select sum(a.fbgvalue) bgValue  from t_bg_bgdata a ,t_bg_bgform b ,t_bg_bgperiod c ,t_bg_bgitemcombination d ,t_bg_bgelement e ,t_bg_bgscheme f where a.fbgformid = b.fid and b.fstate=2 and b.fbgperiodid = c.fid and c.fperiodtype=1 and c.fyear = " + year + " and a.fbgelementid = e.fid and e.fnumber = '" + eleNumber + "'  and b.fbgschemeid = f.fid and f.fFormallyYearScheme = 1  and a.fbgitemcombinid=d.fid and d.fkey = '" + combinNumber + "' and a.forgunitid = '" + orgUnitId + "' and a.fbgvalue is not null";
        ISQLExecutor query1 = SQLExecutorFactory.getRemoteInstance((String)sql1);
        IRowSet rs1 = query1.executeSQL();
        BigDecimal currentYearBudget = new BigDecimal("0.00");
        if (rs1.next()) {
            BigDecimal bigDecimal = currentYearBudget = rs1.getBigDecimal(1) == null ? new BigDecimal("0.00") : rs1.getBigDecimal(1);
        }
        if (spNumber != null && !spNumber.equals("")) {
            String sql2;
            sql1 = " select sum(a.fbgvalue) bgValue  from t_bg_bgdata a ,t_bg_bgform b ,t_bg_bgperiod c ,t_bg_bgitemcombination d ,t_bg_bgelement e ,t_bg_bgscheme f where a.fbgformid = b.fid and b.fstate=2 and b.fbgperiodid = c.fid and c.fperiodtype=1 and c.fyear <= " + year + " and a.fbgelementid = e.fid and e.fnumber =  '" + eleNumber + "' and b.fbgschemeid = f.fid and f.fFormallyYearScheme = 1  and a.fbgitemcombinid=d.fid and d.fkey = '" + combinNumber + "' and a.forgunitid = '" + orgUnitId + "' and a.fbgvalue is not null";
            ISQLExecutor query = SQLExecutorFactory.getRemoteInstance((String)sql1);
            IRowSet rs = query.executeSQL();
            if (rs.next()) {
                Object object = result[2] = rs.getBigDecimal(1) == null ? new BigDecimal("0.00") : rs.getBigDecimal(1);
            }
            if ((rs = (query = SQLExecutorFactory.getRemoteInstance((String)(sql2 = " select sum(a.fbizactual) bgActual from t_bg_bgdata a ,t_bg_bgform b ,t_bg_bgperiod c ,t_bg_bgitemcombination d ,t_bg_bgelement e where a.fbgformid = b.fid and b.fstate=2 and b.fbgperiodid = c.fid and c.fperiodtype=4 and c.fyear*100+c.fmonth<=" + (100 * year + month) + " and a.fbgelementid = e.fid and e.fnumber = '" + eleNumber + "'  and a.fbgitemcombinid=d.fid and d.fkey = '" + combinNumber + "' and a.forgunitid = '" + orgUnitId + "' and a.fbizactual is not null "))).executeSQL()).next()) {
                result[3] = rs.getBigDecimal(1) == null ? new BigDecimal("0.00") : rs.getBigDecimal(1);
            }
            result[4] = currentYearBudget;
        } else {
            result[2] = currentYearBudget;
            String sql2 = " select sum(a.fbizactual) bgActual from t_bg_bgdata a ,t_bg_bgform b ,t_bg_bgperiod c ,t_bg_bgitemcombination d ,t_bg_bgelement e where a.fbgformid = b.fid and b.fstate=2 and b.fbgperiodid = c.fid  and a.fbgperiodid = c.fid and c.fperiodtype=4 and c.fyear = " + year + " and c.fmonth <= " + month + " and a.fbgelementid = e.fid and e.fnumber = '" + eleNumber + "'  and a.fbgitemcombinid=d.fid and d.fkey = '" + combinNumber + "' and a.forgunitid = '" + orgUnitId + "' and a.fbizactual is not null ";
            ISQLExecutor query = SQLExecutorFactory.getRemoteInstance((String)sql2);
            IRowSet rs = query.executeSQL();
            if (rs.next()) {
                result[3] = rs.getBigDecimal(1) == null ? new BigDecimal("0.00") : rs.getBigDecimal(1);
            }
            result[4] = currentYearBudget;
        }
        return result;
    }

    @Override
    protected void table_tableClicked(KDTMouseEvent e) throws Exception {
        super.table_tableClicked(e);
        if (e.getClickCount() == 2) {
            this.onBtnConfirm();
        }
    }

    private void onBtnConfirm() {
        int rowIndex = this.table.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            return;
        }
        IRow iRow = this.table.getRow(rowIndex);
        this.result = new BgCombinItemFDObject((Object[])iRow.getUserObject());
        if (this.isMulti) {
            this.results.add(this.result);
        }
        this.isCancel = false;
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        if (this.isMulti) {
            KDTRange range = this.table.getSelectManager().toRange();
            for (int i = range.size() - 1; i >= 0; --i) {
                KDTSelectBlock block = (KDTSelectBlock)range.get(i);
                for (int j = block.getEndRow(); j >= block.getBeginRow(); --j) {
                    IRow iRow = this.table.getRow(j);
                    BgCombinItemFDObject tmp = new BgCombinItemFDObject((Object[])iRow.getUserObject());
                    this.results.add(tmp);
                }
                if (this.results == null) continue;
                this.isCancel = false;
                this.getUIWindow().close();
            }
        } else {
            int currRow = this.table.getSelectManager().getActiveRowIndex();
            if (currRow != -1) {
                IRow iRow = this.table.getRow(currRow);
                this.result = new BgCombinItemFDObject((Object[])iRow.getUserObject());
            }
            if (this.result != null) {
                this.isCancel = false;
                this.getUIWindow().close();
            }
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public Object getResult() {
        if (this.isMulti) {
            return this.results;
        }
        return this.result;
    }
}

