/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.excel.impl.ToolBarManager;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.eas.ma.budget.analysiscolumn.util.BgFormulaHelper;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BgCompareAndAnalysisFormProcessUI
extends BgNFormProcessUI {
    private static final long serialVersionUID = -626552328003284256L;
    private KDWorkButton btnConfirm = new KDWorkButton();
    protected static Map analysisColIndexMap = new HashMap();
    private List listSheetIdHasActived = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        this.clearCache();
        this.initMyToolBar();
        this.addBookChangeListener();
        this.initForFisrtAccess();
    }

    protected void onSheetActive(Sheet sheet) {
        String id = sheet.getID();
        if (!this.listSheetIdHasActived.contains(id)) {
            this.listSheetIdHasActived.add(id);
        }
        super.onSheetActive(sheet);
    }

    private void initForFisrtAccess() {
        Sheet sheet = this.getBook().getActiveSheet();
        this.fillAnalysisColMap(sheet);
    }

    private void fillAnalysisColMap(Sheet sheet) {
        String sheetID = sheet.getID();
        String sheetName = sheet.getSheetName();
        String id = this.specialID(sheetName, sheetID);
        Set set = analysisColIndexMap.keySet();
        if (!set.contains(id)) {
            analysisColIndexMap.put(id, new ArrayList());
        }
    }

    protected String specialID(String sheetName, String sheetID) {
        return sheetID + "&" + sheetName;
    }

    private void addBookChangeListener() {
        this.getBook().addBookChangeListener(new BookChangeListener(){

            public void changed(BookChangeEvent e) {
                BgCompareAndAnalysisFormProcessUI.this.getSpreadManager().getSpreadContainer().getSpread().scrollCellVisible(0, 0);
                Sheet sheet = e.getSheet();
                BgCompareAndAnalysisFormProcessUI.this.fillAnalysisColMap(sheet);
            }
        });
    }

    protected boolean isAnalysisCol(Sheet sheet, int columnIndex) {
        int rowCount = sheet.getMaxRowIndex() + 1;
        boolean returnFlag = false;
        for (int i = 0; i < rowCount; ++i) {
            Cell cell = sheet.getCell(i, columnIndex, false);
            String bgItem = BgNFSHelper.getFormulaOfCell((Cell)cell);
            String bgFormula = BgNFSHelper.getExpression((Cell)cell);
            if (bgItem != null && !"".equals(bgItem)) {
                returnFlag = true;
                break;
            }
            if (bgFormula == null || bgFormula.equals("") || !BgFormulaHelper.isSingleBgFormula(bgFormula)) continue;
            returnFlag = true;
            break;
        }
        return returnFlag;
    }

    private void initMyToolBar() {
        ToolBarManager toolBarManager = this.getSpreadManager().getSpreadContainer().getToolBarManager();
        toolBarManager.getToolBar("style").setVisible(false);
        this.btnConfirm.setName("btnConfirm");
        this.btnConfirm.setEnabled(true);
        this.btnConfirm.setVisible(true);
        this.btnConfirm.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"174_BgCompareAndAnalysisFormForTitleProcessUI"));
        this.btnConfirm.setToolTipText(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"174_BgCompareAndAnalysisFormForTitleProcessUI"));
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgCompareAndAnalysisFormProcessUI.this.btnConfirm_actionPerformed();
            }
        });
        toolBarManager.getToolBar("common").add((Component)this.btnConfirm);
        int number = toolBarManager.getToolBar("common").getComponentCount();
        for (int i = number - 1; i >= 1; --i) {
            Component c = toolBarManager.getToolBar("common").getComponent(i);
            if (c instanceof KDWorkButton) {
                KDWorkButton btn = (KDWorkButton)c;
                if (btn.getName() != null && "btnConfirm".equals(btn.getName().trim())) continue;
                toolBarManager.getToolBar("common").remove(c);
                continue;
            }
            toolBarManager.getToolBar("common").remove(c);
        }
    }

    private void btnConfirm_actionPerformed() {
        this.confirm();
        super.destroyWindow();
    }

    protected void confirm() {
        Book book = this.getBook();
        HashMap temMap = new HashMap();
        if (analysisColIndexMap != null && !analysisColIndexMap.isEmpty()) {
            temMap.putAll(analysisColIndexMap);
        }
        Set set = analysisColIndexMap.keySet();
        boolean isSelectCol = false;
        int num = book.getSheetCount();
        for (int i = 0; i < num; ++i) {
            String id;
            Sheet currentSheet = book.getSheet(i);
            if (!this.listSheetIdHasActived.contains(currentSheet.getID()) || !set.contains(id = this.specialID(currentSheet.getSheetName(), currentSheet.getID()))) continue;
            ArrayList<Integer> list = new ArrayList<Integer>();
            Range range = currentSheet.getSelectionRange();
            for (int j = range.size() - 1; j >= 0; --j) {
                CellBlock block = (CellBlock)range.getAt(j);
                if (!block.isCol()) continue;
                if (!isSelectCol) {
                    isSelectCol = true;
                }
                for (int k = block.getCol2(); k >= block.getCol(); --k) {
                    if (!this.isAnalysisCol(currentSheet, k)) continue;
                    list.add(new Integer(k));
                }
            }
            if (list.size() != 0) {
                analysisColIndexMap.put(id, list);
                continue;
            }
            analysisColIndexMap.remove(id);
        }
        if (!isSelectCol) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"selectFullRow"));
            analysisColIndexMap.clear();
            analysisColIndexMap.putAll(temMap);
            SysUtil.abort();
        }
    }

    public static Map getAnalysisColIndexMap() {
        return analysisColIndexMap;
    }

    static void setAnalysisColIndexMap(Map map) {
        analysisColIndexMap = map;
    }

    protected void clearCache() {
        analysisColIndexMap.clear();
    }

    public boolean destroyWindow() {
        return super.destroyWindow();
    }

    public void onShow() {
        super.onShow();
        Range selectRange = this.getSpreadManager().getSpreadContainer().getSpread().getBook().getSheet(0).getRange(0, 0);
        selectRange.select();
        this.getSpreadManager().getSpreadContainer().getSpread().scrollCellVisible(0, 0);
    }
}

