/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgCompareOneFilterParam;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgRptFacade;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgCompareOneFilter2UI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCompareOneFilter2UI
extends AbstractBgCompareOneFilter2UI {
    private static final Logger logger = CoreUIObject.getLogger(BgCompareOneFilter2UI.class);
    private BgCompareOneFilterParam compareFilterParam;
    private boolean isLoaded = false;
    private BgPeriodDialog beginF7;
    private BgPeriodDialog endF7;
    private BgSchemeInfo bgSchemeInfo;
    private boolean isUnUsed = false;
    private Map bgTemplateMap = new HashMap();

    public BgCompareOneFilter2UI() throws Exception {
    }

    public BgCompareOneFilter2UI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.contBgRptType.setVisible(true);
        this.chkIsSum.setVisible(true);
        this.isLoaded = true;
        this.prmtBeginPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
    }

    @Override
    public void init() throws Exception {
        this.isLoadQuery = false;
        this.comboBgRptType.removeAllItems();
        this.comboBgRptType.addItem((Object)BgAnalysisTypeEnum.BGCOMPARE);
        this.comboBgRptType.addItem((Object)BgAnalysisTypeEnum.BGMULTICOMPARE);
        this.comboBgRptType.setEnabled(true);
        if (this.bgAnalyType != null) {
            BgClientHelper.setSelectObject(this.comboBgRptType, (Object)this.bgAnalyType);
            this.bgAnalyType = null;
        }
        this.lblBgScheme.setVisible(true);
        this.contBgScheme.setVisible(false);
        BgAnalysisTypeEnum type = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
        if (type != null) {
            if (type.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
                this.lblBgScheme.setVisible(true);
                this.contBgScheme.setVisible(false);
                this.chkIsSum.setEnabled(true);
            } else if (type.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
                this.lblBgScheme.setVisible(false);
                this.contBgScheme.setVisible(true);
                this.chkIsSum.setEnabled(false);
            }
        }
        this.prmtBgScheme.setHasCUDefaultFilter(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(viewInfo);
        this.isLoadQuery = true;
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.compareFilterParam == null) {
            this.compareFilterParam = new BgCompareOneFilterParam();
        }
        return this.compareFilterParam;
    }

    @Override
    protected void initScheme() {
        String orgUnitId = this.currentCompany.getId().toString();
        IBgScheme iBgScheme = null;
        try {
            iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (iBgScheme != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
            if (BgParamCHelper.isFodian()) {
                items.add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                items.add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString(" #0 and #1");
            view.setFilter(filter);
            BgSchemeCollection col = null;
            try {
                col = iBgScheme.getBgSchemeCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            BgHelper.sortCollection(col, new String[]{"number"});
            if (col != null && col.size() > 0) {
                this.comboBgScheme.removeAllItems();
                this.comboBgScheme.addItems(col.toArray());
                this.comboBgScheme.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected void comboBgRptType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgRptType_itemStateChanged(e);
        if (!this.isLoadQuery) {
            return;
        }
        BgAnalysisTypeEnum bgRptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
        if (bgRptType == null) {
            bgRptType = BgAnalysisTypeEnum.BGCOMPARE;
        }
        if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
            this.lblBgScheme.setVisible(true);
            this.contBgScheme.setVisible(false);
            this.comboBgTemplate.setSelectedItem(null);
            this.comboBgPeriod.setSelectedItem(null);
            this.prmtOrgUnit.setData((Object)this.curOrgUnitinfo);
            BgClientHelper.initComboBgScheme((Component)((Object)this), this.comboBgScheme, this.currentCompany.getId().toString());
            this.setBgTemplateSelect();
            this.prmtBeginPeriod.setValue(null);
            this.prmtEndPeriod.setValue(null);
            this.chkIsSum.setSelected(false);
            this.chkIsSum.setEnabled(true);
        } else if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            this.lblBgScheme.setVisible(false);
            this.contBgScheme.setVisible(true);
            Object[] org = new Object[]{this.curOrgUnitinfo};
            this.prmtOrgUnit.setData((Object)org);
            this.comboBgTemplate.setSelectedItem(null);
            this.comboBgPeriod.setSelectedItem(null);
            this.prmtBeginPeriod.setValue(null);
            this.prmtEndPeriod.setValue(null);
            this.chkIsSum.setSelected(false);
            this.chkIsSum.setEnabled(false);
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isLoadQuery) {
            return;
        }
        this.isUnUsed = false;
        if (this.isLoaded) {
            BgAnalysisTypeEnum bgRptType = null;
            bgRptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
            if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
                super.prmtOrgUnit_dataChanged(e);
            }
            if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
                this.isUnUsed = true;
                this.prmtBgScheme.setValue(null);
                this.isUnUsed = false;
                this.comboBgTemplate.setSelectedItem(null);
                this.comboBgPeriod.setSelectedItem(null);
                this.prmtBeginPeriod.setValue(null);
                this.prmtEndPeriod.setValue(null);
                this.chkIsSum.setSelected(false);
                Object obj = this.prmtOrgUnit.getValue();
                if (obj == null) {
                    return;
                }
                if (obj instanceof Object[]) {
                    Object[] objs = (Object[])obj;
                    if (objs[0] == null) {
                        return;
                    }
                    if (objs.length > 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareOrgMsg"));
                        this.prmtOrgUnit.setValue(null);
                        SysUtil.abort();
                    }
                }
                CostCenterOrgUnitInfo orgInfo = null;
                if (obj instanceof CostCenterOrgUnitInfo) {
                    orgInfo = (CostCenterOrgUnitInfo)obj;
                    this.setCompanyIds(new String[]{orgInfo.getId().toString()});
                } else {
                    Object[] oarr = (Object[])obj;
                    if (oarr.length > 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareOrgMsg"));
                        this.prmtOrgUnit.setValue(null);
                        SysUtil.abort();
                    } else {
                        orgInfo = (CostCenterOrgUnitInfo)oarr[0];
                        this.setCompanyIds(new String[]{orgInfo.getId().toString()});
                        Vector<CostCenterOrgUnitInfo> companyVec = new Vector<CostCenterOrgUnitInfo>();
                        companyVec.add(orgInfo);
                        this.setOrgUnitVec(companyVec);
                    }
                }
                if (orgInfo != null && orgInfo.getId() != null) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgInfo.getId().toString()));
                    viewInfo.setFilter(filter);
                    this.prmtBgScheme.setEntityViewInfo(viewInfo);
                }
            }
        } else {
            super.prmtOrgUnit_dataChanged(e);
        }
    }

    @Override
    public boolean verify() {
        BgAnalysisTypeEnum bgRptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        VisualItemInfo vi1 = (VisualItemInfo)this.prmtItemTo.getValue();
        if (vi == null && vi1 != null || vi1 != null || vi != null) {
            // empty if block
        }
        if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
            if (this.prmtOrgUnit.getValue() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectUnit"));
                return false;
            }
            return super.verify();
        }
        if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Object obj = this.prmtOrgUnit.getValue();
            if (this.getCompanyIds() == null || this.getCompanyIds().length < 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectUnit"));
                return false;
            }
            if (this.getCompanyIds().length > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareOrgMsg"));
                return false;
            }
            if (this.comboBgTemplate.getSelectedItem() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgTemplate"));
                return false;
            }
            Object multiBgScheme = this.prmtBgScheme.getData();
            if (multiBgScheme == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgScheme"));
                return false;
            }
            if (multiBgScheme instanceof Object[]) {
                Object[] multiBgSchemeArray = (Object[])multiBgScheme;
                if (multiBgSchemeArray.length < 2) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
                    return false;
                }
                if (multiBgSchemeArray[0] == null || multiBgSchemeArray[1] == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgScheme"));
                    return false;
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
                return false;
            }
            if (this.prmtOrgUnit.getData() != null && this.comboBgTemplate.getSelectedItem() != null) {
                Object[] objs = null;
                if (obj instanceof Object[]) {
                    objs = (Object[])obj;
                    String orgId = ((OrgUnitInfo)objs[0]).getId().toString();
                    String bgTemRootId = ((BgTemplateInfo)this.comboBgTemplate.getSelectedItem()).getRootId().toString();
                    Object[] schemes = (Object[])multiBgScheme;
                    String schemeRootId1 = ((BgSchemeInfo)schemes[0]).getRootId().toString();
                    String schemeRootId2 = ((BgSchemeInfo)schemes[1]).getRootId().toString();
                    try {
                        boolean hasformTwo;
                        IBgRptFacade iBgRptFacade = BgRptFacadeFactory.getRemoteInstance();
                        boolean hasformOne = iBgRptFacade.bgschemehasform(orgId, schemeRootId1, bgTemRootId);
                        if (!hasformOne) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"schemenoform"));
                            SysUtil.abort();
                        }
                        if (!(hasformTwo = iBgRptFacade.bgschemehasform(orgId, schemeRootId2, bgTemRootId))) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAnalyseResource", (String)"schemenoform"));
                            SysUtil.abort();
                        }
                    }
                    catch (BOSException e) {
                        this.handUIException(e);
                    }
                    catch (EASBizException e) {
                        this.handUIException(e);
                    }
                }
            }
            BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, this.prmtBeginPeriod, this.prmtEndPeriod);
            this.retBeginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            this.retEndPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            BgSchemeInfo schemeInfo = (BgSchemeInfo)((Object[])this.prmtBgScheme.getData())[0];
            BgPeriodEnum periodType = (BgPeriodEnum)((Object)this.comboBgPeriod.getSelectedItem());
            BgPeriodInfo beginPeriod = this.retBeginPeriod;
            BgPeriodInfo endPeriod = this.retEndPeriod;
            try {
                BgPeriodCollection periodColl = this.getAccumPeriodColl(periodType.getValue(), BgHelper.getDayBegin(schemeInfo.getDateFrom()), BgHelper.getDayEnd(schemeInfo.getDateTo()));
                if (periodColl == null || periodColl != null && periodColl.size() < 1) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"BgSchemeBgPeriodMsg"));
                    return false;
                }
                boolean beginBln1 = BgHelper.compareBgPeriodBegin2End(periodColl.get(0), beginPeriod);
                boolean beginBln2 = BgHelper.compareBgPeriodBegin2End(beginPeriod, periodColl.get(periodColl.size() - 1));
                boolean beginBln3 = BgHelper.compareBgPeriodBegin2End(beginPeriod, periodColl.get(0));
                boolean endBln1 = BgHelper.compareBgPeriodBegin2End(periodColl.get(0), endPeriod);
                boolean endBln2 = BgHelper.compareBgPeriodBegin2End(endPeriod, periodColl.get(periodColl.size() - 1));
                boolean endBln3 = BgHelper.compareBgPeriodBegin2End(periodColl.get(periodColl.size() - 1), endPeriod);
                if (beginBln1 && beginBln2 || endBln1 && endBln2 || beginBln3 && endBln3) {
                    this.retBeginPeriod = beginBln1 ? beginPeriod : periodColl.get(0);
                    this.retEndPeriod = endBln2 ? endPeriod : periodColl.get(periodColl.size() - 1);
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"BgPeriodBgSchemeMsg"));
                    return false;
                }
                this.periodIds = new String[periodColl.size()];
                for (int i = 0; i < periodColl.size(); ++i) {
                    this.periodIds[i] = periodColl.get(i).getId().toString();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return true;
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (!this.isLoadQuery) {
            return;
        }
        if (this.isUnUsed) {
            this.isUnUsed = false;
            return;
        }
        Object multiBgScheme = this.prmtBgScheme.getData();
        if (multiBgScheme == null) {
            return;
        }
        Object[] multiBgSchemeArray = null;
        if (multiBgScheme instanceof Object[]) {
            multiBgSchemeArray = (Object[])multiBgScheme;
            if (multiBgSchemeArray.length != 2) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
                this.prmtBgScheme.setValue(null);
                SysUtil.abort();
            }
            if (multiBgSchemeArray[0] == null || multiBgSchemeArray[1] == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgScheme"));
                this.prmtBgScheme.setValue(null);
                SysUtil.abort();
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
            this.prmtBgScheme.setValue(null);
            SysUtil.abort();
        }
        this.comboBgTemplate.removeAllItems();
        if (multiBgSchemeArray != null) {
            BgSchemeInfo bgSchemeInfoOne = (BgSchemeInfo)multiBgSchemeArray[0];
            BgTemplateCollection bgTemplateCollOne = BgHelper.getBgTemplateCollByScheme(bgSchemeInfoOne.getId().toString());
            BgSchemeInfo bgSchemeInfoTwo = (BgSchemeInfo)multiBgSchemeArray[1];
            BgTemplateCollection bgTemplateCollTwo = BgHelper.getBgTemplateCollByScheme(bgSchemeInfoTwo.getId().toString());
            Map bgTemTwoMap = BgHelper.tranColl2Map((IObjectCollection)bgTemplateCollTwo, new String[]{"rootId"});
            BgTemplateCollection bgTemplateColl = new BgTemplateCollection();
            for (int i = 0; i < bgTemplateCollOne.size(); ++i) {
                BgTemplateInfo bgTemOneInfo = bgTemplateCollOne.get(i);
                if (!bgTemTwoMap.containsKey(bgTemOneInfo.getRootId().toString())) continue;
                if (this.bgTemplateMap == null) {
                    this.bgTemplateMap = new HashMap();
                }
                bgTemplateColl.add(bgTemOneInfo);
                this.bgTemplateMap.put(bgTemOneInfo.getId().toString(), new String[]{bgTemOneInfo.getId().toString(), ((IObjectValue)bgTemTwoMap.get(bgTemOneInfo.getRootId().toString())).getString("id")});
            }
            this.bgSchemeInfo = this.getBgSchemeByGreatType(bgSchemeInfoOne, bgSchemeInfoTwo);
            if (this.bgSchemeInfo != null && this.bgSchemeInfo.getId() != null) {
                this.comboBgPeriod.setSelectedItem((Object)this.bgSchemeInfo.getPeriod());
                this.comboBgPeriod.setEnabled(false);
                if (this.beginF7 == null) {
                    this.beginF7 = new BgPeriodDialog((CoreUIObject)this);
                }
                this.beginF7.setBgPeriodEnum(this.bgSchemeInfo.getPeriod());
                this.prmtBeginPeriod.setSelector((KDPromptSelector)this.beginF7);
                if (this.endF7 == null) {
                    this.endF7 = new BgPeriodDialog((CoreUIObject)this);
                }
                this.endF7.setBgPeriodEnum(this.bgSchemeInfo.getPeriod());
                this.prmtEndPeriod.setSelector((KDPromptSelector)this.endF7);
                this.comboBgTemplate.addItems(bgTemplateColl.toArray());
            }
        }
    }

    private BgSchemeInfo getBgSchemeByGreatType(BgSchemeInfo bgSchemeInfoOne, BgSchemeInfo bgSchemeInfoTwo) {
        if (bgSchemeInfoOne.getPeriod().getValue() <= bgSchemeInfoTwo.getPeriod().getValue()) {
            return bgSchemeInfoOne;
        }
        return bgSchemeInfoTwo;
    }

    @Override
    public Object getParam() {
        String stritem;
        BgCompareOneFilterParam param = (BgCompareOneFilterParam)super.getParam();
        if (((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem())).equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Object[] multiBgSchemeArray = (Object[])this.prmtBgScheme.getData();
            HashMap<String, String> multiBgSchemeMap = new HashMap<String, String>();
            BgSchemeInfo bgSchemeOne = (BgSchemeInfo)multiBgSchemeArray[0];
            BgSchemeInfo bgSchemeTwo = (BgSchemeInfo)multiBgSchemeArray[1];
            Vector<BgSchemeInfo> multiBgSchemeVec = new Vector<BgSchemeInfo>();
            multiBgSchemeVec.add(bgSchemeOne);
            multiBgSchemeVec.add(bgSchemeTwo);
            param.setMultiBgSchemeVec(multiBgSchemeVec);
            multiBgSchemeMap.put(bgSchemeOne.getId().toString(), bgSchemeOne.getName());
            multiBgSchemeMap.put(bgSchemeTwo.getId().toString(), bgSchemeTwo.getName());
            param.setMultiBgSchemeMap(multiBgSchemeMap);
            param.setBgSchemeId(this.bgSchemeInfo.getId().toString());
            if (this.bgTemplateMap != null && this.bgTemplateMap.size() > 0) {
                param.setBgTemplateIds((String[])this.bgTemplateMap.get(((BgTemplateInfo)this.comboBgTemplate.getSelectedItem()).getId().toString()));
            }
        }
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        param.objItemFrom = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemFrom(stritem);
        } else {
            param.setItemFrom(null);
        }
        vi = (VisualItemInfo)this.prmtItemTo.getValue();
        param.objItemTo = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemTo(stritem);
        } else {
            param.setItemTo(null);
        }
        BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
        param.objElement = beinfo;
        if (beinfo != null) {
            String stritem2 = beinfo.getId().toString();
            param.setElement(stritem2);
        } else {
            param.setElement(null);
        }
        if (this.prmtCurrency.getValue() != null) {
            param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            try {
                param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
            }
            catch (Exception e) {
                param.setCurrency(null);
            }
        }
        if (((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem())).equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            param.setBgRptType(BgAnalysisTypeEnum.BGMULTICOMPARE);
        } else {
            param.setBgRptType(BgAnalysisTypeEnum.BGCOMPARE);
        }
        return param;
    }

    @Override
    public CustomerParams getCustomerParams() {
        String stritem;
        CustomerParams cp = super.getCustomerParams();
        BgCompareOneFilterParam param = (BgCompareOneFilterParam)this.getFilterObject(cp);
        if (((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem())).equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Object[] multiBgSchemeArray = (Object[])this.prmtBgScheme.getData();
            HashMap<String, String> multiBgSchemeMap = new HashMap<String, String>();
            BgSchemeInfo bgSchemeOne = (BgSchemeInfo)multiBgSchemeArray[0];
            BgSchemeInfo bgSchemeTwo = (BgSchemeInfo)multiBgSchemeArray[1];
            Vector<BgSchemeInfo> multiBgSchemeVec = new Vector<BgSchemeInfo>();
            multiBgSchemeVec.add(bgSchemeOne);
            multiBgSchemeVec.add(bgSchemeTwo);
            param.setMultiBgSchemeVec(multiBgSchemeVec);
            multiBgSchemeMap.put(bgSchemeOne.getId().toString(), bgSchemeOne.getName());
            multiBgSchemeMap.put(bgSchemeTwo.getId().toString(), bgSchemeTwo.getName());
            param.setMultiBgSchemeMap(multiBgSchemeMap);
            param.setBgSchemeId(this.bgSchemeInfo.getId().toString());
            if (this.bgTemplateMap != null && this.bgTemplateMap.size() > 0) {
                param.setBgTemplateIds((String[])this.bgTemplateMap.get(((BgTemplateInfo)this.comboBgTemplate.getSelectedItem()).getId().toString()));
            }
        }
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        param.objItemFrom = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemFrom(stritem);
        } else {
            param.setItemFrom(null);
        }
        vi = (VisualItemInfo)this.prmtItemTo.getValue();
        param.objItemTo = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemTo(stritem);
        } else {
            param.setItemTo(null);
        }
        BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
        param.objElement = beinfo;
        if (beinfo != null) {
            String stritem2 = beinfo.getId().toString();
            param.setElement(stritem2);
        } else {
            param.setElement(null);
        }
        if (this.prmtCurrency.getValue() != null) {
            param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            try {
                param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
            }
            catch (Exception e) {
                param.setCurrency(null);
            }
        }
        if (((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem())).equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            param.setBgRptType(BgAnalysisTypeEnum.BGMULTICOMPARE);
        } else {
            param.setBgRptType(BgAnalysisTypeEnum.BGCOMPARE);
        }
        this.setFilterObject(cp, param);
        return cp;
    }

    public void setParam(Object param) {
        if (param == null || !(param instanceof BgRptFilterParam)) {
            return;
        }
        BgRptFilterParam filterParam = (BgRptFilterParam)param;
        this.isLoadQuery = false;
        this.bgAnalyType = filterParam.getBgRptType();
        this.prmtOrgUnit.setValue((Object)filterParam.getOrgUnitVec().toArray());
        this.isLoadQuery = true;
        try {
            this.prmtOrgUnit_dataChanged(null);
            this.isLoadQuery = false;
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String bgSchemeId = filterParam.getBgSchemeId();
        this.isLoadQuery = false;
        if (this.bgAnalyType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            this.prmtBgScheme.setValue((Object)filterParam.getMultiBgSchemeVec().toArray());
            this.isLoadQuery = true;
            try {
                this.prmtBgScheme_dataChanged(null);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            for (int i = 0; i < this.comboBgScheme.getItemCount(); ++i) {
                if (!bgSchemeId.equals(((BgSchemeInfo)this.comboBgScheme.getItemAt(i)).getId().toString())) continue;
                this.comboBgScheme.setSelectedIndex(i);
                try {
                    this.setBgTemplateSelect();
                }
                catch (EASBizException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                break;
            }
        }
        this.isLoadQuery = true;
        this.comboBgPeriod.setSelectedItem((Object)BgPeriodEnum.getEnum(filterParam.getBgPeriodType()));
        String bgTemplateId = filterParam.getBgTemplate().keySet().toArray()[0].toString();
        this.isLoadQuery = false;
        for (int i = 0; i < this.comboBgTemplate.getItemCount(); ++i) {
            if (!bgTemplateId.equals(((BgTemplateInfo)this.comboBgTemplate.getItemAt(i)).getId().toString())) continue;
            this.comboBgTemplate.setSelectedIndex(i);
            break;
        }
        this.isLoadQuery = false;
        this.chkIsSum.setSelected(filterParam.isIsSum());
        this.prmtBeginPeriod.setValue(filterParam.getBgPeriodMap().get("BeginBgPeriod"));
        this.prmtEndPeriod.setValue(filterParam.getBgPeriodMap().get("EndBgPeriod"));
        this.isLoadBgBalance = false;
        filterParam = (BgCompareOneFilterParam)param;
        this.prmtItemFrom.setValue(((BgCompareOneFilterParam)filterParam).objItemFrom);
        this.prmtItemTo.setValue(((BgCompareOneFilterParam)filterParam).objItemTo);
        this.prmtElement.setValue(((BgCompareOneFilterParam)filterParam).objElement);
        this.prmtCurrency.setValue((Object)((BgCompareOneFilterParam)filterParam).getCurrency());
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        FilterParam param = (FilterParam)this.getFilterObject(cp);
        if (param == null || !(param instanceof BgRptFilterParam)) {
            return;
        }
        BgRptFilterParam filterParam = (BgRptFilterParam)param;
        this.isLoadQuery = false;
        this.bgAnalyType = filterParam.getBgRptType();
        this.comboBgRptType.setSelectedItem((Object)this.bgAnalyType);
        this.isLoadQuery = true;
        try {
            this.comboBgRptType_itemStateChanged(null);
            this.prmtOrgUnit.setValue((Object)filterParam.getOrgUnitVec().toArray());
            this.prmtOrgUnit_dataChanged(null);
            this.isLoadQuery = false;
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String bgSchemeId = filterParam.getBgSchemeId();
        this.isLoadQuery = false;
        if (this.bgAnalyType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            this.prmtBgScheme.setValue((Object)filterParam.getMultiBgSchemeVec().toArray());
            this.isLoadQuery = true;
            try {
                this.prmtBgScheme_dataChanged(null);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            for (int i = 0; i < this.comboBgScheme.getItemCount(); ++i) {
                if (!bgSchemeId.equals(((BgSchemeInfo)this.comboBgScheme.getItemAt(i)).getId().toString())) continue;
                this.comboBgScheme.setSelectedIndex(i);
                try {
                    this.setBgTemplateSelect();
                }
                catch (EASBizException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                break;
            }
        }
        this.isLoadQuery = true;
        this.comboBgPeriod.setSelectedItem((Object)BgPeriodEnum.getEnum(filterParam.getBgPeriodType()));
        String bgTemplateId = filterParam.getBgTemplate().keySet().toArray()[0].toString();
        this.isLoadQuery = false;
        for (int i = 0; i < this.comboBgTemplate.getItemCount(); ++i) {
            if (!bgTemplateId.equals(((BgTemplateInfo)this.comboBgTemplate.getItemAt(i)).getId().toString())) continue;
            this.comboBgTemplate.setSelectedIndex(i);
            break;
        }
        this.isLoadQuery = false;
        this.chkIsSum.setSelected(filterParam.isIsSum());
        this.prmtBeginPeriod.setValue(filterParam.getBgPeriodMap().get("BeginBgPeriod"));
        this.prmtEndPeriod.setValue(filterParam.getBgPeriodMap().get("EndBgPeriod"));
        this.isLoadBgBalance = false;
        filterParam = (BgCompareOneFilterParam)param;
        this.prmtItemFrom.setValue(((BgCompareOneFilterParam)filterParam).objItemFrom);
        this.prmtItemTo.setValue(((BgCompareOneFilterParam)filterParam).objItemTo);
        this.prmtElement.setValue(((BgCompareOneFilterParam)filterParam).objElement);
        this.prmtCurrency.setValue((Object)((BgCompareOneFilterParam)filterParam).getCurrency());
        this.isLoadQuery = true;
    }

    @Override
    protected void comboBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgScheme_itemStateChanged(e);
    }

    @Override
    public void clear() {
        super.clear();
        this.comboBgRptType.setSelectedItem((Object)BgAnalysisTypeEnum.BGCOMPARE);
        try {
            this.comboBgRptType_itemStateChanged(null);
        }
        catch (Exception e1) {
            logger.error((Object)"budget error:", (Throwable)e1);
        }
    }
}

