/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgCompareOneFilterParam;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgCompareOneFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgCompareOneFilterUI
extends AbstractBgCompareOneFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgCompareOneFilterUI.class);
    private BgCompareOneFilterParam compareFilterParam;
    private boolean isLoaded = false;
    private BgPeriodDialog beginF7;
    private BgPeriodDialog endF7;
    private BgSchemeInfo bgSchemeInfo;
    private boolean isUnUsed = false;
    private Map bgTemplateMap = new HashMap();

    public BgCompareOneFilterUI() throws Exception {
    }

    public BgCompareOneFilterUI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.isLoaded = true;
    }

    private void init() throws Exception {
        this.isLoadQuery = false;
        this.comboBgPeriod.setEnabled(false);
        this.comboBgRptType.removeAllItems();
        this.comboBgRptType.addItem((Object)BgAnalysisTypeEnum.BGCOMPARE);
        this.comboBgRptType.addItem((Object)BgAnalysisTypeEnum.BGMULTICOMPARE);
        this.comboBgRptType.setEnabled(true);
        if (this.bgAnalyType != null) {
            BgClientHelper.setSelectObject(this.comboBgRptType, (Object)this.bgAnalyType);
            this.bgAnalyType = null;
        }
        this.lblBgScheme.setVisible(true);
        this.contBgScheme.setVisible(false);
        BgAnalysisTypeEnum type = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
        if (type != null) {
            if (type.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
                this.lblBgScheme.setVisible(true);
                this.contBgScheme.setVisible(false);
                this.chkIsSum.setEnabled(true);
            } else if (type.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
                this.lblBgScheme.setVisible(false);
                this.contBgScheme.setVisible(true);
                this.chkIsSum.setEnabled(false);
            }
        }
        this.prmtBgScheme.setHasCUDefaultFilter(false);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.currentCompany.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(viewInfo);
        this.isLoadQuery = true;
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.compareFilterParam == null) {
            this.compareFilterParam = new BgCompareOneFilterParam();
        }
        return this.compareFilterParam;
    }

    @Override
    protected void comboBgRptType_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgRptType_itemStateChanged(e);
        if (!this.isLoadQuery) {
            return;
        }
        if (this.isLoaded) {
            BgAnalysisTypeEnum bgRptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
            if (bgRptType == null) {
                bgRptType = BgAnalysisTypeEnum.BGCOMPARE;
            }
            if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
                this.lblBgScheme.setVisible(true);
                this.contBgScheme.setVisible(false);
                this.comboBgTemplate.setSelectedItem(null);
                this.comboBgPeriod.setSelectedItem(null);
                this.prmtOrgUnit.setData((Object)this.curOrgUnitinfo);
                BgClientHelper.initComboBgScheme((Component)((Object)this), this.comboBgScheme, this.currentCompany.getId().toString());
                this.setBgTemplateSelect();
                this.prmtBeginPeriod.setValue(null);
                this.prmtEndPeriod.setValue(null);
                this.chkIsSum.setSelected(false);
                this.chkIsSum.setEnabled(true);
            } else if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
                this.lblBgScheme.setVisible(false);
                this.contBgScheme.setVisible(true);
                this.prmtOrgUnit.setData(null);
                this.comboBgTemplate.setSelectedItem(null);
                this.comboBgPeriod.setSelectedItem(null);
                this.prmtBeginPeriod.setValue(null);
                this.prmtEndPeriod.setValue(null);
                this.chkIsSum.setSelected(false);
                this.chkIsSum.setEnabled(false);
            }
        }
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.isLoadQuery) {
            return;
        }
        this.isUnUsed = false;
        if (this.isLoaded) {
            BgAnalysisTypeEnum bgRptType = null;
            bgRptType = this.bgAnalyType != null ? this.bgAnalyType : (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
            if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
                super.prmtOrgUnit_dataChanged(e);
            }
            if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
                this.isUnUsed = true;
                this.prmtBgScheme.setValue(null);
                this.isUnUsed = false;
                this.comboBgTemplate.setSelectedItem(null);
                this.comboBgPeriod.setSelectedItem(null);
                this.prmtBeginPeriod.setValue(null);
                this.prmtEndPeriod.setValue(null);
                this.chkIsSum.setSelected(false);
                Object obj = this.prmtOrgUnit.getValue();
                if (obj == null) {
                    return;
                }
                if (obj instanceof Object[]) {
                    Object[] objs = (Object[])obj;
                    if (objs[0] == null) {
                        return;
                    }
                    if (objs.length > 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareOrgMsg"));
                        this.prmtOrgUnit.setValue(null);
                        SysUtil.abort();
                    }
                }
                FullOrgUnitInfo orgInfo = null;
                if (obj instanceof FullOrgUnitInfo) {
                    orgInfo = (FullOrgUnitInfo)obj;
                    this.setCompanyIds(new String[]{orgInfo.getId().toString()});
                } else {
                    Object[] oarr = (Object[])obj;
                    if (oarr.length > 1) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareOrgMsg"));
                        this.prmtOrgUnit.setValue(null);
                        SysUtil.abort();
                    } else {
                        orgInfo = (FullOrgUnitInfo)oarr[0];
                        this.setCompanyIds(new String[]{orgInfo.getId().toString()});
                        Vector<FullOrgUnitInfo> companyVec = new Vector<FullOrgUnitInfo>();
                        companyVec.add(orgInfo);
                        this.setOrgUnitVec(companyVec);
                    }
                }
                if (orgInfo != null && orgInfo.getId() != null) {
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgInfo.getId().toString()));
                    viewInfo.setFilter(filter);
                    this.prmtBgScheme.setEntityViewInfo(viewInfo);
                }
            }
        } else {
            super.prmtOrgUnit_dataChanged(e);
        }
    }

    @Override
    public boolean verify() {
        BgAnalysisTypeEnum bgRptType = (BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem());
        if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGCOMPARE)) {
            return super.verify();
        }
        if (bgRptType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Object obj = this.prmtOrgUnit.getValue();
            if (this.getCompanyIds() == null || this.getCompanyIds().length < 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectUnit"));
                return false;
            }
            if (this.getCompanyIds().length > 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareOrgMsg"));
                return false;
            }
            if (this.comboBgTemplate.getSelectedItem() == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgTemplate"));
                return false;
            }
            Object multiBgScheme = this.prmtBgScheme.getData();
            if (multiBgScheme == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgScheme"));
                return false;
            }
            if (multiBgScheme instanceof Object[]) {
                Object[] multiBgSchemeArray = (Object[])multiBgScheme;
                if (multiBgSchemeArray.length < 2) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
                    return false;
                }
                if (multiBgSchemeArray[0] == null || multiBgSchemeArray[1] == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgScheme"));
                    return false;
                }
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
                return false;
            }
            BgClientHelper.verifyBgPeriodBegin2End((CoreUIObject)this, this.prmtBeginPeriod, this.prmtEndPeriod);
            this.retBeginPeriod = (BgPeriodInfo)this.prmtBeginPeriod.getValue();
            this.retEndPeriod = (BgPeriodInfo)this.prmtEndPeriod.getValue();
            BgSchemeInfo schemeInfo = (BgSchemeInfo)((Object[])this.prmtBgScheme.getData())[0];
            BgPeriodEnum periodType = (BgPeriodEnum)((Object)this.comboBgPeriod.getSelectedItem());
            BgPeriodInfo beginPeriod = this.retBeginPeriod;
            BgPeriodInfo endPeriod = this.retEndPeriod;
            try {
                BgPeriodCollection periodColl = this.getAccumPeriodColl(periodType.getValue(), BgHelper.getDayBegin(schemeInfo.getDateFrom()), BgHelper.getDayEnd(schemeInfo.getDateTo()));
                if (periodColl == null || periodColl != null && periodColl.size() < 1) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"BgSchemeBgPeriodMsg"));
                    return false;
                }
                boolean beginBln1 = BgHelper.compareBgPeriodBegin2End(periodColl.get(0), beginPeriod);
                boolean beginBln2 = BgHelper.compareBgPeriodBegin2End(beginPeriod, periodColl.get(periodColl.size() - 1));
                boolean beginBln3 = BgHelper.compareBgPeriodBegin2End(beginPeriod, periodColl.get(0));
                boolean endBln1 = BgHelper.compareBgPeriodBegin2End(periodColl.get(0), endPeriod);
                boolean endBln2 = BgHelper.compareBgPeriodBegin2End(endPeriod, periodColl.get(periodColl.size() - 1));
                boolean endBln3 = BgHelper.compareBgPeriodBegin2End(periodColl.get(periodColl.size() - 1), endPeriod);
                if (beginBln1 && beginBln2 || endBln1 && endBln2 || beginBln3 && endBln3) {
                    this.retBeginPeriod = beginBln1 ? beginPeriod : periodColl.get(0);
                    this.retEndPeriod = endBln2 ? endPeriod : periodColl.get(periodColl.size() - 1);
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"BgPeriodBgSchemeMsg"));
                    return false;
                }
                this.periodIds = new String[periodColl.size()];
                for (int i = 0; i < periodColl.size(); ++i) {
                    this.periodIds[i] = periodColl.get(i).getId().toString();
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return true;
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        if (!this.isLoadQuery) {
            return;
        }
        if (this.isUnUsed) {
            this.isUnUsed = false;
            return;
        }
        Object multiBgScheme = this.prmtBgScheme.getData();
        if (multiBgScheme == null) {
            return;
        }
        Object[] multiBgSchemeArray = null;
        if (multiBgScheme instanceof Object[]) {
            multiBgSchemeArray = (Object[])multiBgScheme;
            if (multiBgSchemeArray.length != 2) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
                this.prmtBgScheme.setValue(null);
                SysUtil.abort();
            }
            if (multiBgSchemeArray[0] == null || multiBgSchemeArray[1] == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"msgSelectBgScheme"));
                this.prmtBgScheme.setValue(null);
                SysUtil.abort();
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgRptResource", (String)"MultiCompareSchemeMsg"));
            this.prmtBgScheme.setValue(null);
            SysUtil.abort();
        }
        this.comboBgTemplate.removeAllItems();
        if (multiBgSchemeArray != null) {
            BgSchemeInfo bgSchemeInfoOne = (BgSchemeInfo)multiBgSchemeArray[0];
            BgTemplateCollection bgTemplateCollOne = BgHelper.getBgTemplateCollByScheme(bgSchemeInfoOne.getId().toString());
            BgSchemeInfo bgSchemeInfoTwo = (BgSchemeInfo)multiBgSchemeArray[1];
            BgTemplateCollection bgTemplateCollTwo = BgHelper.getBgTemplateCollByScheme(bgSchemeInfoTwo.getId().toString());
            Map bgTemTwoMap = BgHelper.tranColl2Map((IObjectCollection)bgTemplateCollTwo, new String[]{"rootId"});
            BgTemplateCollection bgTemplateColl = new BgTemplateCollection();
            for (int i = 0; i < bgTemplateCollOne.size(); ++i) {
                BgTemplateInfo bgTemOneInfo = bgTemplateCollOne.get(i);
                if (!bgTemTwoMap.containsKey(bgTemOneInfo.getRootId().toString())) continue;
                if (this.bgTemplateMap == null) {
                    this.bgTemplateMap = new HashMap();
                }
                bgTemplateColl.add(bgTemOneInfo);
                this.bgTemplateMap.put(bgTemOneInfo.getId().toString(), new String[]{bgTemOneInfo.getId().toString(), ((IObjectValue)bgTemTwoMap.get(bgTemOneInfo.getRootId().toString())).getString("id")});
            }
            this.bgSchemeInfo = this.getBgSchemeByGreatType(bgSchemeInfoOne, bgSchemeInfoTwo);
            if (this.bgSchemeInfo != null && this.bgSchemeInfo.getId() != null) {
                this.comboBgPeriod.setSelectedItem((Object)this.bgSchemeInfo.getPeriod());
                this.comboBgPeriod.setEnabled(false);
                if (this.beginF7 == null) {
                    this.beginF7 = new BgPeriodDialog((CoreUIObject)this);
                }
                this.beginF7.setBgPeriodEnum(this.bgSchemeInfo.getPeriod());
                this.prmtBeginPeriod.setSelector((KDPromptSelector)this.beginF7);
                if (this.endF7 == null) {
                    this.endF7 = new BgPeriodDialog((CoreUIObject)this);
                }
                this.endF7.setBgPeriodEnum(this.bgSchemeInfo.getPeriod());
                this.prmtEndPeriod.setSelector((KDPromptSelector)this.endF7);
                this.comboBgTemplate.addItems(bgTemplateColl.toArray());
            }
        }
    }

    private BgSchemeInfo getBgSchemeByGreatType(BgSchemeInfo bgSchemeInfoOne, BgSchemeInfo bgSchemeInfoTwo) {
        if (bgSchemeInfoOne.getPeriod().getValue() <= bgSchemeInfoTwo.getPeriod().getValue()) {
            return bgSchemeInfoOne;
        }
        return bgSchemeInfoTwo;
    }

    @Override
    public Object getParam() {
        BgRptFilterParam filterParam = (BgRptFilterParam)super.getParam();
        if (((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem())).equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Object[] multiBgSchemeArray = (Object[])this.prmtBgScheme.getData();
            HashMap<String, String> multiBgSchemeMap = new HashMap<String, String>();
            BgSchemeInfo bgSchemeOne = (BgSchemeInfo)multiBgSchemeArray[0];
            BgSchemeInfo bgSchemeTwo = (BgSchemeInfo)multiBgSchemeArray[1];
            Vector<BgSchemeInfo> multiBgSchemeVec = new Vector<BgSchemeInfo>();
            multiBgSchemeVec.add(bgSchemeOne);
            multiBgSchemeVec.add(bgSchemeTwo);
            filterParam.setMultiBgSchemeVec(multiBgSchemeVec);
            multiBgSchemeMap.put(bgSchemeOne.getId().toString(), bgSchemeOne.getName());
            multiBgSchemeMap.put(bgSchemeTwo.getId().toString(), bgSchemeTwo.getName());
            filterParam.setMultiBgSchemeMap(multiBgSchemeMap);
            filterParam.setBgSchemeId(this.bgSchemeInfo.getId().toString());
            if (this.bgTemplateMap != null && this.bgTemplateMap.size() > 0) {
                filterParam.setBgTemplateIds((String[])this.bgTemplateMap.get(((BgTemplateInfo)this.comboBgTemplate.getSelectedItem()).getId().toString()));
            }
        }
        return filterParam;
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        BgRptFilterParam filterParam = (BgRptFilterParam)this.getFilterObject(cp);
        if (((BgAnalysisTypeEnum)((Object)this.comboBgRptType.getSelectedItem())).equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            Object[] multiBgSchemeArray = (Object[])this.prmtBgScheme.getData();
            HashMap<String, String> multiBgSchemeMap = new HashMap<String, String>();
            BgSchemeInfo bgSchemeOne = (BgSchemeInfo)multiBgSchemeArray[0];
            BgSchemeInfo bgSchemeTwo = (BgSchemeInfo)multiBgSchemeArray[1];
            Vector<BgSchemeInfo> multiBgSchemeVec = new Vector<BgSchemeInfo>();
            multiBgSchemeVec.add(bgSchemeOne);
            multiBgSchemeVec.add(bgSchemeTwo);
            filterParam.setMultiBgSchemeVec(multiBgSchemeVec);
            multiBgSchemeMap.put(bgSchemeOne.getId().toString(), bgSchemeOne.getName());
            multiBgSchemeMap.put(bgSchemeTwo.getId().toString(), bgSchemeTwo.getName());
            filterParam.setMultiBgSchemeMap(multiBgSchemeMap);
            filterParam.setBgSchemeId(this.bgSchemeInfo.getId().toString());
            if (this.bgTemplateMap != null && this.bgTemplateMap.size() > 0) {
                filterParam.setBgTemplateIds((String[])this.bgTemplateMap.get(((BgTemplateInfo)this.comboBgTemplate.getSelectedItem()).getId().toString()));
            }
        }
        this.setFilterObject(cp, filterParam);
        return cp;
    }

    public void setParam(Object param) {
        if (param == null || !(param instanceof BgRptFilterParam)) {
            return;
        }
        BgRptFilterParam filterParam = (BgRptFilterParam)param;
        this.isLoadQuery = false;
        this.bgAnalyType = filterParam.getBgRptType();
        this.prmtOrgUnit.setValue((Object)filterParam.getOrgUnitVec().toArray());
        this.isLoadQuery = true;
        try {
            this.prmtOrgUnit_dataChanged(null);
            this.isLoadQuery = false;
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String bgSchemeId = filterParam.getBgSchemeId();
        this.isLoadQuery = false;
        if (this.bgAnalyType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            this.prmtBgScheme.setValue((Object)filterParam.getMultiBgSchemeVec().toArray());
            this.isLoadQuery = true;
            try {
                this.prmtBgScheme_dataChanged(null);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            for (int i = 0; i < this.comboBgScheme.getItemCount(); ++i) {
                if (!bgSchemeId.equals(((BgSchemeInfo)this.comboBgScheme.getItemAt(i)).getId().toString())) continue;
                this.comboBgScheme.setSelectedIndex(i);
                try {
                    this.setBgTemplateSelect();
                }
                catch (EASBizException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (BOSException e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                break;
            }
        }
        this.isLoadQuery = true;
        this.comboBgPeriod.setSelectedItem((Object)BgPeriodEnum.getEnum(filterParam.getBgPeriodType()));
        String bgTemplateId = filterParam.getBgTemplate().keySet().toArray()[0].toString();
        this.isLoadQuery = false;
        for (int i = 0; i < this.comboBgTemplate.getItemCount(); ++i) {
            if (!bgTemplateId.equals(((BgTemplateInfo)this.comboBgTemplate.getItemAt(i)).getId().toString())) continue;
            this.comboBgTemplate.setSelectedIndex(i);
            break;
        }
        this.isLoadQuery = false;
        this.chkIsSum.setSelected(filterParam.isIsSum());
        this.prmtBeginPeriod.setValue(filterParam.getBgPeriodMap().get("BeginBgPeriod"));
        this.prmtEndPeriod.setValue(filterParam.getBgPeriodMap().get("EndBgPeriod"));
        this.isLoadBgBalance = false;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        BgRptFilterParam param = (BgRptFilterParam)this.getFilterObject(cp);
        if (param == null || !(param instanceof BgRptFilterParam)) {
            return;
        }
        BgRptFilterParam filterParam = param;
        this.isLoadQuery = false;
        this.bgAnalyType = filterParam.getBgRptType();
        this.prmtOrgUnit.setValue((Object)filterParam.getOrgUnitVec().toArray());
        this.isLoadQuery = true;
        try {
            this.prmtOrgUnit_dataChanged(null);
            this.isLoadQuery = false;
        }
        catch (Exception e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        String bgSchemeId = filterParam.getBgSchemeId();
        this.isLoadQuery = false;
        if (this.bgAnalyType.equals((Object)BgAnalysisTypeEnum.BGMULTICOMPARE)) {
            this.prmtBgScheme.setValue((Object)filterParam.getMultiBgSchemeVec().toArray());
            this.isLoadQuery = true;
            try {
                this.prmtBgScheme_dataChanged(null);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        } else {
            for (int i = 0; i < this.comboBgScheme.getItemCount(); ++i) {
                if (!bgSchemeId.equals(((BgSchemeInfo)this.comboBgScheme.getItemAt(i)).getId().toString())) continue;
                this.comboBgScheme.setSelectedIndex(i);
                try {
                    this.setBgTemplateSelect();
                }
                catch (EASBizException eASBizException) {
                }
                catch (BOSException bOSException) {
                }
                catch (Exception e) {
                    logger.error((Object)"budget error:", (Throwable)e);
                }
                break;
            }
        }
        this.isLoadQuery = true;
        this.comboBgPeriod.setSelectedItem((Object)BgPeriodEnum.getEnum(filterParam.getBgPeriodType()));
        String bgTemplateId = filterParam.getBgTemplate().keySet().toArray()[0].toString();
        this.isLoadQuery = false;
        for (int i = 0; i < this.comboBgTemplate.getItemCount(); ++i) {
            if (!bgTemplateId.equals(((BgTemplateInfo)this.comboBgTemplate.getItemAt(i)).getId().toString())) continue;
            this.comboBgTemplate.setSelectedIndex(i);
            break;
        }
        this.isLoadQuery = false;
        this.chkIsSum.setSelected(filterParam.isIsSum());
        this.prmtBeginPeriod.setValue(filterParam.getBgPeriodMap().get("BeginBgPeriod"));
        this.prmtEndPeriod.setValue(filterParam.getBgPeriodMap().get("EndBgPeriod"));
        this.isLoadBgBalance = false;
    }
}

