/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.core.client.AbstractHidedMenuItem;
import com.kingdee.eas.base.myeas.OpenModelInfo;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.uiframe.client.UIFrameContext;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgControlException;
import com.kingdee.eas.ma.budget.BgControlSchemeCollection;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.BgCtrlImportFacadeFactory;
import com.kingdee.eas.ma.budget.BgElementCollection;
import com.kingdee.eas.ma.budget.BgElementFactory;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.IBgCtrlImportFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgControlRuleTreeListUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgBatchCollectClientHelper;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgControlRuleEditUI;
import com.kingdee.eas.ma.budget.client.BgControlSchemeImportReportUI;
import com.kingdee.eas.ma.budget.client.BgControlSchemeImportSelectDialog;
import com.kingdee.eas.ma.budget.client.BgCtrlSchemeAssignChildUI;
import com.kingdee.eas.ma.budget.client.BgElementF7UI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgControlRuleTreeListUI
extends AbstractBgControlRuleTreeListUI {
    private static final long serialVersionUID = -6883476220005482050L;
    private static final Logger logger = CoreUIObject.getLogger(BgControlRuleTreeListUI.class);

    public BgControlRuleTreeListUI() throws Exception {
        this.rbAllOrgUnit.setSelected(false);
        this.rbImmOrgUnit.setSelected(false);
        this.rbCurrOrgUnit.setSelected(true);
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.btnEnableAll.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnAssign.setEnabled(true);
        this.btnEnableAll.setEnabled(true);
        this.menuItemEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemAssign.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
        this.menuItemEA.setIcon(EASResource.getIcon((String)"imgTbtn_attemper"));
        this.btnSysImport.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.menuSysImport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnSysImport.setEnabled(true);
        this.menuSysImport.setEnabled(true);
        this.btnViewFlow.setVisible(false);
        this.itemViewFlow.setVisible(false);
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift A"){

            public void action_actionPerformed() {
                try {
                    IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
                    UIContext uiContext = new UIContext((Object)this);
                    IUIWindow wnd = fy.create("com.kingdee.eas.ma.nbudget.client.BgControlUI", (Map)uiContext);
                    wnd.show();
                }
                catch (UIException e) {
                    SysUtil.abort((Throwable)e);
                }
            }
        });
        this.menuFile.add((JMenuItem)new AbstractHidedMenuItem("ctrl shift F5"){
            private static final long serialVersionUID = 8084246575141009215L;

            public void action_actionPerformed() {
                BgBatchCollectClientHelper.beforeBatchCollection((CoreUI)BgControlRuleTreeListUI.this);
            }
        });
    }

    public void setSelectFirstRow(KDTable tb) {
        super.setSelectFirstRow(tb);
        try {
            this.tblMain_tableSelectChanged(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                try {
                    BgControlRuleTreeListUI.this.tblMain_tableSelectChanged(e);
                }
                catch (Exception exc) {
                    logger.error((Object)e);
                    BgControlRuleTreeListUI.this.handUIException(exc);
                }
            }
        });
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected String getEditUIModal() {
        OpenModelInfo openModelInfo = (OpenModelInfo)UIFrameContext.getInstance().getProperty((Object)"OpenModel");
        if (openModelInfo != null) {
            if (openModelInfo.isIsOpenInFour()) {
                return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
            }
            if (openModelInfo.isIsOpenInNewTab()) {
                return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
            }
            if (openModelInfo.isIsOpenInWindow()) {
                return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
            }
        }
        return "com.kingdee.eas.base.uiframe.client.UIFixTabFactory";
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add("packageName");
        sic.add("billName");
        sic.add("costCenter");
        return sic;
    }

    @Override
    protected String getEditUIName() {
        return BgControlRuleEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgControlSchemeFactory.getRemoteInstance();
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.tblMain.getSelectManager().getActiveRowIndex() != -1) {
            IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
            if (((Boolean)row.getCell("isEnable").getValue()).booleanValue()) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionDisable.setEnabled(true);
                this.actionEnable.setEnabled(false);
                this.btnEdit.setEnabled(false);
                this.btnRemove.setEnabled(false);
                this.btnDisable.setEnabled(true);
                this.btnEnable.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
                this.actionRemove.setEnabled(true);
                this.actionEnable.setEnabled(true);
                this.actionDisable.setEnabled(false);
                this.btnEdit.setEnabled(true);
                this.btnRemove.setEnabled(true);
                this.btnDisable.setEnabled(false);
                this.btnEnable.setEnabled(true);
            }
        }
        boolean isEnable = false;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows != null && selectRows.length > 0) {
            for (int i = 0; i < selectRows.length; ++i) {
                if (!((Boolean)this.tblMain.getRow(selectRows[i]).getCell("isEnable").getValue()).booleanValue()) continue;
                isEnable = true;
            }
        }
        if (isEnable) {
            this.actionEdit.setEnabled(false);
            this.actionRemove.setEnabled(false);
        }
        try {
            this.checkCanUpdate();
        }
        catch (BgControlException ex) {
            if (ex.getSubCode().equals(BgControlException.ASSIGENNOTALLOWUPDATE.getCode())) {
                this.actionEdit.setEnabled(false);
                this.actionRemove.setEnabled(false);
            }
            throw ex;
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanUpdate();
        super.actionEdit_actionPerformed(e);
    }

    private void checkCanUpdate() throws Exception {
        ArrayList ids = this.getSelectedIdValues();
        if (ids != null && ids.size() > 0) {
            IBgControlScheme iCtrlScheme = BgControlSchemeFactory.getRemoteInstance();
            for (int i = 0; i < ids.size(); ++i) {
                String bgCtrlRuleId = (String)ids.get(i);
                iCtrlScheme.checkCanUpdate(bgCtrlRuleId, null);
            }
        }
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkCanUpdate();
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String bgCtrlRuleId = this.getSelectedKeyValue();
        ((IBgControlScheme)this.getBizInterface()).setBgCtrlSchemeValidStatus((IObjectPK)new ObjectUuidPK(bgCtrlRuleId), true);
        this.refreshList();
    }

    @Override
    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String bgCtrlRuleId = this.getSelectedKeyValue();
        ((IBgControlScheme)this.getBizInterface()).setBgCtrlSchemeValidStatus((IObjectPK)new ObjectUuidPK(bgCtrlRuleId), false);
        this.refreshList();
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filterInfo = null;
        filterInfo = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        FilterItemInfo item = new FilterItemInfo("isSysDefault", (Object)new Integer(0), CompareType.EQUALS);
        this.replaceFilterItems(filterInfo, item);
        viewInfo.setFilter(filterInfo);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    public String getPermissionNum() {
        return "bg_ctrl001_list";
    }

    @Override
    protected FilterInfo getImmSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = null;
        filter = viewInfo.getFilter() == null ? new FilterInfo() : viewInfo.getFilter();
        HashSet<String> orgUnitIdSet = new HashSet<String>();
        this.setPermissionOrg(new HashSet());
        OrgStructureInfo _oui = null;
        DefaultKingdeeTreeNode _node = null;
        FullOrgUnitInfo _fullOrgUnitinfo = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            try {
                _oui = (OrgStructureInfo)node.getUserObject();
                _fullOrgUnitinfo = _oui.getUnit();
                orgUnitIdSet.add(_fullOrgUnitinfo.getId().toString());
                this.getPermissionOrg().add(_fullOrgUnitinfo.getId().toString());
                if (!node.isLeaf()) {
                    for (int i = 0; i < node.getChildCount(); ++i) {
                        _node = (DefaultKingdeeTreeNode)node.getChildAt(i);
                        if (_node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)_node)) continue;
                        _oui = (OrgStructureInfo)_node.getUserObject();
                        _fullOrgUnitinfo = _oui.getUnit();
                        orgUnitIdSet.add(_fullOrgUnitinfo.getId().toString());
                        this.getPermissionOrg().add(_fullOrgUnitinfo.getId().toString());
                    }
                }
                FilterItemInfo item = new FilterItemInfo("costCenter.ID".toLowerCase(), orgUnitIdSet, CompareType.INCLUDE);
                this.replaceFilterItems(filter, item);
                viewInfo.setFilter(filter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return filter;
    }

    @Override
    protected FilterInfo getSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = null;
        filter = viewInfo.getFilter() == null ? new FilterInfo() : viewInfo.getFilter();
        this.setPermissionOrg(new HashSet());
        ArrayList<FullOrgUnitInfo> list = new ArrayList<FullOrgUnitInfo>();
        HashSet<String> orgUnitId = new HashSet<String>();
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            try {
                OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
                FullOrgUnitInfo fullOrgUnitinfo = oui.getUnit();
                fullOrgUnitinfo.setLongNumber(oui.getLongNumber());
                list.add(fullOrgUnitinfo);
                this.traceNode(node, list);
                for (int i = 0; i < list.size(); ++i) {
                    FullOrgUnitInfo info = (FullOrgUnitInfo)list.get(i);
                    orgUnitId.add(info.getId().toString());
                    this.getPermissionOrg().add(info.getId().toString());
                }
                FilterItemInfo item = new FilterItemInfo("costCenter.ID".toLowerCase(), orgUnitId, CompareType.INCLUDE);
                this.replaceFilterItems(filter, item);
                viewInfo.setFilter(filter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return filter;
    }

    @Override
    protected FilterInfo getUnSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = null;
        filter = viewInfo.getFilter() != null ? viewInfo.getFilter() : new FilterInfo();
        this.setPermissionOrg(new HashSet());
        this.getPermissionOrg().add(this.getOrgUnitId());
        FilterItemInfo item = new FilterItemInfo("costCenter.ID".toLowerCase(), (Object)this.getOrgUnitId(), CompareType.EQUALS);
        this.replaceFilterItems(filter, item);
        return filter;
    }

    private void traceNode(DefaultKingdeeTreeNode root, ArrayList list) throws Exception {
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node == null || OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) || !(node.getUserObject() instanceof OrgStructureInfo)) continue;
            OrgStructureInfo ouinfo = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo fullinfo = ouinfo.getUnit();
            fullinfo.setLongNumber(ouinfo.getLongNumber());
            list.add(fullinfo);
            if (node.getChildCount() == 0) continue;
            this.traceNode(node, list);
        }
    }

    @Override
    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        if (orgUnitInfo != null) {
            uiContext.put((Object)"ORGUNIT_INFO", (Object)orgUnitInfo);
            uiContext.put((Object)"ORGUNIT_CU", (Object)orgUnitInfo.getCU());
        }
    }

    @Override
    public void actionAssign_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String bgCtrlSchemeId = this.getSelectedKeyValue();
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        FullOrgUnitInfo org = this.getBGOrgUnitInfo();
        if (org == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"pleaseSelectOrg"));
            return;
        }
        OrgUnitCollection orgUnitCollectionSub = iNew.getChildren(org.getId().toString(), OrgViewType.COSTCENTER, true);
        if (orgUnitCollectionSub == null || orgUnitCollectionSub.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NoSubOrgNotSendDown"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitCollectionSub);
        BgClientHelper.applyMutexService((Component)((Object)this), bgCtrlSchemeId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        String cuId = org.getId().toString();
        uiContextOrg.put((Object)"CUID", (Object)cuId);
        uiContextOrg.put((Object)"ID", (Object)this.getSelectedKeyValue());
        uiContextOrg.put((Object)"IDS", (Object)this.getSelectedIdValues());
        uiContextOrg.put((Object)"operateType", (Object)String.valueOf(2));
        uiContextOrg.put((Object)"selfPanelUiName", (Object)BgCtrlSchemeAssignChildUI.class.getName());
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        BgClientHelper.releaseMutexService(bgCtrlSchemeId);
        this.refreshList();
    }

    @Override
    public void actionEnableAll_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int selectIndex = -1;
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (selectRows.length > 0) {
            if (selectRows.length == 1) {
                selectIndex = selectRows[0];
            } else {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"184_BgControlRuleTreeListUI"));
                SysUtil.abort();
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"185_BgControlRuleTreeListUI"));
            SysUtil.abort();
        }
        String bgCtrlSchemeId = this.getSelectedKeyValue();
        IBgControlScheme iCtrlScheme = BgControlSchemeFactory.getRemoteInstance();
        boolean state = (Boolean)this.tblMain.getRow(selectIndex).getCell("isEnable").getValue();
        BgClientHelper.applyMutexService((Component)((Object)this), bgCtrlSchemeId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        boolean isOK = iCtrlScheme.updateChidrenState(bgCtrlSchemeId, state);
        BgClientHelper.releaseMutexService(bgCtrlSchemeId);
        if (isOK) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"187_BgControlRuleTreeListUI"));
        }
        this.refreshList();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        Iterator it;
        super.actionImport_actionPerformed(e);
        BgControlSchemeImportSelectDialog dialog = new BgControlSchemeImportSelectDialog((IUIObject)this);
        dialog.show();
        if (dialog.isCanceled()) {
            return;
        }
        Object obj = dialog.getData();
        BgControlSchemeCollection col = (BgControlSchemeCollection)((Object)obj);
        boolean hasElement = false;
        BgElementCollection bgElementCol = BgElementFactory.getRemoteInstance().getBgElementCollection();
        if (bgElementCol != null && bgElementCol.size() > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"188_BgControlRuleTreeListUI"));
            hasElement = true;
        }
        BgElementInfo bgElementInfo = null;
        if (hasElement) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"isFilterText", (Object)new Boolean(true));
            uiContext.put((Object)"isChooseOne", (Object)new Boolean(true));
            uiContext.put((Object)"isCtrlRule", (Object)new Boolean(true));
            IUIWindow uiWindow = null;
            try {
                uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.BgElementF7UI", (Map)uiContext);
            }
            catch (UIException uie) {
                ExceptionHandler.handle((Throwable)uie);
                return;
            }
            uiWindow.show();
            BgElementF7UI f7ui = (BgElementF7UI)uiWindow.getUIObject();
            if (f7ui.isCancel()) {
                return;
            }
            bgElementInfo = f7ui.getResultOne();
        }
        if (col == null || col.size() == 0) {
            return;
        }
        int size = col.size();
        String[] numbers = new String[size];
        HashMap<String, Object> importMap = new HashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            BgControlSchemeInfo info = col.get(i);
            numbers[i] = info.getNumber();
            importMap.put(info.getNumber(), info.getId());
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        String orgId = null;
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            try {
                OrgStructureInfo _oui = (OrgStructureInfo)node.getUserObject();
                orgId = _oui.getUnit().getId().toString();
            }
            catch (Exception _oui) {
                // empty catch block
            }
        }
        if (orgId == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgCtrlImportResource", (String)"getCostIdLost"));
            return;
        }
        Map repeatMap = this.getImportFacade().checkNumberRepeat(orgId, numbers);
        int j = 0;
        if (repeatMap != null && !repeatMap.isEmpty()) {
            StringBuffer errorMsg = new StringBuffer();
            it = repeatMap.keySet().iterator();
            while (it.hasNext()) {
                errorMsg.append(it.next() + ",");
            }
            errorMsg.delete(errorMsg.length() - 1, errorMsg.length());
            j = MsgBox.showConfirm2((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BgCtrlImportResource", (String)"number") + errorMsg + EASResource.getString((String)"com.kingdee.eas.ma.budget.BgCtrlImportResource", (String)"numberIsRepeatContinueOrNot")));
        }
        if (j != 0) {
            String repeatNumber = null;
            it = repeatMap.keySet().iterator();
            while (it.hasNext()) {
                repeatNumber = (String)it.next();
                importMap.remove(repeatNumber);
                it.remove();
            }
        }
        if (importMap == null || importMap.isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BgCtrlImportResource", (String)"noImportData"));
            return;
        }
        if (bgElementInfo == null || bgElementInfo.getNumber() == null) {
            importMap.put("elementNumber", null);
        } else {
            importMap.put("elementNumber", bgElementInfo.getNumber());
        }
        final String orgUnitId = orgId;
        final HashMap<String, Object> impMap = importMap;
        final Map rptMap = repeatMap;
        LongTimeDialog processDialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            processDialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            processDialog = new LongTimeDialog((Dialog)win);
        }
        if (processDialog != null) {
            processDialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    return BgControlRuleTreeListUI.this.getImportFacade().importData(orgUnitId, impMap, rptMap);
                }

                public void afterExec(Object result) throws Exception {
                    BgControlRuleTreeListUI.this.showImportReport(result);
                }
            });
            processDialog.show();
            this.refreshList();
        }
    }

    private void showImportReport(Object report) throws UIException {
        String messageInfo = (String)report;
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"result", (Object)messageInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgControlSchemeImportReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected IBgCtrlImportFacade getImportFacade() throws BOSException {
        return BgCtrlImportFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        FullOrgUnitInfo org = this.getBGOrgUnitInfo();
        this.getUIContext().put("Cost_Center", org);
        super.actionAddNew_actionPerformed(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.CostCenter;
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        this.tblMain_tableSelectChanged(null);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            // empty if block
        }
        return handler;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return true;
    }

    @Override
    public RequestContext prepareActionEdit(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionEdit(itemAction);
        if (request != null) {
            request.put("IDS", (Object)this.getSelectedIdValues());
        }
        return request;
    }
}

