/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.IllegalSessionStateException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.rpcwrapper.Utils;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.client.OrgViewUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.ma.budget.BgCtrSettingFacadeFactory;
import com.kingdee.eas.ma.budget.BgCtrSettingFilterParam;
import com.kingdee.eas.ma.budget.BgCtrlSetHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeAssignException;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.BgTemFormTypeEnum;
import com.kingdee.eas.ma.budget.BgTemplateCollection;
import com.kingdee.eas.ma.budget.BgTemplateFactory;
import com.kingdee.eas.ma.budget.BgTemplateInfo;
import com.kingdee.eas.ma.budget.BgTypeInfo;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgCtrSettingFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgTemplate;
import com.kingdee.eas.ma.budget.client.AbstractBgCtrSettingListUI;
import com.kingdee.eas.ma.budget.client.BgCtrSettingFilterUI;
import com.kingdee.eas.ma.budget.client.BgTypeSelectorDialog;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.budget.client.ProgressDialogUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormCtrlProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgNTemplateCtrlProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.nbudget.solution.MaQuerySolutionUpgrande;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgCtrSettingListUI
extends AbstractBgCtrSettingListUI {
    private static final long serialVersionUID = 49560577127712657L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrSettingListUI.class);
    protected BgCtrSettingFilterUI defaultFilterUI = null;
    protected FilterParam defaultFilterParam = null;
    private CommonQueryDialog dialog = null;
    protected IMetaDataPK mainQueryPk = null;
    private String selectedItem = null;
    private BOSUuid solutionId = null;
    CostCenterOrgUnitInfo ccOrgUnit = SysContext.getSysContext().getCurrentCostUnit();
    private String RESOURCE = "com.kingdee.eas.ma.budget.client.BgCtrSettingResource";
    boolean hasOnLoad = false;
    private boolean isUpgrade = true;
    boolean isFromQuery = false;
    private static final String COL_ID = "COL_ID";
    private static final String COL_NAME = "COL_NAME";
    private static final String COL_NUMBER = "COL_NUMBER";
    private static final String COL_STATE = "COL_STATE";
    private static final String COL_DESCRIPTION = "COL_DESCRIPTION";
    private static final String COL_SCHEME_NAME = "COL_SCHEME_NAME";
    private static final String COL_SCHEME_NUMBER = "COL_SCHEME_NUMBER";
    private static final String COL_DATA_SOURCE = "COL_DATA_SOURCE";
    private static final String COL_TEMPLATE_NAME = "COL_TEMPLATE_NAME";
    private static final String COL_BGTYPE = "COL_BGTYPE";
    private static final String COL_FORMTYPE = "COL_FORMTYPE";
    private static final String COL_ORG = "COL_ORG";
    private static final String COL_PERIOD = "COL_PERIOD";
    private static final String COL_CURRENCY = "COL_CURRENCY";
    private static final String nullID = "000000000000000000000000000=";

    public BgCtrSettingListUI() throws Exception {
        this.mainQueryPk = new MetaDataPK("com.kingdee.eas.ma.budget", "BgElementQuery");
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        if (handler != null) {
            RequestContext request = (RequestContext)handler.getRequestContext();
            request.put("QUERY_NAME", (Object)this.getQueryMainName());
            request.put("QUERY_PK_NAME", (Object)this.mainQueryPk.getFullName());
        }
        return handler;
    }

    @Override
    public void onLoad() throws Exception {
        this.hasOnLoad = false;
        super.onLoad();
        boolean hasDefaultQuery = this.getDefaultFilterParam();
        if (hasDefaultQuery) {
            this.execQuery();
        } else {
            this.dialog = this.getCommonQueryDialog();
            if (this.dialog.show()) {
                CustomerParams params = this.getFilterUI().getCustomerParams();
                this.setFilterParam(params);
                this.execQuery();
            } else {
                SysUtil.abort();
            }
        }
        this.hasOnLoad = true;
        this.menuItemSelectCtrlView.setVisible(true);
        this.menuItemSelectCtrlView.setEnabled(true);
        this.menuItemSelectCtrlSet.setVisible(true);
        this.menuItemSelectCtrlSet.setEnabled(true);
        this.prmtBgType.setSelector((KDPromptSelector)new BgTypeSelectorDialog());
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewFlow.setEnabled(false);
        this.btnViewFlow.setVisible(false);
        this.btnLocate.setEnabled(false);
        this.btnLocate.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.btnRemove.setVisible(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.btnAddNew.setEnabled(false);
        this.btnAddNew.setVisible(false);
        this.btnView.setEnabled(false);
        this.btnView.setVisible(false);
        this.btnPrint.setEnabled(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setEnabled(false);
        this.btnPrintPreview.setVisible(false);
        this.menuFile.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuTool.setVisible(false);
        this.menuItemCancel.setVisible(false);
        this.menuItemCancelCancel.setVisible(false);
        this.menuItemView.setVisible(false);
        this.menuItemLocate.setVisible(false);
        this.menuItemRefresh.setVisible(false);
        this.itemViewFlow.setVisible(false);
        this.rbImmOrgUnit.setVisible(false);
        this.rbImmOrgUnit.setEnabled(false);
        this.rbAllOrgUnit.setVisible(false);
        this.rbAllOrgUnit.setEnabled(false);
        this.rbCurrOrgUnit.setVisible(false);
        this.rbCurrOrgUnit.setEnabled(false);
        this.btnCtrlView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnCtrlSet.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnDefCtrlSet.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnCtrlUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_mannerrenewal"));
        this.btnCtrlAssign.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.menuItemCtrlView.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.menuItemCtrlSet.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.menuItemDefCrlSet.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.menuItemCtrlUpdate.setIcon(EASResource.getIcon((String)"imgTbtn_mannerrenewal"));
        this.menuItemCtrlAssign.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.actionSelectCtrlSet.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_edit"));
        this.actionSelectCtrlView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_view"));
        JMenuItem jmi = null;
        jmi = this.btnCtrlSet.addAssistMenuItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSelectCtrlSet), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        jmi.setEnabled(true);
        JMenuItem jmiview = null;
        jmiview = this.btnCtrlView.addAssistMenuItem((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSelectCtrlView), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        jmiview.setEnabled(true);
        String strKey = "CTRL_SHIFT_U";
        KeyStroke ks = KeyStroke.getKeyStroke(85, 192, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionUpGrade));
        this.getInputMap(2).put(ks, strKey);
    }

    @Override
    public String getPermissionNum() {
        return "bg_ctrlSet001_list";
    }

    protected CommonQueryDialog getCommonQueryDialog() throws Exception {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.setOwner((Component)this.getUIContext().get("Owner"));
        this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.dialog.setEntityViewInfo(new EntityViewInfo());
        this.dialog.setQueryObjectPK(this.mainQueryPk);
        this.dialog.setTitle(this.getFilterUI().getUITitle());
        this.dialog.setWidth(290);
        this.dialog.setHeight(280);
        this.dialog.addUserPanel((KDPanel)this.getFilterUI());
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        return this.dialog;
    }

    protected void execQuery() {
        FilterInfo filter;
        EntityViewInfo view;
        BgCtrSettingFilterParam _filterParam;
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (!StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            this.kDLabelContainer2.setVisible(false);
            this.kDLabelContainer3.setVisible(true);
            this.btnCtrlUpdate.setEnabled(false);
            this.menuItemCtrlUpdate.setEnabled(false);
            this.btnDefCtrlSet.setEnabled(false);
            this.btnDefCtrlSet.setVisible(false);
            this.menuItemDefCrlSet.setEnabled(false);
            this.menuItemDefCrlSet.setVisible(false);
            if (this.getFilterParam() != null) {
                BgFormCollection bgFormCollection;
                _filterParam = (BgCtrSettingFilterParam)this.getFilterParam();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("state", (Object)new Integer(15), CompareType.NOTEQUALS));
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from t_bg_bgform where fstate in(4, 6, 101) and fid <> fadjustid", CompareType.NOTINNER));
                filter.setMaskString(" #0 and #1 ");
                if (this.getBGOrgUnitInfo() != null) {
                    if (!this.verifyPermission(userId, this.getBGOrgUnitInfo().getId().toString(), this.getPermissionNum())) {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)nullID, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getBGOrgUnitInfo().getId(), CompareType.EQUALS));
                    }
                    if (filter.getMaskString() == null) {
                        filter.setMaskString(" #0 ");
                    } else {
                        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                    }
                }
                if (_filterParam.getBgSchemeInfo() != null) {
                    filter.getFilterItems().add(new FilterItemInfo("bgScheme.number", (Object)_filterParam.getBgSchemeInfo().getNumber(), CompareType.EQUALS));
                    if (filter.getMaskString() == null) {
                        filter.setMaskString(" #0 ");
                    } else {
                        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                    }
                }
                if (_filterParam.getBgFormObject() != null) {
                    bgFormCollection = _filterParam.getBgFormObject().getResult();
                    HashSet<BOSUuid> formIds = new HashSet<BOSUuid>();
                    for (int i = 0; i < bgFormCollection.size(); ++i) {
                        formIds.add(bgFormCollection.get(i).getId());
                    }
                    filter.getFilterItems().add(new FilterItemInfo("id", formIds, CompareType.INCLUDE));
                    if (filter.getMaskString() == null) {
                        filter.setMaskString(" #0 ");
                    } else {
                        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                    }
                } else if (BgParamCHelper.isBgPermissionUsed()) {
                    HashSet<String> orgSet = new HashSet<String>();
                    orgSet.add(this.getBGOrgUnitInfo().getId().toString());
                    filter = BgPermissionHelper.addBgFormPermission((String)userId, orgSet, (FilterInfo)filter);
                }
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)this.getBgFormSelectors());
                try {
                    bgFormCollection = this.getBgFormInterface().getBgFormCollection(view);
                    BgHelper.sortCollection(bgFormCollection, new String[]{"number"});
                    this.fillBgFormData(bgFormCollection);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        if (!StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            this.kDLabelContainer2.setVisible(true);
            this.kDLabelContainer3.setVisible(false);
            this.btnCtrlUpdate.setEnabled(true);
            this.menuItemCtrlUpdate.setEnabled(true);
            this.btnDefCtrlSet.setEnabled(true);
            this.btnDefCtrlSet.setVisible(true);
            this.menuItemDefCrlSet.setEnabled(true);
            this.menuItemDefCrlSet.setVisible(true);
            if (this.getFilterParam() != null) {
                BgTemplateCollection bgTemplateCollection;
                _filterParam = (BgCtrSettingFilterParam)this.getFilterParam();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                HashSet<String> orgIdSet = new HashSet<String>();
                if (this.getBGOrgUnitInfo() != null) {
                    if (!this.verifyPermission(userId, this.getBGOrgUnitInfo().getId().toString(), this.getPermissionNum())) {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)nullID, CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.getBGOrgUnitInfo().getId(), CompareType.EQUALS));
                    }
                    orgIdSet.add(this.getBGOrgUnitInfo().getId().toString());
                    if (filter.getMaskString() == null) {
                        filter.setMaskString("#0");
                    } else {
                        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                    }
                }
                if (_filterParam.getBgTypeInfo() != null) {
                    this.addBgTypeFilterItem(filter, _filterParam.getBgTypeInfo());
                }
                if (_filterParam.getBgTemplateObject() != null) {
                    bgTemplateCollection = _filterParam.getBgTemplateObject().getResult();
                    BOSUuid rootId = null;
                    HashSet<BOSUuid> templateRootIds = new HashSet<BOSUuid>();
                    for (int i = 0; i < bgTemplateCollection.size(); ++i) {
                        rootId = bgTemplateCollection.get(i).getRootId();
                        if (templateRootIds.contains(rootId)) continue;
                        templateRootIds.add(rootId);
                    }
                    filter.getFilterItems().add(new FilterItemInfo("rootId", templateRootIds, CompareType.INCLUDE));
                    if (filter.getMaskString() == null) {
                        filter.setMaskString("#0");
                    } else {
                        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
                    }
                } else if (BgSHelper.isBgPermissionUsed()) {
                    BgPermissionHelper.addBgTemplatePermission((String)userId, orgIdSet, (FilterInfo)filter);
                }
                view.setFilter(filter);
                view.getSelector().addObjectCollection((IObjectCollection)this.getBgTemplateSelectors());
                try {
                    bgTemplateCollection = this.getBgTemplateInterface().getBgTemplateCollection(view);
                    BgHelper.sortCollection(bgTemplateCollection, new String[]{"number"});
                    this.fillBgTemplateData(bgTemplateCollection);
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
    }

    protected boolean verifyPermission(String userId, String orgUnitId, String permission) {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)orgUnitId)) {
            return false;
        }
        boolean hasPerm = false;
        try {
            hasPerm = this.getPermissionInterface().hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), permission);
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            hasPerm = false;
        }
        return hasPerm;
    }

    protected void fillBgFormData(BgFormCollection bgFormCollection) {
        this.initTblForForm();
        BgFormInfo bgFormInfo = null;
        IRow row = null;
        Iterator it = bgFormCollection.iterator();
        while (it.hasNext()) {
            bgFormInfo = (BgFormInfo)it.next();
            row = this.tblMain.addRow();
            row.setUserObject((Object)bgFormInfo);
            row.getCell(COL_ID).setValue((Object)bgFormInfo.getId());
            row.getCell(COL_SCHEME_NUMBER).setValue((Object)bgFormInfo.getBgScheme().getNumber());
            row.getCell(COL_SCHEME_NAME).setValue((Object)bgFormInfo.getBgScheme().getName());
            row.getCell(COL_NUMBER).setValue((Object)bgFormInfo.getNumber());
            row.getCell(COL_NAME).setValue((Object)bgFormInfo.getName());
            row.getCell(COL_DATA_SOURCE).setValue((Object)bgFormInfo.getDataSource());
            row.getCell(COL_TEMPLATE_NAME).setValue((Object)bgFormInfo.getBgTemplate().getName());
            row.getCell(COL_STATE).setValue((Object)bgFormInfo.getState());
            row.getCell(COL_PERIOD).setValue((Object)bgFormInfo.getBgPeriod().getName());
            row.getCell(COL_CURRENCY).setValue((Object)bgFormInfo.getCurrency().getName());
        }
        this.tblMain.setRowCount(bgFormCollection.size());
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    protected void fillBgTemplateData(BgTemplateCollection bgTemplateCollection) {
        this.initTblForTemplate();
        BgTemplateInfo bgTemplateInfo = null;
        IRow row = null;
        Iterator it = bgTemplateCollection.iterator();
        while (it.hasNext()) {
            bgTemplateInfo = (BgTemplateInfo)it.next();
            row = this.tblMain.addRow();
            row.setUserObject((Object)bgTemplateInfo);
            row.getCell(COL_ID).setValue((Object)bgTemplateInfo.getId());
            row.getCell(COL_NUMBER).setValue((Object)bgTemplateInfo.getNumber());
            row.getCell(COL_NAME).setValue((Object)bgTemplateInfo.getName());
            row.getCell(COL_DESCRIPTION).setValue((Object)bgTemplateInfo.getDescription());
            if (bgTemplateInfo.getBgType() != null) {
                row.getCell(COL_BGTYPE).setValue((Object)bgTemplateInfo.getBgType().getName());
            } else {
                row.getCell(COL_BGTYPE).setValue(null);
            }
            row.getCell(COL_FORMTYPE).setValue((Object)bgTemplateInfo.getFormType());
            row.getCell(COL_ORG).setValue((Object)bgTemplateInfo.getOrgUnit().getName());
        }
        this.tblMain.setRowCount(bgTemplateCollection.size());
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    protected boolean getDefaultFilterParam() throws Exception {
        if (this.getFilterParam() != null) {
            return true;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(this.getQueryMainName(), this.mainQueryPk.getFullName());
        if (ds != null && ds.getSolutionType().equals((Object)SolutionTypeEnum.CUSTOMER_SOLUTION) && ds.getQueryPanelInfo().size() > 0) {
            this.solutionId = ds.getId();
            CustomerParams cp = new CustomerParams().getCustomerParams(ds.getQueryPanelInfo().get(0).getCustomerParams());
            this.setFilterParam(cp);
        }
        return this.getFilterParam() != null;
    }

    public FilterParam getFilterParam() {
        return this.defaultFilterParam;
    }

    protected void setFilterParam(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        MaQuerySolutionUpgrande upGrande = new MaQuerySolutionUpgrande();
        FilterParam filterParam = null;
        if (upGrande.isNewQuerySolution(upGrande.cast(cp))) {
            try {
                filterParam = (FilterParam)upGrande.convertToParams(((Object)((Object)this.getFilterUI())).getClass().getName(), cp.getCustomerParam("FILTERPARAM"));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            filterParam = (FilterParam)this.getFilterUI().getFilterObject(cp);
        }
        this.setFilterParam(filterParam);
    }

    public void setFilterParam(FilterParam filterParam) {
        if (filterParam == null) {
            filterParam = new BgCtrSettingFilterParam();
        }
        this.defaultFilterParam = filterParam;
        if (this.getFilterParam() != null) {
            BgCtrSettingFilterParam _filterParam = (BgCtrSettingFilterParam)this.defaultFilterParam;
            this.selectedItem = _filterParam.getSelectedItem();
            this.prmtBgform.setData((Object)_filterParam.getBgFormObject());
            this.prmtBgScheme.setData((Object)_filterParam.getBgSchemeInfo());
            this.prmtBgTemplate.setData((Object)_filterParam.getBgTemplateObject());
            this.prmtBgType.setData((Object)_filterParam.getBgTypeInfo());
        }
    }

    protected BgCtrSettingFilterUI getFilterUI() {
        if (this.defaultFilterUI == null) {
            try {
                this.defaultFilterUI = new BgCtrSettingFilterUI((Object)this);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                this.handleException(ex);
            }
        }
        return this.defaultFilterUI;
    }

    protected String getQueryMainName() {
        return BgCtrSettingListUI.class.getName();
    }

    public String getSelectedItem() {
        return this.selectedItem;
    }

    public void setSelectedItem(String selectedItem) {
        this.selectedItem = selectedItem;
    }

    public Map getQueryParamMap() throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("BGFORMINFO", this.prmtBgform.getData());
        param.put("BGSCHEMEINFO", this.prmtBgScheme.getData());
        param.put("BGTEMPLATEINFO", this.prmtBgTemplate.getData());
        param.put("BGTYPEINFO", this.prmtBgType);
        param.put("SELECTED_ITEM", this.selectedItem);
        return param;
    }

    protected IBgForm getBgFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgTemplate getBgTemplateInterface() throws Exception {
        return BgTemplateFactory.getRemoteInstance();
    }

    public SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgTemplate.id"));
        sic.add(new SelectorItemInfo("bgTemplate.number"));
        sic.add(new SelectorItemInfo("bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgPeriod.id"));
        sic.add(new SelectorItemInfo("bgPeriod.number"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("dataSource"));
        return sic;
    }

    public SelectorItemCollection getBgTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("bgType.id"));
        sic.add(new SelectorItemInfo("bgType.number"));
        sic.add(new SelectorItemInfo("bgType.name"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit.id"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit.name"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add(new SelectorItemInfo("convertResult"));
        sic.add(new SelectorItemInfo("rootId"));
        return sic;
    }

    private void initTblForForm() {
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.removeColumns();
        this.tblMain.setRefresh(false);
        this.tblMain.checkParsed();
        this.tblMain.addColumns(10);
        this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(1).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(0).setKey(COL_ID);
        this.tblMain.getColumn(1).setKey(COL_SCHEME_NUMBER);
        this.tblMain.getColumn(COL_SCHEME_NUMBER).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(COL_SCHEME_NUMBER).setWidth(100);
        this.tblMain.getColumn(2).setKey(COL_SCHEME_NAME);
        this.tblMain.getColumn(3).setKey(COL_NUMBER);
        this.tblMain.getColumn(4).setKey(COL_NAME);
        this.tblMain.getColumn(5).setKey(COL_DATA_SOURCE);
        this.tblMain.getColumn(6).setKey(COL_TEMPLATE_NAME);
        this.tblMain.getColumn(7).setKey(COL_STATE);
        this.tblMain.getColumn(8).setKey(COL_PERIOD);
        this.tblMain.getColumn(9).setKey(COL_CURRENCY);
        IRow headRow = this.tblMain.addHeadRow(0);
        headRow.getCell(0).setValue((Object)"ID");
        headRow.getCell(1).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgSchemeNumber"));
        headRow.getCell(2).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgSchemeName"));
        headRow.getCell(3).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgformNumber"));
        headRow.getCell(4).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgformName"));
        headRow.getCell(5).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgformDataSource"));
        headRow.getCell(6).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgtemplateName"));
        headRow.getCell(7).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgformState"));
        headRow.getCell(8).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"period"));
        headRow.getCell(9).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"currency"));
    }

    private void initTblForTemplate() {
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.removeColumns();
        this.tblMain.setRefresh(false);
        this.tblMain.checkParsed();
        this.tblMain.addColumns(7);
        this.tblMain.getColumn(0).getStyleAttributes().setHided(true);
        this.tblMain.getColumn(0).setKey(COL_ID);
        this.tblMain.getColumn(1).setKey(COL_NUMBER);
        this.tblMain.getColumn(2).setKey(COL_NAME);
        this.tblMain.getColumn(3).setKey(COL_DESCRIPTION);
        this.tblMain.getColumn(4).setKey(COL_BGTYPE);
        this.tblMain.getColumn(5).setKey(COL_FORMTYPE);
        this.tblMain.getColumn(6).setKey(COL_ORG);
        IRow headRow = this.tblMain.addHeadRow(0);
        headRow.getCell(0).setValue((Object)"ID");
        headRow.getCell(1).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgtemplateNumber"));
        headRow.getCell(2).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgtemplateName"));
        headRow.getCell(3).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"description"));
        headRow.getCell(4).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"bgType"));
        headRow.getCell(5).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"templateType"));
        headRow.getCell(6).setValue((Object)EASResource.getString((String)this.RESOURCE, (String)"org"));
    }

    @Override
    protected void prmtBgType_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.hasOnLoad || this.isFromQuery) {
            return;
        }
        super.prmtBgType_dataChanged(e);
        if (this.getFilterParam() != null) {
            BgCtrSettingFilterParam param = (BgCtrSettingFilterParam)this.getFilterParam();
            param.setBgTemplateObject(null);
            if (this.prmtBgType.getData() == null) {
                param.setBgTypeInfo(null);
            } else if (this.prmtBgType.getData() instanceof BgTypeInfo) {
                param.setBgTypeInfo((BgTypeInfo)this.prmtBgType.getData());
            }
            this.execQuery();
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        if (!this.hasOnLoad || this.isFromQuery) {
            return;
        }
        super.prmtBgScheme_dataChanged(e);
        if (this.getFilterParam() != null) {
            BgCtrSettingFilterParam param = (BgCtrSettingFilterParam)this.getFilterParam();
            param.setBgFormObject(null);
            if (this.prmtBgScheme.getData() instanceof BgSchemeInfo) {
                param.setBgSchemeInfo((BgSchemeInfo)this.prmtBgScheme.getData());
            }
            this.execQuery();
        }
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        FullOrgUnitInfo orgUnitInfo = this.getBGOrgUnitInfo();
        if (orgUnitInfo == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgId = orgUnitInfo.getId().toString();
        HashSet<String> orgSet = new HashSet<String>();
        orgSet.add(orgId);
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgId, CompareType.EQUALS));
        if (filter.getMaskString() == null) {
            filter.setMaskString(" #0 ");
        } else {
            filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        }
        if (BgSHelper.isBgPermissionUsed()) {
            BgPermissionHelper.addBgSchemePermission((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString(), orgSet, (FilterInfo)filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
        if (this.getFilterParam() != null) {
            BgCtrSettingFilterParam param = (BgCtrSettingFilterParam)this.getFilterParam();
            param.setFullOrgUnitInfo(orgUnitInfo);
            this.execQuery();
        }
    }

    @Override
    protected FullOrgUnitInfo getBGOrgUnitInfo() {
        OrgStructureInfo oui;
        FullOrgUnitInfo info = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        if (node != null && !OrgViewUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node) && (oui = (OrgStructureInfo)node.getUserObject()) != null && oui.getUnit() != null) {
            info = oui.getUnit();
            String id = info.getId().toString();
            try {
                FullOrgUnitInfo info1 = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo("select CU.id, CU.name where id='" + id + "'");
                info.setCU(info1.getCU());
            }
            catch (Exception ex) {
                this.handUIException(ex);
            }
            info.setLongNumber(oui.getLongNumber());
        }
        return info;
    }

    @Override
    public void actionDefCtrlSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BOSUuid id = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            id = (BOSUuid)row.getCell(COL_ID).getValue();
        }
        if (id == null || StringUtils.isEmpty((String)this.selectedItem) || this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"BGTEMPLATE_ID", (Object)id.toString());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.BgDefaultCtrlSetEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCtrlView_actionPerformed(ActionEvent e) throws Exception {
        super.actionCtrlView_actionPerformed(e);
        this.checkSelected();
        BOSUuid id = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            id = (BOSUuid)row.getCell(COL_ID).getValue();
        }
        Map ctrlSetting = null;
        if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            ctrlSetting = this.getBgCtrSettingFacadeInterface().getTemplateCtrlSetting(id, null);
            BgTemplateInfo template = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(id));
            if (4 == template.getFormType().getValue()) {
                BgCtrlSetHelper.fillNoCtrlRecordForView(null, template.getId(), ctrlSetting);
            } else {
                BgCtrlSetHelper.fillNoCtrlRecord(template.getBook(), ctrlSetting);
            }
        } else if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            ctrlSetting = this.getBgCtrSettingFacadeInterface().getBgFormCtrlSetting(id, null, false);
        }
        if (ctrlSetting == null) {
            return;
        }
        Hashtable ctrlModeMap = (Hashtable)ctrlSetting.get("ctrlModeMap");
        Vector itemAndElement = (Vector)ctrlSetting.get("itemAndElement");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"ctrlModeMap", (Object)ctrlModeMap);
        uiContext.put((Object)"itemAndElement", (Object)itemAndElement);
        uiContext.put((Object)"SELECTED_ITEM", (Object)this.selectedItem);
        uiContext.put((Object)"selectedItem_id", (Object)id);
        uiContext.put((Object)"orgUnitId", (Object)this.getOrgUnitId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewCtrlSetEditUI", (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCtrlSet_actionPerformed(ActionEvent e) throws Exception {
        super.actionCtrlSet_actionPerformed(e);
        this.checkSelected();
        BOSUuid id = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            id = (BOSUuid)row.getCell(COL_ID).getValue();
        }
        boolean isCanSave = true;
        Map ctrlSetting = null;
        if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            ctrlSetting = this.getBgCtrSettingFacadeInterface().getTemplateCtrlSetting(id, null);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("formType");
            sic.add("data");
            sic.add("rootId");
            BgTemplateInfo template = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(id));
            if (template != null) {
                if (4 == template.getFormType().getValue()) {
                    BgCtrlSetHelper.fillNoCtrlRecordForView(null, template.getId(), ctrlSetting);
                } else {
                    BgCtrlSetHelper.fillNoCtrlRecord(template.getBook(), ctrlSetting);
                    if (0 == template.getFormType().getValue() && !template.getId().equals((Object)template.getRootId())) {
                        isCanSave = false;
                    }
                }
            }
        } else if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            ctrlSetting = this.getBgCtrSettingFacadeInterface().getBgFormCtrlSetting(id, null, true);
        }
        if (ctrlSetting == null) {
            return;
        }
        Hashtable ctrlModeMap = (Hashtable)ctrlSetting.get("ctrlModeMap");
        Vector itemAndElement = (Vector)ctrlSetting.get("itemAndElement");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"ctrlModeMap", (Object)ctrlModeMap);
        uiContext.put((Object)"itemAndElement", (Object)itemAndElement);
        if (!isCanSave) {
            uiContext.put((Object)"cannotSave", (Object)Boolean.FALSE);
        }
        uiContext.put((Object)"SELECTED_ITEM", (Object)this.selectedItem);
        if (!StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            uiContext.put((Object)"isFromTemplate", (Object)Boolean.TRUE);
        }
        uiContext.put((Object)"selectedItem_id", (Object)id);
        uiContext.put((Object)"orgUnitId", (Object)this.getOrgUnitId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewCtrlSetEditUI", (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    protected IBgCtrSettingFacade getBgCtrSettingFacadeInterface() throws Exception {
        return BgCtrSettingFacadeFactory.getRemoteInstance();
    }

    @Override
    public void actionUpGrade_actionPerformed(ActionEvent e) throws Exception {
        super.actionUpGrade_actionPerformed(e);
        int confirm = MsgBox.showConfirm2((String)EASResource.getString((String)this.RESOURCE, (String)"upgradeWarning"));
        if (confirm != 0) {
            SysUtil.abort();
        }
        LongTimeDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new LongTimeDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new LongTimeDialog((Dialog)win);
        }
        if (dialog == null) {
            return;
        }
        dialog.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                BgCtrSettingListUI.this.getBgCtrSettingFacadeInterface().restoreOldSetting();
                return "";
            }

            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((String)EASResource.getString((String)BgCtrSettingListUI.this.RESOURCE, (String)"upgradeFinished"));
            }
        });
        dialog.show();
    }

    protected String getKeyFieldName() {
        return COL_ID;
    }

    @Override
    public void actionCtrlUpdate_actionPerformed(ActionEvent e) throws Exception {
        BgFormCollection bgformCol;
        super.actionCtrlUpdate_actionPerformed(e);
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        if (size == 0) {
            return;
        }
        ArrayList<String[]> idNameList = new ArrayList<String[]>();
        String idStr = "";
        BOSUuid id = null;
        String name = null;
        KDTSelectBlock sb = null;
        for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                id = (BOSUuid)this.tblMain.getRow(j).getCell(COL_ID).getValue();
                name = (String)this.tblMain.getRow(j).getCell(COL_NAME).getValue();
                String[] idName = new String[]{id.toString(), name};
                idStr = idStr + "'" + id.toString() + "',";
                if (idNameList.contains(idName)) continue;
                idNameList.add(idName);
            }
        }
        if (idNameList.isEmpty()) {
            return;
        }
        int isConfirm = MsgBox.showConfirm2((String)EASResource.getString((String)this.RESOURCE, (String)"confirmUpdateCtrl"));
        if (isConfirm != 0) {
            SysUtil.abort();
        }
        if ((bgformCol = this.getBgFormInterface().getBgFormCollection("select id where bgTemplate.id in(" + idStr.substring(0, idStr.length() - 1) + ")")).isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)this.RESOURCE, (String)"noBgformToUpdateCtrl"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)uiContext);
        if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
            ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
            ui.setShowTableMessage(true);
            this.initParameterValueForCtrlUpdate(ui, idNameList);
            ui.init();
            window.show();
        }
    }

    private void initParameterValueForCtrlUpdate(ProgressDialogUI ui, List idNameList) {
        Class[] cla = new Class[]{String.class, String.class, Boolean.TYPE, String.class, String.class};
        ui.setUITitle(EASResource.getString((String)this.RESOURCE, (String)"ctrlUpdate"));
        ui.setInvokeClass(this.getMetaDataPK().getFullName());
        ui.setInvokeMethod("invokeMethodCtrlUpdate");
        ui.setInvokeMethodParmeterType(cla);
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        Object[] objOld = null;
        Object[] objNew = null;
        String[] idName = null;
        for (int i = 0; i < idNameList.size(); ++i) {
            idName = (String[])idNameList.get(i);
            if (objOld != null) {
                objNew = new Object[]{objOld[0], objOld[1], Boolean.TRUE, idName[0], idName[1]};
                objOld = new Object[]{idName[0], idName[1], Boolean.FALSE};
            } else {
                objOld = new Object[]{idName[0], idName[1], Boolean.FALSE};
                objNew = new Object[]{idName[0], idName[1], Boolean.FALSE, idName[0], idName[1]};
            }
            vecPrameterValue.add(objNew);
        }
        if (objOld != null) {
            objNew = new Object[]{objOld[0], objOld[1], Boolean.TRUE, idName[0], idName[1]};
            vecPrameterValue.add(objNew);
        }
        int size = vecPrameterValue.size();
        if (objNew != null) {
            int objNewlength = objNew.length;
            Object[][] valueMethod = new Object[size][objNewlength];
            for (int i = 0; i < size; ++i) {
                Object[] obj = (Object[])vecPrameterValue.get(i);
                for (int j = 0; j < objNewlength; ++j) {
                    valueMethod[i][j] = obj[j];
                }
            }
            ui.setInvokeMethodParmeterValue(valueMethod);
        }
        ui.setCountSum(vecPrameterValue.size() - 1);
    }

    public Object invokeMethodCtrlUpdate(String tIdCur, String tNameCur, boolean isTrueUpdate, String tIdNxt, String tNameNxt) throws Exception {
        Object[] obj = new Object[2];
        List list = null;
        try {
            IBgCtrSettingFacade ibgc = this.getBgCtrSettingFacadeInterface();
            if (tIdCur != null && tNameCur != null && tIdNxt != null && tNameNxt != null && isTrueUpdate) {
                list = ibgc.ctrlUpdate(BOSUuid.read((String)tIdCur));
                obj[1] = list;
            }
        }
        catch (Exception exc) {
            if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"172_BgCollectFormEditUI"));
            }
            throw exc;
        }
        obj[0] = MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"ctrlUpdating"), tNameCur);
        return obj;
    }

    @Override
    public void actionCtrlAssign_actionPerformed(ActionEvent e) throws Exception {
        int isConfirm;
        super.actionCtrlAssign_actionPerformed(e);
        this.checkSelected();
        int size = this.tblMain.getSelectManager().size();
        if (size == 0) {
            return;
        }
        ArrayList<String[]> idNameList = new ArrayList<String[]>();
        BOSUuid id = null;
        String idStr = "";
        String name = null;
        BgFormDataSourceEnum dataSource = null;
        KDTSelectBlock sb = null;
        block0: for (int i = 0; i < size; ++i) {
            sb = this.tblMain.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                id = (BOSUuid)this.tblMain.getRow(j).getCell(COL_ID).getValue();
                name = (String)this.tblMain.getRow(j).getCell(COL_NAME).getValue();
                String[] idName = new String[]{id.toString(), name};
                if (!idNameList.contains(idName)) {
                    idNameList.add(idName);
                }
                idStr = idStr + "'" + id.toString() + "',";
                if (StringUtils.isEmpty((String)this.selectedItem) || !this.selectedItem.equals("SELECTED_ITEM_BGFORM")) continue;
                dataSource = (BgFormDataSourceEnum)((Object)this.tblMain.getRow(j).getCell(COL_DATA_SOURCE).getValue());
                continue block0;
            }
        }
        if (idNameList.isEmpty()) {
            return;
        }
        if (!StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            isConfirm = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"confirmAssignCtrl"));
            if (isConfirm != 0) {
                SysUtil.abort();
            }
            String fid = idStr.substring(0, idStr.length() - 1);
            BgTemplateCollection templateCol = this.getBgTemplateInterface().getBgTemplateCollection("select id where parent in (" + fid + ")");
            if (templateCol == null || templateCol.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"noSubTemplateToAssignCtrl"));
                SysUtil.abort();
            }
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)uiContext);
            if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
                ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
                ui.setShowTableMessage(true);
                this.initParameterValueForCtrlAssignTemplate(ui, idNameList);
                ui.init();
                window.show();
            }
        } else if (!StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            isConfirm = MsgBox.showConfirm2((String)EASResource.getString((String)this.RESOURCE, (String)"confirmAssignCtrl"));
            if (isConfirm != 0) {
                SysUtil.abort();
            }
            if (dataSource != null && !dataSource.equals((Object)BgFormDataSourceEnum.FORMCOLLECT)) {
                throw new BgSchemeAssignException(BgSchemeAssignException.FORM_IS_NOT_COLLECT);
            }
            UIContext uiContext = new UIContext((Object)this);
            IUIWindow window = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ProgressDialogUI.class.getName(), (Map)uiContext);
            if (window != null && window.getUIObject() instanceof ProgressDialogUI) {
                ProgressDialogUI ui = (ProgressDialogUI)window.getUIObject();
                ui.setShowTableMessage(true);
                this.initParameterValueForCtrlAssignBgForm(ui, (String[])idNameList.get(0));
                ui.init();
                window.show();
            }
        }
    }

    private void initParameterValueForCtrlAssignBgForm(ProgressDialogUI ui, String[] idName) {
        Class[] cla = new Class[]{String.class};
        ui.setUITitle(EASResource.getString((String)this.RESOURCE, (String)"ctrlAssign"));
        ui.setInvokeClass(this.getMetaDataPK().getFullName());
        ui.setInvokeMethod("invokeMethodCtrlAssignBgForm");
        ui.setInvokeMethodParmeterType(cla);
        Object[][] valueMethod = new Object[1][1];
        valueMethod[0][0] = idName[0] + "," + idName[1];
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(1);
    }

    public SelectorItemCollection getTemplateSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        return sic;
    }

    private void initParameterValueForCtrlAssignTemplate(ProgressDialogUI ui, List idNameList) throws BOSException, EASBizException {
        Class[] cla = new Class[]{String.class, String.class, BgTemplateInfo.class, String.class};
        ui.setUITitle(EASResource.getString((String)this.RESOURCE, (String)"ctrlAssign"));
        ui.setInvokeClass(((Object)((Object)this)).getClass().getName());
        ui.setInvokeMethod("invokeMethodCtrlAssignTemplate");
        ui.setInvokeMethodParmeterType(cla);
        Vector<Object[]> vecPrameterValue = new Vector<Object[]>();
        Object[] objNew = null;
        String[] idName = null;
        String bgformId = null;
        String bgTemplateId = null;
        String parentId = null;
        BgTemplateInfo subTemplate2 = null;
        BgFormInfo bgFormInfo = null;
        HashMap bgTemplateMap = new HashMap();
        Map<String, BgTemplateInfo> subTemplateMap = null;
        HashMap<String, BgFormCollection> bgFormMap = new HashMap<String, BgFormCollection>();
        HashSet<String> bgTemplateIds = new HashSet<String>();
        for (int i = 0; i < idNameList.size(); ++i) {
            idName = (String[])idNameList.get(i);
            bgTemplateIds.add(idName[0]);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(this.getTemplateSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rootId", bgTemplateIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", bgTemplateIds, CompareType.INCLUDE));
        filter.setMaskString("(#0 or #1)");
        evi.setFilter(filter);
        BgTemplateCollection bgTemplateCol = BgTemplateFactory.getRemoteInstance().getBgTemplateCollection(evi);
        if (!bgTemplateCol.isEmpty()) {
            BgFormCollection subFormCol;
            int i;
            for (int i2 = 0; i2 < bgTemplateCol.size(); ++i2) {
                subTemplate2 = bgTemplateCol.get(i2);
                bgTemplateId = subTemplate2.getId().toString();
                if (bgTemplateIds.contains(bgTemplateId) || (parentId = bgTemplateIds.contains(subTemplate2.getRootId().toString()) ? subTemplate2.getRootId().toString() : (subTemplate2.getParent() != null ? subTemplate2.getParent().getId().toString() : null)) == null) continue;
                if (bgTemplateMap.containsKey(parentId)) {
                    subTemplateMap = (Map)bgTemplateMap.get(parentId);
                } else {
                    subTemplateMap = new LinkedHashMap();
                    bgTemplateMap.put(parentId, subTemplateMap);
                }
                subTemplateMap.put(subTemplate2.getId().toString(), subTemplate2);
            }
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("name");
            evi.getSelector().add("number");
            evi.getSelector().add("bgPeriod.number");
            evi.getSelector().add("currency.number");
            evi.getSelector().add("bgTemplate.id");
            evi.getSelector().add("state");
            evi.setFilter(new FilterInfo());
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootId", bgTemplateIds, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.parent.id", bgTemplateIds, CompareType.INCLUDE));
            HashSet<Integer> states = new HashSet<Integer>();
            states.add(15);
            states.add(4);
            filter.getFilterItems().add(new FilterItemInfo("state", states, CompareType.NOTINCLUDE));
            evi.setSorter(new SorterItemCollection());
            evi.getSorter().add(new SorterItemInfo("number"));
            BgFormCollection bgFormCol = BgFormFactory.getRemoteInstance().getBgFormCollection(evi);
            for (i = 0; i < bgFormCol.size(); ++i) {
                bgFormInfo = bgFormCol.get(i);
                bgTemplateId = bgFormInfo.getBgTemplate().getId().toString();
                if (!bgFormMap.containsKey(bgTemplateId)) {
                    bgFormMap.put(bgTemplateId, new BgFormCollection());
                }
                subFormCol = (BgFormCollection)((Object)bgFormMap.get(bgTemplateId));
                subFormCol.add(bgFormInfo);
            }
            for (i = 0; i < idNameList.size(); ++i) {
                idName = (String[])idNameList.get(i);
                subTemplateMap = (Map)bgTemplateMap.get(idName[0]);
                if (subTemplateMap == null || subTemplateMap.isEmpty()) continue;
                for (BgTemplateInfo subTemplate2 : subTemplateMap.values()) {
                    bgformId = null;
                    objNew = new Object[]{idName[0], idName[1], subTemplate2, bgformId};
                    vecPrameterValue.add(objNew);
                    subFormCol = (BgFormCollection)((Object)bgFormMap.get(subTemplate2.getId().toString()));
                    if (subFormCol == null || subFormCol.isEmpty()) continue;
                    Iterator it2 = subFormCol.iterator();
                    while (it2.hasNext()) {
                        bgFormInfo = (BgFormInfo)it2.next();
                        bgformId = bgFormInfo.getId().toString();
                        objNew = new Object[]{idName[0], idName[1], subTemplate2, bgformId};
                        vecPrameterValue.add(objNew);
                    }
                }
            }
        }
        if (objNew == null) {
            return;
        }
        int size = vecPrameterValue.size();
        int objNewlength = objNew.length;
        Object[][] valueMethod = new Object[size][objNewlength];
        for (int i = 0; i < size; ++i) {
            Object[] obj = (Object[])vecPrameterValue.get(i);
            for (int j = 0; j < objNewlength; ++j) {
                valueMethod[i][j] = obj[j];
            }
        }
        ui.setInvokeMethodParmeterValue(valueMethod);
        ui.setCountSum(vecPrameterValue.size());
    }

    public Object invokeMethodCtrlAssignTemplate(String tIdCur, String tNameCur, BgTemplateInfo objTemplate, String objFormId) throws Exception {
        Object[] obj = new Object[2];
        List list = null;
        try {
            IBgCtrSettingFacade ibgc = this.getBgCtrSettingFacadeInterface();
            if (tIdCur != null && tNameCur != null) {
                list = ibgc.ctrlAssignTemplate(BOSUuid.read((String)tIdCur), objTemplate, objFormId);
                obj[1] = list;
            }
        }
        catch (Exception exc) {
            if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"172_BgCollectFormEditUI"));
            }
            throw exc;
        }
        obj[0] = MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"ctrlAssigning"), tNameCur);
        return obj;
    }

    public Object invokeMethodCtrlAssignBgForm(String idName) throws Exception {
        if (StringUtils.isEmpty((String)idName)) {
            return null;
        }
        String[] s = idName.split(",");
        Object[] obj = new Object[2];
        List list = null;
        try {
            IBgCtrSettingFacade ibgc = this.getBgCtrSettingFacadeInterface();
            list = ibgc.ctrlAssignBgForm(BOSUuid.read((String)s[0]));
            obj[1] = list;
        }
        catch (Exception exc) {
            if (Utils.isRPCException((Throwable)exc) && Utils.getRPCErrorCode((Throwable)exc) == 1002 || exc instanceof IllegalSessionStateException || Utils.isRPCException((Throwable)exc) && exc.getCause() instanceof IllegalStateException && exc.getCause().getMessage().indexOf("Cannot found session info") != -1) {
                throw new BOSException(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"172_BgCollectFormEditUI"));
            }
            throw exc;
        }
        obj[0] = MessageFormat.format(EASResource.getString((String)this.RESOURCE, (String)"ctrlAssigning"), s[1]);
        return obj;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (!this.isFirstDefaultQuery()) {
            this.dialog = this.getCommonQueryDialog();
            if (this.dialog.show()) {
                this.isFromQuery = true;
                CustomerParams params = this.getFilterUI().getCustomerParams();
                this.setFilterParam(params);
                this.execQuery();
                this.isFromQuery = false;
            } else {
                SysUtil.abort();
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        BgNFSHelper.setTableSort((KDTMouseEvent)e, (KDTable)this.tblMain);
        if (e.getClickCount() == 2) {
            BOSUuid id = null;
            int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row != null) {
                id = (BOSUuid)row.getCell(COL_ID).getValue();
            }
            Map ctrlSetting = null;
            if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
                ctrlSetting = this.getBgCtrSettingFacadeInterface().getTemplateCtrlSetting(id, null);
                BgTemplateInfo template = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo((IObjectPK)new ObjectUuidPK(id));
                if (template != null) {
                    BgCtrlSetHelper.fillNoCtrlRecord(template.getBook(), ctrlSetting);
                }
            } else if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
                ctrlSetting = this.getBgCtrSettingFacadeInterface().getBgFormCtrlSetting(id, null, false);
            }
            if (ctrlSetting == null) {
                return;
            }
            Hashtable ctrlModeMap = (Hashtable)ctrlSetting.get("ctrlModeMap");
            Vector itemAndElement = (Vector)ctrlSetting.get("itemAndElement");
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", null);
            uiContext.put((Object)"ctrlModeMap", (Object)ctrlModeMap);
            uiContext.put((Object)"itemAndElement", (Object)itemAndElement);
            uiContext.put((Object)"SELECTED_ITEM", (Object)this.selectedItem);
            uiContext.put((Object)"selectedItem_id", (Object)id);
            uiContext.put((Object)"orgUnitId", (Object)this.getOrgUnitId());
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.ma.budget.client.NewCtrlSetEditUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    protected void CoreUI_componentShown(ComponentEvent e) throws Exception {
        super.CoreUI_componentShown(e);
        if (!this.isUpgrade) {
            this.doUpgrade();
            this.isUpgrade = true;
        }
    }

    protected void doUpgrade() throws Exception {
        int re = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.RESOURCE, (String)"upgradeWarning"));
        if (re == 0) {
            LongTimeDialog dialog = null;
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (win instanceof Frame) {
                dialog = new LongTimeDialog((Frame)win);
            } else if (win instanceof Dialog) {
                dialog = new LongTimeDialog((Dialog)win);
            }
            if (dialog == null) {
                return;
            }
            dialog.setLongTimeTask(new ILongTimeTask(){

                public Object exec() throws Exception {
                    BgCtrSettingListUI.this.getBgCtrSettingFacadeInterface().restoreOldSetting();
                    return "";
                }

                public void afterExec(Object result) throws Exception {
                    MsgBox.showInfo((String)EASResource.getString((String)BgCtrSettingListUI.this.RESOURCE, (String)"upgradeFinished"));
                }
            });
            dialog.show();
        }
    }

    @Override
    public void actionSelectCtrlSet_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BOSUuid id = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            id = (BOSUuid)row.getCell(COL_ID).getValue();
        }
        UIContext uiContext = new UIContext((Object)this);
        FullOrgUnitInfo orgInfo = this.getBGOrgUnitInfo();
        uiContext.put((Object)"ORGUNIT_INFO", (Object)orgInfo);
        uiContext.put((Object)"ORGUNIT_CU", (Object)orgInfo.getCU());
        uiContext.put((Object)"ctrlrRange", (Object)"ctrlrRangeSet");
        if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            BgTemplateInfo bgTemplate = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo("select id, formType where id = '" + id + "'");
            uiContext.put((Object)"ID", (Object)id);
            uiContext.put((Object)"isFromTemplate", (Object)Boolean.TRUE);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgTemplate.getFormType()) ? "com.kingdee.eas.ma.view.client.BgViewTemplateCtrlUI" : BgNTemplateCtrlProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo("select id, bgTemplate.formType where id = '" + id + "'");
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) ? "com.kingdee.eas.ma.view.client.BgReportViewCtrlProcessUI" : BgNFormCtrlProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }

    @Override
    public void actionSelectCtrlView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BOSUuid id = null;
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            id = (BOSUuid)row.getCell(COL_ID).getValue();
        }
        UIContext uiContext = new UIContext((Object)this);
        FullOrgUnitInfo orgInfo = this.getBGOrgUnitInfo();
        uiContext.put((Object)"ORGUNIT_INFO", (Object)orgInfo);
        uiContext.put((Object)"ORGUNIT_CU", (Object)orgInfo.getCU());
        uiContext.put((Object)"ctrlrRange", (Object)"ctrlrRangeView");
        if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGTEMPLATE")) {
            BgTemplateInfo bgTemplate = BgTemplateFactory.getRemoteInstance().getBgTemplateInfo("select id, formType where id = '" + id + "'");
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgTemplate.getFormType()) ? "com.kingdee.eas.ma.view.client.BgViewTemplateCtrlUI" : BgNTemplateCtrlProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else if (id != null && !StringUtils.isEmpty((String)this.selectedItem) && this.selectedItem.equals("SELECTED_ITEM_BGFORM")) {
            BgFormInfo bgForm = BgFormFactory.getRemoteInstance().getBgFormInfo("select id, bgTemplate.formType where id = '" + id + "'");
            uiContext.put((Object)"ID", (Object)id);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType()) ? "com.kingdee.eas.ma.view.client.BgReportViewCtrlProcessUI" : BgNFormCtrlProcessUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        }
    }
}

