/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgCtrlBizParamCollection;
import com.kingdee.eas.ma.budget.BgCtrlBizParamEnum;
import com.kingdee.eas.ma.budget.BgCtrlBizParamFactory;
import com.kingdee.eas.ma.budget.BgCtrlBizParamInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgCtrlBizParamUI;
import com.kingdee.eas.ma.budget.client.BgCtrlBizParamListUI;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BgCtrlBizParamUI
extends AbstractBgCtrlBizParamUI {
    private static final long serialVersionUID = -6725114295587333262L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlBizParamUI.class);
    private final int DEFAULT_LEVEL = 2;
    private static final String INCLUDE_SUB = "isIncludeSub";
    private static final String ORG_NUMBER = "orgUnit.number";
    private static final String ORG_NAME = "orgUnit.name";
    private static final String PARAM_VALUE = "param.value";
    private static final String CAN_MODIFY = "canModify";
    private static final String ORG_LONG_NUMBER = "orgUnit.longNumber";
    private static final String ORG_INFO = "orgUnit.info";
    private static final String PARAMITEMINFO = "paramInfo";
    private static final String SUPERIOR_CONTROL_ID = "superiorControlID";
    public static final String BO_NAME = "boName";

    public void onLoad() throws Exception {
        super.onLoad();
        this.limitLevel(new Integer(2));
        this.loadParam();
    }

    protected void checkTableParsed() {
        super.checkTableParsed();
        this.kdTable.checkParsed();
        KDComboBox cb = new KDComboBox();
        cb.addItems(BgCtrlBizParamEnum.getEnumList().toArray());
        cb.putClientProperty((Object)"jump", (Object)"false");
        this.kdTable.getColumn(PARAM_VALUE).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cb));
    }

    private void limitLevel(Integer level) {
        this.spnLevel.setValue((Object)level);
        this.spnLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (Integer.valueOf(BgCtrlBizParamUI.this.spnLevel.getValue().toString()).compareTo(new Integer(2)) == -1) {
                    BgCtrlBizParamUI.this.spnLevel.setValue((Object)new Integer(2));
                }
            }
        });
    }

    private void loadParam() throws EASBizException, BOSException {
        this.init(this.getOrgAndParamControlMap());
    }

    private Map getOrgAndParamControlMap() throws EASBizException, BOSException {
        String orgUnitId = (String)this.getUIContext().get("ORGUNIT_ID");
        String boName = (String)this.getUIContext().get(BO_NAME);
        return BgCtrlBizParamFactory.getRemoteInstance().getOrgAndParamControlMap(boName, orgUnitId, (Integer)this.spnLevel.getValue());
    }

    private void init(Map<FullOrgUnitInfo, BgCtrlBizParamInfo> orgAndParamControlInfoMap) throws BOSException, EASBizException {
        this.kdTable.removeRows();
        if (orgAndParamControlInfoMap == null || orgAndParamControlInfoMap.isEmpty()) {
            return;
        }
        Iterator<FullOrgUnitInfo> it = orgAndParamControlInfoMap.keySet().iterator();
        while (it.hasNext()) {
            IRow row = this.kdTable.addRow();
            row.getStyleAttributes().setLocked(true);
            FullOrgUnitInfo orgUnitInfo = it.next();
            BgCtrlBizParamInfo info = orgAndParamControlInfoMap.get(orgUnitInfo);
            info.copyNewToOld();
            row.getCell(ORG_INFO).setValue((Object)orgUnitInfo);
            row.getCell(PARAM_VALUE).setValue((Object)info.getValue());
            ICell includeSubCell = row.getCell(INCLUDE_SUB);
            includeSubCell.setValue((Object)info.isIsIncludeSub());
            row.getCell(ORG_NUMBER).setValue((Object)orgUnitInfo.getNumber());
            row.getCell(ORG_NAME).setValue((Object)orgUnitInfo.getName());
            ICell canModifyCell = row.getCell(CAN_MODIFY);
            canModifyCell.setValue((Object)info.isCanModify());
            row.getCell(ORG_LONG_NUMBER).setValue((Object)orgUnitInfo.getLongNumber());
            row.getCell(PARAMITEMINFO).setValue((Object)info);
            ICell valueCell = row.getCell(PARAM_VALUE);
            String superiorControlID = info.getSuperiorControlID();
            row.getCell(SUPERIOR_CONTROL_ID).setValue((Object)superiorControlID);
            if (!StringUtils.isEmpty((String)superiorControlID)) {
                row.getStyleAttributes().setLocked(true);
                row.getStyleAttributes().setBackground(Color.GRAY);
                if (!info.isCanModify()) continue;
                valueCell.getStyleAttributes().setLocked(false);
                valueCell.getStyleAttributes().setBackground(Color.white);
                continue;
            }
            includeSubCell.getStyleAttributes().setLocked(false);
            valueCell.getStyleAttributes().setLocked(false);
            canModifyCell.getStyleAttributes().setLocked(false);
        }
    }

    @Override
    protected void kdTable_editStopped(KDTEditEvent e) throws Exception {
        super.kdTable_editStopped(e);
        if (PARAM_VALUE.equals(this.kdTable.getColumnKey(e.getColIndex()))) {
            this.checkValue(e);
        }
    }

    private void checkValue(KDTEditEvent e) {
        IRow row = this.kdTable.getRow(e.getRowIndex());
        if (Boolean.TRUE.equals(row.getCell(INCLUDE_SUB).getValue())) {
            Object value = this.kdTable.getCell(e.getRowIndex(), PARAM_VALUE).getValue();
            if (value == null) {
                return;
            }
            String clickRow_longNumber = (String)this.kdTable.getCell(e.getRowIndex(), ORG_LONG_NUMBER).getValue();
            int j = this.kdTable.getRowCount();
            for (int i = e.getRowIndex(); i < j; ++i) {
                IRow iRow = this.kdTable.getRow(i);
                String longNumber = (String)iRow.getCell(ORG_LONG_NUMBER).getValue();
                BgCtrlBizParamInfo subParamItemInfo = (BgCtrlBizParamInfo)iRow.getCell(PARAMITEMINFO).getValue();
                if (!longNumber.startsWith(clickRow_longNumber + "!")) continue;
                iRow.getCell(PARAM_VALUE).setValue(value);
            }
        }
    }

    @Override
    protected void kdTable_editValueChanged(KDTEditEvent e) throws Exception {
        super.kdTable_editValueChanged(e);
        if (INCLUDE_SUB.equals(this.kdTable.getColumnKey(e.getColIndex()))) {
            this.afterIncludeSubChanged(e);
        } else if (CAN_MODIFY.equals(this.kdTable.getColumnKey(e.getColIndex()))) {
            this.afterCanModifyChanged(e);
        }
    }

    private void afterCanModifyChanged(KDTEditEvent e) {
        IRow row = this.kdTable.getRow(e.getRowIndex());
        if (row.getCell(INCLUDE_SUB).getValue().equals(Boolean.TRUE)) {
            Object value = this.kdTable.getCell(e.getRowIndex(), CAN_MODIFY).getValue();
            String clickRow_longNumber = (String)this.kdTable.getCell(e.getRowIndex(), ORG_LONG_NUMBER).getValue();
            int j = this.kdTable.getRowCount();
            for (int i = e.getRowIndex(); i < j; ++i) {
                IRow iRow = this.kdTable.getRow(i);
                String longNumber = (String)iRow.getCell(ORG_LONG_NUMBER).getValue();
                if (!longNumber.startsWith(clickRow_longNumber + "!")) continue;
                if (value.equals(Boolean.TRUE)) {
                    iRow.getCell(CAN_MODIFY).setValue((Object)Boolean.FALSE);
                    continue;
                }
                iRow.getCell(CAN_MODIFY).setValue((Object)Boolean.TRUE);
            }
        }
        this.btnRefresh.requestFocus();
    }

    private void afterIncludeSubChanged(KDTEditEvent e) {
        String currLongNumber = (String)this.kdTable.getCell(e.getRowIndex(), ORG_LONG_NUMBER).getValue();
        Boolean canModify = (Boolean)this.kdTable.getCell(e.getRowIndex(), CAN_MODIFY).getValue();
        if (Boolean.TRUE.equals(e.getValue())) {
            this.kdTable.getCell(e.getRowIndex(), PARAM_VALUE).getStyleAttributes().setLocked(false);
            this.autoSelectSub(Boolean.TRUE, currLongNumber, canModify, e);
        } else {
            this.kdTable.getCell(e.getRowIndex(), PARAM_VALUE).getStyleAttributes().setLocked(false);
            this.autoSelectSub(Boolean.FALSE, currLongNumber, null, e);
        }
        this.btnRefresh.requestFocus();
    }

    private void autoSelectSub(boolean flag, String currLongNumber, Boolean canModify, KDTEditEvent e) {
        int sizeOfTable = this.kdTable.getRowCount();
        for (int i = 0; i < sizeOfTable; ++i) {
            IRow row = this.kdTable.getRow(i);
            String longNumber = (String)row.getCell(ORG_LONG_NUMBER).getValue();
            if (!longNumber.startsWith(currLongNumber + "!") || row.getStyleAttributes().getBackground().equals(Color.LIGHT_GRAY)) continue;
            this.kdTable.getCell(i, INCLUDE_SUB).setValue((Object)false);
            ICell iCell = row.getCell(PARAM_VALUE);
            ICell iCell2 = this.kdTable.getCell(e.getRowIndex(), PARAM_VALUE);
            if (flag) {
                row.getStyleAttributes().setBackground(Color.GRAY);
                row.getCell(INCLUDE_SUB).getStyleAttributes().setLocked(true);
                row.getCell(CAN_MODIFY).getStyleAttributes().setLocked(true);
                iCell.getStyleAttributes().setLocked(true);
                iCell.setValue(iCell2.getValue());
            } else {
                row.getStyleAttributes().setBackground(Color.WHITE);
                row.getStyleAttributes().setLocked(true);
                row.getCell(INCLUDE_SUB).getStyleAttributes().setLocked(false);
                row.getCell(CAN_MODIFY).getStyleAttributes().setLocked(false);
                row.getCell(CAN_MODIFY).setValue((Object)Boolean.TRUE);
            }
            if (canModify == null) continue;
            this.kdTable.getCell(i, CAN_MODIFY).setValue((Object)canModify);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        for (int i = 0; i < this.kdTable.getRowCount(); ++i) {
            IRow row = this.kdTable.getRow(i);
            BgCtrlBizParamInfo info = (BgCtrlBizParamInfo)row.getCell(PARAMITEMINFO).getValue();
            info.setValue((BgCtrlBizParamEnum)((Object)row.getCell(PARAM_VALUE).getValue()));
            info.setIsIncludeSub(Boolean.TRUE.equals(row.getCell(INCLUDE_SUB).getValue()));
            info.setCanModify(Boolean.TRUE.equals(row.getCell(CAN_MODIFY).getValue()));
            info.setSuperiorControlID((String)row.getCell(SUPERIOR_CONTROL_ID).getValue());
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
        this.storeFields();
        BgCtrlBizParamCollection paramCol = new BgCtrlBizParamCollection();
        for (int i = 0; i < this.kdTable.getRowCount(); ++i) {
            IRow row = this.kdTable.getRow(i);
            BgCtrlBizParamInfo info = (BgCtrlBizParamInfo)row.getCell(PARAMITEMINFO).getValue();
            if (!info.isValueChange()) continue;
            paramCol.add(info);
        }
        if (!paramCol.isEmpty()) {
            BgCtrlBizParamFactory.getRemoteInstance().saveParam(paramCol);
        }
        if (this.getUIContext().get("Owner") instanceof BgCtrlBizParamListUI) {
            ((BgCtrlBizParamListUI)((Object)this.getUIContext().get("Owner"))).execQuery();
        }
        this.getUIWindow().close();
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.btnRefresh_actionPerformed(e);
        this.loadParam();
    }
}

