/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.AssignSolutionCollection;
import com.kingdee.eas.ma.budget.AssignSolutionFactory;
import com.kingdee.eas.ma.budget.AssignSolutionInfo;
import com.kingdee.eas.ma.budget.AssignSolutionTypeEnum;
import com.kingdee.eas.ma.budget.BgControlSchemeCollection;
import com.kingdee.eas.ma.budget.BgControlSchemeFactory;
import com.kingdee.eas.ma.budget.BgControlSchemeInfo;
import com.kingdee.eas.ma.budget.IBgControlScheme;
import com.kingdee.eas.ma.budget.OrgUnitUtils;
import com.kingdee.eas.ma.budget.client.AbstractBgCtrlSchemeAssignChildUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionInterface;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgCtrlSchemeSearchKeyEnum;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgOrgTypeViewEnum;
import com.kingdee.eas.ma.nbudget.BgOrgUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class BgCtrlSchemeAssignChildUI
extends AbstractBgCtrlSchemeAssignChildUI
implements PropertyChangeListener,
AssignSolutionInterface {
    private static final long serialVersionUID = -8148307109125646886L;
    private static final Logger logger = CoreUIObject.getLogger(BgCtrlSchemeAssignChildUI.class);
    private boolean hasNotChooseTemAndOrg = true;
    private boolean isSelectTemAll = false;
    private TreeModel treeModelOld = null;
    private Hashtable temMap = new Hashtable();
    private static final String RESOURCE = "com.kingdee.eas.ma.budget.client.BgSchemeResource";
    private Map storeStateCache = new HashMap();
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String selectedOldTableItemID;
    private OrgUnitInfo org = null;
    private static boolean isFinSelected = false;
    private static final Color NO_DISPATCHED = Color.BLACK;
    private static final Color NOFINANCE = Color.GRAY;
    public static final String RES_PATH = "com.kingdee.eas.ma.nbudget.BgSchemeUnAssignResource";
    KDPopupMenu popMenu = new KDPopupMenu();
    private int count = 0;
    private TreeWillExpandListener listener = new TreeWillExpandListener(){

        @Override
        public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)event.getPath().getLastPathComponent();
            try {
                String controlSchemeId = BgCtrlSchemeAssignChildUI.this.getControlSchemeId();
                Set<String> assOrgSet = BgCtrlSchemeAssignChildUI.this.getAssOrgMap().get(controlSchemeId);
                OrgUnitUtils.addChildNode(node, assOrgSet, false, isFinSelected);
            }
            catch (Exception e) {
                BgCtrlSchemeAssignChildUI.this.handUIExceptionAndAbort(e);
            }
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        }
    };
    private Map<String, Set<String>> assOrgMap = new HashMap<String, Set<String>>();

    public void onLoad() throws Exception {
        super.onLoad();
        isFinSelected = false;
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BgCtrlSchemeAssignChildUI.this.action_search();
                }
                catch (Exception e) {
                    BgCtrlSchemeAssignChildUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        this.btnSelectNow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    BgCtrlSchemeAssignChildUI.this.action_selectNowTemp(arg0);
                }
                catch (Exception e) {
                    BgCtrlSchemeAssignChildUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
        this.initComBoxOrgType();
        this.refreshOrgUnitTree();
        this.initTable(null, null, null);
        this.support.addPropertyChangeListener("selectedOldTableItemID", this);
        this.iniPoppMenu();
        this.kDComboBox1.addItem((Object)BgOrgTypeViewEnum.All);
        this.kDComboBox1.addItem((Object)BgOrgTypeViewEnum.company);
        this.kDComboBox1.addItemListener((ItemListener)new OrgListener());
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
    }

    public void iniPoppMenu() {
        this.treeOrgUnit.addMouseListener((MouseListener)new TreePopupMenuListener());
        KDMenuItem menu = new KDMenuItem();
        menu.setText(EASResource.getString((String)RES_PATH, (String)"selectSon"));
        menu.addActionListener((ActionListener)new TreeMenuListener());
        this.popMenu.add((JMenuItem)menu);
    }

    private ArrayList productArrayList(Object[] obj) {
        if (obj.length == 0) {
            return null;
        }
        ArrayList<Object> array = new ArrayList<Object>();
        for (int i = 0; i < obj.length; ++i) {
            array.add(obj[i]);
        }
        return array;
    }

    private void treeSonSelected(DefaultKingdeeTreeNode root, ArrayList list) {
        if (list.isEmpty()) {
            return;
        }
        if (list.get(list.size() - 1).toString().equals(root.getText()) || list.get(list.size() - 1).toString() == root.getText()) {
            this.selectDowmTree(root);
            return;
        }
        list.remove(0);
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (list.get(0).toString() != node.getText() && !list.get(0).toString().equals(node.getText())) continue;
            if (list.isEmpty()) {
                this.selectDowmTree(node);
                return;
            }
            this.treeSonSelected(node, list);
        }
    }

    private void selectDowmTree(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (!node.isCheckBoxEnabled()) continue;
            node.setChecked(true);
        }
    }

    private void action_selectNowTemp(ActionEvent arg0) {
        this.hasNotChooseTemAndOrg = false;
        KDTSelectBlock sb = null;
        int size = this.temTable.getSelectManager().size();
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size && i != this.temTable.getRowCount() - 1 - 1; ++i) {
            sb = this.temTable.getSelectManager().get(i);
            int bottom = sb.getBottom();
            for (int j = sb.getTop(); j <= bottom; ++j) {
                this.temTable.getRow(j).getCell("select").setValue((Object)true);
            }
        }
    }

    void action_search() throws Exception {
        TreeModel model;
        if (this.txtKey.getText() == null || this.txtKey.getText().trim().length() < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"195_BgCtrlSchemeAssignChildUI"));
            this.txtKey.requestFocus();
            return;
        }
        String value = this.txtKey.getText();
        BgCtrlSchemeSearchKeyEnum keyEnum = (BgCtrlSchemeSearchKeyEnum)((Object)this.comboSearchKey.getSelectedItem());
        long s = System.currentTimeMillis();
        logger.error((Object)(s + "ms"));
        if (keyEnum.getValue() == "13" || keyEnum.getValue() == "11") {
            OrgStructureInfo orginfo = (OrgStructureInfo)((DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot()).getUserObject();
            if (this.count == 0) {
                this.treeModelOld = BgNFSHelper.getOrgTreeModel((String)orginfo.getUnit().getId().toString());
                ++this.count;
            }
        }
        logger.error((Object)(System.currentTimeMillis() - s + "ms"));
        if (keyEnum.getValue() == "13") {
            model = null;
            model = BgOrgUtils.clipAndCloneTreeModel((TreeModel)this.treeModelOld, (String)"name", (String)value, (boolean)true);
            this.treeOrgUnit.setModel(model);
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)((DefaultKingdeeTreeNode)model.getRoot()));
        } else if (keyEnum.getValue() == "11") {
            model = null;
            model = BgOrgUtils.clipAndCloneTreeModel((TreeModel)this.treeModelOld, (String)"number", (String)value, (boolean)true);
            this.treeOrgUnit.setModel(model);
            this.treeOrgUnit.expandAllNodes(true, (TreeNode)((DefaultKingdeeTreeNode)model.getRoot()));
        } else if (keyEnum.getValue() == "21") {
            this.initTable(null, "number", value);
        } else if (keyEnum.getValue() == "23") {
            this.initTable(null, "name", value);
        }
        this.treeOrgUnit.repaint();
    }

    private void initTable(String bgCtrlSchemeId, String searchKey, String searchValue) throws Exception {
        this.temTable.checkParsed();
        this.temTable.removeRows();
        Object ids = this.getUIContext().get("IDS");
        if (ids == null) {
            return;
        }
        List _ids = (List)ids;
        BgControlSchemeCollection coll = this.getBgCtrlSchemeCol(_ids, searchKey, searchValue);
        for (int i = 0; i < coll.size(); ++i) {
            BgControlSchemeInfo info = coll.get(i);
            IRow row = this.temTable.addRow();
            row.getCell("id").setValue((Object)info.getId().toString());
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("number").setValue((Object)info.getNumber());
            row.getCell("name").setValue((Object)info.getName());
            row.getCell("sysName").setValue((Object)info.getSubSystemAlias());
            row.getCell("billName").setValue((Object)info.getBoAlias());
            this.storeStateCache.put(info.getId().toString(), null);
        }
        IRow row = this.temTable.addRow();
        row.getStyleAttributes().setHided(true);
    }

    private void initComBoxOrgType() {
        this.comBoxOrgType.addItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comBoxOrgType.setEditable(false);
        this.comBoxOrgType.setEnabled(false);
    }

    private void refreshOrgUnitTree() throws EASBizException, BOSException, SQLException {
        this.treeOrgUnit.setModel(null);
        OrgViewType orgViewType = (OrgViewType)this.comBoxOrgType.getSelectedItem();
        if (orgViewType == null) {
            return;
        }
        try {
            String rootUnitID = (String)this.getUIContext().get("CUID");
            this.treeModelOld = OrgUnitUtils.getOrgTreeModelWithCompany(this.treeOrgUnit, rootUnitID, this.listener);
            this.treeOrgUnit.setShowCheckBox(true);
            this.treeOrgUnit.setModel(this.treeModelOld);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeModelOld.getRoot();
            root.setCheckBoxVisible(false);
            root.setCheckBoxEnabled(false);
        }
        catch (Exception err) {
            this.handUIException(err);
        }
        if (this.treeOrgUnit.getRowCount() > 0) {
            this.treeOrgUnit.expandRow(0);
        }
    }

    void setTreeNodeSelected(DefaultKingdeeTreeNode parent, boolean selected) {
        parent.setChecked(selected);
        DefaultKingdeeTreeNode node = null;
        Enumeration children = parent.children();
        while (children.hasMoreElements()) {
            node = (DefaultKingdeeTreeNode)children.nextElement();
            this.setTreeNodeSelected(node, selected);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BgControlSchemeCollection getBgCtrlSchemeCol(List bgCtrlSchemeIds, String searchKey, String searchValue) throws BOSException, EASBizException, Exception {
        BgControlSchemeCollection result = new BgControlSchemeCollection();
        if (bgCtrlSchemeIds == null || bgCtrlSchemeIds.isEmpty()) {
            return result;
        }
        String rootUnitID = (String)this.getUIContext().get("CUID");
        String locale = LocaleUtils.getDefaultLocale().getDisplayName();
        String sql = "select FID,FNAME_" + locale + ",FNUMBER,FBOALIAS_" + locale + ",FSUBSYSTEMALIAS_" + locale + " from t_Bg_Bgcontrolscheme where fid in (";
        for (int i = 0; i < bgCtrlSchemeIds.size(); ++i) {
            String _id = bgCtrlSchemeIds.get(i).toString();
            sql = i != bgCtrlSchemeIds.size() - 1 ? sql + "'" + _id + "'," : sql + "'" + _id + "') ";
        }
        if (rootUnitID != null) {
            sql = sql + " and FCostCenterId = '" + rootUnitID + "'";
        }
        if (searchKey != null && searchKey.trim().length() > 0 && searchValue != null && searchValue.trim().length() > 0) {
            if (searchKey.equalsIgnoreCase("number")) {
                searchKey = "fnumber";
            } else if (searchKey.equalsIgnoreCase("name")) {
                searchKey = "fname_" + locale;
            }
            sql = sql + " and " + searchKey + " like '%" + searchValue + "%'";
        }
        sql = sql + " order by fnumber";
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            while (rs.next()) {
                BgControlSchemeInfo info = new BgControlSchemeInfo();
                info.setId(BOSUuid.read((String)rs.getString(1)));
                info.setNumber(rs.getString(3));
                info.setName(rs.getString(2));
                info.setSubSystemAlias(rs.getString(5));
                info.setBoAlias(rs.getString(4));
                result.add(info);
            }
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return result;
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        Object o;
        Iterator itr;
        boolean isAssignAll;
        this.validateSetting();
        HashMap<String, Map> bgCtrlSchemes = new HashMap<String, Map>();
        Map OUMap = this.getSelectedNodesInTree();
        boolean isSelect = false;
        int rowCount = this.temTable.getRowCount() - 1;
        for (int i = 0; i < rowCount; ++i) {
            if (this.temTable.getRow(i).getCell("select").getValue() == null || !(isSelect = ((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue())) continue;
            bgCtrlSchemes.put(this.temTable.getRow(i).getCell("id").getValue().toString(), OUMap);
        }
        int rowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
        if (rowID == -1 || rowID == this.temTable.getRowCount() - 1) {
            if (this.isSelectTemAll) {
                rowID = this.temTable.getRowCount() - 1 - 1;
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"196_BgCtrlSchemeAssignChildUI"));
                return;
            }
        }
        String keyID = this.temTable.getRow(rowID).getCell("id").getValue().toString();
        Map map = this.getSelectedNodesInTree();
        if (map.size() > 0) {
            this.storeStateCache.put(keyID, map);
        }
        if (isAssignAll = this.chBoxTogether.isSelected()) {
            if (bgCtrlSchemes != null) {
                itr = bgCtrlSchemes.keySet().iterator();
                while (itr.hasNext()) {
                    o = bgCtrlSchemes.get(itr.next());
                    if (o == null || !(o instanceof Map) || !((Map)o).isEmpty()) continue;
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"197_BgCtrlSchemeAssignChildUI"));
                    SysUtil.abort();
                }
            }
        } else if (this.storeStateCache != null) {
            if (this.storeStateCache.isEmpty()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"198_BgCtrlSchemeAssignChildUI"));
                SysUtil.abort();
            }
            itr = this.storeStateCache.keySet().iterator();
            while (itr.hasNext()) {
                o = this.storeStateCache.get(itr.next());
                if (o == null || !(o instanceof Map) || !((Map)o).isEmpty()) continue;
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"197_BgCtrlSchemeAssignChildUI"));
                SysUtil.abort();
            }
        }
        boolean isAllowModifyState = true;
        boolean isCanNotUpdate = true;
        if (this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected()) {
            isAllowModifyState = false;
        }
        if (this.chkCanUpdate.isSelected()) {
            isCanNotUpdate = false;
        }
        IBgControlScheme iCtrlScheme = BgControlSchemeFactory.getRemoteInstance();
        Map resultMap = null;
        if (isAssignAll) {
            int flag = this.checkNumberBeformAssign(bgCtrlSchemes);
            if (flag == -1 || flag == 0) {
                resultMap = iCtrlScheme.assignCtrlSchemes(bgCtrlSchemes, isAllowModifyState, isCanNotUpdate);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"199_BgCtrlSchemeAssignChildUI"));
            }
        } else {
            int flag = this.checkNumberBeformAssign(this.storeStateCache);
            if (flag == -1 || flag == 0) {
                resultMap = iCtrlScheme.assignCtrlSchemes(this.storeStateCache, isAllowModifyState, isCanNotUpdate);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"199_BgCtrlSchemeAssignChildUI"));
            }
        }
        this.clearSolutionList();
    }

    private int checkNumberBeformAssign(Map orgs) throws Exception {
        String ret = "";
        IBgControlScheme iCtrlScheme = BgControlSchemeFactory.getRemoteInstance();
        Map retMap = iCtrlScheme.checkNumberBeforeAssign(orgs);
        if (retMap == null || retMap.isEmpty()) {
            return -1;
        }
        Iterator itr = retMap.keySet().iterator();
        while (itr.hasNext()) {
            String csName = itr.next().toString();
            Map ccMap = (Map)retMap.get(csName);
            Iterator itr2 = ccMap.keySet().iterator();
            while (itr2.hasNext()) {
                String orgName = itr2.next().toString();
                ret = ret + MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgControlRuleResource", (String)"assignNumberRepeat"), orgName, csName) + "\n";
            }
        }
        if (ret == null || ret.length() == 0) {
            return -1;
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"203_BgCtrlSchemeAssignChildUI") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"204_BgCtrlSchemeAssignChildUI") + EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"205_BgCtrlSchemeAssignChildUI");
        int result = MsgBox.showConfirm3a((Component)((Object)this), (String)msg, (String)ret);
        return result;
    }

    private void validateSetting() {
        Map map;
        boolean isSelect = false;
        int rowCount = this.temTable.getRowCount() - 1;
        for (int i = 0; !(i >= rowCount || this.temTable.getRow(i).getCell("select").getValue() != null && (isSelect = ((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue())); ++i) {
        }
        if (!isSelect) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"196_BgCtrlSchemeAssignChildUI"));
            SysUtil.abort();
        }
        if ((map = this.getSelectedNodesInTree()) == null || map.isEmpty()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"198_BgCtrlSchemeAssignChildUI"));
            SysUtil.abort();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.storeStateCache.clear();
        this.destroyWindow();
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnSelectAll_actionPerformed(e);
        OrgUnitUtils.selectOrgUnitAllWithCompany((Component)((Object)this), this.treeOrgUnit, true, this.kDCheckBox1.isSelected());
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        OrgUnitUtils.selectOrgUnit(this.treeOrgUnit, false);
    }

    @Override
    protected void temTable_editStopped(KDTEditEvent e) throws Exception {
        super.temTable_editStopped(e);
    }

    @Override
    protected void temTable_editStarted(KDTEditEvent e) throws Exception {
        this.isSelectTemAll = false;
        this.hasNotChooseTemAndOrg = false;
        super.temTable_editStarted(e);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.chBoxTogether.setSelected(true);
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.setAllTreeNodesUncheckedOrChecked(root, false);
    }

    @Override
    protected void temTable_tableClicked(KDTMouseEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        int rowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
        if (rowID == this.temTable.getRowCount() - 1) {
            return;
        }
        int y = e.getColIndex();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (rowID != -1 && y != -1) {
            this.setDefaultColorForTreeNode(root);
            if (this.temTable.getColumnKey(y).equals("select")) {
                this.changeTableSelectValue(rowID);
            }
            String rootID = this.getTemRootId(rowID);
            Set<String> assignOrgSet = this.getAssOrgSet(rootID);
            this.setColorForNode(root, assignOrgSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<String> getAssOrgSet(String controlSchemeId) {
        HashSet<String> assignOrgSet = new HashSet<String>();
        if (controlSchemeId == null) {
            return assignOrgSet;
        }
        IRowSet rs = null;
        try {
            rs = SQLExecutorFactory.getRemoteInstance((String)("select FCostCenterID from T_BG_BgControlScheme where FRootId = '" + controlSchemeId + "' and FIsSysDefault = 0")).executeSQL();
            while (rs.next()) {
                assignOrgSet.add(rs.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        this.getAssOrgMap().put(controlSchemeId, assignOrgSet);
        return assignOrgSet;
    }

    protected Map<String, Set<String>> getAssOrgMap() {
        return this.assOrgMap;
    }

    private String getTemRootId(int rowID) {
        if (rowID == this.temTable.getRowCount() - 1) {
            return null;
        }
        String id = this.temTable.getRow(rowID).getCell("id").getValue().toString();
        return id;
    }

    private void setColorForNode(DefaultKingdeeTreeNode root, Set<String> assignOrgSet) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (oui == null) continue;
            String orgUnitID = oui.getUnit().getId().toString();
            if (assignOrgSet != null && assignOrgSet.contains(orgUnitID)) {
                node.setTextColor(Color.red);
            }
            if (node.isLeaf()) continue;
            this.setColorForNode(node, assignOrgSet);
        }
    }

    private void setDefaultColorForTreeNode(DefaultKingdeeTreeNode rootNode) {
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(Color.BLACK);
            if (node.isLeaf()) continue;
            this.setDefaultColorForTreeNode(node);
        }
    }

    private Map getSelectedNodesInTree() {
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        HashMap map = new HashMap();
        this.deepViewTree(map, root);
        return map;
    }

    private void changeTableSelectValue(int rowID) {
        if (rowID == this.temTable.getRowCount() - 1) {
            return;
        }
        boolean isSelected = Boolean.valueOf(this.temTable.getRow(rowID).getCell("select").getValue().toString());
        if (isSelected) {
            this.temTable.getRow(rowID).getCell("select").setValue((Object)Boolean.FALSE);
        } else {
            this.temTable.getRow(rowID).getCell("select").setValue((Object)Boolean.TRUE);
        }
    }

    private void setSelectedNodesForTree(Map map, DefaultKingdeeTreeNode root) {
        if (map == null || map.size() == 0) {
            this.setAllTreeNodesUncheckedOrChecked(root, false);
        } else {
            Enumeration children = root.children();
            Set keySet = map.keySet();
            Object[] key = null;
            key = keySet.toArray();
            while (children.hasMoreElements()) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
                boolean isContains = false;
                int size = key.length;
                for (int i = 0; i < size; ++i) {
                    DefaultKingdeeTreeNode nodeTem = (DefaultKingdeeTreeNode)key[i];
                    if (nodeTem.getUserObject() == null || !(nodeTem.getUserObject() instanceof OrgStructureInfo) || node.getUserObject() == null || !(node.getUserObject() instanceof OrgStructureInfo)) continue;
                    OrgStructureInfo orgTemKey = (OrgStructureInfo)nodeTem.getUserObject();
                    OrgStructureInfo orgTemNode = (OrgStructureInfo)node.getUserObject();
                    if (!orgTemKey.getId().equals((Object)orgTemNode.getId())) continue;
                    isContains = true;
                    break;
                }
                if (isContains) {
                    node.setChecked(true);
                } else {
                    node.setChecked(false);
                }
                if (node.isLeaf()) continue;
                this.setSelectedNodesForTree(map, node);
            }
        }
    }

    public Map getStoreStateCache() {
        return this.storeStateCache;
    }

    public String getSelectedOldTableItemID() {
        return this.selectedOldTableItemID;
    }

    public void setSelectedOldTableItemID(String selectedOldTableItemID) {
        this.selectedOldTableItemID = selectedOldTableItemID;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.hasNotChooseTemAndOrg) {
            this.hasNotChooseTemAndOrg = false;
            return;
        }
        Object obj = evt.getOldValue();
        if (obj == null) {
            this.setSelectedOldTableItemID(evt.getNewValue().toString());
            return;
        }
        String oldKey = obj.toString();
        this.storeStateCache.put(oldKey, this.getSelectedNodesInTree());
        this.setSelectedOldTableItemID(evt.getNewValue().toString());
    }

    private void deepViewTree(Map treeMap, DefaultKingdeeTreeNode rootNode) {
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (node.isChecked()) {
                treeMap.put(node, rootNode);
            }
            if (node.isLeaf()) continue;
            this.deepViewTree(treeMap, node);
        }
    }

    private void setAllTreeNodesUncheckedOrChecked(DefaultKingdeeTreeNode rootNode, boolean state) {
        rootNode.setChecked(state);
        Enumeration children = rootNode.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            if (node.isLeaf()) {
                node.setChecked(state);
                continue;
            }
            this.setAllTreeNodesUncheckedOrChecked(node, state);
        }
    }

    public Object[] adapter() {
        if (this.storeStateCache == null || this.storeStateCache.size() == 0) {
            return new Object[0];
        }
        ArrayList templateIDList = new ArrayList(this.storeStateCache.keySet());
        ArrayList subOrgs = this.getSubOrgs(templateIDList, this.storeStateCache);
        Hashtable tempMap = this.rebuildMap(templateIDList, this.storeStateCache);
        Object[] array = new Object[]{subOrgs, tempMap};
        return array;
    }

    private ArrayList getSubOrgs(ArrayList keyList, Map map) {
        HashSet set = new HashSet();
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            String templateID = keyList.get(i).toString();
            Object orgMap = map.get(templateID);
            if (orgMap == null) continue;
            this.getSubOrgInfo((Map)orgMap, set);
        }
        return new ArrayList(set);
    }

    private void getSubOrgInfo(Map map, Set set) {
        if (map.size() == 0) {
            return;
        }
        for (DefaultKingdeeTreeNode node : map.keySet()) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            FullOrgUnitInfo info = oui.getUnit();
            info.setLongNumber(oui.getLongNumber());
            set.add(info);
        }
    }

    private Hashtable rebuildMap(ArrayList keyList, Map map) {
        Hashtable table = new Hashtable();
        int num = keyList.size();
        for (int i = 0; i < num; ++i) {
            List list;
            String templateID = keyList.get(i).toString();
            Object orgMap = map.get(templateID);
            if (orgMap == null || (list = this.getSubOrgID((Map)orgMap)) == null || list.isEmpty()) continue;
            int _num = list.size();
            for (int _i = 0; _i < _num; ++_i) {
                String orgID = list.get(_i).toString();
                Object templateIDsVector = table.get(orgID);
                if (templateIDsVector != null && templateIDsVector instanceof Vector) {
                    Vector tempVctr = (Vector)templateIDsVector;
                    tempVctr.add(templateID);
                    continue;
                }
                Vector<String> templateIDsVctr = new Vector<String>();
                templateIDsVctr.add(templateID);
                table.put(orgID, templateIDsVctr);
            }
        }
        return table;
    }

    private List getSubOrgID(Map map) {
        if (map.size() == 0) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (DefaultKingdeeTreeNode node : map.keySet()) {
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            list.add(oui.getUnit().getId().toString());
        }
        return list;
    }

    @Override
    protected void btnClearAllTem_actionPerformed(ActionEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.FALSE);
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.setAllTreeNodesUncheckedOrChecked(root, false);
        this.treeOrgUnit.repaint();
        this.storeStateCache.clear();
        this.isSelectTemAll = false;
    }

    @Override
    protected void btnSelectAllTem_actionPerformed(ActionEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        this.isSelectTemAll = true;
        for (int i = 0; i < this.temTable.getRowCount() - 1; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)Boolean.TRUE);
        }
        this.chBoxTogether.setSelected(true);
        this.treeOrgUnit.repaint();
        this.storeStateCache.clear();
    }

    @Override
    protected void temTable_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.hasNotChooseTemAndOrg = false;
        int currentRowID = KDTableUtil.getSelectedRow((KDTable)this.temTable);
        if (currentRowID == this.temTable.getRowCount() - 1) {
            return;
        }
        String controlSchemeId = this.getControlSchemeId();
        this.support.firePropertyChange("selectedOldTableItemID", this.getSelectedOldTableItemID(), controlSchemeId);
        Object obj = this.storeStateCache.get(controlSchemeId);
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        if (obj != null) {
            Map map = (Map)obj;
            this.setSelectedNodesForTree(map, root);
        } else {
            this.setSelectedNodesForTree(null, root);
        }
        this.treeOrgUnit.repaint();
    }

    protected String getControlSchemeId() {
        String controlSchemeId = null;
        if (this.temTable.getSelectManager().getActiveRowIndex() >= 0) {
            controlSchemeId = this.temTable.getRow(this.temTable.getSelectManager().getActiveRowIndex()).getCell("id").getValue().toString();
        }
        return controlSchemeId;
    }

    @Override
    protected void chBoxTogether_actionPerformed(ActionEvent e) throws Exception {
        super.chBoxTogether_actionPerformed(e);
    }

    public boolean destroyWindow() {
        boolean isDestroy = super.destroyWindow();
        if (isDestroy && this.getUIContext().get("ID") != null) {
            BgClientHelper.releaseMutexService(this.getUIContext().get("ID").toString());
        }
        return isDestroy;
    }

    @Override
    public void clear() throws Exception {
        int i = 0;
        int rowCount = this.temTable.getRowCount() - 1;
        for (i = 0; i < rowCount; ++i) {
            this.temTable.getRow(i).getCell("select").setValue((Object)false);
        }
        this.isSelectTemAll = false;
        DefaultTreeModel node = (DefaultTreeModel)this.treeOrgUnit.getModel();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)node.getRoot();
        this.setTreeNodeSelected(root, false);
        this.treeOrgUnit.repaint();
        this.storeStateCache.clear();
        this.chBoxTogether.setSelected(false);
    }

    @Override
    public Object saveSolution() throws Exception {
        this.validateSetting();
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        objMap.put("chBoxTogether", this.chBoxTogether.isSelected());
        objMap.put("OnlyUpdateAddFormulaToAuditFormAndActualForm", this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.isSelected());
        objMap.put("storeStateCache", this.loadSelectData());
        return objMap;
    }

    private Map loadSelectData() {
        this.storeStateCache.clear();
        boolean isSelect = false;
        int rowCount = this.temTable.getRowCount() - 1;
        for (int i = 0; i < rowCount; ++i) {
            if (this.temTable.getRow(i).getCell("select").getValue() == null || !(isSelect = ((Boolean)this.temTable.getRow(i).getCell("select").getValue()).booleanValue())) continue;
            this.storeStateCache.put(this.temTable.getRow(i).getCell("id").getValue(), null);
        }
        Map value = this.getSelectedNodesInTree();
        HashMap mapTem = new HashMap();
        for (Object key : this.storeStateCache.keySet()) {
            if (value == null || !(value instanceof Map) || value.isEmpty()) continue;
            HashMap<String, String> mapTemValue = new HashMap<String, String>();
            Map valueMap = value;
            if (valueMap.isEmpty()) break;
            for (Object valueKey : valueMap.keySet()) {
                Object valueValue;
                String valueIdKey = null;
                String valueIdValue = null;
                if (valueKey instanceof DefaultKingdeeTreeNode) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)valueKey;
                    if (node == null || node.getUserObject() == null || !(node.getUserObject() instanceof OrgStructureInfo)) continue;
                    valueIdKey = ((OrgStructureInfo)node.getUserObject()).getUnit().getId().toString();
                }
                if ((valueValue = valueMap.get(valueKey)) instanceof DefaultKingdeeTreeNode) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)valueValue;
                    valueIdValue = node != null && node.getUserObject() != null && node.getUserObject() instanceof OrgStructureInfo ? ((OrgStructureInfo)node.getUserObject()).getUnit().getId().toString() : null;
                }
                mapTemValue.put(valueIdKey, valueIdValue);
            }
            mapTem.put(key, mapTemValue);
        }
        this.storeStateCache = mapTem;
        return this.storeStateCache;
    }

    @Override
    public void reloadSolution(Object o) throws Exception {
        this.selectedOldTableItemID = null;
        this.hasNotChooseTemAndOrg = true;
        Map objMap = (Map)o;
        if (objMap == null) {
            return;
        }
        this.storeStateCache = (Map)objMap.get("storeStateCache");
        if (objMap.get("chBoxTogether") != null && objMap.get("chBoxTogether") instanceof Boolean) {
            boolean chBoxTogetherValue = (Boolean)objMap.get("chBoxTogether");
            this.chBoxTogether.setSelected(chBoxTogetherValue);
        }
        boolean OnlyUpdateAddFormulaToAuditFormAndActualForm = false;
        if (objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm") != null && objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm") instanceof Boolean) {
            OnlyUpdateAddFormulaToAuditFormAndActualForm = (Boolean)objMap.get("OnlyUpdateAddFormulaToAuditFormAndActualForm");
            this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setSelected(OnlyUpdateAddFormulaToAuditFormAndActualForm);
        } else {
            this.btnOnlyUpdateAddFormulaToAuditFormAndActualForm.setSelected(false);
        }
        int CurrentSelectRow = 0;
        String firstID = null;
        HashMap mapStrTotRreeNode = new HashMap();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
        this.initTreeNodeUserObectToIdStringMap(mapStrTotRreeNode, root);
        if (this.storeStateCache != null && this.storeStateCache instanceof Map && !this.storeStateCache.isEmpty()) {
            String temIdTemp;
            HashMap mapTem = new HashMap();
            Set temIdSet = this.storeStateCache.keySet();
            if (temIdSet == null || temIdSet.size() < 1) {
                return;
            }
            Iterator iterator = temIdSet.iterator();
            while (iterator.hasNext() && (temIdTemp = (String)iterator.next()) != null && temIdTemp.trim().length() >= 1) {
                int size = this.temTable.getRowCount() - 1;
                for (int i = 0; i < size; ++i) {
                    String idColValue = (String)this.temTable.getRow(i).getCell("id").getValue();
                    if (!idColValue.equals(temIdTemp)) continue;
                    if (firstID == null) {
                        firstID = idColValue;
                        CurrentSelectRow = i;
                    }
                    this.temTable.getRow(i).getCell("select").setValue((Object)true);
                    break;
                }
                Object value = this.storeStateCache.get(temIdTemp);
                HashMap<DefaultKingdeeTreeNode, DefaultKingdeeTreeNode> mapTemValue = new HashMap<DefaultKingdeeTreeNode, DefaultKingdeeTreeNode>();
                Map valueMap = (Map)value;
                if (valueMap.isEmpty()) break;
                String keyStr2 = null;
                DefaultKingdeeTreeNode keyDef = null;
                String valueStr = null;
                DefaultKingdeeTreeNode valueDef = null;
                for (String keyStr2 : valueMap.keySet()) {
                    valueStr = (String)valueMap.get(keyStr2);
                    if (keyStr2 == null || mapStrTotRreeNode.get(keyStr2) == null) continue;
                    keyDef = (DefaultKingdeeTreeNode)mapStrTotRreeNode.get(keyStr2);
                    valueDef = valueStr != null && mapStrTotRreeNode.get(valueStr) != null ? (DefaultKingdeeTreeNode)mapStrTotRreeNode.get(valueStr) : null;
                    mapTemValue.put(keyDef, valueDef);
                }
                valueMap.clear();
                mapTem.put(temIdTemp, mapTemValue);
            }
            this.storeStateCache.clear();
            this.storeStateCache = mapTem;
        }
        this.temTable.getSelectManager().select(CurrentSelectRow, 0, CurrentSelectRow, this.temTable.getColumnCount());
        if (this.temTable.getRowCount() > 0 && this.storeStateCache.containsKey(firstID)) {
            Map mapOrg = (Map)this.storeStateCache.get(firstID);
            root = (DefaultKingdeeTreeNode)this.treeOrgUnit.getModel().getRoot();
            this.setSelectedNodesForTree(mapOrg, root);
        }
        mapStrTotRreeNode.clear();
    }

    private void initTreeNodeUserObectToIdStringMap(Map map, DefaultKingdeeTreeNode root) {
        if (root == null || root.getUserObject() == null || !(root.getUserObject() instanceof OrgStructureInfo)) {
            return;
        }
        OrgStructureInfo org = (OrgStructureInfo)root.getUserObject();
        map.put(org.getUnit().getId().toString(), root);
        if (root.isLeaf()) {
            return;
        }
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)children.nextElement();
            this.initTreeNodeUserObectToIdStringMap(map, child);
        }
    }

    @Override
    public void clearSolutionList() throws Exception {
    }

    @Override
    public AssignSolutionCollection solutionList(AssignSolutionTypeEnum typeEnum) throws Exception {
        StringBuffer oql = new StringBuffer("where solutionType=" + typeEnum.getValue());
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        if (typeEnum.getValue() == 0) {
            String cuid = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            oql.append(" and cuid='" + cuid + "'");
        } else if (typeEnum.getValue() == 2) {
            String orgId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
            oql.append(" and orgId='" + orgId + "'");
        } else if (typeEnum.getValue() == 1) {
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            oql.append(" and userId='" + userId + "' ");
        }
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        oql.append(" and uiname ='" + this.getMetaDataPK().getFullName() + "'");
        oql.append(" order by isDefaultsolution desc");
        AssignSolutionCollection asSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        return asSolutionCol;
    }

    @Override
    public boolean conferm(Object obj) throws Exception {
        this.btnConfirm_actionPerformed(null);
        return false;
    }

    @Override
    public boolean cancel() throws Exception {
        this.btnCancel_actionPerformed(null);
        return true;
    }

    @Override
    public Map getReturnData() throws Exception {
        return null;
    }

    @Override
    public String getNewConfermLabel() {
        return EASResource.getString((String)RESOURCE, (String)"re.assign");
    }

    @Override
    public AssignSolutionInfo getDefaultSoltuion() throws Exception {
        String objId = null;
        String operateType = null;
        Map uicontext = this.getUIContext();
        if (uicontext.get("ID") != null) {
            objId = (String)uicontext.get("ID");
        }
        if (uicontext.get("operateType") != null) {
            operateType = (String)uicontext.get("operateType");
        }
        StringBuffer oql = new StringBuffer("where isDefaultsolution =1 ");
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        oql.append(" and userId='" + userId + "' ");
        if (objId != null) {
            oql.append(" and relativeObjId='" + objId + "' ");
        }
        if (operateType != null) {
            oql.append(" and oprateObjType='" + operateType + "' ");
        }
        AssignSolutionInfo assignSolutionInfo = null;
        AssignSolutionCollection assignSolutionCol = AssignSolutionFactory.getRemoteInstance().getAssignSolutionCollection(oql.toString());
        if (assignSolutionCol.size() > 0) {
            assignSolutionInfo = assignSolutionCol.get(0);
        }
        return assignSolutionInfo;
    }

    private void selectedFinanceOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            OrgStructureInfo oui = (OrgStructureInfo)node.getUserObject();
            if (oui != null && oui.getUnit() != null && !oui.getUnit().isIsCompanyOrgUnit()) {
                node.setTextColor(NOFINANCE);
                node.setCheckBoxVisible(false);
                node.setCheckBoxEnabled(false);
            }
            if (node.getChildCount() <= 0) continue;
            this.selectedFinanceOrg(node);
        }
    }

    private void selectedAllOrg(DefaultKingdeeTreeNode root) {
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)children.nextElement();
            node.setTextColor(NO_DISPATCHED);
            node.setCheckBoxVisible(true);
            node.setCheckBoxEnabled(true);
            if (node.getChildCount() <= 0) continue;
            this.selectedAllOrg(node);
        }
    }

    class OrgListener
    implements ItemListener {
        OrgListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BgCtrlSchemeAssignChildUI.this.txtKey.setText("");
            TreeModel model = null;
            model = BgOrgUtils.clipAndCloneTreeModel((TreeModel)BgCtrlSchemeAssignChildUI.this.treeModelOld, (String)"name", (String)"", (boolean)true);
            ((DefaultKingdeeTreeNode)model.getRoot()).setCheckBoxVisible(false);
            BgCtrlSchemeAssignChildUI.this.treeOrgUnit.setModel(model);
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgCtrlSchemeAssignChildUI.this.treeOrgUnit.getModel().getRoot();
            BgCtrlSchemeAssignChildUI.this.treeOrgUnit.expandAllNodes(true, (TreeNode)root);
            String select = null;
            if (e.getStateChange() == 1) {
                select = e.getItem().toString();
                if (BgOrgTypeViewEnum.company.toString() == select || BgOrgTypeViewEnum.company.toString().equals(select)) {
                    BgCtrlSchemeAssignChildUI.this.selectedFinanceOrg(root);
                    isFinSelected = true;
                } else {
                    BgCtrlSchemeAssignChildUI.this.selectedAllOrg(root);
                    isFinSelected = false;
                }
            }
            BgCtrlSchemeAssignChildUI.this.treeOrgUnit.repaint();
        }
    }

    class TreePopupMenuListener
    extends MouseAdapter {
        TreePopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                BgCtrlSchemeAssignChildUI.this.popMenu.show((Component)BgCtrlSchemeAssignChildUI.this.treeOrgUnit, e.getX(), e.getY());
            }
        }
    }

    class TreeMenuListener
    implements ActionListener {
        TreeMenuListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath path = BgCtrlSchemeAssignChildUI.this.treeOrgUnit.getSelectionPath();
            if (path == null) {
                return;
            }
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)BgCtrlSchemeAssignChildUI.this.treeOrgUnit.getModel().getRoot();
            Object[] obj = path.getPath();
            ArrayList pathList = BgCtrlSchemeAssignChildUI.this.productArrayList(obj);
            BgCtrlSchemeAssignChildUI.this.treeSonSelected(root, pathList);
            BgCtrlSchemeAssignChildUI.this.treeOrgUnit.repaint();
        }
    }
}

