/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgDecForPeriodFormFactory;
import com.kingdee.eas.ma.budget.BgDecForPeriodFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgDecForPeriodForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgDecForPeriodListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgDecForPeriodEditUI;
import com.kingdee.eas.ma.budget.client.BgExamineClientHelper;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgDecForPeriodListUI
extends AbstractBgDecForPeriodListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgDecForPeriodListUI.class);

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewFlow.setEnabled(false);
        this.btnConfirm.setEnabled(true);
        this.btnConfirm.setVisible(true);
        this.menuItemConfirm.setVisible(true);
        this.menuItemConfirm.setEnabled(true);
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.menuItemConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("OrgID", this.getOrgUnitId());
        super.actionAddNew_actionPerformed(e);
    }

    @Override
    protected String getEditUIName() {
        return BgDecForPeriodEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgDecForPeriodFormFactory.getRemoteInstance();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(strID);
        IBgDecForPeriodForm bgDecomposer = BgDecForPeriodFormFactory.getRemoteInstance();
        SelectorItemCollection sc = new SelectorItemCollection();
        sc.add(new SelectorItemInfo("id"));
        sc.add("bgForm.id");
        sc.add("refBgDecPeriods.bgForm.id");
        sc.add(new SelectorItemInfo("state"));
        sc.add("mapData");
        final BgDecForPeriodFormInfo info = bgDecomposer.getBgDecForPeriodFormInfo((IObjectPK)pk, sc);
        if (info.getState().getValue() == 101) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            return;
        }
        if (BgSHelper.isDelomposerExiameCheck(null)) {
            List check;
            final BOSUuid[] ids = new BOSUuid[info.getRefBgDecPeriods().size() + 1];
            ids[0] = info.getBgForm().getId();
            for (int i = 0; i < info.getRefBgDecPeriods().size(); ++i) {
                ids[i + 1] = info.getRefBgDecPeriods().get(i).getBgForm().getId();
            }
            HashMap adjustMap = new HashMap();
            if (info.getMapData() != null) {
                HashMap temp = BgHelper.buildHashMapByByte(info.getMapData());
                if (temp != null && temp.get("adjustMap") instanceof byte[]) {
                    temp = BgHelper.buildHashMapByByte((byte[])temp.get("adjustMap"));
                }
                if (temp != null) {
                    adjustMap = temp;
                }
            }
            if ((check = this.getFormInterface().decForPeriodReprotCheck(ids, BgDecForPeriodFormInfo.class.getName(), adjustMap)).get(0).equals(Boolean.FALSE)) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"String", (Object)check.get(3).toString());
                uiContext.put((Object)"id", this.getUIContext().get("ID"));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiContext, null);
                uiWindow.show();
                return;
            }
            final String xNum = BgNFCHelper.returnExamineX((BOSUuid[])ids, (Object)((Object)this));
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            LongTimeDialog dialog = null;
            dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
            if (dialog != null) {
                dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = BgExamineFacadeFactory.getRemoteInstance().examines(ids, xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            Map bgExamineCheckMap = (Map)result;
                            Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                            if (bgExCheck.booleanValue()) {
                                BgDecForPeriodListUI.this.confirm(info);
                            } else {
                                MsgBox.showWarning((Component)((Object)BgDecForPeriodListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cannotConfirm"));
                                BgExamineClientHelper.openBgExamineViewUI(result, null, (CoreUI)BgDecForPeriodListUI.this);
                            }
                        } else {
                            MsgBox.showWarning((Component)((Object)BgDecForPeriodListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                            SysUtil.abort();
                        }
                    }
                });
                dialog.show();
            }
        } else {
            this.confirm(info);
        }
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        if (strID != null && strID.trim().length() > 0) {
            IBgDecForPeriodForm bgDecomposer = BgDecForPeriodFormFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(strID);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("state"));
            sc.add(new SelectorItemInfo("bgForm"));
            BgDecForPeriodFormInfo aBgDecomposerFormInfo = bgDecomposer.getBgDecForPeriodFormInfo((IObjectPK)pk, sc);
            if (aBgDecomposerFormInfo.getState().getValue() == 101) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgDecomposerStateEnum.SIGNED.equals((Object)aBgDecomposerFormInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNOCHANGE");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.SIGNED.equals((Object)aBgDecomposerFormInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOCHANGE"));
                SysUtil.abort();
            }
            BgClientHelper.applyMutexService((Component)((Object)this), aBgDecomposerFormInfo.getBgForm().getId().toString(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        }
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        if (strID != null && strID.trim().length() > 0) {
            IBgDecForPeriodForm bgDecomposer = BgDecForPeriodFormFactory.getRemoteInstance();
            ObjectUuidPK pk = new ObjectUuidPK(strID);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("state"));
            sc.add(new SelectorItemInfo("bgForm.id"));
            BgDecForPeriodFormInfo aBgDecomposerFormInfo = bgDecomposer.getBgDecForPeriodFormInfo((IObjectPK)pk, sc);
            if (aBgDecomposerFormInfo.getState().getValue() == 101) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgDecomposerStateEnum.SIGNED.equals((Object)aBgDecomposerFormInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNODELETE");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.AUDIT.equals((Object)aBgDecomposerFormInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOREMOVE"));
                SysUtil.abort();
            }
            String upperBgFormId = aBgDecomposerFormInfo.getBgForm().getId().toString();
            BgClientHelper.isMutex((Component)((Object)this), upperBgFormId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        }
        super.actionRemove_actionPerformed(e);
        BgFormHelper.refreshBgFormList((CoreUI)this);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"scheme", "formName", "formNum"};
        return locateNames;
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        filter = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        if (BgSHelper.isBgPermissionUsed()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
            FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            Set<String> orgSet = new HashSet<String>();
            if (this.getPermissionOrg() != null) {
                orgSet = this.getPermissionOrg();
            } else {
                orgSet.add(orgUnitInfo.getId().toString());
            }
            filter = BgPermissionHelper.addBgFormPermission((String)userId, orgSet, (FilterInfo)filter);
        }
        viewInfo.setFilter(filter);
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    public String getPermissionNum() {
        return "bg_form01_list";
    }

    protected void confirm(BgDecForPeriodFormInfo info) throws Exception {
        if (info.getState().getValue() == 101) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            return;
        }
        IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getRemoteInstance();
        iBgFormFacade.auditBgDecForPeriod(info.getId());
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"isOK"));
        this.refreshList();
    }
}

