/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.client.AbstractBgDecForPeriodScaleUI;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgDecForPeriodScaleUI
extends AbstractBgDecForPeriodScaleUI {
    private static final Logger logger = CoreUIObject.getLogger(BgDecForPeriodScaleUI.class);
    private Map data = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.txtSourcePeriod.setText((String)this.getUIContext().get("sourceName"));
        this.initTblMain();
        this.btnConfirm.setEnabled(true);
        this.btnCancel.setEnabled(true);
    }

    private void initTblMain() {
        this.tblMain.setEnabled(true);
        this.tblMain.setEditable(true);
        BgPeriodCollection col = (BgPeriodCollection)((Object)this.getUIContext().get("endPeriod"));
        IRow row = null;
        for (int n = 0; n < col.size(); ++n) {
            row = this.tblMain.addRow();
            row.getCell("number").setValue((Object)col.get(n).getNumber());
            row.getCell("name").setValue((Object)col.get(n).getName());
        }
        this.tblMain.getColumn("number").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("name").getStyleAttributes().setLocked(true);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setScaleToData();
        this.getUIWindow().close();
    }

    private void setScaleToData() {
        this.data = new HashMap();
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            try {
                if (row.getCell("scale") == null || row.getCell("scale").getValue() == null) continue;
                BigDecimal scale = new BigDecimal(row.getCell("scale").getValue().toString());
                this.data.put(row.getCell("number").getValue().toString(), scale);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    public Map getData() {
        return this.data;
    }
}

