/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.ShowEditorPanelUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgCollectStateEnum;
import com.kingdee.eas.ma.budget.BgDecomposerFormFactory;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgDecomposerStateEnum;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgDecomposerForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgDecomposerFormListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgDecomposerFormEditUI;
import com.kingdee.eas.ma.budget.client.BgExamineClientHelper;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgDecomposerFormListUI
extends AbstractBgDecomposerFormListUI {
    private static final long serialVersionUID = 3807484658173718743L;
    private static final Logger logger = CoreUIObject.getLogger(BgDecomposerFormListUI.class);

    protected String getEditUIName() {
        return BgDecomposerFormEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgDecomposerFormFactory.getRemoteInstance();
    }

    protected IBgDecomposerForm getInterface() throws Exception {
        return BgDecomposerFormFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.setRefresh(false);
        this.tblMain.getMergeManager().setMergeMode(1);
        int schemaIndex = this.tblMain.getColumnIndex("bgScheme.name");
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (i == schemaIndex) {
                this.tblMain.getColumn(i).setMergeable(true);
                continue;
            }
            this.tblMain.getColumn(i).setMergeable(false);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnConfirm.setEnabled(true);
        this.btnConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.menuItemConfirm.setIcon(EASResource.getIcon((String)"imgTbtn_makeknown"));
        this.menuItemConfirm.setEnabled(true);
        this.actionConfirm.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        if (strID != null && strID.trim().length() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(strID);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("state"));
            sc.add(new SelectorItemInfo("bgForm"));
            BgDecomposerFormInfo aBgDecomposerFormInfo = this.getInterface().getBgDecomposerFormInfo((IObjectPK)pk, sc);
            if (aBgDecomposerFormInfo.getState().getValue() == 101) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgDecomposerStateEnum.SIGNED.equals((Object)aBgDecomposerFormInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNOCHANGE");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.SIGNED.equals((Object)aBgDecomposerFormInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOCHANGE"));
                SysUtil.abort();
            }
            BgClientHelper.applyMutexService((Component)((Object)this), aBgDecomposerFormInfo.getBgForm().getId().toString(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BgFormHelper.checkInProInst(this.getSelectedKeyValue());
        String strID = this.getSelectedKeyValue();
        if (strID != null && strID.trim().length() > 0) {
            ObjectUuidPK pk = new ObjectUuidPK(strID);
            SelectorItemCollection sc = new SelectorItemCollection();
            sc.add(new SelectorItemInfo("id"));
            sc.add(new SelectorItemInfo("state"));
            sc.add(new SelectorItemInfo("bgForm.id"));
            BgDecomposerFormInfo aBgDecomposerFormInfo = this.getInterface().getBgDecomposerFormInfo((IObjectPK)pk, sc);
            if (aBgDecomposerFormInfo.getState().getValue() == 101) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgDecomposerStateEnum.SIGNED.equals((Object)aBgDecomposerFormInfo.getState())) {
                String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLECTFORMNODELETE");
                MsgBox.showInfo((Component)((Object)this), (String)strMsg);
                return;
            }
            if (BgCollectStateEnum.AUDIT.equals((Object)aBgDecomposerFormInfo.getState())) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BudgetResource", (String)"BGCOLLFORMINWFNOREMOVE"));
                SysUtil.abort();
            }
            String upperBgFormId = aBgDecomposerFormInfo.getBgForm().getId().toString();
            BgClientHelper.isMutex((Component)((Object)this), upperBgFormId, SysContext.getSysContext().getCurrentUserInfo().getId().toString());
        }
        super.actionRemove_actionPerformed(e);
        BgFormHelper.refreshBgFormList((CoreUI)this);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)SysContext.getSysContext().getCurrentCostUnit().getId().toString(), CompareType.EQUALS));
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("BGSCHEME.PERIOD", (Object)new Integer(4), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("BGSCHEME.PERIOD", (Object)new Integer(-1), CompareType.NOTEQUALS));
        }
        filter.setMaskString("#0 and #1");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> org = new HashSet<String>();
            org.add(SysContext.getSysContext().getCurrentCostUnit().getId().toString());
            String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermissionForDec((String)userId, org, (FilterInfo)filter);
        }
        return filter;
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String strID = this.getSelectedKeyValue();
        ObjectUuidPK pk = new ObjectUuidPK(strID);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bgForm.id");
        sic.add("refBgDecForms.id");
        sic.add("refBgDecForms.bgform.id");
        sic.add("state");
        final BgDecomposerFormInfo info = this.getInterface().getBgDecomposerFormInfo((IObjectPK)pk, sic);
        if (info.getState().getValue() == 101) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            return;
        }
        if (BgSHelper.isDelomposerExiameCheck(null)) {
            final BOSUuid[] ids = new BOSUuid[info.getRefBgDecForms().size() + 1];
            BOSUuid[] refIds = new BOSUuid[info.getRefBgDecForms().size() + 1];
            ids[0] = info.getBgForm().getId();
            refIds[0] = info.getId();
            for (int i = 0; i < info.getRefBgDecForms().size(); ++i) {
                ids[i + 1] = info.getRefBgDecForms().get(i).getBgForm().getId();
                refIds[i + 1] = info.getRefBgDecForms().get(i).getId();
            }
            List check = BgFormFactory.getRemoteInstance().reportCheck(info.getId(), refIds, ids, BgDecomposerFormInfo.class.getName());
            if (check.get(0).equals(Boolean.FALSE)) {
                UIContext uiContext = new UIContext((Object)this);
                uiContext.put((Object)"String", (Object)check.get(3).toString());
                uiContext.put((Object)"id", this.getUIContext().get("ID"));
                IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ShowEditorPanelUI.class.getName(), (Map)uiContext, null);
                uiWindow.show();
                return;
            }
            final String xNum = BgNFCHelper.returnExamineX((BOSUuid[])ids, (Object)((Object)this));
            Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
            LongTimeDialog dialog = null;
            dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
            if (dialog != null) {
                dialog.setLongTimeTask(new ILongTimeTask(){

                    public Object exec() throws Exception {
                        Object[] result = BgExamineFacadeFactory.getRemoteInstance().examines(ids, xNum);
                        HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                        bgExamineCheckMap.put("BgExamineChecked", result[0]);
                        bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                        return bgExamineCheckMap;
                    }

                    public void afterExec(Object result) throws Exception {
                        if (result != null && result instanceof HashMap) {
                            Map bgExamineCheckMap = (Map)result;
                            Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                            if (bgExCheck.booleanValue()) {
                                BgDecomposerFormListUI.this.confirm(info);
                            } else {
                                MsgBox.showWarning((Component)((Object)BgDecomposerFormListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cannotConfirm"));
                                BgExamineClientHelper.openBgExamineViewUI(result, null, (CoreUI)BgDecomposerFormListUI.this);
                            }
                        } else {
                            MsgBox.showWarning((Component)((Object)BgDecomposerFormListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                            SysUtil.abort();
                        }
                    }
                });
                dialog.show();
            }
        } else {
            this.confirm(info);
        }
    }

    private boolean checkState(BgDecomposerFormInfo info) throws Exception {
        IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getRemoteInstance();
        iBgFormFacade.updataDecomposerForm(info.getId());
        return true;
    }

    protected void confirm(BgDecomposerFormInfo info) throws Exception {
        if (info.getState().getValue() == 101) {
            String strMsg = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"cantDoIt");
            MsgBox.showInfo((Component)((Object)this), (String)strMsg);
            return;
        }
        boolean isOK = this.checkState(info);
        if (!isOK) {
            return;
        }
        this.getInterface().setState((IObjectPK)new ObjectUuidPK(info.getId()));
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgDecomposerFormResource", (String)"isOK"));
        this.refreshList();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"bgForm.number", "bgForm.name"};
        return locateNames;
    }
}

