/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.Tools;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.BasicNumberTextField;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.ma.budget.BgConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.KeyStroke;

public class BgDefCellEditer
extends KDTAbstractCellEditor {
    protected JComponent comp;
    protected BigDecimal measure = BgConstants.ONE;
    protected int decimal = 10;
    protected EditorDelegate delegate;
    protected int clickCountToStart = 2;

    public BigDecimal getMeasure() {
        return this.measure;
    }

    public void setMeasure(BigDecimal measure) {
        this.measure = measure;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public void setDecimal(int decimal) {
        this.decimal = decimal;
    }

    public BgDefCellEditer(final JFormattedTextField textField, BigDecimal measure, int decimal) {
        this.comp = textField;
        this.handleEsc(textField);
        if (measure != null && measure.compareTo(BgConstants.BIGZERO) != 0) {
            this.measure = measure;
        }
        if (decimal < 0) {
            this.decimal = decimal;
        }
        this.delegate = new EditorDelegate(measure, decimal){
            String lastValue;
            {
                super(measure, decimal);
                this.lastValue = null;
            }

            @Override
            public String getText() {
                String text = null;
                text = textField.getText();
                return text;
            }

            @Override
            public void setValue(Object value) {
                if (textField instanceof KDFormattedTextField) {
                    BigDecimal n = null;
                    if (value != null && !"".equals(value.toString()) && value != null) {
                        try {
                            n = new BigDecimal(value.toString()).divide(this.measure, this.decimal, 4);
                        }
                        catch (Exception ex) {
                            this.lastValue = value.toString();
                            value = null;
                        }
                    }
                    ((KDFormattedTextField)textField).setNumberValue(n);
                }
            }

            @Override
            public Object getValue() {
                Number value = null;
                if (textField instanceof KDFormattedTextField) {
                    value = ((KDFormattedTextField)textField).getNumberValue();
                    if (value != null) {
                        try {
                            value = new BigDecimal(value.toString());
                        }
                        catch (Exception ex) {
                            this.lastValue = value.toString();
                            value = null;
                        }
                    } else {
                        String temp = this.lastValue;
                        this.lastValue = null;
                        return temp;
                    }
                }
                return value;
            }

            @Override
            public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
                super.initComponent(value, expandValue, style, anEvent);
                if (anEvent instanceof KeyEvent) {
                    String str = String.valueOf(((KeyEvent)anEvent).getKeyChar());
                    this.initComponent(str);
                } else if (anEvent instanceof InputMethodEvent) {
                    String str = KDTDefaultCellEditor.getInputMethodEventText((InputMethodEvent)((InputMethodEvent)anEvent));
                    this.initComponent(str);
                } else if (anEvent instanceof ActionEvent) {
                    String str = KDTDefaultCellEditor.getActionEventText((ActionEvent)((ActionEvent)anEvent));
                    this.initComponent(str);
                } else if (textField instanceof KDFormattedTextField) {
                    ((KDFormattedTextField)textField).setSelectAllOnFocus(true);
                } else {
                    textField.selectAll();
                }
                BgDefCellEditer.this.comp.getInputMap().put(KeyStroke.getKeyStroke(38, 0), "SelectUpCell");
                BgDefCellEditer.this.comp.getInputMap().put(KeyStroke.getKeyStroke(40, 0), "SelectDownCell");
                BgDefCellEditer.this.comp.getActionMap().put("SelectUpCell", ((KDTable)expandValue).getActionMap().get("SelectUpCell"));
                BgDefCellEditer.this.comp.getActionMap().put("SelectDownCell", ((KDTable)expandValue).getActionMap().get("SelectDownCell"));
            }

            void initComponent(String str) {
                if (textField instanceof KDFormattedTextField) {
                    ((KDFormattedTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        if (!"-".equals(str)) {
                            try {
                                new BigDecimal(str);
                            }
                            catch (Exception e) {
                                str = null;
                            }
                        }
                        textField.selectAll();
                        ((KDFormattedTextField)textField).replaceSelection(str);
                    }
                } else if (textField instanceof BasicNumberTextField) {
                    ((BasicNumberTextField)textField).setSelectAllOnFocus(false);
                    if (!StringUtil.isEmptyString((String)str)) {
                        int length = str.length();
                        try {
                            new Double(str);
                        }
                        catch (Exception e) {
                            str = null;
                            length = 0;
                        }
                        ((BasicNumberTextField)textField).setText(str);
                        textField.setCaretPosition(length);
                    }
                } else {
                    textField.setText(str);
                    if (!StringUtil.isEmptyString((String)str)) {
                        textField.setCaretPosition(str.length());
                    }
                }
            }

            @Override
            public void releaseComponent() {
                BgDefCellEditer.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(38, 0));
                BgDefCellEditer.this.comp.getInputMap().remove(KeyStroke.getKeyStroke(40, 0));
                BgDefCellEditer.this.comp.getActionMap().remove("SelectUpCell");
                BgDefCellEditer.this.comp.getActionMap().remove("SelectDownCell");
            }

            @Override
            public boolean isCellEditable(EventObject anEvent) {
                if (super.isCellEditable(anEvent)) {
                    return true;
                }
                return anEvent instanceof KeyEvent ? Tools.isVisibleChar((KeyEvent)((KeyEvent)anEvent)) : anEvent instanceof InputMethodEvent || anEvent instanceof ActionEvent;
            }
        };
        textField.addActionListener(this.delegate);
    }

    private void handleEsc(JComponent comp) {
        comp.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "esc2");
        comp.getActionMap().put("esc2", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BgDefCellEditer.this.fireEditingCanceled();
            }
        });
    }

    public String getText() {
        return this.delegate.getText();
    }

    public void setText(String text) {
        this.delegate.setText(text);
    }

    public Object getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Object value) {
        this.delegate.setValue(value);
    }

    public Component prepareComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
        if (this.isDisplayable()) {
            this.delegate.initComponent(value, expandValue, style, anEvent);
            return this.comp;
        }
        this.delegate.actionPerformed(value, anEvent);
        return null;
    }

    public Component getFocusComponent() {
        return this.delegate.getFocusComponent();
    }

    public Component getComponent() {
        return this.comp;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.delegate.setBounds(x, y, width, height);
    }

    Color getBackgroundColor(Color color) {
        if (color.getAlpha() == 0) {
            return Color.WHITE;
        }
        return color;
    }

    public void setClickCountToStart(int clickCountToStart) {
        this.clickCountToStart = clickCountToStart;
    }

    public boolean isDisplayable() {
        return this.delegate.isDisplayable();
    }

    public boolean isCellEditable(EventObject anEvent) {
        return this.delegate.isCellEditable(anEvent);
    }

    protected class EditorDelegate
    implements ActionListener,
    ItemListener {
        protected BigDecimal measure = BgConstants.ONE;
        protected int decimal = 10;

        public EditorDelegate(BigDecimal measure, int decimal) {
            this.measure = measure;
            this.decimal = decimal;
        }

        public String getText() {
            return null;
        }

        public void setText(String text) {
        }

        public Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }

        public void setExpandValue(Object value) {
        }

        public boolean isCellEditable(EventObject anEvent) {
            if (anEvent == null) {
                return true;
            }
            if (anEvent instanceof MouseEvent) {
                return ((MouseEvent)anEvent).getClickCount() >= BgDefCellEditer.this.clickCountToStart;
            }
            return false;
        }

        public boolean isDisplayable() {
            return true;
        }

        public Component getFocusComponent() {
            return BgDefCellEditer.this.comp;
        }

        public void setBounds(int x, int y, int width, int height) {
            BgDefCellEditer.this.comp.setBounds(x, y, width, height);
        }

        public void initComponent(Object value, Object expandValue, Style style, EventObject anEvent) {
            BgDefCellEditer.this.comp.setOpaque(true);
            BgDefCellEditer.this.comp.setBorder(null);
            BgDefCellEditer.this.comp.setBackground(BgDefCellEditer.this.getBackgroundColor(style.getBackground()));
            BgDefCellEditer.this.comp.setForeground(style.getFontColor());
            BgDefCellEditer.this.comp.setFont((Font)style.getKDFont());
            this.setValue(value);
        }

        public void releaseComponent() {
        }

        public void actionPerformed(Object value, EventObject anEvent) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BgDefCellEditer.this.stopCellEditing();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            BgDefCellEditer.this.stopCellEditing();
        }
    }
}

