/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgDataTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgException;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormulaException;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.client.AbstractBgElementSelectListUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgExpProcess;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgTemplateProcessUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgElementSelectListUI
extends AbstractBgElementSelectListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgElementSelectListUI.class);
    protected static final String SOURCESRC = "com.kingdee.eas.ma.budget.client.BgFormulaResource";
    protected BgExpProcess expProcess = null;
    protected Object[] expformula = null;
    protected Object[] expParameter = null;
    protected Object processUI = null;
    protected BgFormInfo bgFormInfo = null;
    protected KDTable proTable = null;
    protected boolean isRowProcess = true;
    protected int activeRowIndex = 0;
    protected int activeColIndex = 0;
    protected int proRowCount = 0;
    protected int proColCount = 0;
    protected int numTitle = -1;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSystemInfo();
        this.initSystemOther();
        this.initTableInfo();
    }

    protected void initSystemInfo() throws EASBizException, BOSException {
        if (this.getUIContext().get("Owner") != null) {
            this.processUI = this.getUIContext().get("Owner");
        }
        if (this.getUIContext().get("bgFormInfo") != null && this.getUIContext().get("bgFormInfo") instanceof BgFormInfo) {
            this.bgFormInfo = (BgFormInfo)this.getUIContext().get("bgFormInfo");
        }
        if (this.getUIContext().get("BGFORMULA_TABLE") != null && this.getUIContext().get("BGFORMULA_TABLE") instanceof KDTable) {
            this.proTable = (KDTable)this.getUIContext().get("BGFORMULA_TABLE");
            if (this.proTable == null) {
                throw new BgFormulaException(BgFormulaException.PROCESSTABLEISNULL);
            }
            if (this.proTable.getUserObject() != null && this.proTable.getUserObject() instanceof HashMap) {
                HashMap aliasMap = (HashMap)this.proTable.getUserObject();
                this.isRowProcess = aliasMap.containsKey("BGFORMULA_ALIAS") ? Boolean.valueOf(aliasMap.get("BGFORMULA_ALIAS").toString()) != false : true;
            }
            this.activeRowIndex = this.proTable.getSelectManager().getActiveRowIndex();
            this.activeColIndex = this.proTable.getSelectManager().getActiveColumnIndex();
            this.proRowCount = this.proTable.getBody().size();
            this.proColCount = this.proTable.getColumnCount();
        }
        this.expProcess = BgExpProcess.getInstance(this.processUI);
        this.expformula = new Object[6];
        this.expParameter = new Object[8];
        BgElementDialog bgElementF7 = new BgElementDialog((IUIObject)this);
        bgElementF7.setIsChooseOne(true);
        this.prmtBgElement.setSelector((KDPromptSelector)bgElementF7);
        BgPeriodDialog bgPeriodF7 = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodF7);
        ICurrency icurrency = CurrencyFactory.getRemoteInstance();
        if (icurrency == null) {
            throw new BgException(BgException.NOINSTANCE);
        }
        CurrencyCollection currCol = icurrency.getCurrencyCollection(true);
        if (!currCol.isEmpty()) {
            this.comCurrency.addItem(null);
            this.comCurrency.addItems(currCol.toArray());
        }
    }

    protected void initSystemOther() {
        this.btnDeleteSelect.setText("");
        this.btnDeleteAll.setText("");
        this.btnInfoUp.setText("");
        this.btnInfoDown.setText("");
        this.btnMoveToTop.setText("");
        this.btnMoveTop.setText("");
        this.btnMoveDown.setText("");
        this.btnMoveToDown.setText("");
        this.btnDeleteSelect.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDeleteAll.setIcon(EASResource.getIcon((String)"imgTbtn_clear"));
        this.btnInfoUp.setIcon(EASResource.getIcon((String)"imgTbtn_upgrade"));
        this.btnInfoDown.setIcon(EASResource.getIcon((String)"imgTbtn_degrade"));
        this.btnMoveToTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop1"));
        this.btnMoveTop.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnMoveDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnMoveToDown.setIcon(EASResource.getIcon((String)"imgTbtn_movebottom"));
    }

    protected void initTableInfo() {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        int n = this.tblMain.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.tblMain.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    @Override
    protected void btnCreate_actionPerformed(ActionEvent e) throws Exception {
        super.btnCreate_actionPerformed(e);
        if (this.proTable == null) {
            throw new BgFormulaException(BgFormulaException.PROCESSTABLEISNULL);
        }
        this.processCreateFormulasInfo(this.proTable);
    }

    protected void processCreateFormulasInfo(KDTable table) {
        int rowCount = this.tblMain.getBody().size();
        if (rowCount > 0) {
            IRow row = null;
            Map bgItemMap = this.processBgItemInfo(table);
            int activeSelectIndex = 0;
            activeSelectIndex = this.isRowProcess ? this.activeColIndex : this.activeRowIndex;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                row = this.tblMain.getRow(rowIndex);
                if (this.isRowProcess) {
                    table.addColumn(activeSelectIndex);
                } else {
                    table.addRow(activeSelectIndex);
                }
                this.processCreateRowFormulaInfo(table, activeSelectIndex, row, bgItemMap);
                ++activeSelectIndex;
            }
            this.tblMain.removeRows();
            if (this.isRowProcess) {
                this.activeColIndex += rowCount;
                this.proColCount += rowCount;
            } else {
                this.activeRowIndex += rowCount;
                this.proRowCount += rowCount;
            }
            table.getSelectManager().select(this.activeRowIndex, this.activeColIndex, this.activeRowIndex, this.activeColIndex);
            table.repaint();
        }
    }

    protected void processCreateRowFormulaInfo(KDTable table, int activeSelectIndex, IRow row, Map bgItemMap) {
        if (table == null || activeSelectIndex < 0 || row == null || bgItemMap == null) {
            return;
        }
        ICell cell = null;
        String indexStr = null;
        String[] infoStr = null;
        BgPeriodInfo bgPeriodInfo = null;
        BgElementInfo bgElementInfo = null;
        CurrencyInfo currencyInfo = null;
        int count = 0;
        count = this.isRowProcess ? this.proRowCount : this.proColCount;
        if (row.getCell("bgPeriod").getValue() != null) {
            bgPeriodInfo = (BgPeriodInfo)row.getCell("bgPeriod").getValue();
            this.expformula[1] = bgPeriodInfo.getNumber();
        } else {
            this.expformula[1] = "";
        }
        if (row.getCell("bgElement").getValue() != null) {
            bgElementInfo = (BgElementInfo)row.getCell("bgElement").getValue();
            this.expformula[2] = bgElementInfo.getNumber();
        } else {
            this.expformula[2] = "";
        }
        this.expformula[3] = BgDataTypeEnum.BgData.getName();
        this.expformula[4] = "true";
        if (row.getCell("currency").getValue() != null) {
            currencyInfo = (CurrencyInfo)row.getCell("currency").getValue();
            this.expformula[5] = currencyInfo.getNumber();
        } else {
            this.expformula[5] = "";
        }
        int n = count;
        for (int i = 0; i < n; ++i) {
            indexStr = String.valueOf(i);
            if (!bgItemMap.containsKey(indexStr)) continue;
            infoStr = (String[])bgItemMap.get(indexStr);
            cell = this.isRowProcess ? table.getCell(i, activeSelectIndex) : table.getCell(activeSelectIndex, i);
            this.expformula[0] = infoStr[0];
            this.expProcess.process(cell, false, 0, this.expformula);
            if (bgElementInfo == null || bgElementInfo.getExtType().getValue() == 0) continue;
            try {
                this.expParameter[0] = Boolean.TRUE.toString();
                this.expParameter[1] = this.bgFormInfo == null ? "" : this.bgFormInfo.getOrgUnit().getNumber();
                this.expParameter[2] = this.bgFormInfo == null ? "" : this.bgFormInfo.getBgScheme().getNumber();
                this.expParameter[3] = bgElementInfo == null ? "" : bgElementInfo.getRefElement().getNumber();
                this.expParameter[4] = infoStr[0];
                this.expParameter[5] = this.expformula[5].equals("") ? this.bgFormInfo.getCurrency().getNumber() : this.expformula[5];
                this.expParameter[6] = BgPeriodHelper.getPreYearOfBgPeriodInfo(bgPeriodInfo).getNumber();
                this.expParameter[7] = this.expParameter[6];
                this.expProcess.process(cell, true, bgElementInfo.getExtType().getValue(), this.expParameter);
                continue;
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage());
            }
        }
        int n2 = this.numTitle = this.numTitle == -1 ? 0 : this.numTitle;
        if (this.isRowProcess) {
            if (bgPeriodInfo != null) {
                table.getCell(this.numTitle, activeSelectIndex).setValue((Object)bgPeriodInfo.getName());
            } else {
                table.getCell(this.numTitle, activeSelectIndex).setValue(null);
            }
            if (bgElementInfo != null) {
                table.getCell(this.numTitle + 1, activeSelectIndex).setValue((Object)bgElementInfo.getName());
            }
            if (currencyInfo != null) {
                table.getCell(this.numTitle + 2, activeSelectIndex).setValue((Object)currencyInfo.getName());
            } else {
                table.getCell(this.numTitle + 2, activeSelectIndex).setValue(null);
            }
        } else {
            if (bgPeriodInfo != null) {
                table.getCell(activeSelectIndex, this.numTitle).setValue((Object)bgPeriodInfo.getName());
            } else {
                table.getCell(activeSelectIndex, this.numTitle).setValue(null);
            }
            if (bgElementInfo != null) {
                table.getCell(activeSelectIndex, this.numTitle + 1).setValue((Object)bgElementInfo.getName());
            }
            if (currencyInfo != null) {
                table.getCell(activeSelectIndex, this.numTitle + 2).setValue((Object)currencyInfo.getName());
            } else {
                table.getCell(activeSelectIndex, this.numTitle + 2).setValue(null);
            }
        }
        if (this.isRowProcess) {
            if (bgElementInfo != null) {
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGELEMENT", bgElementInfo.getNumber());
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGELEMENT_NAME", bgElementInfo.getName());
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGELEMENT_DATATYPE", bgElementInfo.getDataType().getName());
                if (bgElementInfo.getExtType().getValue() != 0) {
                    BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGELEMENT_EXTTYPE", bgElementInfo.getExtType().getName());
                    BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGELEMENT_EXTELEMENT", bgElementInfo.getRefElement().getNumber());
                }
            }
            if (bgPeriodInfo != null) {
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGPERIOD", bgPeriodInfo.getNumber());
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_BGPERIOD_NAME", bgPeriodInfo.getName());
            }
            if (currencyInfo != null) {
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_CURRENCY", currencyInfo.getNumber());
                BgSHelper.setColObject(table.getColumn(activeSelectIndex), "BGFORMULA_CURRENCY_NAME", currencyInfo.getName());
            }
        }
    }

    protected Map processBgItemInfo(KDTable table) {
        HashMap<String, String[]> bgItemMap = new HashMap<String, String[]>();
        Map infoMap = null;
        IRow row = null;
        IColumn column = null;
        String[] infoStr = null;
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        if (this.isRowProcess) {
            int n = rowCount;
            for (int i = 0; i < n; ++i) {
                row = table.getRow(i);
                if (row.getUserObject() == null || !(row.getUserObject() instanceof HashMap)) continue;
                infoMap = (Map)row.getUserObject();
                if (infoMap.containsKey("BGFORMULA_BGITEM")) {
                    infoStr = new String[]{(String)infoMap.get("BGFORMULA_BGITEM")};
                    bgItemMap.put(String.valueOf(i), infoStr);
                }
                if (this.numTitle != -1 || !infoMap.containsKey("BGFORMULA_ALIAS_TITLE")) continue;
                this.numTitle = i;
            }
        } else {
            int n = colCount;
            for (int i = 0; i < n; ++i) {
                column = table.getColumn(i);
                if (column.getUserObject() == null || !(column.getUserObject() instanceof HashMap)) continue;
                infoMap = (Map)column.getUserObject();
                if (infoMap.containsKey("BGFORMULA_BGITEM")) {
                    infoStr = new String[6];
                    infoStr[0] = (String)infoMap.get("BGFORMULA_BGITEM");
                    bgItemMap.put(String.valueOf(i), infoStr);
                }
                if (this.numTitle != -1 || !infoMap.containsKey("BGFORMULA_ALIAS_TITLE")) continue;
                this.numTitle = i;
            }
        }
        return bgItemMap;
    }

    @Override
    protected void btnClose_actionPerformed(ActionEvent e) throws Exception {
        super.btnClose_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    protected void btnDeleteSelect_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteSelect_actionPerformed(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex >= 0) {
            int re = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCESRC, (String)"deleteSelectInfo"));
            if (re == 1 || re == 2) {
                return;
            }
            this.tblMain.removeRow(activeRowIndex);
        }
    }

    @Override
    protected void btnDeleteAll_actionPerformed(ActionEvent e) throws Exception {
        super.btnDeleteAll_actionPerformed(e);
        int re = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)SOURCESRC, (String)"deleteSelectAll"));
        if (re == 1 || re == 2) {
            return;
        }
        this.tblMain.removeRows();
    }

    @Override
    protected void btnInfoUp_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        super.btnInfoUp_actionPerformed(e);
        if (this.prmtBgElement.getData() == null) {
            this.prmtBgElement.requestFocus();
            throw new BgFormulaException(BgFormulaException.SELECTBGELEMENTISNULL);
        }
        if (BgTemplateProcessUI.class.isAssignableFrom(this.processUI.getClass())) {
            if (this.prmtBgPeriod.getData() == null) {
                this.prmtBgPeriod.requestFocus();
                throw new BgFormulaException(BgFormulaException.SELECTBGPERIODISNULL);
            }
            if (this.comCurrency.getSelectedIndex() <= 0) {
                this.comCurrency.requestFocus();
                throw new BgFormulaException(BgFormulaException.SELECTCURRENCYISNULL);
            }
        }
        if ((row = this.tblMain.addRow()) != null) {
            BgElementInfo bgElementInfo = (BgElementInfo)this.prmtBgElement.getData();
            row.getCell("bgElement").setValue((Object)bgElementInfo);
            row.getCell("bgElement.name").setValue((Object)bgElementInfo.getName());
            this.prmtBgElement.setData(null);
            if (this.prmtBgPeriod.getData() != null) {
                BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.prmtBgPeriod.getData();
                row.getCell("bgPeriod").setValue((Object)bgPeriodInfo);
                row.getCell("bgPeriod.name").setValue((Object)bgPeriodInfo.getName());
                this.prmtBgPeriod.setData(null);
            }
            if (this.comCurrency.getSelectedItem() != null) {
                CurrencyInfo currencyInfo = (CurrencyInfo)this.comCurrency.getSelectedItem();
                row.getCell("currency").setValue((Object)currencyInfo);
                row.getCell("currency.name").setValue((Object)currencyInfo.getName());
                this.comCurrency.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected void btnInfoDown_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        super.btnInfoDown_actionPerformed(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex >= 0 && (row = this.tblMain.getRow(activeRowIndex)) != null) {
            this.prmtBgElement.setData(row.getCell("bgElement").getValue());
            this.prmtBgPeriod.setData(row.getCell("bgPeriod").getValue());
            if (row.getCell("currency").getValue() == null) {
                this.comCurrency.setSelectedIndex(0);
            } else {
                BgClientHelper.setSelectObject(this.comCurrency, row.getCell("currency").getValue());
            }
            this.tblMain.removeRow(activeRowIndex);
        }
    }

    @Override
    protected void btnMoveToTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveToTop_actionPerformed(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex >= 0) {
            IRow row = this.tblMain.getRow(activeRowIndex);
            IRow rowTop = this.tblMain.addRow(0);
            if (rowTop != null && row != null) {
                int n = this.tblMain.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    rowTop.getCell(i).setValue(row.getCell(i).getValue());
                }
                this.tblMain.removeRow(activeRowIndex + 1);
                this.tblMain.getSelectManager().select(0, 0);
            }
        }
    }

    @Override
    protected void btnMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveTop_actionPerformed(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex > 0) {
            IRow rowTop = this.tblMain.getRow(activeRowIndex - 1);
            IRow row = this.tblMain.getRow(activeRowIndex);
            if (rowTop != null && row != null) {
                Object[] obj = new Object[]{rowTop.getCell("bgElement").getValue(), rowTop.getCell("bgPeriod").getValue(), rowTop.getCell("currency").getValue(), row.getCell("bgElement").getValue(), row.getCell("bgPeriod").getValue(), row.getCell("currency").getValue()};
                BgElementInfo bgElementInfo = null;
                BgPeriodInfo bgPeriodInfo = null;
                CurrencyInfo currencyInfo = null;
                if (obj[0] != null) {
                    bgElementInfo = (BgElementInfo)obj[0];
                    row.getCell("bgElement").setValue((Object)bgElementInfo);
                    row.getCell("bgElement.name").setValue((Object)bgElementInfo.getName());
                }
                if (obj[1] != null) {
                    bgPeriodInfo = (BgPeriodInfo)obj[1];
                    row.getCell("bgPeriod").setValue((Object)bgPeriodInfo);
                    row.getCell("bgPeriod.name").setValue((Object)bgPeriodInfo.getName());
                }
                if (obj[2] != null) {
                    currencyInfo = (CurrencyInfo)obj[2];
                    row.getCell("currency").setValue((Object)currencyInfo);
                    row.getCell("currency.name").setValue((Object)currencyInfo.getName());
                }
                if (obj[3] != null) {
                    bgElementInfo = (BgElementInfo)obj[3];
                    rowTop.getCell("bgElement").setValue((Object)bgElementInfo);
                    rowTop.getCell("bgElement.name").setValue((Object)bgElementInfo.getName());
                }
                if (obj[4] != null) {
                    bgPeriodInfo = (BgPeriodInfo)obj[4];
                    rowTop.getCell("bgPeriod").setValue((Object)bgPeriodInfo);
                    rowTop.getCell("bgPeriod.name").setValue((Object)bgPeriodInfo.getName());
                }
                if (obj[5] != null) {
                    currencyInfo = (CurrencyInfo)obj[5];
                    rowTop.getCell("currency").setValue((Object)currencyInfo);
                    rowTop.getCell("currency.name").setValue((Object)currencyInfo.getName());
                }
                this.tblMain.getSelectManager().select(activeRowIndex - 1, 0);
            }
        }
    }

    @Override
    protected void btnMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveDown_actionPerformed(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (activeRowIndex < this.tblMain.getBody().size() - 1) {
            IRow rowDown = this.tblMain.getRow(activeRowIndex + 1);
            IRow row = this.tblMain.getRow(activeRowIndex);
            if (rowDown != null && row != null) {
                Object[] obj = new Object[]{rowDown.getCell("bgElement").getValue(), rowDown.getCell("bgPeriod").getValue(), rowDown.getCell("currency").getValue(), row.getCell("bgElement").getValue(), row.getCell("bgPeriod").getValue(), row.getCell("currency").getValue()};
                BgElementInfo bgElementInfo = null;
                BgPeriodInfo bgPeriodInfo = null;
                CurrencyInfo currencyInfo = null;
                if (obj[0] != null) {
                    bgElementInfo = (BgElementInfo)obj[0];
                    row.getCell("bgElement").setValue((Object)bgElementInfo);
                    row.getCell("bgElement.name").setValue((Object)bgElementInfo.getName());
                }
                if (obj[1] != null) {
                    bgPeriodInfo = (BgPeriodInfo)obj[1];
                    row.getCell("bgPeriod").setValue((Object)bgPeriodInfo);
                    row.getCell("bgPeriod.name").setValue((Object)bgPeriodInfo.getName());
                }
                if (obj[2] != null) {
                    currencyInfo = (CurrencyInfo)obj[2];
                    row.getCell("currency").setValue((Object)currencyInfo);
                    row.getCell("currency.name").setValue((Object)currencyInfo.getName());
                }
                if (obj[3] != null) {
                    bgElementInfo = (BgElementInfo)obj[3];
                    rowDown.getCell("bgElement").setValue((Object)bgElementInfo);
                    rowDown.getCell("bgElement.name").setValue((Object)bgElementInfo.getName());
                }
                if (obj[4] != null) {
                    bgPeriodInfo = (BgPeriodInfo)obj[4];
                    rowDown.getCell("bgPeriod").setValue((Object)bgPeriodInfo);
                    rowDown.getCell("bgPeriod.name").setValue((Object)bgPeriodInfo.getName());
                }
                if (obj[5] != null) {
                    currencyInfo = (CurrencyInfo)obj[5];
                    rowDown.getCell("currency").setValue((Object)currencyInfo);
                    rowDown.getCell("currency.name").setValue((Object)currencyInfo.getName());
                }
                this.tblMain.getSelectManager().select(activeRowIndex + 1, 0);
            }
        }
    }

    @Override
    protected void btnMoveToDown_actionPerformed(ActionEvent e) throws Exception {
        super.btnMoveToDown_actionPerformed(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        int rowCount = this.tblMain.getBody().size();
        if (activeRowIndex < rowCount - 1) {
            IRow row = this.tblMain.getRow(activeRowIndex);
            IRow rowDown = this.tblMain.addRow();
            if (rowDown != null && row != null) {
                int n = this.tblMain.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    rowDown.getCell(i).setValue(row.getCell(i).getValue());
                }
                this.tblMain.removeRow(activeRowIndex);
                this.tblMain.getSelectManager().select(rowCount - 1, 0);
            }
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        int rowCount = this.tblMain.getBody().size();
        if (activeRowIndex == 0) {
            this.btnMoveToTop.setEnabled(false);
            this.btnMoveTop.setEnabled(false);
            this.btnMoveDown.setEnabled(true);
            this.btnMoveToDown.setEnabled(true);
        } else if (activeRowIndex == rowCount - 1) {
            this.btnMoveToTop.setEnabled(true);
            this.btnMoveTop.setEnabled(true);
            this.btnMoveDown.setEnabled(false);
            this.btnMoveToDown.setEnabled(false);
        } else {
            this.btnMoveToTop.setEnabled(true);
            this.btnMoveTop.setEnabled(true);
            this.btnMoveDown.setEnabled(true);
            this.btnMoveToDown.setEnabled(true);
        }
    }
}

