/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.ExtendPropertyCollection;
import com.kingdee.bos.metadata.entity.ExtendPropertyInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.SubQueryInfo;
import com.kingdee.bos.metadata.query.UnionQueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.parser.TokenList;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.BaseCommonQueryClientException;
import com.kingdee.eas.base.commonquery.BooleanEnum;
import com.kingdee.eas.base.commonquery.ColumnItemData;
import com.kingdee.eas.base.commonquery.CompareSignEnum;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoCollection;
import com.kingdee.eas.base.commonquery.DyAssignUserInfoInfo;
import com.kingdee.eas.base.commonquery.DyQueryFieldCollection;
import com.kingdee.eas.base.commonquery.DyQueryFieldInfo;
import com.kingdee.eas.base.commonquery.DySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.DynamicSolutionFactory;
import com.kingdee.eas.base.commonquery.DynamicSolutionInfo;
import com.kingdee.eas.base.commonquery.IDySolutionFacade;
import com.kingdee.eas.base.commonquery.IDynamicSolution;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SorterSignEnum;
import com.kingdee.eas.base.commonquery.TableXMLHelper;
import com.kingdee.eas.base.commonquery.UserCustomConfigItemData;
import com.kingdee.eas.base.commonquery.UserPreferenceData;
import com.kingdee.eas.base.commonquery.client.DataObject;
import com.kingdee.eas.base.commonquery.client.DefaultPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.base.commonquery.client.RowObject;
import com.kingdee.eas.base.permission.FieldAccessInfo;
import com.kingdee.eas.base.permission.FieldPermission;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public final class BgEntityUtil {
    private static final String DEFAULT_F7_QUERY = "defaultF7Query";
    private static final String DEFAULT_F7_UI = "defaultF7UI";
    private static final String DEFAULT_DISPLAY_FIELD = "defaultDisplayField";
    private static final String F7_DISPLAY_FORMAT = "displayFormat";
    private static final String F7_EDIT_FORMAT = "editFormat";
    private static final String F7_COMMIT_FORMAT = "commitFormat";
    private static final String IS_SIMPLE_ENTITY = "isSimpleEntity";
    private static final String IS_COMMON_QUERY_FILTER = "isCommonQueryFilter";
    private static final String IS_COMMON_QUERY_SORTER = "isCommonQuerySorter";
    private static final String IS_USING_F7 = "isUsingF7";
    private static final String CO_WIDYTH_IN_KDTABLE = "colWidthInKDTable";
    private static final String IS_REVERSE_LINK = "isRevserseLink";
    private static final String REVERSE_LINK_PROPName = "revserseLinkProName";
    private static final String IS_VISIBLE_FOR_KDTABLE = "isVisibleForKDTable";
    private static final String commonQueryFilterRes = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";
    private static final String commonEntityFilterRes = "com.kingdee.eas.base.commonquery.client.CommonEntityFilter";
    public static final int USER_LEVEL_VALUE = 1;
    public static final int ORG_LEVEL_VALUE = 2;
    public static final int CU_LEVEL_VALUE = 4;
    public static final int PUBLI_LEVEL_VALUE = 8;
    private static Logger logger = Logger.getLogger(BgEntityUtil.class);

    protected static Object[] addObjectToArray(Object[] objects, Object insertObject) {
        Object[] DEFAULT_OBJECTs = new Object[]{insertObject};
        if (objects == null) {
            return DEFAULT_OBJECTs;
        }
        int length = objects.length;
        if (length == 0) {
            return DEFAULT_OBJECTs;
        }
        Object[] results = new Object[length + 1];
        results[0] = DEFAULT_OBJECTs[0];
        for (int i = 1; i <= length; ++i) {
            results[i] = objects[i - 1];
        }
        return results;
    }

    protected static KDComboBox setComboBoxField(KDTable kdTable, int rowIndex, int colIndex, Object[] objs) {
        KDComboBox kdComboBox = new KDComboBox(objs);
        kdComboBox.setMaximumRowCount(10);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor((JComboBox)kdComboBox);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
        return kdComboBox;
    }

    public static Window getWindow(Component component) {
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            return (Window)parent;
        }
        return null;
    }

    public static Component getComponent(Component component, String targetName) {
        Component child = component;
        Container parent = child.getParent();
        while (parent != null) {
            child = parent;
            String name = child.getClass().getName();
            if (name == null) continue;
            if (name.equalsIgnoreCase(targetName)) {
                return child;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static Object getValue(Object object) {
        Object value = "";
        if (object != null) {
            value = object instanceof Enum ? BgEntityUtil.getEnumValue((Enum)object) : (object instanceof Date ? object : (object instanceof DataObject ? ((DataObject)object).getValue() : object.toString()));
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            value = value == null ? "" : ((String)value).trim();
        }
        return value;
    }

    protected static QueryFieldInfo getQueryFieldInfo(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = new QueryFieldInfo();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !(queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName().equalsIgnoreCase(queryFieldName)) continue;
            return queryFieldInfo;
        }
        return queryFieldInfo;
    }

    protected static PropertyInfo getQueryFieldInfo(EntityObjectInfo entity, String queryFieldName) {
        PropertyInfo propertyInfo = null;
        PropertyCollection propertyUnitCollection = entity.getProperties();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            propertyInfo = propertyUnitCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(queryFieldName)) continue;
            return propertyInfo;
        }
        return propertyInfo;
    }

    public static HashMap getQueryFieldCollection(QueryInfo queryInfo, Component owner) {
        HashMap<String, ColumnItemData> fieldMap = new HashMap<String, ColumnItemData>();
        if (owner instanceof ListUI) {
            ListUI listui = (ListUI)owner;
            KDTable kdt = listui.getTableForBOTP();
            int frozenColIndex = kdt.getViewManager().getFreezeCol();
            int j = kdt.getColumnCount();
            for (int i = 0; i < j; ++i) {
                IColumn col = kdt.getColumn(i);
                String key = col.getKey();
                if (StringUtils.isEmpty((String)key)) continue;
                ColumnItemData columnData = new ColumnItemData();
                columnData.setIndex(i);
                columnData.setKey(key);
                if (kdt.getHeadRowCount() == 1) {
                    Object v = kdt.getHeadRow(0).getCell(i).getValue();
                    String title = v == null ? "" : String.valueOf(v);
                    columnData.setTitle(title);
                } else {
                    columnData.setTitle(BgEntityUtil.getColTitle(kdt, i));
                }
                int width = col.getKDTColumn().getWidth();
                if (width == -1) {
                    width = col.getWidth();
                }
                columnData.setWidth(width);
                columnData.setAlign(col.getStyleAttributes().getHorizontalAlign());
                columnData.setHidden(col.getStyleAttributes().isHided());
                columnData.setLocked(false);
                if (frozenColIndex == 0) {
                    columnData.setLocked(false);
                } else if (i < frozenColIndex) {
                    columnData.setLocked(true);
                } else {
                    columnData.setLocked(false);
                }
                if (!BgEntityUtil.isShow(columnData) || !BgEntityUtil.IsFieldPermit(queryInfo, columnData.getKey())) continue;
                fieldMap.put(columnData.getKey(), columnData);
            }
        }
        return fieldMap;
    }

    private static boolean isShow(ColumnItemData columnData) {
        return (!columnData.getKey().equals("id") || !columnData.isHidden()) && columnData.getWidth() > 0;
    }

    public static String getTableParams(QueryInfo info, Component owner) {
        HashMap map = BgEntityUtil.getQueryFieldCollection(null, owner);
        UserCustomConfigItemData itemData = new UserCustomConfigItemData();
        for (String key : map.keySet()) {
            ColumnItemData colData = (ColumnItemData)map.get(key);
            itemData.getColumnData().put(colData.getKey(), colData);
        }
        itemData.getGenericData().put("RowHeight", "20");
        try {
            UserPreferenceData userData = new UserPreferenceData();
            userData.setVersion(UserPreferenceData.VER_2_0_0);
            userData.getSolutions().put("solution", itemData);
            StringWriter writer = null;
            writer = new StringWriter();
            TableXMLHelper.saveData((UserPreferenceData)userData, (Writer)writer, (String)"UTF-8");
            return writer.toString();
        }
        catch (Exception e) {
            logger.error((Object)("get tableparams error:" + e));
            return null;
        }
    }

    private static String getColTitle(KDTable tb, int colIndex) {
        int rowCnt = tb.getHeadRowCount();
        String result = "";
        for (int k = 0; k < rowCnt; ++k) {
            IRow row = tb.getHeadRow(k);
            ICell cell = row.getCell(colIndex);
            Object cellValue = cell.getValue();
            if (cell.getStyleAttributes().isHided()) continue;
            if (cellValue == null) {
                if (cell.getMergeBlock() == null || cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() <= 0) continue;
                if (result != null && result.length() > 0) {
                    result = result + "-";
                }
                result = result + String.valueOf(row.getCell(cell.getMergeBlock().getLeft()).getValue());
                continue;
            }
            String tmpValue = String.valueOf(cell.getValue());
            if (cell.getMergeBlock() != null) {
                if (cell.getMergeBlock().getRight() - cell.getMergeBlock().getLeft() > 0) {
                    tmpValue = String.valueOf(row.getCell(cell.getMergeBlock().getLeft()).getValue());
                }
                if (cell.getMergeBlock().getBottom() - cell.getMergeBlock().getTop() > 0 && result != null && result.length() > 0) {
                    tmpValue = "";
                }
            }
            if (result != null && result.length() > 0 && tmpValue.length() > 0) {
                result = result + "-";
            }
            result = result + tmpValue;
        }
        return result;
    }

    public static boolean IsFieldPermit(QueryInfo queryInfo, String key) {
        if (queryInfo == null) {
            return true;
        }
        boolean flag = true;
        FieldPermission fields = null;
        FieldAccessInfo fieldAccess = null;
        MetaDataPK queryPK = new MetaDataPK(queryInfo.getName());
        ObjectUuidPK userPK = new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        ObjectUuidPK orgPK = new ObjectUuidPK(BOSUuid.read((String)SysContext.getSysContext().getCurrentOrgUnit().getId().toString()));
        try {
            fields = PermissionHelper.getQueryFieldPermission((IMetaDataPK)queryPK, (IObjectPK)userPK, (IObjectPK)orgPK);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        for (int i = 0; i < fields.size(); ++i) {
            fieldAccess = fields.get(i);
            String fieldName = fieldAccess.getFieldName();
            if (!key.equals(fieldName) || fieldAccess.isViewable()) continue;
            flag = false;
            break;
        }
        return flag;
    }

    private static HashMap getFieldFromQuery(QueryInfo queryInfo) {
        HashMap<String, ColumnItemData> fieldMap = new HashMap<String, ColumnItemData>();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        if (propertyUnitCollection != null) {
            int size = propertyUnitCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
                ColumnItemData item = new ColumnItemData();
                QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
                item.setKey(queryFieldInfo.getName());
                item.setIndex(i);
                item.setTitle(queryFieldInfo.getDisplayName());
                String tempWidth = queryFieldInfo.getExtendedProperty(CO_WIDYTH_IN_KDTABLE);
                if (tempWidth != null && !tempWidth.trim().equalsIgnoreCase("")) {
                    item.setWidth(Integer.valueOf(tempWidth).intValue());
                } else {
                    item.setWidth(50);
                }
                item.setHidden(!queryFieldInfo.isIsSelector());
                if (item.isHidden() || StringUtils.isEmpty((String)item.getTitle()) || item.getTitle().equals("ID")) continue;
                fieldMap.put(item.getKey(), item);
            }
        }
        return fieldMap;
    }

    protected static boolean isLikeCompare(CompareSignEnum compareSignEnum) {
        if (compareSignEnum != null) {
            if (compareSignEnum.equals((Object)CompareSignEnum.LIKESIGN)) {
                return true;
            }
            if (compareSignEnum.equals((Object)CompareSignEnum.NOTLIKESIGN)) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isIncludeCompare(CompareSignEnum compareSignEnum) {
        if (compareSignEnum != null) {
            if (compareSignEnum.equals((Object)CompareSignEnum.INCLUDESIGN)) {
                return true;
            }
            if (compareSignEnum.equals((Object)CompareSignEnum.NOTINCLUDESIGN)) {
                return true;
            }
        }
        return false;
    }

    protected static Set processIncludeValue(String str) {
        HashSet<String> value = new HashSet<String>();
        if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken();
                value.add(temp);
            }
        } else {
            value.add(str);
        }
        return value;
    }

    protected static Vector processStringValue(String str) {
        Vector<String> vect = new Vector<String>();
        if (str.indexOf(",") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ",");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else if (str.indexOf(";") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(str, ";");
            while (tokenizer.hasMoreTokens()) {
                String temp = tokenizer.nextToken().trim();
                vect.add(temp);
            }
        } else {
            vect.add(str);
        }
        return vect;
    }

    public static boolean IsStringValue(String str) {
        return str.indexOf(",") > 0 || str.indexOf(";") > 0;
    }

    protected static String processLikeValue(String value) {
        return value;
    }

    protected static ArrayList getEntitiyNames(QueryInfo queryInfo) {
        ArrayList<String> entityNames = new ArrayList<String>();
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            String entityName;
            SubEntityInfo subEntityInfo;
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (subObjectInfo instanceof SubEntityInfo) {
                subEntityInfo = (SubEntityInfo)subObjectInfo;
                entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
                entityNames.add(entityName);
                continue;
            }
            if (!(subObjectInfo instanceof SubQueryInfo)) continue;
            try {
                subObjectInfo = ((SubQueryInfo)subObjectInfo).getQueryRef().getMainObject();
                if (!(subObjectInfo instanceof SubEntityInfo)) continue;
                subEntityInfo = (SubEntityInfo)subObjectInfo;
                entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
                entityNames.add(entityName);
                continue;
            }
            catch (BOSException ex) {
                logger.error((Object)"budget error:", (Throwable)ex);
            }
        }
        return entityNames;
    }

    private static String getEntityNameFromQuery(QueryInfo queryInfo, String entityNameOfQueryField) {
        String entityName = null;
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubEntityInfo subEntityInfo;
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo) || !(subEntityInfo = (SubEntityInfo)subObjectInfo).getName().equalsIgnoreCase(entityNameOfQueryField)) continue;
            entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            return entityName;
        }
        return entityName;
    }

    private static boolean isMainObject(String entityNames, String value) {
        String entityName = entityNames.substring(entityNames.lastIndexOf(".") + 1);
        return entityName.equalsIgnoreCase(value);
    }

    private static DataObject getDataTypeInfo(boolean isUsingF7, OwnPropertyInfo ownPropertyInfo, String entityName) {
        DataObject dataObject = null;
        if (entityName == null) {
            if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                String metaDataEnumName = ownPropertyInfo.getMetaDataRef();
                BizEnumInfo _enum = BgEntityUtil.getEnum(metaDataEnumName);
                dataObject.setValue(_enum.getClassName());
                return dataObject;
            }
            if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(BooleanEnum.class.getName());
                return dataObject;
            }
            if (ownPropertyInfo.getDataType().equals((Object)DataType.DATE) || ownPropertyInfo.getDataType().equals((Object)DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals((Object)DataType.TIME)) {
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(null);
                return dataObject;
            }
            if (ownPropertyInfo.getDataType().equals((Object)DataType.SHORT) || ownPropertyInfo.getDataType().equals((Object)DataType.INTEGER) || ownPropertyInfo.getDataType().equals((Object)DataType.LONG) || ownPropertyInfo.getDataType().equals((Object)DataType.FLOAT) || ownPropertyInfo.getDataType().equals((Object)DataType.DOUBLE) || ownPropertyInfo.getDataType().equals((Object)DataType.DECIMAL)) {
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(null);
                return dataObject;
            }
            return null;
        }
        if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
            dataObject = new DataObject();
            dataObject.setName(ownPropertyInfo.getDataType().getName());
            String enumName = ownPropertyInfo.getMetaDataRef();
            BizEnumInfo _enum = BgEntityUtil.getEnum(enumName);
            dataObject.setValue(_enum.getClassName());
            return dataObject;
        }
        if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
            dataObject = new DataObject();
            dataObject.setName(ownPropertyInfo.getDataType().getName());
            dataObject.setValue(BooleanEnum.class.getName());
            return dataObject;
        }
        if (ownPropertyInfo.getDataType().equals((Object)DataType.DATE) || ownPropertyInfo.getDataType().equals((Object)DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals((Object)DataType.TIME)) {
            dataObject = new DataObject();
            dataObject.setName(ownPropertyInfo.getDataType().getName());
            dataObject.setValue(null);
            return dataObject;
        }
        if (ownPropertyInfo.getDataType().equals((Object)DataType.SHORT) || ownPropertyInfo.getDataType().equals((Object)DataType.INTEGER) || ownPropertyInfo.getDataType().equals((Object)DataType.LONG) || ownPropertyInfo.getDataType().equals((Object)DataType.FLOAT) || ownPropertyInfo.getDataType().equals((Object)DataType.DOUBLE) || ownPropertyInfo.getDataType().equals((Object)DataType.DECIMAL)) {
            if (isUsingF7) {
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(entityName);
                return dataObject;
            }
            dataObject = new DataObject();
            dataObject.setName(ownPropertyInfo.getDataType().getName());
            dataObject.setValue(null);
            return dataObject;
        }
        if (isUsingF7) {
            dataObject = new DataObject();
            dataObject.setName("F7");
            dataObject.setValue(entityName);
            return dataObject;
        }
        return null;
    }

    protected static DataObject getRefMetaData(QueryInfo queryInfo, String queryFieldName) {
        if (queryFieldName == null || queryFieldName.equals("")) {
            return null;
        }
        if (queryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo uqInfo = (UnionQueryInfo)queryInfo;
            SubObjectInfo subObj = null;
            Object subObj1 = null;
            try {
                subObj = uqInfo.getMainObject();
                if (subObj instanceof SubQueryInfo) {
                    queryInfo = ((SubQueryInfo)subObj).getQueryRef();
                }
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        DataObject dataObject = null;
        ArrayList entityNames = BgEntityUtil.getEntitiyNames(queryInfo);
        String mainEntityName = entityNames.get(0).toString();
        int i = 0;
        QueryFieldInfo queryFieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
        int propertyRefCollectionSize = propertyRefCollection.size();
        if (i < propertyRefCollectionSize) {
            PropertyRefInfo propertyRefInfo = propertyRefCollection.get(i);
            String currentEntityName = BgEntityUtil.getEntityNameFromQuery(queryInfo, propertyRefInfo.getSubEntity().getName());
            if (currentEntityName.equalsIgnoreCase(entityNames.get(0).toString())) {
                EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(currentEntityName);
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)BgEntityUtil.getEntityPropertyByName(entityObjectInfo, propertyRefInfo.getRefProperty().getName());
                return BgEntityUtil.getDataTypeInfo(false, ownPropertyInfo, null);
            }
            if (BgEntityUtil.isPKField(queryInfo, queryFieldName)) {
                dataObject = new DataObject();
                EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(currentEntityName);
                if (BgEntityUtil.isSimpleEntity(entityObjectInfo)) {
                    dataObject.setName("SIMPLE_ENTITY");
                    dataObject.setValue(currentEntityName);
                    return dataObject;
                }
                if (BgEntityUtil.isUsingF7(queryInfo, queryFieldName)) {
                    dataObject.setName("F7");
                    dataObject.setValue(currentEntityName);
                    return dataObject;
                }
                return null;
            }
            EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(currentEntityName);
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)BgEntityUtil.getEntityPropertyByName(entityObjectInfo, propertyRefInfo.getRefProperty().getName());
            boolean isUsingF7 = BgEntityUtil.isUsingF7(queryInfo, queryFieldName);
            return BgEntityUtil.getDataTypeInfo(isUsingF7, ownPropertyInfo, currentEntityName);
        }
        return dataObject;
    }

    private static boolean isSimpleEntity(EntityObjectInfo entity) {
        Map extendProperty = entity.getExtendedProperties();
        Object objIsSimple = entity.getExtendedProperties().get(IS_SIMPLE_ENTITY);
        String isSimple = "false";
        if (objIsSimple != null) {
            isSimple = objIsSimple.toString();
        }
        return Boolean.valueOf(isSimple);
    }

    protected static PropertyInfo getEntityPropertyByName(EntityObjectInfo entityObjectInfo, String propertyName) {
        PropertyInfo target = null;
        while (entityObjectInfo != null && entityObjectInfo.getPropertyByName(propertyName) == null) {
            entityObjectInfo = entityObjectInfo.getBaseEntity();
        }
        if (entityObjectInfo == null) {
            return null;
        }
        target = entityObjectInfo.getPropertyByName(propertyName);
        return target;
    }

    protected static String getEntityPropertyName(QueryInfo queryInfo, String queryFieldName) {
        String propertyName = null;
        QueryFieldInfo fieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        propertyName = fieldInfo.getPropertyRefs().get(0).getRefProperty().getName();
        return propertyName;
    }

    private static String getEntityName(QueryInfo queryInfo, String queryFieldName) {
        String entityName = null;
        QueryFieldInfo fieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String entityNameInQueryField = fieldInfo.getPropertyRefs().get(0).getSubEntity().getName();
        entityName = BgEntityUtil.getEntityNameFromQuery(queryInfo, entityNameInQueryField);
        return entityName;
    }

    private static boolean isPKField(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String propertyName = BgEntityUtil.getEntityPropertyName(queryInfo, queryFieldName);
        String entityName = BgEntityUtil.getEntityName(queryInfo, queryFieldName);
        return BgEntityUtil.isEntityPK(BgEntityUtil.getEntity(entityName), propertyName);
    }

    public static boolean isEntityPK(EntityObjectInfo entity, String propertyName) {
        while (entity != null) {
            PropertyCollection propertyCollection = entity.getLogicalKey().getKeyPropertys();
            int size = propertyCollection.size();
            if (size > 1) {
                throw new IllegalArgumentException("not support multi LogicalKey");
            }
            for (int j = 0; j < size; ++j) {
                PropertyInfo propertyInfo = propertyCollection.get(j);
                if (!propertyInfo.getName().equalsIgnoreCase(propertyName)) continue;
                return true;
            }
            entity = entity.getBaseEntity();
        }
        return false;
    }

    public static boolean checkIsMultiEntry(EntityObjectInfo entity, PropertyInfo propertyInfo) {
        boolean flag = false;
        if (propertyInfo instanceof LinkPropertyInfo) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo linkEntity = BgEntityUtil.getEntity(entity.getFullName(), linkPropertyInfo);
            RelationshipInfo relationshipInfo = linkPropertyInfo.getRelationship();
            if (relationshipInfo.getClientObject().getFullName().equalsIgnoreCase(linkEntity.getFullName())) {
                return BgEntityUtil.isMultiCardinalityType(relationshipInfo.getClientCardinality());
            }
            if (relationshipInfo.getSupplierObject().getFullName().equalsIgnoreCase(linkEntity.getFullName())) {
                return BgEntityUtil.isMultiCardinalityType(relationshipInfo.getSupplierCardinality());
            }
            throw new IllegalArgumentException("relationship is error");
        }
        return flag;
    }

    private static boolean isMultiCardinalityType(CardinalityType type) {
        if (type == null) {
            throw new IllegalArgumentException("relationship is null");
        }
        return type.equals((Object)CardinalityType.ONE_TO_UNBOUNDED) || type.equals((Object)CardinalityType.ZERO_TO_UNBOUNDED);
    }

    protected static KDComboBox setEnumComboBoxField(KDTable table, int rowIndex, int colIndex, String enumClassName, String fieldValue) {
        Object[] temp = BgEntityUtil.addObjectToArray(EnumUtils.getEnumList((String)enumClassName).toArray(), "");
        KDComboBox comboBox = BgEntityUtil.setComboBoxField(table, rowIndex, colIndex, temp);
        comboBox.setMaximumRowCount(10);
        List enumList = EnumUtils.getEnumList((String)enumClassName);
        int count = comboBox.getItemCount();
        int selectedIndex = 0;
        for (int i = 0; i < count; ++i) {
            Object obj = comboBox.getItemAt(i);
            Object value = null;
            if (obj == null || !(obj instanceof Enum)) continue;
            Enum _enum = (Enum)obj;
            value = BgEntityUtil.getEnumValue((Enum)obj);
            if (!value.toString().equalsIgnoreCase(fieldValue)) continue;
            selectedIndex = i;
            break;
        }
        comboBox.setSelectedIndex(selectedIndex);
        comboBox.setSelectedItem(temp[selectedIndex]);
        table.getRow(rowIndex).getCell(colIndex).setValue(comboBox.getItemAt(selectedIndex));
        return comboBox;
    }

    protected static void setDateCtrlField(KDTable kdTable, int rowIndex, int colIndex, Date initDate) {
        KDDatePicker datePicker = new KDDatePicker();
        if (initDate instanceof Timestamp) {
            datePicker.setTimeEnabled(true);
        } else if (initDate instanceof Time) {
            datePicker.setTimeEnabled(true);
        }
        datePicker.setValue((Object)initDate);
        KDTDefaultCellEditor kdtDefaultCellEditor = new KDTDefaultCellEditor(datePicker);
        kdTable.getRow(rowIndex).getCell(colIndex).setEditor((ICellEditor)kdtDefaultCellEditor);
    }

    protected static Date getDate(Date date, String type) {
        Date initDate = date;
        String format = BgEntityUtil.getTimeFormat(type);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (DataType.TIMESTAMP.getName().equalsIgnoreCase(type)) {
            initDate = new Timestamp(cal.getTime().getTime());
        } else if (DataType.TIME.getName().equalsIgnoreCase(type)) {
            cal.set(13, 0);
            initDate = new Time(cal.getTime().getTime());
        } else if (DataType.DATE.getName().equalsIgnoreCase(type)) {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            initDate = cal.getTime();
        }
        return initDate;
    }

    static Object getEnumValue(Enum enumValue) {
        Object value = null;
        if (enumValue instanceof BooleanEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof IntEnum) {
            value = new Integer(((IntEnum)enumValue).getValue());
        } else if (enumValue instanceof FloatEnum) {
            value = String.valueOf(((FloatEnum)enumValue).getValue());
        } else if (enumValue instanceof DoubleEnum) {
            value = String.valueOf(((DoubleEnum)enumValue).getValue());
        } else if (enumValue instanceof LongEnum) {
            value = String.valueOf(((LongEnum)enumValue).getValue());
        } else if (enumValue instanceof StringEnum) {
            value = ((StringEnum)enumValue).getValue();
        }
        return value;
    }

    private static String getDateString(Date date) {
        String strDate = null;
        if (date instanceof Timestamp) {
            strDate = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        } else if (date instanceof Time) {
            strDate = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm");
        } else if (date instanceof Date) {
            strDate = DateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        }
        return "{" + strDate + "}";
    }

    public static EntityObjectInfo getEntity(String entityName) {
        MetaDataPK entityPK = new MetaDataPK(entityName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity((IMetaDataPK)entityPK);
    }

    public static EntityObjectInfo getEntity(BOSObjectType objectType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(objectType);
    }

    public static EntityObjectInfo getEntity(IMetaDataPK entityPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEntity(entityPK);
    }

    public static BizEnumInfo getEnum(String enumName) {
        MetaDataPK enumPK = new MetaDataPK(enumName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getEnum((IMetaDataPK)enumPK);
    }

    public static QueryInfo getQueryInfo(String queryName) {
        MetaDataPK queryPK = new MetaDataPK(queryName);
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery((IMetaDataPK)queryPK);
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    public static QueryInfo getQueryInfo(QueryInfo info, boolean isClone) {
        return info;
    }

    public static QueryInfo getDefaultF7QueryObject(IMetaDataPK entityPK) {
        String defaultQueryObjectName = BgEntityUtil.getEntity(entityPK).getExtendedProperty(DEFAULT_F7_QUERY);
        return BgEntityUtil.getQueryInfo(defaultQueryObjectName);
    }

    public static String getDefaultF7Query(QueryFieldInfo queryFieldInfo) {
        return queryFieldInfo.getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static String getDefaultF7Query(IMetaDataPK entityPK) {
        return BgEntityUtil.getEntity(entityPK).getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static String getDefaultF7Query(PropertyInfo propertyInfo) {
        return propertyInfo.getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static String getDefaultF7Query(EntityObjectInfo entity) {
        return entity.getExtendedProperty(DEFAULT_F7_QUERY);
    }

    public static String getDefaultF7UI(QueryFieldInfo fieldInfo) {
        return fieldInfo.getExtendedProperty(DEFAULT_F7_UI);
    }

    public static String getDefaultF7UI(PropertyInfo propertyInfo) {
        return propertyInfo.getExtendedProperty(DEFAULT_F7_UI);
    }

    public static String getDefaultF7UI(EntityObjectInfo entity) {
        return entity.getExtendedProperty(DEFAULT_F7_UI);
    }

    public static String getSimpleEntityDisplayFormat(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_DISPLAY_FORMAT);
        if (textField == null || textField.trim().equalsIgnoreCase("")) {
            EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(BgEntityUtil.getEntityName(queryInfo, queryFieldName));
            textField = "$" + entityObjectInfo.getExtendedProperty(DEFAULT_DISPLAY_FIELD) + "$";
        }
        return textField;
    }

    public static String getF7DisplayFormat(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_DISPLAY_FORMAT);
        return textField;
    }

    public static String getF7EditFormat(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_EDIT_FORMAT);
        return textField;
    }

    public static String getF7CommitFormat(QueryInfo queryInfo, String queryFieldName) {
        QueryFieldInfo queryFieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String textField = queryFieldInfo.getExtendedProperty(F7_COMMIT_FORMAT);
        return textField;
    }

    private static boolean isUsingF7(QueryInfo queryInfo, String queryFieldName) {
        boolean flag = false;
        QueryFieldInfo fieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String strUsingF7 = fieldInfo.getExtendedProperty(IS_USING_F7);
        if (strUsingF7 != null && !strUsingF7.trim().equalsIgnoreCase("")) {
            flag = Boolean.valueOf(strUsingF7);
        }
        return flag;
    }

    public static ArrayList getConditionList(QueryInfo queryInfo, QueryPanelTypeEnum panelType) {
        ArrayList<QueryFieldInfo> target = new ArrayList<QueryFieldInfo>();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            String temp;
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            if (panelType.equals((Object)QueryPanelTypeEnum.FILTER_PANEL)) {
                boolean isFilter = false;
                temp = queryFieldInfo.getExtendedProperty(IS_COMMON_QUERY_FILTER);
                if (temp != null && !temp.trim().equalsIgnoreCase("")) {
                    isFilter = Boolean.valueOf(temp);
                }
                if (!isFilter) continue;
                target.add(queryFieldInfo);
                continue;
            }
            if (!panelType.equals((Object)QueryPanelTypeEnum.SORTER_PANEL)) continue;
            boolean isSorter = false;
            temp = queryFieldInfo.getExtendedProperty(IS_COMMON_QUERY_SORTER);
            if (temp != null && !temp.trim().equalsIgnoreCase("")) {
                isSorter = Boolean.valueOf(temp);
            }
            if (!isSorter) continue;
            target.add(queryFieldInfo);
        }
        return target;
    }

    public static DataObject[] getCompareValueList(QueryInfo queryInfo, String type) throws Exception {
        ArrayList<QueryFieldInfo> target = new ArrayList<QueryFieldInfo>();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            String temp = queryFieldInfo.getExtendedProperty(IS_COMMON_QUERY_FILTER);
            boolean isFilter = false;
            if (temp != null && !temp.trim().equalsIgnoreCase("")) {
                isFilter = Boolean.valueOf(temp);
            }
            if (!queryFieldInfo.getReturnType().toString().equals(type) || StringUtils.isEmpty((String)queryFieldInfo.getDisplayName()) || !queryFieldInfo.isIsSelector() || !isFilter) continue;
            target.add(queryFieldInfo);
        }
        int tmpSize = target.size();
        DataObject[] dataObjects = new DataObject[tmpSize];
        for (int i = 0; i < tmpSize; ++i) {
            dataObjects[i] = new DataObject();
            QueryFieldInfo fieldInfo = (QueryFieldInfo)target.get(i);
            dataObjects[i].setName(BgEntityUtil.getQueryFieldAlias(fieldInfo));
            dataObjects[i].setValue(fieldInfo.getName());
        }
        return dataObjects;
    }

    public static DataObject[] getCompareValueList(EntityObjectInfo entityInfo, String type) throws Exception {
        ArrayList target = new ArrayList();
        PropertyCollection propertyUnitCollection = entityInfo.getEntityProperties();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyUnitCollection.get(i);
        }
        int tmpSize = target.size();
        DataObject[] dataObjects = new DataObject[tmpSize];
        for (int i = 0; i < tmpSize; ++i) {
            dataObjects[i] = new DataObject();
            PropertyInfo fieldInfo = (PropertyInfo)target.get(i);
            dataObjects[i].setName(fieldInfo.getAlias());
            dataObjects[i].setValue(fieldInfo.getName());
        }
        return dataObjects;
    }

    public static DataObject getCompareValueObject(QueryInfo queryInfo, String value) throws BaseCommonQueryClientException {
        DataObject dataObject = new DataObject();
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo queryFieldInfo;
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !(queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName().toString().equals(value) || StringUtils.isEmpty((String)queryFieldInfo.getDisplayName())) continue;
            dataObject.setName(BgEntityUtil.getQueryFieldAlias(queryFieldInfo));
            dataObject.setValue(queryFieldInfo.getName());
            break;
        }
        return dataObject;
    }

    protected static DataObject[] getConditionArray(QueryInfo queryInfo, QueryPanelTypeEnum panelType) {
        DataObject[] dataObjects = null;
        ArrayList conditions = BgEntityUtil.getConditionList(queryInfo, panelType);
        int size = conditions.size();
        dataObjects = new DataObject[size];
        for (int i = 0; i < size; ++i) {
            dataObjects[i] = new DataObject();
            QueryFieldInfo fieldInfo = (QueryFieldInfo)conditions.get(i);
            dataObjects[i].setName(BgEntityUtil.getQueryFieldAlias(fieldInfo));
            boolean isRevserseLink = false;
            String str = (String)fieldInfo.getExtendedProperties().get(IS_REVERSE_LINK);
            if (!StringUtils.isEmpty((String)str)) {
                isRevserseLink = Boolean.valueOf(str);
                if (!isRevserseLink) {
                    dataObjects[i].setValue(fieldInfo.getName());
                    continue;
                }
                String strProp = (String)fieldInfo.getExtendedProperties().get(REVERSE_LINK_PROPName);
                dataObjects[i].setValue(strProp);
                continue;
            }
            dataObjects[i].setValue(fieldInfo.getName());
        }
        return dataObjects;
    }

    public static CompareSignEnum getCommonQueryCompareSign(CompareType compareType) {
        return CompareSignEnum.getEnum((String)compareType.getName().toUpperCase());
    }

    public static SorterSignEnum getCommonQuerySorterSign(SortType sortType) {
        return SorterSignEnum.getEnum((String)sortType.getName().toUpperCase());
    }

    protected static KDPromptBox getF7(String f7ConditonValue, QueryInfo mainQueryInfo, String entityName, IPromptBoxFactory promptBoxFactory) {
        PropertyUnitCollection propertyUnitCollection = mainQueryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo)) continue;
            QueryFieldInfo queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i);
            if (!f7ConditonValue.toLowerCase().equalsIgnoreCase(queryFieldInfo.getName())) continue;
            String defaultF7 = BgEntityUtil.getDefaultF7Query(queryFieldInfo);
            if (defaultF7 != null && !defaultF7.trim().equalsIgnoreCase("")) {
                return BgEntityUtil.createF7(defaultF7, mainQueryInfo, queryFieldInfo.getName(), promptBoxFactory);
            }
            defaultF7 = BgEntityUtil.getDefaultF7Query((IMetaDataPK)new MetaDataPK(entityName));
            String defaultF7UI = BgEntityUtil.getDefaultF7UI(queryFieldInfo);
            if (defaultF7 == null || defaultF7.trim().equalsIgnoreCase("")) {
                if (defaultF7UI == null || defaultF7UI.trim().equalsIgnoreCase("")) {
                    MsgBox.showError((String)(EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning") + mainQueryInfo.getFullName() + EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning1") + queryFieldInfo.getName() + EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning2") + entityName + EASResource.getString((String)commonQueryFilterRes, (String)"getF7Warning3")));
                    continue;
                }
                return BgEntityUtil.createF7(defaultF7, mainQueryInfo, queryFieldInfo.getName(), promptBoxFactory);
            }
            return BgEntityUtil.createF7(defaultF7, mainQueryInfo, queryFieldInfo.getName(), promptBoxFactory);
        }
        return null;
    }

    protected static DataObject[] getSimpleQueryResult(QueryInfo mainQuery, String entityName, String queryFieldName) {
        DataObject[] dataObjects = null;
        EntityObjectInfo simpleEntity = BgEntityUtil.getEntity(entityName);
        IObjectCollection collection = null;
        try {
            collection = DynamicObjectFactory.getRemoteInstance().getCollection(simpleEntity.getType(), new EntityViewInfo());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            int size = collection.size();
            dataObjects = new DataObject[size];
            for (int i = 0; i < size; ++i) {
                dataObjects[i] = new DataObject();
                BizDataFormat displayFormat = new BizDataFormat(BgEntityUtil.getSimpleEntityDisplayFormat(mainQuery, queryFieldName));
                IObjectValue objectValue = collection.getObject(i);
                String displayValue = displayFormat.format((Object)objectValue);
                dataObjects[i].setName(displayValue);
                dataObjects[i].setValue(objectValue.get(objectValue.getPKField()).toString());
            }
        }
        return dataObjects;
    }

    protected static String getEntityPKProperty(String entityName) {
        EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(entityName);
        return BgEntityUtil.getEntityPKProperty(entityObjectInfo);
    }

    protected static String getEntityPKProperty(EntityObjectInfo entity) {
        String propName = null;
        PropertyCollection keys = entity.getLogicalKey().getKeyPropertys();
        int size = keys.size();
        if (size == 0) {
            throw new IllegalArgumentException("not LogicalKey");
        }
        if (size == 1) {
            PropertyInfo propertyInfo = keys.get(0);
            propName = propertyInfo.getName();
        } else if (size > 1) {
            throw new IllegalArgumentException("not support multi LogicalKey");
        }
        return propName;
    }

    protected static IObjectValue getBizData(IObjectValue data) throws BOSException {
        String pk = data.get(BgEntityUtil.getEntityPKProperty(BgEntityUtil.getEntity(data.getBOSType()))).toString();
        return BgEntityUtil.getRemoteValue(pk);
    }

    private static String getQueryPKField(QueryInfo queryInfo, String entityName) {
        String pkField = null;
        ArrayList entityNames = BgEntityUtil.getEntitiyNames(queryInfo);
        EntityObjectInfo entityObjectInfo = BgEntityUtil.getEntity(entityNames.get(0).toString());
        String entityPKName = BgEntityUtil.getEntityPKProperty(entityName);
        String subEntityName = null;
        int subEntitySize = queryInfo.getSubObjects().size();
        for (int k = 0; k < subEntitySize; ++k) {
            SubEntityInfo subEntityInfo;
            String entityFullName;
            if (!(queryInfo.getSubObjects().get(k) instanceof SubEntityInfo) || !(entityFullName = (subEntityInfo = (SubEntityInfo)queryInfo.getSubObjects().get(k)).getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName()).equalsIgnoreCase(entityName)) continue;
            subEntityName = queryInfo.getSubObjects().get(k).getName();
            break;
        }
        int selectorSize = queryInfo.getSelector().size();
        for (int i = 0; i < selectorSize; ++i) {
            QueryFieldInfo queryFieldInfo = queryInfo.getSelector().get(i);
            PropertyRefCollection propertyRefCollection = queryFieldInfo.getPropertyRefs();
            int propertyRefCollectionSize = propertyRefCollection.size();
            for (int j = 0; j < propertyRefCollectionSize; ++j) {
                PropertyRefInfo propertyRefInfo = propertyRefCollection.get(j);
                if (!propertyRefInfo.getSubEntity().getName().equalsIgnoreCase(subEntityName) || !propertyRefInfo.getRefProperty().getName().equalsIgnoreCase(entityPKName)) continue;
                pkField = queryFieldInfo.getName();
                return pkField;
            }
        }
        return pkField;
    }

    private static KDPromptBox createF7(String f7QueryName, QueryInfo mainQuery, String queryFiledName, IPromptBoxFactory promptBoxFactory) {
        if (promptBoxFactory != null) {
            KDPromptBox promptBox = promptBoxFactory.create(f7QueryName);
            if (promptBox == null) {
                return promptBoxFactory.create(f7QueryName, mainQuery, queryFiledName);
            }
            return promptBox;
        }
        return new DefaultPromptBoxFactory().create(f7QueryName, mainQuery, queryFiledName);
    }

    protected static DataObject getRefMetaData(EntityObjectInfo entity, String propertiyName) {
        DataObject dataObject = null;
        PropertyCollection propertyCollection = BgEntityUtil.getAllEntityProperties(entity);
        int size = propertyCollection.size();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            String propName = propertyInfo.getName();
            if (!propName.toLowerCase().equalsIgnoreCase(propertiyName.toLowerCase())) continue;
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                if (ownPropertyInfo.getDataType().equals((Object)DataType.ENUM)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    String enumName = ownPropertyInfo.getMetaDataRef();
                    BizEnumInfo _enum = BgEntityUtil.getEnum(enumName);
                    dataObject.setValue(_enum.getClassName());
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.BOOLEAN)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(BooleanEnum.class.getName());
                    return dataObject;
                }
                if (ownPropertyInfo.getDataType().equals((Object)DataType.DATE) || ownPropertyInfo.getDataType().equals((Object)DataType.TIMESTAMP) || ownPropertyInfo.getDataType().equals((Object)DataType.TIME)) {
                    dataObject = new DataObject();
                    dataObject.setName(ownPropertyInfo.getDataType().getName());
                    dataObject.setValue(null);
                    return dataObject;
                }
                dataObject = new DataObject();
                dataObject.setName(ownPropertyInfo.getDataType().getName());
                dataObject.setValue(entity.getFullName());
                return dataObject;
            }
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo refEntity = BgEntityUtil.getEntity(entity.getFullName(), linkPropertyInfo);
            String refEntityName = refEntity.getFullName();
            dataObject = new DataObject();
            if (BgEntityUtil.isSimpleEntity(refEntity)) {
                dataObject.setName("SIMPLE_ENTITY");
                dataObject.setValue(refEntityName);
                return dataObject;
            }
            return BgEntityUtil.getRefMetaData(refEntity, propertiyName);
        }
        return dataObject;
    }

    public static QueryInfo getDyFilterQuery(QueryInfo queryInfo) {
        ArrayList entityNames = BgEntityUtil.getEntitiyNames(queryInfo);
        String mainEntityName = entityNames.get(0).toString();
        UserInfo userinfo = SysContext.getSysContext().getCurrentUserInfo();
        DynamicSolutionInfo currentSolution = null;
        ExtendPropertyCollection extendColl = new ExtendPropertyCollection();
        ExtendPropertyInfo extendInfo = new ExtendPropertyInfo();
        extendInfo.setName(IS_COMMON_QUERY_FILTER);
        extendInfo.setValue("true");
        extendColl.add(extendInfo);
        boolean flag = false;
        try {
            IDySolutionFacade dyFacade = DySolutionFacadeFactory.getRemoteInstance();
            DyAssignUserInfoCollection coList = dyFacade.getDysolutionList(userinfo.getId().toString());
            if (coList != null && coList.size() > 0) {
                for (int j = 0; j < coList.size(); ++j) {
                    DyAssignUserInfoInfo assignInfo = coList.get(j);
                    String sId = assignInfo.getSolution().getId().toString();
                    ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)sId));
                    IDynamicSolution dy = DynamicSolutionFactory.getRemoteInstance();
                    DynamicSolutionInfo dInfo = dy.getDynamicSolutionInfo((IObjectPK)pk);
                    if (dInfo.getMainEntity().equals(mainEntityName)) {
                        currentSolution = dInfo;
                        flag = true;
                        break;
                    }
                    if (flag) break;
                }
                if (!flag) {
                    return queryInfo;
                }
                queryInfo = BgEntityUtil.getQueryInfo(queryInfo, true);
                if (currentSolution != null) {
                    DyQueryFieldCollection coll = currentSolution.getQueryFields();
                    int size = coll.size();
                    for (int n = 0; n < size; ++n) {
                        DyQueryFieldInfo field = coll.get(n);
                        if (!field.isIsReverseLink()) {
                            SelectorItemInfo info = new SelectorItemInfo();
                            info.setPropertyName(field.getValue());
                            ExtendPropertyInfo extendInfoLink = new ExtendPropertyInfo();
                            extendInfoLink.setName(IS_REVERSE_LINK);
                            extendInfoLink.setValue("false");
                            extendColl.add(extendInfoLink);
                            continue;
                        }
                        String entity = field.getEntityName();
                        String linkProperty = BgEntityUtil.getLinkProperty(mainEntityName, entity).getName();
                        SelectorItemInfo info = new SelectorItemInfo();
                        StringBuffer propertyName = new StringBuffer();
                        propertyName.append(BgEntityUtil.parsePackage(entity));
                        propertyName.append("[");
                        propertyName.append(linkProperty);
                        propertyName.append("]");
                        propertyName.append(".");
                        propertyName.append(field.getValue());
                        info.setPropertyName(propertyName.toString());
                        ExtendPropertyInfo extendInfoLink = new ExtendPropertyInfo();
                        extendInfoLink.setName(IS_REVERSE_LINK);
                        extendInfoLink.setValue("true");
                        extendColl.add(extendInfoLink);
                        ExtendPropertyInfo extendInfoLinkProp = new ExtendPropertyInfo();
                        extendInfoLinkProp.setName(REVERSE_LINK_PROPName);
                        extendInfoLinkProp.setValue(propertyName.toString());
                        extendColl.add(extendInfoLinkProp);
                    }
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return queryInfo;
    }

    public static boolean isReverseLink(String mainEntityName, String subEntityName) {
        EntityObjectInfo mainEntityInfo = BgEntityUtil.getEntity(mainEntityName);
        EntityObjectInfo subEntityInfo = BgEntityUtil.getEntity(subEntityName);
        if (subEntityInfo != null && mainEntityInfo != null) {
            PropertyCollection prColl = subEntityInfo.getProperties();
            if (prColl == null) {
                return false;
            }
            for (PropertyInfo propertyInfo : prColl) {
                if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                EntityObjectInfo refEntity = BgEntityUtil.getEntity(subEntityInfo.getFullName(), linkPropertyInfo);
                if (!refEntity.getFullName().equalsIgnoreCase(mainEntityInfo.getFullName())) continue;
                return true;
            }
        }
        return false;
    }

    private static LinkPropertyInfo getLinkProperty(String mainEntityName, String subEntityName) {
        EntityObjectInfo mainEntityInfo = BgEntityUtil.getEntity(mainEntityName);
        EntityObjectInfo subEntityInfo = BgEntityUtil.getEntity(subEntityName);
        PropertyCollection prColl = subEntityInfo.getProperties();
        for (PropertyInfo propertyInfo : prColl) {
            if (!(propertyInfo instanceof LinkPropertyInfo)) continue;
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
            EntityObjectInfo refEntity = BgEntityUtil.getEntity(subEntityInfo.getFullName(), linkPropertyInfo);
            if (!refEntity.getFullName().equalsIgnoreCase(mainEntityInfo.getFullName())) continue;
            return linkPropertyInfo;
        }
        return null;
    }

    private static String getEntityName(String packageName) {
        if (packageName != null) {
            int index = packageName.lastIndexOf(".");
            return packageName.substring(index + 1, packageName.length());
        }
        return null;
    }

    private static String parsePackage(String packageName) {
        StringBuffer buf = new StringBuffer();
        if (packageName != null) {
            while (packageName.indexOf(".") > 0) {
                int index = packageName.indexOf(".");
                buf.append(packageName.substring(0, index));
                buf.append("_");
                packageName = packageName.substring(index + 1, packageName.length());
            }
            buf.append(packageName);
        }
        return buf.toString();
    }

    private static boolean isUsingF7(EntityObjectInfo entity, String propertyName) {
        boolean flag = false;
        String strUsingF7 = entity.getPropertyByName(propertyName).getExtendedProperty(IS_USING_F7);
        if (strUsingF7 != null && !strUsingF7.trim().equalsIgnoreCase("")) {
            flag = Boolean.valueOf(strUsingF7);
        }
        return flag;
    }

    protected static boolean hasDefaultF7UI(String propertyName, EntityObjectInfo entity) {
        PropertyInfo propertyInfo = entity.getPropertyByName(propertyName);
        String defualtF7UI = BgEntityUtil.getDefaultF7UI(propertyInfo);
        if (defualtF7UI == null || defualtF7UI.trim().equalsIgnoreCase("")) {
            defualtF7UI = BgEntityUtil.getDefaultF7UI(entity);
            return defualtF7UI != null && !defualtF7UI.trim().equalsIgnoreCase("");
        }
        return true;
    }

    protected static KDPromptBox getF7(String propertyName, EntityObjectInfo entity, IPromptBoxFactory promptBoxFactory) {
        PropertyInfo propertyInfo = entity.getPropertyByName(propertyName);
        String defaultF7 = null;
        if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(entity.getFullName()) && "number".equals(propertyName)) {
            defaultF7 = "com.kingdee.eas.basedata.org.app.AdminItemQuery";
            return BgEntityUtil.createF7(defaultF7, entity, propertyName, promptBoxFactory);
        }
        if ("com.kingdee.eas.basedata.assistant.app.Bank".equals(entity.getFullName()) && "number".equals(propertyName)) {
            defaultF7 = "com.kingdee.eas.basedata.assistant.app.BankQuery";
            return BgEntityUtil.createF7(defaultF7, entity, propertyName, promptBoxFactory);
        }
        defaultF7 = BgEntityUtil.getDefaultF7Query(propertyInfo);
        boolean hasDefaultF7UI = BgEntityUtil.hasDefaultF7UI(propertyName, entity);
        if (!hasDefaultF7UI) {
            if (!StringUtils.isEmpty((String)defaultF7)) {
                return BgEntityUtil.createF7(defaultF7, entity, propertyName, promptBoxFactory);
            }
            defaultF7 = BgEntityUtil.getDefaultF7Query(entity);
            if (!StringUtils.isEmpty((String)defaultF7)) {
                return BgEntityUtil.createF7(defaultF7, entity, propertyName, promptBoxFactory);
            }
            return null;
        }
        return BgEntityUtil.createF7(defaultF7, entity, propertyName, promptBoxFactory);
    }

    private static KDPromptBox createF7(String f7QueryName, EntityObjectInfo entity, String propertyName, IPromptBoxFactory promptBoxFactory) {
        if (promptBoxFactory != null) {
            KDPromptBox promptBox = promptBoxFactory.create(f7QueryName);
            if (promptBox == null) {
                return promptBoxFactory.create(f7QueryName, entity, propertyName);
            }
            return promptBox;
        }
        return new DefaultPromptBoxFactory().create(f7QueryName, entity, propertyName);
    }

    protected static IObjectValue getRemoteValue(String pkValue) throws BOSException {
        BOSUuid id = BOSUuid.read((String)pkValue);
        IObjectValue objectValue = null;
        objectValue = DynamicObjectFactory.getRemoteInstance().getValue(id.getType(), (IObjectPK)new ObjectUuidPK(id));
        return objectValue;
    }

    protected static DataObject[] getSimpleQueryResult(EntityObjectInfo mainEntity, String simpleEntityName, String propertyName) {
        DataObject[] dataObjects = null;
        EntityObjectInfo simpleEntity = BgEntityUtil.getEntity(simpleEntityName);
        IObjectCollection collection = null;
        try {
            collection = DynamicObjectFactory.getRemoteInstance().getCollection(simpleEntity.getType(), new EntityViewInfo());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            int size = collection.size();
            dataObjects = new DataObject[size];
            for (int i = 0; i < size; ++i) {
                dataObjects[i] = new DataObject();
                BizDataFormat format = new BizDataFormat(BgEntityUtil.getSimpleEntityDisplayFormat(mainEntity, propertyName));
                IObjectValue objectValue = collection.getObject(i);
                String result = format.format((Object)objectValue);
                dataObjects[i].setName(result);
                dataObjects[i].setValue(objectValue.get(objectValue.getPKField()).toString());
            }
        }
        return dataObjects;
    }

    public static String getSimpleEntityDisplayFormat(EntityObjectInfo entity, String propertyName) {
        String textField = entity.getPropertyByName(propertyName).getExtendedProperty(F7_DISPLAY_FORMAT);
        if (textField == null || textField.trim().equalsIgnoreCase("")) {
            LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)entity.getPropertyByName(propertyName);
            EntityObjectInfo refEntity = BgEntityUtil.getEntity(entity.getFullName(), linkPropertyInfo);
            textField = "$" + refEntity.getExtendedProperty(DEFAULT_DISPLAY_FIELD) + "$";
        }
        return textField;
    }

    public static String getF7DisplayFormat(EntityObjectInfo entity, String propertyName) {
        String textField = entity.getPropertyByName(propertyName).getExtendedProperty(F7_DISPLAY_FORMAT);
        return textField;
    }

    protected static boolean hasNumberField(EntityObjectInfo entity) {
        if (entity != null) {
            while (true) {
                if (entity == null) {
                    return false;
                }
                if (entity.getPropertyByName("number") != null) break;
                entity = entity.getBaseEntity();
            }
            return true;
        }
        return false;
    }

    protected static boolean hasNameField(EntityObjectInfo entity) {
        if (entity != null) {
            while (true) {
                if (entity == null) {
                    return false;
                }
                if (entity.getPropertyByName("name") != null) break;
                entity = entity.getBaseEntity();
            }
            return true;
        }
        return false;
    }

    public static String getF7EditFormat(EntityObjectInfo entity, String propertyName) {
        String textField = entity.getPropertyByName(propertyName).getExtendedProperty(F7_EDIT_FORMAT);
        return textField;
    }

    public static String getF7CommitFormat(EntityObjectInfo entity, String propertyName) {
        String textField = entity.getPropertyByName(propertyName).getExtendedProperty(F7_COMMIT_FORMAT);
        return textField;
    }

    public static FilterInfo toVerifyFilter(QueryInfo queryInfo, FilterInfo filterInfo) {
        FilterInfo filtertemp = new FilterInfo();
        boolean flag = false;
        StringBuffer compareValue = new StringBuffer();
        String propertyname = null;
        CompareType compare = null;
        if (filterInfo != null) {
            int filterSize;
            FilterItemCollection fcol = filterInfo.getFilterItems();
            if (filterInfo.getMaskString() != null && filterInfo.getMaskString().indexOf("and") < 0 && filterInfo.getMaskString().indexOf("AND") < 0 && (filterSize = fcol.size()) >= 2) {
                propertyname = fcol.get(0).getPropertyName();
                compare = fcol.get(0).getCompareType();
                for (int i = 0; i < filterSize; ++i) {
                    FilterItemInfo item = fcol.get(i);
                    if (item.getPropertyName().equals(propertyname) && item.getCompareType() == compare) {
                        String dataType;
                        DataObject dataObj = BgEntityUtil.getRefMetaData(queryInfo, item.getPropertyName());
                        String string = dataType = dataObj == null ? "" : dataObj.getName();
                        if (!DataType.STRING.getName().equalsIgnoreCase(dataType)) {
                            flag = false;
                            break;
                        }
                        flag = true;
                        compareValue.append(item.getCompareValue().toString());
                        if (i == filterSize - 1) continue;
                        compareValue.append(",");
                        continue;
                    }
                    flag = false;
                    break;
                }
            }
        }
        if (flag) {
            FilterItemInfo filterItemInfo = new FilterItemInfo(propertyname, (Object)compareValue.toString(), compare);
            filtertemp.getFilterItems().add(filterItemInfo);
            return filtertemp;
        }
        return filterInfo;
    }

    public static ArrayList getRowInfos(FilterInfo filterInfo) {
        int size;
        char[] exp;
        int size2;
        ArrayList<RowObject> target = new ArrayList<RowObject>();
        String expression = filterInfo.getMaskString();
        if (StringUtils.isEmpty((String)expression) && (size2 = filterInfo.getFilterItems().size()) > 0) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < size2; ++i) {
                if (i == size2 - 1) {
                    buffer.append("#").append(i);
                    continue;
                }
                buffer.append("#").append(i).append(" AND ");
            }
            expression = buffer.toString();
        }
        if ((exp = (expression = expression + " AND ").toLowerCase().toCharArray()) != null) {
            int length = exp.length;
            StringBuffer leftBracket = new StringBuffer();
            StringBuffer rightBracket = new StringBuffer();
            for (int i = 0; i < length; ++i) {
                RowObject rowObject;
                char c = exp[i];
                if ("(".equalsIgnoreCase(String.valueOf(c))) {
                    leftBracket.append(String.valueOf(c));
                    continue;
                }
                if (")".equalsIgnoreCase(String.valueOf(c))) {
                    rightBracket.append(String.valueOf(c));
                    continue;
                }
                if ("A".equalsIgnoreCase(String.valueOf(c))) {
                    rowObject = new RowObject();
                    rowObject.setLeftBracket(leftBracket.toString());
                    rowObject.setRightBracket(rightBracket.toString());
                    rowObject.setLogic("AND");
                    target.add(rowObject);
                    leftBracket = new StringBuffer();
                    rightBracket = new StringBuffer();
                    continue;
                }
                if (!"O".equalsIgnoreCase(String.valueOf(c))) continue;
                rowObject = new RowObject();
                rowObject.setLeftBracket(leftBracket.toString());
                rowObject.setRightBracket(rightBracket.toString());
                rowObject.setLogic("OR");
                target.add(rowObject);
                leftBracket = new StringBuffer();
                rightBracket = new StringBuffer();
            }
        }
        if ((size = target.size()) > 0) {
            ((RowObject)target.get(size - 1)).setLogic("");
        }
        return target;
    }

    protected static String getEntityDisplayName(String selectedName, EntityObjectInfo entity) {
        String name = null;
        PropertyCollection propertyCollection = entity.getProperties();
        int size = propertyCollection.size();
        for (int i = 0; i < size; ++i) {
            LinkPropertyInfo linkPropertyInfo;
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)propertyInfo;
                if (!ownPropertyInfo.getName().equalsIgnoreCase(selectedName)) continue;
                name = ownPropertyInfo.getAlias();
                continue;
            }
            if (!(propertyInfo instanceof LinkPropertyInfo) || !(linkPropertyInfo = (LinkPropertyInfo)propertyInfo).getName().equalsIgnoreCase(selectedName)) continue;
            name = linkPropertyInfo.getAlias();
        }
        if (name == null || name.trim().equalsIgnoreCase("")) {
            name = selectedName;
        }
        return name;
    }

    protected static EntityObjectInfo getEntity(EntityObjectInfo mainEntity, String propertyValue) {
        EntityObjectInfo entity = mainEntity;
        PropertyCollection propertyCollection = BgEntityUtil.getAllEntityProperties(entity);
        int size = propertyCollection.size();
        Object propertyInfos = null;
        StringTokenizer stringTokenizer = new StringTokenizer(propertyValue, ".");
        String temp = stringTokenizer.nextToken();
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(temp)) continue;
            if (stringTokenizer.hasMoreTokens()) {
                LinkPropertyInfo linkPropertyInfo = (LinkPropertyInfo)propertyInfo;
                entity = BgEntityUtil.getEntity(BgEntityUtil.getEntity(mainEntity.getFullName(), linkPropertyInfo), propertyValue.substring(propertyValue.indexOf(".") + 1));
            }
            return entity;
        }
        return entity;
    }

    public static EntityObjectInfo getEntity(String mainEntityName, LinkPropertyInfo linkPropertyInfo) {
        String tempEntityName = linkPropertyInfo.getRelationship().getSupplierObject().getFullName();
        if (!tempEntityName.equalsIgnoreCase(mainEntityName)) {
            return linkPropertyInfo.getRelationship().getSupplierObject();
        }
        return linkPropertyInfo.getRelationship().getClientObject();
    }

    public static String getPropertyName(String str) {
        int index = str.lastIndexOf(".");
        if (index != 0) {
            str = str.substring(index + 1);
        }
        return str;
    }

    public static String getQueryFieldAlias(String selectedName, QueryInfo queryInfo) {
        String name = null;
        PropertyUnitCollection propertyUnitCollection = queryInfo.getUnits();
        int size = propertyUnitCollection.size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo queryFieldInfo;
            if (!(propertyUnitCollection.get(i) instanceof QueryFieldInfo) || !selectedName.equalsIgnoreCase((queryFieldInfo = (QueryFieldInfo)propertyUnitCollection.get(i)).getName())) continue;
            return BgEntityUtil.getQueryFieldAlias(queryFieldInfo);
        }
        return name;
    }

    public static String getQueryFieldAlias(QueryFieldInfo fieldInfo) {
        String displayName = fieldInfo.getDisplayName();
        if (fieldInfo.getDisplayName() == null || fieldInfo.getDisplayName().trim().equalsIgnoreCase("")) {
            displayName = fieldInfo.getName();
        }
        return displayName;
    }

    public static String getEntityPropertyAlias(EntityObjectInfo mainEntity, String propertyValue) {
        String alias = null;
        EntityObjectInfo currentEntity = mainEntity;
        String currentProperty = propertyValue;
        PropertyCollection propertyCollection = BgEntityUtil.getAllEntityProperties(currentEntity);
        int size = propertyCollection.size();
        int index = currentProperty.indexOf(".");
        String compareProperty = null;
        if (index != -1) {
            compareProperty = currentProperty.substring(0, index);
            currentProperty = currentProperty.substring(index + 1);
        } else {
            compareProperty = currentProperty;
        }
        for (int i = 0; i < size; ++i) {
            PropertyInfo propertyInfo = propertyCollection.get(i);
            if (!propertyInfo.getName().equalsIgnoreCase(compareProperty)) continue;
            alias = alias == null ? BgEntityUtil.getPropertyAlias(propertyInfo) : alias + BgEntityUtil.getPropertyAlias(propertyInfo);
            if (propertyInfo instanceof LinkPropertyInfo) {
                currentEntity = BgEntityUtil.getEntity(currentEntity.getFullName(), (LinkPropertyInfo)propertyInfo);
                alias = alias + "." + BgEntityUtil.getEntityPropertyAlias(currentEntity, currentProperty);
                return BgEntityUtil.processEntityPropertyAlias(currentEntity, currentProperty, alias);
            }
            return BgEntityUtil.processEntityPropertyAlias(currentEntity, currentProperty, alias);
        }
        return compareProperty;
    }

    protected static String processEntityPropertyAlias(EntityObjectInfo entity, String property, String alias) {
        if (BgEntityUtil.isEntityPK(entity, property)) {
            int sep = alias.lastIndexOf(".");
            alias = sep == -1 ? BgEntityUtil.getEntityAlias(entity) : alias.substring(0, sep);
        }
        return alias;
    }

    public static String getPropertyAlias(PropertyInfo propertyInfo) {
        String alias = propertyInfo.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            alias = propertyInfo.getName();
        }
        return alias;
    }

    public static String getEntityAlias(EntityObjectInfo entity) {
        String alias = entity.getAlias();
        if (alias == null || alias.trim().equalsIgnoreCase("")) {
            return entity.getName();
        }
        return alias;
    }

    public static String[] getDefaultProperties(EntityObjectInfo entityObjectInfo) {
        PropertyCollection collection = BgEntityUtil.getAllEntityProperties(entityObjectInfo);
        int size = collection.size();
        String[] filterProperties = new String[size];
        for (int i = 0; i < size; ++i) {
            filterProperties[i] = collection.get(i).getName();
        }
        return filterProperties;
    }

    public static PropertyCollection getAllEntityProperties(EntityObjectInfo entity) {
        PropertyCollection properties = new PropertyCollection();
        properties.addObjectCollection((IObjectCollection)entity.getProperties());
        while (entity.getBaseEntity() != null) {
            properties.addObjectCollection((IObjectCollection)entity.getBaseEntity().getProperties());
            entity = entity.getBaseEntity();
        }
        return properties;
    }

    public static ArrayList getWithOutProperties(String entityName) {
        ArrayList al = new ArrayList();
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getRemoteInstance();
            al = iQuerySolution.getWithOutProperties(entityName);
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        return al;
    }

    protected static PropertyCollection getEntityProperties(EntityObjectInfo entity, String[] properties) {
        PropertyCollection target = new PropertyCollection();
        PropertyCollection collection = BgEntityUtil.getAllEntityProperties(entity);
        int length = properties.length;
        int size = collection.size();
        block0: for (int i = 0; i < length; ++i) {
            for (int j = 0; j < size; ++j) {
                if (!properties[i].toLowerCase().equalsIgnoreCase(collection.get(j).getName().toLowerCase())) continue;
                target.add(collection.get(j));
                continue block0;
            }
        }
        return target;
    }

    protected static PropertyCollection getEntitySorterProperties(EntityObjectInfo entity, String[] properties) {
        PropertyCollection target = new PropertyCollection();
        PropertyCollection collection = BgEntityUtil.getAllEntityProperties(entity);
        int size = collection.size();
        for (int j = 0; j < size; ++j) {
            if (!(collection.get(j) instanceof OwnPropertyInfo)) continue;
            target.add(collection.get(j));
        }
        return target;
    }

    protected static String getTimeFormat(String dateType) {
        String format = "yyyy-MM-dd";
        if (dateType.equalsIgnoreCase(DataType.DATE.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIME.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateTimeFormatString();
        } else if (dateType.equalsIgnoreCase(DataType.TIMESTAMP.getName())) {
            format = BgNationalFormatUIUtil.getNationalDateTimeFormatString();
        }
        return format;
    }

    protected static String getTimeFormatForTable(String dateType) {
        String format = "%{" + BgEntityUtil.getTimeFormat(dateType) + "}t";
        return format;
    }

    protected static boolean isString(OwnPropertyInfo ownPropertyInfo) {
        return ownPropertyInfo.getDataType().equals((Object)DataType.STRING);
    }

    protected static boolean isString(QueryInfo queryInfo, String queryFieldName) {
        if (queryInfo instanceof UnionQueryInfo) {
            UnionQueryInfo uqInfo = (UnionQueryInfo)queryInfo;
            SubObjectInfo subObj = null;
            Object subObj1 = null;
            try {
                subObj = uqInfo.getMainObject();
                if (subObj instanceof SubQueryInfo) {
                    queryInfo = ((SubQueryInfo)subObj).getQueryRef();
                }
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        QueryFieldInfo fieldInfo = BgEntityUtil.getQueryFieldInfo(queryInfo, queryFieldName);
        String entityNameInQueryField = fieldInfo.getPropertyRefs().get(0).getSubEntity().getName();
        String entityProperty = fieldInfo.getPropertyRefs().get(0).getRefProperty().getName();
        SubObjectCollection subObjectCollection = queryInfo.getSubObjects();
        int size = subObjectCollection.size();
        for (int i = 0; i < size; ++i) {
            SubEntityInfo subEntityInfo;
            SubObjectInfo subObjectInfo = subObjectCollection.get(i);
            if (!(subObjectInfo instanceof SubEntityInfo) || !(subEntityInfo = (SubEntityInfo)subObjectInfo).getName().equalsIgnoreCase(entityNameInQueryField)) continue;
            String entityName = subEntityInfo.getEntityRef().getPackage() + "." + subEntityInfo.getEntityRef().getName();
            OwnPropertyInfo ownPropertyInfo = (OwnPropertyInfo)BgEntityUtil.getEntity(entityName).getPropertyByName(entityProperty);
            return BgEntityUtil.isString(ownPropertyInfo);
        }
        return false;
    }

    protected static boolean hasLikeCompare(KDComboBox comboBox) {
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            CompareSignEnum _enum;
            Object obj = comboBox.getItemAt(i);
            if (obj == null || !(obj instanceof CompareSignEnum) || !(_enum = (CompareSignEnum)obj).equals((Object)CompareSignEnum.LIKESIGN) && !_enum.equals((Object)CompareSignEnum.NOTLIKESIGN) && !_enum.equals((Object)CompareSignEnum.NOTLEFTLIKESIGN) && !_enum.equals((Object)CompareSignEnum.LEFTLIKESIGN) && !_enum.equals((Object)CompareSignEnum.RIGHTLIKESIGN)) continue;
            return true;
        }
        return false;
    }

    protected static KDComboBox setNoLikeCompareBox(KDTable kdtTable, int rowIndex, int columnIndex) {
        List list = CompareSignEnum.getEnumList();
        list.remove(CompareSignEnum.LIKESIGN);
        list.remove(CompareSignEnum.NOTLIKESIGN);
        Object[] objects = BgEntityUtil.addObjectToArray(list.toArray(), "");
        KDComboBox comboBox = BgEntityUtil.setComboBoxField(kdtTable, rowIndex, columnIndex, objects);
        comboBox.removeItem((Object)CompareSignEnum.INCLUDESIGN);
        comboBox.removeItem((Object)CompareSignEnum.NOTINCLUDESIGN);
        return comboBox;
    }

    protected static IObjectValue getBizF7Data(QueryInfo queryInfo, String entityName, String queryField, Object value) throws BaseCommonQueryClientException {
        String entityPropertyName = BgEntityUtil.getEntityPropertyName(queryInfo, queryField);
        EntityObjectInfo entity = BgEntityUtil.getEntity(entityName);
        return BgEntityUtil.getBizF7Data(entity, entityPropertyName, value);
    }

    protected static IObjectValue getBizF7Data(EntityObjectInfo entity, String propertyName, Object propertyValue) throws BaseCommonQueryClientException {
        IObjectValue bizF7Data = null;
        try {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            FilterItemInfo filterItemInfo = new FilterItemInfo(propertyName, propertyValue);
            filterInfo.getFilterItems().add(filterItemInfo);
            filterInfo.setMaskString(" #0 ");
            entityViewInfo.setFilter(filterInfo);
            IObjectCollection collection = DynamicObjectFactory.getRemoteInstance().getCollection(entity.getType(), entityViewInfo);
            if (collection.size() > 0) {
                bizF7Data = collection.getObject(0);
            }
        }
        catch (BOSException e) {
            throw new BaseCommonQueryClientException(BaseCommonQueryClientException.GET_F7_DATA_FAIL);
        }
        return bizF7Data;
    }

    protected static KDComboBox createShareTypeComboBox(int showShareType) {
        KDComboBox shareTypeComboBox = new KDComboBox();
        Vector<ShareTypeEnum> vect = new Vector<ShareTypeEnum>();
        if (showShareType == 0) {
            vect.add(ShareTypeEnum.USER_LEVEL);
            vect.add(ShareTypeEnum.ORG_LEVEL);
        } else {
            if (showShareType % 2 > 0) {
                vect.add(ShareTypeEnum.USER_LEVEL);
            }
            if ((showShareType >>= 1) % 2 > 0) {
                vect.add(ShareTypeEnum.ORG_LEVEL);
            }
            if ((showShareType >>= 1) % 2 > 0) {
                vect.add(ShareTypeEnum.CU_LEVEL);
            }
            if ((showShareType >>= 1) % 2 > 0) {
                vect.add(ShareTypeEnum.PUBLIC_LEVEL);
            }
        }
        shareTypeComboBox = new KDComboBox(vect);
        return shareTypeComboBox;
    }

    protected static CompareSignEnum getCompareSignEnum(CompareType compareType) {
        Iterator iterator = CompareSignEnum.iterator();
        while (iterator.hasNext()) {
            CompareSignEnum compareSignEnum = (CompareSignEnum)iterator.next();
            if (!compareSignEnum.getValue().equalsIgnoreCase(compareType.getName().toUpperCase())) continue;
            return compareSignEnum;
        }
        throw new IllegalArgumentException("CompareSignEnum not found");
    }

    protected static SorterSignEnum getSorterSignEnum(SortType sortType) {
        Iterator iterator = SorterSignEnum.iterator();
        while (iterator.hasNext()) {
            SorterSignEnum sorterSignEnum = (SorterSignEnum)iterator.next();
            if (!sorterSignEnum.getValue().equalsIgnoreCase(sortType.getName().toUpperCase())) continue;
            return sorterSignEnum;
        }
        throw new IllegalArgumentException("SorterSignEnum not found");
    }

    protected static Date getDate(String str) throws BaseCommonQueryClientException {
        try {
            Lexer lexer = new Lexer(str);
            TokenList tokList = new TokenList(lexer);
            SqlExprParser parser = new SqlExprParser(tokList);
            SqlExpr expr = parser.expr();
            SqlDateTimeExpr dateTimeExpr = (SqlDateTimeExpr)expr;
            GregorianCalendar cal = new GregorianCalendar();
            cal.set(1, dateTimeExpr.getYear());
            cal.set(2, dateTimeExpr.getMonth() - 1);
            cal.set(5, dateTimeExpr.getDate());
            cal.set(11, dateTimeExpr.getHour());
            cal.set(12, dateTimeExpr.getMinute());
            cal.set(13, dateTimeExpr.getSecond());
            Date rtnValue = cal.getTime();
            return rtnValue;
        }
        catch (ParserException e) {
            throw new BaseCommonQueryClientException(BaseCommonQueryClientException.DATE_IS_INVAILD);
        }
    }

    protected static boolean isDate(QueryInfo queryInfo, String queryFieldName) {
        DataObject dateType = BgEntityUtil.getRefMetaData(queryInfo, queryFieldName);
        return dateType != null && (dateType.getName().equals(DataType.DATE.getName()) || dateType.getName().equals(DataType.TIMESTAMP.getName()) || dateType.getName().equals(DataType.TIME.getName()));
    }

    protected static boolean isDate(EntityObjectInfo entity, String propertiyName) {
        DataObject dateType = BgEntityUtil.getRefMetaData(entity, propertiyName);
        return dateType != null && (DataType.DATE.getName().equals(dateType.getName()) || DataType.TIMESTAMP.getName().equals(dateType.getName()) || DataType.TIME.getName().equals(dateType.getName()));
    }

    protected static boolean isEnum(QueryInfo queryInfo, String queryFieldName) {
        DataObject dateType = BgEntityUtil.getRefMetaData(queryInfo, queryFieldName);
        return dateType != null && dateType.getName().equals(DataType.ENUM.getName());
    }

    protected static boolean isEnum(EntityObjectInfo entity, String propertiyName) {
        DataObject dateType = BgEntityUtil.getRefMetaData(entity, propertiyName);
        return dateType.getName().equals(DataType.ENUM.getName());
    }

    protected static boolean isBoolean(QueryInfo queryInfo, String queryFieldName) {
        DataObject dateType = BgEntityUtil.getRefMetaData(queryInfo, queryFieldName);
        return dateType != null && dateType.getName().equals(DataType.BOOLEAN.getName());
    }

    protected static boolean isBoolean(EntityObjectInfo entity, String propertiyName) {
        DataObject dateType = BgEntityUtil.getRefMetaData(entity, propertiyName);
        return dateType.getName().equals(DataType.BOOLEAN.getName());
    }

    protected static Map getConditionMap(ArrayList conditions) {
        HashMap<String, QueryFieldInfo> map = new HashMap<String, QueryFieldInfo>();
        int size = conditions.size();
        for (int i = 0; i < size; ++i) {
            QueryFieldInfo fieldInfo = (QueryFieldInfo)conditions.get(i);
            map.put(fieldInfo.getName(), fieldInfo);
        }
        return map;
    }

    protected static Set getConditionSet(SorterItemCollection sorters) {
        HashSet<String> set = new HashSet<String>();
        int size = sorters.size();
        for (int i = 0; i < size; ++i) {
            SorterItemInfo info = sorters.get(i);
            set.add(info.getPropertyName());
        }
        return set;
    }

    public static EntityViewInfo getInnerFilterInfo(QuerySolutionInfo querySolutionInfo) throws BOSException, EASBizException {
        int filterSize;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        try {
            entityViewInfo = new EntityViewInfo(querySolutionInfo.getEntityViewInfo());
        }
        catch (ParserException e3) {
            logger.error((Object)"budget error:", (Throwable)e3);
        }
        FilterInfo commonFilterInfo = entityViewInfo.getFilter();
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        if (commonFilterInfo != null && (filterSize = commonFilterInfo.getFilterItems().size()) > 0) {
            ArrayList rowInfos = BgEntityUtil.getRowInfos(commonFilterInfo);
            Date dateApp = SysUtil.getAppServerTime(null);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Calendar worldTour = Calendar.getInstance();
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowsInfo = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = commonFilterInfo.getFilterItems().get(i);
                String leftBracket = rowsInfo.getLeftBracket();
                String rightBracket = rowsInfo.getRightBracket();
                String logic = rowsInfo.getLogic();
                rowsInfo.setLeftBracket(rowsInfo.getLeftBracket());
                rowsInfo.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null) {
                    Date dateDayEnd;
                    Date dateBreakStart;
                    String lastDay;
                    String firstDay;
                    FilterItemInfo filterItemInfo2;
                    FilterItemInfo filterItemInfo1;
                    Date endDay;
                    Date startDay;
                    String condition = rowsInfo.getCondition();
                    if (condition != null && condition.endsWith("Date") && filterItemInfo.getCompareValue().getClass().getName().equals("java.sql.Timestamp") && filterItemInfo.getCompareType().equals((Object)CompareType.EQUALS)) {
                        worldTour.setTime((Date)filterItemInfo.getCompareValue());
                        worldTour.add(5, 0);
                        startDay = worldTour.getTime();
                        worldTour.add(5, 1);
                        endDay = worldTour.getTime();
                        filterItemInfo1 = new FilterItemInfo(condition, (Object)startDay, CompareType.getEnum((String)">="));
                        newFilterInfo.getFilterItems().add(filterItemInfo1);
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)endDay, CompareType.getEnum((String)"<"));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (condition != null && condition.endsWith("Date") && filterItemInfo.getCompareValue().getClass().getName().equals("java.sql.Timestamp") && filterItemInfo.getCompareType().equals((Object)CompareType.NOTEQUALS)) {
                        worldTour.setTime((Date)filterItemInfo.getCompareValue());
                        worldTour.add(5, 0);
                        startDay = worldTour.getTime();
                        worldTour.add(5, 1);
                        endDay = worldTour.getTime();
                        filterItemInfo1 = new FilterItemInfo(condition, (Object)startDay, CompareType.getEnum((String)"<"));
                        newFilterInfo.getFilterItems().add(filterItemInfo1);
                        filterItemInfo2 = new FilterItemInfo(condition, (Object)endDay, CompareType.getEnum((String)">="));
                        newFilterInfo.getFilterItems().add(filterItemInfo2);
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("OR").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("YESTERDAY") != -1) {
                        worldTour = Calendar.getInstance();
                        worldTour.setTime(dateApp);
                        worldTour.add(5, -1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        lastDay = df.format(dateApp) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo2 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo2);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("TODAY") != -1 && filterItemInfo.getCompareValue().toString().indexOf("BEFORETODAY") == -1 && filterItemInfo.getCompareValue().toString().indexOf("AFTERTODAY") == -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(dateApp) + " 00:00:00";
                        worldTour.setTime(dateApp);
                        worldTour.add(5, 1);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo2 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo2);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("TOMORROW") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(5, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.setTime(dateApp);
                        worldTour.add(5, 2);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("LASTWEEK") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(11, -168);
                        worldTour.set(7, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.add(5, 6);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("THISWEEK") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.set(7, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.set(7, 7);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("NEXTWEEK") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(11, 168);
                        worldTour.set(7, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.set(7, 7);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("LASTMONTH") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(2, -1);
                        firstDay = df.format(worldTour.getTime());
                        firstDay = firstDay.substring(0, firstDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        worldTour.add(2, 1);
                        lastDay = df.format(worldTour.getTime());
                        lastDay = lastDay.substring(0, lastDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("THISMONTH") != -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(worldTour.getTime());
                        firstDay = firstDay.substring(0, firstDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        worldTour.add(2, 1);
                        lastDay = df.format(worldTour.getTime());
                        lastDay = lastDay.substring(0, lastDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("NEXTMONTH") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(2, 1);
                        firstDay = df.format(worldTour.getTime());
                        firstDay = firstDay.substring(0, firstDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        worldTour.add(2, 1);
                        lastDay = df.format(worldTour.getTime());
                        lastDay = lastDay.substring(0, lastDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("BEFORETODAY") != -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("AFTERTODAY") != -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    newFilterInfo.getFilterItems().add(commonFilterInfo.getFilterItems().get(i));
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (filterItemInfo.getPropertyName() == null) continue;
                newFilterInfo.getFilterItems().add(commonFilterInfo.getFilterItems().get(i));
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        entityViewInfo.setFilter(newFilterInfo);
        return entityViewInfo;
    }

    public static FilterInfo getInnerFilterInfo(FilterInfo commonFilterInfo) throws BOSException, EASBizException {
        int filterSize;
        FilterInfo newFilterInfo = new FilterInfo();
        StringBuffer sbFormula = new StringBuffer();
        if (commonFilterInfo != null && (filterSize = commonFilterInfo.getFilterItems().size()) > 0) {
            ArrayList rowInfos = BgEntityUtil.getRowInfos(commonFilterInfo);
            Date dateApp = SysUtil.getAppServerTime(null);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Calendar worldTour = Calendar.getInstance();
            for (int i = 0; i < filterSize; ++i) {
                RowObject rowsInfo = (RowObject)rowInfos.get(i);
                FilterItemInfo filterItemInfo = commonFilterInfo.getFilterItems().get(i);
                String leftBracket = rowsInfo.getLeftBracket();
                String rightBracket = rowsInfo.getRightBracket();
                String logic = rowsInfo.getLogic();
                rowsInfo.setLeftBracket(rowsInfo.getLeftBracket());
                rowsInfo.setCondition(filterItemInfo.getPropertyName());
                if (filterItemInfo.getCompareValue() != null) {
                    FilterItemInfo filterItemInfo1;
                    Date dateDayEnd;
                    Date dateBreakStart;
                    String lastDay;
                    String firstDay;
                    String condition = rowsInfo.getCondition();
                    if (filterItemInfo.getCompareValue().toString().indexOf("YESTERDAY") != -1) {
                        worldTour = Calendar.getInstance();
                        worldTour.setTime(dateApp);
                        worldTour.add(5, -1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        lastDay = df.format(dateApp) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("TODAY") != -1 && filterItemInfo.getCompareValue().toString().indexOf("BEFORETODAY") == -1 && filterItemInfo.getCompareValue().toString().indexOf("AFTERTODAY") == -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(dateApp) + " 00:00:00";
                        worldTour.setTime(dateApp);
                        worldTour.add(5, 1);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("TOMORROW") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(5, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.setTime(dateApp);
                        worldTour.add(5, 2);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("LASTWEEK") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(11, -168);
                        worldTour.set(7, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.add(5, 6);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("THISWEEK") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.set(7, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.set(7, 7);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("NEXTWEEK") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(11, 168);
                        worldTour.set(7, 1);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        worldTour.set(7, 7);
                        lastDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("LASTMONTH") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(2, -1);
                        firstDay = df.format(worldTour.getTime());
                        firstDay = firstDay.substring(0, firstDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        worldTour.add(2, 1);
                        lastDay = df.format(worldTour.getTime());
                        lastDay = lastDay.substring(0, lastDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(lastDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("THISMONTH") != -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(worldTour.getTime());
                        firstDay = firstDay.substring(0, firstDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        worldTour.add(2, 1);
                        lastDay = df.format(worldTour.getTime());
                        lastDay = lastDay.substring(0, lastDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(firstDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("NEXTMONTH") != -1) {
                        worldTour.setTime(dateApp);
                        worldTour.add(2, 1);
                        firstDay = df.format(worldTour.getTime());
                        firstDay = firstDay.substring(0, firstDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        worldTour.add(2, 1);
                        lastDay = df.format(worldTour.getTime());
                        lastDay = lastDay.substring(0, lastDay.indexOf("-", 6) + 1) + "01 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            dateDayEnd = df.parse(firstDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateDayEnd, CompareType.getEnum((String)"<="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 2)).append(" ").append("AND").append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("BEFORETODAY") != -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)"<"));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    if (filterItemInfo.getCompareValue().toString().indexOf("AFTERTODAY") != -1) {
                        worldTour.setTime(dateApp);
                        firstDay = df.format(worldTour.getTime()) + " 00:00:00";
                        try {
                            dateBreakStart = df.parse(firstDay);
                            filterItemInfo1 = new FilterItemInfo(condition, (Object)dateBreakStart, CompareType.getEnum((String)">="));
                            newFilterInfo.getFilterItems().add(filterItemInfo1);
                        }
                        catch (ParseException e) {
                            logger.error((Object)"budget error:", (Throwable)e);
                        }
                        sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                        continue;
                    }
                    newFilterInfo.getFilterItems().add(commonFilterInfo.getFilterItems().get(i));
                    sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
                    continue;
                }
                if (filterItemInfo.getPropertyName() == null) continue;
                newFilterInfo.getFilterItems().add(commonFilterInfo.getFilterItems().get(i));
                sbFormula.append(leftBracket).append(" ").append("#").append(String.valueOf(newFilterInfo.getFilterItems().size() - 1)).append(" ").append(rightBracket).append(" ").append(logic).append(" ");
            }
            String strFormula = sbFormula.toString();
            if (strFormula != null && !strFormula.trim().equalsIgnoreCase("")) {
                newFilterInfo.setMaskString(sbFormula.toString().substring(0, strFormula.length() - 1));
            }
        }
        return newFilterInfo;
    }

    protected static OrgType getOrgType(QueryInfo queryInfo) {
        OrgType orgType = null;
        try {
            EntityObjectInfo eo;
            String orgTypeStr;
            SubObjectInfo main = queryInfo.getMainObject();
            if (main instanceof SubQueryInfo) {
                main = ((SubQueryInfo)main).getQueryRef().getMainObject();
            }
            if ((orgTypeStr = (eo = ((SubEntityInfo)main).getEntityRef()).getExtendedProperty("OrgType")) != null) {
                if ("Admin".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Admin;
                } else if ("Company".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Company;
                } else if ("Sale".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Sale;
                } else if ("Purchase".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Purchase;
                } else if ("Storage".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.Storage;
                } else if ("CostCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.CostCenter;
                } else if ("ProfitCenter".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ProfitCenter;
                } else if ("ControlUnit".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.ControlUnit;
                } else if ("HRO".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.HRO;
                } else if ("NONE".equalsIgnoreCase(orgTypeStr)) {
                    orgType = OrgType.NONE;
                }
            } else {
                orgType = null;
            }
        }
        catch (RuntimeException e) {
            orgType = null;
        }
        catch (BOSException e) {
            orgType = null;
        }
        return orgType;
    }
}

