/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgExamineItemF7UI;
import com.kingdee.eas.ma.budget.client.BgElementDialog;
import com.kingdee.eas.ma.budget.client.BgExaminePeriodF7Dialog;
import com.kingdee.eas.ma.budget.client.BgOrgViewF7;
import com.kingdee.eas.ma.budget.client.NewBgItemDialog;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgExamineItemF7UI
extends AbstractBgExamineItemF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgExamineItemF7UI.class);
    private String result = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
        this.init();
    }

    private void init() {
        BgOrgViewF7 orgF7 = new BgOrgViewF7((IUIObject)this);
        orgF7.setCurrentCUID(SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        this.prmtOrgUnit.setSelector((KDPromptSelector)orgF7);
        this.prmtOrgUnit.setEditable(true);
        orgF7.setMultiSelect(true);
        this.prmtOrgUnit.setDisplayFormat("$name$");
        this.prmtOrgUnit.setEditFormat("$number$");
        this.prmtBgScheme.setValue(null);
        this.prmtBgScheme.setEditable(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String orgUnitId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        filter.setMaskString("#0");
        if (BgSHelper.isBgPermissionUsed()) {
            HashSet<String> orgSet = new HashSet<String>();
            orgSet.add(orgUnitId);
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgSet, (FilterInfo)filter);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
        BgExaminePeriodF7Dialog periodDialog = new BgExaminePeriodF7Dialog();
        this.prmtPeriod.setSelector((KDPromptSelector)periodDialog);
        this.prmtPeriod.setEditable(true);
        BgElementDialog bgElement = new BgElementDialog((IUIObject)this);
        bgElement.setIsChooseOne(true);
        this.prmtBgElement.setSelector((KDPromptSelector)bgElement);
        this.prmtBgElement.setDisplayFormat("$name$");
        this.prmtBgElement.setEditable(false);
        NewBgItemDialog itemDialog = new NewBgItemDialog((IUIObject)this);
        itemDialog.setSelectCombinItem(true);
        this.prmtBgItem.setSelector((KDPromptSelector)itemDialog);
        this.prmtBgItem.setDisplayFormat("$name$");
        this.prmtBgItem.setEditable(false);
        this.prmtCurrency.setEditable(false);
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.isAllNull()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineAllNull"));
            SysUtil.abort();
            this.prmtOrgUnit.requestFocus();
        }
        this.setResultFromPrmt();
        this.getUIWindow().close();
    }

    protected boolean isAllNull() throws Exception {
        boolean ExamineAllNull = false;
        boolean BgItemNull = false;
        boolean BgElementNull = false;
        boolean CurrencyNull = false;
        boolean PeriodNull = false;
        if (this.prmtBgItem.getText() == null || this.prmtBgItem.getText().trim().length() == 0) {
            BgItemNull = true;
        }
        if (this.prmtBgElement.getText() == null || this.prmtBgElement.getText().trim().length() == 0) {
            BgElementNull = true;
        }
        if (this.prmtCurrency.getText() == null || this.prmtCurrency.getText().trim().length() == 0) {
            CurrencyNull = true;
        }
        if (this.prmtPeriod.getText() == null || this.prmtPeriod.getText().trim().length() == 0) {
            PeriodNull = true;
        }
        ExamineAllNull = BgItemNull && BgElementNull && CurrencyNull && PeriodNull;
        return ExamineAllNull;
    }

    private boolean isErrorData() {
        return this.prmtOrgUnit.getValue() != null ? this.prmtBgScheme.getValue() == null : this.prmtOrgUnit.getValue() == null && this.prmtBgScheme.getValue() != null;
    }

    private void setResultFromPrmt() {
        this.verifyX();
        StringBuffer item = new StringBuffer();
        item.append("BgItem(\"");
        if (this.prmtOrgUnit.getValue() != null && this.prmtOrgUnit.getValue() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])this.prmtOrgUnit.getValue();
            StringBuffer orgStr = new StringBuffer();
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (i == orgUnitInfos.length - 1) {
                    orgStr.append(orgUnitInfos[i].getNumber());
                    continue;
                }
                orgStr.append(orgUnitInfos[i].getNumber()).append(";");
            }
            item.append(orgStr.toString());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBgScheme.getValue() != null) {
            item.append(((BgSchemeInfo)this.prmtBgScheme.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBgItem.getValue() != null) {
            item.append(((VisualItemInfo)this.prmtBgItem.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtBgElement.getValue() != null) {
            item.append(((BgElementInfo)this.prmtBgElement.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtCurrency.getValue() != null) {
            item.append(((CurrencyInfo)this.prmtCurrency.getValue()).getNumber());
        } else {
            item.append("%");
        }
        item.append("\",\"");
        if (this.prmtPeriod.getValue() != null) {
            item.append(this.periodToFormulatrouble());
        } else {
            item.append("%");
        }
        item.append("\")");
        this.setResult(item.toString());
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        this.prmtBgScheme.setValue(null);
        HashSet<String> orgUnitSet = new HashSet<String>();
        String[] strOrgNumber = null;
        if (this.prmtOrgUnit.getValue() != null && this.prmtOrgUnit.getValue() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] orgUnitInfos = (OrgUnitInfo[])this.prmtOrgUnit.getValue();
            strOrgNumber = new String[orgUnitInfos.length];
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                orgUnitSet.add(orgUnitInfos[i].getId().toString());
                strOrgNumber[i] = orgUnitInfos[i].getNumber();
            }
        } else {
            strOrgNumber = new String[1];
            CostCenterOrgUnitInfo info = SysContext.getSysContext().getCurrentCostUnit();
            orgUnitSet.add(info.getId().toString());
            strOrgNumber[0] = info.getNumber();
        }
        HashSet<String> bgSchemeIdSet = new HashSet<String>();
        HashSet<String> bgSchemeIdSetCurrentUser = new HashSet<String>();
        ArrayList<String> bgSchemeIdList = new ArrayList<String>();
        try {
            IBgScheme iBgS = BgSchemeFactory.getRemoteInstance();
            BgSchemeCollection bgSchemeCol = iBgS.getSameSchemeByOrgNumbers(strOrgNumber);
            if (bgSchemeCol != null && !bgSchemeCol.isEmpty()) {
                for (int i = 0; i < bgSchemeCol.size(); ++i) {
                    bgSchemeIdSet.add(bgSchemeCol.get(i).getId().toString());
                    bgSchemeIdList.add(bgSchemeCol.get(i).getId().toString());
                }
            }
        }
        catch (BOSException e2) {
            this.handUIException(e2);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bgSchemeIdSet, CompareType.INCLUDE));
        filter.setMaskString("#0");
        if (BgSHelper.isBgPermissionUsed()) {
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgSchemePermission((String)user, orgUnitSet, (FilterInfo)filter);
        }
        int perNum = filter.getFilterItems().size() - 1;
        try {
            String user = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            IBgScheme iBgS = BgSchemeFactory.getRemoteInstance();
            Map bgSchemeColMap = iBgS.getCreatorByScheme(bgSchemeIdList);
            if (bgSchemeColMap != null && !bgSchemeColMap.isEmpty()) {
                String schemeid2 = null;
                String creatorid = null;
                for (String schemeid2 : bgSchemeColMap.keySet()) {
                    creatorid = (String)bgSchemeColMap.get(schemeid2);
                    if (!user.equals(creatorid)) continue;
                    bgSchemeIdSetCurrentUser.add(schemeid2);
                }
            }
        }
        catch (BOSException e3) {
            this.handUIException(e3);
        }
        if (bgSchemeIdSetCurrentUser != null && !bgSchemeIdSetCurrentUser.isEmpty()) {
            FilterItemInfo itemScheme = new FilterItemInfo("id".toLowerCase(), bgSchemeIdSetCurrentUser, CompareType.INCLUDE);
            perNum = BgPermissionHelper.replaceFilterItems((FilterInfo)filter, (FilterItemInfo)itemScheme, (int)perNum);
            filter = BgPermissionHelper.setMarkStringForForm((FilterInfo)filter, (int)perNum);
        }
        view.setFilter(filter);
        this.prmtBgScheme.setEntityViewInfo(view);
    }

    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    private String periodToFormulaeasy() {
        String period = (String)this.prmtPeriod.getValue();
        String stryear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"stryear");
        String strfirsthalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strfirsthalfyear");
        String strlasthalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strlasthalfyear");
        String strhalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strhalfyear");
        String strquarter = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strquarter");
        String strmonth = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strmonth");
        String strweek = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strweek");
        String strday = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strday");
        String strTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strtenDay");
        String strFirstTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strFirstTenDay");
        String strSecondTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strSecondTenDay");
        String strThirdTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strThirdTenDay");
        if (period.indexOf(strfirsthalfyear) < 0 && period.indexOf(strlasthalfyear) < 0 && period.endsWith(stryear)) {
            period = period.replaceAll(stryear, "Y");
        } else {
            period = period.replaceFirst(stryear, "Y");
            period = period.replaceFirst("Y", "Y|");
        }
        period = period.endsWith(strmonth) ? period.replaceAll(strmonth, "M") : period.replaceAll(strmonth, "M|");
        period = period.replaceAll(strfirsthalfyear, "01HY");
        period = period.replaceAll(strlasthalfyear, "02HY");
        period = period.replaceAll(strquarter, "Q");
        period = period.replaceAll(strweek, "W");
        period = period.replaceAll(strday, "D");
        period = period.replaceAll(strFirstTenDay, "01TD");
        period = period.replaceAll(strSecondTenDay, "02TD");
        period = period.replaceAll(strThirdTenDay, "03TD");
        period = period.replaceAll(strTenDay, "TD");
        return period;
    }

    private String periodToFormulatrouble() {
        String period = (String)this.prmtPeriod.getValue();
        String stryear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"stryear");
        String strfirsthalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strfirsthalfyear");
        String strlasthalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strlasthalfyear");
        String strhalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strhalfyear");
        String strquarter = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strquarter");
        String strmonth = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strmonth");
        String strweek = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strweek");
        String strday = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strday");
        String strTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strtenDay");
        String strFirstTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strFirstTenDay");
        String strSecondTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strSecondTenDay");
        String strThirdTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strThirdTenDay");
        period = period.replaceAll(strfirsthalfyear, "01HY");
        period = period.replaceAll(strlasthalfyear, "02HY");
        period = period.replaceAll(strhalfyear, "HY");
        period = period.replaceAll(stryear, "Y");
        period = period.replaceAll(strquarter, "Q");
        period = (period = period.replaceAll(strmonth, "M")).indexOf(strweek) > 0 && period.indexOf(77) > 0 ? period.replaceAll(strweek, "MW") : period.replaceAll(strweek, "W");
        period = period.replaceAll(strday, "D");
        period = period.replaceAll(strFirstTenDay, "01TD");
        period = period.replaceAll(strSecondTenDay, "02TD");
        period = period.replaceAll(strThirdTenDay, "03TD");
        if ((period = period.replaceAll(strTenDay, "TD")).startsWith("%Y")) {
            return period;
        }
        StringBuffer res = new StringBuffer();
        boolean preIsNumber = true;
        char c = '\u0000';
        for (int i = 0; i < period.length(); ++i) {
            c = period.charAt(i);
            if (c >= '0' && c <= '9' || c == '%') {
                if (!preIsNumber) {
                    res.append('.');
                }
                preIsNumber = true;
            } else if (c != '|') {
                preIsNumber = false;
            }
            if (c == '|') continue;
            res.append(c);
        }
        return res.toString();
    }

    private void verifyX() {
        String beginData;
        boolean xError = false;
        if (this.prmtPeriod.getValue() != null && this.prmtPeriod.getValue().toString() != null && (beginData = this.prmtPeriod.getValue().toString()).indexOf("x") + beginData.indexOf("X") > -2) {
            beginData = beginData.replaceAll("x", "");
            beginData = beginData.replaceAll("X", "");
            beginData = beginData.replaceAll(" ", "");
            beginData = beginData.replaceAll("\\+", "");
            if (!(beginData = beginData.replaceAll("\\-", "")).equals("")) {
                try {
                    new BigDecimal(beginData);
                }
                catch (Exception e) {
                    xError = true;
                }
            }
        }
        if (xError) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"xError"));
            SysUtil.abort();
        }
    }
}

