/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.ma.budget.BgExamineFactory;
import com.kingdee.eas.ma.budget.BgExamineGroupFactory;
import com.kingdee.eas.ma.budget.BgExamineGroupInfo;
import com.kingdee.eas.ma.budget.BgExamineInfo;
import com.kingdee.eas.ma.budget.IBgExamine;
import com.kingdee.eas.ma.budget.IBgExamineGroup;
import com.kingdee.eas.ma.budget.client.AbstractBgExamineListUI;
import com.kingdee.eas.ma.budget.client.BgExamineEditUI;
import com.kingdee.eas.ma.budget.client.BgExamineGroupEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.TreeSelectionEvent;
import org.apache.log4j.Logger;

public class BgExamineListUI
extends AbstractBgExamineListUI {
    private static final Logger logger = CoreUIObject.getLogger(BgExamineListUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public IBgExamine getInterface() throws Exception {
        return BgExamineFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnGroupMoveTree.setVisible(false);
        this.actionGroupEdit.setEnabled(true);
        this.actionGroupRemove.setEnabled(true);
        this.btnGroupEdit.setEnabled(true);
        this.btnGroupRemove.setEnabled(true);
        this.btnGroupMoveTree.setEnabled(false);
        this.actionGroupMoveTree.setEnabled(false);
    }

    protected String getRootName() {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"root");
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        ObjectUuidPK groupPK = null;
        String id = this.getSelectedKeyValue();
        if (!StringUtils.isEmpty((String)id)) {
            try {
                BgExamineInfo bgExamineInfo = this.getInterface().getBgExamineInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
                BgExamineGroupInfo group = bgExamineInfo.getExamineGroup();
                if (group != null) {
                    groupPK = new ObjectUuidPK(group.getId());
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
            }
        }
        return groupPK;
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            this.actionAddNew.setEnabled(true);
            this.btnAddNew.setEnabled(true);
        } else {
            this.actionAddNew.setEnabled(false);
            this.btnAddNew.setEnabled(false);
        }
    }

    protected String getGroupEditUIName() {
        return BgExamineGroupEditUI.class.getName();
    }

    protected String getQueryFieldName() {
        return "examineGroup.id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return BgExamineGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return BgExamineEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgExamineFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode == null || !(treeNode.getUserObject() instanceof TreeBaseInfo)) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgItemResource", (String)"isRootItemGroup"));
            return;
        }
        if (this.getSelectedBgExamineGroupInfo() == null) {
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    private boolean isBgExamineCreatorOrgUnit() throws Exception {
        BgExamineInfo info;
        String creatorOrgUnit;
        boolean isCreatorOrgUnit = true;
        String currentUserOrgUnit = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();
        if (!currentUserOrgUnit.equals(creatorOrgUnit = (info = this.getSelectedBgExamineInfo()).getOrgUnit().getId().toString())) {
            isCreatorOrgUnit = false;
        }
        return isCreatorOrgUnit;
    }

    private BgExamineInfo getSelectedBgExamineInfo() throws EASBizException, BOSException {
        String bgExamineID = null;
        BgExamineInfo examineInfo = null;
        bgExamineID = this.getSelectedKeyValue();
        if (bgExamineID != null) {
            examineInfo = BgExamineFactory.getRemoteInstance().getBgExamineInfo((IObjectPK)new ObjectUuidPK(bgExamineID), this.getSelectors());
        }
        return examineInfo;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BgExamineInfo info = this.getSelectedBgExamineInfo();
        boolean iscreator = this.notIsInit(info);
        if (!iscreator) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorNoEdit"));
            return;
        }
        if (!this.isBgExamineCreatorOrgUnit()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorOrgUnitNoEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        BgExamineInfo info = this.getSelectedBgExamineInfo();
        boolean iscreator = this.notIsInit(info);
        if (!iscreator) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorNoEdit"));
            return;
        }
        if (!this.isBgExamineCreatorOrgUnit()) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorOrgUnitNoDelete"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public static boolean isBgExamineCreator(String bizObjectId) throws Exception {
        boolean iscreator = true;
        IBgExamineGroup io = BgExamineGroupFactory.getRemoteInstance();
        BgExamineGroupInfo info = io.getBgExamineGroupInfo("select creator where id ='" + bizObjectId + "'");
        String creatorId = info.getCreator().getId().toString();
        String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (!userId.equals(creatorId)) {
            iscreator = false;
        }
        return iscreator;
    }

    public void actionGroupEdit_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            String bizObjectId = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
            boolean iscreator = BgExamineListUI.isBgExamineCreator(bizObjectId);
            if (!iscreator) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorNoEdit"));
                return;
            }
            if (this.getSelectedBgExamineGroupInfo() == null) {
                return;
            }
            super.actionGroupEdit_actionPerformed(e);
        }
    }

    public void actionGroupRemove_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            String bizObjectId = ((TreeBaseInfo)treeNode.getUserObject()).getId().toString();
            boolean iscreator = BgExamineListUI.isBgExamineCreator(bizObjectId);
            if (!iscreator) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"NotCreatorNoDelete"));
                return;
            }
            if (this.tblMain.getBody().size() >= 1) {
                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"HasItem_NoDelete"));
                return;
            }
            if (this.getSelectedBgExamineGroupInfo() == null) {
                return;
            }
        }
        super.actionGroupRemove_actionPerformed(e);
    }

    private BgExamineGroupInfo getSelectedBgExamineGroupInfo() {
        KDTreeNode treeNode = null;
        BgExamineGroupInfo examineGroupInfo = null;
        treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        if (treeNode != null && treeNode.getUserObject() instanceof TreeBaseInfo) {
            examineGroupInfo = (BgExamineGroupInfo)treeNode.getUserObject();
        }
        return examineGroupInfo;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"groupInfo", (Object)this.getSelectedBgExamineGroupInfo());
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("formulaAlias"));
        sic.add(new SelectorItemInfo("isUse"));
        sic.add(new SelectorItemInfo("compareValue"));
        sic.add(new SelectorItemInfo("compareType"));
        sic.add(new SelectorItemInfo("hint"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("examineGroup.id"));
        sic.add(new SelectorItemInfo("errorData"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        return sic;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    protected boolean isIgnoreTreeCUFilter() {
        return true;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        if (exec != null && exec.option() != null) {
            exec.option().isAutoIgnoreZero = false;
        }
        return exec;
    }

    private boolean notIsInit(BgExamineInfo info) throws EASBizException, BOSException {
        String number = info.getNumber();
        return number == null || !number.equals("initExamine");
    }
}

