/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.CalendarHelper;
import com.kingdee.eas.ma.budget.client.AbstractBgExaminePeriodF7UI;
import com.kingdee.eas.ma.budget.client.BgPeriodF7ListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.log4j.Logger;

public class BgExaminePeriodF7UI
extends AbstractBgExaminePeriodF7UI {
    private static final Logger logger = CoreUIObject.getLogger(BgExaminePeriodF7UI.class);
    private BgPeriodF7ListUI bgPeriodListUI = null;
    protected BgPeriodInfo bgPeriodInfo;
    private String result = null;
    private boolean troubleselect = false;

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        try {
            this.bgPeriodListUI = new BgPeriodF7ListUI();
            this.bgPeriodListUI.initUIContentLayout();
            this.bgPeriodListUI.getTable().addKDTMouseListener(new KDTMouseListener(){

                public void tableClicked(KDTMouseEvent e) {
                    try {
                        if (e.getClickCount() == 2) {
                            BgExaminePeriodF7UI.this.actionConfirm_actionPerformed(null);
                        }
                    }
                    catch (Exception exc) {
                        BgExaminePeriodF7UI.this.handUIException(exc);
                    }
                }
            });
            this.bgPeriodListUI.onLoad(false);
        }
        catch (Exception e) {
            if (this.bgPeriodListUI != null) {
                this.bgPeriodListUI.destroyWindow();
                this.bgPeriodListUI = null;
            }
            this.destroyWindow();
            this.handUIException(e);
        }
        this.kDPanelEasy.setLayout((LayoutManager)new BorderLayout());
        this.kDPanelEasy.add((Component)((Object)this.bgPeriodListUI), (Object)"Center");
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.troubleselect = false;
        this.initBtn();
        this.bgPeriodListUI.bgPeriodInitial();
        this.bgPeriodListUI.loadPeriodYear(true, new CalendarHelper().getCurrentlyYear(new Date()), 1);
        this.kDTextArea1.setText(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"help"));
    }

    private void initBtn() {
        this.kDPanelTrouble.setVisible(false);
        this.kDPanelTrouble.setEnabled(false);
        this.btnEasySelect.setSelected(true);
        this.btnCancel.setEnabled(true);
        this.btnConfirm.setEnabled(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
        this.getUIWindow().close();
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        if (this.btnEasySelect.isSelected()) {
            this.setBgPeriodInfo(this.bgPeriodListUI.getData());
            if (this.getBgPeriodInfo() == null) {
                String msg = EASResource.getString((String)"com.kingdee.eas.ma.budget.BgPeriodResource", (String)"selectFaild");
                MsgBox.showInfo((Component)((Object)this), (String)msg);
                return;
            }
            this.setResult(this.getBgPeriodInfo().getName());
        } else if (this.btnTrouble.isSelected()) {
            String strYear = this.textYear.getText();
            String strHalfYear = this.textHalfYear.getText();
            String strQuarter = this.textQuarter.getText();
            String strMonth = this.textMonth.getText();
            String strWeek = this.textWeek.getText();
            String strDay = this.textData.getText();
            String strTenD = this.textTenDay.getText();
            boolean chkyearweek = this.btnyear.isSelected();
            boolean chkmonthweek = this.btnMonth.isSelected();
            this.verify(strYear, strHalfYear, strQuarter, strMonth, strWeek, strDay, chkyearweek, chkmonthweek, strTenD);
            this.setResult(this.getPeriodFormula(strYear, strHalfYear, strQuarter, strMonth, strTenD, strWeek, strDay, chkyearweek, chkmonthweek));
        }
        this.getUIWindow().close();
    }

    private void verify(String year, String halfyear, String quarter, String month, String week, String day, boolean isYearWeek, boolean isMonthWeek, String strTenD) {
        int k;
        int i;
        ArrayList<Integer> ListYear = new ArrayList<Integer>();
        ArrayList<Integer> listintyear = new ArrayList<Integer>();
        int[] ArrYear = null;
        int myear = 0;
        if (year != null && year.trim().length() != 0 && !year.trim().toString().equals("%")) {
            int i2;
            String[] arrayYear = year.split(",");
            for (i2 = 0; i2 < arrayYear.length; ++i2) {
                if (arrayYear[i2].indexOf(":") > 0) {
                    String[] tempstryear = arrayYear[i2].split(":");
                    try {
                        for (int j = 0; j < tempstryear.length; ++j) {
                            listintyear.add(j, new Integer(Integer.parseInt("" + tempstryear[j])));
                        }
                        if ((Integer)listintyear.get(0) > (Integer)listintyear.get(1)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearError"));
                            SysUtil.abort();
                        }
                        int gapyear = (Integer)listintyear.get(1) - (Integer)listintyear.get(0) + 1;
                        for (int k2 = 0; k2 < gapyear; ++k2) {
                            ListYear.add(myear + k2, new Integer((Integer)listintyear.get(0) + k2));
                        }
                        myear = gapyear;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearError"));
                        SysUtil.abort();
                    }
                    continue;
                }
                if (arrayYear[i2].indexOf(":") >= 0) continue;
                try {
                    ListYear.add(myear, new Integer(Integer.parseInt("" + arrayYear[i2])));
                    ++myear;
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearError"));
                    SysUtil.abort();
                }
            }
            ArrYear = new int[ListYear.size()];
            for (i2 = 0; i2 < ListYear.size(); ++i2) {
                ArrYear[i2] = (Integer)ListYear.get(i2);
            }
            Arrays.sort(ArrYear);
            for (i2 = 1; i2 < ArrYear.length; ++i2) {
                if (ArrYear[i2 - 1] != ArrYear[i2]) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearError"));
                SysUtil.abort();
            }
        }
        ArrayList<Integer> ListHalfYear = new ArrayList<Integer>();
        ArrayList<Integer> listinthalfyear = new ArrayList<Integer>();
        int[] ArrHalfYear = null;
        int mhalfyear = 0;
        if (halfyear != null && halfyear.trim().length() != 0 && !halfyear.trim().toString().equals("%")) {
            int i3;
            String[] arrayHalfYear = halfyear.split(",");
            for (i3 = 0; i3 < arrayHalfYear.length; ++i3) {
                if (arrayHalfYear[i3].indexOf(":") > 0) {
                    String[] tempstrhalfyear = arrayHalfYear[i3].split(":");
                    try {
                        for (int j = 0; j < tempstrhalfyear.length; ++j) {
                            listinthalfyear.add(j, new Integer(Integer.parseInt("" + tempstrhalfyear[j])));
                        }
                        if ((Integer)listinthalfyear.get(0) > (Integer)listinthalfyear.get(1)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineHalfYearError"));
                            SysUtil.abort();
                        }
                        int gaphalfyear = (Integer)listinthalfyear.get(1) - (Integer)listinthalfyear.get(0) + 1;
                        for (int k3 = 0; k3 < gaphalfyear; ++k3) {
                            ListHalfYear.add(mhalfyear + k3, new Integer((Integer)listinthalfyear.get(0) + k3));
                        }
                        mhalfyear = gaphalfyear;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineHalfYearError"));
                        SysUtil.abort();
                    }
                    continue;
                }
                if (arrayHalfYear[i3].indexOf(":") >= 0) continue;
                try {
                    ListHalfYear.add(mhalfyear, new Integer(Integer.parseInt("" + arrayHalfYear[i3])));
                    ++mhalfyear;
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineHalfYearError"));
                    SysUtil.abort();
                }
            }
            ArrHalfYear = new int[ListHalfYear.size()];
            for (i3 = 0; i3 < ListHalfYear.size(); ++i3) {
                ArrHalfYear[i3] = (Integer)ListHalfYear.get(i3);
            }
            Arrays.sort(ArrHalfYear);
            for (i3 = 1; i3 < ArrHalfYear.length; ++i3) {
                if (ArrHalfYear[i3 - 1] != ArrHalfYear[i3]) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineHalfYearError"));
                SysUtil.abort();
            }
            for (i3 = 0; i3 < ArrHalfYear.length; ++i3) {
                if (ArrHalfYear[i3] >= 1 && ArrHalfYear[i3] <= 2) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineHalfYearError"));
                SysUtil.abort();
            }
        }
        ArrayList<Integer> ListQuarter = new ArrayList<Integer>();
        ArrayList<Integer> listintquarter = new ArrayList<Integer>();
        int[] ArrQuarter = null;
        int mquarter = 0;
        if (quarter != null && quarter.trim().length() != 0 && !quarter.trim().toString().equals("%")) {
            int i4;
            String[] arrayQuarter = quarter.split(",");
            for (i4 = 0; i4 < arrayQuarter.length; ++i4) {
                if (arrayQuarter[i4].indexOf(":") > 0) {
                    String[] tempstrquarter = arrayQuarter[i4].split(":");
                    try {
                        for (int j = 0; j < tempstrquarter.length; ++j) {
                            listintquarter.add(j, new Integer(Integer.parseInt("" + tempstrquarter[j])));
                        }
                        if ((Integer)listintquarter.get(0) > (Integer)listintquarter.get(1)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineQuarterError"));
                            SysUtil.abort();
                        }
                        int gapquarter = (Integer)listintquarter.get(1) - (Integer)listintquarter.get(0) + 1;
                        for (int k4 = 0; k4 < gapquarter; ++k4) {
                            ListQuarter.add(mquarter + k4, new Integer((Integer)listintquarter.get(0) + k4));
                        }
                        mquarter = gapquarter;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineQuarterError"));
                        SysUtil.abort();
                    }
                    continue;
                }
                if (arrayQuarter[i4].indexOf(":") >= 0) continue;
                try {
                    ListQuarter.add(mquarter, new Integer(Integer.parseInt("" + arrayQuarter[i4])));
                    ++mquarter;
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineQuarterError"));
                    SysUtil.abort();
                }
            }
            ArrQuarter = new int[ListQuarter.size()];
            for (i4 = 0; i4 < ListQuarter.size(); ++i4) {
                ArrQuarter[i4] = (Integer)ListQuarter.get(i4);
            }
            Arrays.sort(ArrQuarter);
            for (i4 = 1; i4 < ArrQuarter.length; ++i4) {
                if (ArrQuarter[i4 - 1] != ArrQuarter[i4]) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineQuarterError"));
                SysUtil.abort();
            }
            for (i4 = 0; i4 < ArrQuarter.length; ++i4) {
                if (ArrQuarter[i4] >= 1 && ArrQuarter[i4] <= 4) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineQuarterError"));
                SysUtil.abort();
            }
        }
        ArrayList<Integer> ListMonth = new ArrayList<Integer>();
        ArrayList<Integer> listintmonth = new ArrayList<Integer>();
        int[] ArrMonth = null;
        int mmonth = 0;
        if (month != null && month.trim().length() != 0 && !month.trim().toString().equals("%")) {
            int i5;
            String[] arrayMonth = month.split(",");
            for (i5 = 0; i5 < arrayMonth.length; ++i5) {
                if (arrayMonth[i5].indexOf(":") > 0) {
                    String[] tempstrmonth = arrayMonth[i5].split(":");
                    try {
                        for (int j = 0; j < tempstrmonth.length; ++j) {
                            listintmonth.add(j, new Integer(Integer.parseInt("" + tempstrmonth[j])));
                        }
                        if ((Integer)listintmonth.get(0) > (Integer)listintmonth.get(1)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthError"));
                            SysUtil.abort();
                        }
                        int gapmonth = (Integer)listintmonth.get(1) - (Integer)listintmonth.get(0) + 1;
                        for (int k5 = 0; k5 < gapmonth; ++k5) {
                            ListMonth.add(mmonth + k5, new Integer((Integer)listintmonth.get(0) + k5));
                        }
                        mmonth = gapmonth;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthError"));
                        SysUtil.abort();
                    }
                    continue;
                }
                if (arrayMonth[i5].indexOf(":") >= 0) continue;
                try {
                    ListMonth.add(mmonth, new Integer(Integer.parseInt("" + arrayMonth[i5])));
                    ++mmonth;
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthError"));
                    SysUtil.abort();
                }
            }
            ArrMonth = new int[ListMonth.size()];
            for (i5 = 0; i5 < ListMonth.size(); ++i5) {
                ArrMonth[i5] = (Integer)ListMonth.get(i5);
            }
            Arrays.sort(ArrMonth);
            for (i5 = 1; i5 < ArrMonth.length; ++i5) {
                if (ArrMonth[i5 - 1] != ArrMonth[i5]) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthError"));
                SysUtil.abort();
            }
            for (i5 = 0; i5 < ArrMonth.length; ++i5) {
                if (ArrMonth[i5] >= 1 && ArrMonth[i5] <= 12) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthError"));
                SysUtil.abort();
            }
        }
        ArrayList<Integer> ListDay = new ArrayList<Integer>();
        ArrayList<Integer> listintday = new ArrayList<Integer>();
        int[] ArrDay = null;
        int mday = 0;
        if (day != null && day.trim().length() != 0 && !day.trim().toString().equals("%")) {
            int i6;
            String[] arrayDay = day.split(",");
            for (i6 = 0; i6 < arrayDay.length; ++i6) {
                if (arrayDay[i6].indexOf(":") > 0) {
                    String[] tempstrday = arrayDay[i6].split(":");
                    try {
                        for (int j = 0; j < tempstrday.length; ++j) {
                            listintday.add(j, new Integer(Integer.parseInt("" + tempstrday[j])));
                        }
                        if ((Integer)listintday.get(0) > (Integer)listintday.get(1)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineDayError"));
                            SysUtil.abort();
                        }
                        int gapday = (Integer)listintday.get(1) - (Integer)listintday.get(0) + 1;
                        for (int k6 = 0; k6 < gapday; ++k6) {
                            ListDay.add(mday + k6, new Integer((Integer)listintday.get(0) + k6));
                        }
                        mday = gapday;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineDayError"));
                        SysUtil.abort();
                    }
                    continue;
                }
                if (arrayDay[i6].indexOf(":") >= 0) continue;
                try {
                    ListDay.add(mday, new Integer(Integer.parseInt("" + arrayDay[i6])));
                    ++mday;
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineDayError"));
                    SysUtil.abort();
                }
            }
            ArrDay = new int[ListDay.size()];
            for (i6 = 0; i6 < ListDay.size(); ++i6) {
                ArrDay[i6] = (Integer)ListDay.get(i6);
            }
            Arrays.sort(ArrDay);
            for (i6 = 1; i6 < ArrDay.length; ++i6) {
                if (ArrDay[i6 - 1] != ArrDay[i6]) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineDayError"));
                SysUtil.abort();
            }
            for (i6 = 0; i6 < ArrDay.length; ++i6) {
                if (ArrDay[i6] >= 1 && ArrDay[i6] <= 31) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineDayError"));
                SysUtil.abort();
            }
        }
        int[] ArrYearWeek = null;
        int[] ArrMonthWeek = null;
        if (week != null && week.trim().length() != 0 && !week.trim().toString().equals("%")) {
            if (isYearWeek) {
                ArrayList<Integer> ListYearWeek = new ArrayList<Integer>();
                ArrayList<Integer> listintyearweek = new ArrayList<Integer>();
                int myearweek = 0;
                String[] arrayYearWeek = week.split(",");
                for (i = 0; i < arrayYearWeek.length; ++i) {
                    if (arrayYearWeek[i].indexOf(":") > 0) {
                        String[] tempstryearweek = arrayYearWeek[i].split(":");
                        try {
                            for (int j = 0; j < tempstryearweek.length; ++j) {
                                listintyearweek.add(j, new Integer(Integer.parseInt("" + tempstryearweek[j])));
                            }
                            if ((Integer)listintyearweek.get(0) > (Integer)listintyearweek.get(1)) {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearWeekError"));
                                SysUtil.abort();
                            }
                            int gapyearweek = (Integer)listintyearweek.get(1) - (Integer)listintyearweek.get(0) + 1;
                            for (k = 0; k < gapyearweek; ++k) {
                                ListYearWeek.add(myearweek + k, new Integer((Integer)listintyearweek.get(0) + k));
                            }
                            myearweek = gapyearweek;
                        }
                        catch (Exception ex) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearWeekError"));
                            SysUtil.abort();
                        }
                        continue;
                    }
                    if (arrayYearWeek[i].indexOf(":") >= 0) continue;
                    try {
                        ListYearWeek.add(myearweek, new Integer(Integer.parseInt("" + arrayYearWeek[i])));
                        ++myearweek;
                        continue;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearWeekError"));
                        SysUtil.abort();
                    }
                }
                ArrYearWeek = new int[ListYearWeek.size()];
                for (i = 0; i < ListYearWeek.size(); ++i) {
                    ArrYearWeek[i] = (Integer)ListYearWeek.get(i);
                }
                Arrays.sort(ArrYearWeek);
                for (i = 1; i < ArrYearWeek.length; ++i) {
                    if (ArrYearWeek[i - 1] != ArrYearWeek[i]) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearWeekError"));
                    SysUtil.abort();
                }
                for (i = 0; i < ArrYearWeek.length; ++i) {
                    if (ArrYearWeek[i] >= 1 && ArrYearWeek[i] <= 53) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineYearWeekError"));
                    SysUtil.abort();
                }
            }
            if (isMonthWeek) {
                ArrayList<Integer> ListMonthWeek = new ArrayList<Integer>();
                ArrayList<Integer> listintmonthweek = new ArrayList<Integer>();
                int mmonthweek = 0;
                String[] arrayMonthWeek = week.split(",");
                for (i = 0; i < arrayMonthWeek.length; ++i) {
                    if (arrayMonthWeek[i].indexOf(":") > 0) {
                        String[] tempstrmonthweek = arrayMonthWeek[i].split(":");
                        try {
                            for (int j = 0; j < tempstrmonthweek.length; ++j) {
                                listintmonthweek.add(j, new Integer(Integer.parseInt("" + tempstrmonthweek[j])));
                            }
                            if ((Integer)listintmonthweek.get(0) > (Integer)listintmonthweek.get(1)) {
                                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthWeekError"));
                                SysUtil.abort();
                            }
                            int gapmonthweek = (Integer)listintmonthweek.get(1) - (Integer)listintmonthweek.get(0) + 1;
                            for (k = 0; k < gapmonthweek; ++k) {
                                ListMonthWeek.add(mmonthweek + k, new Integer((Integer)listintmonthweek.get(0) + k));
                            }
                            mmonthweek = gapmonthweek;
                        }
                        catch (Exception ex) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthWeekError"));
                            SysUtil.abort();
                        }
                        continue;
                    }
                    if (arrayMonthWeek[i].indexOf(":") >= 0) continue;
                    try {
                        ListMonthWeek.add(mmonthweek, new Integer(Integer.parseInt("" + arrayMonthWeek[i])));
                        ++mmonthweek;
                        continue;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthWeekError"));
                        SysUtil.abort();
                    }
                }
                ArrMonthWeek = new int[ListMonthWeek.size()];
                for (i = 0; i < ListMonthWeek.size(); ++i) {
                    ArrMonthWeek[i] = (Integer)ListMonthWeek.get(i);
                }
                Arrays.sort(ArrMonthWeek);
                for (i = 1; i < ArrMonthWeek.length; ++i) {
                    if (ArrMonthWeek[i - 1] != ArrMonthWeek[i]) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthWeekError"));
                    SysUtil.abort();
                }
                for (i = 0; i < ArrMonthWeek.length; ++i) {
                    if (ArrMonthWeek[i] >= 1 && ArrMonthWeek[i] <= 6) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineMonthWeekError"));
                    SysUtil.abort();
                }
            }
        }
        if (strTenD != null && strTenD.trim().length() != 0 && !strTenD.trim().toString().equals("%")) {
            int i7;
            String[] arrayTenD = strTenD.split(",");
            ArrayList<Integer> ListTenD = new ArrayList<Integer>();
            ArrayList<Integer> listintTenD = new ArrayList<Integer>();
            int mTenD = 0;
            for (i = 0; i < arrayTenD.length; ++i) {
                if (arrayTenD[i].indexOf(":") > 0) {
                    String[] tempstrTenD = arrayTenD[i].split(":");
                    try {
                        for (int j = 0; j < tempstrTenD.length; ++j) {
                            listintTenD.add(j, new Integer(Integer.parseInt("" + tempstrTenD[j])));
                        }
                        if ((Integer)listintTenD.get(0) > (Integer)listintTenD.get(1)) {
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineTenDayError"));
                            SysUtil.abort();
                        }
                        int gapTenD = (Integer)listintTenD.get(1) - (Integer)listintTenD.get(0) + 1;
                        for (k = 0; k < gapTenD; ++k) {
                            ListTenD.add(mTenD + k, new Integer((Integer)listintTenD.get(0) + k));
                        }
                        mTenD = gapTenD;
                    }
                    catch (Exception ex) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineTenDayError"));
                        SysUtil.abort();
                    }
                    continue;
                }
                if (arrayTenD[i].indexOf(":") >= 0) continue;
                try {
                    ListTenD.add(mTenD, new Integer(Integer.parseInt("" + arrayTenD[i])));
                    ++mTenD;
                    continue;
                }
                catch (Exception ex) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineTenDayError"));
                    SysUtil.abort();
                }
            }
            int[] ArrTenD = new int[ListTenD.size()];
            for (i7 = 0; i7 < ListTenD.size(); ++i7) {
                ArrTenD[i7] = (Integer)ListTenD.get(i7);
            }
            Arrays.sort(ArrTenD);
            for (i7 = 1; i7 < ArrTenD.length; ++i7) {
                if (ArrTenD[i7 - 1] != ArrTenD[i7]) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineTenDayError"));
                SysUtil.abort();
            }
            for (i7 = 0; i7 < ArrTenD.length; ++i7) {
                if (ArrTenD[i7] >= 1 && ArrTenD[i7] <= 3) continue;
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"ExamineTenDayError"));
                SysUtil.abort();
            }
        }
        if (ArrHalfYear != null) {
            for (int i8 = 0; i8 < ArrHalfYear.length; ++i8) {
                if (ArrHalfYear[i8] == 1) {
                    if (ArrQuarter != null) {
                        for (int j = 0; j < ArrQuarter.length; ++j) {
                            if (ArrQuarter[j] <= 2) continue;
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"HalfYear_Quarter_LogicError"));
                            SysUtil.abort();
                        }
                    }
                    if (ArrMonth != null) {
                        for (int k7 = 0; k7 < ArrMonth.length; ++k7) {
                            if (ArrMonth[k7] <= 6) continue;
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"HalfYear_Month_LogicError"));
                            SysUtil.abort();
                        }
                    }
                }
                if (ArrHalfYear[i8] != 2) continue;
                if (ArrQuarter != null) {
                    for (int j = 0; j < ArrQuarter.length; ++j) {
                        if (ArrQuarter[j] >= 3) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"HalfYear_Quarter_LogicError"));
                        SysUtil.abort();
                    }
                }
                if (ArrMonth == null) continue;
                for (int k8 = 0; k8 < ArrMonth.length; ++k8) {
                    if (ArrMonth[k8] >= 7) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"HalfYear_Month_LogicError"));
                    SysUtil.abort();
                }
            }
        }
        if (ArrQuarter != null && ArrMonth != null) {
            for (int i9 = 0; i9 < ArrQuarter.length; ++i9) {
                if (ArrQuarter[i9] == 1) {
                    for (int k9 = 0; k9 < ArrMonth.length; ++k9) {
                        if (ArrMonth[k9] >= 1 && ArrMonth[k9] <= 3) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Quarter_Month_LogicError"));
                        SysUtil.abort();
                    }
                }
                if (ArrQuarter[i9] == 2) {
                    for (int k10 = 0; k10 < ArrMonth.length; ++k10) {
                        if (ArrMonth[k10] >= 4 && ArrMonth[k10] <= 6) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Quarter_Month_LogicError"));
                        SysUtil.abort();
                    }
                }
                if (ArrQuarter[i9] == 3) {
                    for (int k11 = 0; k11 < ArrMonth.length; ++k11) {
                        if (ArrMonth[k11] >= 7 && ArrMonth[k11] <= 9) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Quarter_Month_LogicError"));
                        SysUtil.abort();
                    }
                }
                if (ArrQuarter[i9] != 4) continue;
                for (int k12 = 0; k12 < ArrMonth.length; ++k12) {
                    if (ArrMonth[k12] >= 10 && ArrMonth[k12] <= 12) continue;
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Quarter_Month_LogicError"));
                    SysUtil.abort();
                }
            }
        }
        if (ArrMonth != null) {
            for (int i10 = 0; i10 < ArrMonth.length; ++i10) {
                if ((ArrMonth[i10] == 4 || ArrMonth[i10] == 6 || ArrMonth[i10] == 8 || ArrMonth[i10] == 10 || ArrMonth[i10] == 12) && ArrDay != null) {
                    for (int k13 = 0; k13 < ArrDay.length; ++k13) {
                        if (ArrDay[k13] >= 1 && ArrDay[k13] <= 30) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Month_Day_LogicError"));
                        SysUtil.abort();
                    }
                }
                if (ArrMonth[i10] != 2 || ArrYear == null) continue;
                for (int j = 0; j < ArrYear.length; ++j) {
                    if (new GregorianCalendar().isLeapYear(ArrYear[j])) {
                        if (ArrDay == null) continue;
                        for (int k14 = 0; k14 < ArrDay.length; ++k14) {
                            if (ArrDay[k14] >= 1 && ArrDay[k14] <= 29) continue;
                            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Month_Day_LeapLogicError"));
                            SysUtil.abort();
                        }
                        continue;
                    }
                    if (ArrDay == null) continue;
                    for (int k15 = 0; k15 < ArrDay.length; ++k15) {
                        if (ArrDay[k15] >= 1 && ArrDay[k15] <= 28) continue;
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"Month_Day_LogicError"));
                        SysUtil.abort();
                    }
                }
            }
        }
        if (ArrYearWeek != null && isYearWeek && (ArrHalfYear != null || ArrQuarter != null || ArrMonth != null || ArrDay != null)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"YearWeek_LogicError"));
            SysUtil.abort();
        }
        if (ArrMonthWeek != null && isMonthWeek) {
            if (ArrDay != null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"MonthWeek_Day_LogicError"));
                SysUtil.abort();
            }
            if (ArrMonth == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"MonthWeek_Month_LogicError"));
                SysUtil.abort();
            }
        }
    }

    private String getPeriodFormula(String year, String halfYear, String quarter, String month, String tenDay, String week, String data, boolean isYearWeek, boolean isMonthWeek) {
        String stryear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"stryear");
        String strhalfyear = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strhalfyear");
        String strquarter = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strquarter");
        String strmonth = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strmonth");
        String strweek = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strweek");
        String strday = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strday");
        String strTenDay = EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineResource", (String)"strtenDay");
        String period = null;
        if (year != null && !year.trim().equals("")) {
            year = year.trim();
            period = year + stryear;
        } else {
            period = "%" + stryear;
        }
        if (data != null && !data.trim().equals("")) {
            if (data.length() == 1 && !data.trim().toString().equals("%")) {
                data = '0' + data;
            }
            if (month != null && month.trim().length() != 0) {
                if (month.length() == 1 && !month.trim().toString().equals("%")) {
                    month = '0' + month;
                }
                return period + "|" + month + strmonth + "|" + data + strday;
            }
            return period + "|%" + strmonth + "|" + data + strday;
        }
        if (week != null && !week.trim().equals("")) {
            if (week.length() == 1 && !week.trim().toString().equals("%")) {
                week = '0' + week;
            }
            if (isYearWeek) {
                return period + "|" + week + strweek;
            }
            if (isMonthWeek) {
                if (month.length() == 1 && !month.trim().toString().equals("%")) {
                    month = '0' + month;
                }
                if (month.length() == 0) {
                    month = "%";
                }
                return period + "|" + month + strmonth + "|" + week + strweek;
            }
        }
        if (tenDay != null && !tenDay.trim().equals("")) {
            if (tenDay.length() == 1 && !tenDay.trim().toString().equals("%")) {
                tenDay = '0' + tenDay;
            }
            if (month != null && month.trim().length() != 0) {
                if (month.length() == 1 && !month.trim().toString().equals("%")) {
                    month = '0' + month;
                }
                return period + "|" + month + strmonth + "|" + tenDay + strTenDay;
            }
            return period + "|%" + strmonth + "|" + tenDay + strTenDay;
        }
        if (month != null && !month.trim().equals("")) {
            if (month.length() == 1 && !month.trim().toString().equals("%")) {
                month = '0' + month;
            }
            return period + "|" + month + strmonth;
        }
        if (quarter != null && !quarter.trim().equals("")) {
            if (quarter.length() == 1 && !quarter.trim().toString().equals("%")) {
                quarter = '0' + quarter;
            }
            return period + "|" + quarter + strquarter;
        }
        if (halfYear != null && !halfYear.trim().equals("")) {
            if (halfYear.length() == 1 && !halfYear.trim().toString().equals("%")) {
                halfYear = '0' + halfYear;
            } else if (halfYear.equals("1,2") || halfYear.equals("2,1")) {
                halfYear = "01,02";
            } else if (halfYear.equals("1:2")) {
                halfYear = "01:02";
            }
            return period + "|" + halfYear + strhalfyear;
        }
        return period;
    }

    public BgPeriodInfo getBgPeriodInfo() {
        return this.bgPeriodInfo;
    }

    public void setBgPeriodInfo(BgPeriodInfo bgPeriodInfo) {
        this.bgPeriodInfo = bgPeriodInfo;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public boolean gettroubleselect() {
        return this.troubleselect;
    }

    @Override
    protected void btnEasySelect_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnEasySelect.isSelected()) {
            this.troubleselect = false;
            this.kDPanelEasy.setEnabled(true);
            this.kDPanelEasy.setVisible(true);
            this.kDPanelTrouble.setEnabled(false);
            this.kDPanelTrouble.setVisible(false);
        }
    }

    @Override
    protected void btnTrouble_actionPerformed(ActionEvent e) throws Exception {
        if (this.btnTrouble.isSelected()) {
            this.troubleselect = true;
            this.kDPanelTrouble.setEnabled(true);
            this.kDPanelTrouble.setVisible(true);
            this.kDPanelEasy.setEnabled(false);
            this.kDPanelEasy.setVisible(false);
        }
    }
}

