/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalyseFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.IBgAnalyseFacade;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgExecuteUI;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgExecuteUI
extends AbstractBgExecuteUI {
    private static final long serialVersionUID = -43926238132747982L;
    private static final Logger logger = CoreUIObject.getLogger(BgExecuteUI.class);
    protected IBgScheme ibgScheme = null;
    protected IBgAnalyseFacade analyse = null;
    protected BOSUuid orgUnitId = null;
    protected BOSUuid bgSchemeId = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.initBgScheme();
        this.initBgPeriod();
    }

    protected void init() {
        this.orgUnitId = this.getUIContext().get("orgUnitInfo") != null ? (BOSUuid)this.getUIContext().get("orgUnitInfo") : SysContext.getSysContext().getCurrentCostUnit().getId();
        if (this.getUIContext().get("BGSCHEMEID") != null) {
            this.bgSchemeId = (BOSUuid)this.getUIContext().get("BGSCHEMEID");
        }
    }

    protected IBgScheme getInterface() throws Exception {
        if (this.ibgScheme == null) {
            this.ibgScheme = BgSchemeFactory.getRemoteInstance();
        }
        return this.ibgScheme;
    }

    protected IBgAnalyseFacade getAnalyseInterface() throws Exception {
        if (this.analyse == null) {
            this.analyse = BgAnalyseFacadeFactory.getRemoteInstance();
        }
        return this.analyse;
    }

    protected void initBgScheme() throws Exception {
        BgSchemeCollection bgSchemeCol = null;
        try {
            bgSchemeCol = this.getBgSchemeInfo(this.orgUnitId, null);
            this.comBgScheme.removeAllItems();
            this.comBgScheme.addItems(bgSchemeCol.toArray());
            BgSchemeInfo bgSchemeInfo = new BgSchemeInfo();
            bgSchemeInfo.setId(this.bgSchemeId);
            BgFormHelper.setSelectObject(this.comBgScheme, bgSchemeInfo);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw ex;
        }
    }

    protected BgSchemeCollection getBgSchemeInfo(BOSUuid currCCOrgUnitId, Set subOrgUnits) throws Exception {
        return this.getAnalyseInterface().getCommonBgScheme(currCCOrgUnitId, subOrgUnits, true);
    }

    protected void initBgPeriod() {
        BgPeriodDialog bgPeriodDialog = new BgPeriodDialog((CoreUIObject)this);
        this.prmtBgPeriod.setSelector((KDPromptSelector)bgPeriodDialog);
    }

    @Override
    protected void btnSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verifyData();
        String command = null;
        command = this.rbNoPlan.isSelected() ? "NOPLAN" : (this.rbBeforeHand.isSelected() ? "BEFOREHAND" : "PLAN");
        BgPeriodInfo bgPeriodInfo = (BgPeriodInfo)this.prmtBgPeriod.getData();
        if (this.getInterface().executePlan(this.orgUnitId, this.bgSchemeId, bgPeriodInfo.getId(), command)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"planSucceed"));
        }
    }

    public void verifyData() {
        if (this.prmtBgPeriod.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"selectBgPeriod"));
            SysUtil.abort();
        }
    }
}

