/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgFormActualListUI;
import com.kingdee.eas.ma.budget.client.BgPeriodDialog;
import com.kingdee.eas.ma.budget.client.BgTypeSelectorDialog;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.BgPermissionHelper;
import com.kingdee.eas.ma.nbudget.client.BgIntegrationDataImportUI;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormActualProcessUI;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.ma.view.client.BgReportViewActualInitProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;

public class BgFormActualListUI
extends AbstractBgFormActualListUI {
    private static final long serialVersionUID = -971819174521287212L;

    @Override
    protected String getEditUIName() {
        String editName = null;
        int formType = this.getActiveTempFormType();
        editName = formType == 4 ? BgReportViewActualInitProcessUI.class.getName() : BgNFormActualProcessUI.class.getName();
        return editName;
    }

    protected int getActiveTempFormType() {
        if (this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex()) != null) {
            IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
            BizEnumValueInfo _enum = null;
            if (row.getCell("bgTemplate.FormType") != null) {
                _enum = (BizEnumValueInfo)row.getCell("bgTemplate.FormType").getValue();
            } else if (row.getCell("bgTemplate.formType") != null) {
                _enum = (BizEnumValueInfo)row.getCell("bgTemplate.formType").getValue();
            }
            if (_enum != null) {
                return _enum.getInt();
            }
        }
        return -1;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    @Override
    public String getPermissionNum() {
        return "bg_formActual01_list";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        if (this.isHasFodian()) {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(true);
        }
        BgPeriodDialog dialog = new BgPeriodDialog();
        this.prmtBgPeriodBegin.setSelector((KDPromptSelector)dialog);
        this.prmtBgPeriodEnd.setSelector((KDPromptSelector)dialog);
        this.prmtBgType.setSelector((KDPromptSelector)new BgTypeSelectorDialog());
        String strKey = "CTRL_SHIFT_O";
        KeyStroke ks = KeyStroke.getKeyStroke(79, 192, false);
        this.getActionMap().put(strKey, (Action)((Object)this.actionGather));
        this.getInputMap(2).put(ks, strKey);
        this.btnViewFlow.setVisible(false);
        this.btnViewFlow.setEnabled(false);
        this.itemViewFlow.setEnabled(false);
        this.itemViewFlow.setVisible(false);
        this.setVisible(null, (JMenuItem)this.menuItemIntDataImport, BgNSHelper.isEnableElimIntegrate(null));
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEditActual.setIcon(EASResource.getIcon((String)"imgTbtn_getparms"));
        this.btnGetActual.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.btnGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemEditActual.setIcon(EASResource.getIcon((String)"imgTbtn_getparms"));
        this.menuItemGetActual.setIcon(EASResource.getIcon((String)"imgTbtn_dispose"));
        this.menuItemGather.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        SorterItemCollection sortCol = new SorterItemCollection();
        if (!viewInfo.getSorter().isEmpty()) {
            sortCol.addObjectCollection((IObjectCollection)viewInfo.getSorter());
        }
        filter = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        this.refreshFilter(filter);
        if (BgParamCHelper.isBgPermissionUsed()) {
            String userId = this.getUserInfo().getId().toString();
            filter = BgPermissionHelper.addBgFormPermission((String)userId, (Set)this.getPermissionOrg(), (FilterInfo)filter);
        }
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(2), CompareType.NOTEQUALS));
        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.formType", (Object)new Integer(4), CompareType.NOTEQUALS));
        filter.setMaskString(filter.getMaskString() + " and #" + (filter.getFilterItems().size() - 1));
        viewInfo.setFilter(filter);
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        if (!sortCol.isEmpty()) {
            viewInfo.getSorter().clear();
            viewInfo.getSorter().addObjectCollection((IObjectCollection)sortCol);
        } else if (viewInfo.getSorter().isEmpty()) {
            viewInfo.getSorter().add(new SorterItemInfo("bgScheme.number"));
        }
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    protected FilterInfo getUnSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        return super.getUnSelectedQueryFilterInfo(viewInfo);
    }

    @Override
    protected FilterInfo getImmSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        return super.getImmSelectedQueryFilterInfo(viewInfo);
    }

    @Override
    protected FilterInfo getSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        return super.getSelectedQueryFilterInfo(viewInfo);
    }

    @Override
    public void actionEditActual_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkOrgUnitDisable();
        this.checkIsOnCU(true);
        super.actionEdit_actionPerformed(e);
    }

    @Override
    public void actionGetActual_actionPerformed(ActionEvent e) throws Exception {
        int re;
        this.checkSelected();
        this.checkOrgUnitDisable();
        this.checkIsOnCU(false);
        int rowCount = this.tblMain.getRowCount();
        if (rowCount == 0) {
            MsgBox.showWarning((String)this.getMessageStr("com.kingdee.eas.ma.budget.client.BgFormResource", "actualNoData"));
            SysUtil.abort();
        }
        if ((re = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"actualGroupSubmit"))) == 1 || re == 2) {
            return;
        }
        LongTimeDialog dialog = new LongTimeDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dialog.setLongTimeTask(new ILongTimeTask(){
            List pass = new ArrayList();
            List noPass = new ArrayList();
            List[] selectedBgFormIdList = BgFormActualListUI.access$000(BgFormActualListUI.this);

            public Object exec() throws Exception {
                for (int i = 0; i < this.selectedBgFormIdList[0].size(); ++i) {
                    String id = (String)this.selectedBgFormIdList[0].get(i);
                    String number = (String)this.selectedBgFormIdList[1].get(i);
                    if (id == null) continue;
                    if (BgFormActualListUI.this.getNFacadeInterface().getBatchActualSheet(id)) {
                        this.pass.add(number);
                        continue;
                    }
                    this.noPass.add(number);
                }
                return "";
            }

            public void afterExec(Object result) throws Exception {
                int i;
                int n;
                StringBuffer message = new StringBuffer(512);
                if (this.pass.size() > 0) {
                    message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"codeis"));
                    n = this.pass.size();
                    for (i = 0; i < n; ++i) {
                        message.append(this.pass.get(i) + " ");
                    }
                    message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"actualSubmitPass"));
                    MsgBox.showInfo((String)message.toString());
                }
                this.pass.clear();
                if (this.noPass.size() > 0) {
                    message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"codeis"));
                    n = this.noPass.size();
                    for (i = 0; i < n; ++i) {
                        message.append(this.noPass.get(i) + " ");
                    }
                    message.append(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"actualSubmitNoPass"));
                    MsgBox.showInfo((String)message.toString());
                }
                this.noPass.clear();
            }
        });
        dialog.show();
    }

    private List[] getSelectedBgFormIds() {
        this.checkSelected();
        List[] result = new List[]{new ArrayList(), new ArrayList()};
        KDTRange range = this.tblMain.getSelectManager().toRange();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                IRow row = this.tblMain.getRow(j);
                String id = row.getCell("id").getValue().toString();
                String number = row.getCell("number").getValue().toString();
                result[0].add(id);
                result[1].add(number);
            }
        }
        return result;
    }

    @Override
    public void actionGather_actionPerformed(ActionEvent e) throws Exception {
        this.actionGather();
    }

    @Override
    protected boolean isBudgetData() {
        return false;
    }

    @Override
    protected boolean isGatherType(BizEnumValueInfo enumInfo) {
        return false;
    }

    @Override
    protected void treeOrgUnit_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeOrgUnit_valueChanged(e);
        EntityViewInfo view = null;
        FilterInfo filter = null;
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)this.treeOrgUnit.getLastSelectedPathComponent();
        FullOrgUnitInfo orgUnitInfo = this.getOrgUnitInfo(node);
        if (orgUnitInfo != null) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitInfo.getId().toString(), CompareType.EQUALS));
            if (this.isHasFodian()) {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("period", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString("#0 and #1");
            if (BgSHelper.isBgPermissionUsed()) {
                String userId = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
                Set<String> orgSet = new HashSet<String>();
                if (this.getPermissionOrg() != null) {
                    orgSet = this.getPermissionOrg();
                } else {
                    orgSet.add(orgUnitInfo.getId().toString());
                }
                filter = BgPermissionHelper.addBgSchemePermission((String)userId, orgSet, (FilterInfo)filter);
            }
            view.setFilter(filter);
            this.prmtBgScheme.setEntityViewInfo(view);
        }
    }

    @Override
    protected void prmtBgScheme_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgScheme_dataChanged(e);
        this.refreshTable();
    }

    @Override
    protected void prmtBgType_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgType_dataChanged(e);
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriodBegin_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodBegin_dataChanged(e);
        this.verifyPeriod();
        this.refreshTable();
    }

    @Override
    protected void prmtBgPeriodEnd_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBgPeriodEnd_dataChanged(e);
        this.verifyPeriod();
        this.refreshTable();
    }

    private void verifyPeriod() {
        if (this.prmtBgPeriodBegin.getData() != null && this.prmtBgPeriodBegin.getData() instanceof BgPeriodInfo && this.prmtBgPeriodEnd.getData() != null && this.prmtBgPeriodEnd.getData() instanceof BgPeriodInfo) {
            boolean bln;
            BgPeriodInfo beginPeriod = (BgPeriodInfo)this.prmtBgPeriodBegin.getData();
            BgPeriodInfo endPeriod = (BgPeriodInfo)this.prmtBgPeriodEnd.getData();
            if (!beginPeriod.getPeriodType().equals((Object)endPeriod.getPeriodType())) {
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkBgPeriodType"));
                SysUtil.abort();
            }
            if (!(bln = BgHelper.compareBgPeriodBegin2End(beginPeriod, endPeriod))) {
                this.prmtBgPeriodEnd.requestFocus();
                MsgBox.showWarning((Component)((Object)this), (String)BgNFCHelper.getMessageStr((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"checkBgPeriodOrder"));
                SysUtil.abort();
            }
        }
    }

    private void refreshTable() {
        FilterInfo _filter = new FilterInfo();
        this.refreshFilter(_filter);
        this.mainQuery.setFilter(_filter);
        try {
            this.execQuery();
        }
        catch (Exception ex) {
            this.handUIExceptionAndAbort(ex);
        }
    }

    private void refreshFilter(FilterInfo filter) {
        BgPeriodInfo _bgPeriodInfo;
        if (filter == null) {
            return;
        }
        Object obj = this.prmtBgScheme.getData();
        if (obj != null) {
            if (obj instanceof BgSchemeInfo) {
                BgSchemeInfo _bgSchemeInfo = (BgSchemeInfo)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_bgSchemeInfo.getNumber(), CompareType.EQUALS));
            } else if (obj instanceof String) {
                String _name = (String)obj;
                this.replaceFilterItems(filter, new FilterItemInfo("bgScheme.number", (Object)_name, CompareType.EQUALS));
            }
        }
        this.addBgTypeFilterItem(filter, this.prmtBgType.getValue());
        obj = this.prmtBgPeriodBegin.getData();
        if (obj != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.beginDate", (Object)_bgPeriodInfo.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        if ((obj = this.prmtBgPeriodEnd.getData()) != null && obj instanceof BgPeriodInfo) {
            _bgPeriodInfo = (BgPeriodInfo)obj;
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.endDate", (Object)_bgPeriodInfo.getEndDate(), CompareType.LESS_EQUALS));
        }
        if (this.prmtBgPeriodBegin.getData() != null || this.prmtBgPeriodEnd.getData() != null) {
            int bgPeriodType = 0;
            bgPeriodType = this.prmtBgPeriodBegin.getData() != null ? ((BgPeriodInfo)this.prmtBgPeriodBegin.getData()).getPeriodType().getValue() : ((BgPeriodInfo)this.prmtBgPeriodEnd.getValue()).getPeriodType().getValue();
            this.replaceFilterItems(filter, new FilterItemInfo("bgPeriod.periodType", (Object)new Integer(bgPeriodType), CompareType.EQUALS));
        }
    }

    @Override
    public void actionIntegrationDataImport_actionPerformed(ActionEvent e) throws Exception {
        this.checkOrgUnitDisable();
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgIntegrationDataImportUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        KDTRange range = this.tblMain.getSelectManager().toRange();
        if (range == null || range.size() == 0) {
            return;
        }
        KDTSelectBlock select = (KDTSelectBlock)range.get(0);
        if (select == null) {
            return;
        }
        rowIndex = select.getBeginRow();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("state").getValue();
            int _state = state.getInt();
            if (_state == 1) {
                this.setEditButtAndMenu();
            } else if (_state == 2) {
                this.setApprovedButtAndMenu();
            } else {
                this.setApprovedButtAndMenu();
            }
        } else {
            this.setDisableButtAndMenu();
        }
    }

    protected void setDisableButtAndMenu() {
        this.disableAction((JButton)this.btnEditActual, (JMenuItem)this.menuItemEditActual, (Action)((Object)this.actionEditActual));
        this.disableAction((JButton)this.btnGetActual, (JMenuItem)this.menuItemGetActual, (Action)((Object)this.actionGetActual));
        this.disableAction((JButton)this.btnGather, (JMenuItem)this.menuItemGather, (Action)((Object)this.actionGather));
    }

    protected void setEditButtAndMenu() {
        this.enableAction((JButton)this.btnEditActual, (JMenuItem)this.menuItemEditActual, (Action)((Object)this.actionEditActual));
        this.enableAction((JButton)this.btnGetActual, (JMenuItem)this.menuItemGetActual, (Action)((Object)this.actionGetActual));
        this.enableAction((JButton)this.btnGather, (JMenuItem)this.menuItemGather, (Action)((Object)this.actionGather));
    }

    protected void setApprovedButtAndMenu() {
        this.setDisableButtAndMenu();
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        return super.prepareInit();
    }

    static /* synthetic */ List[] access$000(BgFormActualListUI x0) {
        return x0.getSelectedBgFormIds();
    }
}

