/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.gr.cslrpt.client.SimpleNotePad;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.ma.budget.BgAdjustException;
import com.kingdee.eas.ma.budget.BgExamineFacadeFactory;
import com.kingdee.eas.ma.budget.BgFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormDataSourceEnum;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormHelper;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.IBgExamineFacade;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgFormAdjustListUI;
import com.kingdee.eas.ma.budget.client.AssignSolutionUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgExamineViewUI;
import com.kingdee.eas.ma.budget.client.BgFormAdjustEditUI;
import com.kingdee.eas.ma.budget.client.BgSubOrgUnitSelectUIForForm;
import com.kingdee.eas.ma.budget.client.BgVersionUI;
import com.kingdee.eas.ma.budget.client.LongTimeDialog;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BgFormAdjustListUI
extends AbstractBgFormAdjustListUI {
    private static final long serialVersionUID = -2869864168239287145L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormAdjustListUI.class);
    private IBgForm ibgForm = null;
    private IBgFormFacade iBgFormFacade = null;
    private IBgExamineFacade ibgExamineFacade = null;
    private boolean isGatherFormula = false;
    private boolean isGatherEnumErate = false;
    private boolean isGatherEnumErateItem = false;
    private boolean isGatherEnumErateFodian = false;
    private boolean isGatherCell = false;
    private boolean isGatherAdjust = false;
    protected String bgFormSubmitId = null;
    protected IRow bgFormSelectRow = null;
    protected LongTimeDialog dialog = null;
    private String xNum = null;

    @Override
    protected String getEditUIName() {
        return BgFormAdjustEditUI.class.getName();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.comboxOrgType.setSelectedItem((Object)OrgViewType.COSTCENTER);
        this.comboxOrgType.setEnabled(false);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
        this.setButtonBySelectRow();
        if (BgParamCHelper.isFodian()) {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("executeState").getStyleAttributes().setHided(true);
        }
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnReferWork.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.btnFormAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.btnFormCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.btnFormHistory.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.menuItemReferWork.setIcon(EASResource.getIcon((String)"imgTbtn_submit"));
        this.menuItemFormAdjust.setIcon(EASResource.getIcon((String)"imgTbtn_budgetadjust"));
        this.menuItemFormCollect.setIcon(EASResource.getIcon((String)"imgTbtn_collect"));
        this.menuItemFormHistory.setIcon(EASResource.getIcon((String)"imgTbtn_historyedition"));
        this.menuItemEdit.setMnemonic(69);
    }

    private void setButtonBySelectRow() {
        this.actionView.setEnabled(true);
        this.actionEdit.setEnabled(true);
        this.actionRemove.setEnabled(false);
        this.actionFormAdjust.setEnabled(true);
        this.actionFormHistory.setEnabled(true);
    }

    public void isGatherFormula(boolean isGatherFormula) {
        this.isGatherFormula = isGatherFormula;
    }

    public boolean isGatherFormula() {
        return this.isGatherFormula;
    }

    public void isGatherEnumErate(boolean isGatherEnumErate) {
        this.isGatherEnumErate = isGatherEnumErate;
    }

    public boolean isGatherEnumErate() {
        return this.isGatherEnumErate;
    }

    public void isGatherEnumErateItem(boolean isGatherEnumErateItem) {
        this.isGatherEnumErateItem = isGatherEnumErateItem;
    }

    public boolean isGatherEnumErateItem() {
        return this.isGatherEnumErateItem;
    }

    public void isGatherEnumErateFudian(boolean isGatherEnumErateFodian) {
        this.isGatherEnumErateFodian = isGatherEnumErateFodian;
    }

    public boolean isGatherEnumErateFodian() {
        return this.isGatherEnumErateFodian;
    }

    public void isGatherCell(boolean isGatherCell) {
        this.isGatherCell = isGatherCell;
    }

    public boolean isGatherCell() {
        return this.isGatherCell;
    }

    public boolean isGatherAdjust() {
        return this.isGatherAdjust;
    }

    public void isGatherAdjust(boolean isGatherAdjust) {
        this.isGatherAdjust = isGatherAdjust;
    }

    @Override
    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"orgUnitInfo", (Object)this.getBGOrgUnitInfo());
        uiContext.put((Object)"OrgUnitCU", (Object)this.getBGOrgUnitInfo().getCU());
    }

    @Override
    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor queryExecutor = null;
        FilterInfo filter = null;
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(4));
        state.add(new Integer(25));
        state.add(new Integer(2));
        filter = this.rbImmOrgUnit.isSelected() ? this.getImmSelectedQueryFilterInfo(viewInfo) : (this.rbAllOrgUnit.isSelected() ? this.getSelectedQueryFilterInfo(viewInfo) : this.getUnSelectedQueryFilterInfo(viewInfo));
        FilterItemInfo item = new FilterItemInfo("state".toLowerCase(), state, CompareType.INCLUDE);
        this.replaceFilterItems(filter, item);
        viewInfo.setFilter(filter);
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("orgUnit.name").getStyleAttributes().setHided(true);
        }
        queryExecutor = super.getQueryExecutor(queryPK, viewInfo);
        return queryExecutor;
    }

    @Override
    protected FilterInfo getSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = super.getSelectedQueryFilterInfo(viewInfo);
        FilterItemInfo item = null;
        item = BgParamCHelper.isFodian() ? new FilterItemInfo("bgPeriod.periodType".toLowerCase(), (Object)new Integer(4), CompareType.NOTEQUALS) : new FilterItemInfo("bgPeriod.periodType".toLowerCase(), (Object)new Integer(-1), CompareType.NOTEQUALS);
        this.replaceFilterItems(filter, item);
        return filter;
    }

    @Override
    protected FilterInfo getUnSelectedQueryFilterInfo(EntityViewInfo viewInfo) {
        FilterInfo filter = super.getUnSelectedQueryFilterInfo(viewInfo);
        if (BgParamCHelper.isFodian()) {
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.periodType".toLowerCase(), (Object)new Integer(4), CompareType.NOTEQUALS));
            filter.setMaskString(filter.getMaskString() + " and #" + String.valueOf(filter.getFilterItems().size() - 1));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.periodType".toLowerCase(), (Object)new Integer(-1), CompareType.NOTEQUALS));
            filter.setMaskString(filter.getMaskString() + " and #" + String.valueOf(filter.getFilterItems().size() - 1));
        }
        return filter;
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.setButtonState();
    }

    private void setButtonState() {
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex == -1) {
            this.setButtonBySelectRow();
            return;
        }
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null) {
            BizEnumValueInfo state = (BizEnumValueInfo)row.getCell("state").getValue();
            BizEnumValueInfo dataSource = (BizEnumValueInfo)row.getCell("dataSource").getValue();
            if (state.getInt() == 4) {
                this.actionRemove.setEnabled(true);
                this.actionEdit.setEnabled(true);
                this.actionFormAdjust.setEnabled(true);
                this.actionFormHistory.setEnabled(false);
                this.actionFormCollect.setEnabled(true);
            } else if (state.getInt() == 2) {
                this.actionRemove.setEnabled(false);
                this.actionEdit.setEnabled(true);
                this.actionFormAdjust.setEnabled(true);
                this.actionFormHistory.setEnabled(true);
                this.actionFormCollect.setEnabled(false);
            } else if (state.getInt() == 25) {
                if (dataSource.getInt() == 2) {
                    this.actionEdit.setEnabled(true);
                    this.actionFormAdjust.setEnabled(true);
                } else {
                    this.actionEdit.setEnabled(false);
                    this.actionFormAdjust.setEnabled(false);
                }
                this.actionRemove.setEnabled(false);
                this.actionFormHistory.setEnabled(false);
                this.actionFormCollect.setEnabled(false);
            }
        }
    }

    public String getMessage(String messageStr) {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)messageStr);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.openReportView(e, this.getSelectedKeyValue(), null);
    }

    @Override
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsOnCU(true);
        this.processAdjustOfBudgetForm(e);
    }

    @Override
    public void actionFormAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsOnCU(true);
        this.processAdjustOfBudgetForm(e);
    }

    protected void processAdjustOfBudgetForm(ActionEvent e) throws Exception {
        String id = this.getSelectedKeyValue();
        try {
            BOSUuid bid = BOSUuid.read((String)id);
            IObjectPK pk = this.getFacadeInterface().checkFormIsAdjust(bid);
            if (pk == null) {
                IBgForm ibgForm = BgFormFactory.getRemoteInstance();
                pk = ibgForm.cloneAdjust(bid, BgFormDataSourceEnum.ADJUST, BgFormStateEnum.Adjusted);
                this.openReport(e, OprtState.EDIT, pk.toString(), null);
            } else {
                if (BgFormHelper.checkInProInst(pk.toString())) {
                    throw new BgAdjustException(BgAdjustException.SUBMITINWORK);
                }
                this.openReport(e, OprtState.EDIT, pk.toString(), null);
            }
        }
        catch (EASBizException ex) {
            this.refresh(e);
            throw ex;
        }
        BgFormHelper.refreshBgFormList((CoreUI)this);
    }

    @Override
    public void actionFormHistory_actionPerformed(ActionEvent e) throws Exception {
        String adjustId;
        String bgFormId;
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row != null && row.getCell("adjust.id").getValue() != null && (bgFormId = BgVersionUI.showDialogWindow((Component)((Object)this), adjustId = row.getCell("adjust.id").getValue().toString(), null)) != null) {
            this.openReportView(e, bgFormId, "adjustHistory");
        }
    }

    private void openReportView(ActionEvent e, String bgFormId, String type) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        if (bgFormId == null) {
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        } else {
            uiContext.put((Object)"ID", (Object)bgFormId);
        }
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReportState", (Object)OprtState.VIEW);
        if (type != null) {
            uiContext.put((Object)"bgFormType", (Object)type);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.hide();
    }

    private void openReport(ActionEvent e, String reportState, String id, String type) throws UIException {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        if (id == null) {
            uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        } else {
            uiContext.put((Object)"ID", (Object)id);
        }
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReportState", (Object)reportState);
        if (type != null) {
            uiContext.put((Object)"bgFormType", (Object)type);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.hide();
    }

    @Override
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        this.checkSelected();
        this.checkIsOnCU(true);
        int rowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        if (rowIndex >= 0 && (row = this.tblMain.getRow(rowIndex)) != null) {
            String id = this.getSelectedKeyValue();
            String number = row.getCell("number").getValue().toString();
            if (BgFormHelper.checkInProInst(id)) {
                throw new BgAdjustException(BgAdjustException.REMOVEERROROFREFERWORKING);
            }
            int re = MsgBox.showConfirm3((Component)((Object)this), (String)(this.getMessage("isRemove") + this.getMessage("number") + number + this.getMessage("budgetAdjustForm") + this.getMessage("interrogation")));
            if (re == 1 || re == 2) {
                return;
            }
            BgClientHelper.applyMutexService((Component)((Object)this), this.getSelectedKeyValue(), SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(id));
            BgFormHelper.refreshBgFormList((CoreUI)this);
        }
    }

    @Override
    public void actionFormCollect_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkIsOnCU(true);
        this.collectForm(e, this.getSelectedKeyValue());
    }

    public void collectForm(ActionEvent e, String bgFormId) throws Exception {
        if (bgFormId == null || bgFormId.trim().length() == 0) {
            return;
        }
        BOSUuid id = BOSUuid.read((String)bgFormId);
        if (BgFormHelper.checkInProInst(bgFormId)) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWorkNoCollect"));
            SysUtil.abort();
        }
        FullOrgUnitInfo org = null;
        FullOrgUnitInfo tmpOrg = null;
        if (this.rbImmOrgUnit.isSelected() || this.rbAllOrgUnit.isSelected()) {
            int activeRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
            IRow row = this.tblMain.getRow(activeRowIndex);
            org = new FullOrgUnitInfo();
            org.setId(BOSUuid.read((String)row.getCell("orgUnit.id").getValue().toString()));
        } else {
            org = this.getBGOrgUnitInfo();
        }
        INewOrgViewFacade iNew = NewOrgViewFacadeFactory.getRemoteInstance();
        OrgUnitCollection orgUnitCol = iNew.getChildren(org.getId().toString(), OrgViewType.COSTCENTER);
        if (orgUnitCol != null && !orgUnitCol.isEmpty()) {
            int i;
            FullOrgUnitCollection orgRangesColl = BgNFSHelper.getOrgPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()));
            HashMap<String, String> orgRangesMap = new HashMap<String, String>();
            for (i = 0; i < orgRangesColl.size(); ++i) {
                orgRangesMap.put(orgRangesColl.get(i).getId().toString(), orgRangesColl.get(i).getId().toString());
            }
            for (i = orgUnitCol.size() - 1; i >= 0; --i) {
                String tmpid = orgUnitCol.get(i).getId().toString();
                if (orgRangesMap.containsKey(tmpid)) continue;
                orgUnitCol.removeObject(i);
            }
        }
        if (orgUnitCol == null || orgUnitCol.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgSchemeResource", (String)"NoSubOrgNotCollect"));
            return;
        }
        UIContext uiContextOrg = new UIContext((Object)this);
        uiContextOrg.put((Object)"EditOrg", (Object)orgUnitCol);
        uiContextOrg.put((Object)"CUID", (Object)org.getId().toString());
        uiContextOrg.put((Object)"ID", (Object)bgFormId);
        uiContextOrg.put((Object)"selfPanelUiName", (Object)BgSubOrgUnitSelectUIForForm.class.getName());
        uiContextOrg.put((Object)"OwnerUI", (Object)this);
        IUIWindow orgSelectorUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AssignSolutionUI.class.getName(), (Map)uiContextOrg, null, null);
        orgSelectorUI.show();
        HashMap returnData = (HashMap)((AssignSolutionUI)orgSelectorUI.getUIObject()).getReturnData();
        if (returnData == null || returnData.get("returnValue") == null || ((ArrayList)returnData.get("returnValue")).size() == 0) {
            return;
        }
        ArrayList<FullOrgUnitInfo> subOrgs = (ArrayList<FullOrgUnitInfo>)returnData.get("returnValue");
        HashMap<BOSUuid, Object> orgUnitMap = new HashMap<BOSUuid, Object>();
        int n = subOrgs.size();
        for (int i = 0; i < n; ++i) {
            tmpOrg = (FullOrgUnitInfo)subOrgs.get(i);
            orgUnitMap.put(tmpOrg.getId(), null);
        }
        Hashtable map = new Hashtable();
        map.putAll(BgFacadeFactory.getRemoteInstance().filterFormCollectInfo(id, orgUnitMap, true));
        if (!map.isEmpty()) {
            ArrayList<FullOrgUnitInfo> newOrgs = new ArrayList<FullOrgUnitInfo>();
            int n2 = subOrgs.size();
            for (int i = 0; i < n2; ++i) {
                tmpOrg = (FullOrgUnitInfo)subOrgs.get(i);
                if (!map.containsKey(tmpOrg.getId().toString())) continue;
                newOrgs.add(tmpOrg);
            }
            subOrgs.clear();
            subOrgs = newOrgs;
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"cantCollect"));
            SysUtil.abort();
        }
        this.openCollectReport(e, bgFormId, map, subOrgs);
        if (this.isDoRefresh(this.uiWindow)) {
            this.refresh(null);
        }
    }

    public void openCollectReport(ActionEvent e, String bgFormId, Map mapInfo, List orgUnitCol) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        this.prepareUIContext(uiContext, e);
        uiContext.put((Object)"ID", (Object)bgFormId);
        uiContext.put((Object)"OpenReport", (Object)Boolean.TRUE);
        uiContext.put((Object)"isBizActual", (Object)Boolean.FALSE);
        uiContext.put((Object)"OpenReportState", (Object)OprtState.EDIT);
        uiContext.put((Object)"bgFormType", null);
        uiContext.put((Object)"IS_COLLECT", (Object)Boolean.TRUE);
        uiContext.put((Object)"COLLECT_SCHEME", (Object)mapInfo);
        uiContext.put((Object)"COLLECT_ORGUNIT", (Object)orgUnitCol);
        uiContext.put((Object)"GATHER_CELL", (Object)new Boolean(this.isGatherCell()));
        uiContext.put((Object)"GATHER_ENUMERATE", (Object)new Boolean(this.isGatherEnumErate()));
        uiContext.put((Object)"GATHER_TMPDATA", (Object)new Boolean(this.isGatherAdjust()));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.hide();
    }

    protected IBgForm getInterface() throws Exception {
        if (this.ibgForm == null) {
            this.ibgForm = BgFormFactory.getRemoteInstance();
        }
        return this.ibgForm;
    }

    @Override
    protected IBgFormFacade getFacadeInterface() throws Exception {
        if (this.iBgFormFacade == null) {
            this.iBgFormFacade = BgFormFacadeFactory.getRemoteInstance();
        }
        return this.iBgFormFacade;
    }

    @Override
    protected IBgExamineFacade getBgExamineInterface() throws Exception {
        if (this.ibgExamineFacade == null) {
            this.ibgExamineFacade = BgExamineFacadeFactory.getRemoteInstance();
        }
        return this.ibgExamineFacade;
    }

    @Override
    public void actionReferWork_actionPerformed(ActionEvent e) throws Exception {
        int re;
        this.checkSelected();
        this.checkIsOnCU(true);
        if (BgFormHelper.checkInProInst(this.getSelectedKeyValue())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"bgFormInWorkNoSubmit"));
            SysUtil.abort();
        }
        if ((re = MsgBox.showConfirm3((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"submitFormWork"))) == 1 || re == 2) {
            return;
        }
        this.bgFormSubmitId = this.getSelectedKeyValue();
        this.bgFormSelectRow = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (this.bgFormSubmitId != null && this.bgFormSubmitId.trim().length() > 0) {
            if (BgParamCHelper.isCompulsionReportCheck()) {
                boolean isExit = false;
                List check = this.getInterface().reportCheck(new BOSUuid[]{BOSUuid.read((String)this.bgFormSubmitId)});
                if (check.get(0).equals(Boolean.FALSE)) {
                    isExit = true;
                    UIContext uiCtx = new UIContext((Object)this);
                    uiCtx.put((Object)"Title", (Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"ReportCheckError"));
                    uiCtx.put((Object)"ShowOpen", (Object)Boolean.FALSE);
                    SimpleNotePad.showMessageByModel((UIContext)uiCtx, (String)check.get(3).toString());
                }
                if (isExit) {
                    SysUtil.abort();
                }
            }
            if (this.getBgExamineInterface().canExamine(new BOSUuid[]{BOSUuid.read((String)this.bgFormSubmitId)})) {
                this.xNum = BgNFCHelper.returnExamineX((BOSUuid[])new BOSUuid[]{BOSUuid.read((String)this.bgFormSubmitId)}, (Object)((Object)this));
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                this.dialog = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : null);
                if (this.dialog != null) {
                    this.dialog.setLongTimeTask(new ILongTimeTask(){

                        public Object exec() throws Exception {
                            Object[] result = BgFormAdjustListUI.this.getBgExamineInterface().examines(new BOSUuid[]{BOSUuid.read((String)BgFormAdjustListUI.this.bgFormSubmitId)}, BgFormAdjustListUI.this.xNum);
                            HashMap<String, Object> bgExamineCheckMap = new HashMap<String, Object>();
                            bgExamineCheckMap.put("BgExamineChecked", result[0]);
                            bgExamineCheckMap.put("BgExamineCheckResult", result[1]);
                            return bgExamineCheckMap;
                        }

                        public void afterExec(Object result) throws Exception {
                            if (result != null && result instanceof HashMap) {
                                BgFormAdjustListUI.this.openBgExamineViewUI(result);
                                Map bgExamineCheckMap = (Map)result;
                                Boolean bgExCheck = (Boolean)bgExamineCheckMap.get("BgExamineChecked");
                                if (bgExCheck.booleanValue()) {
                                    if (BgFormAdjustListUI.this.getFacadeInterface().submitAdjustWork(BOSUuid.read((String)BgFormAdjustListUI.this.bgFormSubmitId))) {
                                        MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                                    } else {
                                        MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                                    }
                                    BgFormAdjustListUI.this.tblMain.refresh();
                                } else {
                                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"cantsubmit"));
                                }
                            } else {
                                MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgExamineCheckResource", (String)"error"));
                            }
                        }
                    });
                    this.dialog.show();
                }
            } else if (this.getFacadeInterface().submitAdjustWork(BOSUuid.read((String)this.bgFormSubmitId))) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"pass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
                this.tblMain.refresh();
            } else {
                MsgBox.showError((String)(EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"budgetAdjustForm") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"submitToWork") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"nopass") + EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormAdjustResource", (String)"exclaim")));
            }
        }
    }

    protected void openBgExamineViewUI(Object obj) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"EXAMINE_DATA", obj);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(BgExamineViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

