/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgAuditIdeaEnum;
import com.kingdee.eas.ma.budget.BgAuditIdeaFactory;
import com.kingdee.eas.ma.budget.BgAuditIdeaInfo;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormFacadeFactory;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgFormFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgFormAuditIdeaEditUI;
import com.kingdee.eas.ma.nbudget.BgNFSHelper;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFCHelper;
import com.kingdee.eas.ma.nbudget.client.BgNFormAuditProcessUI;
import com.kingdee.eas.ma.view.client.BgReportViewProcessUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class BgFormAuditIdeaEditUI
extends AbstractBgFormAuditIdeaEditUI {
    private static final long serialVersionUID = 1256787137985729524L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormAuditIdeaEditUI.class);
    private Component component;
    private boolean auditType = true;
    private boolean isCancel = true;

    protected IObjectValue createNewData() {
        return new BgAuditIdeaInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BgAuditIdeaFactory.getRemoteInstance();
    }

    protected IBgForm getFormInterface() throws Exception {
        return BgFormFactory.getRemoteInstance();
    }

    protected IBgFormFacade getFacadeInterface() throws Exception {
        return BgFormFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.toolBar.setVisible(false);
        this.toolBar.setEnabled(false);
        this.prmtCreator.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
        this.pkCreateTime.setValue((Object)new Timestamp(System.currentTimeMillis()));
        this.kDBizMultiLangArea.setSelectedLanguage(new LanguageInfo(this.getCurrentLocale()));
        Object obj = this.getUIContext().get("BGFORM_PROCESSUI");
        if (obj != null && obj instanceof Component) {
            this.component = (Component)obj;
        }
        if ((obj = this.getUIContext().get("BGFORM_AUDIT_TYPE")) != null) {
            if ("BGFORM_AUDIT".equals(obj.toString())) {
                this.auditType = true;
            } else if ("BGFORM_ANTIAUDIT".equals(obj.toString())) {
                this.auditType = false;
            }
        }
        BgFormInfo bgFormInfo = null;
        if (this.component instanceof BgNFormAuditProcessUI) {
            bgFormInfo = (BgFormInfo)((BgNFormAuditProcessUI)this.component).getEditData();
        } else if (this.component instanceof BgReportViewProcessUI) {
            bgFormInfo = ((BgReportViewProcessUI)this.component).getEditData();
        }
        String msg = null;
        msg = bgFormInfo != null && (bgFormInfo.getState().getValue() == 35 || bgFormInfo.getState().getValue() == 4) ? BgNFCHelper.getMessageStr((String)"adjustAudit") : BgNFCHelper.getMessageStr((String)"formAudit");
        this.setUITitle(msg);
    }

    @Override
    public void actionSubmitIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmitIdea_actionPerformed(e);
        if (this.auditType) {
            this.submitAuditIdea();
            if (this.kDRadioButtonNoPass.isSelected()) {
                MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("passNotPass"));
            } else {
                MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("pass"));
            }
        } else {
            this.unSubmitAuditIdea();
            MsgBox.showInfo((Component)((Object)this), (String)this.getMessageStr("noPass"));
        }
        this.setCancel(false);
        this.getUIWindow().close();
    }

    @Override
    public void actionCancelIdea_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancelIdea_actionPerformed(e);
        this.setCancel(true);
        this.getUIWindow().close();
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData() == null || this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString().trim().length() == 0) {
            this.kDBizMultiLangArea.requestFocus(true);
            this.showWarning("inputIdea");
        }
    }

    private String getMessageStr(String key) {
        return EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgAuditIdeaResource", (String)key);
    }

    private void showWarning(String key) {
        if (StringUtils.isEmpty((String)key)) {
            return;
        }
        MsgBox.showWarning((Component)((Object)this), (String)this.getMessageStr(key));
        SysUtil.abort();
    }

    private boolean submitAuditIdea() throws Exception {
        boolean re = false;
        if (this.component == null) {
            return re;
        }
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        BgFormInfo bgFormInfo = null;
        if (this.component instanceof BgNFormAuditProcessUI) {
            bgFormInfo = (BgFormInfo)((BgNFormAuditProcessUI)this.component).getEditData();
        } else if (this.component instanceof BgReportViewProcessUI) {
            bgFormInfo = ((BgReportViewProcessUI)this.component).getEditData();
        }
        try {
            if (bgFormInfo != null && BgNFSHelper.checkInProInst((String)bgFormInfo.getId().toString())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"bgFormInWorkNoAudit"));
                SysUtil.abort();
            }
            String message = this.kDBizMultiLangArea.getItemBy(new LanguageInfo(this.getCurrentLocale())).getData().toString();
            if (BgNFSHelper.checkHasAdjust((IObjectValue)bgFormInfo)) {
                if (this.kDRadioButtonPass.isSelected()) {
                    if (bgFormInfo != null && this.getFacadeInterface().auditFormAdjust(bgFormInfo.getId())) {
                        this.getFacadeInterface().submitAuditIdea(bgFormInfo.getAdjust().getId(), userInfo.getId(), BgAuditIdeaEnum.ADJUSTPASS, message);
                        bgFormInfo.setState(BgFormStateEnum.History);
                    }
                } else if (this.kDRadioButtonNoPass.isSelected() && bgFormInfo != null && bgFormInfo.getAdjust() != null && userInfo != null) {
                    this.getFacadeInterface().unAuditForm(bgFormInfo.getAdjust().getId(), BgAuditIdeaEnum.ADJUSTNOPASS, userInfo.getId(), message);
                }
            } else if (bgFormInfo != null && (bgFormInfo.getState().getValue() == 1 || bgFormInfo.getState().getValue() == 41 || bgFormInfo.getState().getValue() == 102)) {
                if (this.kDRadioButtonPass.isSelected()) {
                    if (!this.getFacadeInterface().checkIsSubmit(bgFormInfo.getId())) {
                        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.client.BgFormResource", (String)"isSubmit"));
                        SysUtil.abort();
                    }
                    if (BgNSHelper.isStartBasisApproved()) {
                        if (BgNSHelper.isStepByStepReport()) {
                            this.getFacadeInterface().auditFormGatherCourse(bgFormInfo.getId(), userInfo.getId(), message, bgFormInfo.getOrgUnit().getId().toString());
                        } else if (bgFormInfo.getBgType() != null && BOSUuid.read((String)"BV/FQwEUEADgABtLwKgSXv9s2OA=").equals((Object)bgFormInfo.getBgType().getId())) {
                            this.getFacadeInterface().auditForm(bgFormInfo.getId(), userInfo.getId(), message);
                        } else if (bgFormInfo.getBgTemplate().getId().equals((Object)bgFormInfo.getBgTemplate().getRootId())) {
                            this.getFacadeInterface().auditForm(bgFormInfo.getId(), userInfo.getId(), message);
                        } else if (bgFormInfo.getBgScheme().getRootId().equals((Object)bgFormInfo.getBgScheme().getId())) {
                            this.getFacadeInterface().auditForm(bgFormInfo.getId(), userInfo.getId(), message);
                        } else {
                            this.getFacadeInterface().auditFormBasisApproved(bgFormInfo.getId(), userInfo.getId(), message);
                        }
                    } else {
                        this.getFacadeInterface().auditForm(bgFormInfo.getId(), userInfo.getId(), message);
                    }
                } else if (this.kDRadioButtonNoPass.isSelected()) {
                    this.getFacadeInterface().unAuditForm(bgFormInfo.getId(), BgAuditIdeaEnum.AUDITNOPASS, userInfo.getId(), message);
                }
                BgFormInfo bgFormNewInfo = this.getFormInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId()), this.getSelectors());
                bgFormInfo.setState(bgFormNewInfo.getState());
                bgFormInfo.setLastUpdateTime(bgFormNewInfo.getLastUpdateTime());
            }
        }
        catch (BOSException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BgFormException(BgFormException.SAVEERROR);
        }
        return re;
    }

    private boolean unSubmitAuditIdea() throws Exception {
        boolean re = true;
        return re;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        return sic;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public void setCancel(boolean isCancel) {
        this.isCancel = isCancel;
    }
}

