/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.rpc.RpcProxy;
import com.kingdee.bos.workflow.monitor.IWfUtil;
import com.kingdee.bos.workflow.monitor.WfUtil;
import com.kingdee.bos.workflow.monitor.client.WfUtils;
import com.kingdee.eas.base.multiapprove.IMultiApprove;
import com.kingdee.eas.base.multiapprove.IMultiApproveHst;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveHstCollection;
import com.kingdee.eas.base.multiapprove.MultiApproveHstFactory;
import com.kingdee.eas.base.multiapprove.MultiApproveHstInfo;
import com.kingdee.eas.base.multiapprove.MultiApproveInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.ma.budget.BgAuditIdeaCollection;
import com.kingdee.eas.ma.budget.BgAuditIdeaEnum;
import com.kingdee.eas.ma.budget.BgAuditIdeaFactory;
import com.kingdee.eas.ma.budget.BgAuditIdeaInfo;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.IBgAuditIdea;
import com.kingdee.eas.ma.budget.client.AbstractBgFormAuditIdeaListUI;
import com.kingdee.eas.ma.nbudget.BgNSHelper;
import com.kingdee.util.STConverter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgFormAuditIdeaListUI
extends AbstractBgFormAuditIdeaListUI {
    private static final long serialVersionUID = 2352869054324724415L;
    private static final Logger logger = CoreUIObject.getLogger(BgFormAuditIdeaListUI.class);
    private String bgFormId = null;

    protected IBgAuditIdea getInterface() throws Exception {
        return BgAuditIdeaFactory.getRemoteInstance();
    }

    protected IMultiApprove getWorkInterface() throws Exception {
        return MultiApproveFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.menuTool.setVisible(false);
        this.getAuditIdeaInfo();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            this.tblMain.setEditable(false);
        }
    }

    protected void getAuditIdeaInfo() throws Exception {
        if (this.getUIContext().get("BGFORM_ID") != null) {
            this.bgFormId = (String)this.getUIContext().get("BGFORM_ID");
            SelectorItemCollection formSic = new SelectorItemCollection();
            formSic.add("id");
            formSic.add("adjust.id");
            formSic.add("state");
            BgFormInfo bgFormInfo = BgFormFactory.getRemoteInstance().getBgFormInfo((IObjectPK)new ObjectStringPK(this.bgFormId), formSic);
            if (bgFormInfo.getAdjust() != null && bgFormInfo.getAdjust().getId() != null) {
                this.bgFormId = bgFormInfo.getAdjust().getId().toString();
            }
            IRow row = null;
            Locale sLocale = new Locale("l2");
            Locale tLocale = new Locale("l3");
            this.tblMain.checkParsed();
            this.tblMain.getStyleAttributes().setWrapText(true);
            this.tblMain.setDefaultRowHeight(this.tblMain.getDefaultRowHeight() * 2);
            SorterItemInfo sort = new SorterItemInfo("createtime");
            sort.setSortType(SortType.DESCEND);
            ArrayList<Object[]> auditIdea = new ArrayList<Object[]>();
            Object[] idea = null;
            if (BgNSHelper.isGetWorkFlowInfo()) {
                IWfUtil util = (IWfUtil)RpcProxy.wrapNoSupport(IWfUtil.class, (String)WfUtil.class.getName());
                String[] hstids = util.getApproveHstAssignIds(this.bgFormId);
                FilterInfo hstfilinfo = WfUtils.generateMultiApproveFilter((String)this.bgFormId, (String[])hstids);
                EntityViewInfo hstviewInfo = new EntityViewInfo();
                hstviewInfo.setFilter(hstfilinfo);
                IMultiApproveHst imhst = MultiApproveHstFactory.getRemoteInstance();
                SelectorItemCollection hstsic = new SelectorItemCollection();
                hstsic.add("id");
                hstsic.add("isPass");
                hstsic.add("opinion");
                hstsic.add("createTime");
                hstsic.add("creator.name");
                hstviewInfo.getSelector().addObjectCollection((IObjectCollection)hstsic);
                hstviewInfo.getSorter().add(sort);
                MultiApproveHstCollection mhstcll = imhst.getMultiApproveHstCollection(hstviewInfo);
                MultiApproveHstInfo mhstinfo2 = null;
                if (mhstcll != null && !mhstcll.isEmpty()) {
                    for (MultiApproveHstInfo mhstinfo2 : mhstcll) {
                        if (mhstinfo2.getOpinion(tLocale) == null && mhstinfo2.getOpinion(sLocale) != null) {
                            mhstinfo2.setOpinion(STConverter.sc2tc((String)mhstinfo2.getOpinion(sLocale)), tLocale);
                        }
                        idea = new Object[]{mhstinfo2.getCreator().getName(), mhstinfo2.getIsPass().getAlias(), mhstinfo2.getOpinion(), mhstinfo2.getCreateTime()};
                        auditIdea.add(idea);
                    }
                }
                String[] ids = util.getApproveAssignIds(this.bgFormId);
                FilterInfo filterinfo = WfUtils.generateMultiApproveFilter((String)this.bgFormId, (String[])ids);
                EntityViewInfo imaentityviewinfo = new EntityViewInfo();
                imaentityviewinfo.setFilter(filterinfo);
                IMultiApprove ima = MultiApproveFactory.getRemoteInstance();
                SelectorItemCollection imasic = new SelectorItemCollection();
                imasic.add("id");
                imasic.add("isPass");
                imasic.add("opinion");
                imasic.add("createTime");
                imasic.add("creator.name");
                imaentityviewinfo.getSelector().addObjectCollection((IObjectCollection)imasic);
                imaentityviewinfo.getSorter().add(sort);
                MultiApproveCollection mcll = ima.getMultiApproveCollection(imaentityviewinfo);
                MultiApproveInfo mainfo2 = null;
                if (mcll != null && !mcll.isEmpty()) {
                    for (MultiApproveInfo mainfo2 : mcll) {
                        if (mainfo2.getOpinion(tLocale) == null && mainfo2.getOpinion(sLocale) != null) {
                            mainfo2.setOpinion(STConverter.sc2tc((String)mainfo2.getOpinion(sLocale)), tLocale);
                        }
                        idea = new Object[]{mainfo2.getCreator().getName(), mainfo2.getIsPass().getAlias(), mainfo2.getOpinion(), mainfo2.getCreateTime()};
                        auditIdea.add(idea);
                    }
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgForm.id", (Object)this.bgFormId, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("state");
            sic.add("idea");
            sic.add("createTime");
            sic.add("creator.name");
            SelectorItemCollection work = new SelectorItemCollection();
            work.add("id");
            work.add("isPass");
            work.add("handlerOpinion");
            work.add("createTime");
            work.add("creator.name");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.getSorter().add(sort);
            BgAuditIdeaInfo ideaInfo = null;
            BgAuditIdeaCollection ideaCol = null;
            try {
                ideaCol = this.getInterface().getBgAuditIdeaCollection(view);
                if (ideaCol != null && !ideaCol.isEmpty()) {
                    Iterator iter = ideaCol.iterator();
                    while (iter.hasNext()) {
                        ideaInfo = (BgAuditIdeaInfo)iter.next();
                        if (ideaInfo.getIdea(tLocale) == null && ideaInfo.getIdea(sLocale) != null) {
                            ideaInfo.setIdea(STConverter.sc2tc((String)ideaInfo.getIdea(sLocale)), tLocale);
                        }
                        idea = new Object[]{ideaInfo.getCreator().getName(), BgAuditIdeaEnum.getEnum(ideaInfo.getState().getValue()).getAlias(), ideaInfo.getIdea(), ideaInfo.getCreateTime()};
                        auditIdea.add(idea);
                    }
                }
                filter.getFilterItems().clear();
                filter.getFilterItems().add(new FilterItemInfo("billId", (Object)this.bgFormId, CompareType.EQUALS));
                view.getSelector().clear();
                view.getSelector().addObjectCollection((IObjectCollection)work);
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
            finally {
                if (ideaCol != null) {
                    ideaCol.clear();
                }
            }
            if (!auditIdea.isEmpty()) {
                Collections.sort(auditIdea, new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        int res = 0;
                        if (arg0 != arg1 && arg0 instanceof Object[] && arg1 instanceof Object[]) {
                            Object[] l = (Object[])arg0;
                            Object[] r = (Object[])arg1;
                            if (l.length > 3 && r.length > 3 && l[3] instanceof Timestamp && r[3] instanceof Timestamp) {
                                res = ((Timestamp)r[3]).compareTo((Timestamp)l[3]);
                            }
                        }
                        return res;
                    }
                });
                for (int i = 0; i < auditIdea.size(); ++i) {
                    idea = (Object[])auditIdea.get(i);
                    row = this.tblMain.addRow();
                    for (int j = 0; j < 4; ++j) {
                        row.getCell(j).setValue(idea[j]);
                    }
                }
            }
        }
    }
}

