/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgDecomposerFacadeFactory;
import com.kingdee.eas.ma.budget.BgDecomposerFormFactory;
import com.kingdee.eas.ma.budget.BgDecomposerFormInfo;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormDiversityData;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgOperationEnum;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.IBgDecomposerForm;
import com.kingdee.eas.ma.budget.IRefBgDecForm;
import com.kingdee.eas.ma.budget.RefBgDecFormFactory;
import com.kingdee.eas.ma.budget.RefBgDecFormInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgFormDecProcessUI;
import com.kingdee.eas.ma.budget.client.BgAdjustViewUI;
import com.kingdee.eas.ma.budget.client.BgDecomposerFormEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgFormDecProcessUI
extends AbstractBgFormDecProcessUI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormDecProcessUI.class);
    private BgFormInfo bgFormInfo = null;
    private BgDecomposerFormEditUI decForm;
    private RefBgDecFormInfo refBgDecForm;
    private boolean isProcess = false;
    private boolean isCantEdit = false;
    private Map deleteMap = null;
    private Map addNewMap = null;
    private Map openMap = null;
    private Map endMap = null;
    private Map editValueMap = null;
    private Map checkMap = null;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void loadDiversityInfo() throws Exception {
    }

    @Override
    protected void initSystemOfOther() {
        super.initSystemOfOther();
        this.addNewMap = new HashMap();
        this.deleteMap = new HashMap();
        this.openMap = new HashMap();
        this.endMap = new HashMap();
        this.checkMap = new HashMap();
        this.editValueMap = this.getUIContext().get("EDIT_VALUE") != null && this.getUIContext().get("EDIT_VALUE") instanceof Map ? (Map)this.getUIContext().get("EDIT_VALUE") : new HashMap();
        if (this.getUIContext().get("OPEN_FORMULA") != null) {
            this.menuTools.setVisible(false);
            this.btnAddBgItem.setEnabled(false);
            this.btnAddBgItem.setVisible(false);
            this.btnAddBgElement.setEnabled(false);
            this.btnAddBgElement.setVisible(false);
            this.btnAddBgPeriod.setEnabled(false);
            this.btnAddBgPeriod.setVisible(false);
            this.btnAddCurrency.setEnabled(false);
            this.btnAddCurrency.setVisible(false);
            this.btnBgFormulaAddNew.setEnabled(false);
            this.btnBgFormulaAddNew.setVisible(false);
            this.btnBgFormulaRemove.setEnabled(false);
            this.btnBgFormulaRemove.setVisible(false);
            this.actionAddBgItem.setEnabled(false);
            this.actionAddBgElement.setEnabled(false);
            this.actionAddBgPeriod.setEnabled(false);
            this.actionAddCurrency.setEnabled(false);
        }
    }

    @Override
    protected void loadBudgetFormInfo() {
        super.loadBudgetFormInfo();
        if (!this.isProcess && this.editDataUI != null) {
            this.editData = (BgFormInfo)this.editDataUI.getEditDataObject();
            this.bgFormInfo = (BgFormInfo)this.editData;
            try {
                boolean isDecUI = (Boolean)this.getUIContext().get("isDecBgFormUI");
                if (isDecUI) {
                    this.decForm = (BgDecomposerFormEditUI)((Object)this.getUIContext().get("Owner"));
                    BgDecomposerFormInfo decBgInfo = this.decForm.editData;
                    if (this.bgFormInfo.getId().equals((Object)decBgInfo.getBgForm().getId())) {
                        this.adjustMap = BgHelper.buildHashMapByByte(decBgInfo.getAdjustMapData());
                        if (decBgInfo.getKdtData() == null || decBgInfo.getKdtData().length == 0) {
                            this.isCantEdit = true;
                        }
                    } else {
                        this.refBgDecForm = decBgInfo.getRefBgDecFormInfo(this.bgFormInfo.getId().toString());
                        this.adjustMap = BgHelper.buildHashMapByByte(this.refBgDecForm.getAdjustMapData());
                        if (this.refBgDecForm.getKdtData() == null || this.refBgDecForm.getKdtData().length == 0) {
                            this.isCantEdit = true;
                        }
                    }
                } else {
                    IBgDecomposerForm iBgDec = BgDecomposerFormFactory.getRemoteInstance();
                    CoreBaseCollection infoDec = iBgDec.getCollection("select adjustMapData where bgForm.id='" + this.bgFormInfo.getId().toString() + "' and orgUnit.id='" + this.bgFormInfo.getOrgUnit().getId().toString() + "' order by createTime desc");
                    if (infoDec != null && infoDec.size() > 0) {
                        BgDecomposerFormInfo info = (BgDecomposerFormInfo)infoDec.get(0);
                        this.adjustMap = BgHelper.buildHashMapByByte(info.getAdjustMapData());
                    } else {
                        IRefBgDecForm iRef = RefBgDecFormFactory.getRemoteInstance();
                        infoDec = iRef.getCollection("select adjustMapData where bgForm.id='" + this.bgFormInfo.getId().toString() + "' and  bgDecomposer.state <> " + 101 + " order by bgDecomposer.createTime desc");
                        if (infoDec != null && infoDec.size() > 0) {
                            RefBgDecFormInfo info = (RefBgDecFormInfo)infoDec.get(0);
                            this.adjustMap = BgHelper.buildHashMapByByte(info.getAdjustMapData());
                        } else {
                            this.adjustMap = new HashMap();
                        }
                    }
                }
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
            this.isProcess = true;
        }
    }

    @Override
    protected void storeDiversityInfo() throws Exception {
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewDiffInfo.setIcon(EASResource.getIcon((String)"imgTbtn_view"));
        this.btnViewDiffInfo.setIsControlByParent(false);
        this.btnViewDiffInfo.setTextIconDisStyle((short)3);
    }

    @Override
    public void actionFileSave_actionPerformed(ActionEvent e) throws Exception {
        this.checkMap.clear();
        super.actionFileSave_actionPerformed(e);
        if (!OprtState.VIEW.equals(this.getOprtState()) && this.decForm != null) {
            String formulaString2 = null;
            BgFormDiversityData divData = null;
            for (String formulaString2 : this.endMap.keySet()) {
                if (this.openMap.containsKey(formulaString2)) continue;
                divData = (BgFormDiversityData)this.endMap.get(formulaString2);
                this.addNewMap.put(formulaString2, null);
                if (divData == null) {
                    divData = new BgFormDiversityData();
                    divData.setFormula(formulaString2);
                    divData.setNewValue(BgConstants.BIGZERO);
                }
                this.adjustMap.put(formulaString2, divData);
            }
            for (String formulaString2 : this.openMap.keySet()) {
                if (this.endMap.containsKey(formulaString2)) continue;
                this.deleteMap.put(formulaString2, null);
                this.adjustMap.remove(formulaString2);
            }
            this.decForm.removeBgFormulaOfForm(this.bgFormInfo.getId(), this.deleteMap);
            this.getModifyingManager().setModifiedCount(0);
            this.getProgressManager().popMessage(EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
            if (!this.deleteMap.isEmpty() || !this.addNewMap.isEmpty()) {
                BgDecomposerFormInfo bgDecFormInfo = this.decForm.editData;
                if (this.bgFormInfo.getId().equals((Object)bgDecFormInfo.getBgForm().getId())) {
                    this.decForm.loadAllTableStyle();
                }
                if (!this.addNewMap.isEmpty()) {
                    for (String formulaString2 : this.addNewMap.keySet()) {
                        this.openMap.put(formulaString2, null);
                    }
                }
                if (!this.deleteMap.isEmpty()) {
                    for (String formulaString2 : this.deleteMap.keySet()) {
                        this.openMap.remove(formulaString2);
                    }
                }
                this.deleteMap.clear();
                this.addNewMap.clear();
            }
            this.endMap.clear();
        }
    }

    @Override
    protected void beforeFileSave() throws Exception {
        super.beforeFileSave();
        BgDecomposerFacadeFactory.getRemoteInstance().checkFormulaIsEctype(this.bgFormInfo.getId(), this.checkMap);
    }

    @Override
    protected void checkAllFormula(String formulaString, int rowIndex, int colIndex) {
        this.checkMap.put(formulaString, TableToolkit.xy2range((int)colIndex, (int)rowIndex));
    }

    @Override
    protected void afterFileSave() throws Exception {
    }

    @Override
    protected void processCellOfTable(ICell cell) {
        super.processCellOfTable(cell);
        if (cell == null) {
            return;
        }
        cell.getStyleAttributes().setBackground(BgSHelper.BASE_COLOR);
        if (this.checkHasFormulaOfCell(cell)) {
            String formulaString = this.getFormulaOfCell(cell);
            if (this.adjustMap.get(formulaString) != null) {
                cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
                cell.setValue((Object)((BgFormDiversityData)this.adjustMap.get(formulaString)).getNewValue());
                this.getModifyingManager().setModifiedCount(0);
            }
            if (this.isCantEdit) {
                this.setFormulaOfCellCantEdit(cell, false);
            } else if (BgFSHelper.checkCanUpdateOfCell(cell)) {
                cell.getStyleAttributes().setBackground(BgSHelper.EDIT_COLOR);
            }
            this.openMap.put(formulaString, null);
            if (this.editValueMap.containsKey(formulaString)) {
                cell.setValue(this.editValueMap.get(formulaString));
            }
            if (this.formulaStr != null && this.formulaStr.equals(formulaString)) {
                this.xyPosition = TableToolkit.xy2range((int)cell.getColumnIndex(), (int)cell.getRowIndex());
                this.backColor = cell.getStyleAttributes().getBackground();
                cell.getStyleAttributes().setBackground(Color.RED);
            }
        }
    }

    @Override
    public void searchBgFormulaOfForm(ICell cell, String formulaString) {
        super.searchBgFormulaOfForm(cell, formulaString);
        if (cell.getValue() != null && cell.getValue().toString().length() > 0) {
            BgFormDiversityData divData = new BgFormDiversityData();
            divData.setFormula(formulaString);
            try {
                divData.setNewValue(new BigDecimal(cell.getValue().toString()));
            }
            catch (Exception ex) {
                divData.setNewValue(BgConstants.BIGZERO);
            }
            this.endMap.put(formulaString, divData);
        } else {
            this.endMap.put(formulaString, null);
        }
    }

    @Override
    protected boolean checkBeforeWindowClosing() {
        boolean re = super.checkBeforeWindowClosing();
        if (re) {
            this.deleteMap.clear();
            this.addNewMap.clear();
            this.openMap.clear();
            this.endMap.clear();
            this.checkMap.clear();
        }
        return re;
    }

    @Override
    public void actionViewDiffInfo_actionPerformed(ActionEvent e) throws Exception {
        String formulaString = null;
        HashMap formulas = new HashMap();
        KDTable mainTable = this.pnlTables.getCurrentPage();
        KDTRange range = mainTable.getSelectManager().toRange();
        for (int i = 0; i < range.size(); ++i) {
            KDTSelectBlock block = (KDTSelectBlock)range.get(i);
            for (int j = block.getBeginRow(); j <= block.getEndRow(); ++j) {
                for (int k = block.getBeginCol(); k <= block.getEndCol(); ++k) {
                    RptCell rptCell;
                    ICell cell = mainTable.getCell(j, k);
                    if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null) continue;
                    formulas.put(formulaString, null);
                }
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        HashMap map = new HashMap();
        for (String formula : formulas.keySet()) {
            if (!this.adjustMap.containsKey(formula)) continue;
            map.put(formula, this.adjustMap.get(formula));
        }
        uiContext.put((Object)"bgFormAdjust", map);
        uiContext.put((Object)"bgRecordType", (Object)BgOperationEnum.COLLECT);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BgAdjustViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }
}

