/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgFormExamineResultFactory;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.IBgFormExamineResult;
import com.kingdee.eas.ma.budget.client.AbstractBgFormExamineResultUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BgFormExamineResultUI
extends AbstractBgFormExamineResultUI {
    private static final long serialVersionUID = -7089200459287034604L;
    public static final String BG_FORM_IDS = "BG_FORM_IDS";
    public static final String BG_EXAMINE_IDS = "BG_EXAMINE_IDS";
    protected List bgFormIds = null;
    protected List bgExamineIds = null;
    protected Map result = null;
    boolean isShowOrg = false;
    private IFullOrgUnit iFullOrgUnit = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initParam();
        this.queryResult();
        this.buildKDTable();
        this.toolBar.setVisible(true);
        this.menuBar.setVisible(false);
    }

    protected void initParam() {
        Map uiContext = this.getUIContext();
        this.bgFormIds = uiContext.get(BG_FORM_IDS) != null ? (List)uiContext.get(BG_FORM_IDS) : null;
        this.bgExamineIds = uiContext.get(BG_EXAMINE_IDS) != null ? (List)uiContext.get(BG_EXAMINE_IDS) : null;
        this.isShowOrg = uiContext.get("isShowOrg") != null ? (Boolean)uiContext.get("isShowOrg") : false;
    }

    protected void queryResult() throws BOSException, EASBizException {
        IBgFormExamineResult iExamie = BgFormExamineResultFactory.getRemoteInstance();
        this.result = iExamie.queryExamineResult(this.bgFormIds, this.bgExamineIds);
    }

    protected void buildKDTable() throws EASBizException, BOSException {
        this.tblMain.getScriptManager().setAutoRun(false);
        this.tblMain.setRefresh(true);
        this.tblMain.checkParsed(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.setDefaultRowHeight(this.tblMain.getDefaultRowHeight() * 2);
        IColumn orgCol = this.tblMain.addColumn();
        IColumn formCol = this.tblMain.addColumn();
        IColumn eXNumberCol = this.tblMain.addColumn();
        IColumn eXNameCol = this.tblMain.addColumn();
        IColumn eXTypeCol = this.tblMain.addColumn();
        IColumn eXExpressionCol = this.tblMain.addColumn();
        IColumn eXConditionCol = this.tblMain.addColumn();
        IColumn eXValueCol = this.tblMain.addColumn();
        IColumn eXResultCol = this.tblMain.addColumn();
        IColumn eXNoteCol = this.tblMain.addColumn();
        this.tblMain.addHeadRow();
        orgCol.setWidth(150);
        formCol.setWidth(250);
        eXNumberCol.setWidth(100);
        eXNameCol.setWidth(100);
        eXTypeCol.setWidth(110);
        eXExpressionCol.setWidth(300);
        eXConditionCol.setWidth(400);
        eXValueCol.setWidth(100);
        eXResultCol.setWidth(100);
        eXNoteCol.setWidth(300);
        orgCol.getStyleAttributes().setWrapText(true);
        formCol.getStyleAttributes().setWrapText(true);
        eXNumberCol.getStyleAttributes().setWrapText(true);
        eXNameCol.getStyleAttributes().setWrapText(true);
        eXTypeCol.getStyleAttributes().setWrapText(true);
        eXExpressionCol.getStyleAttributes().setWrapText(true);
        eXConditionCol.getStyleAttributes().setWrapText(true);
        eXValueCol.getStyleAttributes().setWrapText(true);
        eXResultCol.getStyleAttributes().setWrapText(true);
        eXNoteCol.getStyleAttributes().setWrapText(true);
        IRow titleRow = this.tblMain.addRow();
        IRow timeRow = this.tblMain.addRow();
        IRow operatorRow = this.tblMain.addRow();
        this.tblMain.getMergeManager().mergeBlock(0, 0, 0, 9);
        this.tblMain.getMergeManager().mergeBlock(1, 0, 1, 9);
        this.tblMain.getMergeManager().mergeBlock(2, 0, 2, 9);
        titleRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"241_BgFormExamineResultUI"));
        timeRow.getCell(0).setValue((Object)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"242_BgFormExamineResultUI") + BgNationalFormatUIUtil.getNationalDateTimeFormat().format(new Date())));
        operatorRow.getCell(0).setValue((Object)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"243_BgFormExamineResultUI") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        if (this.result == null || this.result.isEmpty()) {
            IRow successRow = this.tblMain.addRow();
            successRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"244_BgFormExamineResultUI"));
            this.tblMain.getMergeManager().mergeBlock(3, 0, 3, 9);
            successRow.getStyleAttributes().setBold(true);
            return;
        }
        IRow captionRow = this.tblMain.addRow();
        captionRow.getStyleAttributes().setBold(true);
        captionRow.getCell(orgCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"245_BgFormExamineResultUI"));
        captionRow.getCell(formCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"246_BgFormExamineResultUI"));
        captionRow.getCell(eXNumberCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"247_BgFormExamineResultUI"));
        captionRow.getCell(eXNameCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"248_BgFormExamineResultUI"));
        captionRow.getCell(eXTypeCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"249_BgFormExamineResultUI"));
        captionRow.getCell(eXExpressionCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"250_BgFormExamineResultUI"));
        captionRow.getCell(eXConditionCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"251_BgFormExamineResultUI"));
        captionRow.getCell(eXValueCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"252_BgFormExamineResultUI"));
        captionRow.getCell(eXResultCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"253_BgFormExamineResultUI"));
        captionRow.getCell(eXNoteCol.getColumnIndex()).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"254_BgFormExamineResultUI"));
        Map bgFormMap = null;
        Map examineMap = null;
        Map valueMap = null;
        String orgKey2 = null;
        String bgFormKey2 = null;
        String examineKey2 = null;
        for (String orgKey2 : this.result.keySet()) {
            bgFormMap = (Map)this.result.get(orgKey2);
            for (String bgFormKey2 : bgFormMap.keySet()) {
                examineMap = (Map)bgFormMap.get(bgFormKey2);
                for (String examineKey2 : examineMap.keySet()) {
                    valueMap = (Map)examineMap.get(examineKey2);
                    String orgUnitName = (String)valueMap.get("EXAMINE_CITATION_ORGUNIT_NAME");
                    String bgFormName = (String)valueMap.get("EXAMINE_CITATION_FORM_NAME");
                    String eXNumber = (String)valueMap.get("EXAMINE_NUMBER");
                    String eXName = (String)valueMap.get("EXAMINE_NAME");
                    String eXType = (String)valueMap.get("EXAMINE_TYPE");
                    String eXExpression = (String)valueMap.get("EXAMINE_EXPLAIN");
                    String eXCondition = (String)valueMap.get("EXAMINE_FORMULA_ALIAS");
                    String eXValue = (String)valueMap.get("EXAMINE_FORMULA");
                    String eXResult = (String)valueMap.get("EXAMINE_RESULT");
                    String eXNote = (String)valueMap.get("EXAMINE_CITATION_POSTIAL");
                    IRow currRow = this.insertRow(orgUnitName, bgFormName, eXName, eXExpression, orgKey2);
                    currRow.getCell(orgCol.getColumnIndex()).setValue((Object)orgUnitName);
                    currRow.getCell(formCol.getColumnIndex()).setValue((Object)bgFormName);
                    currRow.getCell(eXNumberCol.getColumnIndex()).setValue((Object)eXNumber);
                    currRow.getCell(eXNameCol.getColumnIndex()).setValue((Object)eXName);
                    currRow.getCell(eXTypeCol.getColumnIndex()).setValue((Object)eXType);
                    currRow.getCell(eXExpressionCol.getColumnIndex()).setValue((Object)eXExpression);
                    currRow.getCell(eXConditionCol.getColumnIndex()).setValue((Object)eXCondition);
                    currRow.getCell(eXValueCol.getColumnIndex()).setValue((Object)eXValue);
                    currRow.getCell(eXResultCol.getColumnIndex()).setValue((Object)eXResult);
                    currRow.getCell(eXNoteCol.getColumnIndex()).setValue((Object)eXNote);
                    currRow.setUserObject((Object)(orgUnitName + bgFormName + eXNumber));
                    currRow.getCell(0).setUserObject((Object)orgKey2.split("\\|")[0]);
                    KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)currRow.getRowIndex());
                }
            }
        }
        if (!this.isShowOrg) {
            orgCol.getStyleAttributes().setHided(true);
            this.tblMain.getMergeManager().mergeBlock(0, 1, 0, 9);
            this.tblMain.getMergeManager().mergeBlock(1, 1, 1, 9);
            this.tblMain.getMergeManager().mergeBlock(2, 1, 2, 9);
            titleRow.getCell(1).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"241_BgFormExamineResultUI"));
            timeRow.getCell(1).setValue((Object)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"242_BgFormExamineResultUI") + new SimpleDateFormat(BgNationalFormatUIUtil.getNationalDateTimeFormatString()).format(new Date())));
            operatorRow.getCell(1).setValue((Object)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"243_BgFormExamineResultUI") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        } else {
            this.tblMain.getMergeManager().mergeBlock(0, 0, 0, 9);
            this.tblMain.getMergeManager().mergeBlock(1, 0, 1, 9);
            this.tblMain.getMergeManager().mergeBlock(2, 0, 2, 9);
            titleRow.getCell(0).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"241_BgFormExamineResultUI"));
            timeRow.getCell(0).setValue((Object)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"242_BgFormExamineResultUI") + new SimpleDateFormat(BgNationalFormatUIUtil.getNationalDateTimeFormatString()).format(new Date())));
            operatorRow.getCell(0).setValue((Object)(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"243_BgFormExamineResultUI") + SysContext.getSysContext().getCurrentUserInfo().getName()));
        }
        this.merge(0, 3, 0);
        this.merge(1, 3, 0);
    }

    private void merge(int colIndex, int top, int width) {
        int maxIndex = this.tblMain.getRowCount();
        int bottom = top;
        String lastValue = null;
        String currValue = null;
        for (int i = top; i < maxIndex; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (lastValue == null) {
                currValue = lastValue = row.getCell(colIndex).getValue().toString();
                continue;
            }
            currValue = row.getCell(colIndex).getValue().toString();
            bottom = row.getRowIndex();
            if (!currValue.equals(lastValue)) {
                this.merge(colIndex, row.getRowIndex(), width);
                break;
            }
            for (int j = 0; j <= width; ++j) {
                this.tblMain.getMergeManager().mergeBlock(top, colIndex + j, bottom, colIndex + j);
            }
        }
    }

    private void mergeExamineRows() {
        String lastRowValue = "########";
        int lastRowIndex = 4;
        int currRowIndex = 4;
        for (int i = 4; i < this.tblMain.getRowCount(); ++i) {
            IRow currRow = this.tblMain.getRow(i);
            currRowIndex = currRow.getRowIndex();
            Object rowObj = currRow.getUserObject();
            if (rowObj == null) continue;
            String rowString = rowObj.toString();
            if (i == 4) {
                lastRowValue = rowString;
            }
            if ((rowString.equals(lastRowValue) || currRowIndex == 4) && currRowIndex != this.tblMain.getRowCount() - 1) continue;
            this.tblMain.getMergeManager().mergeBlock(lastRowIndex, 2, currRowIndex != this.tblMain.getRowCount() - 1 ? currRowIndex - 1 : currRowIndex, 2);
            this.tblMain.getMergeManager().mergeBlock(lastRowIndex, 3, currRowIndex != this.tblMain.getRowCount() - 1 ? currRowIndex - 1 : currRowIndex, 3);
            this.tblMain.getMergeManager().mergeBlock(lastRowIndex, 4, currRowIndex != this.tblMain.getRowCount() - 1 ? currRowIndex - 1 : currRowIndex, 4);
            this.tblMain.getMergeManager().mergeBlock(lastRowIndex, 5, currRowIndex != this.tblMain.getRowCount() - 1 ? currRowIndex - 1 : currRowIndex, 5);
            lastRowValue = rowString;
            lastRowIndex = currRowIndex;
        }
    }

    private IRow insertRow(String orgName, String bgFormName, String eXName, String eXExpression, String orgKey) throws EASBizException, BOSException {
        int j;
        int _currOrgUnitNumber;
        int _orgUnitNumber;
        FullOrgUnitInfo currOrgUnit;
        FullOrgUnitInfo orgUnit;
        String currOrgNumber;
        int index;
        boolean flag = false;
        int size = this.tblMain.getRowCount();
        for (index = 0; index < size; ++index) {
            if (!orgName.equals(this.tblMain.getCell(index, 0).getValue().toString()) || !bgFormName.equals(this.tblMain.getCell(index, 1).getValue().toString()) || !eXExpression.equals(this.tblMain.getCell(index, 5).getValue().toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            return this.tblMain.addRow(index);
        }
        size = this.tblMain.getRowCount();
        for (index = 0; index < size; ++index) {
            if (!orgName.equals(this.tblMain.getCell(index, 0).getValue().toString()) || !bgFormName.equals(this.tblMain.getCell(index, 1).getValue().toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            return this.tblMain.addRow(index);
        }
        size = this.tblMain.getRowCount();
        for (index = 0; index < size; ++index) {
            if (!orgName.equals(this.tblMain.getCell(index, 0).getValue().toString())) continue;
            flag = true;
            break;
        }
        if (flag) {
            String orgUnitNumber = this.tblMain.getCell(index, 0).getUserObject().toString().split("\\|")[0];
            currOrgNumber = orgKey.split("\\|")[0];
            orgUnit = this.getOrgInterface().getFullOrgUnitInfo(" select level where number ='" + orgUnitNumber + "'");
            currOrgUnit = this.getOrgInterface().getFullOrgUnitInfo(" select level where number ='" + currOrgNumber + "'");
            _orgUnitNumber = orgUnit.getLevel();
            _currOrgUnitNumber = currOrgUnit.getLevel();
            if (_currOrgUnitNumber < _orgUnitNumber && index > 0) {
                return this.tblMain.addRow(index - 1);
            }
            for (j = index + 1; j < this.tblMain.getRowCount(); ++j) {
                if (currOrgNumber.equals(this.tblMain.getCell(j, 0).getUserObject().toString())) continue;
                return this.tblMain.addRow(j);
            }
        }
        if (this.tblMain.getRowCount() > 4) {
            String orgUnitNumber = this.tblMain.getCell(4, 0).getUserObject().toString().split("\\|")[0];
            currOrgNumber = orgKey.split("\\|")[0];
            orgUnit = this.getOrgInterface().getFullOrgUnitInfo(" select level where number ='" + orgUnitNumber + "'");
            currOrgUnit = this.getOrgInterface().getFullOrgUnitInfo(" select level where number ='" + currOrgNumber + "'");
            _orgUnitNumber = orgUnit.getLevel();
            _currOrgUnitNumber = currOrgUnit.getLevel();
            if (_currOrgUnitNumber <= _orgUnitNumber) {
                return this.tblMain.addRow(4);
            }
            for (j = 4; j < this.tblMain.getRowCount(); ++j) {
                String _rowNumber = this.tblMain.getCell(j, 0).getUserObject().toString().split("\\|")[0];
                FullOrgUnitInfo rowOrg = this.getOrgInterface().getFullOrgUnitInfo(" select level where number ='" + _rowNumber + "'");
                int _rowOrg = rowOrg.getLevel();
                if (_currOrgUnitNumber >= _rowOrg) continue;
                return this.tblMain.addRow(j);
            }
        }
        return this.tblMain.addRow();
    }

    private IFullOrgUnit getOrgInterface() throws BOSException {
        if (this.iFullOrgUnit == null) {
            this.iFullOrgUnit = FullOrgUnitFactory.getRemoteInstance();
        }
        return FullOrgUnitFactory.getRemoteInstance();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnPrint.setVisible(true);
        this.btnPrintPreview.setVisible(true);
        this.btnExport.setVisible(true);
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.btnExport.setEnabled(true);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
        this.tblMain.getIOManager().exportExcelToTempFile(false);
    }
}

