/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgItemCollection;
import com.kingdee.eas.ma.budget.BgItemFactory;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.ma.budget.BgQueryFormFilterParam;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSHelper;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.FilterParam;
import com.kingdee.eas.ma.budget.IBgItem;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.VisualItemInfo;
import com.kingdee.eas.ma.budget.client.AbstractBgFormQueryFilter2UI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ItemEvent;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgFormQueryFilter2UI
extends AbstractBgFormQueryFilter2UI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormQueryFilter2UI.class);
    private BgQueryFormFilterParam balFilterParam;
    private String orgUnitId = SysContext.getSysContext().getCurrentOrgUnit().getId().toString();

    public BgFormQueryFilter2UI() throws Exception {
    }

    public BgFormQueryFilter2UI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
        this.contBgRptType.setVisible(true);
        this.chkIsSum.setVisible(false);
        this.prmtBeginPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
    }

    @Override
    public void init() throws Exception {
        BgClientHelper.setSelectObject(this.comboBgRptType, (Object)BgAnalysisTypeEnum.BGQUERY);
        this.comboBgRptType.setEnabled(false);
    }

    @Override
    protected void initScheme() {
        String orgUnitId = this.currentCompany.getId().toString();
        IBgScheme iBgScheme = null;
        try {
            iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (iBgScheme != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
            if (BgParamCHelper.isFodian()) {
                items.add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                items.add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString(" #0 and #1");
            view.setFilter(filter);
            BgSchemeCollection col = null;
            try {
                col = iBgScheme.getBgSchemeCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            BgHelper.sortCollection(col, new String[]{"number"});
            if (col != null && col.size() > 0) {
                this.comboBgScheme.removeAllItems();
                this.comboBgScheme.addItems(col.toArray());
                this.comboBgScheme.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.balFilterParam == null) {
            this.balFilterParam = new BgQueryFormFilterParam();
        }
        return this.balFilterParam;
    }

    @Override
    public Object getParam() {
        String stritem;
        BgQueryFormFilterParam param = (BgQueryFormFilterParam)super.getParam();
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        param.objItemFrom = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemFrom(stritem);
        } else {
            param.setItemFrom(null);
        }
        vi = (VisualItemInfo)this.prmtItemTo.getValue();
        param.objItemTo = vi;
        if (vi != null) {
            stritem = (String)vi.get("number");
            if (stritem != null) {
                stritem = stritem.replace(',', '_');
            }
            param.setItemTo(stritem);
        } else {
            param.setItemTo(null);
        }
        BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
        param.objElement = beinfo;
        if (beinfo != null) {
            String stritem2 = beinfo.getId().toString();
            param.setElement(stritem2);
        } else {
            param.setElement(null);
        }
        if (this.prmtCurrency.getValue() != null) {
            param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
        } else {
            try {
                param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
            }
            catch (Exception e) {
                param.setCurrency(null);
            }
        }
        param.setBgRptType(BgAnalysisTypeEnum.BGQUERY);
        return param;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void prmtOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtOrgUnit_dataChanged(e);
        this.prmtBeginPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
    }

    @Override
    protected void prmtBeginPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBeginPeriod_dataChanged(e);
        this.prmtBeginPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
    }

    @Override
    protected void comboBgScheme_itemStateChanged(ItemEvent e) throws Exception {
        super.comboBgScheme_itemStateChanged(e);
        this.prmtBeginPeriod.setEnabled(true);
        this.prmtEndPeriod.setEnabled(true);
    }

    @Override
    public boolean verify() {
        boolean bln = super.verify();
        VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
        VisualItemInfo vi1 = (VisualItemInfo)this.prmtItemTo.getValue();
        if (vi == null && vi1 != null) {
            vi = vi1;
        } else if (vi1 == null && vi != null) {
            vi1 = vi;
        }
        if (vi != null && vi1 != null) {
            if (vi == null) {
                vi1 = vi;
            } else if (vi1 == null) {
                vi1 = vi;
            }
            String numberVi = vi.getNumber();
            String[] numArrayVi = numberVi.split(",");
            String numberVi1 = vi1.getNumber();
            String[] numArrayVi1 = numberVi1.split(",");
            try {
                int size;
                IBgItem iBgItem = BgItemFactory.getRemoteInstance();
                BgItemCollection itemColVi = iBgItem.getBgItemCollection("where number in ('" + numberVi.replaceAll(",", "','") + "') and orgUnit.id = '" + BgSHelper.getIsolateOrg(this.orgUnitId) + "' ");
                BgItemCollection itemColVi1 = iBgItem.getBgItemCollection("where number in ('" + numberVi1.replaceAll(",", "','") + "') and orgUnit.id = '" + BgSHelper.getIsolateOrg(this.orgUnitId) + "' ");
                BgItemInfo itemVi = null;
                BgItemInfo itemVi1 = null;
                HashMap<BOSUuid, BgItemInfo> mapVi = new HashMap<BOSUuid, BgItemInfo>();
                HashMap<BOSUuid, BgItemInfo> mapVi1 = new HashMap<BOSUuid, BgItemInfo>();
                int sizeVi1 = itemColVi1.size();
                int sizeVi = itemColVi.size();
                int n = size = sizeVi > sizeVi1 ? sizeVi : sizeVi1;
                for (int i = 0; i < size; ++i) {
                    if (i < sizeVi) {
                        itemVi = itemColVi.get(i);
                    }
                    if (i < sizeVi1) {
                        itemVi1 = itemColVi1.get(i);
                    }
                    if (itemVi != null && itemVi.getBgItemGroup() != null) {
                        mapVi.put(itemVi.getBgItemGroup().getId(), itemVi);
                    }
                    if (itemVi1 == null || itemVi1.getBgItemGroup() == null) continue;
                    mapVi1.put(itemVi1.getBgItemGroup().getId(), itemVi1);
                }
                Set keySetVi = mapVi.keySet();
                Set keySetVi1 = mapVi1.keySet();
                Iterator iterato = keySetVi.iterator();
                while (iterato.hasNext()) {
                    if (mapVi1.containsKey(iterato.next())) continue;
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"260_BgFormQueryFilter2UI"));
                    SysUtil.abort();
                }
                Iterator iterator = keySetVi1.iterator();
                while (iterator.hasNext()) {
                    if (!mapVi.containsKey(iterator.next())) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"260_BgFormQueryFilter2UI"));
                        SysUtil.abort();
                    }
                    this.prmtItemFrom.setValue((Object)vi);
                    this.prmtItemTo.setValue((Object)vi1);
                }
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
        }
        return bln;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getFilterObject(CustomerParams cp, String key) {
        if (cp == null) {
            return null;
        }
        FilterParam param = null;
        String objStr = null;
        objStr = key == null || key.length() == 0 ? cp.getCustomerParam("FilterParam") : cp.getCustomerParam(key);
        byte[] objByte = Base64.decode((String)objStr);
        InputStream is = null;
        ObjectInputStream bais = null;
        try {
            is = ZipUtil.unpack((byte[])objByte);
            bais = new ObjectInputStream(is);
            param = (FilterParam)bais.readObject();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return param;
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        BgRptFilterParam pa = (BgRptFilterParam)this.getFilterObject(cp);
        BgQueryFormFilterParam param = null;
        if (this.rptType.equals((Object)BgAnalysisTypeEnum.BGQUERY)) {
            String stritem;
            param = (BgQueryFormFilterParam)pa;
            VisualItemInfo vi = (VisualItemInfo)this.prmtItemFrom.getValue();
            if (vi != null && vi.toString() == null) {
                vi = null;
            }
            param.objItemFrom = vi;
            if (vi != null) {
                stritem = (String)vi.get("number");
                if (stritem != null) {
                    stritem = stritem.replace(',', '_');
                }
                param.setItemFrom(stritem);
            } else {
                param.setItemFrom(null);
            }
            vi = (VisualItemInfo)this.prmtItemTo.getValue();
            if (vi != null && vi.toString() == null) {
                vi = null;
            }
            param.objItemTo = vi;
            if (vi != null) {
                stritem = (String)vi.get("number");
                if (stritem != null) {
                    stritem = stritem.replace(',', '_');
                }
                param.setItemTo(stritem);
            } else {
                param.setItemTo(null);
            }
            BgElementInfo beinfo = (BgElementInfo)this.prmtElement.getValue();
            param.objElement = beinfo;
            if (beinfo != null) {
                String stritem2 = beinfo.getId().toString();
                param.setElement(stritem2);
            } else {
                param.setElement(null);
            }
            if (this.prmtCurrency.getValue() != null) {
                param.setCurrency((CurrencyInfo)this.prmtCurrency.getValue());
            } else {
                try {
                    param.setCurrency(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()));
                }
                catch (Exception e) {
                    param.setCurrency(null);
                }
            }
            param.setBgRptType(BgAnalysisTypeEnum.BGQUERY);
        }
        this.setFilterObject(cp, param);
        return cp;
    }

    @Override
    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        BgQueryFormFilterParam filterParam = (BgQueryFormFilterParam)this.getFilterObject(cp);
        if (filterParam == null) {
            return;
        }
        this.prmtItemFrom.setData(filterParam.objItemFrom);
        this.prmtItemTo.setData(filterParam.objItemTo);
        this.prmtElement.setData(filterParam.objElement);
        this.prmtCurrency.setData((Object)filterParam.getCurrency());
    }
}

