/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgFormException;
import com.kingdee.eas.ma.budget.BgFormQueryFilterParam;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgPeriodCollection;
import com.kingdee.eas.ma.budget.BgPeriodHelper;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.BgSchemeCollection;
import com.kingdee.eas.ma.budget.BgSchemeFactory;
import com.kingdee.eas.ma.budget.IBgScheme;
import com.kingdee.eas.ma.budget.client.AbstractBgFormQueryFilterUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.nbudget.client.BgParamCHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import org.apache.log4j.Logger;

public class BgFormQueryFilterUI
extends AbstractBgFormQueryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(BgFormQueryFilterUI.class);
    private static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgFormResource";
    private BgFormQueryFilterParam queryFilterParam;

    public BgFormQueryFilterUI() throws Exception {
    }

    public BgFormQueryFilterUI(BgAnalysisTypeEnum analyType) throws Exception {
        this.rptType = analyType;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.init();
    }

    private void init() throws Exception {
        this.comboBgPeriod.setEnabled(false);
        BgClientHelper.setSelectObject(this.comboBgRptType, (Object)BgAnalysisTypeEnum.BGFORMQUERY);
        this.comboBgRptType.setEnabled(false);
    }

    @Override
    protected void initScheme() {
        String orgUnitId = this.currentCompany.getId().toString();
        IBgScheme iBgScheme = null;
        try {
            iBgScheme = BgSchemeFactory.getRemoteInstance();
        }
        catch (BOSException e) {
            logger.error((Object)"budget error:", (Throwable)e);
        }
        if (iBgScheme != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            FilterItemCollection items = filter.getFilterItems();
            items.add(new FilterItemInfo("orgUnit", (Object)orgUnitId, CompareType.EQUALS));
            if (BgParamCHelper.isFodian()) {
                items.add(new FilterItemInfo("period ", (Object)new Integer(4), CompareType.NOTEQUALS));
            } else {
                items.add(new FilterItemInfo("period ", (Object)new Integer(-1), CompareType.NOTEQUALS));
            }
            filter.setMaskString(" #0 and #1");
            view.setFilter(filter);
            BgSchemeCollection col = null;
            try {
                col = iBgScheme.getBgSchemeCollection(view);
            }
            catch (BOSException e) {
                logger.error((Object)"budget error:", (Throwable)e);
            }
            BgHelper.sortCollection(col, new String[]{"number"});
            if (col != null && col.size() > 0) {
                this.comboBgScheme.removeAllItems();
                this.comboBgScheme.addItems(col.toArray());
                this.comboBgScheme.setSelectedIndex(0);
            }
        }
    }

    @Override
    protected BgRptFilterParam getRptFilterParam() {
        if (this.queryFilterParam == null) {
            this.queryFilterParam = new BgFormQueryFilterParam();
        }
        return this.queryFilterParam;
    }

    @Override
    public Object getParam() {
        BgFormQueryFilterParam param = (BgFormQueryFilterParam)super.getParam();
        param.setBgRptType(BgAnalysisTypeEnum.BGFORMQUERY);
        try {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        catch (BgFormException e) {
            logger.error((Object)"budget error:", (Throwable)((Object)e));
            return param;
        }
    }

    @Override
    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        BgFormQueryFilterParam param = (BgFormQueryFilterParam)this.getFilterObject(cp);
        param.setBgRptType(BgAnalysisTypeEnum.BGFORMQUERY);
        BgPeriodCollection bgPeriodCol = null;
        try {
            bgPeriodCol = BgPeriodHelper.getPeriodColInfo(param.getBgPeriodType(), param.getBeginPeriod().getBeginDate(), param.getEndPeriod().getEndDate());
        }
        catch (EASBizException e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"261_BgFormQueryFilterUI"));
        }
        catch (BOSException e) {
            MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"261_BgFormQueryFilterUI"));
        }
        String[] periods = new String[bgPeriodCol.size()];
        for (int i = 0; i < bgPeriodCol.size(); ++i) {
            periods[i] = bgPeriodCol.get(i).getId().toString();
        }
        param.setPeriodIds(periods);
        this.setFilterObject(cp, param);
        return cp;
    }

    @Override
    protected void prmtBeginPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBeginPeriod_dataChanged(e);
        Object obj = this.prmtBeginPeriod.getValue();
        this.prmtEndPeriod.setData(obj);
    }

    @Override
    public boolean verify() {
        boolean re = super.verify();
        if (re && this.isAllCheck()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"262_BgFormQueryFilterUI"));
            return false;
        }
        return re;
    }

    private boolean isAllCheck() {
        Object obj;
        Object[] objs;
        return !this.prmtBeginPeriod.getValue().equals(this.prmtEndPeriod.getValue()) && this.chkIsSum.isSelected() && this.prmtOrgUnit != null && (objs = (Object[])(obj = this.prmtOrgUnit.getValue())).length > 1;
    }

    @Override
    public void clear() {
        super.clear();
    }
}

