/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.budget.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.IUserCellDisplayParser;
import com.kingdee.bos.ctrl.kdf.table.KDTRange;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.event.NodeClickListener;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.ZipKDF;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.rpt.FormulaHint;
import com.kingdee.eas.fi.rpt.RptCell;
import com.kingdee.eas.fi.rpt.TableToolkit;
import com.kingdee.eas.ma.budget.BgAnalysisTypeEnum;
import com.kingdee.eas.ma.budget.BgConstants;
import com.kingdee.eas.ma.budget.BgElementInfo;
import com.kingdee.eas.ma.budget.BgFCHelper;
import com.kingdee.eas.ma.budget.BgFSHelper;
import com.kingdee.eas.ma.budget.BgFormCollection;
import com.kingdee.eas.ma.budget.BgFormFactory;
import com.kingdee.eas.ma.budget.BgFormInfo;
import com.kingdee.eas.ma.budget.BgFormQueryFilterParam;
import com.kingdee.eas.ma.budget.BgFormStateEnum;
import com.kingdee.eas.ma.budget.BgHelper;
import com.kingdee.eas.ma.budget.BgNationalFormatUIUtil;
import com.kingdee.eas.ma.budget.BgPeriodInfo;
import com.kingdee.eas.ma.budget.BgRptFacadeFactory;
import com.kingdee.eas.ma.budget.BgRptFilterParam;
import com.kingdee.eas.ma.budget.IBgForm;
import com.kingdee.eas.ma.budget.IBgRptFacade;
import com.kingdee.eas.ma.budget.client.AbstractBgFormQueryMainUI;
import com.kingdee.eas.ma.budget.client.BgClientHelper;
import com.kingdee.eas.ma.budget.client.BgFilterBaseUI;
import com.kingdee.eas.ma.budget.client.BgFormQueryFilterUI;
import com.kingdee.eas.ma.nbudget.BgInfoHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BgFormQueryMainUI
extends AbstractBgFormQueryMainUI {
    protected static final String resourcePath = "com.kingdee.eas.ma.budget.client.BgRptResource";
    private static final String BGITEM = "BgItem";
    private static final Logger logger = CoreUIObject.getLogger(BgFormQueryMainUI.class);
    private FlexRender render = null;
    int orgUnitColumnIndex = -1;
    int orgUnitRowIndex = -1;
    int flexRowCount = 1;
    protected BgFormQueryFilterUI filterUI;
    private Vector companyVec;
    private Set parentCompanySet;
    private Set childCompanySet;
    private Map bgTemplateMap;
    private List lstTemplateKey = new ArrayList(10);
    private Vector periodVec;
    private Map companyMap;
    private String currenctBgTemId;
    private Map bgBaseMap;
    Vector elementVec;
    Vector currencyVec;
    boolean isCanDo = false;
    private Map bgFormTableMap = new HashMap();
    private Vector existDataCompanyVec;
    protected boolean isRemoved = true;
    protected boolean isSumDisp = false;
    protected IMetaDataPK mainQueryPK;
    protected DecimalFormat decFormat = BgNationalFormatUIUtil.getDecimalFormat(BgHelper.getCompanyBaseCurrency(SysContext.getSysContext().getCurrentFIUnit()).getPrecision());
    String strBgFormIDs = "";
    KDTable firstTable;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.setIcon();
        if (this.kdtabbed.getTabCount() > 0) {
            this.kdtabbed.setSelectedIndex(0);
            this.isCanDo = true;
        }
        this.setUITitle(EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"263_BgFormQueryListUI"));
    }

    public void setIcon() {
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnAttachment.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.menuItemAttach.setIcon(EASResource.getIcon((String)"imgTbtn_affixmanage"));
        this.setButtonDefaultStyl(this.btnAttachment);
    }

    public void addPanel() throws Exception {
        for (int i = 0; i < this.existDataCompanyVec.size(); ++i) {
            CostCenterOrgUnitInfo orgUnitInfo = (CostCenterOrgUnitInfo)this.existDataCompanyVec.get(i);
            if (i == 0) {
                this.kdtabbed.setTitleAt(0, orgUnitInfo.getName());
                continue;
            }
            this.kdtabbed.addTab(orgUnitInfo.getName(), (Component)this.createPanel());
        }
    }

    private KDPanel createPanel() {
        KDPanel kdpanel = new KDPanel();
        return kdpanel;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.formTable.checkParsed();
    }

    protected void initTableHead(BgFormQueryFilterParam filterParam) {
        boolean isMulti = true;
        if (filterParam.getOrgUnitIds().length < 2) {
            isMulti = false;
        }
        this.formTable.checkParsed();
        this.formTable.getStyleAttributes().setLocked(true);
        this.formTable.removeHeadRows();
        this.formTable.removeRows();
        this.formTable.removeColumns();
        for (int i = 0; i < 4; ++i) {
            this.formTable.addHeadRow();
        }
        int mergeIndex = this.formTable.getColumnCount();
        int n = 1;
        for (int i = 0; i < n; ++i) {
            IColumn col = this.formTable.addColumn();
            col.setKey(BGITEM);
            col.getStyleAttributes().setLocked(true);
            this.formTable.getHeadRow(0).getCell(i).setValue((Object)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"41_BgItemFacadeControllerBean"));
        }
        this.formTable.getHeadMergeManager().mergeBlock(0, mergeIndex, 3, this.formTable.getColumnCount() - 1);
        NodeClickListener nodeClickListener = new NodeClickListener(){

            public void doClick(CellTreeNode source, ICell cell, int type) {
                logger.info((Object)("" + type + "," + cell.getValue()));
            }
        };
        IRow headRow = this.formTable.getHeadRow(0);
        this.elementVec = (Vector)this.bgBaseMap.get("BGELEMENT");
        this.currencyVec = (Vector)this.bgBaseMap.get("BGCURRENCY");
        CostCenterOrgUnitInfo companyInfo = null;
        BgPeriodInfo periodInfo = null;
        BgElementInfo elementInfo = null;
        CurrencyInfo currencyInfo = null;
        int mergePeriodIndex = this.formTable.getColumnCount();
        int mergeCompanyIndex = this.formTable.getColumnCount();
        int mergeElementIndex = this.formTable.getColumnCount();
        for (int i = 0; i < this.companyVec.size(); ++i) {
            mergeCompanyIndex = this.formTable.getColumnCount();
            int n2 = this.periodVec.size();
            for (int j = 0; j < n2; ++j) {
                mergePeriodIndex = this.formTable.getColumnCount();
                for (int k = 0; k < this.elementVec.size(); ++k) {
                    mergeElementIndex = this.formTable.getColumnCount();
                    for (int x = 0; x < this.currencyVec.size(); ++x) {
                        IColumn newColumn = this.formTable.addColumn();
                        newColumn.setWidth(100);
                        companyInfo = (CostCenterOrgUnitInfo)this.companyVec.get(i);
                        periodInfo = (BgPeriodInfo)this.periodVec.get(j);
                        elementInfo = (BgElementInfo)this.elementVec.get(k);
                        currencyInfo = (CurrencyInfo)this.currencyVec.get(x);
                        String columnKey = companyInfo.getId().toString() + "_" + periodInfo.getId().toString() + "_" + elementInfo.getId().toString() + "_" + currencyInfo.getId().toString();
                        newColumn.setKey(columnKey);
                        newColumn.setUserObject((Object)currencyInfo.getId().toString());
                        ICell cell = headRow.getCell(newColumn.getColumnIndex());
                        cell.getStyleAttributes().setLocked(false);
                        cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
                        CellTreeNode node = new CellTreeNode();
                        node.setTreeType(CellTreeNode.TREE_TYPE_ROW);
                        node.setTreeRootDirection(CellTreeNode.TOPLEFT);
                        node.addClickListener(nodeClickListener);
                        node.setVirtualModel(true);
                        if (isMulti && this.parentCompanySet.contains(companyInfo.getId().toString())) {
                            newColumn.getStyleAttributes().setLocked(true);
                            newColumn.getStyleAttributes().setBackground(BgClientHelper.TOTAL_COLOR);
                            node.setValue((Object)companyInfo.getName());
                            node.setHasChildren(true);
                            node.setTreeLevel(0);
                        } else {
                            node.setValue((Object)companyInfo.getName());
                            node.setHasChildren(false);
                            node.setTreeLevel(1);
                        }
                        this.formTable.getHeadRow(0).getCell(newColumn.getColumnIndex()).setValue((Object)node);
                        this.formTable.getHeadRow(1).getCell(newColumn.getColumnIndex()).setValue((Object)periodInfo);
                        this.formTable.getHeadRow(2).getCell(newColumn.getColumnIndex()).setValue((Object)elementInfo);
                        this.formTable.getHeadRow(3).getCell(newColumn.getColumnIndex()).setValue((Object)currencyInfo);
                    }
                    this.formTable.getHeadMergeManager().mergeBlock(2, mergeElementIndex, 2, this.formTable.getColumnCount() - 1);
                }
                this.formTable.getHeadMergeManager().mergeBlock(1, mergePeriodIndex, 1, this.formTable.getColumnCount() - 1);
            }
            this.formTable.getHeadMergeManager().mergeBlock(0, mergeCompanyIndex, 0, this.formTable.getColumnCount() - 1);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void kdtabbed_stateChanged(ChangeEvent e) throws Exception {
        super.kdtabbed_stateChanged(e);
        if (this.isCanDo && this.isRemoved) {
            int index = this.kdtabbed.getSelectedIndex();
            String orgUnitId = ((CostCenterOrgUnitInfo)this.existDataCompanyVec.get(index)).getId().toString();
            KDPanel panel = (KDPanel)this.kdtabbed.getComponentAt(index);
            KDTable table = (KDTable)this.bgFormTableMap.get(orgUnitId);
            BgClientHelper.clearKDTableBlankArea(table);
            this.showBgFormTable(panel, table);
        }
    }

    public void setTableData(BgFormQueryFilterParam filterParam) throws Exception {
        if (this.bgTemplateMap.keySet() != null && this.bgTemplateMap.keySet().size() > 0) {
            String templateKey = (String)this.bgTemplateMap.keySet().toArray()[0];
            Object table = null;
            HashSet<String> idSet = new HashSet<String>();
            IRowSet rs = null;
            StringBuffer sqlBuff = new StringBuffer(" select BGFORM.FID as FID, BGFORM.FOrgUnitID as FOrgUnitID, BGFORM.FData as FData from t_bg_bgform as BGFORM ");
            sqlBuff.append(" where BGFORM.FOrgUnitID in ");
            sqlBuff.append(BgHelper.tranArray2String(filterParam.getOrgUnitIds()));
            sqlBuff.append(" and BGFORM.FBgSchemeID IN ");
            sqlBuff.append(BgHelper.tranArray2String(filterParam.getBgSchemeIds()));
            sqlBuff.append(" and BGFORM.FBgTemplateID IN ");
            sqlBuff.append(BgHelper.tranArray2String(filterParam.getBgTemplateIds()));
            sqlBuff.append(" and BGFORM.FBgPeriodID=");
            sqlBuff.append("'").append(filterParam.getBeginPeriodId()).append("'");
            sqlBuff.append(" and BGFORM.FState=");
            sqlBuff.append(2);
            ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sqlBuff.toString());
            byte[] data = null;
            String id = null;
            try {
                rs = sqlExe.executeSQL();
                if (rs.size() > 0) {
                    while (rs.next()) {
                        data = BgInfoHelper.getBytes((ResultSet)rs, (String)"FData");
                        if (data == null) continue;
                        id = rs.getString("FID");
                        idSet.add(id);
                    }
                } else {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckExistBgForm"));
                    SysUtil.abort();
                }
                this.setBgFormTableMap(idSet);
            }
            catch (BOSException e) {
                throw new BOSException((Throwable)e);
            }
            catch (SQLException e2) {
                throw new BOSException((Throwable)e2);
            }
        }
    }

    private void setBgFormTableMap(Set idSet) throws Exception {
        BgFormInfo bgFormInfo = null;
        if (idSet != null && idSet.size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            viewInfo.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("data"));
            selector.add(new SelectorItemInfo("bgPeriod"));
            selector.add(new SelectorItemInfo("orgUnit"));
            selector.add(new SelectorItemInfo("orgUnit.id"));
            selector.add(new SelectorItemInfo("orgUnit.name"));
            selector.add(new SelectorItemInfo("orgUnit.number"));
            selector.add(new SelectorItemInfo("currency"));
            selector.add(new SelectorItemInfo("bgScheme"));
            selector.add(new SelectorItemInfo("bgTemplate"));
            selector.add(new SelectorItemInfo("auditedStatus"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
            IBgForm iBgForm = BgFormFactory.getRemoteInstance();
            BgFormCollection bgFormColl = iBgForm.getBgFormCollection(viewInfo);
            for (int i = 0; i < bgFormColl.size(); ++i) {
                bgFormInfo = bgFormColl.get(i);
                this.bgFormTableMap.put(bgFormInfo.getOrgUnit().getId().toString(), this.getKDTable(bgFormInfo, true));
            }
            if (this.companyMap.size() > 1) {
                HashMap tempMap = new HashMap();
                for (String key : this.companyMap.keySet()) {
                    if (!this.bgFormTableMap.keySet().contains(key)) continue;
                    tempMap.put(key, this.companyMap.get(key));
                }
                this.companyMap.clear();
                this.companyMap.putAll(tempMap);
            }
        }
    }

    Vector getBgFormTableID(BgFormQueryFilterParam filterParam) throws Exception {
        Vector<String> vector = new Vector<String>();
        BgFormInfo bgFormInfo = null;
        if (this.bgTemplateMap.keySet() != null && this.bgTemplateMap.keySet().size() > 0) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.childCompanySet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootid", (Object)filterParam.getBgSchemeId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootid", (Object)filterParam.getCurrentBgTemplate(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)BgHelper.tranArray2Set(filterParam.getPeriodIds()), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Approved, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Edited, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Approving, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Adjusted, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Collect, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and ( #4 or #5 or #6 or #7 or #8 ) ");
            viewInfo.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("data"));
            selector.add(new SelectorItemInfo("bgPeriod"));
            selector.add(new SelectorItemInfo("orgUnit"));
            selector.add(new SelectorItemInfo("orgUnit.id"));
            selector.add(new SelectorItemInfo("orgUnit.name"));
            selector.add(new SelectorItemInfo("orgUnit.number"));
            selector.add(new SelectorItemInfo("currency"));
            selector.add(new SelectorItemInfo("bgScheme"));
            selector.add(new SelectorItemInfo("bgTemplate"));
            selector.add(new SelectorItemInfo("auditedStatus"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
            IBgForm iBgForm = BgFormFactory.getRemoteInstance();
            BgFormCollection bgFormColl = iBgForm.getBgFormCollection(viewInfo);
            if (bgFormColl == null || bgFormColl.size() < 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"264_BgFormQueryMainUI"));
                this.kdtabbed.setTitleAt(0, SysContext.getSysContext().getCurrentFIUnit().getName());
                SysUtil.abort();
            }
            for (int k = 0; k < bgFormColl.size(); ++k) {
                bgFormInfo = bgFormColl.get(k);
                vector.add(bgFormInfo.getId().toString());
            }
        }
        return vector;
    }

    private String convertFormula(String ItemFormula2, boolean isCol) {
        List list = new ArrayList();
        try {
            list = TableToolkit.parseFormula((String)ItemFormula2, (boolean)false);
        }
        catch (ParserException e1) {
            return null;
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        FormulaHint hint = (FormulaHint)list.get(0);
        String[] params = hint.getParams();
        String result = "";
        String periodStr = params[1];
        result = periodStr.indexOf("Y") >= 0 && periodStr.indexOf(".") < 0 ? ItemFormula2 : (isCol ? "=BgItem(\"" + params[0] + "\",\"" + params[2] + "\",\"" + params[3] + "\"," + params[4] + ",\"" + params[5] + "\")" : ItemFormula2);
        return result;
    }

    private Object computeValue(Map hm, String strFormula, String strValue) {
        if (hm.containsKey(strFormula)) {
            return ((BigDecimal)hm.get(strFormula)).add(new BigDecimal(strValue));
        }
        return new BigDecimal(strValue);
    }

    private void setBgFormTableMap(BgFormQueryFilterParam filterParam) throws Exception {
        BgFormInfo bgFormInfo = null;
        if (this.bgTemplateMap.keySet() != null && this.bgTemplateMap.keySet().size() > 0) {
            HashSet<String> set = new HashSet<String>();
            for (int i = 0; i < filterParam.getPeriodIds().length; ++i) {
                set.add(filterParam.getPeriodIds()[i]);
            }
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)BgHelper.tranArray2Set(filterParam.getOrgUnitIds()), CompareType.INCLUDE));
            if (filterParam.getOrgUnitIds().length > 1) {
                filter.getFilterItems().add(new FilterItemInfo("bgScheme.rootid", (Object)filterParam.getBgSchemeId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.rootid", (Object)filterParam.getCurrentBgTemplate(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)filterParam.getBgSchemeId(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)filterParam.getCurrentBgTemplate(), CompareType.EQUALS));
            }
            filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", set, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Approved, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Edited, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Approving, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Adjusted, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)BgFormStateEnum.Collect, CompareType.EQUALS));
            filter.setMaskString("#0 and #1 and #2 and #3 and ( #4 or #5 or #6 or #7 or #8)");
            viewInfo.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("data"));
            selector.add(new SelectorItemInfo("bgPeriod"));
            selector.add(new SelectorItemInfo("orgUnit"));
            selector.add(new SelectorItemInfo("orgUnit.id"));
            selector.add(new SelectorItemInfo("orgUnit.name"));
            selector.add(new SelectorItemInfo("orgUnit.number"));
            selector.add(new SelectorItemInfo("currency"));
            selector.add(new SelectorItemInfo("bgScheme"));
            selector.add(new SelectorItemInfo("bgTemplate"));
            selector.add(new SelectorItemInfo("auditedStatus"));
            selector.add(new SelectorItemInfo("lastUpdateTime"));
            viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
            IBgForm iBgForm = BgFormFactory.getRemoteInstance();
            BgFormCollection bgFormColl = iBgForm.getBgFormCollection(viewInfo);
            if (bgFormColl == null || bgFormColl.size() < 1) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"264_BgFormQueryMainUI"));
                this.kdtabbed.setTitleAt(0, SysContext.getSysContext().getCurrentFIUnit().getName());
                SysUtil.abort();
            }
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            String convertedFormula = "";
            BgFormInfo bgFormInfo_ = bgFormColl.get(0);
            KDTable kdt_ = null;
            KDTable kdt = null;
            for (int m = 0; m < bgFormColl.size(); ++m) {
                String orgunitid = null;
                for (int k = m; k < bgFormColl.size(); ++k) {
                    bgFormInfo = bgFormColl.get(k);
                    kdt_ = this.getKDTable(bgFormInfo, true);
                    if (kdt == null) {
                        orgunitid = bgFormInfo.getOrgUnit().getId().toString();
                        kdt = kdt_;
                    }
                    if (!bgFormInfo.equals(bgFormInfo_)) {
                        bgFormInfo_ = bgFormInfo;
                        m = k - 1;
                        break;
                    }
                    int colCount = kdt_.getColumnCount();
                    int rowCount = kdt_.getRowCount3();
                    for (int i = 0; i < colCount; ++i) {
                        for (int j = 0; j < rowCount; ++j) {
                            RptCell rptCell;
                            String formulaString;
                            ICell cell = kdt_.getCell(j, i);
                            if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null || formulaString.trim().length() <= 0) continue;
                            String budgetValue = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                            try {
                                if (budgetValue == null || budgetValue.trim().length() <= 0) continue;
                                convertedFormula = orgunitid + "_" + this.convertFormula(formulaString, filterParam.getPeriodIds().length > 1);
                                resultMap.put(convertedFormula, this.computeValue(resultMap, convertedFormula, budgetValue));
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (kdt == null) {
                    return;
                }
                int colCount = kdt.getColumnCount();
                int rowCount = kdt.getRowCount3();
                kdt.getScriptManager().setAutoRun(false);
                for (int i = 0; i < colCount; ++i) {
                    for (int j = 0; j < rowCount; ++j) {
                        RptCell rptCell;
                        String formulaString;
                        ICell cell = kdt.getCell(j, i);
                        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null || formulaString.trim().length() <= 0) continue;
                        convertedFormula = orgunitid + "_" + this.convertFormula(formulaString, filterParam.getPeriodIds().length > 1);
                        try {
                            cell.setValue((Object)this.decFormat.format(resultMap.get(convertedFormula)));
                            continue;
                        }
                        catch (Exception e) {
                            cell.setValue(resultMap.get(convertedFormula));
                        }
                    }
                }
                this.bgFormTableMap.put(orgunitid, kdt);
                kdt = null;
            }
            if (this.companyMap.size() > 1) {
                HashMap tempMap = new HashMap();
                for (String key : this.companyMap.keySet()) {
                    if (!this.bgFormTableMap.keySet().contains(key)) continue;
                    tempMap.put(key, this.companyMap.get(key));
                }
                this.companyMap.clear();
                this.companyMap.putAll(tempMap);
            }
            this.existDataCompanyVec = new Vector(this.companyVec);
            for (int i = 0; i < this.companyVec.size(); ++i) {
                Object obj = this.companyVec.get(i);
                if (this.companyMap.containsKey(((CostCenterOrgUnitInfo)obj).getId().toString())) continue;
                this.existDataCompanyVec.remove(obj);
            }
        }
    }

    private KDTable getKDTable(BgFormInfo bgFormInfo, boolean isGetValue) throws EASBizException, BOSException {
        KDTable table = null;
        KDF kdf = null;
        if (bgFormInfo == null || bgFormInfo.getZipData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckExistBgTable"));
            SysUtil.abort();
        }
        try {
            kdf = bgFormInfo.getKDF();
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage());
            this.clearKDTable(table);
            this.clearKDF(kdf);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckTableDataIsNull"));
            SysUtil.abort();
        }
        if (kdf == null || kdf.getAllTable() == null || kdf.getAllTable().size() < 1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckTableDataIsNull"));
            SysUtil.abort();
        }
        ICell cell = null;
        RptCell rptCell = null;
        String formulaString = null;
        String valueString = null;
        Collection dataColl = kdf.getAllTable();
        if (isGetValue) {
            for (KDTable kdTable : dataColl) {
                kdTable.getScriptManager().setAutoRun(false);
                kdTable.setFormulaMode(0);
                int rowCount = kdTable.getBody().size();
                int colCount = kdTable.getColumnCount();
                for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                    for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                        cell = kdTable.getCell(rowIndex, colIndex);
                        try {
                            if (BgFSHelper.checkHasFormulaOfCell(cell)) {
                                BigDecimal num = new BigDecimal(cell.getValue().toString());
                                cell.setValue((Object)this.decFormat.format(num));
                            } else {
                                cell.setValue(cell.getValue());
                            }
                        }
                        catch (Exception num) {
                            // empty catch block
                        }
                        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell) || (formulaString = (rptCell = (RptCell)cell.getUserObject()).getItemFormulaLine()) == null || formulaString.trim().length() <= 0) continue;
                        valueString = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                        BigDecimal valueBD = new BigDecimal("0");
                        if (valueString != null && valueString.trim().length() > 0) {
                            try {
                                valueBD = new BigDecimal(valueString).setScale(2, 4);
                            }
                            catch (Exception e) {
                                valueBD = BgConstants.BIGZERO;
                            }
                        }
                        cell.setValue((Object)this.decFormat.format(valueBD));
                    }
                }
            }
        }
        table = (KDTable)kdf.getTableByIndex(0);
        kdf = null;
        if (!this.isSumDisp) {
            this.clearKDTableBlankArea(table);
            table.putUserProperty("id", (Object)bgFormInfo.getId().toString());
        }
        return table;
    }

    private void showBgFormTable(KDPanel panel, KDTable table) {
        this.removeTable();
        panel.removeAll();
        if (table != null) {
            table.setEditable(false);
            table.getScriptManager().setAutoRun(false);
            panel.setLayout((LayoutManager)new KDLayout());
            panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, panel.getWidth(), panel.getHeight()));
            table.setBounds(new Rectangle(8, 10, panel.getWidth() - 16, panel.getHeight() - 20));
            table.getHeadRow(0).getStyleAttributes().setBackground(new Color(184, 204, 221));
            table.getHeadStyleAttributes().setBackground(new Color(184, 204, 221));
            table.getIndexColumn().getStyleAttributes().setBackground(new Color(184, 204, 221));
            panel.add((Component)table, (Object)new KDLayout.Constraints(8, 10, panel.getWidth() - 16, panel.getHeight() - 20, 15));
            table.setUserCellDisplayParser(new IUserCellDisplayParser(){

                public Object parse(int rowIndex, int colIndex, ICell cell, Object value) {
                    if (colIndex == BgFormQueryMainUI.this.orgUnitColumnIndex) {
                        return cell.getValue();
                    }
                    return value;
                }
            });
        }
    }

    private void removeTable() {
        for (int i = 0; i < this.kdtabbed.getTabCount(); ++i) {
            KDPanel panel = (KDPanel)this.kdtabbed.getComponentAt(i);
            if (panel.getComponentCount() <= 0) continue;
            panel.remove(0);
        }
    }

    private void clearKDTable(KDTable table) {
        if (table != null) {
            table.removeAll();
        }
    }

    private void clearKDF(KDF kdf) {
        if (kdf != null) {
            kdf.removeAllTables();
        }
    }

    @Override
    protected void execQuery() throws Exception {
        KDPanel panel;
        this.orgUnitRowIndex = -1;
        BgFormQueryFilterParam filterParam = (BgFormQueryFilterParam)this.getFilterParam();
        if (filterParam == null) {
            CustomerParams cp = this.getFilterUI().getCustomerParams();
            filterParam = (BgFormQueryFilterParam)this.getFilterUI().getFilterObject(cp);
        }
        if (filterParam.getBgTemplate().size() == 0 || filterParam.getOrgUnitIds() == null || filterParam.getOrgUnitIds()[0] == null || null == filterParam.getBgSchemeId()) {
            this.kdtabbed.setTitleAt(0, "");
            return;
        }
        if (null == filterParam.getPeriodIds()) {
            this.kdtabbed.setTitleAt(0, "");
            return;
        }
        this.bgTemplateMap = filterParam.getBgTemplate();
        this.bgFormTableMap.clear();
        if (!filterParam.isIsSum() || filterParam.getOrgUnitIds().length == 1) {
            this.isSumDisp = false;
            this.actionAttachment.setEnabled(true);
            this.menuItemAttach.setVisible(true);
            this.btnAttachment.setVisible(true);
            if (this.kdtabbed.getTabCount() > 1) {
                for (int i = this.kdtabbed.getTabCount(); i > 1; --i) {
                    this.isRemoved = false;
                    this.kdtabbed.remove(i - 1);
                    this.isRemoved = true;
                }
            }
            this.kdtabbed.validate();
            this.getFilterParam(filterParam);
            this.setBgFormTableMap(filterParam);
            this.addPanel();
            if (this.existDataCompanyVec.size() > 0) {
                panel = (KDPanel)this.kdtabbed.getSelectedComponent();
                KDTable table = (KDTable)this.bgFormTableMap.get(((CostCenterOrgUnitInfo)this.existDataCompanyVec.get(0)).getId().toString());
                this.showBgFormTable(panel, table);
            }
            KDTable table = null;
            this.kdtabbed.setSelectedIndex(0);
            KDPanel panel2 = (KDPanel)this.kdtabbed.getComponentAt(0);
            if (panel2.getComponentCount() > 0) {
                table = (KDTable)panel2.getComponent(0);
                BgClientHelper.clearKDTableBlankArea(table);
            }
        } else {
            this.isSumDisp = true;
            this.actionAttachment.setEnabled(false);
            this.menuItemAttach.setVisible(false);
            this.btnAttachment.setVisible(false);
            if (this.kdtabbed.getTabCount() > 1) {
                for (int i = this.kdtabbed.getTabCount(); i > 1; --i) {
                    this.isRemoved = false;
                    this.kdtabbed.remove(i - 1);
                    this.isRemoved = true;
                }
            }
            this.kdtabbed.validate();
            this.kdtabbed.setTitleAt(0, SysContext.getSysContext().getCurrentFIUnit().getName());
            panel = (KDPanel)this.kdtabbed.getSelectedComponent();
            IBgRptFacade iBgRptFacade = BgRptFacadeFactory.getRemoteInstance();
            BgFormInfo formInfo = iBgRptFacade.getBgForm(filterParam);
            if (formInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"265_BgFormQueryMainUI"));
                SysUtil.abort();
            }
            this.getFilterParam(filterParam);
            this.collectBgForm(formInfo, filterParam);
            this.showBgFormTable(panel, this.getKDTable(formInfo, false));
            this.processCollectFormat();
            Object var5_8 = null;
        }
    }

    private void clearKDTableBlankArea(KDTable table) {
        int i;
        int rowCount = table.getRowCount();
        int columnCount = table.getColumnCount();
        ICell tmpCell = null;
        block0: for (i = rowCount - 1; i >= 0; ++i) {
            for (int j = columnCount - 1; j >= 0; ++j) {
                ICell cell = table.getCell(i, j);
                if (cell == null || cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                tmpCell = cell;
                continue block0;
            }
        }
        if (tmpCell != null) {
            if (rowCount > tmpCell.getRowIndex()) {
                for (i = tmpCell.getRowIndex() + 1; i < rowCount; ++i) {
                    table.removeRow(i);
                }
            }
            if (columnCount > tmpCell.getColumnIndex()) {
                for (i = tmpCell.getColumnIndex() + 1; i < columnCount; ++i) {
                    table.removeColumn(i);
                }
            }
        }
    }

    private void processCollectFormat() {
        this.getMainTable().checkParsed();
        this.getMainTable().addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                try {
                    BgFormQueryMainUI.this.tblMain_tableClicked(e);
                }
                catch (Exception exc) {
                    BgFormQueryMainUI.this.handUIException(exc);
                }
            }
        });
        this.getMainTable().getDataRequestManager().setDataRequestMode(0);
        IColumn col = null;
        col = this.getMainTable().getColumn(this.orgUnitColumnIndex);
        if (col != null) {
            this.render = new FlexRender();
            col.setRenderer((IBasicRender)this.render);
            col.getStyleAttributes().setLocked(true);
        }
        this.initListener();
        if (this.orgUnitRowIndex < 0) {
            return;
        }
        for (int i = this.orgUnitRowIndex; i < this.getMainTable().getRowCount(); ++i) {
            IRow row = this.getMainTable().getRow(i);
            ICell cell = row.getCell(this.orgUnitColumnIndex);
            CostCenterOrgUnitInfo companyInfo = (CostCenterOrgUnitInfo)cell.getValue();
            if (this.parentCompanySet.contains(companyInfo.getId().toString())) {
                row.getStyleAttributes().setBackground(BgClientHelper.TOTAL_COLOR);
            } else {
                row.getStyleAttributes().setBackground(Color.white);
            }
            NumberExpandInfo expandInfo = new NumberExpandInfo();
            expandInfo.setId(companyInfo.getId().toString());
            expandInfo.setNumber(companyInfo.getNumber());
            expandInfo.setName(companyInfo.getName());
            expandInfo.setLongNumber(companyInfo.getLongNumber());
            expandInfo.setLevel(0);
            expandInfo.setExpandStatus(true);
            if (this.parentCompanySet.contains(companyInfo.getId().toString())) {
                expandInfo.setLeaf(false);
            } else {
                expandInfo.setLeaf(true);
            }
            cell.setValue((Object)expandInfo);
        }
        IRow row = this.getMainTable().getRow(this.orgUnitRowIndex);
        this.setTreeDisplayStyle(row, (NumberExpandInfo)row.getCell(this.orgUnitColumnIndex).getValue(), this.orgUnitColumnIndex);
    }

    protected void initListener() {
        this.getMainTable().addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent event) {
                if (BgFormQueryMainUI.this.getMainTable().getRowCount() <= 0) {
                    return;
                }
                BgFormQueryMainUI.this.setActionState();
            }
        });
    }

    private void collectBgForm(BgFormInfo bgFormInfo, BgFormQueryFilterParam filterParam) throws BOSException, EASBizException {
        KDF kdf = null;
        try {
            kdf = bgFormInfo.getKDF();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Collection collection = kdf.getAllTable();
        if (collection != null) {
            int colletionSize = collection.size();
            for (int i = 0; i < colletionSize; ++i) {
                KDTable tempTable = (KDTable)kdf.getTableByIndex(i);
                tempTable.getScriptManager().setAutoRun(false);
                int index = tempTable.getID().indexOf("RPTSHEET");
                if (index < 0) continue;
                this.processTableFormat(tempTable, filterParam);
            }
        }
        try {
            bgFormInfo.setZipData(ZipKDF.pack((KDF)kdf));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int colIndex;
        if (e.getClickCount() == 1 && (colIndex = e.getColIndex()) == this.orgUnitColumnIndex) {
            NumberExpandInfo expandInfo;
            int rowIndex = e.getRowIndex();
            IRow row = this.getMainTable().getRow(rowIndex);
            if (row != null && row.getCell(this.orgUnitColumnIndex).getValue() != null && row.getCell(this.orgUnitColumnIndex).getValue() instanceof NumberExpandInfo && (expandInfo = (NumberExpandInfo)row.getCell(this.orgUnitColumnIndex).getValue()) != null && this.render.inRect(expandInfo, e.getX(), e.getY())) {
                this.setTreeDisplayStyle(row, expandInfo, this.orgUnitColumnIndex);
            }
        }
    }

    protected void setTreeDisplayStyle(IRow row, NumberExpandInfo numberExpandInfo, int expandIndex) {
        if (!numberExpandInfo.isLeaf) {
            this.getMainTable().setRefresh(false);
            this.expandTable(row, numberExpandInfo, expandIndex);
            this.getMainTable().setRefresh(true);
            this.getMainTable().reLayoutAndPaint();
        }
    }

    protected void expandTable(IRow row, NumberExpandInfo numberExpandInfo, int expandIndex) {
        if (row == null || numberExpandInfo == null) {
            return;
        }
        IRow child = null;
        String longNumber = null;
        NumberExpandInfo expandInfo = null;
        String bgLongNumber = numberExpandInfo.getLongNumber();
        boolean isExpandStatus = numberExpandInfo.isExpandStatus();
        if (isExpandStatus) {
            numberExpandInfo.setExpandStatus(false);
            int rowCount = this.getMainTable().getRowCount();
            for (int rowIndex = row.getRowIndex() + this.flexRowCount; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.getMainTable().getRow(rowIndex)).getCell(expandIndex).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(true);
            }
        } else {
            numberExpandInfo.setExpandStatus(true);
            int rowCount = this.getMainTable().getRowCount();
            for (int rowIndex = row.getRowIndex() + this.flexRowCount; rowIndex < rowCount && (longNumber = (expandInfo = (NumberExpandInfo)(child = this.getMainTable().getRow(rowIndex)).getCell(expandIndex).getValue()).getLongNumber()).startsWith(bgLongNumber); ++rowIndex) {
                child.getStyleAttributes().setHided(false);
                if (expandInfo.isLeaf()) continue;
                this.expandChild(child, expandInfo, expandIndex);
            }
        }
    }

    private int expandChild(IRow row, NumberExpandInfo parentExpandInfo, int expandIndex) {
        int rowIndex;
        IRow child = null;
        int endIndex = rowIndex = row.getRowIndex() + 1;
        int rowCount = this.getMainTable().getRowCount();
        String number = null;
        NumberExpandInfo childExpandInfo = null;
        String parentNumber = parentExpandInfo.getLongNumber();
        parentExpandInfo.setExpandStatus(true);
        for (int i = rowIndex; i < rowCount; ++i) {
            child = this.getMainTable().getRow(i);
            if (child != null) {
                childExpandInfo = (NumberExpandInfo)child.getCell(expandIndex).getValue();
                number = childExpandInfo.getLongNumber();
                if (!number.startsWith(parentNumber)) break;
                if (!childExpandInfo.isLeaf()) {
                    i = this.expandChild(child, childExpandInfo, expandIndex);
                }
            }
            ++endIndex;
        }
        return endIndex;
    }

    private void processTableFormat(KDTable table, BgFormQueryFilterParam filterParam) throws BOSException, EASBizException {
        int i;
        this.clearKDTableBlankArea(table);
        BgClientHelper.clearKDTableBlankArea(table);
        int rowCount = table.getBody().size();
        int colCount = table.getColumnCount();
        ICell beginCell = null;
        ICell middleCell = null;
        ICell tmpBeginCell = null;
        ICell tmpMiddleCell = null;
        ICell expressionCell = null;
        HashSet<String> bgItemFormulaSet = new HashSet<String>();
        boolean beginFlag = true;
        boolean tempFlag = true;
        boolean expressionFlag = true;
        KDTable tab = new KDTable();
        tab = table;
        ArrayList delColRows = new ArrayList();
        for (i = rowCount - 1; i >= 0; --i) {
        }
        for (i = 0; i < colCount; ++i) {
            for (int j = 0; j < rowCount; ++j) {
                ICell cell = table.getCell(j, i);
                if (cell.getUserObject() != null && cell.getUserObject() instanceof RptCell) {
                    RptCell rptCell = (RptCell)cell.getUserObject();
                    String formulaString = rptCell.getItemFormulaLine();
                    if (formulaString != null && formulaString.trim().length() > 0 && cell.getValue() != null) {
                        String budgetValue = rptCell.getItemFormula().getExt("BG_BUDGET_VALUE");
                        if (budgetValue != null && budgetValue.trim().length() > 0) {
                            cell.setValue((Object)budgetValue);
                        }
                    } else if (BgFCHelper.isNumericalOfCell(cell) && cell.getValue() != null) {
                        try {
                            cell.setValue((Object)this.decFormat.format(new BigDecimal(cell.getValue().toString())));
                            cell.getStyleAttributes().setNumberFormat(null);
                        }
                        catch (Exception e) {
                            cell.setValue(cell.getValue());
                            cell.getStyleAttributes().setNumberFormat(null);
                        }
                    } else {
                        cell.setValue(cell.getValue());
                        cell.getStyleAttributes().setNumberFormat(null);
                    }
                    bgItemFormulaSet.add(rptCell.getItemFormulaLine());
                    if (tempFlag) {
                        tmpMiddleCell = cell;
                        tempFlag = false;
                    }
                } else if (BgFCHelper.isNumericalOfCell(cell) && cell.getValue() != null) {
                    try {
                        cell.setValue((Object)this.decFormat.format(new BigDecimal(cell.getValue().toString())));
                    }
                    catch (Exception e) {
                        cell.setValue(cell.getValue());
                    }
                } else {
                    cell.setValue(cell.getValue());
                    cell.getStyleAttributes().setNumberFormat(null);
                }
                if (beginFlag && cell.getValue() != null) {
                    tmpBeginCell = cell;
                    beginFlag = false;
                }
                if ((!expressionFlag || cell.getExpressions() == null || cell.getExpressions().trim().length() <= 0 || !(cell.getValue() instanceof BigDecimal)) && (!expressionFlag || cell.getStyleAttributes().getNumberFormat().indexOf("0.0") <= 0)) continue;
                expressionCell = cell;
                expressionFlag = false;
            }
        }
        beginCell = tmpBeginCell;
        middleCell = tmpMiddleCell;
        if (expressionCell != null && tmpMiddleCell != null && tmpMiddleCell.getRowIndex() > expressionCell.getRowIndex()) {
            tmpMiddleCell = expressionCell;
            middleCell = expressionCell;
        }
        if (beginCell != null && middleCell != null) {
            int i2;
            int valRowCount = rowCount - middleCell.getRowIndex();
            int newRowCount = beginCell.getRowIndex();
            HashSet<String> companySet = new HashSet<String>(this.companyVec.size());
            for (i2 = 0; i2 < this.companyVec.size(); ++i2) {
                companySet.add(((CostCenterOrgUnitInfo)this.companyVec.get(i2)).getId().toString());
            }
            if (tmpBeginCell != null && tmpBeginCell.getColumnIndex() == 0) {
                table.addColumn(0);
                beginCell = table.getCell(tmpBeginCell.getRowIndex(), tmpBeginCell.getColumnIndex() + 1);
                if (tmpMiddleCell != null) {
                    middleCell = table.getCell(tmpMiddleCell.getRowIndex(), tmpMiddleCell.getColumnIndex() + 1);
                }
            } else {
                beginCell = tmpBeginCell;
                middleCell = tmpMiddleCell;
            }
            colCount = table.getColumnCount();
            if (beginCell != null) {
                this.orgUnitColumnIndex = beginCell.getColumnIndex() - 1;
            }
            if (middleCell != null) {
                this.orgUnitRowIndex = middleCell.getRowIndex();
            }
            this.flexRowCount = valRowCount;
            table.getColumn(this.orgUnitColumnIndex).getStyleAttributes().setNumberFormat(null);
            newRowCount = rowCount;
            for (i2 = 0; i2 < valRowCount * (this.companyVec.size() - 1); ++i2) {
                table.addRow();
            }
            KDTSelectManager manager = table.getSelectManager();
            if (middleCell != null && beginCell != null) {
                manager.set(middleCell.getRowIndex(), beginCell.getColumnIndex(), rowCount, colCount);
                KDTRange range = manager.toRange();
                table.getEditHelper().copy(15);
                table.getEditHelper().copy();
                for (int i3 = 0; i3 < this.companyVec.size() - 1; ++i3) {
                    manager.set(rowCount + valRowCount * i3, beginCell.getColumnIndex(), rowCount + valRowCount * (i3 + 1), table.getColumnCount());
                    table.getEditHelper().paste(15);
                }
                newRowCount = middleCell.getRowIndex();
                table.getColumn(beginCell.getColumnIndex() - 1).setMergeable(true);
                table.getColumn(beginCell.getColumnIndex() - 1).setGroup(true);
                table.getGroupManager().setGroup(true);
                table.getMergeManager().setMergeMode(5);
            }
            for (int i4 = 0; i4 < this.companyVec.size(); ++i4) {
                CostCenterOrgUnitInfo companyInfo = (CostCenterOrgUnitInfo)this.companyVec.get(i4);
                for (int j = 0; j < valRowCount; ++j) {
                    if (table.getRow(valRowCount * i4 + (newRowCount + j)) == null || beginCell == null) continue;
                    table.getRow(valRowCount * i4 + (newRowCount + j)).getCell(beginCell.getColumnIndex() - 1).setValue((Object)companyInfo);
                }
                if (middleCell == null || beginCell == null) continue;
                table.getMergeManager().mergeBlock(valRowCount * i4 + middleCell.getRowIndex(), beginCell.getColumnIndex() - 1, valRowCount * i4 + rowCount - 1, beginCell.getColumnIndex() - 1);
            }
            Vector vx = null;
            try {
                vx = this.getBgFormTableID(filterParam);
                this.strBgFormIDs = "";
                for (int i5 = 0; i5 < vx.size(); ++i5) {
                    this.strBgFormIDs = this.strBgFormIDs + "'" + vx.get(i5) + "' ,";
                }
                this.strBgFormIDs = this.strBgFormIDs.substring(0, this.strBgFormIDs.length() - 1);
            }
            catch (Exception e) {
                this.handleException(e);
                SysUtil.abort();
            }
            Map dataMap = this.getCollectData(bgItemFormulaSet, filterParam.getPeriodIds().length > 1);
            BigDecimal num = new BigDecimal("0");
            if (middleCell != null) {
                String companyId = null;
                for (int i6 = middleCell.getRowIndex(); i6 < rowCount + valRowCount * (this.companyVec.size() - 1); ++i6) {
                    IRow row = table.getRow(i6);
                    if (beginCell != null) {
                        companyId = ((CostCenterOrgUnitInfo)row.getCell(beginCell.getColumnIndex() - 1).getValue()).getId().toString();
                    }
                    for (int j = middleCell.getColumnIndex(); j < table.getColumnCount(); ++j) {
                        if (row == null || row.getCell(j) == null) {
                            logger.info((Object)("Row: " + i6 + " Cell is null ! "));
                            continue;
                        }
                        ICell cell = row.getCell(j);
                        try {
                            if (BgFSHelper.checkHasFormulaOfCell(cell)) {
                                num = new BigDecimal(cell.getValue().toString());
                                cell.setValue((Object)this.decFormat.format(num));
                            } else {
                                cell.setValue(cell.getValue());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (cell.getUserObject() == null || !(cell.getUserObject() instanceof RptCell)) continue;
                        RptCell rptCell = (RptCell)cell.getUserObject();
                        Object obj = dataMap.get(companyId + "_" + this.convertFormula(rptCell.getItemFormulaLine(), filterParam.getPeriodIds().length > 1));
                        if (obj != null && obj instanceof BigDecimal) {
                            cell.setValue((Object)this.decFormat.format(obj));
                            continue;
                        }
                        if (!BgFSHelper.checkHasFormulaOfCell(cell)) continue;
                        CostCenterOrgUnitInfo fullOrgUnitInfo = (CostCenterOrgUnitInfo)this.companyVec.get(0);
                        if (companyId == null || companyId.equals(fullOrgUnitInfo.getId().toString())) continue;
                        cell.setValue((Object)BgConstants.BIGZERO);
                    }
                }
            }
        }
        Object[] rows = new Object[delColRows.size()];
        rows = delColRows.toArray();
        int removeRow = 0;
        for (int i7 = this.companyVec.size() - 1; i7 > 0; --i7) {
            for (int j = 0; j < rows.length; ++j) {
                removeRow = i7 * this.flexRowCount + (Integer)rows[j];
                table.removeRow(removeRow);
            }
        }
    }

    private Map getCollectData(Set formulaSet, boolean isCol) throws BOSException, EASBizException {
        Map preCollectMap;
        Map valueMap = preCollectMap = this.getAllDataByFormula(formulaSet, this.childCompanySet);
        BigDecimal bgValue = null;
        String currentKey = null;
        String key = null;
        HashSet<String> newFormulaSet = new HashSet<String>();
        Iterator iter = formulaSet.iterator();
        while (iter.hasNext()) {
            String newItemFormula = this.convertFormula((String)iter.next(), isCol);
            if (newItemFormula == null) continue;
            newFormulaSet.add(newItemFormula);
        }
        for (int i = this.companyVec.size() - 1; i >= 0; --i) {
            String parentCompanyId;
            CostCenterOrgUnitInfo fullOrgUnit = (CostCenterOrgUnitInfo)this.companyVec.get(i);
            if (fullOrgUnit.getParent() == null || !this.parentCompanySet.contains(parentCompanyId = fullOrgUnit.getParent().getId().toString())) continue;
            Iterator iter2 = newFormulaSet.iterator();
            while (iter2.hasNext()) {
                bgValue = null;
                String itemFormula = (String)iter2.next();
                currentKey = fullOrgUnit.getId().toString() + "_" + itemFormula;
                key = parentCompanyId + "_" + itemFormula;
                if (!preCollectMap.containsKey(currentKey)) continue;
                bgValue = (BigDecimal)preCollectMap.get(currentKey);
                if (valueMap.containsKey(key)) {
                    bgValue = BgHelper.getBigDecimal(valueMap.get(key)).add(BgHelper.getBigDecimal(bgValue));
                }
                valueMap.put(key, bgValue);
            }
        }
        return valueMap;
    }

    private Map getAllDataByFormula(Set formulaSet, Set companyIdSet) throws BOSException, EASBizException {
        HashMap<String, BigDecimal> dataMap = new HashMap<String, BigDecimal>();
        StringBuffer strBuff = new StringBuffer("SELECT FOrgUnitId, FFormula, FBgValue ,FBgPeriodId ");
        strBuff.append(" FROM T_BG_BgData ");
        strBuff.append(" WHERE FOrgUnitId IN ");
        strBuff.append(BgHelper.tranSet2String(companyIdSet));
        strBuff.append(" AND FBgFormId in(" + this.strBgFormIDs + ") ");
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)strBuff.toString());
        BgFormQueryFilterParam filter = (BgFormQueryFilterParam)this.getFilterParam();
        String[] periods = filter.getPeriodIds();
        try {
            IRowSet rs = sqlExe.executeSQL();
            if (rs.size() > 0) {
                while (rs.next()) {
                    String convertedFormula = rs.getString("FOrgUnitId") + "_" + this.convertFormula(rs.getString("FFormula"), periods.length > 1);
                    dataMap.put(convertedFormula, rs.getBigDecimal("FBgValue"));
                }
            }
        }
        catch (SQLException ex) {
            this.handleException(ex);
        }
        return dataMap;
    }

    private void getFilterParam(BgRptFilterParam filterParam) throws Exception {
        this.companyVec = null;
        ICostCenterOrgUnit iCompany = CostCenterOrgUnitFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        Set companyIdSet = BgHelper.tranArray2Set(filterParam.getOrgUnitIds());
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("longNumber"));
        selector.add(new SelectorItemInfo("isLeaf"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("level"));
        selector.add(new SelectorItemInfo("parent"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.name"));
        selector.add(new SelectorItemInfo("parent.number"));
        selector.add(new SelectorItemInfo("isCU"));
        viewInfo.getSelector().addObjectCollection((IObjectCollection)selector);
        SorterItemCollection sorter = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo("longNumber");
        sortItemInfo.setSortType(SortType.ASCEND);
        sorter.add(sortItemInfo);
        viewInfo.getSorter().addObjectCollection((IObjectCollection)sorter);
        CostCenterOrgUnitCollection companyColl = iCompany.getCostCenterOrgUnitCollection(viewInfo);
        this.companyVec = BgHelper.tranColl2Vec((IObjectCollection)companyColl);
        this.companyMap = BgHelper.tranColl2Map((IObjectCollection)companyColl, new String[]{"id"});
        if (filterParam.isIsSum() && filterParam.getOrgUnitIds().length > 1) {
            this.parentCompanySet = new HashSet();
            CostCenterOrgUnitInfo orgUnitInfo = null;
            String parentCompanyId = null;
            for (int i = 0; i < companyColl.size(); ++i) {
                orgUnitInfo = companyColl.get(i);
                if (orgUnitInfo.getParent() == null || (parentCompanyId = orgUnitInfo.getParent().getId().toString()) == null || !companyIdSet.contains(parentCompanyId)) continue;
                this.parentCompanySet.add(parentCompanyId);
            }
            this.childCompanySet = BgHelper.tranArray2Set(filterParam.getOrgUnitIds());
            this.childCompanySet.removeAll(this.parentCompanySet);
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        BgClientHelper.exportTablesToExcel((Component)((Object)this), this.kdtabbed, false);
    }

    @Override
    public BgFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BgFormQueryFilterUI(BgAnalysisTypeEnum.BGFORMQUERY);
        }
        return this.filterUI;
    }

    @Override
    protected KDTable getMainTable() {
        return (KDTable)((KDPanel)this.kdtabbed.getSelectedComponent()).getComponent(0);
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        AttachmentUIContextInfo acmInfo = new AttachmentUIContextInfo();
        String id = null;
        KDTable table = this.getMainTable();
        if (table.getUserProperty("id") == null) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.ma.budget.BUDGETAutoGenerateResource", (String)"266_BgFormQueryMainUI"));
            SysUtil.abort();
        } else {
            id = table.getUserProperty("id").toString();
        }
        acmInfo.setBoID(id);
        acmInfo.setEdit(false);
        acm.showAttachmentListUIByBoID((Object)this, acmInfo);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("Owner", this);
        super.actionQuery_actionPerformed(e);
    }

    protected class FlexRender
    implements IBasicRender {
        private int TABSIZE = 8;
        private int ICONSIZE = 10;
        private int margin = 2;
        protected SimpleTextRender simpleRender = new SimpleTextRender();
        protected HashMap acctIdToPos = new HashMap();

        protected FlexRender() {
        }

        protected void drawExpanded(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
        }

        protected void drawCollapsed(Graphics g, int x, int y) {
            g.drawRect(x, y, this.ICONSIZE, this.ICONSIZE);
            int lineSize = this.ICONSIZE - 2 * this.margin;
            g.drawLine(x + this.margin, y + this.ICONSIZE / 2, x + this.margin + lineSize, y + this.ICONSIZE / 2);
            g.drawLine(x + this.ICONSIZE / 2, y + this.margin, x + this.ICONSIZE / 2, y + this.margin + lineSize);
        }

        protected void drawLeaf(Graphics g, int x, int y) {
            int lineSize = this.ICONSIZE - 2 * this.margin;
        }

        public boolean inRect(NumberExpandInfo numberExpandInfo, int x, int y) {
            String acctId = numberExpandInfo.getNumber();
            Rectangle rec = (Rectangle)this.acctIdToPos.get(acctId);
            if (rec != null) {
                return rec.getX() < (double)x && rec.getX() + rec.getWidth() > (double)x;
            }
            return false;
        }

        public void draw(Graphics graphics, Shape clip, Object obj, Style style) {
            if (obj instanceof NumberExpandInfo) {
                NumberExpandInfo numberExpandInfo = (NumberExpandInfo)obj;
                int ident = numberExpandInfo.getLevel() * this.TABSIZE;
                Rectangle rect = clip.getBounds();
                int x = rect.x + ident;
                int y = rect.y + (rect.height - this.ICONSIZE) / 2;
                Rectangle iconRect = new Rectangle(x, y, this.ICONSIZE, this.ICONSIZE);
                this.acctIdToPos.put(numberExpandInfo.getNumber(), iconRect);
                this.simpleRender.draw(graphics, (Shape)new Rectangle(x + this.ICONSIZE + this.TABSIZE, rect.y, rect.width - this.ICONSIZE - this.TABSIZE, rect.height), numberExpandInfo.toString(), style);
                this.paintIcon(graphics, numberExpandInfo, iconRect);
            } else if (obj != null) {
                this.simpleRender.draw(graphics, clip, obj.toString(), style);
            }
        }

        private void paintIcon(Graphics graphics, NumberExpandInfo numberExpandInfo, Rectangle iconRect) {
            if (numberExpandInfo.isLeaf()) {
                this.drawLeaf(graphics, iconRect.x, iconRect.y);
            } else if (numberExpandInfo.isExpandStatus()) {
                this.drawExpanded(graphics, iconRect.x, iconRect.y);
            } else if (!numberExpandInfo.isExpandStatus()) {
                this.drawCollapsed(graphics, iconRect.x, iconRect.y);
            }
        }
    }

    class NumberExpandInfo {
        private String id;
        private String name;
        private String number;
        private String longNumber;
        private boolean isExpandStatus;
        private int level;
        private boolean isLeaf;

        NumberExpandInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String toString() {
            return this.name;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public boolean isLeaf() {
            return this.isLeaf;
        }

        public void setLeaf(boolean isLeaf) {
            this.isLeaf = isLeaf;
        }

        public boolean isExpandStatus() {
            return this.isExpandStatus;
        }

        public void setExpandStatus(boolean isExpandStatus) {
            this.isExpandStatus = isExpandStatus;
        }
    }
}

